/* File     : Sun.pov
 *
 * Purpose  : haloed sun
 * Author   : (C) 1996 Matthew Hunter
 * Version  : 0.02 (25 June 1996)
 *            0.03 (27 June 1996)
 *              Release version.
 */

/* Input state
 *
 * sun_size - the radius of the sun. The sun will actually be 1.2 * sun_size
 * to allow the halo turbulence to extend beyond the base object. This will
 * only be important if you try and place the sun extremly close to the
 * camera
 *
 * sun_location - the final position of the sun.
 */

/* Output state
 *
 * The sun object will be added to the scene at the specified position
 * and size.
 *
 * No light source will be added, if you actually want the sun to produce
 * light then simply add a lightsource at sun_location. The sun halo has
 * the no shadow attribute set.
 */

object {
  sphere {
    <0,0,0> 1.2
  }
  pigment {
    color rgbt <1,1,1,1>
  }
  hollow
  no_shadow
  halo {
    emitting
    linear
    spherical_mapping
    turbulence 0.1
    max_value 1.0

    color_map {
      [0 color rgbt <1,1,1,1>]
      [0.3 color rgbt <1,0.7,0.3,0.5>]
      [0.7 color rgbt <1,1,0.7,0>]
      [1 color rgbt <1,1,0.7,0>]
    }
    samples 100
  }
  scale <sun_size,sun_size,sun_size>
  translate sun_location
}
