// DClock.pov

#include "colors.inc"

// La camera
/*camera
{
  location  <0.0, 20.0, -28>
  direction 2.0*z
  up        y
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}*/

camera
{
  location  <0.0, 30.0, 2>
  direction 1.0*y
  up        -z
  right     4/3*x
  look_at   <0.0, .8,  2.0>
}

// Le fond de l'image
sky_sphere
{
  pigment
  {
    bozo
    turbulence .5
    color_map { [0 .5 color rgb <0,.3,.6> color rgb <.1,.2,.4>]
      	        [.5 1 color rgb <.1,.2,.4> color rgb <0,.1,.2>] }
  }
}

// Une lumiere
light_source { <100,100,-100> color White }

#declare metal = finish { ambient .7
                          diffuse .3
                          phong 1
                          phong_size 200
                          reflection .6
                          specular 1
                          roughness .005
                          metallic
                          brilliance 10 }

#declare chiffres = union {
  object { text { ttf "c:\eric\font\pcrypt.ttf", "XII", 1, 0 }
           rotate 90*x
           scale <3,2,3>
           translate <-2.25,1.2,7> }
  object { text { ttf "c:\eric\font\pcrypt.ttf", "III", 1, 0 }
           rotate 90*x
           scale <3,2,3>
           translate <-1.5+7.2,1.2,-.75> }
  object { text { ttf "c:\eric\font\pcrypt.ttf", "VI", 1, 0 }
           rotate 90*x
           scale <3,2,3>
           translate <-1.8,1.2,-8.25> }
  object { text { ttf "c:\eric\font\pcrypt.ttf", "IX", 1, 0 }
           rotate 90*x
           scale <3,2,3>
           translate <-1.5-7,1.2,-.75> }
  pigment { color rgb <.2,.7,.1> }
  finish { metal } }

// Les chiffres romains
object { chiffres }

// Les billes pour indiquer les heures
object {
  union { sphere { <0,0,8>, .25
                   rotate 30*y }
          sphere { <0,0,8>, .25
                   rotate 60*y }
          sphere { <0,0,8>, .25
                   rotate 120*y }
          sphere { <0,0,8>, .25
                   rotate 150*y }
          sphere { <0,0,8>, .25
                   rotate 210*y }
          sphere { <0,0,8>, .25
                   rotate 240*y }
          sphere { <0,0,8>, .25
                   rotate 300*y }
          sphere { <0,0,8>, .25
                   rotate 330*y } }
  translate 1*y
  pigment { color rgb <.2,.7,.1> }
  finish { metal } }

// L'horloge 
object {
  superellipsoid { <1,.4> }
  rotate 90*x
  scale <10,1,10>
  pigment { color rgb <.05,.08,.05> }
  finish { metal } }

// Le centre
object { sphere { <0,1,0>, 1 }
	 pigment { color rgb <.05,.08,.05> }
	 finish { metal } }

// Les aiguilles
object { union { cone { <0,0,0>, .25, <0,0,7>, .15 }
                 sphere { <0,0,7>, .15 } }
         scale <1,.25,1>
         translate 1.25*y
         rotate -27*y
	 pigment { color rgb <.2,.7,.1> }
	 finish { metal } }

object { union { cone { <0,0,0>, .25, <0,0,5>, .15 }
                 sphere { <0,0,5>, .15 } }
         scale <1,.25,1>
         translate 1.25*y
         rotate -2*y
	 pigment { color rgb <.2,.7,.1> }
	 finish { metal } }


//Une chaine
#declare TexOr = texture {
    pigment { color Gold }
    finish { ambient .4
             diffuse .8
             reflection .6
             metallic
             specular 1
             roughness .001 }
    normal { ripples .9
             scale .2 } }


#declare Half_Torus = difference {
    torus { 4,1
      sturm
      rotate x*-90
    }
    box { <-5, -5, -1>, <5, 0, 1> }
  }

#declare Flip_It_Over = x*180

#declare Torus_Translate = 8


#declare Chain_Segment =
  cylinder { <0, 4, 0>, <0, -4, 0>, 1
             texture { TexOr } }


#declare Link = union {
 object { Half_Torus
          translate y*Torus_Translate/2 }
 object { Half_Torus
          rotate Flip_It_Over
          translate -y*Torus_Translate/2 }
 object { Chain_Segment
          translate x*Torus_Translate/2 }
 object { Chain_Segment
          translate -x*Torus_Translate/2 }
 texture { TexOr } }


#declare Link_Translate = Torus_Translate*2-2*y


#declare Link_Pair =
  union { object { Link }
          object { Link
                   translate y*Link_Translate
                   rotate y*90 } }


#declare Chain = union {
  object { Link_Pair}
  object { Link_Pair translate  y*Link_Translate*2 }
  object { Link_Pair translate  y*Link_Translate*4 }
  object { Link_Pair translate  y*Link_Translate*6 }
  object { Link_Pair translate  y*Link_Translate*8 }
  object { Link_Pair translate  y*Link_Translate*10 }
  object { Link_Pair translate  y*Link_Translate*12 }
  object { Link_Pair translate  y*Link_Translate*14 }
  object { Link_Pair translate  y*Link_Translate*16 }
  object { Link_Pair translate  y*Link_Translate*18 }
  object { Link_Pair translate  y*Link_Translate*20 }
  object { Link_Pair translate  y*Link_Translate*22 }
  object { Link_Pair translate -y*Link_Translate*2 }
  object { Link_Pair translate -y*Link_Translate*4 }
  object { Link_Pair translate -y*Link_Translate*6 } }

object { Chain
         translate 6*y
         scale .05
         translate y
         rotate 25*y
         rotate 90*x }
