                        //Sketch for IRTC 'Time' by JHSP
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare QuickTex=texture{pigment{color rgb<1,1,1>}finish{specular .5 roughness .07}}
#declare QuickTex2=texture{pigment{color rgb<1,.4,.4>} finish{Shiny}}
#declare ClearPlastic=texture{pigment{color rgbt<1,1,1,.55>} finish{Shiny}}
// Atmosphere with Mie scattering, murky atmosphere (dependent on incident light).
#declare Atmosphere=0
#declare Torches=2
#if (Atmosphere=1)
// texture component

atmosphere
{
  type 1             // Mie scattering
  eccentricity 0
  samples 10        // Number of samples in first distance interval
  distance 10       // Atmosphere density, similar to fog
  scattering .021    // Reflectivity of atmosphere, determines brightness
  aa_level 2        // Level of binary subdivision in case of aa
  aa_threshold 1 // Threshold for aa to push in
  jitter 0.2        // Amount of sample jittering
  color rgbt<1,1,1,1>
}

#end
global_settings { assumed_gamma 1.0 }
// set viewer's position in the scene
camera
{
  location  <0,0,0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0,0,1.0> // point center of view at this point <X Y Z>
  angle 40               // overrides "direction" with specific angle
rotate <5,0,0>
translate <1.15,1.25,-5.1>
}
// create a regular point light source

#declare TorchLight=light_source
{
  0*x // light's position (translated below)
  color red .5  green .5  blue .4  // light's color
  translate <0,0,0> atmospheric_attenuation 0 fade_distance 2.5 fade_power 2
}

#declare CandleLight=
light_source{
  0*x // light's position (translated below)
  color rgb<.453,.453,.4>  // light's color
  fade_distance 1.9 fade_power 2

}




light_source //THE SUN
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  //area_light
 // <-.07, 0, -.07> <.05, 0, .05> // lights spread out across this distance (x * z)
 // 3, 3                // total number of lights in grid (4x*4z = 16 lights)
  //adaptive 0          // 0,1,2,3...
  //jitter              // adds random softening of light
  translate <0,9.6,-1.5>   // <x y z> position of light
 // translate <0,3.5,-1.5>   // <x y z> position of light
}
//***************************************************************************
#declare Halfwidth=3.15
#declare Roofheight=3.7

#include "skobj.inc" //THIS CONTAINS ALL (WELL, MOST) OF THE OBJECTS IN THE SCENE


#declare BackWall=union{difference{
				union{
                             box{<-Halfwidth,-1,0><Halfwidth,Roofheight,.7>
                             texture{BackWallTex}
                             }
				object{Torch translate<-1.5,3,0>}
				object{Torch translate<.5,3,0>}
		                              		}//end union
                             object{DoorwayCutter translate<(Halfwidth-.55),2.3,0>}

                             }
			//**************DOOR CUT OUT, NOW DO STEPS***********
			object{Ladder translate<(Halfwidth-.55),1.9,0>}
                        object{Door translate<(Halfwidth-.55),2.3,0>}
		translate z*Halfwidth
		}
#declare Floor2=box{<-12,-1,-12>,<12,0,12>
                       texture{FloorTex}
                     }

#declare Floor=union{difference{
                          object{Floor2}
                          object{DrainSpace}

                          }

                     object{Drain translate y*-.06}
                     object{Puddles}
                    }
#declare Roof=union{
                        difference{
                         box{<-12,Roofheight,-12>,<12,Roofheight+.25,12>}
                         object{BarsCutter}
                             texture{QuickTex}
                         }
                         object{Bars translate y*Roofheight+.175}
                    }
#declare LeftWall=box {<-.7,-1,-Halfwidth><0,Roofheight,Halfwidth>
                      texture{BackWallTex rotate y*90}
                      translate x*-Halfwidth
                      }

#declare RightWall=union{
			box {<0,-1,-Halfwidth><.7,Roofheight,Halfwidth>
                      texture{RightWallTex rotate y*90}
			}
			object{Torch rotate y*90 translate<0,3,-1>}
			object{Torch rotate y*90 translate<0,3,1>}
                        object{Piping translate y*.3}
                      translate x*Halfwidth
                      }


#declare Room= union{
               object{Floor}
               object{RightWall}
               object{LeftWall}
               object{BackWall}
               object{Roof}
               object{FoodScene rotate y*14 translate<1.5,0,-2> }

               }

           object{Room}
                    object{Bed rotate y*80 translate <1,0,1.75>  }
