#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare Watch=union{

torus //outer metal ring
{6,0.5 texture {pigment {P_Brass4}
finish {F_MetalD ambient 0.5}}
rotate x*90}

#declare R=0.8 //gray scale
disc{<0,0,0>z,6 texture{
pigment {rgb <R,R,R>}
finish {ambient 0.3}
}}

//------
//Digits
//------
#declare T1=texture {pigment{Black}}
#declare S1=1.5  //Scaling Digits
#declare B=0.01 //Thickness Digits

text {ttf "uhr.ttf","12",B, <0,0,0> texture {T1} scale S1
translate <-0.7,4,0>}

text {ttf "uhr.ttf","1",B, <0,0,0> texture {T1} scale S1
rotate z*40 translate <-0.6,4,0> rotate z*-40}

text {ttf "uhr.ttf","2",B, <0,0,0> texture {T1} scale S1
rotate z*70 translate <-0.6,4,0> rotate z*-70}

text {ttf "uhr.ttf","3",B, <0,0,0> texture {T1} scale S1
translate <4,-0.4,0>}

text {ttf "uhr.ttf","4",B, <0,0,0> texture {T1} scale S1
rotate z*32 translate <4.5,-0.6,0> rotate z*-32}

text {ttf "uhr.ttf","5",B, <0,0,0> texture {T1} scale S1
rotate z*62 translate <4.9,-0.5,0> rotate z*-62}

text {ttf "uhr.ttf","6",B, <0,0,0> texture {T1} scale S1
translate <-0.3,-5.0,0>}

text {ttf "uhr.ttf","7",B, <0,0,0> texture {T1} scale S1
rotate z*25 translate <-0.5,-5,0> rotate z*-25}

text {ttf "uhr.ttf","8",B, <0,0,0> texture {T1} scale S1
rotate z*50 translate <-0.5,-5,0> rotate z*-50}

text {ttf "uhr.ttf","9",B, <0,0,0> texture {T1} scale S1
translate <-4.8,-0.4,0>}

        text {ttf "uhr.ttf","10",B, <0,0,0> texture {T1} scale S1
rotate z*31 translate <-4.7,-0.6,0> rotate z*-31}

text {ttf "uhr.ttf","11",B, <0,0,0> texture {T1} scale S1
rotate z*58 translate <-4.4,-0.6,0> rotate z*-58}


//Marks

#declare Count = 0
#while (Count < 360)
box{<-0.05,-0.1,-B>,<0.05,0.1,B>
pigment {Black}
translate y*5.3
rotate z*-Count}
#declare Count = Count+10
#end

#declare Count = 0
#while (Count < 360)
box{<-0.05,-0.2,-B>,<0.05,0.2,B>
pigment {Black}
translate y*5.3
rotate z*-Count}
#declare Count = Count+30
#end


//Grosser Zeiger
#declare Dist=0.2 //Zeiger Abstand
#declare Thick=0.001 // Dicke Zeiger
#declare Di=0.05
#declare Beule=0.1
        
#declare GZ=prism {linear_sweep
Dist-Thick,Dist,12,
<Di,0>,<Di,1>,<Di,2>,<Beule,3.5>,<Beule/2,4>,<0,4.5>,
<-Beule/2,4>,<-Beule,3.5>,<-Di,2>,<-Di,1>,<-Di,0>,<Di,0>
rotate <-90,0,30>               }

//Kleiner Zeiger
#declare K=0.95
#declare Beule=0.2
#declare KZ=prism {linear_spline
Dist-Thick,Dist,12,
<Di,0>,<Di,1-K>,<Di,2-K>,<Beule,3.5-K>,<Beule/2,4-K>,<0,4.5-K>,
<-Beule/2,4-K>,<-Beule,3.5-K>,<-Di,2-K>,<-Di,1-K>,<-Di,0>,<Di,0>
//translate y*0.1
rotate <-90,0,130>}

object {GZ pigment {Black}}
object {KZ pigment {Black}}

object {GZ pigment {Black}translate z*2*Dist}
object {KZ pigment {Black}translate z*2*Dist}

#declare It=torus {0.3,0.1
pigment{Black}
rotate x*90}

object {It translate z*-Dist}
object {It translate z*Dist}

#declare Screw=torus {0.1,0.1 texture {pigment {P_Brass4}
finish {F_MetalD ambient 0.5}}
rotate x*90}
object {Screw translate z*-Dist}
object {Screw translate z*Dist}


//Aufzieher
sphere {<0,0,0>,1
        texture {pigment {P_Brass4}
finish {F_MetalD ambient 0.5}
        normal {gradient x bump_size 2 scale 0.2}}
scale <1,0.6,1>
translate y*7
}

} // End Union Object Watch

#ifdef (Datei)
#declare Feld=
intersection{
height_field
{gif Datei}
box {<0,0.475,0>,<1,0.525,1>}
scale <4,1,3>
rotate x*-90
translate <-2,-1.5,0>}
#end
