#declare My_wall = texture {
	pigment {
		brick
		pigment {color rgb <0.6, 0.6, 0.58>}, pigment {color rgb <0.7, 0.7, 0.68>}
		brick_size <1, 0.7, 0.8>
		mortar 0.05
	}
	normal {
		brick
		normal {bumps 0.2 scale 0.01}, normal {granite 0.04 scale 0.01}
		brick_size <1, 0.7, 0.8>
		mortar 0.065
	}
	finish {ambient 0.12 diffuse 0.8 phong 0.1 phong_size 85}
	scale 0.04
}

#declare My_gr = texture {
	pigment {color rgb 0.8}
	normal {granite 0.04 scale 0.01}
	finish {ambient 0.12 diffuse 0.8 phong 0.1 phong_size 85}
}

#declare My_metal = texture {
	pigment {color rgb <0.3, 0.4, 0.38>}
	finish {metallic ambient 0.12 diffuse 0.8 phong 0.1}
}

sky_sphere {
	pigment {
		granite
		color_map {
			[0.0 0.85 color rgb <0, 0, 0.25> color rgb <0, 0, 0.21>]
			[0.85 1.0 color rgb 5 color rgb 5]
		}
		scale 0.018
	}
	pigment {
		gradient y
		color_map {
		[0.0 0.2 color rgb <0.1, 0.15, 0.45> color rgb <0, 0, 0.21>]
		[0.2 0.3 color rgb <0, 0, 0.21> color rgbf <0, 0, 0.21, 1>]
		[0.3 1.0 color rgbf 1 color rgbf 1]
		}
	}
}

#declare River = plane {
	y, -0.205
	pigment {color rgb <0.11, 0.13, 0.18>}
	normal {
		bozo
		normal_map {
		[0.6 bumps 0.014 scale <0.05, 1, 0.04>]
		[0.7 bumps 0.01 scale <0.05, 1, 0.04>]
		[1 bumps 0.005 scale <0.05, 1, 0.04>]
		}
		scale <0.4, 0.25, 0.25>
	}
	finish {ambient 0.1 diffuse 0.8 phong 1
		reflection 0.65
	}
}

#declare Street_light = light_source {
	0
	color rgb <0.7, 0.65, 0.55>
	fade_distance 0.52
	fade_power 2
}

// Left_bank_lights
object {Street_light translate <-1.5, 0.02, 0>}
object {Street_light translate <-1.5, 0.02, 1>}
object {Street_light translate <-1.5, 0.02, 2>}

// Right_bank_lights
object {Street_light translate <0.9, 0.13, 0>}
object {Street_light translate <0.9, 0.13, 1>}
object {Street_light translate <0.9, 0.13, 2>}

#declare Light_bulb = light_source {
	0 color rgb <0.75, 0.8, 0.85>
	area_light z, x, 3, 3
	looks_like {
		sphere {
			0, 0.1
			scale <1, 2, 1>
			pigment {color rgb <0.9, 0.94, 1>}
			finish {ambient 1 diffuse 1 phong 0.1}
		}
	}
	fade_distance 0.12
	fade_power 2
}

#declare Light = union {
	intersection {			// glass
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*0}
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*60}
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*120}
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*180}
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*240}
		plane {z, 0 rotate x*15 translate z*0.2 rotate y*300}

		clipped_by {plane {y, -0.2 inverse}}
		clipped_by {plane {y, 0.4}}

		pigment {color rgbf <0.9, 0.94, 1, 0.8>}
		finish {ambient 0.1 diffuse 0.85 phong 1}
	}
	intersection {			// top
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*0}
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*60}
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*120}
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*180}
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*240}
		plane {z, 0 rotate -x*60 translate z*0.35 rotate y*300}

		clipped_by {plane {-y, 0}}
		translate y*0.4
		texture {My_metal}
	}
	difference {			// sticks
		union {
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*30}
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*90}
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*150}
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*210}
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*270}
			cylinder {<0, -0.3, 0>, <0, 0.6, 0>, 0.02 scale <1, 1, 0.5> rotate x*17.5 translate z*0.23 rotate y*330}
		}
		plane {y, -0.2}
		plane {y, 0.4 inverse}
		texture {My_metal}
	}
	union {					// top-top
		sphere {0, 0.06 scale <1, 0.5, 1>}
		sphere {0, 0.05 scale <0.6, 1, 0.6> translate y*0.07}
		translate y*0.6
		texture {My_metal}
	}
	union {					// bottom
		cylinder {0, <0, -0.02, 0>, 0.2}
		cylinder {<0, -0.02>, <0, -0.1, 0>, 0.15}
		sphere {<0, -0.14, 0 >, 0.08}

		translate -y*0.2
		texture {My_metal}
	}
}

#declare Rings = union {
	difference {
		cylinder {0, <0, 0, 0.01>, 0.06}
		cylinder {<0, 0, -0.1>, <0, 0, 0.2>, 0.04}
	}
	difference {
		cylinder {0, <0, 0, 0.01>, 0.03}
		cylinder {<0, 0, -0.1>, <0, 0, 0.2>, 0.015}
		translate -y*0.085
	}
}

#declare Support = union {
	cylinder {0, <0, 0, -0.35>, 0.006}
	cylinder {0, <0, 0, 0.01>, 0.04}
	difference {
		cylinder {0, <0, 0, 0.01>, 0.11}
		cylinder {<0, 0, -0.1>, <0, 0, 0.2>, 0.08}
		scale <0.5, 1, 1>
	}
	object {Rings translate -y*0.15}
	object {Rings rotate z*180 translate y*0.15}
	object {Rings rotate -z*90 translate -x*0.05}
	object {Rings rotate z*90 translate x*0.05}
	intersection {
		torus {0.2, 0.006 rotate z*90 translate <0, 0.2, -0.19>}
		box {<-0.1, 0, -0.2>, <0.1, 0.2, 0.1>}
		rotate z*180
	}

	translate -z*0.01
	texture {My_metal}
}

#declare Light1 = union {
	object {Support}
	union {
		object {Light}
		object {Light_bulb}

		scale 0.25
		rotate y*30
		translate <0, -0.6/4, -0.35>
	}
}

#declare Lights_low = union {
	object {Light1 rotate -y*90 scale 0.1 translate <-1.1, -0.04, 0>}
	object {Light1 rotate -y*90 scale 0.1 translate <-1, -0.01, 0.5>}
	object {Light1 rotate -y*90 scale 0.1 translate <-1.1, -0.04, 1>}
}

#declare Stairway = union {
	difference {			// side
		prism {
			linear_sweep
			linear_spline
			0, 0.01, 11,
			<-0.35, 0>, <-0.35, 0.05>, <-0.25, 0.15>, <-0.15, 0.15>, <-0.05, 0.25>,
			<0.05, 0.25>, <0.15, 0.15>, <0.25, 0.15>, <0.35, 0.05>, <0.35, 0>,
			<-0.35, 0>
		}
		cylinder {<0, -1, 0>, <0, 1, 0>, 0.15}

		translate -y*0.01
		rotate -x*90
		texture {My_wall rotate -y*90}
	}
	difference {		// arch
		cylinder {<0, -0.01, 0>, <0, 0.4, 0>, 0.16}
		cylinder {<0, -1, 0>, <0, 1, 0>, 0.14}
		plane {z, 0}

		translate -y*0.4
		rotate -x*90
		texture {My_gr}
	}
	prism {        		// hand
		linear_sweep
		linear_spline
		0, 0.012, 17,
		<-0.35, 0.05>, <-0.25, 0.15>, <-0.15, 0.15>, <-0.05, 0.25>,
		<0.05, 0.25>, <0.15, 0.15>, <0.25, 0.15>, <0.35, 0.05>,
		<0.36, 0.06>, <0.26, 0.16>, <0.16, 0.16>, <0.06, 0.26>,
		<-0.06, 0.26>, <-0.16, 0.16>, <-0.26, 0.16>, <-0.36, 0.06>,
		<-0.35, 0.05>

		translate -y*0.011
		rotate -x*90
		texture {My_gr}
	}
	difference {			// steps
		prism {
			linear_sweep
			linear_spline
			0, 0.1, 45,
			<-0.35, 0.00>, <-0.35, 0.01>,
			<-0.34, 0.01>, <-0.34, 0.02>,
			<-0.33, 0.02>, <-0.33, 0.03>,
			<-0.32, 0.03>, <-0.32, 0.04>,
			<-0.31, 0.04>, <-0.31, 0.05>,
			<-0.30, 0.05>, <-0.30, 0.06>,
			<-0.29, 0.06>, <-0.29, 0.07>,
			<-0.28, 0.07>, <-0.28, 0.08>,
			<-0.27, 0.08>, <-0.27, 0.09>,
			<-0.26, 0.09>, <-0.26, 0.10>,

			<-0.15, 0.10>, <-0.15, 0.11>,
			<-0.14, 0.11>, <-0.14, 0.12>,
			<-0.13, 0.12>, <-0.13, 0.13>,
			<-0.12, 0.13>, <-0.12, 0.14>,
			<-0.11, 0.14>, <-0.11, 0.15>,
			<-0.10, 0.15>, <-0.10, 0.16>,
			<-0.09, 0.16>, <-0.09, 0.17>,
			<-0.08, 0.17>, <-0.08, 0.18>,
			<-0.07, 0.18>, <-0.07, 0.19>,
			<-0.06, 0.19>, <-0.06, 0.20>,

			<0.05, 0.2>, <0.15, 0.1>, <0.25, 0.1>, <0.35, 0>, <-0.35, 0.00>
		}
		cylinder {<0, -1, 0>, <0, 1, 0>, 0.11}

		translate -y*0.1
		rotate -x*90
		translate z*0.005
		texture {My_gr}
	}
}

#declare Ring = difference {
	cylinder {<0, 0, -0.007>, <0, 0, 0.007>, 0.1}
	cylinder {<0, 0, -0.1>, <0, 0, 0.1>, 0.09}
}

#declare Section = union {
	box {<-0.1, 0, -0.1>, <0.1, 0.02, 0.1>}
	box {<-0.08, 0.02, -0.08>, <0.08, 0.04, 0.08>}

	box {<-0.06, 0.04, -0.06>, <0.06, 0.4, 0.06>}

	box {<-0.07, 0.4, -0.07>, <0.07, 0.42, 0.07>}
	box {<-0.08, 0.42, -0.08>, <0.08, 0.43, 0.08>}
	box {<-0.07, 0.43, -0.07>, <0.07, 0.44, 0.07>}
	sphere {<0, 0.44+0.05, 0>, 0.05}

	union {			// grid
		box {<0, -0.015, -0.007>, <-0.9, 0, 0.007> translate y*(0.225-0.1)}
		box {<0, -0.015, -0.007>, <-0.9, 0, 0.007> translate y*(0.225+0.1+0.015)}
		box {<0, -0.015, -0.007>, <-0.9, 0, 0.007> translate y*(0.225-0.1-0.03)}
		box {<0, -0.015, -0.007>, <-0.9, 0, 0.007> translate y*(0.225+0.1+0.015+0.03)}

		object {Ring translate <-0.1, 0.225, 0>}
		object {Ring translate <-0.2, 0.225, 0>}
		object {Ring translate <-0.3, 0.225, 0>}
		object {Ring translate <-0.4, 0.225, 0>}
		object {Ring translate <-0.5, 0.225, 0>}
		object {Ring translate <-0.6, 0.225, 0>}
		object {Ring translate <-0.7, 0.225, 0>}
		object {Ring translate <-0.8, 0.225, 0>}

		translate -x*0.06
		texture {My_metal}
	}
	texture {My_gr}
}

#declare Left_bank = union {
	difference {
		box {<-6, -1, -6>, 0 translate <-0.95, 0, 3>}
		intersection {
			plane {-y, 0 texture {My_wall scale 0.25 rotate x*90}}
			plane {-x, 0}
			translate <-1.1, -0.2, 0>
		}
	}
	object {Stairway rotate -y*90 translate <-1, -0.2, 0.5>}
	box {	// border low
		<-0.96, -0.21, -1>, <-0.94, -0.19, 3>
		texture {My_gr}
	}
	box {	// border high
		<-1.11, -0.005, -1>, <-1.09, 0, 3>
		texture {My_gr}
	}

	#declare Cycle = 0
	#while (Cycle < 7)
		object {
			Section
			scale 0.12
			rotate -y*90
			translate <-1.12, 0, 0.5-Cycle*((0.9+0.06)*0.12)>
		}
		#declare Cycle = Cycle + 1
	#end

	#declare Cycle = 0
	#while (Cycle < 17)
		object {
			Section
			scale 0.12
			rotate y*90
			translate <-1.12, 0, 0.6+Cycle*((0.9+0.06)*0.12)>
		}
		#declare Cycle = Cycle + 1
	#end

	object {Lights_low}

	union {			// bench
		box {0, <0.04, 0.025, 0.1>}
		box {<0, 0.025, -0.02>, <0.045, 0.03, 0.105>}

		translate <-1.1, -0.2, -0.12>
		texture {My_gr}
	}
	texture {My_wall rotate -y*90}
}

#declare Piece = union {
	box {<-0.3, -0.1, -0.02>, <0, 0, 0.02> rotate z*70 texture {My_wall}}
	box {<-0.3, -0.01, -0.022>, <0, 0.001, 0.022> rotate z*70 texture {My_gr}}
}

#declare Right_bank = union {
	box {<0.6, -1, -6>, <6, 0.1, 3> texture {My_wall rotate y*90}}
	box {	// border high
		<0.59, 0.1-0.005, -1>, <0.61, 0.1, 3>
		texture {My_gr}
	}

	#declare Cycle = 0
	#while (Cycle < 17)
		object {
			Section
			scale 0.12
			rotate -y*90
			translate <0.62, 0.1, 2.7-Cycle*((0.9+0.06)*0.12)>
		}
		#declare Cycle = Cycle + 1
	#end

	object {Piece translate <0.6, 0.01, 2.5>}
	object {Piece translate <0.6, 0.01, 2.0>}
	object {Piece translate <0.6, 0.01, 1.5>}
	object {Piece translate <0.6, 0.01, 1.0>}
	object {Piece translate <0.6, 0.01, 0.5>}
}

#declare Front_bank = union {
	box {<-8, -1, 4>, <8, 0.05, 5>}
	box {<-8, 0.05, 3.9>, <8, 0.08, 4.05> texture {My_gr}}

	texture {My_wall}
}

