#declare Bld2_wall = texture {
	pigment {color rgb <0.7, 0.5, 0.4>}
	finish {ambient 0.12 diffuse 0.85 phong 0.1 phong_size 60}
}

#declare Bld2_gr = texture {
	pigment {color rgb <0.9, 0.7, 0.6>}
	finish {ambient 0.12 diffuse 0.8 phong 0.01 phong_size 85}
}

#declare Light_wind = texture {
	pigment {color rgb <1, 0.8, 0.7>}
	finish {ambient 0.9 diffuse 0.6}
}

#declare Frame_txt2 = texture {
	pigment {color rgb <0.2, 0, 0.02>}
	finish {ambient 0.12 diffuse 0.8 phong 0.4}
}

#declare Frame = union {
	// vert.
	box {<0.1, 0.05, 0.01>, <0.11, 0.2, 0.02>}
	box {<0.1, 0.05, 0.01>, <0.11, 0.245, 0.02> translate x*0.045}
	box {<0.1, 0.05, 0.01>, <0.11, 0.2, 0.02> translate x*0.09}
	// hor.
	box {<0.1, 0.05, 0.01>, <0.2, 0.06, 0.02>}
	box {<0.1, 0.05, 0.01>, <0.2, 0.06, 0.02> translate y*0.045}
	box {<0.1, 0.05, 0.01>, <0.2, 0.06, 0.02> translate y*0.045*2}
	box {<0.1, 0.05, 0.01>, <0.2, 0.06, 0.02> translate y*0.14}
	// arch
	difference {
		cylinder {<0.15, 0.195, 0.01>, <0.15, 0.195, 0.02>, 0.05}
		cylinder {<0.15, 0.195, -0.1>, <0.15, 0.195, 0.2>, 0.04}
	}
	// light
	union {
		box {<0.105, 0.055, 0.015>, <0.195, 0.195, 0.02>}
		cylinder {<0.15, 0.195, 0.015>, <0.15, 0.195, 0.2>, 0.045}
		texture {Light_wind}
	}
	texture {Frame_txt2}
}

#declare Windows_1 = union {
	object {Frame}
	object {Frame translate x*0.09}
	object {Frame translate x*0.18}
	sphere {
		<0.25, 0.15, 0>, 0.2
		clipped_by {plane {y, 0.25 inverse}}
		scale <1, 1, 0.6>
		translate <-0.01, 0, 0.02>

		pigment {color rgb <0.5, 0, 0.05>}
		finish {ambient 0.12 diffuse 0.8 phong 0.8}
	}
	translate x*0.01
}

#declare Windows_2 = union {
	box {<0.02, 0.4999, 0.01>, <0.66, 0.508, 0.02>}
	#declare Cycle = 0
	#while (Cycle < 26)
		cylinder {<0.05, 0.4, 0.015>, <0.05, 0.4999, 0.015>, 0.004 translate <Cycle*0.025, 0, 0>}
		#declare Cycle = Cycle + 1
	#end
	// windows
	union {
		difference {		// door
			box {<0.1, 0.4, 0.09>, <0.2, 0.65, 0.1>}
			box {<0.11, 0.5, -0.1>, <0.145, 0.64, 0.2>}
			box {<0.11, 0.5, -0.1>, <0.145, 0.64, 0.2> translate x*0.045}
		}
		// light
		box {<0.105, 0.45, 0.095>, <0.195, 0.645, 0.1> texture {Light_wind}}
		difference {
			box {<0.35, 0.5, 0.09>, <0.45, 0.65, 0.1>}
			box {<0.36, 0.51, -0.1>, <0.395, 0.64, 0.2>}
			box {<0.36, 0.51, -0.1>, <0.395, 0.64, 0.2> translate x*0.045}
		}
		// light
		box {<0.355, 0.505, 0.095>, <0.435, 0.645, 0.1> texture {Light_wind}}
		difference {
			box {<0.35, 0.5, 0.09>, <0.45, 0.65, 0.1>}
			box {<0.36, 0.51, -0.1>, <0.395, 0.64, 0.2>}
			box {<0.36, 0.51, -0.1>, <0.395, 0.64, 0.2> translate x*0.045}
			translate x*0.15
		}
		// light
		box {<0.355, 0.505, 0.095>, <0.435, 0.645, 0.1> texture {Light_wind}
			translate x*0.15
		}
		texture {Frame_txt2}
	}
	texture {My_metal}
}

#declare Sep = union {
	box {<-0.01, 0.37, -0.01>, <3, 0.38, 2>}
	box {<-0.02, 0.38, -0.01>, <3, 0.39, 2>}
	box {<-0.01, 0.39, -0.01>, <3, 0.4, 2>}
	texture {Bld2_gr}
}

#declare Cap = union {
	box {<-0.01, 0, -0.005>, <0.06, 0.01, 0.055>}
	box {<-0.015, 0.01, -0.01>, <0.065, 0.02, 0.06>}
	box {<-0.01, 0.02, -0.005>, <0.06, 0.03, 0.055>}
	texture {Bld2_gr}
}

#declare For_cut_1 = merge {
	cylinder {<0.25, 0.15, -0.1>, <0.25, 0.15, 0.02>, 0.2}
	box {<0.05, -0.1, -0.1>, <0.45, 0.15, 0.02>}
}

#declare For_cut_2 = union {
	merge {
		cylinder {<0.15, 0.6, -0.1>, <0.15, 0.6, 0.1>, 0.1}
		box {<0.05, 0.4, -0.1>, <0.25, 0.6, 0.1>}
	}
	merge {
		cylinder {<0.15, 0.6, -0.1>, <0.15, 0.6, 0.1>, 0.1 translate x*0.25}
		box {<0.3, 0.4, -0.1>, <0.65, 0.6, 0.1>}
		cylinder {<0.15, 0.6, -0.1>, <0.15, 0.6, 0.1>, 0.1 translate x*0.4}
	}
	box {<0.03, 0.3999, 0.05>, <0.66, 0.72, 0.1001>}
}

#declare Bld2 = union {
	difference {
		box {0, <3, 1.45, 2>}	// main block
		// 1st floor
		object {For_cut_1 translate x*0.45*0}
		object {For_cut_1 translate x*0.45*1}
		object {For_cut_1 translate x*0.45*2}
		// 2nd floor
		object {For_cut_2 translate x*0.65*0}
		object {For_cut_2 translate x*0.65*1}
		// 3rd floor
		object {For_cut_2 translate <0.65*0, 0.35*1, 0>}
		object {For_cut_2 translate <0.65*1, 0.35*1, 0>}
		// 4th floor
		object {For_cut_2 translate <0.65*0, 0.35*2, 0>}
		object {For_cut_2 translate <0.65*1, 0.35*2, 0>}
	}

	// caps 1st floor
	object {Cap translate <0.45*0, 0.13, 0>}
	object {Cap translate <0.45*1, 0.13, 0>}
	object {Cap translate <0.45*2, 0.13, 0>}
	object {Cap translate <0.45*3, 0.13, 0>}

	// caps 2nd floor
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
	}
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
		translate x*0.65
	}
	// caps 3rd floor
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
		translate y*0.35
	}
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
		translate <0.65, 0.35, 0>
	}
	// caps 4th floor
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
		translate y*0.35*2
	}
	union {
		object {Cap translate <0.25*0, 0.58, 0>}
		object {Cap translate <0.25*1, 0.58, 0>}
		translate <0.65, 0.35*2, 0>
	}
	object {Sep}
	object {Sep translate y*0.35}
	object {Sep translate y*0.35*2}
	// front.
	union {
		box {<-0.01, 1.45, -0.01>, <3, 1.46, 2>}
		box {<-0.02, 1.46, -0.02>, <3, 1.5, 2>}
		texture {Bld2_gr}
	}
	// windows 1
	object {Windows_1}
	object {Windows_1 translate x*0.45}
	object {Windows_1 translate x*0.45*2}

	// windows 2
	object {Windows_2 translate x*0}
	object {Windows_2 translate x*0.65}
	// windows 3
	object {Windows_2 translate <0, 0.35, 0>}
	object {Windows_2 translate <0.65, 0.35, 0>}
	// windows 4
	object {Windows_2 translate <0, 0.7, 0>}
	object {Windows_2 translate <0.65, 0.7, 0>}

	// roof
	difference {
		plane {-z, 0 rotate x*(degrees(acos(3/sqrt(13))))}
		plane {y, 0}
		plane {y, 0.3 inverse}
		plane {x, 3 inverse}
		plane {z, 2 inverse}
		plane {x, 0 rotate -z*(degrees(acos(3/sqrt(13))))}
		translate <-0.1, 1.5, -0.1>
		texture {Frame_txt2}
	}

	texture {Bld2_wall}
}