#declare Color1 = color rgb <1, 0.5, 0.5>
#declare Color2 = color rgb <0.9, 0.4, 0.4>
#declare Color3 = color rgb <0.5, 0.1, 0.1>

#declare Train_txt = texture {
	pigment {color Color1}
	finish {ambient 0.15 diffuse 0.8 phong 0.25 phong_size 50}
}
texture {
	pigment {
		gradient x
		color_map {
		[0.0 0.1 color rgbf 1 color rgbf 1]
		[0.1 0.21 color Color2 color Color2]
		[0.21 0.45 color rgbf 1 color rgbf 1]
		[0.45 0.56 color Color2 color Color2]
		[0.56 0.8 color rgbf 1 color rgbf 1]
		[0.8 0.91 color Color2 color Color2]
		[0.91 1 color rgbf 1 color rgbf 1]
		}
	}
	finish {ambient 0.15 diffuse 0.8 phong 0.25 phong_size 50}
	scale 1.2
}
texture {
	pigment {
		gradient y
		color_map {
		[0 0.11 color Color3 color Color3]
		[0.11 0.32 color rgbf 1 color rgbf 1]
		[0.32 1 color rgb 0.3 color rgb 0.3]
		}
	}
	finish {ambient 0.15 diffuse 0.8 phong 0.25 phong_size 50}
}

#declare Train_light = difference {
	sphere {0, 0.015}
	plane {-y, 0}
	scale <1, 0.5, 1>

	pigment {color rgb <1, 0.98, 0.95>}
	finish {ambient 0.8 diffuse 0.8 phong 1}
}

#declare Light_raw = union {
	object {Train_light translate <0.1, 0.34, -0.07>}
	object {Train_light translate <0.3, 0.34, -0.07>}
	object {Train_light translate <0.5, 0.34, -0.07>}
	object {Train_light translate <0.7, 0.34, -0.07>}
	object {Train_light translate <0.9, 0.34, -0.07>}
	object {Train_light translate <1.1, 0.34, -0.07>}
}

#declare Vent = merge {
	merge {
		cylinder {<-0.05, 0.35, -0.05>, <-0.05, 0.35, 0.05>, 0.01}
		sphere {<-0.05, 0.35, -0.05>, 0.01}
		sphere {<-0.05, 0.35, 0.05>, 0.01}
	}
	merge {
		cylinder {<0.05, 0.35, -0.05>, <0.05, 0.35, 0.05>, 0.01}
		sphere {<0.05, 0.35, -0.05>, 0.01}
		sphere {<0.05, 0.35, 0.05>, 0.01}
	}
	cylinder {<-0.05, 0.35, -0.05>, <0.05, 0.35, -0.05>, 0.01}
	cylinder {<-0.05, 0.35, 0.05>, <0.05, 0.35, 0.05>, 0.01}
	box {<-0.05, 0.34, -0.05>, <0.05, 0.36, 0.05>}
}

#declare Base = merge {
	merge {		// front side
		cylinder {<0.05, 0.1, -0.15>, <0.05, 0.3, -0.15>, 0.05}
		cylinder {<0.05, 0.3, -0.15>, <1.15, 0.3, -0.15>, 0.05}
		cylinder {<1.15, 0.1, -0.15>, <1.15, 0.3, -0.15>, 0.05}
		sphere {<0.05, 0.3, -0.15>, 0.05}
		sphere {<1.15, 0.3, -0.15>, 0.05}
		box {<0.05, 0.1, -0.2>, <1.15, 0.3, -0.1>}
	}
	merge {		// back side
		cylinder {<0.05, 0.1, -0.15>, <0.05, 0.3, -0.15>, 0.05}
		cylinder {<0.05, 0.3, -0.15>, <1.15, 0.3, -0.15>, 0.05}
		cylinder {<1.15, 0.1, -0.15>, <1.15, 0.3, -0.15>, 0.05}
		sphere {<0.05, 0.3, -0.15>, 0.05}
		sphere {<1.15, 0.3, -0.15>, 0.05}
		box {<0.05, 0.1, -0.2>, <1.15, 0.3, -0.1>}
		translate z*0.3
	}
	merge {		// top
		box {<0.05, 0.3, -0.15>, <1.15, 0.35, 0.15>	}
		cylinder {<0.05, 0.3, -0.15>, <0.05, 0.3, 0.15>, 0.05}
		cylinder {<1.15, 0.3, -0.15>, <1.15, 0.3, 0.15>, 0.05}
	}
	box {<0, 0.1, -0.15>, <1.2, 0.3, 0.15>}		// body
	object {Vent translate x*0.2}
	object {Vent translate x*0.45}
	object {Vent translate x*0.75}
	object {Vent translate x*1}
	box {<0.03, 0.05, -0.16>, <1.17, 0.1, 0.16>}		// bottom
    box {<-0.04, 0.06, -0.02>, <0.05, 0.1, 0.02>}
	box {<1.15, 0.06, -0.02>, <1.24, 0.1, 0.02>}
}

#declare For_cut1 = merge {
	cylinder {<-0.1, 0.3, -0.15>, <1.3, 0.3, -0.15>, 0.02}
	cylinder {<-0.1, 0.3, 0.15>, <1.3, 0.3, 0.15>, 0.02}
	box {<-0.1, 0.2, -0.17>, <1.3, 0.3, 0.17>}
	box {<-0.1, 0.25, -0.15>, <1.3, 0.32, 0.15>}
}

#declare For_cut2 = merge {
	cylinder {<0.04, 0.3, -0.3>, <0.04, 0.3, 0.3>, 0.02}
	box {<0.02, 0.2, -0.3>, <0.1, 0.3, 0.3>}
	box {<0.05, 0.25, -0.3>, <0.1, 0.32, 0.3>}
}

#declare For_cut3 = merge {
	cylinder {<0, 0.22, -0.3>, <0, 0.22, 0.3>, 0.02}
	cylinder {<0, 0.29, -0.3>, <0, 0.29, 0.3>, 0.02}
	box {<-0.02, 0.22, -0.3>, <0.02, 0.29, 0.3>}
}

#declare Carriage = union {
	object {
		Base
		clipped_by {box {<0.27, 0.2, -0.3>, <0.39, 0.32, 0.3> inverse}}
		clipped_by {box {<0.27, 0.2, -0.3>, <0.39, 0.32, 0.3> inverse translate x*0.14}}
		clipped_by {box {<0.27, 0.2, -0.3>, <0.39, 0.32, 0.3> inverse translate x*0.42}}
		clipped_by {box {<0.27, 0.2, -0.3>, <0.39, 0.32, 0.3> inverse translate x*0.56}}
		clipped_by {object {For_cut1 inverse}}
		clipped_by {object {For_cut2 inverse}}
		clipped_by {object {For_cut2 inverse translate -x*0.1 rotate y*180 translate x*1.1}}
		clipped_by {object {For_cut3 inverse translate x*0.15}}
		clipped_by {object {For_cut3 inverse translate x*0.21}}
		clipped_by {object {For_cut3 inverse translate x*0.58}}
		clipped_by {object {For_cut3 inverse translate x*0.64}}
		clipped_by {object {For_cut3 inverse translate x*1}}
		clipped_by {object {For_cut3 inverse translate x*1.06}}

		texture {Train_txt}
	}
	object {
		Base
		hollow
		translate -x*0.6 scale 0.985 translate x*0.6
		pigment {color rgbf <1, 1, 0.95, 0.94>}
		finish {ambient 0.12 diffuse 0.85 phong 1}
	}

	object {Light_raw}
	object {Light_raw translate z*0.14}
	object {Train_light rotate -z*90 translate <0, 0.15, -0.08>}
	object {Train_light rotate -z*90 translate <0, 0.15, 0.08>}
	object {Train_light rotate z*90 translate <1.2, 0.15, -0.08>}
	object {Train_light rotate z*90 translate <1.2, 0.15, 0.08>}

	light_source {
		<0.3, 0.15, 0> color rgb 1
		fade_distance 0.45
		fade_power 2
	}
	light_source {
		<0.9, 0.12, 0> color rgb 1
		fade_distance 0.45
		fade_power 2
	}
}

#declare Train = union {
	object {Carriage}
	object {Carriage translate x*1.3}
	object {Carriage translate x*2.6}

	translate -y*0.05
	scale 0.7
	translate <-0.6, 0.45, 3.07>
}
