//
//    Include file for gveyard.pov scene file.
//    By: Timo Ettanen tket@spider.compart.fi
//

#version 3.0

#include "colors.inc"
#include "textures.inc"

// ---------------------------- Basket parts -------------------------

#declare BasketColor1 =
pigment{
   bozo
   turbulence 0.05
   color_map{
      [ 0.0 color rgb<0.2, 0.8, 0.9>]
      [ 0.5 color rgb<0.2, 0.8, 0.9>]
      [ 1.0 color rgb<0.15, 0.7, 0.8>]
   }
   scale<0.1,90,0.1>
}


#declare BasketColor2 =
pigment{
   bozo
   turbulence 0.05
   color_map{
      [ 0.0 color rgb<0.2, 0.8, 0.9>]
      [ 0.5 color rgb<0.2, 0.8, 0.9>]
      [ 1.0 color rgb<0.15, 0.7, 0.8>]
   }
   scale<0.1,40,40>
}


#declare BasketTexture1 =
texture{
   pigment{ BasketColor2 rotate<0,0,90>}
   finish{ specular 0.6 roughness 0.03 }
   normal{ bumps 0.12 scale<1.5,0.5,1.5> }
}


#declare BasketTexture2 =
texture{
   pigment{ BasketColor1 }
   finish{ specular 0.5 roughness 0.05 }
   normal{ bumps 0.08 scale<1.2,3.5,1.2> }
}


#declare BasketTexture3 =
texture{
   pigment{ BasketColor2 }
   finish{ specular 0.8 roughness 0.01 }
   normal{ bumps 0.11 scale<0.8,3.6,3.6> }
}


#declare Shield =
union{
   bicubic_patch {                           //back
     type 1
     flatness 0.01
     u_steps 4
     v_steps 4
     <-16, 5,    0>, <-16,  10.5, 18.7>, <16,  10.5, 18.7>, <16, 5,    0>,
     <-15, 3.33, 0>, <-15,  6.67, 18.5>, <15,  6.67, 18.5>, <15, 3.33, 0>,
     <-15, 1.67, 0>, <-15,  3.33, 19.5>, <15,  3.33, 19.5>, <15, 1.67, 0>,
     <-16, 0,    0>, <-16,  0,    21>,   <16,  0,    21>,   <16, 0,    0>
   }
   bicubic_patch {                             //left side
     type 1
     flatness 0.01
     u_steps 4
     v_steps 4
     <-16, 5,    0>, <-16,  3.33, -5.33>, <-16,  1.67, -10.67>, <-16, 0, -16>,
     <-15, 3.33, 0>, <-15,  2.22, -5.33>, <-15,  1.11, -10.67>, <-15, 0, -16>,
     <-15, 1.67, 0>, <-15,  1.11, -5.33>, <-15,  0.55, -10.67>, <-15, 0, -16>,
     <-16, 0,    0>, <-16,  0,    -5.33>, <-16,  0,    -10.67>, <-16, 0, -16>
   }
   bicubic_patch {                           //right side
     type 1
     flatness 0.01
     u_steps 4
     v_steps 4
     <16, 5,    0>, <16,  3.33, -5.33>, <16,  1.67, -10.67>, <16, 0, -16>,
     <15, 3.33, 0>, <15,  2.22, -5.33>, <15,  1.11, -10.67>, <15, 0, -16>,
     <15, 1.67, 0>, <15,  1.11, -5.33>, <15,  0.55, -10.67>, <15, 0, -16>,
     <16, 0,    0>, <16,  0,    -5.33>, <16,  0,    -10.67>, <16, 0, -16>
   }
   union{
      difference{
         torus{15.5,0.6}
         plane{z,0}
      }
      cylinder{<-15.5,0,0><-15.5,0,-8>,0.6}
      cylinder{< 15.5,0,0>< 15.5,0,-8>,0.6}
      torus{0.6,0.15 scale<1,3,1> rotate x*90 translate<-15.5,0,-8>}
      torus{0.6,0.15 scale<1,3,1> rotate x*90 translate< 15.5,0,-8>}
      union{
         cylinder{<-15.5,0,-7><-15.5,0,-15>,0.5}
         cylinder{< 15.5,0,-7>< 15.5,0,-15>,0.5}

         texture{Chrome_Metal}
      }
      translate z*16 rotate x*-18 translate z*-16
   }
   texture { BasketTexture1 rotate x*-9}
}


#declare Straps =
union{
   box{<-0.35,0,-1.2><0.5,20,1.2>}
   cylinder{<-0.3,5.8,1.2><-0.3,5.8,-1.2>,1}
   cylinder{<0,0,1.2><0,0,-1.2>,0.6}
   rotate z*2.85
   translate x*-15
}


#declare Basket =                            // The basket
union{
   union{
      difference{
         box{<0,0,-16><40,20,16>}
         plane{z,0 rotate<-2.85,0,0> translate <0,0,-15> }
         plane{z,0 rotate< 2.85,0,0> translate <0,0, 15> inverse}
      }
      cone{<0,0,0>,15<0,20,0>,16}
      cone{<0,0,0>,15<0,20,0>,16 scale <0.5,1,1> translate x*40}
      object{Straps}
      object{Straps rotate y*70}
      object{Straps rotate y*-70}
      torus{15,0.4}
      torus{15,0.4 scale <0.5,1,1> translate x*40}
      cylinder{<0,0,-15><40,0,-15>,0.4}
      cylinder{<0,0, 15><40,0, 15>,0.4}
      torus{16,0.2 translate y*20 }
      cylinder{<0,20,-16><16,20,-16>,0.2}
      cylinder{<0,20, 16><16,20, 16>,0.2}

      texture{ BasketTexture2 }
   }
   union{
      torus{15.6,0.4 scale <0.5,1,1> translate<40,18,0>}
      cylinder{<16,18,-15.6><40,18,-15.6>,0.4}
      cylinder{<16,18, 15.6><40,18, 15.6>,0.4}
      cylinder{<16,0,0><40,0,0>,16 scale<1,0.15,1> translate y*20}
      box{<16,18,-16><40,20,16>}
      sphere{0,16 scale<0.5,0.15,1> translate<40,20,0>}
      cylinder{<0,18,0><0,20,0>,16 scale<0.5,1,1> translate x*40}

      texture{ BasketTexture3 }
   }
   object{Shield rotate<0,-90,0> translate<0,20,0>}
   object{Shield rotate y*-90 translate x*-16 rotate z*-18 translate<16,20,0>}
   object{Shield rotate y*-90 translate x*-16 rotate z*-36 translate<16,20,0>}
   object{Shield rotate y*-90 translate x*-16 rotate z*-54 translate<16,20,0>}
   union{
      cylinder{<15.5, 20.5,-16.2><15.5, 20.5, -15>,0.8}
      cylinder{<15.5, 20.5, 15><15.5, 20.5,  16.2>,0.8}
      sphere{ 0,0.8 scale<1,1,0.5> translate<15.5,20.5,-16.2>}
      sphere{ 0,0.8 scale<1,1,0.5> translate<15.5,20.5, 16.2>}
      texture{Chrome_Metal}
   }
}


// ---------------------------- Metal parts -------------------------


#declare Wheel =                               // The wheel
union{
  sphere{ 0,2 scale<1,1,0.4>}
  cone {0,2,<0,0,0.6>,2.25}
  cone {<0,0,0.6>,2.35,<0,0,0.75>,2.45}
  cylinder {<0,0,0.75>,<0,0,1.05>,2}
  cylinder {<0,0,3>,<0,0,3.3>,2}
  cylinder {<0,0,0.6><0,0,4>,1}
  difference{
    cylinder{<0,0,0.8><0,0,2.95>,9}
    cylinder{<0,0,0.7999><0,0,2.951>,8}
  }
  torus{ 8,0.5375 scale<1,2,1> rotate x*90 translate<0,0,1.875>}
  torus{ 9,0.2  rotate x*90 translate<0,0,1>}
  torus{ 9,0.2  rotate x*90 translate<0,0,2.75>}
  #declare j= 360
  #while (j >= 0)
      union{
         cylinder{<1.8,0,2.95><8,0,1.875>,0.14}
         cylinder{<7,0,1.95><8,0,1.875>,0.19 texture{New_Brass}}
         rotate<0,0,j>
      }
      #declare j=j-45
  #end
  #declare j= 360
  #while (j >= 0)
      union{
         cylinder{<1.8,0,1.1><8,0,1.875>,0.14}
         cylinder{<7,0,1.75><8,0,1.875>,0.19 texture{New_Brass}}
         rotate<0,0,22.5+j>
      }
      #declare j=j-45
  #end
  difference{
    cylinder{<0,0,1><0,0,2.75>,10.2}
    cylinder{<0,0,0.999><0,0,2.751>,9}
    pigment{White}
    normal{bumps 0.15 scale 0.4}
  }
  torus{ 10.2,0.4375
     scale<1,2,1>
     rotate x*90
     translate<0,0,1.875>
     pigment{
        bozo
        color_map{
           [0.0 color Gray80]
           [0.7 color Gray80]
           [1.0 color Gray25]
        }
        scale 0.3
     }
     normal{bumps 0.25 scale 0.3}
  }
  texture{Chrome_Metal}
}


#declare RockingPart =                      // Small rocking joint
union{
   cylinder{<0,0.2,0><7,0.2,0>,1}
   box{<0,-0.8,-1><7,0.2,1>}
   sphere{<0,0,0>,0.35 scale<1,1,0.85> translate<0.8,0.1,-1>}
   sphere{<0,0,0>,0.35 scale<1,1,0.85> translate<0.8,0.1, 1>}
   sphere{<0,0,0>,0.35 scale<1,1,0.85> translate<6.2,0.1,-1>}
   sphere{<0,0,0>,0.35 scale<1,1,0.85> translate<6.2,0.1, 1>}
}


#declare SolidPart =
union{
   cylinder{<-3,1.35,5.5><53,1.35,5.5>,0.85}
   torus{6,0.85
      rotate <90,0,0>
      clipped_by{ plane {x,0 } }
      translate<-3,7.35,5.5>
   }
   torus{6,0.85
      rotate <90,0,0>
      clipped_by{ plane {x,0 inverse} }
      translate<53,7.35,5.5>
   }
   cylinder{<-3,13.35,5.5><-1,13.35,5.5>,0.85}
   cylinder{<51,13.35,5.5><53,13.35,5.5>,0.85}
   object{RockingPart rotate<0,0,-10> translate<-3.2,13.35,5.5>}
   object{RockingPart rotate<0,180,10> translate<51.2,13.35,5.5>}
   box{<-0.8,0,4.65><0.8,1.35,6.35>}
   box{<-0.8,0,4.65><0.8,1.35,6.35> translate<50,0,0>}
}


#declare Handle =
union{
   cylinder{<0,0, 0>,<35,0,0>,0.85}
   cylinder{<0,0,34>,<35,0,34>,0.85}
   sphere{0,0.48
      scale<1,1,0.7>
      translate<0.85,0,-0.85>
      texture { Chrome_Texture }
   }
   sphere{0,0.48
      scale<1,1,0.7>
      translate<0.85,0,34.85>
      texture { Chrome_Texture }
   }
   union{
      cylinder{<30,0, 0>,<35,0,0>,1}
      cylinder{<30,0,34>,<35,0,34>,1}
      torus{1,0.2 rotate z*90 scale<3,1,1> translate<30.6,0,0>}
      torus{1,0.2 rotate z*90 scale<3,1,1> translate<30.6,0,34>}
      intersection{
         torus{4,1}
         box{<0,-1.001,-5.001><5.001,1.001,0>}
         translate<35,0,4>
      }
      intersection{
         torus{4,1}
         box{<0,-1.001,0><5.001,1.001,5.001>}
         translate<35,0,30>
      }
      cylinder{<39,0,4><39,0,30>,1}

      pigment{Gray50}
      finish{Shiny}
   }
}


#declare CurvedPart =
union{
   difference{
      difference{
         torus{20,0.85 rotate x*90 }
	 plane{x,0}
	 rotate z*-45
      }
      plane{x,0 inverse}
      translate y*20
   }
   cylinder{0,<30,0,0>,0.85}
   box{<28,-1.7,-1><30,0.6,1>}
   cylinder{<28,-1.7,-0.5><30,-1.7,-0.5>,0.5}
   sphere{0,0.48
      scale<1,1,0.6>
      translate<29,0,-0.9>
      texture { Chrome_Texture }
   }
   sphere{0,0.5
      scale<1,1,0.6>
      translate<8.5,0,-0.85>
      texture { Chrome_Texture }
   }
   sphere{0,0.5
      scale<1,1,0.6>
      translate<8.5,0,0.85>
      texture { Chrome_Texture }
   }
}


#declare CurvedPart2 =
union{
   difference{
      difference{
         torus{20,0.85 rotate x*90 }
         plane{x,0 inverse}
         rotate z*45
      }
      plane{x,0}
      translate y*20
   }
   sphere{0,0.85}
   cylinder{<-5,0,1.7>,0,0.85}
   sphere{<-5,0,1.7>,0.85}
   cylinder{<-21.5,0,1.7>,<-5,0,1.7>,0.85}
   union{
      difference{
         difference{
            torus{20,0.85 rotate x*90 }
            plane{x,0 inverse}
            rotate z*45
         }
         plane{x,0}
         translate y*20
      }
      sphere{0,0.85}
      cylinder{<-5,0,-1.7>,0,0.85}
      sphere{<-5,0,-1.7>,0.85}
      cylinder{<-21.5,0,-1.7>,<-5,0,-1.7>,0.85}

      translate<0,0,34>
   }
}


#declare Frame =
union{
   cylinder{<0,0,0><0,0,45>,0.5}
   cylinder{<50,0,0><50,0,45>,0.5}
   object{SolidPart}
   object{SolidPart translate<0,0,34>}

   object{Handle rotate z*45 translate<35,32.4,5.5>}
   object{CurvedPart rotate z*45 translate<18,18,5.5>}
   object{CurvedPart rotate z*45 translate<18,18,39.5>}
   object{CurvedPart2 rotate z*-45 translate<30,18,5.5>}
   union{
      difference{
         torus{15.3,0.85}
         plane{x,0 inverse}
      }
      difference{
         difference{
            torus{10,0.85 rotate x*90 }
            plane{x,0 }
         }
         plane{x,0 rotate z*-45 inverse}
         translate <0,-10,-15.3>
      }
      difference{
         difference{
            torus{10,0.85 rotate x*90 }
            plane{x,0 }
         }
         plane{x,0 rotate z*-45 inverse}
         translate <0,-10, 15.3>
      }
      translate<8,35.8,22.5>
   }
   pigment{Green}
   finish{Shiny}
}

// ------------------------- All parts together ------------------


declare BabyCar =
union{
   object{ Wheel }
   object{ Wheel rotate<0,180,0> translate<0,0,45> }
   object{ Wheel translate<50,0,0> }
   object{ Wheel rotate<0,180,0> translate<50,0,45> }
   object{ Frame }
   object{ Basket translate<8,30,22.5>}
}


