//  DLIhelio.pov by Daniel L. Isdell for the Internet Raytracing Competetion July 1996
//  Heliochron (sun clock)
#version 3.0
global_settings { assumed_gamma 2.2 }
global_settings { max_trace_level 30 }

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"
#include "iris.inc"

#declare R1 = seed(0)
#declare R2 = seed(1)
#declare leafgreen = texture {
   pigment {
     color rgb<0.3, 0.7, 0.3>
   }
   finish {
     diffuse 0.450
     ambient 0.310
     phong 0.20
     phong_size 20.000
     roughness 0.0200
   }
}

//////////////////////////////////////////////////////////////////////////////////////////////
camera {
    location <-2.5, 2.0, -7.3>
    right x*1.333
    up y
    direction <0,0,4>
    look_at <0, 0.4, 0>
}

//////////////////////////////////////////////////////////////////////////////////////////////
light_source { <-30.5, 75, -60> White }

//////////////////////////////////////////////////////////////////////////////////////////////
// iris leaves

#declare Leaf_Count1=20
union{
  #while (Leaf_Count1>=0)

intersection {
 sphere { 0, 0.5 scale <1, 3+(rand(R2)*2),1>
   texture { leafgreen }}

torus { 1, 0.5 texture { pigment { color rgbf <1,1,1,1> } }
  scale <1, 0.2, (rand(R2)*2.6)+3.5>
 rotate <87+(rand(R2)*6), 0, 0>
  translate <0.1, 0.3, 0>}
translate <0.5, 0.4, 0>
scale (rand(R2)/2)+0.5 rotate <rand(R2)*45,rand(R2)*360,0> translate <7.23,-4.3,14>}

intersection {
 sphere { 0, 0.5 scale <1, 2+(rand(R2)*3),1>
   texture { leafgreen }}

torus { 1, 0.5 texture { pigment { color rgbf <1,1,1,1> } }
  scale <1, 0.2, (rand(R2)*2)+3.4>
 rotate <87+(rand(R2)*6), 0, 0>
  translate <0.1, 0.3, 0>}
translate <0.5, 0, 0>
scale (rand(R2)/2)+0.5 rotate <rand(R2)*45,rand(R2)*360,0> translate <8.03,-4.3,13.3>}

intersection {
 sphere { 0, 0.5 scale <1, 2+(rand(R2)*3),1>
   texture { leafgreen }}

torus { 1, 0.5 texture { pigment { color rgbf <1,1,1,1> } }
  scale <1, 0.2, (rand(R2)*2.5)+3.2>
 rotate <87+(rand(R2)*6), 0, 0>
  translate <0.1, 0.3, 0>}
translate <0.5, 0, 0>
scale (rand(R2)/2)+0.5 rotate <rand(R2)*45,rand(R2)*360,0> translate <8.79,-4.3,13.4>}

    #declare Leaf_Count1=Leaf_Count1-1
  #end }

//////////////////////////////////////////////////////////////////////////////////////////////
//iris stems

intersection {
torus { 0.5, 0.015
  texture { pigment{color <0.5,0.9,0.5> }}
  scale <1,1,3.5>
 rotate 90*x
}
box {< 0, -0.5, -0.5 >, < 0.6, 1.59, 0.5 >
texture { pigment {color rgbf<1,1,1,1>}}}
rotate <0, -6, 3 >
translate <6.63,-3.9,14>}

intersection {
torus { 0.5, 0.015
  texture { pigment{color <0.5,0.9,0.5> }}
  scale <1,1,4>
 rotate 90*x
}
box {< 0, -0.5, -0.5 >, < 0.6, 1.7, 0.5 >
texture { pigment {color rgbf<1,1,1,1>}}}
rotate <0, -12, 3 >
translate <7.53,-3.9,13.3>}

intersection {
torus { 0.5, 0.015
  texture { pigment{color <0.5,0.9,0.5> }}
  scale <1,1,5>
 rotate 90*x
}
box {< 0, -0.5, -0.5 >, < 0.6, 1.7, 0.5 >
texture { pigment {color rgbf<1,1,1,1>}}}
rotate <0, -35, 3 >
translate <8.35,-3.9,13.4>}

//////////////////////////////////////////////////////////////////////////////////////////////
// iris

object {iris
 scale  0.12
rotate < -107, 90, 15 >
translate < 6.7, -2.3, 14 >
}

object {iris
 scale  0.125
rotate < -120, 15, 15 >
translate < 7.7, -2.2, 13.3 >
}

object {iris
 scale  0.12
rotate < -100, 80, 5 >
translate < 8.5, -2.0, 13.6 >
}


//////////////////////////////////////////////////////////////////////////////////////////////
// leaf shadows on wall
// shadow on right
polygon
{
  5, <0, 0>, <0, 1>, <1, 1>, <1, 0>, <0, 0>
 texture {
   pigment {
    image_map {
  gif "shadow.gif"
  map_type 0
  interpolate 2
   filter 0,0.9
   filter 15,1.0
  once
      }
    }
  }
scale <1, 1.25, 1>
rotate <0, 3, -20>
translate <-14.0, 40.8, -26>}

// shadow on left
polygon
{
  5, <0, 0>, <0, 1>, <1, 1>, <1, 0>, <0, 0>
 texture {
   pigment {
    image_map {
  gif "shadow.gif"
  map_type 0
  interpolate 2
   filter 0,0.9
   filter 15,1.0
  once
      }
    }
  }
scale <1.45, 1, 1>
rotate <0, 3, 0>
translate <-16.2, 40, -26>} //-13.5


//////////////////////////////////////////////////////////////////////////////////////////////
//bow string sundial

union {

// engraved roman numerals

difference {
cylinder {0*y,  1*y,  0.474 open
texture { pigment { P_Brass5 }
  finish { F_MetalD }
  normal { bump_map { gif "numerals.gif"
     map_type 2
     interpolate 2

  bump_size 1.2
      }
    }
  }
 rotate 275.5*y translate <0,-0.5,0> scale <1, 0.1, 1>} //274
  box{<-1, -0.1, 0.05>
      < 1, 0.1, 1>  }
texture { pigment { rgbf 1 }
}
rotate -90*x   translate <0, 0.7,0>}

// arrow head

difference {
cone { <0, 0, 0.15>, 0.06, <0, 0, -0.1>, 0
texture { pigment { P_Brass5 }
  finish { F_MetalD }}
scale <0.35, 1, 1> rotate <-22, 0, 0> }
box { <-0.5, 0.00001, -0.5>,<0.5, 0.5, 0.5>
texture { pigment { P_Brass5 }
  finish { F_MetalE }
}
}
rotate <0,0,90> translate <0, 0.7, 0.68> }

difference {
cone { <0, 0, 0.15>, 0.06, <0, 0, -0.1>, 0
texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.35, 1, 1> rotate <22, 0, 0> }
box { <-0.5, -0.5, -0.5>,<0.5, -0.00001, 0.5>
texture { pigment { P_Brass5 }
  finish { F_MetalE }
}//tex
}//box
rotate <0,0,90> translate <0, 0.7, 0.68> }

// arrow shaft

cylinder {0.7*z,  -0.725*z,  0.012
texture { pigment { P_Brass5 }
  finish { F_MetalE }
}
translate <0, 0.7,0>}

//feathers

difference {
union {
difference {
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1> }
box {<-0.1,-0.1,-0.06>, <0.1,0.1,0.1>
texture { pigment { P_Brass5 }
  finish { F_MetalE }}}
 translate <0, 0.7, -0.54>  }

difference {
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1> }
box {<-0.1,-0.1,-0.05>, <0.1,0.1,0.1>
texture { pigment { P_Brass5 }
  finish { F_MetalE }}}
 translate <0, 0.7, -0.57>  }

difference {
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1> }
box {<-0.1,-0.1,-0.04>, <0.1,0.1,0.1>
texture { pigment { P_Brass5 }
  finish { F_MetalE }}}
 translate <0, 0.7, -0.60>  }

difference {
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1> }
box {<-0.1,-0.1,-0.03>, <0.1,0.1,0.1>
texture { pigment { P_Brass5 }
  finish { F_MetalE }}}
 translate <0, 0.7, -0.63>  }

torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1>  translate <0, 0.7, -0.66>  }
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalD }}
scale <0.55, 1, 1>  translate <0, 0.7, -0.69>  }
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1>  translate <0, 0.7, -0.72>  }
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalE }}
scale <0.55, 1, 1>  translate <0, 0.7, -0.75>  }
}

cylinder { <0,-0.1,0>, <0,0.1,0>, 0.075
 texture { pigment { P_Brass5 }
  finish { F_MetalD }}
scale <0.55, 1, 1>  translate <0, 0.7, -0.78>  }
}

difference {
torus { 0.075, 0.00385
 texture { pigment { P_Brass5 }
  finish { F_MetalD }}
scale <0.55, 1, 1> }
box { <-0.1,-0.1,-0.1>, <0.1,0.1,0.>
texture { pigment { P_Brass5 }
  finish { F_MetalD }}}
 translate <0, 0.7, -0.78>  }

// arcs of sundial

difference {
cylinder {-0.05*y,  0.05*y,  0.5}
 cylinder {-0.06*y,  0.06*y,  0.475
texture { pigment { P_Brass5 }
  finish {F_MetalD}
}
}
  box{<-1, -0.06, 0.05>
      < 1, 0.06, 1>  }
texture { pigment { P_Brass5 }
  finish{ F_MetalD }
}
rotate -90*x rotate 90*y  translate <0, 0.7,0> }

difference {
cylinder {-0.05*y,  0.05*y,  0.5}
 cylinder {-0.06*y,  0.06*y,  0.475}
  box{<-1, -0.06, 0.05>
      < 1, 0.06, 1>  }
texture { pigment { P_Brass5 }
  finish { F_MetalD }
}
rotate -90*x translate <0, 0.7,0>}//dif
rotate -37.53*x  //   latitude adjustment for San Jose, CA
 translate <0, 0.2, 0.4>
}


/////////////////////////////////////////////////////////////////////////////////////////////
// small brass base of sundial

union {
torus
{
  0.06,
  0.015
scale <1,0.5,1>
translate 0.057*y}
cone
{
  0.055*y,  0.06,
  0*y, 0.092
}
torus
{
  0.092,
  0.022
}
texture { pigment { P_Brass5 }
  finish { F_MetalD }
}
translate <0, 0.19, 0>}



//////////////////////////////////////////////////////////////////////////////////////////////
// flag stone walk

 disc
{
  <0, -4, 0>
  y,
  13,
  2
texture{
pigment {
 crackle
    color_map {
     [0.0 color rgb 0.54]
     [0.04 color rgb 0.47]
     [0.04 color rgb 0.75]
     [0.8 color rgb 0.8]
     [0.9 color rgb 0.82]}
    turbulence 0.09
    scale <1,3,1>
  }
  normal
  {
    crackle

 normal_map {
      [ 0.0 crackle]
      [ 0.07 crackle turbulence 0.1]
      [ 0.07 crackle turbulence 1.0]
      [ 1.0 crackle turbulence 0.7]
    }
    turbulence 0.09
    scale <1,3,1>
  }
  finish
  {
    ambient 0.4
    specular 0.2
  }
}
rotate <0, 7, 0>
}

//////////////////////////////////////////////////////////////////////////////////////////////
//dirt past stone walk

 disc
{
  <0, -4.2, 0>
  y,
  20,
  13
texture{
pigment {
 crackle
    color_map {
     [0.0 color rgb <0.34, 0.16, 0.1>]
     [1.0 color rgb 0.47]
    }
    turbulence 0.09
    scale <10,30,10>
  }
  normal
  {
    crackle //0.55
    turbulence 1.0
    scale <1,5,1>// transformations
  }
  finish
  {
    ambient 0.4
    specular 0.2
  }
}
}


//////////////////////////////////////////////////////////////////////////////////////////////
// column and top block with carved poem

union {
difference {
box {
  <-0.50, -0.20, -0.50> //-0.54
  < 0.50, 0.20, 0.50> //0.55
      texture {T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6
  }
 }

height_field { gif "poem.gif"
      texture {T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6
}
    scale <1,-0.025,0.4>
    rotate <-90, 0, 0>
    translate <-0.5, -0.20, -0.5> } // -0.5395
}

torus { 0.41, 0.09
 texture { T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6
  }
scale <1,0.4, 1> translate <0,-0.24,0>
}

difference {
cylinder { -0.2*y,  -0.35*y,  0.41
  texture { T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6 }
}

torus { 0.41, 0.05
 texture { T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6
  }
scale <1, 0.5, 1> translate <0, -0.31, 0>
  }
}

torus { 0.35, 0.07
 texture { T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6
  }
scale <1, 0.4, 1> translate <0, -0.345, 0>
}

#declare flute = union { cylinder { -0.48*y,  -3.6*y,  0.06 }
sphere {-0.48*y, 0.06}
sphere {-3.6*y, 0.06 }
scale <1,1,0.9>}

difference {
cylinder { -0.34*y,  -4.0*y,  0.4 }
object { flute translate 0.4*z rotate  22.5*y }
object { flute translate 0.4*z rotate  45.0*y }
object { flute translate 0.4*z rotate  67.5*y }
object { flute translate 0.4*z rotate  90.0*y }
object { flute translate 0.4*z rotate 112.5*y }
object { flute translate 0.4*z rotate 135.0*y }
object { flute translate 0.4*z rotate 157.5*y }
object { flute translate 0.4*z rotate 180.0*y }
object { flute translate 0.4*z rotate 202.5*y }
object { flute translate 0.4*z rotate 225.0*y }
object { flute translate 0.4*z rotate 247.5*y }
object { flute translate 0.4*z rotate 270.0*y }
object { flute translate 0.4*z rotate 292.5*y }
object { flute translate 0.4*z rotate 315.0*y }
object { flute translate 0.4*z rotate 337.5*y }
texture { T_Stone8 }
      finish {
              ambient 0.4
              specular 0.6 }scale <0.9,1,0.9>}
}


/////////////////////////////////////////////////////////////////////////////////////////////
//grass
#declare Count=1200  //1200 blades of grass!

union{
  #while (Count>=0)

 intersection {
     sphere {0, (rand(R1)/2)+0.5
       texture { pigment {rgb <0.1, 0.4+(rand(R1))/6, 0.1>}
          finish {ambient 0.45
                  phong 0.12 } }
scale <((rand(R1))*0.15)+0.15,((rand(R1))/2)+0.55,((rand(R1))*0.2)+0.15>}
     box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
   texture { pigment {rgbf <1,1,1,1> } }
rotate <0,45,0> scale <1,1,0.1> translate <-0.7,0.5,0>}
translate <0.225,0,0>rotate <0,0,(rand(R1))*-20> rotate <0,rand(R1)*360,0>
translate < 0, -4.25, 13.01+(rand(R1)*2) > rotate ((35*(rand(R1))))*y
}
    #declare Count=Count-1
  #end }

//////////////////////////////////////////////////////////////////////////////////////////////
//wall

#declare Atex = texture{ pigment { rgb 1 }
  finish { ambient 0.45
           phong 1}
  }

#declare Btex = texture{ pigment { rgb 1 }
  finish { ambient 0.4
           phong 1}
  normal {
    wood 0.005
    turbulence 0.04
    octaves 3
    scale < 0.02, 0.02, 0.1 >
 rotate < 0.0, 88.5, 0.0 >
 translate < 0.0, 0.0, 1.0 >
}
}
#declare clapboard = box{<-12, -3, 12.5>,<12, -2.45,12.5>

rotate <7,0,0>}

difference {

union {
// 10
object { clapboard translate < 0.0, 4.5, 0.0 >
texture { Btex scale < 1.0, 0.8, 1.0 >
 rotate < 0.0, 2.0, 1.0 >
 translate < 0.0, 4.0, -1.0> } }
// 9
object { clapboard translate < 0.0, 4.0, 0.0 >
texture { Btex scale < 1.0, 0.85, 1.0 >
 rotate < 0.0, 0.4, 0.3>
 translate < 0.0, 4.0, -1.0 > } }
// 8
object { clapboard translate < 0.0, 3.5, 0.0 >
texture { Btex scale <0.9, 0.5, 1.0 >
 rotate < 0.0, -2.2, -1.0 >
 translate < 0.0, -1, 1.5 > } }
// 7
object { clapboard translate < 0.0, 3.0, 0.0 >
texture { Btex scale < 1.0, 0.9, 1.0 >
 rotate < 0.0, -1.0, 0.0 >
 translate < 0.0, -3.5, -0.7 > } }
// 6
object { clapboard translate < 0.0, 2.5, 0.0 >
texture { Btex scale < 1.0, 1.0, 1.0 >
 rotate < 0.0, 2.2, -2.0 >
 translate < 0.0, 5.0, 0.0 > } }
// 5
object { clapboard translate < 0.0, 2.0, 0.0 >
texture { Btex scale < 1.0, 0.8, 1.0 >
 rotate < 0.0, 3.0, 2.0 >
 translate < 0.0, 2.0, -1.5 > } }
// 4
object { clapboard translate < 0.0, 1.5, 0.0 >
texture{ Btex scale < 1.0, 0.75, 1.0 >
 rotate < 0.0, 2.0, 0.7 >
 translate < 0.0, 1.5, 1.0 > } }
// 3
object { clapboard translate < 0.0, 1.0, 0.0 >
texture{ Btex scale < 1.0, 1.0, 1.0 >
 rotate < 0.0, 0.0, 0.5 >
 translate < 0.0, 0.8, 0.5 > } }
// 2
object { clapboard translate < 0.0, 0.5, 0.0 >
texture{ Btex scale < 1.0, 0.85, 1.0 >
 rotate < 0.0, 0.9, 0.0>
 translate < 0.0, 0.5, 1.0 > } }
// 1
object { clapboard translate < 0.0, 0.0, 0.0 >
texture{ Btex scale < 1.0, 1.0, 1.0 >
 rotate < 4.0, 0.0, 0.0 >
 translate < 0.0, 0.3, 3.0 > } }
translate < 0.0, 0.0, 2.5 >
}
box { < 7.3, -1.65, 14.0 >, < 11.0, 4.0, 16.0 > texture { Btex } }
}

//////////////////////////////////////////////////////////////////////////////////////////////
//window frame
union {
box {<7.6, -2, 14.45>, <8.2, 4, 15> texture { Atex }}// left side
box {<11.0, -2,14.45>, <11.6 ,4,15> texture { Atex }}//right side
box {<7.5,-0.1,-0.5>, <12.0,0.1,0.5> texture { Atex } translate <0,4,14.9>}//top
box {<7.5,-0.1,-0.5>, <12.0,0.1,0.4> texture { Atex }rotate <-7,0,0> translate <0,-2,14.9>}//sill

#declare muntin = union {
box { <-1.5, -0.2, -0.04>, <-1.5, -0.2, -0.04> texture { Atex }}  //<-1.5, -0.08, -0.04>, <-1.5, -0.08, -0.04>
box { <-1.5, -0.04, -0.06>, <-1.5, -0.04, -0.06> texture { Atex }}  //<-1.5, -0.04, -0.06>, <-1.5, -0.04, -0.06>
cylinder { <-1.5, 0, 0>, <1.5, 0, 0>, 0.04  texture { Atex } scale <1, 0.6, 1>}
}

object { muntin
translate <9.6, -0.8, 15.>}
object { muntin
translate <9.6, -1.7, 15.>}
object { muntin
rotate <0,0,90>translate <9.3, -0.4, 15.>}
object { muntin
rotate <0,0,90>translate <10.0, -0.4, 15.>}

//sash frame

box { <-1.5, -0.2, -0.1 >, <1.5, 0.2, 0.1> texture { Atex }
translate <9.6, -1.9, 15>}
box { <-1.5, -0.2, -0.1 >, <1.5, 0.2, 0.1> texture { Atex }
rotate <0,0,90> translate <8.4, -0.5, 15>}


//////////////////////////////////////////////////////////////////////////////////////////////
// curtain
union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-15.123461, -0.022231, -13.478718>, <-9.721802, -5.153345, -13.446125>, <-5.348158, 6.168715, -13.521604>, <-3.245699, 0.108047, -12.967748>,
      <-15.442732, 0.055818, -3.242760>, <-10.566071, -5.188176, -3.209309>, <-5.667429, 6.246764, -3.285646>, <-3.721181, -0.593966, -3.241045>,
      <-15.782028, 0.145978, 8.730338>, <-10.380368, -4.985136, 8.762931>, <-6.006725, 6.336925, 8.687452>, <-3.635656, 2.479217, 8.712326>,
      <-15.779969, 0.207980, 18.150084>, <-10.903829, -1.126700, 18.157803>, <-6.199139, 0.541439, 18.145795>, <-3.730834, -0.387524, 18.151371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.245699, 0.108047, -12.967748>, <-1.143239, -5.952620, -12.413893>, <2.564266, 7.227030, -10.811518>, <3.984146, 1.046368, -12.130537>,
      <-3.721181, -0.593966, -3.241045>, <-1.774933, -7.434696, -3.196443>, <3.284130, 4.907087, -3.278784>, <4.184442, -0.074579, -3.246191>,
      <-3.635656, 2.479217, 8.712326>, <-1.264588, -1.378490, 8.737200>, <2.944834, 4.997247, 8.694314>, <3.586709, 2.043965, 8.713613>,
      <-3.730834, -0.387524, 18.151371>, <-1.262529, -1.316488, 18.156946>, <3.168857, -0.030205, 18.147511>, <3.699749, -0.438760, 18.150084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.984146, 1.046368, -12.130537>, <5.404025, -5.134294, -13.449556>, <12.261089, -5.361954, -13.449556>, <9.181556, -2.653514, -13.466710>,
      <4.184442, -0.074579, -3.246191>, <5.084755, -5.056245, -3.213598>, <11.941818, -5.283905, -3.213598>, <8.862285, -2.575465, -3.230752>,
      <3.586709, 2.043965, 8.713613>, <4.228583, -0.909318, 8.732911>, <9.288945, -5.116932, 8.759501>, <8.137407, -2.472079, 8.806646>,
      <3.699749, -0.438760, 18.150084>, <4.230642, -0.847316, 18.152657>, <7.195594, -0.554825, 18.150084>, <8.388445, -0.724315, 18.215242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.181556, -2.653514, -13.466710>, <6.102023, 0.054927, -13.483865>, <12.837970, 5.816198, -13.523258>, <16.588581, 1.964331, -9.511946>,
      <8.862285, -2.575465, -3.230752>, <5.782752, 0.132976, -3.247906>, <13.533193, 3.263712, -3.270207>, <14.607152, -2.375269, -3.233325>,
      <8.137407, -2.472079, 8.806646>, <6.985870, 0.172774, 8.853792>, <13.193898, 3.353873, 8.702891>, <14.267856, -2.285108, 8.739773>,
      <8.388445, -0.724315, 18.215242>, <9.581296, -0.893804, 18.280400>, <12.662835, -0.866651, 18.150942>, <14.972620, -0.682718, 18.149226>
    }
  }
  texture {
   pigment {
     color rgb < 0.37, 0.34, 0.75 >
   }
   finish {
     diffuse 0.3
     ambient 0.34
     phong 0.15
     phong_size 20.000
     specular 0.300
     roughness 0.4110
   }

}
scale <0.085, 0.1, 0.1>
rotate <-90,0,0>
translate  <9.3, -1.4, 15.4>
}
translate <-0.7, 0.35, 0>}




// DLIhelio.pov by Daniel L. Isdell for the Internet Raytracing Competetion July 1996

