// Persistence of Vision Ray Tracer Scene Description File
// File: hglass5.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: 6/28/96
// Auth: Brian Vandewettering
//

#version 3

#include "colors.inc"
#include "skies.inc"
#include "glass.inc"
#include "bvwood.inc"
#include "bvstone.inc"



global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <2.0, 0.5, -9.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 1.3,  0.0>
}

sky_sphere {S_Cloud3}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 20, -30>
}


// ----------------------------------------
// plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

// create a smooth blobby shape
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components

#declare Blob = blob
{
 
  threshold 0.6
  sphere { < 0,   0,    0>, StrengthVal, RadiusVal }
  sphere { < 0,  1.34, 0>, StrengthVal, RadiusVal }
  sturm

}
#declare Blob2 = blob
{
 
  threshold 0.6
  sphere { < 0,   0,    0>, StrengthVal, RadiusVal-.01}
  sphere { < 0,  1.34, 0>, StrengthVal, RadiusVal-.01 }
  sturm


}

#declare Globe = difference {
        object {Blob}
        object {Blob2 }
        texture {T_Old_Glass}
        scale 2
}


#declare Top = 3.8
#declare Base_Cyl = cylinder {<0,-1.36,0> <0,Top,0> 1.1}


#declare Cut_Helix1 = blob { threshold 0.2
#include "helix1.inc"
}


#declare Clockwise = difference {
        object {Base_Cyl}
        object {Blob scale 2}
        object {Cut_Helix1}
        object {Cut_Helix1 rotate 120*y }
        object {Cut_Helix1 rotate 240*y }

        cylinder { <0,0,0> <0,3,0> .9 }
}



#declare Cut_Helix2 = blob { threshold 0.2
#include "helix2.inc"
}


#declare CClockwise = difference {
        object {Base_Cyl}
        object {Blob scale 2}
        object {Cut_Helix2 }
        object {Cut_Helix2 rotate 120*y }
        object {Cut_Helix2 rotate 240*y }

        cylinder { <0,0,0> <0,3,0> .9 }


}

#declare Base = union {
        object {Clockwise }
        object {CClockwise }
        texture {Yello_Pine2 scale .3}

}

#declare HGlass = union {
        object {Base}
        object {Globe}
}

object {HGlass rotate 10*y}

object {HGlass rotate -30*y translate <-7,0,8> }
object {HGlass rotate 45*y translate <4,0,25> }

plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.3 // distance from the origin in the direction of the surface normal
  texture {Stone2 finish {crand 0.05}}
}


fog
{
  fog_type   2
  distance   50
  color      Gray
  fog_offset 0
  fog_alt    .5
  turbulence 0.8
}

