// Scene Created by Joel R. Cheves
// for the POV "Time" Raytracing Competition
// Persistence of Vision Raytracer 3

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "sundial.inc"

camera {
   location <0, 50.0, -295> 
   direction <0.0, 0.0, 1.0>
   up <0.0, 1.0, 0.0>
   right <4/3, 0.0, 0.0>
   look_at <0.0, -35, 200.0>
}

fog {colour rgbft<0.3, 0.5, 0.2, 0.0, 0.0> distance 1500}

height_field {
   gif "fract003.gif"
      water_level .01 //.05

   pigment {
      image_map { gif "fract004.gif"}
      quick_color White
      translate <-1.0, 0.0, -1.0>
   }
   scale <320, 256, 200>
   scale <2.3, .55, 2> 
   translate <-160.0, -65.5, -100.0>  
   translate <-125.0, 0.0, -30.0> 
}

// Define the sand
plane { y, -10.0
   pigment { color red .89 green .80 blue.66}
   normal {
      waves 1
      frequency 9 
      scale 4000.0 
   }
   finish {
      crand .05
      ambient 0.2 //.3
   }
}

// Now draw the sky - seed file by D. Muir
sphere { <0.0, 0.0, 0.0>, 3500.0
   pigment {
      onion
      colour_map {
         [0.0 0.6  colour red 1.0 green 0.6 blue 0.0
                   colour red 0.3 green 0.6 blue 0.6]
         [0.6 1.0  colour red 0.3 green 0.6 blue 0.6
                   colour red 0.1 green 0.4 blue 0.6]
      }
      quick_colour red 0.7 green 0.7 blue 1.0
      scale <6000, 1700, 4000>
      translate <-1200.0, 220.0, 2500.0>
   }
   finish {
      ambient 0.8
      diffuse 0.0
   }
}

// Put in a few clouds
plane { y, 300.0
   pigment {
      bozo
      turbulence 0.5
      colour_map {
         [0.0 0.6   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 1.0 blue 1.0 filter 1.0]
         [0.6 0.8   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 0.8 blue 0.1]
         [0.8 1.001 colour red 1.0 green 0.8 blue 0.1
                    colour red 1.0 green 0.8 blue 0.1]
      }
      quick_colour red 0.8 green 0.8 blue 1.0
      scale <400,80,320>
   }
   finish {
      ambient 0.7
      diffuse 0.0
   }

   translate <50, -50, 0>
   rotate 6*y
}

//
plane { <0, 0, 1>, 0
 texture {
  pigment {
   image_map {
    gif "sunmap.gif"
     once
   }
  } 
  scale <4,3,3>
  }
   finish {
    ambient 1
    diffuse 0
     phong .8 
 }
translate <2000, 200, 2400> 
scale <.2,.15,.15>
}

// Now to cast some light on the subject
light_source { <-125.0, 250.0, -400.0> colour MediumGoldenrod }
light_source { <-1100.0, 2000.0, 1200.0> colour White } 
light_source { <300, 1250, -300> colour MediumGoldenrod }
light_source {
    <0, 0, 0> colour Quartz
   looks_like {
      sphere { <0.0, 0.0, 0.0>, 100
         pigment { colour Quartz filter 0.5 }
         finish { ambient 1.0 diffuse 0.0
          crand 4 
          phong .1}
      }
   }
       translate <500.0, 200.0, 2500.0>
}

object {
  Sundial
  translate <-13.5, 2.5, 0>
   scale 12
   rotate y*-87
}
