// Scene Created by Joel R. Cheves
// for the POV "Time" Raytracing Competition
// Persistence of Vision Raytracer 3

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "sundial.inc"

// CAMERA POSITION
camera {
 right      < -1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1 >
 location   < 1.75, .8, 15.75>
 look_at    < -.55, -3, 0 >
}
// LIGHTS:
light_source { < -20,25,-34>
color White
}

light_source { < .5,0,-24>
color White
}

light_source {
    < 3,10,5> //12,20,12>
    color White //Tan
  spotlight
  point_at < 0, .3, -2>
  tightness 5
  radius 10
  falloff 150
}

background {color MidnightBlue}

#declare Water =
        texture {
           pigment {
              color rgbf<.2, .7, .8, .95>
              }
           normal {
              waves .20
              frequency 40
              scale 28
              }
           finish {
              reflection .25
              refraction 1
              ior 1.5
              ambient .2
              diffuse .3
              phong .9
              phong_size 80
              }
        }

// Define the ocean surface
plane { y, -4
 texture { Water }
}


//Put a floor underneath to catch any errant waves from the ripples
plane { y, -7
    texture { PinkAlabaster
     finish { ambient 1.0  diffuse 0.0  crand 0.05 }
  }
}

//sphere { <0,0,0>,1000}
// Now draw the sky
sphere { <0.0, 0.0, 0.0>, 3500.0
      pigment {
      onion
      colour_map {
         [0.0 0.6  colour red .6 green .2 blue .8
                   colour red .1 green 0 blue 0.2]
         [0.6 1.0  colour red .1 green 0.4 blue 0.5
                   colour red 0.1 green 0.3 blue 0.4]
      }
      quick_colour red 0.7 green 0.5 blue 1.0 //gr.7
      scale <6000, 1700, 4000>
      translate <-1200.0, 200.0, 2500.0> // 220
   }
   finish {
      ambient 0.8
      diffuse 0.0
  }
}

union {
// CYLINDER _cylinder0
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { PinkAlabaster }
 scale  < 8.99987, 0.580356, 9 >
 translate  < 0, -4.77029, 0 >
 }


// Dial Markers
union {
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
  translate  < -6.54447, -4, 3.78947 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4    // amount of iridescence saturation (0...1) [0]
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < -6.54447, -4, 3.78947 >
}

cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < 3.77132, -4, 6.598 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < 3.77132, -4, 6.598 >
}

cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < -3.77586, -4, 6.55536 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < -3.77586, -4, 6.55536 >
}


cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < 0, -4, 7.5 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < 0, -4, 7.5 >
}


cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < 3.7922, -4, -6.63158 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < 3.7922, -4, -6.63158 >
}


// CONE
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < -7.5, -4, 0.0163934> //0 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }

   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < -7.5, -4, 0 >
}
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 > //.1
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < -6.43557, -4, -3.70236 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < -6.43557, -4, -3.70236 >
}


cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < -3.83394, -4, -6.64609 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }
   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < -3.83394, -4, -6.64609 >
}


cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
   scale  < 0.2, 1, 0.2 >
  texture { pigment { Bronze2}
  finish {
   crand .1
   phong.8 phong_size 100
   ambient .5
 }
}
 translate  < 0.0235931, -4, -7.72504 >
 }
sphere {  < 0, 0, 0 > 1
  texture { pigment { Bronze2}
  finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
   }

   crand .1
   phong.8 phong_size 100
   ambient .5
  }
 }
 scale  < 0.25, 0.25, 0.25 >
 translate  < 0.0235931, -4, -7.72504 >
 }
   rotate y*35
  texture { pigment { Bronze2}
   finish {
    irid {
    0.4
    thickness 0.2
    turbulence 0.7
     }
    crand .4 //.05 , .2
    phong.8 phong_size 100
    ambient .4}
  }
 }
}

union {
torus { 10, 0.25
 texture {pigment { Bronze2 }
 finish {
    irid {
    0.4            // amount of iridescence saturation (0...1) [0]
    thickness 0.2
    turbulence 0.7
  }
  crand .4
  phong.8 phong_size 100
  diffuse .5
  ambient .2} // .1 dark nice color range!!!
 }
  translate  < 0, -4.1, 0>
}
// CYLINDER _cylinder11
cylinder { < 0, -1, 0>, < 0, 1, 0>, 10
 texture { PinkAlabaster
   scale 2 }
 translate  < 0, -5.45, 0>
 }
}

object {
  Sundial
}
