// This is the invariant part of the main clock body.  All the variable
// parts are declared in "clcktvar.inc"
//
//   Created by: Ryan Wellman (firestar@eskimo.com)
// Copyright 1996, Ryan Wellman

==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "glass.inc"    // The glass texture include
#include "metals.inc"   // The metal texture include
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"    // The wood includes

#declare Pattern_Line_Width = .01
#declare Clock_VTop_Depth = .02
#declare Clock_Total_Depth = .5

// The un-cut version of the pattern at the top consisting of 12 toruses.
#declare clock_vtop_pattern_raw = union {
  // Right Side.
  torus {
    .4,
    Pattern_Line_Width

    rotate 90*x
    translate < .4, 0, 0 >
  }
  torus {
    sqrt( .1325 ),
    Pattern_Line_Width

    rotate 90*x
    translate < .35, -.1, 0 >
  }
  torus {
    sqrt( .13 ),
    Pattern_Line_Width

    rotate 90*x
    translate < .3, -.2, 0 >
  }
  torus {
    sqrt( .1525 ),
    Pattern_Line_Width

    rotate 90*x
    translate < .25, -.3, 0 >
  }
  torus {
    sqrt( .2 ),
    Pattern_Line_Width

    rotate 90*x
    translate < .2, -.4, 0 >
  }
  torus {
    sqrt( .37 ),
    Pattern_Line_Width

    rotate 90*x
    translate < .1, -.6, 0 >
  }

  // Left Side.
  torus {
    .4,
    Pattern_Line_Width

    rotate 90*x
    translate < -.4, 0, 0 >
  }
  torus {
    sqrt( .1325 ),
    Pattern_Line_Width

    rotate 90*x
    translate < -.35, -.1, 0 >
  }
  torus {
    sqrt( .13 ),
    Pattern_Line_Width

    rotate 90*x
    translate < -.3, -.2, 0 >
  }
  torus {
    sqrt( .1525 ),
    Pattern_Line_Width

    rotate 90*x
    translate < -.25, -.3, 0 >
  }
  torus {
    sqrt( .2 ),
    Pattern_Line_Width

    rotate 90*x
    translate < -.2, -.4, 0 >
  }
  torus {
    sqrt( .37 ),
    Pattern_Line_Width

    rotate 90*x
    translate < -.1, -.6, 0 >
  }
}

// The shape of the indentation at the top.  (A protion of a cylinder)
#declare clock_vtop_cut = intersection {
  cylinder {
    < 0, -.5, -.1 >,
    < 0, -.5, 2 >,
    sqrt( .4525 )
  }
  box {
    < -.45, 0, -.1 >,
    <  .45, .2, Clock_VTop_Depth >
  }
}

// Remove all the unwanted portions of the pattern at the top of the clock
//  (Leave only what fits into the cut.)
#declare clock_vtop_pattern = intersection {
  object {
    clock_vtop_pattern_raw
    translate < 0, 0, Clock_VTop_Depth >
  }
  object { clock_vtop_cut }
}

// The side Rails.
#declare clock_vtop_rail_side = difference {
  intersection {
    cylinder {
      <0, 0, -.2>,
      <0, 0, Clock_Total_Depth + .1>,
      .05
    }
    box {
      <0, 0, -.1>,
      <.05, .05, Clock_Total_Depth >
    }
  }
  box {
    <-.1, -.1, -.2>,
    <.2, .2, 0>

    rotate 45*y
    translate <0, 0, 0 >
  }
}

#declare clock_vtop_rail_front = difference {
  intersection {
    cylinder {
      < -.8, 0, 0 >,
      <  .8, 0, 0 >,
      .05
    }
    box {
      < -.75, 0, -.1 >,
      <  .75, .1,  .1 >
    }
  }
  box {
    <  0,  -.1, -.2 >,
    < .2, .2,   0 >
    rotate -45*y
    translate < .65, 0, 0 >
  }
  box {
    < -.2,  -.1, -.2 >,
    <   0, .2,   0 >
    rotate 45*y
    translate < -.65, 0, 0 >
  }
}

#declare clock_vtop_raw = union {
  // The cap.
  intersection {
    cylinder {
      < 0, -.5, -.1 >,
      < 0, -.5, Clock_Total_Depth + .1 >,
      sqrt( .5 )
    }
    box {
      < -.5,  0, 0 >,
      <  .5, .3, Clock_Total_Depth >
    }
  }
  // The BaseBoard
  box {
    < -.65, -.05, 0 >,
    <  .65,   0, Clock_Total_Depth >
  }
  object {
    clock_vtop_rail_side
    translate < .65, -.05, 0 >
  }
  object {
    clock_vtop_rail_side
    scale < -1, 1, 1 >
    translate < -.65, -.05, 0 >
  }
  object {
    clock_vtop_rail_front
    translate < 0, -.05, 0 >
  }
}

#declare clock_vtop_knob = sor {
  9,
  < .05/.7, -0.01 >,
  < .05/.7,  0.00 >,
  < 0.0450,  1/60 >,
  <   1/60,  2/30 >,
  < 0.0450,  0.12 >,
  < 0.0150,  6/30 >,
  < 0.0015,  8/30 >,
  < 0.0000,  0.30 >,
  < 0.0000,  0.35 >
  scale .7
}

#declare clock_vtop = union {
  difference {
    object{ clock_vtop_raw }
    object{ clock_vtop_cut }
  }
  object { clock_vtop_pattern }
  object {
    clock_vtop_knob
    translate < .6, 0, .05 >
  }
  object {
    clock_vtop_knob
    translate < -.6, 0, .05 >
  }
  object {
    clock_vtop_knob
    translate < .6, 0, Clock_Total_Depth - .1 >
  }
  object {
    clock_vtop_knob
    translate < -.6, 0, Clock_Total_Depth - .1 >
  }
}

#declare clock_top_pillar = difference {
  cylinder {
    < 0, -1, 0>,
    < 0,  0, 0>,
    .05
  }
  #declare Indent_Count = 0
  #while (Indent_Count < 12 )
    cylinder {
      < 0, -1.1, 0 >,
      < 0,  0.1, 0 >,
      .05/4
      translate < sin( Indent_Count * 2*pi / 12 ) * .05, 0,
                  cos( Indent_Count * 2*pi / 12 ) * .05 >
    }
    #declare Indent_Count = Indent_Count + 1
  #end
}

#declare clock_top_min_hand = union {
  disc {
    < 0, 0, 0 >,
    < 0, 0, -1 >,
    .0125
  }
  triangle {
    < -.0125,  .000, 0 >,
    <  .0125,  .000, 0 >,
    <  .0000, -.025, 0 >
  }
  triangle {
    < -.0125, .000, 0 >,
    <  .0125, .000, 0 >,
    <  .0000, .325, 0 >
  }
  triangle {
    < -.0125, .275, 0 >,
    <  .0125, .275, 0 >,
    <  .0000, .325, 0 >
  }
}

#declare clock_top_hour_hand = union {
  disc {
    < 0, 0, 0 >,
    < 0, 0, -1 >,
    .01875
  }
  triangle {
    < -.01875,  .000, 0 >,
    <  .01875,  .000, 0 >,
    <  .0000, -.025, 0 >
  }
  triangle {
    < -.01875, .000, 0 >,
    <  .01875, .000, 0 >,
    <  .0000, .225, 0 >
  }
  triangle {
    < -.01875, .175, 0 >,
    <  .01875, .175, 0 >,
    <  .0000, .225, 0 >
  }
}

#declare clock_top_sec_hand = union {
  disc {
    < 0, 0, 0 >,
    < 0, 0, -1 >,
    .0125
  }
  triangle {
    < -.00625, -.025, 0 >,
    <  .00625, -.025, 0 >,
    <  .00000,  .325, 0 >
  }
  triangle {
    < -.00625, -.025, 0 >,
    <  .00625, -.025, 0 >,
    <  .00000, -.050, 0 >
  }
}

#declare clock_top_box = difference {
  box {
    < -.5, -1, 0 >,
    <  .5,  0, Clock_Total_Depth >
  }
  box {
    < -.475, -.975, -.001 >,
    <  .475, -.025,  .025 >
  }
  cylinder {
    < 0, -.5, 0 >,
    < 0, -.5, Clock_Total_Depth - .1 >,
    .4
  }
}
