// This is the file that contains everything for the main body of the
// clock that varies with time. v1.0
//   Created by: Ryan Wellman (firestar@eskimo.com)
// Copyright 1996, Ryan Wellman

#include "clcktvar.inc"

#declare clock_weight_long = union {
  #declare Links = 0
  #declare Length = 0.025
//  #while ( Length < (Clock_Mid_Height * 14/20) )
  #while( Length < (Clock_Mid_Height * (86400 - SECONDS)/90000) )
    torus {
      .025, .004375
      rotate 90 * x
      scale <1, 1, 2>
      rotate 90 * Links * y
      translate <0, -Links * (.05 - 2*.004375), 0 >
    }
    #declare Links = Links + 1
    #declare Length = Length + (.05 - 2*.004375)
  #end
  cylinder {
    <0, -.2, 0 >,
    <0, 0, 0 >,
    .05
    translate < 0, -Links * (.05 - 2*.004375), 0 >
  }
  torus {
    .05, .004375
    rotate 90 * x
    rotate 90 * Links * y
    translate < 0, -Links * (.05 - 2*.004375), 0 >
  }
}

#declare clock_weight_short = union {
  #declare Links = 0
  #declare Length = 0.025
//  #while ( Length < (Clock_Mid_Height * 6/20) )
  #while( Length < (Clock_Mid_Height * (SECONDS + 3600)/90000) )
    torus {
      .025, .004375
      rotate 90 * x
      scale <1, 1, 2>
      rotate 90 * Links * y
      translate <0, -Links * (.05 - 2*.004375), 0 >
    }
    #declare Links = Links + 1
    #declare Length = Length + (.05 - 2*.004375)
  #end
  cylinder {
    <0, -.2, 0 >,
    <0, 0, 0 >,
    .05
    translate < 0, -Links * (.05 - 2*.004375), 0 >
  }
  torus {
    .05, .004375
    rotate 90 * x
    scale <1, 1, 2>
    rotate 90 * Links * y
    translate < 0, -Links * (.05 - 2*.004375), 0 >
  }
}

#declare grandfather_clock = union {
  // The Top of the Clock
  object {
    clock_top
  }

  // The main body of the Clock.
  object {
    clock_box
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }

  // The Pendulum.
  object {
    pendulum
//    rotate degrees(atan2( .12, Clock_Pendulum_Length )) * z
    rotate degrees(atan2( .12 * cos(SECONDS*pi),
                          Clock_Pendulum_Length )) * z
    translate < 0, 0, (Clock_Total_Depth / 2) - .1 >
    texture { T_Brass_5E }
  }

  // The Weights and Chains.
  object {
    clock_weight_long
    texture { T_Brass_5E }
    rotate 42*y
    translate < -.1, 0, (Clock_Total_Depth / 2) >
  }
  object {
    clock_weight_short
    rotate -42*y
    texture { T_Brass_5E }
    translate < .1, 0, (Clock_Total_Depth / 2) >
  }

  // The Door of the Clock.
  object {
    clock_door
  }

  translate < 0, -1.2, 0 >
  translate < 0, (Clock_Body_Height + 1.2) / 2, 0 >
}
