/* File         : Sky.inc
 *
 * Purpose      : The sky
 * Author       : (C)1996 Matthew Hunter
 * Version      : 0.02  (06 May 1996)
 *                0.05  (28 June 1996)
 *                  Release version
 */

#include "GTexts.inc"

// old style sky sphere
object {
  sphere {
    <0,0,0>
    1
  }
  hollow // just in case any halos are used 
  texture {
    pigment {
      gradient y
      colour_map {
        [0.00 colour rgb <0.8,0.6,0.4>]
        [0.10 colour rgb <0.7,0.6,0.5>]
        [0.15 colour rgb <0.6,0.6,0.8>]
        [0.30 colour rgb <0.3,0.6,0.8>]
        [1.00 colour rgb <0.2,0.2,0.6>]
      }
      turbulence 0.05
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
  scale <250000,250000,250000>
}

// Clouds
// put them in a box so they don't curve around with the sky
object {
  box {
    <-250000,5000,-250000>
    < 250000,5500, 250000>
  }
  texture {
    pigment {
      bozo
      colour_map {
        [0.0 colour rgbf <1,1,1,1>]
        [0.7 colour rgbf <1,1,1,1>]
        [1.0 colour rgbf <1,1,1,0.8>]
      }
      turbulence 0.8
    }
    scale <1000,1000,1500>
    rotate <0,37,0>
  }
}

