// Metronome
// Created by the Butter-Fingered Juggler.
// For the POVRAY July 1996 Competition


#include "colors.inc"
#include "textures.inc"
#include "chars.inc"
#include "metro.inc"

camera {
   location  <15, 10, -50>
   look_at   <0, 10, 0>
//   location <0, 0, -10>
//   look_at   <0, 0, 0>
}

// Bright light to left and above main screen
// 2 lights quicker than area and brighter
light_source {<-10, 30, -30> color White}
light_source {<-11, 29, -29> color White}

// --------------------------------------------------

//Casing Top - diffence used to get hollowness
difference {
   object {
      Chop_Pyr
      scale <7, 40, 4>
   }
   object {
      Chop_Pyr
      scale <6, 38, 7>
   }
   texture {DarkWalnut}
}

// Scale Face
object {
   Chop_Pyr
   scale <6, 38, 2>
   texture {GunMetal}
}
object {
   Marking
   rotate < 2.5, 0, 0>
   translate <0, 0, -2.6>
}

// Casing bottom
object {
   Chop_Pyr
   scale <7, -7, 4>
   texture {DarkWalnut}
}

// 'Ticker'
// base
cylinder {<0, 0, -3.8>, <0, 0, -3.5>, 2
         texture {Ticker_Metal}
}
// arm
cylinder {<0, 0, -3.8>, <11, 22, -4.2>, 0.3
         texture {Ticker_Metal}
}
// slider
object {
   Chop_Pyr
   scale <0.6, 3, 0.4>
   rotate <0, 0, 157>
   translate <8.7, 17.7, -4.2>
   texture {Ticker_Metal}
}

// Plaque
object {Plaque
     rotate <-30, 0, 0>
     translate <-3.5, -3, -3.6>
     }

// Sheets of music
// top one
object {Music
        scale <0.5, 0.5, 0.5>
        rotate <90, 0, 0>
        rotate <0, 10, 0>
        rotate <2, 0, 0>
        translate <5, -7, -5>
}
// bottom one
object {Music
        scale <0.5, 0.5, 0.5>
        rotate <90, 0, 0>
        rotate <0, -20, 0>
        rotate <-2, 0, 0>
        translate <3, -7.3, 3>
}

// Background conductors
object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <2, 2, 2>
        rotate <0, -90, 0>
        translate <-30, 0, -5>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <1.7, 1.7, 1.7>
        rotate <0, -60, 0>
        translate <-20, 0, 10>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <1.5, 1.5, 1.5>
        rotate <0, -30, 0>
        translate <-10, 0, 25>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <1.25, 1.25, 1.25>
        translate <0, 0,40>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        rotate <0, 30, 0>
        translate <10, 0, 55>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <0.75, 0.75, 0.75>
        rotate <0, 60, 0>
        translate <20, 0, 70>
}

object {Conductor
        texture {Yellow_Conductor}
        no_shadow
        scale <0.5, 0.5, 0.5>
        rotate <0, 90, 0>
        translate <30, 0, 85>
}

