/*
Bird.pov by Michel van Rossum june 1996
Entry for may/jun 1996 IRTC
Topic: Time

All sources (except vessels.inc) may be used without
authors permission.
*/

#include "colors.inc"
#include "textures.inc"

camera
{
   right     < 1, 0, 0   >  up        < 0, 1, 0   >
   direction < 0, 0, 1 >    location  < 0, 0, -1   >
   rotate    < 50,-25,0>
   translate < 160, 680, -240   >
}

#declare Tafel =
texture
{
  pigment
  {
   spotted  turbulence 0.2
   scale <0.1, 0.1, 5>
   color_map
    {[0.00, 0.40 color red 0.80 green 0.33 blue 0 color red 0.80 green 0.40 blue 0]
     [0.40, 1.01 color red 0.80 green 0.40 blue 0 color red 0.80 green 0.40 blue 0.1]}
  }
  finish { ambient 0.1 diffuse 0.7 reflection 0.2}
  scale < 10, 1, 10 >
}


light_source
{
  <0,0,0> color rgb 1.0
  area_light  <0, 0, 40> <0, 40, 0> , 8, 8
  adaptive 1 jitter
  translate <-100, 650, -150>
}

object
{
   box { < 0, 0, 0 >, < 1, 1, 1 > }

   scale < 1000, 1, 1000 >
   translate < -100, 399, -500 >

   texture { Tafel }
}

#declare VloerTexture =
texture
{
  pigment
  {
   spotted turbulence 0.2
   color_map
    {[0.00, 0.40 color red 0.4 green 0.4  blue 0.4 color red 0.35 green 0.35 blue 0.35]
     [0.40, 1.01 color red 0.4 green 0.4  blue 0.4 color red 0.3 green 0.3 blue 0.33]}
  }
  finish {ambient 0.1 diffuse 0.7}
  scale <20,20,20>
}

object
{  box { < -2000, 0, -5000 >, < 1000, 1, 5000 > }
   texture {VloerTexture}
}// floor

object
{  box { < -50000, 900, -50000 >, < 50000, 901, 50000 > }
   texture { pigment {color White} finish {ambient 0.8}}
}//ceiling

object
{  box { < -50000, -50000, 10000 >, < 50000, 50000, 10001 > }
   texture {pigment {color White} finish {ambient 0.8}}
}//back wall

#include "ashtray.inc"
object {Ashtray rotate <0,20,0> translate <80, 400, -210>}

#include "glas.inc"
object {WhiskyGlas translate <-10, 400, -50>}


#include "druppel.inc"
object {Druppel  rotate <0,-30,0> translate <50 400 50>}

#include "watch.inc"
object {Watch rotate <0,-60,0> translate <170, 400, -120>}

#include "vessels.inc"
object {Bottle scale 200 rotate <0,40,0> rotate <90,-110,0> translate <230, 440, 120>}

