#include "Colors.inc"
#include "Textures.inc"

#declare Metaal_Finish=
  finish
   {Shiny
    ambient 0.2
    diffuse 0.2
    reflection 0.4
   }


#declare Metaal=
texture
{
  pigment {rgb <1 1 1>}
  finish {Metaal_Finish}
}

#declare Goud=
texture
{
  pigment {rgb <1 0.8 0>}
  finish {Metaal_Finish}
}

#declare Glas_Finish=
finish {
    roughness 0.001
    phong 1.0 phong_size 80
    specular 0.8
    ambient 0
    diffuse 0
    refraction 0.8
    reflection 0.1
    ior 1.2
}

#declare Glas2=
texture {pigment {rgbft <1, 1, 1,0.6,0.4>} finish {Glas_Finish}}

#declare Knoppie =
object
{
  difference
  {
      cylinder {<0, 0, 0> <1.5, 0, 0> ,1.5 }
      #declare Count=1
      #declare Aantal=20

      #while (Count < Aantal)
          object{cylinder {<-1, 0, 0> <2, 0, 0> ,0.3} translate <0,1.5*sin(2*pi*Count/Aantal),1.5*cos(2*pi*Count/Aantal)>}
          #declare Count=Count+1
      #end
   }
   texture {Metaal}
}

#declare Body =
object
{
    merge
    {
        cylinder {<0, 1, 0> <0, 5, 0> ,17.5}
        difference
        {
                object {torus { 17, .25 } translate < 0, 5, 0 >}
                cylinder {<0, 4, 0> <0, 6, 0> ,17}
        }
        intersection
        {
           merge
           {
                difference
                {
                   box {<-0.6,1,-20> <3,5,20>}
                   object {cylinder {<0,0,0> <0,6,0>,2} scale <1,1,3.5> translate <-1,0,-20>}
                   object {cylinder {<0,0,0> <0,6,0>,2} scale <1,1,3.5> translate <-1,0,20>}
                   translate <-9,0,0>
                }
                difference
                {
                   box {<-1,1,-20> <2.6,5,20> }
                   object {cylinder {<0,0,0> <0,6,0>,2} scale <1,1,3.5> translate <3,0,-20>}
                   object {cylinder {<0,0,0> <0,6,0>,2} scale <1,1,3.5> translate <3,0,20>}
                   translate <9,0,0>
                }
           }
           object {sphere {<0,3,0> 30} scale <0.7,0.2,1>}
        }
        cylinder {<-8, 3.5, -18.5> <8, 3.5, -18.5> ,0.5} //asje
        cylinder {<-8, 3.5, 18.5> <8, 3.5, 18.5> ,0.5} //asje
    }
    texture {Metaal}
}


#declare Face =
object
{
  cylinder {<0, 5, 0> <0, 5.001, 0> ,17}
  texture { pigment {image_map {gif "klok.gif" map_type 0} scale <34,34,34> rotate <90,0,0> translate <-17,0,17>} finish  {Dull} }
}

#declare Hourhand =
object
{
  box {<-0.1,0,0> <0.1,0.1,10>}
  texture { pigment {rgb <0.1,0.1,0.1>} finish  {Dull} }
//  texture { Metaal}
}

#declare Minutehand =
object
{
  box {<-0.07,0,0> <0.07,0.1,15>}
  texture { pigment {rgb <0.1,0.1,0.1>} finish  {Dull} }
//  texture { Metaal}
}

#declare Dopje =
object
{
  intersection
  {
    intersection
    {
      object {sphere {<0,-10,0>,13} scale <3,1,3> }
      cylinder {<0, 0, 0> <0, 3, 0> ,17}
    }
    intersection
    {
      object {sphere {<0,-10.5,0>,13} scale <3,1,3> }
      cylinder {<0, 0, 0> <0, 2, 0> ,17}
    }
  }
  texture {Glas2}
}
#declare BovenBandje =
object
{
  merge
  {
    difference
    {
      object {cylinder {<-6, 0, 0> <7.8, 0, 0> ,35} scale <1,0.6,1> translate <0,0,35> rotate <17,0,0>}
      object {cylinder {<-8.1, 0, 0> <8.1, 0, 0> ,35} scale <1,0.6,1> translate <0,-0.5,35> rotate <17,0,0>}
      object {cylinder {<0, -6, 0> <0, 20, 0> ,80} scale <0.03,1,1> translate <-6,1,80>}
      object {cylinder {<0, -6, 0> <0, 20, 0> ,80} scale <0.03,1,1> translate <7.8,1,80>}
      texture { pigment {rgb <0,0,0>} finish  {Dull}  normal {crackle 0.5} scale <2,2,2>}
    }
    merge
    {
      intersection
      {
      difference
       {
          box {<-6.1,-3.5,60> <7.9,10,75>}
          box {<-5.1,-3.6,61.5> <6.9,11,73.5>}
       }
       difference
       {
          cylinder {<-7  , -15, 67.50> < 9, -15, 67.50> ,15}
          cylinder {<-7.1, -17, 67.50> <9.1,-17, 67.50> ,15}
       }
      }
      cylinder {<0.9, 0, 62> <0.9,3, 75> ,0.68}
      texture { Goud }
   }
  }
}

#declare OnderBandje =
object
{
  difference
  {
    object {cylinder {<-6, 0, 0> <7.8, 0, 0> ,35} scale <1,0.6,1> translate <0,0,-35> rotate <-15,0,0>}
    object {cylinder {<-8.1, 0, 0> <8.1, 0, 0> ,35} scale <1,0.6,1> translate <0,-0.5,-35> rotate <-15,0,0>}
    object {cylinder {<0, -6, 0> <0, 20, 0> ,80} scale <0.03,1,1> translate <-6,1,-80>}
    object {cylinder {<0, -6, 0> <0, 20, 0> ,80} scale <0.03,1,1> translate <7.8,1,-80>}
  }
  texture { pigment {rgb <0,0,0>} finish  {Dull} normal {crackle 0.5} scale <2,2,2> }
}

#declare Watch =
object
{
  union
  {
    object {OnderBandje translate <0,3.5,-18>}
    object {BovenBandje translate <0,3.5,18>}
    object {Body}
    object {Face}
    object {Dopje translate <0,4,0>}
    object {Hourhand rotate <0,150,0> translate <0,5.1,0>}
    object {Minutehand rotate <0,60,0> translate <0,5.1,0>}
    object {Knoppie translate <17.5,3,0>}
  }
}


