#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
   location <0,0,-50>
   look_at <0,0,0>
}

plane {
   <0,0,-1>,0
   texture {
      pigment {
        marble
        color_map {
          [0 color SpicyPink]
          [.3 color Clear]
        }
      scale 2
      turbulence .5
      }
      finish {ambient 1 diffuse 0}
      rotate <0,0,90>
      translate <0,-1,0>
   }
   clipped_by {
      plane {
         <0,1,0>,.8
      }
      plane {
         <0,-1,0>,.7
      }
   }
   hollow
   scale 20
   rotate <0,45,0>
   translate <10,20,50>
}

sphere {
   <0,0,0>,1
   texture {Starfield finish {diffuse 0 reflection 0}}
   scale 1000000
   hollow
   no_shadow
}

sphere {
   <0,0,0>,1
   texture {pigment {color DarkBrown}}
   texture {
      bozo
      texture_map {
         [0  pigment {
                granite
                color_map {
                   [0.0 color Tan]
                   [0.4 color White]
                   [0.6 color Tan]
                   [0.8 color DarkTan]
                   [1.0 color Tan]
                }
                scale 5
             }       
             finish {ambient .4 reflection 0}
         ]
         [.9 Water finish {ambient 1 diffuse 1 reflection 0}]
      }
   }
   scale 15
   translate <-20,-20,0>
}


sphere {
   <0,0,0>,1
   pigment {color rgbt <1,1,1,1>}
   halo {
      spherical_mapping
      emitting
      constant  
      color_map {
         [0 color rgbt <1,1,.5,.7>]
                 
      }
      samples 20       
   }  
   hollow
   scale 20
   translate <30,0,50>
}

sphere {
   <0,0,0>,1
   texture {
      pigment {
         spotted
         turbulence .5
         color_map {
            [0 color rgbt <1,.7,.5,0>]
            [1 color rgbt <1,1,.5,0>]
         }
      scale 1/14
      }  
      finish {ambient 1 diffuse 0}
   }
   scale 14
   translate <30,0,50>
   hollow
}

light_source {<30,30,30> color White}














