#include "glass.inc"

difference
{
   sphere{
      <0,0,0>, 15
   }//sphere
   sphere{
      <0,0,0>, 12
   }//sphere
   texture{ T_Glass3 }
   translate <-10.7,-.5,0>
}//difference

#declare C_pt = <0,0,0>
#declare Placement = <-9.4,-3.4,-.75>
#declare Hour = 3
#declare Min =   22
#declare Sec =     34
#declare s_hand = Sec * 6                    //time into degrees
#declare m_hand = Sec * .1 + Min * 6
#declare h_hand = Sec * (.5/60) + Min * .5 + Hour * 30

union
{
   union
   {
      cone{
         C_pt, .28
         <C_pt.x,C_pt.y+4,C_pt.z>, 0
         scale <1,1,.1>
         rotate <0,0,h_hand>
         translate <0,0,.1*.4>
      }//cone, hour hand
      cone{
         C_pt, .16
         <C_pt.x,C_pt.y+5,C_pt.z>, 0
         scale <1,1,.1>
         rotate <0,0,m_hand>
      }//cone, minute hand
      cone{
         C_pt, .09
         <C_pt.x,C_pt.y+5,C_pt.z>, 0
         scale <1,1,.1>
         rotate <0,0,s_hand>
         translate <0,0,-.2*.1>  
      }//cone, second hand
      pigment{ color Black}
      finish{ reflection .4 }
      translate Placement
   }//union2

   text{
      ttf "test.ttf",
      "a",
      .75, 0
      texture { T_Ruby_Glass }
      scale <100,100,2>
      translate <-1,0,0>
      rotate <0,180,0>
   }//text
}//union1
