// Scene File: PHOUR2.POV, for POV-Ray v2.x
//
// Generated With POVCAD 4 (c) Alfonso Hermida 1993 - 1995
//                         (c) Robert McGregor 1993 - 1995
//
// Created on 6/29/96 at 12:50 am

#include "bands.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"
#include "shapes2.inc"
#include "povcolr.inc"
#include "pov2tex.inc"

camera {
  right     <2.5, 0, 0>
  up        <0, 3.5, 0>
  direction <0, -2.0, 0> //0,2.5,1.5
  location  <2.0 , 2.0 , 3.5>
  look_at   <0, -1 , 0>
}


//Textures
#declare Blue_Swirl = 
texture {
  pigment {
    agate
    color_map {
      [0.5 color Blue]
      [0.6 color Clear]
      [0.5 color MidnightBlue]
      [0.6 color Clear]
    }
  }
} // End Texture

#declare Vein_Glass =
texture {Glass3 
         pigment {color Vein filter .9}}

#declare BV_Layer =
    texture {Vein_Glass}
    texture {Blue_Swirl}
        
         
#declare Cone_Swirl = 
texture {
  pigment {
    gradient z
    color_map {
      [0.2 color Vein]
      [0.3 color BlueViolet]
      [0.2 color CoolCopper]
      [0.3 color Coral]
    }
    turbulence 2.9
    frequency 4
    phase 3.8
  }
  normal {
    waves 3.4
  }
  finish {
    reflection 0.8
  }
} // End Texture

//Main Objects
object {
  union {
    // CONE
    cone { <0, -1.0, 0>, 0.5, <0, 0, 0>, 0
      scale <1.3, 1.0, 1.3>
      rotate <-180.0, 0.0, 180.0>
      texture {Glass3}
    }
    
    // CONE
    cone { <0, -1.0, 0>, 0.5, <0, 0, 0>, 0
      scale <1.3, 1.0, 1.3>
      rotate <0.0, 0.0, 180.0>
      texture {Glass3}
    }
    
    // CYLINDER
    cylinder {<0, -1.0, 0>, <0, 1.0, 0>, 0.2
      scale <0.5, 1.0, 0.5>
      translate <0.75, 0.0, 0.0>
      texture {Red_Marble}
    }
    
    // CYLINDER
    cylinder {<0, -1.0, 0>, <0, 1.0, 0>, 0.2
      scale <0.5, 1.0, 0.5>
      translate <0.0, 0.0, -0.75>
      texture {Red_Marble}
    }
    
    // CYLINDER
    cylinder {<0, -1.0, 0>, <0, 1.0, 0>, 0.2
      scale <0.5, 1.0, 0.5>
      translate <-0.75, 0.0, 0.0>
      texture {Red_Marble}
    }
    
    // CYLINDER
    cylinder {<0, -1.0, 0>, <0, 1.0, 0>, 0.2
      scale <0.5, 1.0, 0.5>
      translate <0.0, 0.0, 0.75>
      texture {Red_Marble}
    }
    
  }
}

// ELLIPSOID
sphere {<0, 0, 0>, 1
  scale <0.25, 0.5, 0.25>
  texture {Green_Glass}
}

// CYLINDER
cylinder {<0, -0.0625, 0>, <0, 0.0625, 0>, 0.5
  scale <2.0, 0.75, 2.0>
  translate <0.0, 1.0, 0.0>
  texture {DMFLightOak}
}

// CYLINDER
cylinder {<0, -0.0625, 0>, <0, 0.0625, 0>, 0.5
  scale <2.0, 0.75, 2.0>
  translate <0.0, -1.0, 0.0>
  texture {DMFLightOak}
}

// LIGHT_SOURCE
light_source {<0.0, 0.0, 0.0> color BrightGold 
              looks_like {object {bands}}}

// CONE
cone { <0, -0.3, 0>, 0.1, <0, 0, 0>, 0
  translate <0.75, 1.3, 0.0>
  texture {Gold_Metal}
}

// CONE
cone { <0, -0.3, 0>, 0.1, <0, 0, 0>, 0
  translate <0.0, 1.3, -0.75>
  texture {Gold_Metal}
}

// CONE
cone { <0, -0.3, 0>, 0.1, <0, 0, 0>, 0
  translate <-0.75, 1.3, 0.0>
  texture {Gold_Metal}
}

// CONE
cone { <0, -0.3, 0>, 0.1, <0, 0, 0>, 0
  translate <0.0, 1.3, 0.75>
  texture {Gold_Metal}
}

// SPHERE
sphere {<0.0, -1.0, 0.0>, 0.5
  texture {Sapphire_Agate}
}

object {
  difference {
     union {
    // PLANE AND LIGHT PLANE
    plane { <0, 1, 0>, 0 
      scale <3.5, 1.0, 3.5>
      translate <0.0, -2.0, 0.0>
      texture {BV_Layer}}

    light_source {<0, -2.1, 0> color Clear
                  looks_like {plane {<0, 1, 0>, -2.1} 
                  pigment {color BrightGold} finish {Luminous}}}
     }


    
    // CONE
    cone { <0, -2.0, 0>, 1.0, <0, 0, 0>, 0
      scale <1.5, 1.0, 1.5>
      rotate <0.0, 0.0, 180.0>
      translate <0.0, -4.0, 0.0>
      texture {Cone_Swirl}
    }
    
  }
}

