// This is a Persistence of Vision Ray Tracer (POV-Ray) Version 2.2 Scene file
//             POV-Ray is (Copyrighted) 1994-95, POV-Ray Team
//
// This file was generated using "Mid Night Modeller" Version 2.10
//             MNM is (Copyright) 1994-95, David R.Taylor
//
//
//******************************** HEADER *************************************
#include "colors.inc"
#include "textures.inc"

// User defined include files

#include "stones.inc"
#include "mnm.inc"


#max_trace_level 5
#max_intersections 100

fog {
    color rgb<0.5, 0.5, 0.5>
    distance 10000
}

background { color rgb<0, 1, 1> }


//****************** CAMERA **********************

camera {
    location <0, 5, -13>
   direction <0, 0, 1.07225>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <0, 4, 7>
}


//****************** TEXTURES ********************


#declare Plane_White = texture {
    pigment { color rgbf<1, 1, 1, 0>
    }
}

#declare Plane_Brown = texture {
    pigment { color rgbf<0.4, 0.4, 0, 0>
    }
    finish {
        diffuse 1
        ambient 0.5
    }
}

#declare bigsky = texture {
    pigment { granite
        color_map {
            [0  color rgbf<0.3, 0.3, 1, 0>]
            [0.4  color rgbf<0.3, 0.3, 1, 0>]
            [0.7  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.99  color rgbf<0.95, 0.95, 1, 0>]
        }
        turbulence 0.2
        octaves 6
        omega 0.7
        lambda 2
    }
    finish {
        ambient 1
    }
}

#declare Fire1 = texture {
    pigment { granite
        color_map {
            [0  color rgbf<1, 1, 1, 0>]
            [0.1  color rgbf<0.556863, 0.137255, 0.137255, 0>]
            [0.9  color rgbf<1, 1, 0, 0>]
            [0.9  color rgbf<1, 1, 1, 1>]
            [1  color rgbf<1, 1, 1, 1>]
        }
        scale <2, 6, 2>
    }
    normal {
        waves 0.9
        turbulence 1
        octaves 6
        omega 0.5
        lambda 2
    }
    finish {
        ambient 1
    }
    scale <2, 6, 2>
}

#declare Green_speckle = texture {
    pigment { spotted
        color_map {
            [0  color rgbf<0, 1, 0.5, 0>]
            [0  color rgbf<0, 0.7, 0, 0>]
        }
    }
    scale <0.2, 0.2, 0.2>
}

#declare Black_window = texture {
    pigment { color rgbf<0.1, 0.1, 0.1, 0>
    }
    normal {
        dents 0.001
    }
    finish {
        brilliance 1
        reflection 0.3
        phong 1  phong_size 5
        metallic
    }
}

#declare Shuttle = texture {
    pigment { bozo
        color_map {
            [0  color rgbf<0.4, 0.4, 0.4, 0>]
            [0.35  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.99  color rgbf<1, 1, 1, 0>]
        }
        scale <0.6, 0.3, 0.3>
    }
    finish {
        specular 0.3  roughness 0.05
        metallic
    }
    scale <1, 10, 1>
}

#declare Shuttle_iron = texture {
    pigment { bozo
        color_map {
            [0  color rgbf<0.2, 0.2, 0.2, 0>]
            [0.3  color rgbf<0.3, 0.3, 0.3, 0>]
            [0.35  color rgbf<0.4, 0.4, 0.4, 0>]
        }
        turbulence 0.1
        octaves 6
        omega 0.5
        lambda 2
        scale <0.2, 1, 0.2>
    }
    finish {
        specular 0.5  roughness 0.05
        metallic
    }
}

#declare Spotty_steel = texture {
    pigment { spotted
        color_map {
            [0  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.5  color rgbf<0.75, 0.75, 0.75, 0>]
            [0.5  color rgbf<0.6, 0.6, 0.6, 0>]
            [0.99  color rgbf<0.6, 0.6, 0.6, 0>]
        }
        turbulence 0.3
        octaves 6
        omega 0.5
        lambda 2
    }
    normal {
        wrinkles 0.5
    }
    finish {
        reflection 0.5
        specular 1  roughness 0.005
        metallic
    }
}

#declare Green_iron = texture {
    pigment { marble
        color_map {
            [0  color rgbf<0.2, 0.4, 0.1, 0>]
            [0  color rgbf<0.1, 0.3, 0.05, 0>]
        }
        scale <0.1, 0.1, 0.1>
    }
    finish {
        diffuse 0.6
        ambient 0.5
        phong 1  phong_size 150
        specular 2  roughness 0.05
        metallic
    }
}

#declare Lighttan_dirt = texture {
    pigment { granite
        color_map {
            [0  color rgbf<0.7, 0.7, 0.6, 0>]
            [0.3  color rgbf<0.5, 0.5, 0.4, 0>]
        }
    }
}

#declare America_flad_fade = texture {
    pigment {
        image_map {
            gif "amflag.gif"
            map_type 0
        }
    }
    normal {
        wrinkles 0.25
    }
    rotate <90, 90, 0>
}

#declare Semi_smooth_steel = texture {
    pigment { color rgbf<0.5, 0.5, 0.5, 0>
    }
    normal {
        dents 0.25
    }
    finish {
        reflection 0.5
        specular 1  roughness 0.001
        metallic
    }
    rotate <90, 90, 0>
}

#declare Yellow_rope = texture {
    pigment { wood
        color_map {
            [0  color rgbf<0.8, 0.8, 0, 0>]
            [0.8  color rgbf<0.7, 0.7, 0, 0>]
            [0.99  color rgbf<0.3, 0.3, 0, 0>]
        }
    }
    normal {
        wrinkles 1
    }
    finish {
        reflection 0.5
        specular 1  roughness 0.001
        metallic
    }
    scale <0.5, 0.5, 0.5>
    rotate <90, 90, 0>
}

#declare Blue_rock = texture {
    pigment { color rgbf<0.2, 0.2, 1, 0.2>
    }
    finish {
        specular 1  roughness 0.001
        refraction 0.5  ior 1.5
        metallic
    }
    scale <0.5, 0.5, 0.5>
    rotate <90, 90, 0>
}


//****************** BLOCK LAYERS ****************



//****************** ACTION **********************


union {  // Layer name: cars
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0  
        texture { Fire1 }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 47>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 4, 0.0>, 0  
        texture { Green_speckle }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 47>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        scale <1, 1, 2>
        rotate <.0, 180, .0>
        translate <-15, 7, 30>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -42.7167>
        rotate <.0, 180, .0>
        translate <-11.7903, 2.73204, 40.25>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -317.291>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 40.25>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-12, 3, 37.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 37.5>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -216.285>
        rotate <.0, 180, .0>
        translate <-12, 3, 40>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -318.814>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 40>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 14, 0.0>, 2.5  
        texture { Green_speckle }
        rotate <90, .0, .0>
        rotate <.0, 3.87336e-08, .0>
        translate <-15, 6.5, 33>
    }
    sphere { <0.0, 0.0, 0.0>, 1.5 
        texture { Green_speckle }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 33>
    }
    sphere { <0.0, 0.0, 0.0>, 1.5 
        texture { Green_speckle }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 106>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 14, 0.0>, 2.5  
        texture { Green_speckle }
        rotate <90, .0, .0>
        rotate <.0, 3.87336e-08, .0>
        translate <-15, 6.5, 106>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -318.814>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 113>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -216.285>
        rotate <.0, 180, .0>
        translate <-12, 3, 113>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 110.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-12, 3, 110.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -317.291>
        rotate <.0, 180, .0>
        translate <-18.5, 3, 113.25>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -42.7167>
        rotate <.0, 180, .0>
        translate <-11.7903, 2.73204, 113.25>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        scale <1, 1, 2>
        rotate <.0, 180, .0>
        translate <-15, 7, 103>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 4, 0.0>, 0  
        texture { Green_speckle }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 120>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0  
        texture { Fire1 }
        rotate <270, .0, .0>
        rotate <.0, 180, .0>
        translate <-15, 6.5, 120>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1, 0.0>, 0  
        texture { Fire1 }
        rotate <270, .0, .0>
        translate <15, 6.5, 55.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 4, 0.0>, 0  
        texture { Green_speckle }
        rotate <270, .0, .0>
        translate <15, 6.5, 55.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        scale <1, 1, 2>
        translate <15, 7, 72.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -42.7167>
        translate <11.7903, 2.73204, 62.25>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 4.94975, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -317.291>
        translate <18.5, 3, 62.25>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        translate <12, 3, 65>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <270, .0, .0>
        translate <18.5, 3, 65>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -216.285>
        translate <12, 3, 62.5>
    }
    torus { 2, 0.5 
        texture { Plane_Brown }
        scale <1, 1, 1.25>
        rotate <.0, .0, -318.814>
        translate <18.5, 3, 62.5>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 14, 0.0>, 2.5  
        texture { Green_speckle }
        rotate <90, .0, .0>
        rotate <.0, 180, .0>
        translate <15, 6.5, 69.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1.5 
        texture { Green_speckle }
        scale <1, 1, 5>
        translate <15, 6.5, 69.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1.98011 
        texture { Semi_smooth_steel }
        scale <1, 1, 6>
        translate <24.5, 4, 331.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { Black_window }
        scale <1, 1, 3>
        translate <24.5, 5, 338>
    }
    torus { 1, 0.1 
        rotate <90, .0, .0>
        translate <24.5, 5, 338>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 30>
        translate <21, 1.3, 323.5>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 330>
        translate <25, 3, 323.5>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        translate <28, 1.5, 326>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        translate <21, 1.5, 326>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-20.5, 1.5, 268.5>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-27.5, 1.5, 268.5>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 330>
        rotate <.0, 180, .0>
        translate <-24.5, 3, 271>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 30>
        rotate <.0, 180, .0>
        translate <-20.5, 1.3, 271>
    }
    torus { 1, 0.1 
        rotate <90, .0, .0>
        rotate <.0, 180, .0>
        translate <-24, 5, 256.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { Black_window }
        scale <1, 1, 3>
        rotate <.0, 180, .0>
        translate <-24, 5, 256.5>
    }
    sphere { <0.0, 0.0, 0.0>, 1.98011 
        texture { Semi_smooth_steel }
        scale <1, 1, 6>
        rotate <.0, 180, .0>
        translate <-24, 4, 263>
    }
    sphere { <0.0, 0.0, 0.0>, 1.98011 
        texture { Semi_smooth_steel }
        scale <1, 1, 6>
        rotate <.0, 180, .0>
        translate <-24, 4, 73>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { Black_window }
        scale <1, 1, 3>
        rotate <.0, 180, .0>
        translate <-24, 5, 66.5>
    }
    torus { 1, 0.1 
        rotate <90, .0, .0>
        rotate <.0, 180, .0>
        translate <-24, 5, 66.5>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 30>
        rotate <.0, 180, .0>
        translate <-20.5, 1.3, 81>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 330>
        rotate <.0, 180, .0>
        translate <-24.5, 3, 81>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-27.5, 1.5, 78.5>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        rotate <.0, 180, .0>
        translate <-20.5, 1.5, 78.5>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        translate <21, 1.5, 26>
    }
    sphere { <0.0, 0.0, 0.0>, 0.75 
        texture { Green_iron }
        scale <1, 1, 5>
        translate <28, 1.5, 26>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 330>
        translate <25, 3, 23.5>
    }
    box { <0.0, 0.0, 0.0>, <3.5, 0.5, 5> 
        texture { Spotty_steel }
        rotate <.0, .0, 30>
        translate <21, 1.3, 23.5>
    }
    torus { 1, 0.1 
        rotate <90, .0, .0>
        translate <24.5, 5, 38>
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { Black_window }
        scale <1, 1, 3>
        translate <24.5, 5, 38>
    }
    sphere { <0.0, 0.0, 0.0>, 1.98011 
        texture { Semi_smooth_steel }
        scale <1, 1, 6>
        translate <24.5, 4, 31.5>
    }
}

union {  // Layer name: roads
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <-20, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <19, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <-11, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <-30, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <29, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <1, 2, 5000> 
        texture { Plane_White }
        translate <10, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <20, 1, 5000> 
        texture { Shuttle_iron }
        translate <-30, 0, -50>
    }
    box { <0.0, 0.0, 0.0>, <20, 1, 5000> 
        texture { Shuttle_iron }
        translate <10, 0, -50>
    }
}

union {  // Layer name: city
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { Blue_rock }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <112, 352.455, 1525>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 26, 0.0>, 0.5  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <112, 196.455, 1525>
    }
    sphere { <0.0, 0.0, 0.0>, 5.09902 
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <112, 172.455, 1525>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 158.629, .0>
        translate <79.2888, -7.63181, 1512.2>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 68.6294, .0>
        translate <124.8, -7.63181, 1492.29>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 248.629, .0>
        translate <99.2, -7.63181, 1557.71>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 338.629, .0>
        translate <144.711, -7.63181, 1537.8>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 338.629, .0>
        translate <-632.289, -7.63181, 1851.8>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 248.629, .0>
        translate <-677.8, -7.63181, 1871.71>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 68.6294, .0>
        translate <-652.2, -7.63181, 1806.29>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 158.629, .0>
        translate <-697.711, -7.63181, 1826.2>
    }
    sphere { <0.0, 0.0, 0.0>, 5.09902 
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-665, 172.455, 1839>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 26, 0.0>, 0.5  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-665, 196.455, 1839>
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { Blue_rock }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-665, 352.455, 1839>
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 30, 0.0>, 1  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <265, -1.5453, 2151>
    }
    sphere { <0.0, 0.0, 0.0>, 6 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <265, 418.455, 2151>
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 24, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <265, 274.455, 2151>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 16, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <265, 178.455, 2151>
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { Blue_rock }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <474, 352.455, 1901>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 26, 0.0>, 0.5  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <474, 196.455, 1901>
    }
    sphere { <0.0, 0.0, 0.0>, 5.09902 
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <474, 172.455, 1901>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 25.477, .0>
        translate <505.711, -7.63181, 1885.89>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 295.477, .0>
        translate <489.11, -7.63181, 1932.71>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 115.477, .0>
        translate <458.89, -7.63181, 1869.29>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 205.477, .0>
        translate <442.289, -7.63181, 1916.11>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 205.477, .0>
        translate <251.289, -7.63181, 1860.11>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 115.477, .0>
        translate <267.89, -7.63181, 1813.29>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 295.477, .0>
        translate <298.11, -7.63181, 1876.71>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 25.477, .0>
        translate <314.711, -7.63181, 1829.89>
    }
    sphere { <0.0, 0.0, 0.0>, 5.09902 
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <283, 172.455, 1845>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 26, 0.0>, 0.5  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <283, 196.455, 1845>
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { Blue_rock }
        scale <6, 6, 6>
        rotate <.0, 205.477, .0>
        translate <283, 352.455, 1845>
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { Blue_rock }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-401, 352.455, 2007>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 26, 0.0>, 0.5  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-401, 196.455, 2007>
    }
    sphere { <0.0, 0.0, 0.0>, 5.09902 
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, 338.629, .0>
        translate <-401, 172.455, 2007>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 158.629, .0>
        translate <-433.711, -7.63181, 1994.2>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 68.6294, .0>
        translate <-388.2, -7.63181, 1974.29>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 248.629, .0>
        translate <-413.8, -7.63181, 2039.71>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 30, 0.0>, 3  
        texture { Shuttle }
        scale <6, 6, 6>
        rotate <.0, .0, -348.69>
        rotate <.0, 338.629, .0>
        translate <-368.289, -7.63181, 2019.8>
    }
    cone { <0.0, 0.0, 0.0>, 12.083, <0.0, 29.1204, 0.0>, 12.083  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-365, -1.5453, 1785>
    }
    sphere { <0.0, 0.0, 0.0>, 12 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-365, 172.455, 1785>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 46.0109, 0.0>, 0  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-365, 208.455, 1785>
    }
    cone { <0.0, 0.0, 0.0>, 14, <0.0, 55, 0.0>, 14  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-257, 0, 2205>
    }
    cone { <0.0, 0.0, 0.0>, 13, <0.0, 28.178, 0.0>, 10.0499  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-257, 330, 2205>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-257, 498, 2228.89>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-280.886, 498, 2205>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-257, 498, 2181.11>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-233.114, 498, 2205>
    }
    torus { 6, 1 
        texture { Shuttle_iron }
        scale <6, 6, 6>
        translate <-257, 543.467, 2205>
    }
    torus { 6, 1 
        texture { Shuttle_iron }
        scale <6, 6, 6>
        translate <-257, 615.467, 2205>
    }
    sphere { <0.0, 0.0, 0.0>, 8 
        texture { Blue_rock }
        scale <6, 6, 6>
        translate <-257, 704.906, 2205>
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 30, 0.0>, 1  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-167, -1.5453, 1725>
    }
    sphere { <0.0, 0.0, 0.0>, 6 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-167, 418.455, 1725>
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 24, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-167, 274.455, 1725>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 16, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-167, 178.455, 1725>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 16, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-119, 178.455, 2037>
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 24, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-119, 274.455, 2037>
    }
    sphere { <0.0, 0.0, 0.0>, 6 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-119, 418.455, 2037>
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 30, 0.0>, 1  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-119, -1.5453, 2037>
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 30, 0.0>, 1  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-251, -1.5453, 1881>
    }
    sphere { <0.0, 0.0, 0.0>, 6 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-251, 418.455, 1881>
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 24, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-251, 274.455, 1881>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 16, 0.0>, 6  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <-251, 178.455, 1881>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 46.0109, 0.0>, 0  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <151, 208.455, 1665>
    }
    sphere { <0.0, 0.0, 0.0>, 12 
        texture { Shuttle }
        scale <6, 6, 6>
        translate <151, 172.455, 1665>
    }
    cone { <0.0, 0.0, 0.0>, 12.083, <0.0, 29.1204, 0.0>, 12.083  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <151, -1.5453, 1665>
    }
    sphere { <0.0, 0.0, 0.0>, 8 
        texture { Blue_rock }
        scale <6, 6, 6>
        translate <124, 704.906, 2009>
    }
    torus { 6, 1 
        texture { Shuttle_iron }
        scale <6, 6, 6>
        translate <124, 615.467, 2009>
    }
    torus { 6, 1 
        texture { Shuttle_iron }
        scale <6, 6, 6>
        translate <124, 543.467, 2009>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <147.886, 498, 2009>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <124, 498, 1985.11>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <100.114, 498, 2009>
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 30, 0.0>, 2  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <124, 498, 2032.89>
    }
    cone { <0.0, 0.0, 0.0>, 13, <0.0, 28.178, 0.0>, 10.0499  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <124, 330, 2009>
    }
    cone { <0.0, 0.0, 0.0>, 14, <0.0, 55, 0.0>, 14  
        texture { Shuttle }
        scale <6, 6, 6>
        translate <124, 0, 2009>
    }
}

union {  // Layer name: grid
    cone { <0.0, 0.0, 0.0>, 0.01, <0.0, 10, 0.0>, 0.01  
        texture { Yellow_rope }
        rotate <.0, .0, -270>
        translate <5, 1, 4.98104>
    }
    cone { <0.0, 0.0, 0.0>, 0.01, <0.0, 10, 0.0>, 0.01  
        texture { Yellow_rope }
        rotate <.0, .0, -270>
        rotate <.0, 90, .0>
        translate <4.98104, 1, -5>
    }
    cone { <0.0, 0.0, 0.0>, 0.01, <0.0, 10, 0.0>, 0.01  
        texture { Yellow_rope }
        rotate <.0, .0, -270>
        rotate <.0, 90, .0>
        translate <-5.01896, 1, -5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <5, 1.04203, 5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <5, 1.0205, 5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <-5, 1.0205, 5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <-5, 1.04203, 5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <-5, 1.04203, -5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <-5, 1.0205, -5>
    }
    cone { <0.0, 0.0, 0.0>, 0.01, <0.0, 10, 0.0>, 0.01  
        texture { Yellow_rope }
        rotate <.0, .0, -270>
        translate <5, 1, -5.01896>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <5, 1.0205, -5>
    }
    torus { 0.055, 0.01 
        texture { Yellow_rope }
        translate <5, 1.04203, -5>
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 2, 0.0>, 0.05  
        texture { DMFWood1 }
        translate <-5, 0, -5.00062>
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 2, 0.0>, 0.05  
        texture { DMFWood1 }
        translate <-5, 0, 4.99938>
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 2, 0.0>, 0.05  
        texture { DMFWood1 }
        translate <5, 0, 4.99938>
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 2, 0.0>, 0.05  
        texture { DMFWood1 }
        translate <5, 0, -5.00062>
    }
}

union {  // Layer name: trowellB
    union { // Poly_Mesh
        smooth_triangle {<0.106584, 0.469267, -4.25402>, <-1.45749e-05, 4.69215e-05, 7.17863e-05>,
                         <0.100006, 0.449707, -4.24257>, <-1.57159e-05, 7.05856e-05, 9.0179e-05>,
                         <0.103347, 0.44873, -4.24125>, <-1.45749e-05, 4.69215e-05, 7.17863e-05> }
        smooth_triangle {<0.103347, 0.44873, -4.24125>, <-8.64291e-06, 2.34607e-05, 3.55495e-05>,
                         <0.106559, 0.46932, -4.25392>, <-2.71094e-06, -4.88212e-18, -6.87272e-07>,
                         <0.106584, 0.469267, -4.25402>, <-8.64291e-06, 2.34607e-05, 3.55495e-05> }
        smooth_triangle {<0.100006, 0.449707, -4.24257>, <-1.57159e-05, 7.05856e-05, 9.0179e-05>,
                         <0.0926171, 0.432718, -4.22792>, <-1.61456e-05, 0.00014767, 0.000137674>,
                         <0.099286, 0.430847, -4.22523>, <-1.81645e-05, 0.00011755, 0.000127117> }
        smooth_triangle {<0.099286, 0.430847, -4.22523>, <-1.30338e-05, 8.82156e-05, 9.54201e-05>,
                         <0.103347, 0.44873, -4.24125>, <-1.1239e-05, 5.29013e-05, 6.77546e-05>,
                         <0.100006, 0.449707, -4.24257>, <-1.37627e-05, 6.76595e-05, 8.35649e-05> }
        smooth_triangle {<0.0926171, 0.432718, -4.22792>, <-1.61456e-05, 0.00014767, 0.000137674>,
                         <0.0845108, 0.418921, -4.21042>, <-9.64921e-06, 0.000238425, 0.000166005>,
                         <0.0944751, 0.416324, -4.20626>, <-1.1951e-05, 0.000208092, 0.000158526> }
        smooth_triangle {<0.0944751, 0.416324, -4.20626>, <-7.70772e-06, 0.000173775, 0.000132189>,
                         <0.099286, 0.430847, -4.22523>, <-1.08145e-05, 0.000128504, 0.000116484>,
                         <0.0926171, 0.432718, -4.22792>, <-1.29753e-05, 0.000145617, 0.000129718> }
        smooth_triangle {<0.0845108, 0.418921, -4.21042>, <-9.64921e-06, 0.000238425, 0.000166005>,
                         <0.0760233, 0.407412, -4.19139>, <-2.47244e-06, 0.000329633, 0.000186763>,
                         <0.0892709, 0.40421, -4.18573>, <-4.23064e-06, 0.0003001, 0.00017964> }
        smooth_triangle {<0.0892709, 0.40421, -4.18573>, <-6.59309e-07, 0.000263147, 0.000156932>,
                         <0.0944751, 0.416324, -4.20626>, <-4.51951e-06, 0.000217143, 0.000146375>,
                         <0.0845108, 0.418921, -4.21042>, <-6.5089e-06, 0.000235367, 0.00015806> }
        smooth_triangle {<0.0760233, 0.407412, -4.19139>, <-2.47244e-06, 0.000329633, 0.000186763>,
                         <0.0673373, 0.397363, -4.17154>, <4.94811e-06, 0.000420395, 0.000203641>,
                         <0.0838672, 0.393632, -4.16441>, <2.42467e-06, 0.000390007, 0.00019852> }
        smooth_triangle {<0.0838672, 0.393632, -4.16441>, <5.3966e-06, 0.000351485, 0.000177978>,
                         <0.0892709, 0.40421, -4.18573>, <2.06894e-06, 0.000306532, 0.000168538>,
                         <0.0760233, 0.407412, -4.19139>, <2.37805e-07, 0.000325465, 0.000179432> }
        smooth_triangle {<0.0673373, 0.397363, -4.17154>, <4.94811e-06, 0.000420395, 0.000203641>,
                         <0.0584975, 0.388617, -4.15101>, <1.5946e-05, 0.000514264, 0.000211963>,
                         <0.0783139, 0.384425, -4.14251>, <1.16975e-05, 0.000482018, 0.000210378> }
        smooth_triangle {<0.0783139, 0.384425, -4.14251>, <1.39003e-05, 0.000441848, 0.000191645>,
                         <0.0838672, 0.393632, -4.16441>, <9.26386e-06, 0.000395843, 0.000185716>,
                         <0.0673373, 0.397363, -4.17154>, <7.73685e-06, 0.000415716, 0.000195959> }
        smooth_triangle {<0.0584975, 0.388617, -4.15101>, <1.5946e-05, 0.000514264, 0.000211963>,
                         <0.0495201, 0.381286, -4.12976>, <3.46174e-05, 0.000614284, 0.000203947>,
                         <0.0726257, 0.376708, -4.12007>, <2.62866e-05, 0.000578035, 0.00021048> }
        smooth_triangle {<0.0726257, 0.376708, -4.12007>, <2.73638e-05, 0.000535511, 0.00019362>,
                         <0.0783139, 0.384425, -4.14251>, <2.00692e-05, 0.000487502, 0.00019357>,
                         <0.0584975, 0.388617, -4.15101>, <1.90698e-05, 0.000508945, 0.000203163> }
        smooth_triangle {<0.0495201, 0.381286, -4.12976>, <3.46174e-05, 0.000614284, 0.000203947>,
                         <0.0404376, 0.37595, -4.10745>, <6.57595e-05, 0.000721938, 0.00016733>,
                         <0.0667922, 0.371092, -4.09706>, <5.29588e-05, 0.000682268, 0.00018474> }
        smooth_triangle {<0.0667922, 0.371092, -4.09706>, <5.19458e-05, 0.000635216, 0.000170605>,
                         <0.0726257, 0.376708, -4.12007>, <3.86097e-05, 0.0005831, 0.000183475>,
                         <0.0495201, 0.381286, -4.12976>, <3.86962e-05, 0.000607754, 0.000192078> }
        smooth_triangle {<0.0404376, 0.37595, -4.10745>, <6.57595e-05, 0.000721938, 0.00016733>,
                         <0.0315874, 0.37322, -4.08361>, <0.00010418, 0.000819195, 0.000101156>,
                         <0.0608404, 0.368218, -4.07358>, <9.18544e-05, 0.000786029, 0.000124125> }
        smooth_triangle {<0.0608404, 0.368218, -4.07358>, <8.80312e-05, 0.000733284, 0.000114386>,
                         <0.0667922, 0.371092, -4.09706>, <6.85834e-05, 0.000681403, 0.000144693>,
                         <0.0404376, 0.37595, -4.10745>, <7.03717e-05, 0.000711588, 0.000151659> }
        smooth_triangle {<0.0315874, 0.37322, -4.08361>, <0.00010418, 0.000819195, 0.000101156>,
                         <0.0240246, 0.372993, -4.05819>, <0.000132592, 0.000855394, 2.38634e-05>,
                         <0.0548466, 0.367979, -4.04994>, <0.000125591, 0.00084594, 4.49221e-05> }
        smooth_triangle {<0.0548466, 0.367979, -4.04994>, <0.000120727, 0.000798831, 4.09494e-05>,
                         <0.0608404, 0.368218, -4.07358>, <0.000103858, 0.000768876, 8.0551e-05>,
                         <0.0315874, 0.37322, -4.08361>, <0.0001071, 0.000802327, 8.51111e-05> }
        smooth_triangle {<0.0240246, 0.372993, -4.05819>, <0.000132592, 0.000855394, 2.38634e-05>,
                         <0.0188834, 0.374696, -4.03231>, <0.000139592, 0.000794679, -4.06217e-05>,
                         <0.0488671, 0.369772, -4.02636>, <0.000137573, 0.000806515, -2.57526e-05> }
        smooth_triangle {<0.0488671, 0.369772, -4.02636>, <0.000135311, 0.000791407, -2.55159e-05>,
                         <0.0548466, 0.367979, -4.04994>, <0.00012932, 0.000811119, 9.82151e-06>,
                         <0.0240246, 0.372993, -4.05819>, <0.000132706, 0.00083562, 1.15778e-05> }
        smooth_triangle {<0.0188834, 0.374696, -4.03231>, <0.000139592, 0.000794679, -4.06217e-05>,
                         <0.0153651, 0.377805, -4.00719>, <0.000132365, 0.000686002, -7.89339e-05>,
                         <0.0429246, 0.373044, -4.00292>, <0.000132884, 0.000707319, -6.89192e-05> }
        smooth_triangle {<0.0429246, 0.373044, -4.00292>, <0.000133902, 0.000722769, -6.88832e-05>,
                         <0.0488671, 0.369772, -4.02636>, <0.000136246, 0.000772367, -4.73e-05>,
                         <0.0188834, 0.374696, -4.03231>, <0.000138424, 0.000780564, -4.76781e-05> }
        smooth_triangle {<0.0153651, 0.377805, -4.00719>, <0.000132365, 0.000686002, -7.89339e-05>,
                         <0.0124939, 0.382082, -3.9828>, <0.000122097, 0.000582287, -9.86894e-05>,
                         <0.0370312, 0.377547, -3.97967>, <0.000124034, 0.00060747, -9.19317e-05> }
        smooth_triangle {<0.0370312, 0.377547, -3.97967>, <0.000126985, 0.000636678, -9.39803e-05>,
                         <0.0429246, 0.373044, -4.00292>, <0.00013141, 0.000686602, -8.2474e-05>,
                         <0.0153651, 0.377805, -4.00719>, <0.000131758, 0.000680973, -8.32076e-05> }
        smooth_triangle {<0.0124939, 0.382082, -3.9828>, <0.000122097, 0.000582287, -9.86894e-05>,
                         <0.00991976, 0.387485, -3.95896>, <0.000110698, 0.000485725, -0.000109658>,
                         <0.0312002, 0.383233, -3.95667>, <0.000113744, 0.000513339, -0.000104021> }
        smooth_triangle {<0.0312002, 0.383233, -3.95667>, <0.000117946, 0.00054799, -0.000108555>,
                         <0.0370312, 0.377547, -3.97967>, <0.000123091, 0.000595056, -0.00010251>,
                         <0.0124939, 0.382082, -3.9828>, <0.00012211, 0.000582376, -0.000102289> }
        smooth_triangle {<0.00991976, 0.387485, -3.95896>, <0.000110698, 0.000485725, -0.000109658>,
                         <0.00757477, 0.394316, -3.93571>, <9.72579e-05, 0.000389871, -0.00011845>,
                         <0.0254713, 0.390425, -3.93407>, <0.000101665, 0.000419961, -0.000113136> }
        smooth_triangle {<0.0254713, 0.390425, -3.93407>, <0.0001071, 0.000456987, -0.000120907>,
                         <0.0312002, 0.383233, -3.95667>, <0.00011314, 0.000503676, -0.000116349>,
                         <0.00991976, 0.387485, -3.95896>, <0.000111158, 0.000487797, -0.000114413> }
        smooth_triangle {<0.00757477, 0.394316, -3.93571>, <9.72579e-05, 0.000389871, -0.00011845>,
                         <0.0055325, 0.403289, -3.91342>, <8.05033e-05, 0.000291812, -0.000124479>,
                         <0.019946, 0.39987, -3.91228>, <8.64879e-05, 0.000323525, -0.000122344> }
        smooth_triangle {<0.019946, 0.39987, -3.91228>, <9.33783e-05, 0.000361304, -0.000134936>,
                         <0.0254713, 0.390425, -3.93407>, <0.000100967, 0.000409522, -0.000130332>,
                         <0.00757477, 0.394316, -3.93571>, <9.80106e-05, 0.000392174, -0.00012572> }
        smooth_triangle {<0.0055325, 0.403289, -3.91342>, <8.05033e-05, 0.000291812, -0.000124479>,
                         <0.00394754, 0.415098, -3.89277>, <5.98308e-05, 0.000193785, -0.000119991>,
                         <0.0147938, 0.4123, -3.89195>, <6.74033e-05, 0.000225332, -0.000123648> }
        smooth_triangle {<0.0147938, 0.4123, -3.89195>, <7.55768e-05, 0.000262084, -0.000142598>,
                         <0.019946, 0.39987, -3.91228>, <8.51191e-05, 0.00031118, -0.000141946>,
                         <0.0055325, 0.403289, -3.91342>, <8.1315e-05, 0.000293568, -0.000133747> }
        smooth_triangle {<0.00394754, 0.415098, -3.89277>, <5.98308e-05, 0.000193785, -0.000119991>,
                         <0.00308582, 0.430467, -3.87486>, <3.62435e-05, 0.000104009, -9.56875e-05>,
                         <0.0103182, 0.428478, -3.8743>, <4.42591e-05, 0.00012998, -0.000109438> }
        smooth_triangle {<0.0103182, 0.428478, -3.8743>, <5.34082e-05, 0.000162549, -0.000136191>,
                         <0.0147938, 0.4123, -3.89195>, <6.49803e-05, 0.000210225, -0.000143295>,
                         <0.00394754, 0.415098, -3.89277>, <6.05124e-05, 0.000194119, -0.000130729> }
        smooth_triangle {<0.00308582, 0.430467, -3.87486>, <3.62435e-05, 0.000104009, -9.56875e-05>,
                         <0.00310388, 0.448962, -3.86039>, <1.30441e-05, 3.48535e-05, -4.4653e-05>,
                         <0.00671722, 0.447946, -3.8601>, <2.01676e-05, 5.22825e-05, -6.68481e-05> }
        smooth_triangle {<0.00671722, 0.447946, -3.8601>, <2.96859e-05, 7.85186e-05, -0.000100245>,
                         <0.0103182, 0.428478, -3.8743>, <4.17317e-05, 0.000117367, -0.00012154>,
                         <0.00308582, 0.430467, -3.87486>, <3.69837e-05, 0.000104195, -0.000105176> }
        smooth_triangle {<0.00310388, 0.448962, -3.86039>, <1.30441e-05, 3.48535e-05, -4.4653e-05>,
                         <0.00381885, 0.469267, -3.84866>, <-1.17942e-06, 1.53347e-07, -5.20603e-09>,
                         <0.00382588, 0.46932, -3.84869>, <-1.18564e-06, 1.02232e-07, -1.04716e-07> }
        smooth_triangle {<0.00382588, 0.46932, -3.84869>, <8.3599e-06, 2.10837e-05, -3.72001e-05>,
                         <0.00671722, 0.447946, -3.8601>, <1.90365e-05, 4.71738e-05, -7.05718e-05>,
                         <0.00310388, 0.448962, -3.86039>, <1.42595e-05, 3.66564e-05, -5.20637e-05> }
        smooth_triangle {<0.106609, 0.469214, -4.25412>, <-1.44083e-05, 4.72853e-05, 7.16333e-05>,
                         <0.0966643, 0.450683, -4.24389>, <-1.5657e-05, 7.07669e-05, 9.0164e-05>,
                         <0.100006, 0.449707, -4.24257>, <-1.57159e-05, 7.05856e-05, 9.0179e-05> }
        smooth_triangle {<0.100006, 0.449707, -4.24257>, <-1.2423e-05, 5.30302e-05, 6.74242e-05>,
                         <0.106584, 0.469267, -4.25402>, <-8.55962e-06, 2.36426e-05, 3.5473e-05>,
                         <0.106609, 0.469214, -4.25412>, <-8.47633e-06, 2.38246e-05, 3.53966e-05> }
        smooth_triangle {<0.0966643, 0.450683, -4.24389>, <-1.5657e-05, 7.07669e-05, 9.0164e-05>,
                         <0.0859483, 0.434588, -4.2306>, <-1.65216e-05, 0.00014721, 0.000138288>,
                         <0.0926171, 0.432718, -4.22792>, <-1.61456e-05, 0.00014767, 0.000137674> }
        smooth_triangle {<0.0926171, 0.432718, -4.22792>, <-1.41241e-05, 0.000125426, 0.000119251>,
                         <0.100006, 0.449707, -4.24257>, <-1.38018e-05, 6.76135e-05, 8.36302e-05>,
                         <0.0966643, 0.450683, -4.24389>, <-1.37577e-05, 6.77494e-05, 8.36189e-05> }
        smooth_triangle {<0.0859483, 0.434588, -4.2306>, <-1.65216e-05, 0.00014721, 0.000138288>,
                         <0.0745464, 0.421518, -4.21458>, <-1.06527e-05, 0.000237316, 0.000167716>,
                         <0.0845108, 0.418921, -4.21042>, <-9.64921e-06, 0.000238425, 0.000166005> }
        smooth_triangle {<0.0845108, 0.418921, -4.21042>, <-8.30673e-06, 0.000213431, 0.000151297>,
                         <0.0926171, 0.432718, -4.22792>, <-1.3179e-05, 0.000145364, 0.000130049>,
                         <0.0859483, 0.434588, -4.2306>, <-1.3461e-05, 0.00014502, 0.00013051> }
        smooth_triangle {<0.0745464, 0.421518, -4.21458>, <-1.06527e-05, 0.000237316, 0.000167716>,
                         <0.0627758, 0.410615, -4.19705>, <-3.9604e-06, 0.000328478, 0.000189592>,
                         <0.0760233, 0.407412, -4.19139>, <-2.47244e-06, 0.000329633, 0.000186763> }
        smooth_triangle {<0.0760233, 0.407412, -4.19139>, <-1.47149e-06, 0.000303446, 0.000174251>,
                         <0.0845108, 0.418921, -4.21042>, <-6.85407e-06, 0.00023504, 0.000158682>,
                         <0.0745464, 0.421518, -4.21458>, <-7.6067e-06, 0.000234208, 0.000159966> }
        smooth_triangle {<0.0627758, 0.410615, -4.19705>, <-3.9604e-06, 0.000328478, 0.000189592>,
                         <0.0508073, 0.401095, -4.17867>, <3.19862e-06, 0.000420072, 0.000207529>,
                         <0.0673373, 0.397363, -4.17154>, <4.94811e-06, 0.000420395, 0.000203641> }
        smooth_triangle {<0.0673373, 0.397363, -4.17154>, <5.3776e-06, 0.000393326, 0.000192966>,
                         <0.0760233, 0.407412, -4.19139>, <-1.87817e-07, 0.000325254, 0.000180308>,
                         <0.0627758, 0.410615, -4.19705>, <-1.30379e-06, 0.000324388, 0.000182429> }
        smooth_triangle {<0.0508073, 0.401095, -4.17867>, <3.19862e-06, 0.000420072, 0.000207529>,
                         <0.0386812, 0.392808, -4.15951>, <1.41571e-05, 0.000516251, 0.000217112>,
                         <0.0584975, 0.388617, -4.15101>, <1.5946e-05, 0.000514264, 0.000211963> }
        smooth_triangle {<0.0584975, 0.388617, -4.15101>, <1.55244e-05, 0.000486298, 0.000203363>,
                         <0.0673373, 0.397363, -4.17154>, <7.27597e-06, 0.000415897, 0.000197122>,
                         <0.0508073, 0.401095, -4.17867>, <5.96386e-06, 0.000415654, 0.000200038> }
        smooth_triangle {<0.0386812, 0.392808, -4.15951>, <1.41571e-05, 0.000516251, 0.000217112>,
                         <0.0264145, 0.385863, -4.13944>, <3.3333e-05, 0.000622377, 0.000210836>,
                         <0.0495201, 0.381286, -4.12976>, <3.46174e-05, 0.000614284, 0.000203947> }
        smooth_triangle {<0.0495201, 0.381286, -4.12976>, <3.26533e-05, 0.000585089, 0.000198686>,
                         <0.0584975, 0.388617, -4.15101>, <1.86498e-05, 0.000510074, 0.000204698>,
                         <0.0386812, 0.392808, -4.15951>, <1.73081e-05, 0.000511564, 0.00020856> }
        smooth_triangle {<0.0264145, 0.385863, -4.13944>, <3.3333e-05, 0.000622377, 0.000210836>,
                         <0.014083, 0.380809, -4.11784>, <6.65105e-05, 0.000745299, 0.000176351>,
                         <0.0404376, 0.37595, -4.10745>, <6.57595e-05, 0.000721938, 0.00016733> }
        smooth_triangle {<0.0404376, 0.37595, -4.10745>, <6.19295e-05, 0.000692307, 0.000166711>,
                         <0.0495201, 0.381286, -4.12976>, <3.85729e-05, 0.000611567, 0.000194174>,
                         <0.0264145, 0.385863, -4.13944>, <3.76096e-05, 0.000617636, 0.00019934> }
        smooth_triangle {<0.014083, 0.380809, -4.11784>, <6.65105e-05, 0.000745299, 0.000176351>,
                         <0.00233443, 0.378222, -4.09364>, <0.000109347, 0.000868181, 0.000110519>,
                         <0.0315874, 0.37322, -4.08361>, <0.00010418, 0.000819195, 0.000101156> }
        smooth_triangle {<0.0315874, 0.37322, -4.08361>, <9.99968e-05, 0.000794427, 0.000104602>,
                         <0.0404376, 0.37595, -4.10745>, <7.11816e-05, 0.000721485, 0.000154233>,
                         <0.014083, 0.380809, -4.11784>, <7.17448e-05, 0.000739005, 0.000160998> }
        smooth_triangle {<0.00233443, 0.378222, -4.09364>, <0.000109347, 0.000868181, 0.000110519>,
                         <-0.00679747, 0.378007, -4.06644>, <0.000142188, 0.000921815, 2.83822e-05>,
                         <0.0240246, 0.372993, -4.05819>, <0.000132592, 0.000855394, 2.38634e-05> }
        smooth_triangle {<0.0240246, 0.372993, -4.05819>, <0.000130665, 0.000846423, 2.90163e-05>,
                         <0.0315874, 0.37322, -4.08361>, <0.000109356, 0.000819274, 8.69857e-05>,
                         <0.00233443, 0.378222, -4.09364>, <0.000113231, 0.000856013, 9.40078e-05> }
        smooth_triangle {<-0.00679747, 0.378007, -4.06644>, <0.000142188, 0.000921815, 2.83822e-05>,
                         <-0.0111002, 0.379621, -4.03827>, <0.000149187, 0.000849104, -4.3926e-05>,
                         <0.0188834, 0.374696, -4.03231>, <0.000139592, 0.000794679, -4.06217e-05> }
        smooth_triangle {<0.0188834, 0.374696, -4.03231>, <0.000140643, 0.000806006, -3.71462e-05>,
                         <0.0240246, 0.372993, -4.05819>, <0.000135393, 0.000851542, 1.12176e-05>,
                         <-0.00679747, 0.378007, -4.06644>, <0.000142589, 0.000901358, 1.46067e-05> }
        smooth_triangle {<-0.0111002, 0.379621, -4.03827>, <0.000149187, 0.000849104, -4.3926e-05>,
                         <-0.0121944, 0.382566, -4.01147>, <0.00013872, 0.000716128, -8.63496e-05>,
                         <0.0153651, 0.377805, -4.00719>, <0.000132365, 0.000686002, -7.89339e-05> }
        smooth_triangle {<0.0153651, 0.377805, -4.00719>, <0.000134827, 0.000708031, -7.81702e-05>,
                         <0.0188834, 0.374696, -4.03231>, <0.000140247, 0.000789539, -4.9436e-05>,
                         <-0.0111002, 0.379621, -4.03827>, <0.000147443, 0.000830357, -5.19142e-05> }
        smooth_triangle {<-0.0121944, 0.382566, -4.01147>, <0.00013872, 0.000716128, -8.63496e-05>,
                         <-0.0120434, 0.386618, -3.98594>, <0.000126065, 0.000598186, -0.000106743>,
                         <0.0124939, 0.382082, -3.9828>, <0.000122097, 0.000582287, -9.86894e-05> }
        smooth_triangle {<0.0124939, 0.382082, -3.9828>, <0.000125177, 0.000607832, -0.00010007>,
                         <0.0153651, 0.377805, -4.00719>, <0.000132878, 0.000685618, -8.52536e-05>,
                         <-0.0121944, 0.382566, -4.01147>, <0.000137644, 0.000708213, -9.08153e-05> }
        smooth_triangle {<-0.0120434, 0.386618, -3.98594>, <0.000126065, 0.000598186, -0.000106743>,
                         <-0.0113607, 0.391736, -3.96125>, <0.000113313, 0.000494803, -0.000117099>,
                         <0.00991976, 0.387485, -3.95896>, <0.000110698, 0.000485725, -0.000109658> }
        smooth_triangle {<0.00991976, 0.387485, -3.95896>, <0.000114297, 0.000512587, -0.000112464>,
                         <0.0124939, 0.382082, -3.9828>, <0.000122846, 0.000585009, -0.000104238>,
                         <-0.0120434, 0.386618, -3.98594>, <0.000125822, 0.000596933, -0.000110278> }
        smooth_triangle {<-0.0113607, 0.391736, -3.96125>, <0.000113313, 0.000494803, -0.000117099>,
                         <-0.0103217, 0.398208, -3.93734>, <9.8939e-05, 0.000394999, -0.000124641>,
                         <0.00757477, 0.394316, -3.93571>, <9.72579e-05, 0.000389871, -0.00011845> }
        smooth_triangle {<0.00757477, 0.394316, -3.93571>, <0.000101566, 0.000417447, -0.000122691>,
                         <0.00991976, 0.387485, -3.95896>, <0.000111647, 0.000489338, -0.000116096>,
                         <-0.0113607, 0.391736, -3.96125>, <0.000113607, 0.000496146, -0.000121677> }
        smooth_triangle {<-0.0103217, 0.398208, -3.93734>, <9.8939e-05, 0.000394999, -0.000124641>,
                         <-0.008881, 0.406708, -3.91457>, <8.13993e-05, 0.000294086, -0.000128961>,
                         <0.0055325, 0.403289, -3.91342>, <8.05033e-05, 0.000291812, -0.000124479> }
        smooth_triangle {<0.0055325, 0.403289, -3.91342>, <8.57273e-05, 0.000319393, -0.000131517>,
                         <0.00757477, 0.394316, -3.93571>, <9.82933e-05, 0.000392937, -0.000126995>,
                         <-0.0103217, 0.398208, -3.93734>, <9.95541e-05, 0.000396783, -0.000131639> }
        smooth_triangle {<-0.008881, 0.406708, -3.91457>, <8.13993e-05, 0.000294086, -0.000128961>,
                         <-0.00689866, 0.417896, -3.89358>, <6.01301e-05, 0.000194188, -0.000122597>,
                         <0.00394754, 0.415098, -3.89277>, <5.98308e-05, 0.000193785, -0.000119991> }
        smooth_triangle {<0.00394754, 0.415098, -3.89277>, <6.59173e-05, 0.000220226, -0.00013119>,
                         <0.0055325, 0.403289, -3.91342>, <8.14217e-05, 0.000293746, -0.000134557>,
                         <-0.008881, 0.406708, -3.91457>, <8.20937e-05, 0.000295451, -0.000137918> }
        smooth_triangle {<-0.00689866, 0.417896, -3.89358>, <6.01301e-05, 0.000194188, -0.000122597>,
                         <-0.00414655, 0.432456, -3.87542>, <3.62674e-05, 0.000103829, -9.66322e-05>,
                         <0.00308582, 0.430467, -3.87486>, <3.62435e-05, 0.000104009, -9.56875e-05> }
        smooth_triangle {<0.00308582, 0.430467, -3.87486>, <4.28331e-05, 0.000126732, -0.000112836>,
                         <0.00394754, 0.415098, -3.89277>, <6.05236e-05, 0.000194065, -0.000131064>,
                         <-0.00689866, 0.417896, -3.89358>, <6.0748e-05, 0.000194366, -0.000133018> }
        smooth_triangle {<-0.00414655, 0.432456, -3.87542>, <3.62674e-05, 0.000103829, -9.66322e-05>,
                         <-0.000509467, 0.449977, -3.86069>, <1.30369e-05, 3.48164e-05, -4.46921e-05>,
                         <0.00310388, 0.448962, -3.86039>, <1.30441e-05, 3.48535e-05, -4.4653e-05> }
        smooth_triangle {<0.00310388, 0.448962, -3.86039>, <1.95799e-05, 5.23021e-05, -6.69399e-05>,
                         <0.00308582, 0.430467, -3.87486>, <3.69794e-05, 0.000104169, -0.000105216>,
                         <-0.00414655, 0.432456, -3.87542>, <3.69974e-05, 0.000104034, -0.000105924> }
        smooth_triangle {<-0.000509467, 0.449977, -3.86069>, <1.30369e-05, 3.48164e-05, -4.46921e-05>,
                         <0.00381183, 0.469214, -3.84864>, <-1.16698e-06, 2.55579e-07, 1.93813e-07>,
                         <0.00381885, 0.469267, -3.84866>, <-1.17942e-06, 1.53347e-07, -5.20603e-09> }
        smooth_triangle {<0.00381885, 0.469267, -3.84866>, <5.18635e-06, 1.4158e-05, -2.47023e-05>,
                         <0.00310388, 0.448962, -3.86039>, <1.42626e-05, 3.6682e-05, -5.20139e-05>,
                         <-0.000509467, 0.449977, -3.86069>, <1.42572e-05, 3.66542e-05, -5.20432e-05> }
        smooth_triangle {<0.106634, 0.469161, -4.25422>, <-1.42417e-05, 4.76491e-05, 7.14804e-05>,
                         <0.0933228, 0.451659, -4.2452>, <-1.55982e-05, 7.09481e-05, 9.0149e-05>,
                         <0.0966643, 0.450683, -4.24389>, <-1.5657e-05, 7.07669e-05, 9.0164e-05> }
        smooth_triangle {<0.0966643, 0.450683, -4.24389>, <-1.23372e-05, 5.32571e-05, 6.73747e-05>,
                         <0.106609, 0.469214, -4.25412>, <-8.39305e-06, 2.40065e-05, 3.53201e-05>,
                         <0.106634, 0.469161, -4.25422>, <-8.30976e-06, 2.41884e-05, 3.52436e-05> }
        smooth_triangle {<0.0933228, 0.451659, -4.2452>, <-1.55982e-05, 7.09481e-05, 9.0149e-05>,
                         <0.0792795, 0.436459, -4.23328>, <-1.68976e-05, 0.000146751, 0.000138903>,
                         <0.0859483, 0.434588, -4.2306>, <-1.65216e-05, 0.00014721, 0.000138288> }
        smooth_triangle {<0.0859483, 0.434588, -4.2306>, <-1.44452e-05, 0.000125036, 0.000119778>,
                         <0.0966643, 0.450683, -4.24389>, <-1.37968e-05, 6.77034e-05, 8.36842e-05>,
                         <0.0933228, 0.451659, -4.2452>, <-1.37527e-05, 6.78394e-05, 8.36729e-05> }
        smooth_triangle {<0.0792795, 0.436459, -4.23328>, <-1.68976e-05, 0.000146751, 0.000138903>,
                         <0.0645821, 0.424114, -4.21874>, <-1.16562e-05, 0.000236206, 0.000169427>,
                         <0.0745464, 0.421518, -4.21458>, <-1.06527e-05, 0.000237316, 0.000167716> }
        smooth_triangle {<0.0745464, 0.421518, -4.21458>, <-9.26308e-06, 0.000212347, 0.000152911>,
                         <0.0859483, 0.434588, -4.2306>, <-1.36647e-05, 0.000144768, 0.00013084>,
                         <0.0792795, 0.436459, -4.23328>, <-1.39467e-05, 0.000144423, 0.000131301> }
        smooth_triangle {<0.0645821, 0.424114, -4.21874>, <-1.16562e-05, 0.000236206, 0.000169427>,
                         <0.0495282, 0.413817, -4.20271>, <-5.44835e-06, 0.000327323, 0.00019242>,
                         <0.0627758, 0.410615, -4.19705>, <-3.9604e-06, 0.000328478, 0.000189592> }
        smooth_triangle {<0.0627758, 0.410615, -4.19705>, <-2.93264e-06, 0.000302253, 0.000176995>,
                         <0.0745464, 0.421518, -4.21458>, <-7.95187e-06, 0.000233881, 0.000160588>,
                         <0.0645821, 0.424114, -4.21874>, <-8.70449e-06, 0.000233049, 0.000161872> }
        smooth_triangle {<0.0495282, 0.413817, -4.20271>, <-5.44835e-06, 0.000327323, 0.00019242>,
                         <0.0342773, 0.404826, -4.1858>, <1.44914e-06, 0.000419749, 0.000211417>,
                         <0.0508073, 0.401095, -4.17867>, <3.19862e-06, 0.000420072, 0.000207529> }
        smooth_triangle {<0.0508073, 0.401095, -4.17867>, <3.63986e-06, 0.000392872, 0.000196758>,
                         <0.0627758, 0.410615, -4.19705>, <-1.72941e-06, 0.000324177, 0.000183306>,
                         <0.0495282, 0.413817, -4.20271>, <-2.84538e-06, 0.000323311, 0.000185427> }
        smooth_triangle {<0.0342773, 0.404826, -4.1858>, <1.44914e-06, 0.000419749, 0.000211417>,
                         <0.0188648, 0.397, -4.16801>, <1.23681e-05, 0.000518238, 0.000222261>,
                         <0.0386812, 0.392808, -4.15951>, <1.41571e-05, 0.000516251, 0.000217112> }
        smooth_triangle {<0.0386812, 0.392808, -4.15951>, <1.37218e-05, 0.000487969, 0.000208389>,
                         <0.0508073, 0.401095, -4.17867>, <5.50299e-06, 0.000415835, 0.000201201>,
                         <0.0342773, 0.404826, -4.1858>, <4.19087e-06, 0.000415593, 0.000204117> }
        smooth_triangle {<0.0188648, 0.397, -4.16801>, <1.23681e-05, 0.000518238, 0.000222261>,
                         <0.0033089, 0.390441, -4.14913>, <3.20487e-05, 0.000630471, 0.000217725>,
                         <0.0264145, 0.385863, -4.13944>, <3.3333e-05, 0.000622377, 0.000210836> }
        smooth_triangle {<0.0264145, 0.385863, -4.13944>, <3.12701e-05, 0.000592287, 0.000205388>,
                         <0.0386812, 0.392808, -4.15951>, <1.68881e-05, 0.000512693, 0.000210095>,
                         <0.0188648, 0.397, -4.16801>, <1.55464e-05, 0.000514183, 0.000213957> }
        smooth_triangle {<0.0033089, 0.390441, -4.14913>, <3.20487e-05, 0.000630471, 0.000217725>,
                         <-0.0122715, 0.385667, -4.12822>, <6.72615e-05, 0.00076866, 0.000185371>,
                         <0.014083, 0.380809, -4.11784>, <6.65105e-05, 0.000745299, 0.000176351> }
        smooth_triangle {<0.014083, 0.380809, -4.11784>, <6.23694e-05, 0.00071364, 0.000175573>,
                         <0.0264145, 0.385863, -4.13944>, <3.74863e-05, 0.000621449, 0.000201436>,
                         <0.0033089, 0.390441, -4.14913>, <3.6523e-05, 0.000627518, 0.000206603> }
        smooth_triangle {<-0.0122715, 0.385667, -4.12822>, <6.72615e-05, 0.00076866, 0.000185371>,
                         <-0.0269186, 0.383224, -4.10367>, <0.000114513, 0.000917167, 0.000119881>,
                         <0.00233443, 0.378222, -4.09364>, <0.000109347, 0.000868181, 0.000110519> }
        smooth_triangle {<0.00233443, 0.378222, -4.09364>, <0.000104682, 0.000841063, 0.000114198>,
                         <0.014083, 0.380809, -4.11784>, <7.25548e-05, 0.000748902, 0.000163572>,
                         <-0.0122715, 0.385667, -4.12822>, <7.3118e-05, 0.000766423, 0.000170338> }
        smooth_triangle {<-0.0269186, 0.383224, -4.10367>, <0.000114513, 0.000917167, 0.000119881>,
                         <-0.0376195, 0.383021, -4.07469>, <0.000151783, 0.000988236, 3.2901e-05>,
                         <-0.00679747, 0.378007, -4.06644>, <0.000142188, 0.000921815, 2.83822e-05> }
        smooth_triangle {<-0.00679747, 0.378007, -4.06644>, <0.000140117, 0.000913186, 3.42801e-05>,
                         <0.00233443, 0.378222, -4.09364>, <0.000115486, 0.00087296, 9.58824e-05>,
                         <-0.0269186, 0.383224, -4.10367>, <0.000119361, 0.0009097, 0.000102905> }
        smooth_triangle {<-0.0376195, 0.383021, -4.07469>, <0.000151783, 0.000988236, 3.2901e-05>,
                         <-0.0410839, 0.384545, -4.04423>, <0.000158782, 0.000903528, -4.72303e-05>,
                         <-0.0111002, 0.379621, -4.03827>, <0.000149187, 0.000849104, -4.3926e-05> }
        smooth_triangle {<-0.0111002, 0.379621, -4.03827>, <0.000150525, 0.000862746, -3.99846e-05>,
                         <-0.00679747, 0.378007, -4.06644>, <0.000145276, 0.00091728, 1.42466e-05>,
                         <-0.0376195, 0.383021, -4.07469>, <0.000152473, 0.000967096, 1.76357e-05> }
        smooth_triangle {<-0.0410839, 0.384545, -4.04423>, <0.000158782, 0.000903528, -4.72303e-05>,
                         <-0.0397539, 0.387326, -4.01575>, <0.000145076, 0.000746254, -9.37653e-05>,
                         <-0.0121944, 0.382566, -4.01147>, <0.00013872, 0.000716128, -8.63496e-05> }
        smooth_triangle {<-0.0121944, 0.382566, -4.01147>, <0.000141417, 0.0007396, -8.54899e-05>,
                         <-0.0111002, 0.379621, -4.03827>, <0.000149267, 0.000839332, -5.36721e-05>,
                         <-0.0410839, 0.384545, -4.04423>, <0.000156463, 0.00088015, -5.61504e-05> }
        smooth_triangle {<-0.0397539, 0.387326, -4.01575>, <0.000145076, 0.000746254, -9.37653e-05>,
                         <-0.0365806, 0.391153, -3.98907>, <0.000130033, 0.000614085, -0.000114798>,
                         <-0.0120434, 0.386618, -3.98594>, <0.000126065, 0.000598186, -0.000106743> }
        smooth_triangle {<-0.0120434, 0.386618, -3.98594>, <0.000129273, 0.000624401, -0.000108157>,
                         <-0.0121944, 0.382566, -4.01147>, <0.000138764, 0.000712858, -9.28613e-05>,
                         <-0.0397539, 0.387326, -4.01575>, <0.000143531, 0.000735453, -9.84231e-05> }
        smooth_triangle {<-0.0365806, 0.391153, -3.98907>, <0.000130033, 0.000614085, -0.000114798>,
                         <-0.0326412, 0.395987, -3.96354>, <0.000115927, 0.00050388, -0.00012454>,
                         <-0.0113607, 0.391736, -3.96125>, <0.000113313, 0.000494803, -0.000117099> }
        smooth_triangle {<-0.0113607, 0.391736, -3.96125>, <0.000116993, 0.000522029, -0.000119994>,
                         <-0.0120434, 0.386618, -3.98594>, <0.000126558, 0.000599567, -0.000112227>,
                         <-0.0365806, 0.391153, -3.98907>, <0.000129534, 0.000611491, -0.000118268> }
        smooth_triangle {<-0.0326412, 0.395987, -3.96354>, <0.000115927, 0.00050388, -0.00012454>,
                         <-0.0282182, 0.4021, -3.93898>, <0.00010062, 0.000400127, -0.000130832>,
                         <-0.0103217, 0.398208, -3.93734>, <9.8939e-05, 0.000394999, -0.000124641> }
        smooth_triangle {<-0.0103217, 0.398208, -3.93734>, <0.000103316, 0.000422835, -0.000129017>,
                         <-0.0113607, 0.391736, -3.96125>, <0.000114096, 0.000497688, -0.000123361>,
                         <-0.0326412, 0.395987, -3.96354>, <0.000116057, 0.000504496, -0.000128942> }
        smooth_triangle {<-0.0282182, 0.4021, -3.93898>, <0.00010062, 0.000400127, -0.000130832>,
                         <-0.0232945, 0.410128, -3.91572>, <8.22953e-05, 0.000296359, -0.000133444>,
                         <-0.008881, 0.406708, -3.91457>, <8.13993e-05, 0.000294086, -0.000128961> }
        smooth_triangle {<-0.008881, 0.406708, -3.91457>, <8.6682e-05, 0.000321862, -0.000136155>,
                         <-0.0103217, 0.398208, -3.93734>, <9.98367e-05, 0.000397547, -0.000132914>,
                         <-0.0282182, 0.4021, -3.93898>, <0.000101098, 0.000401393, -0.000137557> }
        smooth_triangle {<-0.0232945, 0.410128, -3.91572>, <8.22953e-05, 0.000296359, -0.000133444>,
                         <-0.0177449, 0.420694, -3.89439>, <6.04293e-05, 0.00019459, -0.000125203>,
                         <-0.00689866, 0.417896, -3.89358>, <6.01301e-05, 0.000194188, -0.000122597> }
        smooth_triangle {<-0.00689866, 0.417896, -3.89358>, <6.62484e-05, 0.000220705, -0.000133955>,
                         <-0.008881, 0.406708, -3.91457>, <8.22003e-05, 0.000295629, -0.000138728>,
                         <-0.0232945, 0.410128, -3.91572>, <8.28724e-05, 0.000297334, -0.00014209> }
        smooth_triangle {<-0.0177449, 0.420694, -3.89439>, <6.04293e-05, 0.00019459, -0.000125203>,
                         <-0.0113789, 0.434445, -3.87599>, <3.62914e-05, 0.000103649, -9.75768e-05>,
                         <-0.00414655, 0.432456, -3.87542>, <3.62674e-05, 0.000103829, -9.66322e-05> }
        smooth_triangle {<-0.00414655, 0.432456, -3.87542>, <4.28622e-05, 0.000126543, -0.000113879>,
                         <-0.00689866, 0.417896, -3.89358>, <6.07591e-05, 0.000194312, -0.000133352>,
                         <-0.0177449, 0.420694, -3.89439>, <6.09836e-05, 0.000194614, -0.000135307> }
        smooth_triangle {<-0.0113789, 0.434445, -3.87599>, <3.62914e-05, 0.000103649, -9.75768e-05>,
                         <-0.00412281, 0.450993, -3.86098>, <1.30297e-05, 3.47794e-05, -4.47312e-05>,
                         <-0.000509467, 0.449977, -3.86069>, <1.30369e-05, 3.48164e-05, -4.46921e-05> }
        smooth_triangle {<-0.000509467, 0.449977, -3.86069>, <1.95702e-05, 5.22476e-05, -6.70088e-05>,
                         <-0.00414655, 0.432456, -3.87542>, <3.69931e-05, 0.000104007, -0.000105964>,
                         <-0.0113789, 0.434445, -3.87599>, <3.70111e-05, 0.000103872, -0.000106672> }
        smooth_triangle {<-0.00412281, 0.450993, -3.86098>, <1.30297e-05, 3.47794e-05, -4.47312e-05>,
                         <0.0038048, 0.469161, -3.84861>, <-1.15454e-06, 3.57811e-07, 3.92832e-07>,
                         <0.00381183, 0.469214, -3.84864>, <-1.16698e-06, 2.55579e-07, 1.93813e-07> }
        smooth_triangle {<0.00381183, 0.469214, -3.84864>, <5.19879e-06, 1.42602e-05, -2.45033e-05>,
                         <-0.000509467, 0.449977, -3.86069>, <1.42603e-05, 3.66797e-05, -5.19935e-05>,
                         <-0.00412281, 0.450993, -3.86098>, <1.42549e-05, 3.66519e-05, -5.20228e-05> }
        smooth_triangle {<0.106659, 0.469108, -4.25432>, <-1.40751e-05, 4.80129e-05, 7.13274e-05>,
                         <0.0899812, 0.452636, -4.24652>, <-1.55393e-05, 7.11293e-05, 9.0134e-05>,
                         <0.0933228, 0.451659, -4.2452>, <-1.55982e-05, 7.09481e-05, 9.0149e-05> }
        smooth_triangle {<0.0933228, 0.451659, -4.2452>, <-1.22514e-05, 5.34839e-05, 6.73252e-05>,
                         <0.106634, 0.469161, -4.25422>, <-8.22647e-06, 2.43703e-05, 3.51671e-05>,
                         <0.106659, 0.469108, -4.25432>, <-8.14318e-06, 2.45522e-05, 3.50907e-05> }
        smooth_triangle {<0.0899812, 0.452636, -4.24652>, <-1.55393e-05, 7.11293e-05, 9.0134e-05>,
                         <0.0726106, 0.438329, -4.23596>, <-1.72736e-05, 0.000146292, 0.000139518>,
                         <0.0792795, 0.436459, -4.23328>, <-1.68976e-05, 0.000146751, 0.000138903> }
        smooth_triangle {<0.0792795, 0.436459, -4.23328>, <-1.47664e-05, 0.000124646, 0.000120304>,
                         <0.0933228, 0.451659, -4.2452>, <-1.37918e-05, 6.77934e-05, 8.37381e-05>,
                         <0.0899812, 0.452636, -4.24652>, <-1.37477e-05, 6.79293e-05, 8.37269e-05> }
        smooth_triangle {<0.0726106, 0.438329, -4.23596>, <-1.72736e-05, 0.000146292, 0.000139518>,
                         <0.0546178, 0.426711, -4.2229>, <-1.26597e-05, 0.000235097, 0.000171139>,
                         <0.0645821, 0.424114, -4.21874>, <-1.16562e-05, 0.000236206, 0.000169427> }
        smooth_triangle {<0.0645821, 0.424114, -4.21874>, <-1.02194e-05, 0.000211262, 0.000154525>,
                         <0.0792795, 0.436459, -4.23328>, <-1.41505e-05, 0.000144171, 0.000131631>,
                         <0.0726106, 0.438329, -4.23596>, <-1.44325e-05, 0.000143827, 0.000132092> }
        smooth_triangle {<0.0546178, 0.426711, -4.2229>, <-1.26597e-05, 0.000235097, 0.000171139>,
                         <0.0362806, 0.41702, -4.20838>, <-6.93631e-06, 0.000326169, 0.000195249>,
                         <0.0495282, 0.413817, -4.20271>, <-5.44835e-06, 0.000327323, 0.00019242> }
        smooth_triangle {<0.0495282, 0.413817, -4.20271>, <-4.39378e-06, 0.000301059, 0.000179739>,
                         <0.0645821, 0.424114, -4.21874>, <-9.04967e-06, 0.000232722, 0.000162494>,
                         <0.0546178, 0.426711, -4.2229>, <-9.80229e-06, 0.00023189, 0.000163778> }
        smooth_triangle {<0.0362806, 0.41702, -4.20838>, <-6.93631e-06, 0.000326169, 0.000195249>,
                         <0.0177473, 0.408557, -4.19293>, <-3.00353e-07, 0.000419426, 0.000215304>,
                         <0.0342773, 0.404826, -4.1858>, <1.44914e-06, 0.000419749, 0.000211417> }
        smooth_triangle {<0.0342773, 0.404826, -4.1858>, <1.90212e-06, 0.000392418, 0.00020055>,
                         <0.0495282, 0.413817, -4.20271>, <-3.271e-06, 0.000323099, 0.000186303>,
                         <0.0362806, 0.41702, -4.20838>, <-4.38697e-06, 0.000322233, 0.000188424> }
        smooth_triangle {<0.0177473, 0.408557, -4.19293>, <-3.00353e-07, 0.000419426, 0.000215304>,
                         <-0.000951526, 0.401192, -4.17652>, <1.05792e-05, 0.000520225, 0.000227411>,
                         <0.0188648, 0.397, -4.16801>, <1.23681e-05, 0.000518238, 0.000222261> }
        smooth_triangle {<0.0188648, 0.397, -4.16801>, <1.19192e-05, 0.00048964, 0.000213414>,
                         <0.0342773, 0.404826, -4.1858>, <3.73e-06, 0.000415773, 0.00020528>,
                         <0.0177473, 0.408557, -4.19293>, <2.41788e-06, 0.000415531, 0.000208196> }
        smooth_triangle {<-0.000951526, 0.401192, -4.17652>, <1.05792e-05, 0.000520225, 0.000227411>,
                         <-0.0197967, 0.395018, -4.15881>, <3.07643e-05, 0.000638564, 0.000224614>,
                         <0.0033089, 0.390441, -4.14913>, <3.20487e-05, 0.000630471, 0.000217725> }
        smooth_triangle {<0.0033089, 0.390441, -4.14913>, <2.98869e-05, 0.000599486, 0.00021209>,
                         <0.0188648, 0.397, -4.16801>, <1.51265e-05, 0.000515312, 0.000215492>,
                         <-0.000951526, 0.401192, -4.17652>, <1.37848e-05, 0.000516802, 0.000219354> }
        smooth_triangle {<-0.0197967, 0.395018, -4.15881>, <3.07643e-05, 0.000638564, 0.000224614>,
                         <-0.0386261, 0.390525, -4.13861>, <6.80125e-05, 0.000792021, 0.000194392>,
                         <-0.0122715, 0.385667, -4.12822>, <6.72615e-05, 0.00076866, 0.000185371> }
        smooth_triangle {<-0.0122715, 0.385667, -4.12822>, <6.28093e-05, 0.000734973, 0.000184434>,
                         <0.0033089, 0.390441, -4.14913>, <3.63997e-05, 0.000631331, 0.000208699>,
                         <-0.0197967, 0.395018, -4.15881>, <3.54364e-05, 0.0006374, 0.000213866> }
        smooth_triangle {<-0.0386261, 0.390525, -4.13861>, <6.80125e-05, 0.000792021, 0.000194392>,
                         <-0.0561716, 0.388226, -4.1137>, <0.00011968, 0.000966154, 0.000129244>,
                         <-0.0269186, 0.383224, -4.10367>, <0.000114513, 0.000917167, 0.000119881> }
        smooth_triangle {<-0.0269186, 0.383224, -4.10367>, <0.000109367, 0.000887699, 0.000123794>,
                         <-0.0122715, 0.385667, -4.12822>, <7.3928e-05, 0.000776319, 0.000172911>,
                         <-0.0386261, 0.390525, -4.13861>, <7.44912e-05, 0.00079384, 0.000179677> }
        smooth_triangle {<-0.0561716, 0.388226, -4.1137>, <0.00011968, 0.000966154, 0.000129244>,
                         <-0.0684415, 0.388035, -4.08293>, <0.000161379, 0.00105466, 3.74198e-05>,
                         <-0.0376195, 0.383021, -4.07469>, <0.000151783, 0.000988236, 3.2901e-05> }
        smooth_triangle {<-0.0376195, 0.383021, -4.07469>, <0.000149568, 0.000979948, 3.95438e-05>,
                         <-0.0269186, 0.383224, -4.10367>, <0.000121616, 0.000926647, 0.000104779>,
                         <-0.0561716, 0.388226, -4.1137>, <0.000125491, 0.000963386, 0.000111801> }
        smooth_triangle {<-0.0684415, 0.388035, -4.08293>, <0.000161379, 0.00105466, 3.74198e-05>,
                         <-0.0710675, 0.389469, -4.05019>, <0.000168377, 0.000957953, -5.05346e-05>,
                         <-0.0410839, 0.384545, -4.04423>, <0.000158782, 0.000903528, -4.72303e-05> }
        smooth_triangle {<-0.0410839, 0.384545, -4.04423>, <0.000160408, 0.000919487, -4.28229e-05>,
                         <-0.0376195, 0.383021, -4.07469>, <0.000155159, 0.000983018, 1.72755e-05>,
                         <-0.0684415, 0.388035, -4.08293>, <0.000162356, 0.00103283, 2.06646e-05> }
        smooth_triangle {<-0.0710675, 0.389469, -4.05019>, <0.000168377, 0.000957953, -5.05346e-05>,
                         <-0.0673135, 0.392087, -4.02003>, <0.000151431, 0.00077638, -0.000101181>,
                         <-0.0397539, 0.387326, -4.01575>, <0.000145076, 0.000746254, -9.37653e-05> }
        smooth_triangle {<-0.0397539, 0.387326, -4.01575>, <0.000148006, 0.000771169, -9.28095e-05>,
                         <-0.0410839, 0.384545, -4.04423>, <0.000158286, 0.000889125, -5.79083e-05>,
                         <-0.0710675, 0.389469, -4.05019>, <0.000165482, 0.000929944, -6.03865e-05> }
        smooth_triangle {<-0.0673135, 0.392087, -4.02003>, <0.000151431, 0.00077638, -0.000101181>,
                         <-0.0611179, 0.395689, -3.99221>, <0.000134001, 0.000629983, -0.000122852>,
                         <-0.0365806, 0.391153, -3.98907>, <0.000130033, 0.000614085, -0.000114798> }
        smooth_triangle {<-0.0365806, 0.391153, -3.98907>, <0.000133369, 0.000640971, -0.000116243>,
                         <-0.0397539, 0.387326, -4.01575>, <0.000144651, 0.000740098, -0.000100469>,
                         <-0.0673135, 0.392087, -4.02003>, <0.000149417, 0.000762692, -0.000106031> }
        smooth_triangle {<-0.0611179, 0.395689, -3.99221>, <0.000134001, 0.000629983, -0.000122852>,
                         <-0.0539217, 0.400238, -3.96583>, <0.000118541, 0.000512958, -0.000131982>,
                         <-0.0326412, 0.395987, -3.96354>, <0.000115927, 0.00050388, -0.00012454> }
        smooth_triangle {<-0.0326412, 0.395987, -3.96354>, <0.00011969, 0.000531471, -0.000127523>,
                         <-0.0365806, 0.391153, -3.98907>, <0.000130269, 0.000614125, -0.000120216>,
                         <-0.0611179, 0.395689, -3.99221>, <0.000133245, 0.000626049, -0.000126257> }
        smooth_triangle {<-0.0539217, 0.400238, -3.96583>, <0.000118541, 0.000512958, -0.000131982>,
                         <-0.0461147, 0.405991, -3.94061>, <0.000102301, 0.000405255, -0.000137023>,
                         <-0.0282182, 0.4021, -3.93898>, <0.00010062, 0.000400127, -0.000130832> }
        smooth_triangle {<-0.0282182, 0.4021, -3.93898>, <0.000105066, 0.000428222, -0.000135344>,
                         <-0.0326412, 0.395987, -3.96354>, <0.000116546, 0.000506037, -0.000130625>,
                         <-0.0539217, 0.400238, -3.96583>, <0.000118507, 0.000512846, -0.000136206> }
        smooth_triangle {<-0.0461147, 0.405991, -3.94061>, <0.000102301, 0.000405255, -0.000137023>,
                         <-0.037708, 0.413547, -3.91686>, <8.31913e-05, 0.000298633, -0.000137926>,
                         <-0.0232945, 0.410128, -3.91572>, <8.22953e-05, 0.000296359, -0.000133444> }
        smooth_triangle {<-0.0232945, 0.410128, -3.91572>, <8.76366e-05, 0.000324331, -0.000140792>,
                         <-0.0282182, 0.4021, -3.93898>, <0.00010138, 0.000402157, -0.000138833>,
                         <-0.0461147, 0.405991, -3.94061>, <0.000102641, 0.000406003, -0.000143476> }
        smooth_triangle {<-0.037708, 0.413547, -3.91686>, <8.31913e-05, 0.000298633, -0.000137926>,
                         <-0.0285911, 0.423492, -3.89521>, <6.07286e-05, 0.000194992, -0.000127809>,
                         <-0.0177449, 0.420694, -3.89439>, <6.04293e-05, 0.00019459, -0.000125203> }
        smooth_triangle {<-0.0177449, 0.420694, -3.89439>, <6.65796e-05, 0.000221185, -0.000136719>,
                         <-0.0232945, 0.410128, -3.91572>, <8.2979e-05, 0.000297512, -0.0001429>,
                         <-0.037708, 0.413547, -3.91686>, <8.3651e-05, 0.000299217, -0.000146261> }
        smooth_triangle {<-0.0285911, 0.423492, -3.89521>, <6.07286e-05, 0.000194992, -0.000127809>,
                         <-0.0186113, 0.436434, -3.87655>, <3.63154e-05, 0.000103469, -9.85215e-05>,
                         <-0.0113789, 0.434445, -3.87599>, <3.62914e-05, 0.000103649, -9.75768e-05> }
        smooth_triangle {<-0.0113789, 0.434445, -3.87599>, <4.28913e-05, 0.000126354, -0.000114922>,
                         <-0.0177449, 0.420694, -3.89439>, <6.09947e-05, 0.00019456, -0.000135641>,
                         <-0.0285911, 0.423492, -3.89521>, <6.12192e-05, 0.000194861, -0.000137596> }
        smooth_triangle {<-0.0186113, 0.436434, -3.87655>, <3.63154e-05, 0.000103469, -9.85215e-05>,
                         <-0.00773616, 0.452009, -3.86128>, <1.30225e-05, 3.47423e-05, -4.47703e-05>,
                         <-0.00412281, 0.450993, -3.86098>, <1.30297e-05, 3.47794e-05, -4.47312e-05> }
        smooth_triangle {<-0.00412281, 0.450993, -3.86098>, <1.95605e-05, 5.21931e-05, -6.70776e-05>,
                         <-0.0113789, 0.434445, -3.87599>, <3.70068e-05, 0.000103845, -0.000106712>,
                         <-0.0186113, 0.436434, -3.87655>, <3.70248e-05, 0.00010371, -0.00010742> }
        smooth_triangle {<-0.00773616, 0.452009, -3.86128>, <1.30225e-05, 3.47423e-05, -4.47703e-05>,
                         <0.00379777, 0.469108, -3.84858>, <-1.14209e-06, 4.60042e-07, 5.91851e-07>,
                         <0.0038048, 0.469161, -3.84861>, <-1.15454e-06, 3.57811e-07, 3.92832e-07> }
        smooth_triangle {<0.0038048, 0.469161, -3.84861>, <5.21123e-06, 1.43625e-05, -2.43043e-05>,
                         <-0.00412281, 0.450993, -3.86098>, <1.4258e-05, 3.66775e-05, -5.1973e-05>,
                         <-0.00773616, 0.452009, -3.86128>, <1.42525e-05, 3.66497e-05, -5.20023e-05> }
        smooth_triangle {<0.106684, 0.469055, -4.25442>, <-1.39086e-05, 4.83768e-05, 7.11745e-05>,
                         <0.0866397, 0.453612, -4.24784>, <-1.54805e-05, 7.13105e-05, 9.0119e-05>,
                         <0.0899812, 0.452636, -4.24652>, <-1.55393e-05, 7.11293e-05, 9.0134e-05> }
        smooth_triangle {<0.0899812, 0.452636, -4.24652>, <-1.21656e-05, 5.37108e-05, 6.72757e-05>,
                         <0.106659, 0.469108, -4.25432>, <-8.0599e-06, 2.47341e-05, 3.50142e-05>,
                         <0.106684, 0.469055, -4.25442>, <-7.97661e-06, 2.4916e-05, 3.49377e-05> }
        smooth_triangle {<0.0866397, 0.453612, -4.24784>, <-1.54805e-05, 7.13105e-05, 9.0119e-05>,
                         <0.0659418, 0.4402, -4.23865>, <-1.76496e-05, 0.000145833, 0.000140132>,
                         <0.0726106, 0.438329, -4.23596>, <-1.72736e-05, 0.000146292, 0.000139518> }
        smooth_triangle {<0.0726106, 0.438329, -4.23596>, <-1.50875e-05, 0.000124255, 0.00012083>,
                         <0.0899812, 0.452636, -4.24652>, <-1.37868e-05, 6.78833e-05, 8.37921e-05>,
                         <0.0866397, 0.453612, -4.24784>, <-1.37427e-05, 6.80192e-05, 8.37809e-05> }
        smooth_triangle {<0.0659418, 0.4402, -4.23865>, <-1.76496e-05, 0.000145833, 0.000140132>,
                         <0.0446535, 0.429308, -4.22706>, <-1.36632e-05, 0.000233988, 0.00017285>,
                         <0.0546178, 0.426711, -4.2229>, <-1.26597e-05, 0.000235097, 0.000171139> }
        smooth_triangle {<0.0546178, 0.426711, -4.2229>, <-1.11758e-05, 0.000210178, 0.000156139>,
                         <0.0726106, 0.438329, -4.23596>, <-1.46362e-05, 0.000143574, 0.000132423>,
                         <0.0659418, 0.4402, -4.23865>, <-1.49182e-05, 0.00014323, 0.000132884> }
        smooth_triangle {<0.0446535, 0.429308, -4.22706>, <-1.36632e-05, 0.000233988, 0.00017285>,
                         <0.0230331, 0.420222, -4.21404>, <-8.42427e-06, 0.000325014, 0.000198077>,
                         <0.0362806, 0.41702, -4.20838>, <-6.93631e-06, 0.000326169, 0.000195249> }
        smooth_triangle {<0.0362806, 0.41702, -4.20838>, <-5.85492e-06, 0.000299866, 0.000182483>,
                         <0.0546178, 0.426711, -4.2229>, <-1.01475e-05, 0.000231562, 0.0001644>,
                         <0.0446535, 0.429308, -4.22706>, <-1.09001e-05, 0.00023073, 0.000165684> }
        smooth_triangle {<0.0230331, 0.420222, -4.21404>, <-8.42427e-06, 0.000325014, 0.000198077>,
                         <0.00121735, 0.412289, -4.20006>, <-2.04984e-06, 0.000419103, 0.000219192>,
                         <0.0177473, 0.408557, -4.19293>, <-3.00353e-07, 0.000419426, 0.000215304> }
        smooth_triangle {<0.0177473, 0.408557, -4.19293>, <1.64381e-07, 0.000391965, 0.000204342>,
                         <0.0362806, 0.41702, -4.20838>, <-4.81259e-06, 0.000322022, 0.000189301>,
                         <0.0230331, 0.420222, -4.21404>, <-5.92856e-06, 0.000321156, 0.000191422> }
        smooth_triangle {<0.00121735, 0.412289, -4.20006>, <-2.04984e-06, 0.000419103, 0.000219192>,
                         <-0.0207679, 0.405383, -4.18502>, <8.79025e-06, 0.000522211, 0.00023256>,
                         <-0.000951526, 0.401192, -4.17652>, <1.05792e-05, 0.000520225, 0.000227411> }
        smooth_triangle {<-0.000951526, 0.401192, -4.17652>, <1.01167e-05, 0.000491311, 0.000218439>,
                         <0.0177473, 0.408557, -4.19293>, <1.95701e-06, 0.000415712, 0.000209359>,
                         <0.00121735, 0.412289, -4.20006>, <6.4489e-07, 0.00041547, 0.000212275> }
        smooth_triangle {<-0.0207679, 0.405383, -4.18502>, <8.79025e-06, 0.000522211, 0.00023256>,
                         <-0.0429023, 0.399596, -4.1685>, <2.948e-05, 0.000646657, 0.000231502>,
                         <-0.0197967, 0.395018, -4.15881>, <3.07643e-05, 0.000638564, 0.000224614> }
        smooth_triangle {<-0.0197967, 0.395018, -4.15881>, <2.85036e-05, 0.000606685, 0.000218792>,
                         <-0.000951526, 0.401192, -4.17652>, <1.33648e-05, 0.00051793, 0.00022089>,
                         <-0.0207679, 0.405383, -4.18502>, <1.20231e-05, 0.000519421, 0.000224752> }
        smooth_triangle {<-0.0429023, 0.399596, -4.1685>, <2.948e-05, 0.000646657, 0.000231502>,
                         <-0.0649807, 0.395384, -4.149>, <6.87635e-05, 0.000815382, 0.000203413>,
                         <-0.0386261, 0.390525, -4.13861>, <6.80125e-05, 0.000792021, 0.000194392> }
        smooth_triangle {<-0.0386261, 0.390525, -4.13861>, <6.32492e-05, 0.000756306, 0.000193296>,
                         <-0.0197967, 0.395018, -4.15881>, <3.53131e-05, 0.000641213, 0.000215962>,
                         <-0.0429023, 0.399596, -4.1685>, <3.43498e-05, 0.000647283, 0.000221128> }
        smooth_triangle {<-0.0649807, 0.395384, -4.149>, <6.87635e-05, 0.000815382, 0.000203413>,
                         <-0.0854246, 0.393228, -4.12372>, <0.000124847, 0.00101514, 0.000138607>,
                         <-0.0561716, 0.388226, -4.1137>, <0.00011968, 0.000966154, 0.000129244> }
        smooth_triangle {<-0.0561716, 0.388226, -4.1137>, <0.000114052, 0.000934336, 0.00013339>,
                         <-0.0386261, 0.390525, -4.13861>, <7.53012e-05, 0.000803736, 0.000182251>,
                         <-0.0649807, 0.395384, -4.149>, <7.58644e-05, 0.000821257, 0.000189016> }
        smooth_triangle {<-0.0854246, 0.393228, -4.12372>, <0.000124847, 0.00101514, 0.000138607>,
                         <-0.0992636, 0.393049, -4.09118>, <0.000170975, 0.00112108, 4.19387e-05>,
                         <-0.0684415, 0.388035, -4.08293>, <0.000161379, 0.00105466, 3.74198e-05> }
        smooth_triangle {<-0.0684415, 0.388035, -4.08293>, <0.00015902, 0.00104671, 4.48076e-05>,
                         <-0.0561716, 0.388226, -4.1137>, <0.000127746, 0.000980333, 0.000113676>,
                         <-0.0854246, 0.393228, -4.12372>, <0.000131621, 0.00101707, 0.000120698> }
        smooth_triangle {<-0.0992636, 0.393049, -4.09118>, <0.000170975, 0.00112108, 4.19387e-05>,
                         <-0.101051, 0.394394, -4.05614>, <0.000177972, 0.00101238, -5.38389e-05>,
                         <-0.0710675, 0.389469, -4.05019>, <0.000168377, 0.000957953, -5.05346e-05> }
        smooth_triangle {<-0.0710675, 0.389469, -4.05019>, <0.000170291, 0.000976228, -4.56613e-05>,
                         <-0.0684415, 0.388035, -4.08293>, <0.000165042, 0.00104876, 2.03045e-05>,
                         <-0.0992636, 0.393049, -4.09118>, <0.000172239, 0.00109857, 2.36936e-05> }
        smooth_triangle {<-0.101051, 0.394394, -4.05614>, <0.000177972, 0.00101238, -5.38389e-05>,
                         <-0.094873, 0.396848, -4.02431>, <0.000157786, 0.000806506, -0.000108597>,
                         <-0.0673135, 0.392087, -4.02003>, <0.000151431, 0.00077638, -0.000101181> }
        smooth_triangle {<-0.0673135, 0.392087, -4.02003>, <0.000154596, 0.000802738, -0.000100129>,
                         <-0.0710675, 0.389469, -4.05019>, <0.000167305, 0.000938918, -6.21444e-05>,
                         <-0.101051, 0.394394, -4.05614>, <0.000174502, 0.000979737, -6.46226e-05> }
        smooth_triangle {<-0.094873, 0.396848, -4.02431>, <0.000157786, 0.000806506, -0.000108597>,
                         <-0.0856552, 0.400225, -3.99535>, <0.000137969, 0.000645882, -0.000130906>,
                         <-0.0611179, 0.395689, -3.99221>, <0.000134001, 0.000629983, -0.000122852> }
        smooth_triangle {<-0.0611179, 0.395689, -3.99221>, <0.000137465, 0.00065754, -0.00012433>,
                         <-0.0673135, 0.392087, -4.02003>, <0.000150537, 0.000767338, -0.000108077>,
                         <-0.094873, 0.396848, -4.02431>, <0.000155304, 0.000789932, -0.000113638> }
        smooth_triangle {<-0.0856552, 0.400225, -3.99535>, <0.000137969, 0.000645882, -0.000130906>,
                         <-0.0752021, 0.40449, -3.96812>, <0.000121155, 0.000522036, -0.000139423>,
                         <-0.0539217, 0.400238, -3.96583>, <0.000118541, 0.000512958, -0.000131982> }
        smooth_triangle {<-0.0539217, 0.400238, -3.96583>, <0.000122386, 0.000540914, -0.000135053>,
                         <-0.0611179, 0.395689, -3.99221>, <0.000133981, 0.000628682, -0.000128206>,
                         <-0.0856552, 0.400225, -3.99535>, <0.000136957, 0.000640606, -0.000134246> }
        smooth_triangle {<-0.0752021, 0.40449, -3.96812>, <0.000121155, 0.000522036, -0.000139423>,
                         <-0.0640112, 0.409883, -3.94225>, <0.000103982, 0.000410383, -0.000143213>,
                         <-0.0461147, 0.405991, -3.94061>, <0.000102301, 0.000405255, -0.000137023> }
        smooth_triangle {<-0.0461147, 0.405991, -3.94061>, <0.000106816, 0.000433609, -0.000141671>,
                         <-0.0539217, 0.400238, -3.96583>, <0.000118996, 0.000514387, -0.00013789>,
                         <-0.0752021, 0.40449, -3.96812>, <0.000120957, 0.000521195, -0.000143471> }
        smooth_triangle {<-0.0640112, 0.409883, -3.94225>, <0.000103982, 0.000410383, -0.000143213>,
                         <-0.0521215, 0.416967, -3.91801>, <8.40873e-05, 0.000300906, -0.000142408>,
                         <-0.037708, 0.413547, -3.91686>, <8.31913e-05, 0.000298633, -0.000137926> }
        smooth_triangle {<-0.037708, 0.413547, -3.91686>, <8.85913e-05, 0.0003268, -0.000145429>,
                         <-0.0461147, 0.405991, -3.94061>, <0.000102924, 0.000406766, -0.000144752>,
                         <-0.0640112, 0.409883, -3.94225>, <0.000104184, 0.000410612, -0.000149395> }
        smooth_triangle {<-0.0521215, 0.416967, -3.91801>, <8.40873e-05, 0.000300906, -0.000142408>,
                         <-0.0394373, 0.42629, -3.89602>, <6.10279e-05, 0.000195395, -0.000130414>,
                         <-0.0285911, 0.423492, -3.89521>, <6.07286e-05, 0.000194992, -0.000127809> }
        smooth_triangle {<-0.0285911, 0.423492, -3.89521>, <6.69107e-05, 0.000221665, -0.000139483>,
                         <-0.037708, 0.413547, -3.91686>, <8.37577e-05, 0.000299395, -0.000147071>,
                         <-0.0521215, 0.416967, -3.91801>, <8.44297e-05, 0.0003011, -0.000150433> }
        smooth_triangle {<-0.0394373, 0.42629, -3.89602>, <6.10279e-05, 0.000195395, -0.000130414>,
                         <-0.0258437, 0.438423, -3.87711>, <3.63394e-05, 0.000103289, -9.94662e-05>,
                         <-0.0186113, 0.436434, -3.87655>, <3.63154e-05, 0.000103469, -9.85215e-05> }
        smooth_triangle {<-0.0186113, 0.436434, -3.87655>, <4.29204e-05, 0.000126165, -0.000115965>,
                         <-0.0285911, 0.423492, -3.89521>, <6.12303e-05, 0.000194807, -0.00013793>,
                         <-0.0394373, 0.42629, -3.89602>, <6.14548e-05, 0.000195109, -0.000139885> }
        smooth_triangle {<-0.0258437, 0.438423, -3.87711>, <3.63394e-05, 0.000103289, -9.94662e-05>,
                         <-0.0113495, 0.453024, -3.86157>, <1.30153e-05, 3.47052e-05, -4.48094e-05>,
                         <-0.00773616, 0.452009, -3.86128>, <1.30225e-05, 3.47423e-05, -4.47703e-05> }
        smooth_triangle {<-0.00773616, 0.452009, -3.86128>, <1.95509e-05, 5.21386e-05, -6.71465e-05>,
                         <-0.0186113, 0.436434, -3.87655>, <3.70206e-05, 0.000103684, -0.00010746>,
                         <-0.0258437, 0.438423, -3.87711>, <3.70386e-05, 0.000103549, -0.000108168> }
        smooth_triangle {<-0.0113495, 0.453024, -3.86157>, <1.30153e-05, 3.47052e-05, -4.48094e-05>,
                         <0.00379075, 0.469055, -3.84855>, <-1.12965e-06, 5.62274e-07, 7.9087e-07>,
                         <0.00379777, 0.469108, -3.84858>, <-1.14209e-06, 4.60042e-07, 5.91851e-07> }
        smooth_triangle {<0.00379777, 0.469108, -3.84858>, <5.22367e-06, 1.44647e-05, -2.41052e-05>,
                         <-0.00773616, 0.452009, -3.86128>, <1.42557e-05, 3.66752e-05, -5.19526e-05>,
                         <-0.0113495, 0.453024, -3.86157>, <1.42502e-05, 3.66474e-05, -5.19819e-05> }
        smooth_triangle {<0.106709, 0.469002, -4.25451>, <-1.3742e-05, 4.87406e-05, 7.10215e-05>,
                         <0.0832981, 0.454589, -4.24915>, <-1.54216e-05, 7.14918e-05, 9.0104e-05>,
                         <0.0866397, 0.453612, -4.24784>, <-1.54805e-05, 7.13105e-05, 9.0119e-05> }
        smooth_triangle {<0.0866397, 0.453612, -4.24784>, <-1.20799e-05, 5.39377e-05, 6.72262e-05>,
                         <0.106684, 0.469055, -4.25442>, <-7.89332e-06, 2.5098e-05, 3.48612e-05>,
                         <0.106709, 0.469002, -4.25451>, <-7.81003e-06, 2.52799e-05, 3.47848e-05> }
        smooth_triangle {<0.0832981, 0.454589, -4.24915>, <-1.54216e-05, 7.14918e-05, 9.0104e-05>,
                         <0.0592729, 0.44207, -4.24133>, <-1.80256e-05, 0.000145374, 0.000140747>,
                         <0.0659418, 0.4402, -4.23865>, <-1.76496e-05, 0.000145833, 0.000140132> }
        smooth_triangle {<0.0659418, 0.4402, -4.23865>, <-1.54087e-05, 0.000123865, 0.000121356>,
                         <0.0866397, 0.453612, -4.24784>, <-1.37818e-05, 6.79732e-05, 8.38461e-05>,
                         <0.0832981, 0.454589, -4.24915>, <-1.37377e-05, 6.81091e-05, 8.38349e-05> }
        smooth_triangle {<0.0592729, 0.44207, -4.24133>, <-1.80256e-05, 0.000145374, 0.000140747>,
                         <0.0346891, 0.431904, -4.23121>, <-1.46667e-05, 0.000232878, 0.000174561>,
                         <0.0446535, 0.429308, -4.22706>, <-1.36632e-05, 0.000233988, 0.00017285> }
        smooth_triangle {<0.0446535, 0.429308, -4.22706>, <-1.21321e-05, 0.000209093, 0.000157752>,
                         <0.0659418, 0.4402, -4.23865>, <-1.51219e-05, 0.000142977, 0.000133214>,
                         <0.0592729, 0.44207, -4.24133>, <-1.54039e-05, 0.000142633, 0.000133675> }
        smooth_triangle {<0.0346891, 0.431904, -4.23121>, <-1.46667e-05, 0.000232878, 0.000174561>,
                         <0.00978548, 0.423424, -4.2197>, <-9.91223e-06, 0.00032386, 0.000200906>,
                         <0.0230331, 0.420222, -4.21404>, <-8.42427e-06, 0.000325014, 0.000198077> }
        smooth_triangle {<0.0230331, 0.420222, -4.21404>, <-7.31606e-06, 0.000298673, 0.000185227>,
                         <0.0446535, 0.429308, -4.22706>, <-1.12453e-05, 0.000230403, 0.000166306>,
                         <0.0346891, 0.431904, -4.23121>, <-1.19979e-05, 0.000229571, 0.000167589> }
        smooth_triangle {<0.00978548, 0.423424, -4.2197>, <-9.91223e-06, 0.00032386, 0.000200906>,
                         <-0.0153126, 0.41602, -4.20718>, <-3.79933e-06, 0.00041878, 0.00022308>,
                         <0.00121735, 0.412289, -4.20006>, <-2.04984e-06, 0.000419103, 0.000219192> }
        smooth_triangle {<0.00121735, 0.412289, -4.20006>, <-1.57336e-06, 0.000391511, 0.000208135>,
                         <0.0230331, 0.420222, -4.21404>, <-6.35418e-06, 0.000320944, 0.000192298>,
                         <0.00978548, 0.423424, -4.2197>, <-7.47015e-06, 0.000320078, 0.00019442> }
        smooth_triangle {<-0.0153126, 0.41602, -4.20718>, <-3.79933e-06, 0.00041878, 0.00022308>,
                         <-0.0405842, 0.409575, -4.19352>, <7.00131e-06, 0.000524198, 0.000237709>,
                         <-0.0207679, 0.405383, -4.18502>, <8.79025e-06, 0.000522211, 0.00023256> }
        smooth_triangle {<-0.0207679, 0.405383, -4.18502>, <8.31409e-06, 0.000492981, 0.000223464>,
                         <0.00121735, 0.412289, -4.20006>, <1.84017e-07, 0.00041565, 0.000213438>,
                         <-0.0153126, 0.41602, -4.20718>, <-1.1281e-06, 0.000415408, 0.000216354> }
        smooth_triangle {<-0.0405842, 0.409575, -4.19352>, <7.00131e-06, 0.000524198, 0.000237709>,
                         <-0.0660079, 0.404173, -4.17818>, <2.81956e-05, 0.00065475, 0.000238391>,
                         <-0.0429023, 0.399596, -4.1685>, <2.948e-05, 0.000646657, 0.000231502> }
        smooth_triangle {<-0.0429023, 0.399596, -4.1685>, <2.71204e-05, 0.000613883, 0.000225494>,
                         <-0.0207679, 0.405383, -4.18502>, <1.16031e-05, 0.000520549, 0.000226287>,
                         <-0.0405842, 0.409575, -4.19352>, <1.02614e-05, 0.00052204, 0.000230149> }
        smooth_triangle {<-0.0660079, 0.404173, -4.17818>, <2.81956e-05, 0.00065475, 0.000238391>,
                         <-0.0913353, 0.400242, -4.15939>, <6.95145e-05, 0.000838743, 0.000212434>,
                         <-0.0649807, 0.395384, -4.149>, <6.87635e-05, 0.000815382, 0.000203413> }
        smooth_triangle {<-0.0649807, 0.395384, -4.149>, <6.36892e-05, 0.000777639, 0.000202157>,
                         <-0.0429023, 0.399596, -4.1685>, <3.42265e-05, 0.000651095, 0.000223224>,
                         <-0.0660079, 0.404173, -4.17818>, <3.32632e-05, 0.000657165, 0.000228391> }
        smooth_triangle {<-0.0913353, 0.400242, -4.15939>, <6.95145e-05, 0.000838743, 0.000212434>,
                         <-0.114678, 0.39823, -4.13375>, <0.000130013, 0.00106413, 0.00014797>,
                         <-0.0854246, 0.393228, -4.12372>, <0.000124847, 0.00101514, 0.000138607> }
        smooth_triangle {<-0.0854246, 0.393228, -4.12372>, <0.000118737, 0.000980972, 0.000142986>,
                         <-0.0649807, 0.395384, -4.149>, <7.66744e-05, 0.000831154, 0.00019159>,
                         <-0.0913353, 0.400242, -4.15939>, <7.72376e-05, 0.000848674, 0.000198356> }
        smooth_triangle {<-0.114678, 0.39823, -4.13375>, <0.000130013, 0.00106413, 0.00014797>,
                         <-0.130086, 0.398063, -4.09943>, <0.00018057, 0.0011875, 4.64575e-05>,
                         <-0.0992636, 0.393049, -4.09118>, <0.000170975, 0.00112108, 4.19387e-05> }
        smooth_triangle {<-0.0992636, 0.393049, -4.09118>, <0.000168472, 0.00111347, 5.00713e-05>,
                         <-0.0854246, 0.393228, -4.12372>, <0.000133876, 0.00103402, 0.000122573>,
                         <-0.114678, 0.39823, -4.13375>, <0.000137751, 0.00107076, 0.000129595> }
        smooth_triangle {<-0.130086, 0.398063, -4.09943>, <0.00018057, 0.0011875, 4.64575e-05>,
                         <-0.131035, 0.399318, -4.0621>, <0.000187567, 0.0010668, -5.71432e-05>,
                         <-0.101051, 0.394394, -4.05614>, <0.000177972, 0.00101238, -5.38389e-05> }
        smooth_triangle {<-0.101051, 0.394394, -4.05614>, <0.000180173, 0.00103297, -4.84997e-05>,
                         <-0.0992636, 0.393049, -4.09118>, <0.000174926, 0.00111449, 2.33335e-05>,
                         <-0.130086, 0.398063, -4.09943>, <0.000182122, 0.00116431, 2.67226e-05> }
        smooth_triangle {<-0.131035, 0.399318, -4.0621>, <0.000187567, 0.0010668, -5.71432e-05>,
                         <-0.122433, 0.401608, -4.02859>, <0.000164142, 0.000836632, -0.000116012>,
                         <-0.094873, 0.396848, -4.02431>, <0.000157786, 0.000806506, -0.000108597> }
        smooth_triangle {<-0.094873, 0.396848, -4.02431>, <0.000161186, 0.000834307, -0.000107449>,
                         <-0.101051, 0.394394, -4.05614>, <0.000176325, 0.000988711, -6.63806e-05>,
                         <-0.131035, 0.399318, -4.0621>, <0.000183521, 0.00102953, -6.88588e-05> }
        smooth_triangle {<-0.122433, 0.401608, -4.02859>, <0.000164142, 0.000836632, -0.000116012>,
                         <-0.110192, 0.40476, -3.99848>, <0.000141937, 0.000661781, -0.00013896>,
                         <-0.0856552, 0.400225, -3.99535>, <0.000137969, 0.000645882, -0.000130906> }
        smooth_triangle {<-0.0856552, 0.400225, -3.99535>, <0.000141561, 0.000674109, -0.000132416>,
                         <-0.094873, 0.396848, -4.02431>, <0.000156424, 0.000794577, -0.000115684>,
                         <-0.122433, 0.401608, -4.02859>, <0.00016119, 0.000817172, -0.000121246> }
        smooth_triangle {<-0.110192, 0.40476, -3.99848>, <0.000141937, 0.000661781, -0.00013896>,
                         <-0.0964826, 0.408741, -3.97041>, <0.000123769, 0.000531114, -0.000146864>,
                         <-0.0752021, 0.40449, -3.96812>, <0.000121155, 0.000522036, -0.000139423> }
        smooth_triangle {<-0.0752021, 0.40449, -3.96812>, <0.000125082, 0.000550356, -0.000142583>,
                         <-0.0856552, 0.400225, -3.99535>, <0.000137693, 0.00064324, -0.000136195>,
                         <-0.110192, 0.40476, -3.99848>, <0.000140669, 0.000655164, -0.000142235> }
        smooth_triangle {<-0.0964826, 0.408741, -3.97041>, <0.000123769, 0.000531114, -0.000146864>,
                         <-0.0819077, 0.413775, -3.94389>, <0.000105663, 0.000415511, -0.000149404>,
                         <-0.0640112, 0.409883, -3.94225>, <0.000103982, 0.000410383, -0.000143213> }
        smooth_triangle {<-0.0640112, 0.409883, -3.94225>, <0.000108566, 0.000438997, -0.000147997>,
                         <-0.0752021, 0.40449, -3.96812>, <0.000121446, 0.000522737, -0.000145154>,
                         <-0.0964826, 0.408741, -3.97041>, <0.000123406, 0.000529545, -0.000150735> }
        smooth_triangle {<-0.0819077, 0.413775, -3.94389>, <0.000105663, 0.000415511, -0.000149404>,
                         <-0.066535, 0.420386, -3.91916>, <8.49833e-05, 0.00030318, -0.00014689>,
                         <-0.0521215, 0.416967, -3.91801>, <8.40873e-05, 0.000300906, -0.000142408> }
        smooth_triangle {<-0.0521215, 0.416967, -3.91801>, <8.9546e-05, 0.000329268, -0.000150067>,
                         <-0.0640112, 0.409883, -3.94225>, <0.000104467, 0.000411376, -0.000150671>,
                         <-0.0819077, 0.413775, -3.94389>, <0.000105728, 0.000415222, -0.000155314> }
        smooth_triangle {<-0.066535, 0.420386, -3.91916>, <8.49833e-05, 0.00030318, -0.00014689>,
                         <-0.0502835, 0.429087, -3.89684>, <6.13272e-05, 0.000195797, -0.00013302>,
                         <-0.0394373, 0.42629, -3.89602>, <6.10279e-05, 0.000195395, -0.000130414> }
        smooth_triangle {<-0.0394373, 0.42629, -3.89602>, <6.72418e-05, 0.000222145, -0.000142248>,
                         <-0.0521215, 0.416967, -3.91801>, <8.45364e-05, 0.000301278, -0.000151243>,
                         <-0.066535, 0.420386, -3.91916>, <8.52084e-05, 0.000302983, -0.000154604> }
        smooth_triangle {<-0.0502835, 0.429087, -3.89684>, <6.13272e-05, 0.000195797, -0.00013302>,
                         <-0.033076, 0.440412, -3.87767>, <3.63634e-05, 0.000103109, -0.000100411>,
                         <-0.0258437, 0.438423, -3.87711>, <3.63394e-05, 0.000103289, -9.94662e-05> }
        smooth_triangle {<-0.0258437, 0.438423, -3.87711>, <4.29495e-05, 0.000125976, -0.000117008>,
                         <-0.0394373, 0.42629, -3.89602>, <6.14659e-05, 0.000195055, -0.000140219>,
                         <-0.0502835, 0.429087, -3.89684>, <6.16904e-05, 0.000195357, -0.000142173> }
        smooth_triangle {<-0.033076, 0.440412, -3.87767>, <3.63634e-05, 0.000103109, -0.000100411>,
                         <-0.0149628, 0.45404, -3.86187>, <1.3008e-05, 3.46681e-05, -4.48484e-05>,
                         <-0.0113495, 0.453024, -3.86157>, <1.30153e-05, 3.47052e-05, -4.48094e-05> }
        smooth_triangle {<-0.0113495, 0.453024, -3.86157>, <1.95412e-05, 5.20841e-05, -6.72153e-05>,
                         <-0.0258437, 0.438423, -3.87711>, <3.70343e-05, 0.000103522, -0.000108208>,
                         <-0.033076, 0.440412, -3.87767>, <3.70523e-05, 0.000103387, -0.000108916> }
        smooth_triangle {<-0.0149628, 0.45404, -3.86187>, <1.3008e-05, 3.46681e-05, -4.48484e-05>,
                         <0.00378372, 0.469002, -3.84852>, <-1.11721e-06, 6.64505e-07, 9.89889e-07>,
                         <0.00379075, 0.469055, -3.84855>, <-1.12965e-06, 5.62274e-07, 7.9087e-07> }
        smooth_triangle {<0.00379075, 0.469055, -3.84855>, <5.23611e-06, 1.45669e-05, -2.39062e-05>,
                         <-0.0113495, 0.453024, -3.86157>, <1.42533e-05, 3.6673e-05, -5.19321e-05>,
                         <-0.0149628, 0.45404, -3.86187>, <1.42479e-05, 3.66451e-05, -5.19614e-05> }
        smooth_triangle {<0.106735, 0.468949, -4.25461>, <-1.35754e-05, 4.91044e-05, 7.08686e-05>,
                         <0.0799565, 0.455565, -4.25047>, <-1.53627e-05, 7.1673e-05, 9.0089e-05>,
                         <0.0832981, 0.454589, -4.24915>, <-1.54216e-05, 7.14918e-05, 9.0104e-05> }
        smooth_triangle {<0.0832981, 0.454589, -4.24915>, <-1.19941e-05, 5.41646e-05, 6.71768e-05>,
                         <0.106709, 0.469002, -4.25451>, <-7.72675e-06, 2.54618e-05, 3.47083e-05>,
                         <0.106735, 0.468949, -4.25461>, <-7.64346e-06, 2.56437e-05, 3.46318e-05> }
        smooth_triangle {<0.0799565, 0.455565, -4.25047>, <-1.53627e-05, 7.1673e-05, 9.0089e-05>,
                         <0.0526041, 0.443941, -4.24401>, <-1.84016e-05, 0.000144915, 0.000141361>,
                         <0.0592729, 0.44207, -4.24133>, <-1.80256e-05, 0.000145374, 0.000140747> }
        smooth_triangle {<0.0592729, 0.44207, -4.24133>, <-1.57298e-05, 0.000123475, 0.000121882>,
                         <0.0832981, 0.454589, -4.24915>, <-1.37768e-05, 6.80631e-05, 8.39001e-05>,
                         <0.0799565, 0.455565, -4.25047>, <-1.37327e-05, 6.81991e-05, 8.38889e-05> }
        smooth_triangle {<0.0526041, 0.443941, -4.24401>, <-1.84016e-05, 0.000144915, 0.000141361>,
                         <0.0247248, 0.434501, -4.23537>, <-1.56702e-05, 0.000231769, 0.000176272>,
                         <0.0346891, 0.431904, -4.23121>, <-1.46667e-05, 0.000232878, 0.000174561> }
        smooth_triangle {<0.0346891, 0.431904, -4.23121>, <-1.30885e-05, 0.000208009, 0.000159366>,
                         <0.0592729, 0.44207, -4.24133>, <-1.56076e-05, 0.000142381, 0.000134005>,
                         <0.0526041, 0.443941, -4.24401>, <-1.58897e-05, 0.000142036, 0.000134466> }
        smooth_triangle {<0.0247248, 0.434501, -4.23537>, <-1.56702e-05, 0.000231769, 0.000176272>,
                         <-0.00346209, 0.426627, -4.22536>, <-1.14002e-05, 0.000322705, 0.000203734>,
                         <0.00978548, 0.423424, -4.2197>, <-9.91223e-06, 0.00032386, 0.000200906> }
        smooth_triangle {<0.00978548, 0.423424, -4.2197>, <-8.77721e-06, 0.00029748, 0.00018797>,
                         <0.0346891, 0.431904, -4.23121>, <-1.23431e-05, 0.000229244, 0.000168212>,
                         <0.0247248, 0.434501, -4.23537>, <-1.30957e-05, 0.000228412, 0.000169495> }
        smooth_triangle {<-0.00346209, 0.426627, -4.22536>, <-1.14002e-05, 0.000322705, 0.000203734>,
                         <-0.0318426, 0.419751, -4.21431>, <-5.54882e-06, 0.000418457, 0.000226968>,
                         <-0.0153126, 0.41602, -4.20718>, <-3.79933e-06, 0.00041878, 0.00022308> }
        smooth_triangle {<-0.0153126, 0.41602, -4.20718>, <-3.3111e-06, 0.000391057, 0.000211927>,
                         <0.00978548, 0.423424, -4.2197>, <-7.89577e-06, 0.000319867, 0.000195296>,
                         <-0.00346209, 0.426627, -4.22536>, <-9.01174e-06, 0.000319001, 0.000197417> }
        smooth_triangle {<-0.0318426, 0.419751, -4.21431>, <-5.54882e-06, 0.000418457, 0.000226968>,
                         <-0.0604006, 0.413767, -4.20202>, <5.21237e-06, 0.000526185, 0.000242858>,
                         <-0.0405842, 0.409575, -4.19352>, <7.00131e-06, 0.000524198, 0.000237709> }
        smooth_triangle {<-0.0405842, 0.409575, -4.19352>, <6.51151e-06, 0.000494652, 0.000228489>,
                         <-0.0153126, 0.41602, -4.20718>, <-1.58897e-06, 0.000415589, 0.000217517>,
                         <-0.0318426, 0.419751, -4.21431>, <-2.90109e-06, 0.000415346, 0.000220433> }
        smooth_triangle {<-0.0604006, 0.413767, -4.20202>, <5.21237e-06, 0.000526185, 0.000242858>,
                         <-0.0891134, 0.408751, -4.18787>, <2.69113e-05, 0.000662843, 0.00024528>,
                         <-0.0660079, 0.404173, -4.17818>, <2.81956e-05, 0.00065475, 0.000238391> }
        smooth_triangle {<-0.0660079, 0.404173, -4.17818>, <2.57372e-05, 0.000621082, 0.000232196>,
                         <-0.0405842, 0.409575, -4.19352>, <9.84147e-06, 0.000523168, 0.000231684>,
                         <-0.0604006, 0.413767, -4.20202>, <8.49977e-06, 0.000524658, 0.000235546> }
        smooth_triangle {<-0.0891134, 0.408751, -4.18787>, <2.69113e-05, 0.000662843, 0.00024528>,
                         <-0.11769, 0.4051, -4.16977>, <7.02655e-05, 0.000862105, 0.000221455>,
                         <-0.0913353, 0.400242, -4.15939>, <6.95145e-05, 0.000838743, 0.000212434> }
        smooth_triangle {<-0.0913353, 0.400242, -4.15939>, <6.41291e-05, 0.000798972, 0.000211019>,
                         <-0.0660079, 0.404173, -4.17818>, <3.31399e-05, 0.000660977, 0.000230487>,
                         <-0.0891134, 0.408751, -4.18787>, <3.21766e-05, 0.000667047, 0.000235654> }
        smooth_triangle {<-0.11769, 0.4051, -4.16977>, <7.02655e-05, 0.000862105, 0.000221455>,
                         <-0.143931, 0.403232, -4.14378>, <0.00013518, 0.00111311, 0.000157333>,
                         <-0.114678, 0.39823, -4.13375>, <0.000130013, 0.00106413, 0.00014797> }
        smooth_triangle {<-0.114678, 0.39823, -4.13375>, <0.000123422, 0.00102761, 0.000152581>,
                         <-0.0913353, 0.400242, -4.15939>, <7.80475e-05, 0.000858571, 0.000200929>,
                         <-0.11769, 0.4051, -4.16977>, <7.86108e-05, 0.000876092, 0.000207695> }
        smooth_triangle {<-0.143931, 0.403232, -4.14378>, <0.00013518, 0.00111311, 0.000157333>,
                         <-0.160908, 0.403077, -4.10768>, <0.000190166, 0.00125392, 5.09763e-05>,
                         <-0.130086, 0.398063, -4.09943>, <0.00018057, 0.0011875, 4.64575e-05> }
        smooth_triangle {<-0.130086, 0.398063, -4.09943>, <0.000177924, 0.00118024, 5.53351e-05>,
                         <-0.114678, 0.39823, -4.13375>, <0.000140006, 0.00108771, 0.000131469>,
                         <-0.143931, 0.403232, -4.14378>, <0.000143881, 0.00112445, 0.000138491> }
        smooth_triangle {<-0.160908, 0.403077, -4.10768>, <0.000190166, 0.00125392, 5.09763e-05>,
                         <-0.161019, 0.404242, -4.06806>, <0.000197162, 0.00112123, -6.04475e-05>,
                         <-0.131035, 0.399318, -4.0621>, <0.000187567, 0.0010668, -5.71432e-05> }
        smooth_triangle {<-0.131035, 0.399318, -4.0621>, <0.000190056, 0.00108971, -5.13381e-05>,
                         <-0.130086, 0.398063, -4.09943>, <0.000184809, 0.00118023, 2.63624e-05>,
                         <-0.160908, 0.403077, -4.10768>, <0.000192006, 0.00123005, 2.97515e-05> }
        smooth_triangle {<-0.161019, 0.404242, -4.06806>, <0.000197162, 0.00112123, -6.04475e-05>,
                         <-0.149992, 0.406369, -4.03287>, <0.000170497, 0.000866758, -0.000123428>,
                         <-0.122433, 0.401608, -4.02859>, <0.000164142, 0.000836632, -0.000116012> }
        smooth_triangle {<-0.122433, 0.401608, -4.02859>, <0.000167775, 0.000865876, -0.000114769>,
                         <-0.131035, 0.399318, -4.0621>, <0.000185344, 0.0010385, -7.06167e-05>,
                         <-0.161019, 0.404242, -4.06806>, <0.00019254, 0.00107932, -7.30949e-05> }
        smooth_triangle {<-0.149992, 0.406369, -4.03287>, <0.000170497, 0.000866758, -0.000123428>,
                         <-0.13473, 0.409296, -4.00162>, <0.000145905, 0.00067768, -0.000147014>,
                         <-0.110192, 0.40476, -3.99848>, <0.000141937, 0.000661781, -0.00013896> }
        smooth_triangle {<-0.110192, 0.40476, -3.99848>, <0.000145657, 0.000690679, -0.000140503>,
                         <-0.122433, 0.401608, -4.02859>, <0.000162311, 0.000821817, -0.000123292>,
                         <-0.149992, 0.406369, -4.03287>, <0.000167077, 0.000844411, -0.000128854> }
        smooth_triangle {<-0.13473, 0.409296, -4.00162>, <0.000145905, 0.00067768, -0.000147014>,
                         <-0.117763, 0.412992, -3.9727>, <0.000126384, 0.000540192, -0.000154305>,
                         <-0.0964826, 0.408741, -3.97041>, <0.000123769, 0.000531114, -0.000146864> }
        smooth_triangle {<-0.0964826, 0.408741, -3.97041>, <0.000127779, 0.000559798, -0.000150112>,
                         <-0.110192, 0.40476, -3.99848>, <0.000141405, 0.000657798, -0.000144184>,
                         <-0.13473, 0.409296, -4.00162>, <0.00014438, 0.000669722, -0.000150224> }
        smooth_triangle {<-0.117763, 0.412992, -3.9727>, <0.000126384, 0.000540192, -0.000154305>,
                         <-0.0998042, 0.417666, -3.94552>, <0.000107344, 0.000420639, -0.000155595>,
                         <-0.0819077, 0.413775, -3.94389>, <0.000105663, 0.000415511, -0.000149404> }
        smooth_triangle {<-0.0819077, 0.413775, -3.94389>, <0.000110316, 0.000444384, -0.000154324>,
                         <-0.0964826, 0.408741, -3.97041>, <0.000123895, 0.000531086, -0.000152419>,
                         <-0.117763, 0.412992, -3.9727>, <0.000125856, 0.000537895, -0.000158> }
        smooth_triangle {<-0.0998042, 0.417666, -3.94552>, <0.000107344, 0.000420639, -0.000155595>,
                         <-0.0809485, 0.423806, -3.9203>, <8.58793e-05, 0.000305453, -0.000151372>,
                         <-0.066535, 0.420386, -3.91916>, <8.49833e-05, 0.00030318, -0.00014689> }
        smooth_triangle {<-0.066535, 0.420386, -3.91916>, <9.05007e-05, 0.000331737, -0.000154704>,
                         <-0.0819077, 0.413775, -3.94389>, <0.000106011, 0.000415986, -0.00015659>,
                         <-0.0998042, 0.417666, -3.94552>, <0.000107271, 0.000419832, -0.000161233> }
        smooth_triangle {<-0.0809485, 0.423806, -3.9203>, <8.58793e-05, 0.000305453, -0.000151372>,
                         <-0.0611297, 0.431885, -3.89765>, <6.16265e-05, 0.000196199, -0.000135626>,
                         <-0.0502835, 0.429087, -3.89684>, <6.13272e-05, 0.000195797, -0.00013302> }
        smooth_triangle {<-0.0502835, 0.429087, -3.89684>, <6.75729e-05, 0.000222624, -0.000145012>,
                         <-0.066535, 0.420386, -3.91916>, <8.5315e-05, 0.000303161, -0.000155414>,
                         <-0.0809485, 0.423806, -3.9203>, <8.59871e-05, 0.000304866, -0.000158776> }
        smooth_triangle {<-0.0611297, 0.431885, -3.89765>, <6.16265e-05, 0.000196199, -0.000135626>,
                         <-0.0403084, 0.442401, -3.87824>, <3.63874e-05, 0.000102929, -0.000101355>,
                         <-0.033076, 0.440412, -3.87767>, <3.63634e-05, 0.000103109, -0.000100411> }
        smooth_triangle {<-0.033076, 0.440412, -3.87767>, <4.29786e-05, 0.000125787, -0.000118051>,
                         <-0.0502835, 0.429087, -3.89684>, <6.17015e-05, 0.000195303, -0.000142508>,
                         <-0.0611297, 0.431885, -3.89765>, <6.19259e-05, 0.000195604, -0.000144462> }
        smooth_triangle {<-0.0403084, 0.442401, -3.87824>, <3.63874e-05, 0.000102929, -0.000101355>,
                         <-0.0185762, 0.455055, -3.86217>, <1.30008e-05, 3.4631e-05, -4.48875e-05>,
                         <-0.0149628, 0.45404, -3.86187>, <1.3008e-05, 3.46681e-05, -4.48484e-05> }
        smooth_triangle {<-0.0149628, 0.45404, -3.86187>, <1.95315e-05, 5.20296e-05, -6.72842e-05>,
                         <-0.033076, 0.440412, -3.87767>, <3.7048e-05, 0.00010336, -0.000108956>,
                         <-0.0403084, 0.442401, -3.87824>, <3.7066e-05, 0.000103225, -0.000109664> }
        smooth_triangle {<-0.0185762, 0.455055, -3.86217>, <1.30008e-05, 3.4631e-05, -4.48875e-05>,
                         <0.00377669, 0.468949, -3.8485>, <-1.10477e-06, 7.66737e-07, 1.18891e-06>,
                         <0.00378372, 0.469002, -3.84852>, <-1.11721e-06, 6.64505e-07, 9.89889e-07> }
        smooth_triangle {<0.00378372, 0.469002, -3.84852>, <5.24855e-06, 1.46692e-05, -2.37072e-05>,
                         <-0.0149628, 0.45404, -3.86187>, <1.4251e-05, 3.66707e-05, -5.19117e-05>,
                         <-0.0185762, 0.455055, -3.86217>, <1.42456e-05, 3.66429e-05, -5.1941e-05> }
        smooth_triangle {<0.10676, 0.468896, -4.25471>, <-1.34089e-05, 4.94683e-05, 7.07157e-05>,
                         <0.076615, 0.456541, -4.25179>, <-1.53039e-05, 7.18542e-05, 9.0074e-05>,
                         <0.0799565, 0.455565, -4.25047>, <-1.53627e-05, 7.1673e-05, 9.0089e-05> }
        smooth_triangle {<0.0799565, 0.455565, -4.25047>, <-1.19083e-05, 5.43914e-05, 6.71273e-05>,
                         <0.106735, 0.468949, -4.25461>, <-7.56017e-06, 2.58256e-05, 3.45554e-05>,
                         <0.10676, 0.468896, -4.25471>, <-7.47689e-06, 2.60075e-05, 3.44789e-05> }
        smooth_triangle {<0.076615, 0.456541, -4.25179>, <-1.53039e-05, 7.18542e-05, 9.0074e-05>,
                         <0.0459352, 0.445812, -4.24669>, <-1.87776e-05, 0.000144455, 0.000141976>,
                         <0.0526041, 0.443941, -4.24401>, <-1.84016e-05, 0.000144915, 0.000141361> }
        smooth_triangle {<0.0526041, 0.443941, -4.24401>, <-1.6051e-05, 0.000123084, 0.000122408>,
                         <0.0799565, 0.455565, -4.25047>, <-1.37718e-05, 6.81531e-05, 8.39541e-05>,
                         <0.076615, 0.456541, -4.25179>, <-1.37277e-05, 6.8289e-05, 8.39428e-05> }
        smooth_triangle {<0.0459352, 0.445812, -4.24669>, <-1.87776e-05, 0.000144455, 0.000141976>,
                         <0.0147605, 0.437098, -4.23953>, <-1.66737e-05, 0.000230659, 0.000177984>,
                         <0.0247248, 0.434501, -4.23537>, <-1.56702e-05, 0.000231769, 0.000176272> }
        smooth_triangle {<0.0247248, 0.434501, -4.23537>, <-1.40448e-05, 0.000206925, 0.00016098>,
                         <0.0526041, 0.443941, -4.24401>, <-1.60934e-05, 0.000141784, 0.000134797>,
                         <0.0459352, 0.445812, -4.24669>, <-1.63754e-05, 0.000141439, 0.000135258> }
        smooth_triangle {<0.0147605, 0.437098, -4.23953>, <-1.66737e-05, 0.000230659, 0.000177984>,
                         <-0.0167097, 0.429829, -4.23102>, <-1.28881e-05, 0.00032155, 0.000206563>,
                         <-0.00346209, 0.426627, -4.22536>, <-1.14002e-05, 0.000322705, 0.000203734> }
        smooth_triangle {<-0.00346209, 0.426627, -4.22536>, <-1.02383e-05, 0.000296287, 0.000190714>,
                         <0.0247248, 0.434501, -4.23537>, <-1.34409e-05, 0.000228084, 0.000170118>,
                         <0.0147605, 0.437098, -4.23953>, <-1.41935e-05, 0.000227252, 0.000171401> }
        smooth_triangle {<-0.0167097, 0.429829, -4.23102>, <-1.28881e-05, 0.00032155, 0.000206563>,
                         <-0.0483726, 0.423482, -4.22144>, <-7.29831e-06, 0.000418134, 0.000230855>,
                         <-0.0318426, 0.419751, -4.21431>, <-5.54882e-06, 0.000418457, 0.000226968> }
        smooth_triangle {<-0.0318426, 0.419751, -4.21431>, <-5.04883e-06, 0.000390604, 0.000215719>,
                         <-0.00346209, 0.426627, -4.22536>, <-9.43736e-06, 0.000318789, 0.000198294>,
                         <-0.0167097, 0.429829, -4.23102>, <-1.05533e-05, 0.000317923, 0.000200415> }
        smooth_triangle {<-0.0483726, 0.423482, -4.22144>, <-7.29831e-06, 0.000418134, 0.000230855>,
                         <-0.080217, 0.417958, -4.21053>, <3.42343e-06, 0.000528172, 0.000248007>,
                         <-0.0604006, 0.413767, -4.20202>, <5.21237e-06, 0.000526185, 0.000242858> }
        smooth_triangle {<-0.0604006, 0.413767, -4.20202>, <4.70893e-06, 0.000496323, 0.000233514>,
                         <-0.0318426, 0.419751, -4.21431>, <-3.36196e-06, 0.000415527, 0.000221596>,
                         <-0.0483726, 0.423482, -4.22144>, <-4.67408e-06, 0.000415285, 0.000224512> }
        smooth_triangle {<-0.080217, 0.417958, -4.21053>, <3.42343e-06, 0.000528172, 0.000248007>,
                         <-0.112219, 0.413328, -4.19755>, <2.56269e-05, 0.000670936, 0.000252169>,
                         <-0.0891134, 0.408751, -4.18787>, <2.69113e-05, 0.000662843, 0.00024528> }
        smooth_triangle {<-0.0891134, 0.408751, -4.18787>, <2.4354e-05, 0.000628281, 0.000238898>,
                         <-0.0604006, 0.413767, -4.20202>, <8.07981e-06, 0.000525787, 0.000237081>,
                         <-0.080217, 0.417958, -4.21053>, <6.7381e-06, 0.000527277, 0.000240943> }
        smooth_triangle {<-0.112219, 0.413328, -4.19755>, <2.56269e-05, 0.000670936, 0.000252169>,
                         <-0.144044, 0.409959, -4.18016>, <7.10165e-05, 0.000885466, 0.000230476>,
                         <-0.11769, 0.4051, -4.16977>, <7.02655e-05, 0.000862105, 0.000221455> }
        smooth_triangle {<-0.11769, 0.4051, -4.16977>, <6.4569e-05, 0.000820305, 0.000219881>,
                         <-0.0891134, 0.408751, -4.18787>, <3.20533e-05, 0.000670859, 0.00023775>,
                         <-0.112219, 0.413328, -4.19755>, <3.109e-05, 0.000676929, 0.000242916> }
        smooth_triangle {<-0.144044, 0.409959, -4.18016>, <7.10165e-05, 0.000885466, 0.000230476>,
                         <-0.173184, 0.408234, -4.15381>, <0.000140347, 0.0011621, 0.000166695>,
                         <-0.143931, 0.403232, -4.14378>, <0.00013518, 0.00111311, 0.000157333> }
        smooth_triangle {<-0.143931, 0.403232, -4.14378>, <0.000128107, 0.00107424, 0.000162177>,
                         <-0.11769, 0.4051, -4.16977>, <7.94207e-05, 0.000885988, 0.000210269>,
                         <-0.144044, 0.409959, -4.18016>, <7.9984e-05, 0.000903509, 0.000217035> }
        smooth_triangle {<-0.173184, 0.408234, -4.15381>, <0.000140347, 0.0011621, 0.000166695>,
                         <-0.19173, 0.408091, -4.11593>, <0.000199762, 0.00132034, 5.54951e-05>,
                         <-0.160908, 0.403077, -4.10768>, <0.000190166, 0.00125392, 5.09763e-05> }
        smooth_triangle {<-0.160908, 0.403077, -4.10768>, <0.000187376, 0.001247, 6.05988e-05>,
                         <-0.143931, 0.403232, -4.14378>, <0.000146137, 0.00114139, 0.000140366>,
                         <-0.173184, 0.408234, -4.15381>, <0.000150012, 0.00117813, 0.000147388> }
        smooth_triangle {<-0.19173, 0.408091, -4.11593>, <0.000199762, 0.00132034, 5.54951e-05>,
                         <-0.191002, 0.409167, -4.07402>, <0.000206756, 0.00117565, -6.37518e-05>,
                         <-0.161019, 0.404242, -4.06806>, <0.000197162, 0.00112123, -6.04475e-05> }
        smooth_triangle {<-0.161019, 0.404242, -4.06806>, <0.000199939, 0.00114645, -5.41764e-05>,
                         <-0.160908, 0.403077, -4.10768>, <0.000194692, 0.00124597, 2.93914e-05>,
                         <-0.19173, 0.408091, -4.11593>, <0.000201889, 0.00129578, 3.27805e-05> }
        smooth_triangle {<-0.191002, 0.409167, -4.07402>, <0.000206756, 0.00117565, -6.37518e-05>,
                         <-0.177552, 0.41113, -4.03715>, <0.000176852, 0.000896884, -0.000130844>,
                         <-0.149992, 0.406369, -4.03287>, <0.000170497, 0.000866758, -0.000123428> }
        smooth_triangle {<-0.149992, 0.406369, -4.03287>, <0.000174365, 0.000897446, -0.000122088>,
                         <-0.161019, 0.404242, -4.06806>, <0.000194364, 0.0010883, -7.48528e-05>,
                         <-0.191002, 0.409167, -4.07402>, <0.00020156, 0.00112912, -7.73311e-05> }
        smooth_triangle {<-0.177552, 0.41113, -4.03715>, <0.000176852, 0.000896884, -0.000130844>,
                         <-0.159267, 0.413831, -4.00475>, <0.000149873, 0.000693579, -0.000155068>,
                         <-0.13473, 0.409296, -4.00162>, <0.000145905, 0.00067768, -0.000147014> }
        smooth_triangle {<-0.13473, 0.409296, -4.00162>, <0.000149753, 0.000707248, -0.000148589>,
                         <-0.149992, 0.406369, -4.03287>, <0.000168197, 0.000849057, -0.0001309>,
                         <-0.177552, 0.41113, -4.03715>, <0.000172964, 0.000871651, -0.000136462> }
        smooth_triangle {<-0.159267, 0.413831, -4.00475>, <0.000149873, 0.000693579, -0.000155068>,
                         <-0.139044, 0.417243, -3.97499>, <0.000128998, 0.00054927, -0.000161747>,
                         <-0.117763, 0.412992, -3.9727>, <0.000126384, 0.000540192, -0.000154305> }
        smooth_triangle {<-0.117763, 0.412992, -3.9727>, <0.000130475, 0.00056924, -0.000157642>,
                         <-0.13473, 0.409296, -4.00162>, <0.000145116, 0.000672355, -0.000152173>,
                         <-0.159267, 0.413831, -4.00475>, <0.000148092, 0.00068428, -0.000158214> }
        smooth_triangle {<-0.139044, 0.417243, -3.97499>, <0.000128998, 0.00054927, -0.000161747>,
                         <-0.117701, 0.421558, -3.94716>, <0.000109025, 0.000425767, -0.000161786>,
                         <-0.0998042, 0.417666, -3.94552>, <0.000107344, 0.000420639, -0.000155595> }
        smooth_triangle {<-0.0998042, 0.417666, -3.94552>, <0.000112066, 0.000449771, -0.000160651>,
                         <-0.117763, 0.412992, -3.9727>, <0.000126345, 0.000539436, -0.000159684>,
                         <-0.139044, 0.417243, -3.97499>, <0.000128306, 0.000546245, -0.000165265> }
        smooth_triangle {<-0.117701, 0.421558, -3.94716>, <0.000109025, 0.000425767, -0.000161786>,
                         <-0.095362, 0.427225, -3.92145>, <8.67753e-05, 0.000307727, -0.000155854>,
                         <-0.0809485, 0.423806, -3.9203>, <8.58793e-05, 0.000305453, -0.000151372> }
        smooth_triangle {<-0.0809485, 0.423806, -3.9203>, <9.14554e-05, 0.000334206, -0.000159341>,
                         <-0.0998042, 0.417666, -3.94552>, <0.000107554, 0.000420595, -0.000162509>,
                         <-0.117701, 0.421558, -3.94716>, <0.000108815, 0.000424441, -0.000167152> }
        smooth_triangle {<-0.095362, 0.427225, -3.92145>, <8.67753e-05, 0.000307727, -0.000155854>,
                         <-0.0719759, 0.434683, -3.89846>, <6.19257e-05, 0.000196602, -0.000138232>,
                         <-0.0611297, 0.431885, -3.89765>, <6.16265e-05, 0.000196199, -0.000135626> }
        smooth_triangle {<-0.0611297, 0.431885, -3.89765>, <6.79041e-05, 0.000223104, -0.000147776>,
                         <-0.0809485, 0.423806, -3.9203>, <8.60937e-05, 0.000305044, -0.000159586>,
                         <-0.095362, 0.427225, -3.92145>, <8.67657e-05, 0.000306749, -0.000162947> }
        smooth_triangle {<-0.0719759, 0.434683, -3.89846>, <6.19257e-05, 0.000196602, -0.000138232>,
                         <-0.0475408, 0.44439, -3.8788>, <3.64113e-05, 0.000102749, -0.0001023>,
                         <-0.0403084, 0.442401, -3.87824>, <3.63874e-05, 0.000102929, -0.000101355> }
        smooth_triangle {<-0.0403084, 0.442401, -3.87824>, <4.30077e-05, 0.000125597, -0.000119094>,
                         <-0.0611297, 0.431885, -3.89765>, <6.19371e-05, 0.00019555, -0.000144797>,
                         <-0.0719759, 0.434683, -3.89846>, <6.21615e-05, 0.000195852, -0.000146751> }
        smooth_triangle {<-0.0475408, 0.44439, -3.8788>, <3.64113e-05, 0.000102749, -0.0001023>,
                         <-0.0221895, 0.456071, -3.86246>, <1.29936e-05, 3.45939e-05, -4.49266e-05>,
                         <-0.0185762, 0.455055, -3.86217>, <1.30008e-05, 3.4631e-05, -4.48875e-05> }
        smooth_triangle {<-0.0185762, 0.455055, -3.86217>, <1.95218e-05, 5.19751e-05, -6.7353e-05>,
                         <-0.0403084, 0.442401, -3.87824>, <3.70617e-05, 0.000103199, -0.000109704>,
                         <-0.0475408, 0.44439, -3.8788>, <3.70797e-05, 0.000103064, -0.000110412> }
        smooth_triangle {<-0.0221895, 0.456071, -3.86246>, <1.29936e-05, 3.45939e-05, -4.49266e-05>,
                         <0.00376967, 0.468896, -3.84847>, <-1.09233e-06, 8.68969e-07, 1.38793e-06>,
                         <0.00377669, 0.468949, -3.8485>, <-1.10477e-06, 7.66737e-07, 1.18891e-06> }
        smooth_triangle {<0.00377669, 0.468949, -3.8485>, <5.26099e-06, 1.47714e-05, -2.35082e-05>,
                         <-0.0185762, 0.455055, -3.86217>, <1.42487e-05, 3.66685e-05, -5.18912e-05>,
                         <-0.0221895, 0.456071, -3.86246>, <1.42433e-05, 3.66406e-05, -5.19206e-05> }
        smooth_triangle {<0.106785, 0.468842, -4.25481>, <-1.32423e-05, 4.98321e-05, 7.05627e-05>,
                         <0.0732734, 0.457518, -4.2531>, <-1.5245e-05, 7.20354e-05, 9.0059e-05>,
                         <0.076615, 0.456541, -4.25179>, <-1.53039e-05, 7.18542e-05, 9.0074e-05> }
        smooth_triangle {<0.076615, 0.456541, -4.25179>, <-1.18225e-05, 5.46183e-05, 6.70778e-05>,
                         <0.10676, 0.468896, -4.25471>, <-7.3936e-06, 2.61894e-05, 3.44024e-05>,
                         <0.106785, 0.468842, -4.25481>, <-7.31031e-06, 2.63714e-05, 3.43259e-05> }
        smooth_triangle {<0.0732734, 0.457518, -4.2531>, <-1.5245e-05, 7.20354e-05, 9.0059e-05>,
                         <0.0392664, 0.447682, -4.24938>, <-1.91536e-05, 0.000143996, 0.00014259>,
                         <0.0459352, 0.445812, -4.24669>, <-1.87776e-05, 0.000144455, 0.000141976> }
        smooth_triangle {<0.0459352, 0.445812, -4.24669>, <-1.63721e-05, 0.000122694, 0.000122934>,
                         <0.076615, 0.456541, -4.25179>, <-1.37668e-05, 6.8243e-05, 8.40081e-05>,
                         <0.0732734, 0.457518, -4.2531>, <-1.37227e-05, 6.83789e-05, 8.39968e-05> }
        smooth_triangle {<0.0392664, 0.447682, -4.24938>, <-1.91536e-05, 0.000143996, 0.00014259>,
                         <0.00479617, 0.439694, -4.24369>, <-1.76772e-05, 0.00022955, 0.000179695>,
                         <0.0147605, 0.437098, -4.23953>, <-1.66737e-05, 0.000230659, 0.000177984> }
        smooth_triangle {<0.0147605, 0.437098, -4.23953>, <-1.50012e-05, 0.00020584, 0.000162594>,
                         <0.0459352, 0.445812, -4.24669>, <-1.65791e-05, 0.000141187, 0.000135588>,
                         <0.0392664, 0.447682, -4.24938>, <-1.68611e-05, 0.000140843, 0.000136049> }
        smooth_triangle {<0.00479617, 0.439694, -4.24369>, <-1.76772e-05, 0.00022955, 0.000179695>,
                         <-0.0299572, 0.433032, -4.23668>, <-1.43761e-05, 0.000320396, 0.000209391>,
                         <-0.0167097, 0.429829, -4.23102>, <-1.28881e-05, 0.00032155, 0.000206563> }
        smooth_triangle {<-0.0167097, 0.429829, -4.23102>, <-1.16995e-05, 0.000295093, 0.000193458>,
                         <0.0147605, 0.437098, -4.23953>, <-1.45386e-05, 0.000226925, 0.000172024>,
                         <0.00479617, 0.439694, -4.24369>, <-1.52913e-05, 0.000226093, 0.000173307> }
        smooth_triangle {<-0.0299572, 0.433032, -4.23668>, <-1.43761e-05, 0.000320396, 0.000209391>,
                         <-0.0649026, 0.427214, -4.22857>, <-9.0478e-06, 0.000417811, 0.000234743>,
                         <-0.0483726, 0.423482, -4.22144>, <-7.29831e-06, 0.000418134, 0.000230855> }
        smooth_triangle {<-0.0483726, 0.423482, -4.22144>, <-6.78657e-06, 0.00039015, 0.000219511>,
                         <-0.0167097, 0.429829, -4.23102>, <-1.0979e-05, 0.000317712, 0.000201291>,
                         <-0.0299572, 0.433032, -4.23668>, <-1.20949e-05, 0.000316846, 0.000203413> }
        smooth_triangle {<-0.0649026, 0.427214, -4.22857>, <-9.0478e-06, 0.000417811, 0.000234743>,
                         <-0.100033, 0.42215, -4.21903>, <1.63449e-06, 0.000530159, 0.000253156>,
                         <-0.080217, 0.417958, -4.21053>, <3.42343e-06, 0.000528172, 0.000248007> }
        smooth_triangle {<-0.080217, 0.417958, -4.21053>, <2.90635e-06, 0.000497994, 0.000238539>,
                         <-0.0483726, 0.423482, -4.22144>, <-5.13495e-06, 0.000415465, 0.000225675>,
                         <-0.0649026, 0.427214, -4.22857>, <-6.44707e-06, 0.000415223, 0.000228591> }
        smooth_triangle {<-0.100033, 0.42215, -4.21903>, <1.63449e-06, 0.000530159, 0.000253156>,
                         <-0.135325, 0.417906, -4.20724>, <2.43426e-05, 0.000679029, 0.000259058>,
                         <-0.112219, 0.413328, -4.19755>, <2.56269e-05, 0.000670936, 0.000252169> }
        smooth_triangle {<-0.112219, 0.413328, -4.19755>, <2.29708e-05, 0.000635479, 0.0002456>,
                         <-0.080217, 0.417958, -4.21053>, <6.31814e-06, 0.000528406, 0.000242479>,
                         <-0.100033, 0.42215, -4.21903>, <4.97644e-06, 0.000529896, 0.00024634> }
        smooth_triangle {<-0.135325, 0.417906, -4.20724>, <2.43426e-05, 0.000679029, 0.000259058>,
                         <-0.170399, 0.414817, -4.19055>, <7.17675e-05, 0.000908827, 0.000239497>,
                         <-0.144044, 0.409959, -4.18016>, <7.10165e-05, 0.000885466, 0.000230476> }
        smooth_triangle {<-0.144044, 0.409959, -4.18016>, <6.50089e-05, 0.000841638, 0.000228742>,
                         <-0.112219, 0.413328, -4.19755>, <3.09667e-05, 0.000680741, 0.000245012>,
                         <-0.135325, 0.417906, -4.20724>, <3.00034e-05, 0.000686811, 0.000250179> }
        smooth_triangle {<-0.170399, 0.414817, -4.19055>, <7.17675e-05, 0.000908827, 0.000239497>,
                         <-0.202437, 0.413236, -4.16383>, <0.000145513, 0.00121108, 0.000176058>,
                         <-0.173184, 0.408234, -4.15381>, <0.000140347, 0.0011621, 0.000166695> }
        smooth_triangle {<-0.173184, 0.408234, -4.15381>, <0.000132792, 0.00112088, 0.000171773>,
                         <-0.144044, 0.409959, -4.18016>, <8.07939e-05, 0.000913405, 0.000219608>,
                         <-0.170399, 0.414817, -4.19055>, <8.13572e-05, 0.000930926, 0.000226374> }
        smooth_triangle {<-0.202437, 0.413236, -4.16383>, <0.000145513, 0.00121108, 0.000176058>,
                         <-0.222552, 0.413105, -4.12418>, <0.000209357, 0.00138676, 6.00139e-05>,
                         <-0.19173, 0.408091, -4.11593>, <0.000199762, 0.00132034, 5.54951e-05> }
        smooth_triangle {<-0.19173, 0.408091, -4.11593>, <0.000196828, 0.00131376, 6.58626e-05>,
                         <-0.173184, 0.408234, -4.15381>, <0.000152267, 0.00119508, 0.000149263>,
                         <-0.202437, 0.413236, -4.16383>, <0.000156142, 0.00123182, 0.000156285> }
        smooth_triangle {<-0.222552, 0.413105, -4.12418>, <0.000209357, 0.00138676, 6.00139e-05>,
                         <-0.220986, 0.414091, -4.07997>, <0.000216351, 0.00123008, -6.70561e-05>,
                         <-0.191002, 0.409167, -4.07402>, <0.000206756, 0.00117565, -6.37518e-05> }
        smooth_triangle {<-0.191002, 0.409167, -4.07402>, <0.000209821, 0.00120319, -5.70148e-05>,
                         <-0.19173, 0.408091, -4.11593>, <0.000204575, 0.00131171, 3.24203e-05>,
                         <-0.222552, 0.413105, -4.12418>, <0.000211772, 0.00136152, 3.58095e-05> }
        smooth_triangle {<-0.220986, 0.414091, -4.07997>, <0.000216351, 0.00123008, -6.70561e-05>,
                         <-0.205111, 0.415891, -4.04142>, <0.000183208, 0.00092701, -0.000138259>,
                         <-0.177552, 0.41113, -4.03715>, <0.000176852, 0.000896884, -0.000130844> }
        smooth_triangle {<-0.177552, 0.41113, -4.03715>, <0.000180955, 0.000929015, -0.000129408>,
                         <-0.191002, 0.409167, -4.07402>, <0.000203383, 0.00113809, -7.9089e-05>,
                         <-0.220986, 0.414091, -4.07997>, <0.000210579, 0.00117891, -8.15672e-05> }
        smooth_triangle {<-0.205111, 0.415891, -4.04142>, <0.000183208, 0.00092701, -0.000138259>,
                         <-0.183804, 0.418367, -4.00789>, <0.000153841, 0.000709477, -0.000163122>,
                         <-0.159267, 0.413831, -4.00475>, <0.000149873, 0.000693579, -0.000155068> }
        smooth_triangle {<-0.159267, 0.413831, -4.00475>, <0.000153849, 0.000723817, -0.000156676>,
                         <-0.177552, 0.41113, -4.03715>, <0.000174084, 0.000876296, -0.000138508>,
                         <-0.205111, 0.415891, -4.04142>, <0.00017885, 0.000898891, -0.000144069> }
        smooth_triangle {<-0.183804, 0.418367, -4.00789>, <0.000153841, 0.000709477, -0.000163122>,
                         <-0.160324, 0.421495, -3.97728>, <0.000131612, 0.000558348, -0.000169188>,
                         <-0.139044, 0.417243, -3.97499>, <0.000128998, 0.00054927, -0.000161747> }
        smooth_triangle {<-0.139044, 0.417243, -3.97499>, <0.000133172, 0.000578682, -0.000165172>,
                         <-0.159267, 0.413831, -4.00475>, <0.000148828, 0.000686913, -0.000160162>,
                         <-0.183804, 0.418367, -4.00789>, <0.000151804, 0.000698837, -0.000166203> }
        smooth_triangle {<-0.160324, 0.421495, -3.97728>, <0.000131612, 0.000558348, -0.000169188>,
                         <-0.135597, 0.42545, -3.94879>, <0.000110706, 0.000430895, -0.000167976>,
                         <-0.117701, 0.421558, -3.94716>, <0.000109025, 0.000425767, -0.000161786> }
        smooth_triangle {<-0.117701, 0.421558, -3.94716>, <0.000113815, 0.000455159, -0.000166977>,
                         <-0.139044, 0.417243, -3.97499>, <0.000128795, 0.000547786, -0.000166948>,
                         <-0.160324, 0.421495, -3.97728>, <0.000130755, 0.000554594, -0.000172529> }
        smooth_triangle {<-0.135597, 0.42545, -3.94879>, <0.000110706, 0.000430895, -0.000167976>,
                         <-0.109775, 0.430644, -3.9226>, <8.76714e-05, 0.00031, -0.000160336>,
                         <-0.095362, 0.427225, -3.92145>, <8.67753e-05, 0.000307727, -0.000155854> }
        smooth_triangle {<-0.095362, 0.427225, -3.92145>, <9.241e-05, 0.000336674, -0.000163979>,
                         <-0.117701, 0.421558, -3.94716>, <0.000109097, 0.000425205, -0.000168428>,
                         <-0.135597, 0.42545, -3.94879>, <0.000110358, 0.000429051, -0.000173071> }
        smooth_triangle {<-0.109775, 0.430644, -3.9226>, <8.76714e-05, 0.00031, -0.000160336>,
                         <-0.0828221, 0.437481, -3.89928>, <6.2225e-05, 0.000197004, -0.000140838>,
                         <-0.0719759, 0.434683, -3.89846>, <6.19257e-05, 0.000196602, -0.000138232> }
        smooth_triangle {<-0.0719759, 0.434683, -3.89846>, <6.82352e-05, 0.000223584, -0.000150541>,
                         <-0.095362, 0.427225, -3.92145>, <8.68724e-05, 0.000306927, -0.000163757>,
                         <-0.109775, 0.430644, -3.9226>, <8.75444e-05, 0.000308632, -0.000167119> }
        smooth_triangle {<-0.0828221, 0.437481, -3.89928>, <6.2225e-05, 0.000197004, -0.000140838>,
                         <-0.0547732, 0.446379, -3.87936>, <3.64353e-05, 0.000102569, -0.000103245>,
                         <-0.0475408, 0.44439, -3.8788>, <3.64113e-05, 0.000102749, -0.0001023> }
        smooth_triangle {<-0.0475408, 0.44439, -3.8788>, <4.30369e-05, 0.000125408, -0.000120137>,
                         <-0.0719759, 0.434683, -3.89846>, <6.21727e-05, 0.000195798, -0.000147086>,
                         <-0.0828221, 0.437481, -3.89928>, <6.23971e-05, 0.0001961, -0.00014904> }
        smooth_triangle {<-0.0547732, 0.446379, -3.87936>, <3.64353e-05, 0.000102569, -0.000103245>,
                         <-0.0258029, 0.457087, -3.86276>, <1.29864e-05, 3.45569e-05, -4.49657e-05>,
                         <-0.0221895, 0.456071, -3.86246>, <1.29936e-05, 3.45939e-05, -4.49266e-05> }
        smooth_triangle {<-0.0221895, 0.456071, -3.86246>, <1.95121e-05, 5.19206e-05, -6.74218e-05>,
                         <-0.0475408, 0.44439, -3.8788>, <3.70755e-05, 0.000103037, -0.000110452>,
                         <-0.0547732, 0.446379, -3.87936>, <3.70935e-05, 0.000102902, -0.00011116> }
        smooth_triangle {<-0.0258029, 0.457087, -3.86276>, <1.29864e-05, 3.45569e-05, -4.49657e-05>,
                         <0.00376264, 0.468842, -3.84844>, <-1.07989e-06, 9.712e-07, 1.58695e-06>,
                         <0.00376967, 0.468896, -3.84847>, <-1.09233e-06, 8.68969e-07, 1.38793e-06> }
        smooth_triangle {<0.00376967, 0.468896, -3.84847>, <5.27344e-06, 1.48736e-05, -2.33092e-05>,
                         <-0.0221895, 0.456071, -3.86246>, <1.42464e-05, 3.66662e-05, -5.18708e-05>,
                         <-0.0258029, 0.457087, -3.86276>, <1.4241e-05, 3.66384e-05, -5.19001e-05> }
        smooth_triangle {<0.10681, 0.468789, -4.25491>, <-1.30757e-05, 5.01959e-05, 7.04098e-05>,
                         <0.0699318, 0.458494, -4.25442>, <-1.51861e-05, 7.22167e-05, 9.0044e-05>,
                         <0.0732734, 0.457518, -4.2531>, <-1.5245e-05, 7.20354e-05, 9.0059e-05> }
        smooth_triangle {<0.0732734, 0.457518, -4.2531>, <-1.17367e-05, 5.48452e-05, 6.70283e-05>,
                         <0.106785, 0.468842, -4.25481>, <-7.22702e-06, 2.65533e-05, 3.42495e-05>,
                         <0.10681, 0.468789, -4.25491>, <-7.14374e-06, 2.67352e-05, 3.4173e-05> }
        smooth_triangle {<0.0699318, 0.458494, -4.25442>, <-1.51861e-05, 7.22167e-05, 9.0044e-05>,
                         <0.0325976, 0.449553, -4.25206>, <-1.95296e-05, 0.000143537, 0.000143205>,
                         <0.0392664, 0.447682, -4.24938>, <-1.91536e-05, 0.000143996, 0.00014259> }
        smooth_triangle {<0.0392664, 0.447682, -4.24938>, <-1.66933e-05, 0.000122303, 0.000123461>,
                         <0.0732734, 0.457518, -4.2531>, <-1.37618e-05, 6.83329e-05, 8.40621e-05>,
                         <0.0699318, 0.458494, -4.25442>, <-1.37177e-05, 6.84688e-05, 8.40508e-05> }
        smooth_triangle {<0.0325976, 0.449553, -4.25206>, <-1.95296e-05, 0.000143537, 0.000143205>,
                         <-0.00516815, 0.442291, -4.24785>, <-1.86807e-05, 0.000228441, 0.000181406>,
                         <0.00479617, 0.439694, -4.24369>, <-1.76772e-05, 0.00022955, 0.000179695> }
        smooth_triangle {<0.00479617, 0.439694, -4.24369>, <-1.59575e-05, 0.000204756, 0.000164208>,
                         <0.0392664, 0.447682, -4.24938>, <-1.70648e-05, 0.00014059, 0.000136379>,
                         <0.0325976, 0.449553, -4.25206>, <-1.73469e-05, 0.000140246, 0.00013684> }
        smooth_triangle {<-0.00516815, 0.442291, -4.24785>, <-1.86807e-05, 0.000228441, 0.000181406>,
                         <-0.0432048, 0.436234, -4.24235>, <-1.58641e-05, 0.000319241, 0.00021222>,
                         <-0.0299572, 0.433032, -4.23668>, <-1.43761e-05, 0.000320396, 0.000209391> }
        smooth_triangle {<-0.0299572, 0.433032, -4.23668>, <-1.31606e-05, 0.0002939, 0.000196202>,
                         <0.00479617, 0.439694, -4.24369>, <-1.56364e-05, 0.000225766, 0.00017393>,
                         <-0.00516815, 0.442291, -4.24785>, <-1.63891e-05, 0.000224934, 0.000175213> }
        smooth_triangle {<-0.0432048, 0.436234, -4.24235>, <-1.58641e-05, 0.000319241, 0.00021222>,
                         <-0.0814326, 0.430945, -4.2357>, <-1.07973e-05, 0.000417488, 0.000238631>,
                         <-0.0649026, 0.427214, -4.22857>, <-9.0478e-06, 0.000417811, 0.000234743> }
        smooth_triangle {<-0.0649026, 0.427214, -4.22857>, <-8.52431e-06, 0.000389696, 0.000223303>,
                         <-0.0299572, 0.433032, -4.23668>, <-1.25205e-05, 0.000316635, 0.000204289>,
                         <-0.0432048, 0.436234, -4.24235>, <-1.36365e-05, 0.000315769, 0.00020641> }
        smooth_triangle {<-0.0814326, 0.430945, -4.2357>, <-1.07973e-05, 0.000417488, 0.000238631>,
                         <-0.11985, 0.426342, -4.22753>, <-1.54452e-07, 0.000532146, 0.000258305>,
                         <-0.100033, 0.42215, -4.21903>, <1.63449e-06, 0.000530159, 0.000253156> }
        smooth_triangle {<-0.100033, 0.42215, -4.21903>, <1.10377e-06, 0.000499665, 0.000243564>,
                         <-0.0649026, 0.427214, -4.22857>, <-6.90794e-06, 0.000415404, 0.000229754>,
                         <-0.0814326, 0.430945, -4.2357>, <-8.22006e-06, 0.000415162, 0.00023267> }
        smooth_triangle {<-0.11985, 0.426342, -4.22753>, <-1.54452e-07, 0.000532146, 0.000258305>,
                         <-0.15843, 0.422483, -4.21693>, <2.30582e-05, 0.000687122, 0.000265947>,
                         <-0.135325, 0.417906, -4.20724>, <2.43426e-05, 0.000679029, 0.000259058> }
        smooth_triangle {<-0.135325, 0.417906, -4.20724>, <2.15875e-05, 0.000642678, 0.000252302>,
                         <-0.100033, 0.42215, -4.21903>, <4.55648e-06, 0.000531025, 0.000247876>,
                         <-0.11985, 0.426342, -4.22753>, <3.21477e-06, 0.000532515, 0.000251738> }
        smooth_triangle {<-0.15843, 0.422483, -4.21693>, <2.30582e-05, 0.000687122, 0.000265947>,
                         <-0.196754, 0.419675, -4.20093>, <7.25185e-05, 0.000932188, 0.000248517>,
                         <-0.170399, 0.414817, -4.19055>, <7.17675e-05, 0.000908827, 0.000239497> }
        smooth_triangle {<-0.170399, 0.414817, -4.19055>, <6.54488e-05, 0.000862971, 0.000237604>,
                         <-0.135325, 0.417906, -4.20724>, <2.98801e-05, 0.000690623, 0.000252275>,
                         <-0.15843, 0.422483, -4.21693>, <2.89168e-05, 0.000696693, 0.000257441> }
        smooth_triangle {<-0.196754, 0.419675, -4.20093>, <7.25185e-05, 0.000932188, 0.000248517>,
                         <-0.23169, 0.418238, -4.17386>, <0.00015068, 0.00126007, 0.000185421>,
                         <-0.202437, 0.413236, -4.16383>, <0.000145513, 0.00121108, 0.000176058> }
        smooth_triangle {<-0.202437, 0.413236, -4.16383>, <0.000137476, 0.00116752, 0.000181369>,
                         <-0.170399, 0.414817, -4.19055>, <8.21671e-05, 0.000940822, 0.000228948>,
                         <-0.196754, 0.419675, -4.20093>, <8.27304e-05, 0.000958343, 0.000235713> }
        smooth_triangle {<-0.23169, 0.418238, -4.17386>, <0.00015068, 0.00126007, 0.000185421>,
                         <-0.253374, 0.418119, -4.13242>, <0.000218953, 0.00145318, 6.45328e-05>,
                         <-0.222552, 0.413105, -4.12418>, <0.000209357, 0.00138676, 6.00139e-05> }
        smooth_triangle {<-0.222552, 0.413105, -4.12418>, <0.00020628, 0.00138052, 7.11263e-05>,
                         <-0.202437, 0.413236, -4.16383>, <0.000158397, 0.00124877, 0.00015816>,
                         <-0.23169, 0.418238, -4.17386>, <0.000162272, 0.00128551, 0.000165182> }
        smooth_triangle {<-0.253374, 0.418119, -4.13242>, <0.000218953, 0.00145318, 6.45328e-05>,
                         <-0.250969, 0.419015, -4.08593>, <0.000225946, 0.0012845, -7.03604e-05>,
                         <-0.220986, 0.414091, -4.07997>, <0.000216351, 0.00123008, -6.70561e-05> }
        smooth_triangle {<-0.220986, 0.414091, -4.07997>, <0.000219704, 0.00125993, -5.98532e-05>,
                         <-0.222552, 0.413105, -4.12418>, <0.000214459, 0.00137744, 3.54493e-05>,
                         <-0.253374, 0.418119, -4.13242>, <0.000221655, 0.00142726, 3.88384e-05> }
        smooth_triangle {<-0.250969, 0.419015, -4.08593>, <0.000225946, 0.0012845, -7.03604e-05>,
                         <-0.232671, 0.420651, -4.0457>, <0.000189563, 0.000957136, -0.000145675>,
                         <-0.205111, 0.415891, -4.04142>, <0.000183208, 0.00092701, -0.000138259> }
        smooth_triangle {<-0.205111, 0.415891, -4.04142>, <0.000187545, 0.000960584, -0.000136728>,
                         <-0.220986, 0.414091, -4.07997>, <0.000212402, 0.00118788, -8.33251e-05>,
                         <-0.250969, 0.419015, -4.08593>, <0.000219599, 0.0012287, -8.58033e-05> }
        smooth_triangle {<-0.232671, 0.420651, -4.0457>, <0.000189563, 0.000957136, -0.000145675>,
                         <-0.208342, 0.422903, -4.01102>, <0.000157809, 0.000725376, -0.000171176>,
                         <-0.183804, 0.418367, -4.00789>, <0.000153841, 0.000709477, -0.000163122> }
        smooth_triangle {<-0.183804, 0.418367, -4.00789>, <0.000157945, 0.000740387, -0.000164762>,
                         <-0.205111, 0.415891, -4.04142>, <0.00017997, 0.000903536, -0.000146115>,
                         <-0.232671, 0.420651, -4.0457>, <0.000184737, 0.000926131, -0.000151677> }
        smooth_triangle {<-0.208342, 0.422903, -4.01102>, <0.000157809, 0.000725376, -0.000171176>,
                         <-0.181605, 0.425746, -3.97957>, <0.000134226, 0.000567426, -0.000176629>,
                         <-0.160324, 0.421495, -3.97728>, <0.000131612, 0.000558348, -0.000169188> }
        smooth_triangle {<-0.160324, 0.421495, -3.97728>, <0.000135868, 0.000588124, -0.000172701>,
                         <-0.183804, 0.418367, -4.00789>, <0.00015254, 0.000701471, -0.000168152>,
                         <-0.208342, 0.422903, -4.01102>, <0.000155516, 0.000713395, -0.000174192> }
        smooth_triangle {<-0.181605, 0.425746, -3.97957>, <0.000134226, 0.000567426, -0.000176629>,
                         <-0.153494, 0.429341, -3.95043>, <0.000112387, 0.000436024, -0.000174167>,
                         <-0.135597, 0.42545, -3.94879>, <0.000110706, 0.000430895, -0.000167976> }
        smooth_triangle {<-0.135597, 0.42545, -3.94879>, <0.000115565, 0.000460546, -0.000173304>,
                         <-0.160324, 0.421495, -3.97728>, <0.000131245, 0.000556136, -0.000174213>,
                         <-0.181605, 0.425746, -3.97957>, <0.000133205, 0.000562944, -0.000179794> }
        smooth_triangle {<-0.153494, 0.429341, -3.95043>, <0.000112387, 0.000436024, -0.000174167>,
                         <-0.124189, 0.434064, -3.92375>, <8.85674e-05, 0.000312274, -0.000164818>,
                         <-0.109775, 0.430644, -3.9226>, <8.76714e-05, 0.00031, -0.000160336> }
        smooth_triangle {<-0.109775, 0.430644, -3.9226>, <9.33647e-05, 0.000339143, -0.000168616>,
                         <-0.135597, 0.42545, -3.94879>, <0.000110641, 0.000429815, -0.000174346>,
                         <-0.153494, 0.429341, -3.95043>, <0.000111902, 0.000433661, -0.000178989> }
        smooth_triangle {<-0.124189, 0.434064, -3.92375>, <8.85674e-05, 0.000312274, -0.000164818>,
                         <-0.0936683, 0.440279, -3.90009>, <6.25243e-05, 0.000197406, -0.000143444>,
                         <-0.0828221, 0.437481, -3.89928>, <6.2225e-05, 0.000197004, -0.000140838> }
        smooth_triangle {<-0.0828221, 0.437481, -3.89928>, <6.85663e-05, 0.000224063, -0.000153305>,
                         <-0.109775, 0.430644, -3.9226>, <8.76511e-05, 0.00030881, -0.000167929>,
                         <-0.124189, 0.434064, -3.92375>, <8.83231e-05, 0.000310515, -0.00017129> }
        smooth_triangle {<-0.0936683, 0.440279, -3.90009>, <6.25243e-05, 0.000197406, -0.000143444>,
                         <-0.0620055, 0.448368, -3.87992>, <3.64593e-05, 0.000102389, -0.000104189>,
                         <-0.0547732, 0.446379, -3.87936>, <3.64353e-05, 0.000102569, -0.000103245> }
        smooth_triangle {<-0.0547732, 0.446379, -3.87936>, <4.3066e-05, 0.000125219, -0.00012118>,
                         <-0.0828221, 0.437481, -3.89928>, <6.24082e-05, 0.000196045, -0.000149375>,
                         <-0.0936683, 0.440279, -3.90009>, <6.26327e-05, 0.000196347, -0.000151329> }
        smooth_triangle {<-0.0620055, 0.448368, -3.87992>, <3.64593e-05, 0.000102389, -0.000104189>,
                         <-0.0294162, 0.458102, -3.86305>, <1.29791e-05, 3.45198e-05, -4.50048e-05>,
                         <-0.0258029, 0.457087, -3.86276>, <1.29864e-05, 3.45569e-05, -4.49657e-05> }
        smooth_triangle {<-0.0258029, 0.457087, -3.86276>, <1.95025e-05, 5.18661e-05, -6.74907e-05>,
                         <-0.0547732, 0.446379, -3.87936>, <3.70892e-05, 0.000102875, -0.0001112>,
                         <-0.0620055, 0.448368, -3.87992>, <3.71072e-05, 0.00010274, -0.000111909> }
        smooth_triangle {<-0.0294162, 0.458102, -3.86305>, <1.29791e-05, 3.45198e-05, -4.50048e-05>,
                         <0.00375561, 0.468789, -3.84841>, <-1.06745e-06, 1.07343e-06, 1.78597e-06>,
                         <0.00376264, 0.468842, -3.84844>, <-1.07989e-06, 9.712e-07, 1.58695e-06> }
        smooth_triangle {<0.00376264, 0.468842, -3.84844>, <5.28588e-06, 1.49759e-05, -2.31102e-05>,
                         <-0.0258029, 0.457087, -3.86276>, <1.42441e-05, 3.66639e-05, -5.18504e-05>,
                         <-0.0294162, 0.458102, -3.86305>, <1.42387e-05, 3.66361e-05, -5.18797e-05> }
        smooth_triangle {<0.106835, 0.468736, -4.25501>, <-1.29091e-05, 5.05597e-05, 7.02568e-05>,
                         <0.0665903, 0.459471, -4.25574>, <-1.51273e-05, 7.23979e-05, 9.0029e-05>,
                         <0.0699318, 0.458494, -4.25442>, <-1.51861e-05, 7.22167e-05, 9.0044e-05> }
        smooth_triangle {<0.0699318, 0.458494, -4.25442>, <-1.16509e-05, 5.50721e-05, 6.69788e-05>,
                         <0.10681, 0.468789, -4.25491>, <-7.06045e-06, 2.69171e-05, 3.40965e-05>,
                         <0.106835, 0.468736, -4.25501>, <-6.97716e-06, 2.7099e-05, 3.402e-05> }
        smooth_triangle {<0.0665903, 0.459471, -4.25574>, <-1.51273e-05, 7.23979e-05, 9.0029e-05>,
                         <0.0259287, 0.451423, -4.25474>, <-1.99057e-05, 0.000143078, 0.000143819>,
                         <0.0325976, 0.449553, -4.25206>, <-1.95296e-05, 0.000143537, 0.000143205> }
        smooth_triangle {<0.0325976, 0.449553, -4.25206>, <-1.70144e-05, 0.000121913, 0.000123987>,
                         <0.0699318, 0.458494, -4.25442>, <-1.37568e-05, 6.84228e-05, 8.4116e-05>,
                         <0.0665903, 0.459471, -4.25574>, <-1.37127e-05, 6.85587e-05, 8.41048e-05> }
        smooth_triangle {<0.0259287, 0.451423, -4.25474>, <-1.99057e-05, 0.000143078, 0.000143819>,
                         <-0.0151325, 0.444888, -4.25201>, <-1.96842e-05, 0.000227331, 0.000183117>,
                         <-0.00516815, 0.442291, -4.24785>, <-1.86807e-05, 0.000228441, 0.000181406> }
        smooth_triangle {<-0.00516815, 0.442291, -4.24785>, <-1.69139e-05, 0.000203671, 0.000165822>,
                         <0.0325976, 0.449553, -4.25206>, <-1.75506e-05, 0.000139994, 0.000137171>,
                         <0.0259287, 0.451423, -4.25474>, <-1.78326e-05, 0.000139649, 0.000137632> }
        smooth_triangle {<-0.0151325, 0.444888, -4.25201>, <-1.96842e-05, 0.000227331, 0.000183117>,
                         <-0.0564524, 0.439436, -4.24801>, <-1.7352e-05, 0.000318086, 0.000215048>,
                         <-0.0432048, 0.436234, -4.24235>, <-1.58641e-05, 0.000319241, 0.00021222> }
        smooth_triangle {<-0.0432048, 0.436234, -4.24235>, <-1.46218e-05, 0.000292707, 0.000198946>,
                         <-0.00516815, 0.442291, -4.24785>, <-1.67342e-05, 0.000224607, 0.000175836>,
                         <-0.0151325, 0.444888, -4.25201>, <-1.74869e-05, 0.000223775, 0.000177119> }
        smooth_triangle {<-0.0564524, 0.439436, -4.24801>, <-1.7352e-05, 0.000318086, 0.000215048>,
                         <-0.0979625, 0.434676, -4.24283>, <-1.25468e-05, 0.000417165, 0.000242519>,
                         <-0.0814326, 0.430945, -4.2357>, <-1.07973e-05, 0.000417488, 0.000238631> }
        smooth_triangle {<-0.0814326, 0.430945, -4.2357>, <-1.0262e-05, 0.000389242, 0.000227095>,
                         <-0.0432048, 0.436234, -4.24235>, <-1.40621e-05, 0.000315557, 0.000207286>,
                         <-0.0564524, 0.439436, -4.24801>, <-1.51781e-05, 0.000314691, 0.000209408> }
        smooth_triangle {<-0.0979625, 0.434676, -4.24283>, <-1.25468e-05, 0.000417165, 0.000242519>,
                         <-0.139666, 0.430533, -4.23603>, <-1.94339e-06, 0.000534132, 0.000263455>,
                         <-0.11985, 0.426342, -4.22753>, <-1.54452e-07, 0.000532146, 0.000258305> }
        smooth_triangle {<-0.11985, 0.426342, -4.22753>, <-6.98804e-07, 0.000501335, 0.000248589>,
                         <-0.0814326, 0.430945, -4.2357>, <-8.68093e-06, 0.000415342, 0.000233833>,
                         <-0.0979625, 0.434676, -4.24283>, <-9.99305e-06, 0.0004151, 0.000236749> }
        smooth_triangle {<-0.139666, 0.430533, -4.23603>, <-1.94339e-06, 0.000534132, 0.000263455>,
                         <-0.181536, 0.427061, -4.22661>, <2.17739e-05, 0.000695216, 0.000272836>,
                         <-0.15843, 0.422483, -4.21693>, <2.30582e-05, 0.000687122, 0.000265947> }
        smooth_triangle {<-0.15843, 0.422483, -4.21693>, <2.02043e-05, 0.000649877, 0.000259004>,
                         <-0.11985, 0.426342, -4.22753>, <2.79481e-06, 0.000533644, 0.000253273>,
                         <-0.139666, 0.430533, -4.23603>, <1.4531e-06, 0.000535134, 0.000257135> }
        smooth_triangle {<-0.181536, 0.427061, -4.22661>, <2.17739e-05, 0.000695216, 0.000272836>,
                         <-0.223108, 0.424533, -4.21132>, <7.32695e-05, 0.000955549, 0.000257538>,
                         <-0.196754, 0.419675, -4.20093>, <7.25185e-05, 0.000932188, 0.000248517> }
        smooth_triangle {<-0.196754, 0.419675, -4.20093>, <6.58887e-05, 0.000884304, 0.000246465>,
                         <-0.15843, 0.422483, -4.21693>, <2.87935e-05, 0.000700505, 0.000259537>,
                         <-0.181536, 0.427061, -4.22661>, <2.78302e-05, 0.000706575, 0.000264704> }
        smooth_triangle {<-0.223108, 0.424533, -4.21132>, <7.32695e-05, 0.000955549, 0.000257538>,
                         <-0.260943, 0.42324, -4.18389>, <0.000155847, 0.00130906, 0.000194784>,
                         <-0.23169, 0.418238, -4.17386>, <0.00015068, 0.00126007, 0.000185421> }
        smooth_triangle {<-0.23169, 0.418238, -4.17386>, <0.000142161, 0.00121415, 0.000190965>,
                         <-0.196754, 0.419675, -4.20093>, <8.35403e-05, 0.00096824, 0.000238287>,
                         <-0.223108, 0.424533, -4.21132>, <8.41036e-05, 0.000985761, 0.000245053> }
        smooth_triangle {<-0.260943, 0.42324, -4.18389>, <0.000155847, 0.00130906, 0.000194784>,
                         <-0.284196, 0.423133, -4.14067>, <0.000228549, 0.0015196, 6.90516e-05>,
                         <-0.253374, 0.418119, -4.13242>, <0.000218953, 0.00145318, 6.45328e-05> }
        smooth_triangle {<-0.253374, 0.418119, -4.13242>, <0.000215732, 0.00144729, 7.63901e-05>,
                         <-0.23169, 0.418238, -4.17386>, <0.000164527, 0.00130245, 0.000167056>,
                         <-0.260943, 0.42324, -4.18389>, <0.000168402, 0.00133919, 0.000174078> }
        smooth_triangle {<-0.284196, 0.423133, -4.14067>, <0.000228549, 0.0015196, 6.90516e-05>,
                         <-0.280953, 0.42394, -4.09189>, <0.000235541, 0.00133893, -7.36647e-05>,
                         <-0.250969, 0.419015, -4.08593>, <0.000225946, 0.0012845, -7.03604e-05> }
        smooth_triangle {<-0.250969, 0.419015, -4.08593>, <0.000229587, 0.00131667, -6.26916e-05>,
                         <-0.253374, 0.418119, -4.13242>, <0.000224342, 0.00144318, 3.84783e-05>,
                         <-0.284196, 0.423133, -4.14067>, <0.000231539, 0.001493, 4.18674e-05> }
        smooth_triangle {<-0.280953, 0.42394, -4.09189>, <0.000235541, 0.00133893, -7.36647e-05>,
                         <-0.26023, 0.425412, -4.04998>, <0.000195918, 0.000987262, -0.000153091>,
                         <-0.232671, 0.420651, -4.0457>, <0.000189563, 0.000957136, -0.000145675> }
        smooth_triangle {<-0.232671, 0.420651, -4.0457>, <0.000194134, 0.000992153, -0.000144047>,
                         <-0.250969, 0.419015, -4.08593>, <0.000221422, 0.00123768, -8.75613e-05>,
                         <-0.280953, 0.42394, -4.09189>, <0.000228618, 0.0012785, -9.00395e-05> }
        smooth_triangle {<-0.26023, 0.425412, -4.04998>, <0.000195918, 0.000987262, -0.000153091>,
                         <-0.232879, 0.427438, -4.01416>, <0.000161777, 0.000741275, -0.00017923>,
                         <-0.208342, 0.422903, -4.01102>, <0.000157809, 0.000725376, -0.000171176> }
        smooth_triangle {<-0.208342, 0.422903, -4.01102>, <0.000162041, 0.000756956, -0.000172849>,
                         <-0.232671, 0.420651, -4.0457>, <0.000185857, 0.000930776, -0.000153723>,
                         <-0.26023, 0.425412, -4.04998>, <0.000190623, 0.00095337, -0.000159285> }
        smooth_triangle {<-0.232879, 0.427438, -4.01416>, <0.000161777, 0.000741275, -0.00017923>,
                         <-0.202885, 0.429997, -3.98186>, <0.000136841, 0.000576504, -0.00018407>,
                         <-0.181605, 0.425746, -3.97957>, <0.000134226, 0.000567426, -0.000176629> }
        smooth_triangle {<-0.181605, 0.425746, -3.97957>, <0.000138565, 0.000597566, -0.000180231>,
                         <-0.208342, 0.422903, -4.01102>, <0.000156252, 0.000716029, -0.000176141>,
                         <-0.232879, 0.427438, -4.01416>, <0.000159227, 0.000727953, -0.000182181> }
        smooth_triangle {<-0.202885, 0.429997, -3.98186>, <0.000136841, 0.000576504, -0.00018407>,
                         <-0.17139, 0.433233, -3.95207>, <0.000114068, 0.000441152, -0.000180358>,
                         <-0.153494, 0.429341, -3.95043>, <0.000112387, 0.000436024, -0.000174167> }
        smooth_triangle {<-0.153494, 0.429341, -3.95043>, <0.000117315, 0.000465933, -0.000179631>,
                         <-0.181605, 0.425746, -3.97957>, <0.000133694, 0.000564485, -0.000181477>,
                         <-0.202885, 0.429997, -3.98186>, <0.000135655, 0.000571294, -0.000187058> }
        smooth_triangle {<-0.17139, 0.433233, -3.95207>, <0.000114068, 0.000441152, -0.000180358>,
                         <-0.138602, 0.437483, -3.92489>, <8.94634e-05, 0.000314547, -0.0001693>,
                         <-0.124189, 0.434064, -3.92375>, <8.85674e-05, 0.000312274, -0.000164818> }
        smooth_triangle {<-0.124189, 0.434064, -3.92375>, <9.43194e-05, 0.000341612, -0.000173254>,
                         <-0.153494, 0.429341, -3.95043>, <0.000112184, 0.000434424, -0.000180265>,
                         <-0.17139, 0.433233, -3.95207>, <0.000113445, 0.00043827, -0.000184908> }
        smooth_triangle {<-0.138602, 0.437483, -3.92489>, <8.94634e-05, 0.000314547, -0.0001693>,
                         <-0.104515, 0.443077, -3.9009>, <6.28236e-05, 0.000197809, -0.00014605>,
                         <-0.0936683, 0.440279, -3.90009>, <6.25243e-05, 0.000197406, -0.000143444> }
        smooth_triangle {<-0.0936683, 0.440279, -3.90009>, <6.88974e-05, 0.000224543, -0.00015607>,
                         <-0.124189, 0.434064, -3.92375>, <8.84297e-05, 0.000310693, -0.0001721>,
                         <-0.138602, 0.437483, -3.92489>, <8.91018e-05, 0.000312399, -0.000175462> }
        smooth_triangle {<-0.104515, 0.443077, -3.9009>, <6.28236e-05, 0.000197809, -0.00014605>,
                         <-0.0692379, 0.450357, -3.88049>, <3.64833e-05, 0.000102209, -0.000105134>,
                         <-0.0620055, 0.448368, -3.87992>, <3.64593e-05, 0.000102389, -0.000104189> }
        smooth_triangle {<-0.0620055, 0.448368, -3.87992>, <4.30951e-05, 0.00012503, -0.000122223>,
                         <-0.0936683, 0.440279, -3.90009>, <6.26438e-05, 0.000196293, -0.000151663>,
                         <-0.104515, 0.443077, -3.9009>, <6.28683e-05, 0.000196595, -0.000153618> }
        smooth_triangle {<-0.0692379, 0.450357, -3.88049>, <3.64833e-05, 0.000102209, -0.000105134>,
                         <-0.0330296, 0.459118, -3.86335>, <1.29719e-05, 3.44827e-05, -4.50438e-05>,
                         <-0.0294162, 0.458102, -3.86305>, <1.29791e-05, 3.45198e-05, -4.50048e-05> }
        smooth_triangle {<-0.0294162, 0.458102, -3.86305>, <1.94928e-05, 5.18116e-05, -6.75595e-05>,
                         <-0.0620055, 0.448368, -3.87992>, <3.71029e-05, 0.000102714, -0.000111948>,
                         <-0.0692379, 0.450357, -3.88049>, <3.71209e-05, 0.000102579, -0.000112657> }
        smooth_triangle {<-0.0330296, 0.459118, -3.86335>, <1.29719e-05, 3.44827e-05, -4.50438e-05>,
                         <0.00374859, 0.468736, -3.84839>, <-1.055e-06, 1.17566e-06, 1.98498e-06>,
                         <0.00375561, 0.468789, -3.84841>, <-1.06745e-06, 1.07343e-06, 1.78597e-06> }
        smooth_triangle {<0.00375561, 0.468789, -3.84841>, <5.29832e-06, 1.50781e-05, -2.29111e-05>,
                         <-0.0294162, 0.458102, -3.86305>, <1.42418e-05, 3.66617e-05, -5.18299e-05>,
                         <-0.0330296, 0.459118, -3.86335>, <1.42364e-05, 3.66339e-05, -5.18592e-05> }
        smooth_triangle {<0.10686, 0.468683, -4.25511>, <-1.27426e-05, 5.09236e-05, 7.01039e-05>,
                         <0.0632487, 0.460447, -4.25705>, <-1.50684e-05, 7.25791e-05, 9.0014e-05>,
                         <0.0665903, 0.459471, -4.25574>, <-1.51273e-05, 7.23979e-05, 9.0029e-05> }
        smooth_triangle {<0.0665903, 0.459471, -4.25574>, <-1.15651e-05, 5.52989e-05, 6.69294e-05>,
                         <0.106835, 0.468736, -4.25501>, <-6.89387e-06, 2.72809e-05, 3.39436e-05>,
                         <0.10686, 0.468683, -4.25511>, <-6.81059e-06, 2.74628e-05, 3.38671e-05> }
        smooth_triangle {<0.0632487, 0.460447, -4.25705>, <-1.50684e-05, 7.25791e-05, 9.0014e-05>,
                         <0.0192599, 0.453294, -4.25743>, <-2.02817e-05, 0.000142619, 0.000144434>,
                         <0.0259287, 0.451423, -4.25474>, <-1.99057e-05, 0.000143078, 0.000143819> }
        smooth_triangle {<0.0259287, 0.451423, -4.25474>, <-1.73356e-05, 0.000121523, 0.000124513>,
                         <0.0665903, 0.459471, -4.25574>, <-1.37518e-05, 6.85128e-05, 8.417e-05>,
                         <0.0632487, 0.460447, -4.25705>, <-1.37077e-05, 6.86487e-05, 8.41588e-05> }
        smooth_triangle {<0.0192599, 0.453294, -4.25743>, <-2.02817e-05, 0.000142619, 0.000144434>,
                         <-0.0250968, 0.447485, -4.25617>, <-2.06877e-05, 0.000226222, 0.000184829>,
                         <-0.0151325, 0.444888, -4.25201>, <-1.96842e-05, 0.000227331, 0.000183117> }
        smooth_triangle {<-0.0151325, 0.444888, -4.25201>, <-1.78702e-05, 0.000202587, 0.000167436>,
                         <0.0259287, 0.451423, -4.25474>, <-1.80363e-05, 0.000139397, 0.000137962>,
                         <0.0192599, 0.453294, -4.25743>, <-1.83183e-05, 0.000139052, 0.000138423> }
        smooth_triangle {<-0.0250968, 0.447485, -4.25617>, <-2.06877e-05, 0.000226222, 0.000184829>,
                         <-0.0696999, 0.442639, -4.25367>, <-1.884e-05, 0.000316932, 0.000217877>,
                         <-0.0564524, 0.439436, -4.24801>, <-1.7352e-05, 0.000318086, 0.000215048> }
        smooth_triangle {<-0.0564524, 0.439436, -4.24801>, <-1.60829e-05, 0.000291514, 0.00020169>,
                         <-0.0151325, 0.444888, -4.25201>, <-1.7832e-05, 0.000223447, 0.000177742>,
                         <-0.0250968, 0.447485, -4.25617>, <-1.85847e-05, 0.000222615, 0.000179025> }
        smooth_triangle {<-0.0696999, 0.442639, -4.25367>, <-1.884e-05, 0.000316932, 0.000217877>,
                         <-0.114493, 0.438408, -4.24996>, <-1.42963e-05, 0.000416842, 0.000246406>,
                         <-0.0979625, 0.434676, -4.24283>, <-1.25468e-05, 0.000417165, 0.000242519> }
        smooth_triangle {<-0.0979625, 0.434676, -4.24283>, <-1.19998e-05, 0.000388789, 0.000230887>,
                         <-0.0564524, 0.439436, -4.24801>, <-1.56037e-05, 0.00031448, 0.000210284>,
                         <-0.0696999, 0.442639, -4.25367>, <-1.67197e-05, 0.000313614, 0.000212405> }
        smooth_triangle {<-0.114493, 0.438408, -4.24996>, <-1.42963e-05, 0.000416842, 0.000246406>,
                         <-0.159482, 0.434725, -4.24453>, <-3.73233e-06, 0.000536119, 0.000268604>,
                         <-0.139666, 0.430533, -4.23603>, <-1.94339e-06, 0.000534132, 0.000263455> }
        smooth_triangle {<-0.139666, 0.430533, -4.23603>, <-2.50138e-06, 0.000503006, 0.000253615>,
                         <-0.0979625, 0.434676, -4.24283>, <-1.04539e-05, 0.000415281, 0.000237913>,
                         <-0.114493, 0.438408, -4.24996>, <-1.1766e-05, 0.000415038, 0.000240828> }
        smooth_triangle {<-0.159482, 0.434725, -4.24453>, <-3.73233e-06, 0.000536119, 0.000268604>,
                         <-0.204641, 0.431638, -4.2363>, <2.04895e-05, 0.000703309, 0.000279725>,
                         <-0.181536, 0.427061, -4.22661>, <2.17739e-05, 0.000695216, 0.000272836> }
        smooth_triangle {<-0.181536, 0.427061, -4.22661>, <1.88211e-05, 0.000657075, 0.000265706>,
                         <-0.139666, 0.430533, -4.23603>, <1.03314e-06, 0.000536263, 0.00025867>,
                         <-0.159482, 0.434725, -4.24453>, <-3.08562e-07, 0.000537753, 0.000262532> }
        smooth_triangle {<-0.204641, 0.431638, -4.2363>, <2.04895e-05, 0.000703309, 0.000279725>,
                         <-0.249463, 0.429392, -4.22171>, <7.40206e-05, 0.00097891, 0.000266559>,
                         <-0.223108, 0.424533, -4.21132>, <7.32695e-05, 0.000955549, 0.000257538> }
        smooth_triangle {<-0.223108, 0.424533, -4.21132>, <6.63286e-05, 0.000905637, 0.000255327>,
                         <-0.181536, 0.427061, -4.22661>, <2.77069e-05, 0.000710387, 0.0002668>,
                         <-0.204641, 0.431638, -4.2363>, <2.67436e-05, 0.000716457, 0.000271967> }
        smooth_triangle {<-0.249463, 0.429392, -4.22171>, <7.40206e-05, 0.00097891, 0.000266559>,
                         <-0.290196, 0.428242, -4.19392>, <0.000161013, 0.00135804, 0.000204147>,
                         <-0.260943, 0.42324, -4.18389>, <0.000155847, 0.00130906, 0.000194784> }
        smooth_triangle {<-0.260943, 0.42324, -4.18389>, <0.000146846, 0.00126079, 0.000200561>,
                         <-0.223108, 0.424533, -4.21132>, <8.49135e-05, 0.000995657, 0.000247626>,
                         <-0.249463, 0.429392, -4.22171>, <8.54767e-05, 0.00101318, 0.000254392> }
        smooth_triangle {<-0.290196, 0.428242, -4.19392>, <0.000161013, 0.00135804, 0.000204147>,
                         <-0.315018, 0.428147, -4.14892>, <0.000238145, 0.00158603, 7.35704e-05>,
                         <-0.284196, 0.423133, -4.14067>, <0.000228549, 0.0015196, 6.90516e-05> }
        smooth_triangle {<-0.284196, 0.423133, -4.14067>, <0.000225184, 0.00151405, 8.16538e-05>,
                         <-0.260943, 0.42324, -4.18389>, <0.000170657, 0.00135614, 0.000175953>,
                         <-0.290196, 0.428242, -4.19392>, <0.000174532, 0.00139288, 0.000182975> }
        smooth_triangle {<-0.315018, 0.428147, -4.14892>, <0.000238145, 0.00158603, 7.35704e-05>,
                         <-0.310937, 0.428864, -4.09785>, <0.000245136, 0.00139335, -7.6969e-05>,
                         <-0.280953, 0.42394, -4.09189>, <0.000235541, 0.00133893, -7.36647e-05> }
        smooth_triangle {<-0.280953, 0.42394, -4.09189>, <0.000239469, 0.00137341, -6.553e-05>,
                         <-0.284196, 0.423133, -4.14067>, <0.000234225, 0.00150892, 4.15072e-05>,
                         <-0.315018, 0.428147, -4.14892>, <0.000241422, 0.00155874, 4.48963e-05> }
        smooth_triangle {<-0.310937, 0.428864, -4.09785>, <0.000245136, 0.00139335, -7.6969e-05>,
                         <-0.28779, 0.430173, -4.05426>, <0.000202274, 0.00101739, -0.000160507>,
                         <-0.26023, 0.425412, -4.04998>, <0.000195918, 0.000987262, -0.000153091> }
        smooth_triangle {<-0.26023, 0.425412, -4.04998>, <0.000200724, 0.00102372, -0.000151367>,
                         <-0.280953, 0.42394, -4.09189>, <0.000230441, 0.00128747, -9.17974e-05>,
                         <-0.310937, 0.428864, -4.09785>, <0.000237637, 0.00132829, -9.42756e-05> }
        smooth_triangle {<-0.28779, 0.430173, -4.05426>, <0.000202274, 0.00101739, -0.000160507>,
                         <-0.257416, 0.431974, -4.01729>, <0.000165745, 0.000757174, -0.000187284>,
                         <-0.232879, 0.427438, -4.01416>, <0.000161777, 0.000741275, -0.00017923> }
        smooth_triangle {<-0.232879, 0.427438, -4.01416>, <0.000166137, 0.000773525, -0.000180935>,
                         <-0.26023, 0.425412, -4.04998>, <0.000191743, 0.000958015, -0.000161331>,
                         <-0.28779, 0.430173, -4.05426>, <0.00019651, 0.00098061, -0.000166892> }
        smooth_triangle {<-0.257416, 0.431974, -4.01729>, <0.000165745, 0.000757174, -0.000187284>,
                         <-0.224165, 0.434248, -3.98415>, <0.000139455, 0.000585582, -0.000191512>,
                         <-0.202885, 0.429997, -3.98186>, <0.000136841, 0.000576504, -0.00018407> }
        smooth_triangle {<-0.202885, 0.429997, -3.98186>, <0.000141261, 0.000607008, -0.00018776>,
                         <-0.232879, 0.427438, -4.01416>, <0.000159963, 0.000730586, -0.00018413>,
                         <-0.257416, 0.431974, -4.01729>, <0.000162939, 0.00074251, -0.000190171> }
        smooth_triangle {<-0.224165, 0.434248, -3.98415>, <0.000139455, 0.000585582, -0.000191512>,
                         <-0.189287, 0.437125, -3.9537>, <0.000115749, 0.00044628, -0.000186549>,
                         <-0.17139, 0.433233, -3.95207>, <0.000114068, 0.000441152, -0.000180358> }
        smooth_triangle {<-0.17139, 0.433233, -3.95207>, <0.000119065, 0.000471321, -0.000185957>,
                         <-0.202885, 0.429997, -3.98186>, <0.000136144, 0.000572835, -0.000188742>,
                         <-0.224165, 0.434248, -3.98415>, <0.000138105, 0.000579643, -0.000194323> }
        smooth_triangle {<-0.189287, 0.437125, -3.9537>, <0.000115749, 0.00044628, -0.000186549>,
                         <-0.153016, 0.440903, -3.92604>, <9.03594e-05, 0.00031682, -0.000173782>,
                         <-0.138602, 0.437483, -3.92489>, <8.94634e-05, 0.000314547, -0.0001693> }
        smooth_triangle {<-0.138602, 0.437483, -3.92489>, <9.52741e-05, 0.00034408, -0.000177891>,
                         <-0.17139, 0.433233, -3.95207>, <0.000113728, 0.000439034, -0.000186184>,
                         <-0.189287, 0.437125, -3.9537>, <0.000114989, 0.00044288, -0.000190827> }
        smooth_triangle {<-0.153016, 0.440903, -3.92604>, <9.03594e-05, 0.00031682, -0.000173782>,
                         <-0.115361, 0.445875, -3.90172>, <6.31229e-05, 0.000198211, -0.000148655>,
                         <-0.104515, 0.443077, -3.9009>, <6.28236e-05, 0.000197809, -0.00014605> }
        smooth_triangle {<-0.104515, 0.443077, -3.9009>, <6.92286e-05, 0.000225023, -0.000158834>,
                         <-0.138602, 0.437483, -3.92489>, <8.92084e-05, 0.000312576, -0.000176272>,
                         <-0.153016, 0.440903, -3.92604>, <8.98804e-05, 0.000314282, -0.000179633> }
        smooth_triangle {<-0.115361, 0.445875, -3.90172>, <6.31229e-05, 0.000198211, -0.000148655>,
                         <-0.0764703, 0.452346, -3.88105>, <3.65073e-05, 0.000102029, -0.000106079>,
                         <-0.0692379, 0.450357, -3.88049>, <3.64833e-05, 0.000102209, -0.000105134> }
        smooth_triangle {<-0.0692379, 0.450357, -3.88049>, <4.31242e-05, 0.000124841, -0.000123266>,
                         <-0.104515, 0.443077, -3.9009>, <6.28794e-05, 0.000196541, -0.000153952>,
                         <-0.115361, 0.445875, -3.90172>, <6.31039e-05, 0.000196842, -0.000155907> }
        smooth_triangle {<-0.0764703, 0.452346, -3.88105>, <3.65073e-05, 0.000102029, -0.000106079>,
                         <-0.0366429, 0.460133, -3.86365>, <1.29647e-05, 3.44456e-05, -4.50829e-05>,
                         <-0.0330296, 0.459118, -3.86335>, <1.29719e-05, 3.44827e-05, -4.50438e-05> }
        smooth_triangle {<-0.0330296, 0.459118, -3.86335>, <1.94831e-05, 5.17571e-05, -6.76284e-05>,
                         <-0.0692379, 0.450357, -3.88049>, <3.71166e-05, 0.000102552, -0.000112696>,
                         <-0.0764703, 0.452346, -3.88105>, <3.71346e-05, 0.000102417, -0.000113405> }
        smooth_triangle {<-0.0366429, 0.460133, -3.86365>, <1.29647e-05, 3.44456e-05, -4.50829e-05>,
                         <0.00374156, 0.468683, -3.84836>, <-1.04256e-06, 1.2779e-06, 2.184e-06>,
                         <0.00374859, 0.468736, -3.84839>, <-1.055e-06, 1.17566e-06, 1.98498e-06> }
        smooth_triangle {<0.00374859, 0.468736, -3.84839>, <5.31076e-06, 1.51803e-05, -2.27121e-05>,
                         <-0.0330296, 0.459118, -3.86335>, <1.42395e-05, 3.66594e-05, -5.18095e-05>,
                         <-0.0366429, 0.460133, -3.86365>, <1.42341e-05, 3.66316e-05, -5.18388e-05> }
        smooth_triangle {<0.106885, 0.46863, -4.25521>, <-1.2576e-05, 5.12874e-05, 6.99509e-05>,
                         <0.0599071, 0.461423, -4.25837>, <-1.50096e-05, 7.27603e-05, 8.9999e-05>,
                         <0.0632487, 0.460447, -4.25705>, <-1.50684e-05, 7.25791e-05, 9.0014e-05> }
        smooth_triangle {<0.0632487, 0.460447, -4.25705>, <-1.14793e-05, 5.55258e-05, 6.68799e-05>,
                         <0.10686, 0.468683, -4.25511>, <-6.7273e-06, 2.76448e-05, 3.37906e-05>,
                         <0.106885, 0.46863, -4.25521>, <-6.64401e-06, 2.78267e-05, 3.37141e-05> }
        smooth_triangle {<0.0599071, 0.461423, -4.25837>, <-1.50096e-05, 7.27603e-05, 8.9999e-05>,
                         <0.012591, 0.455164, -4.26011>, <-2.06577e-05, 0.00014216, 0.000145048>,
                         <0.0192599, 0.453294, -4.25743>, <-2.02817e-05, 0.000142619, 0.000144434> }
        smooth_triangle {<0.0192599, 0.453294, -4.25743>, <-1.76567e-05, 0.000121132, 0.000125039>,
                         <0.0632487, 0.460447, -4.25705>, <-1.37468e-05, 6.86027e-05, 8.4224e-05>,
                         <0.0599071, 0.461423, -4.25837>, <-1.37026e-05, 6.87386e-05, 8.42128e-05> }
        smooth_triangle {<0.012591, 0.455164, -4.26011>, <-2.06577e-05, 0.00014216, 0.000145048>,
                         <-0.0350611, 0.450081, -4.26033>, <-2.16912e-05, 0.000225113, 0.00018654>,
                         <-0.0250968, 0.447485, -4.25617>, <-2.06877e-05, 0.000226222, 0.000184829> }
        smooth_triangle {<-0.0250968, 0.447485, -4.25617>, <-1.88266e-05, 0.000201503, 0.00016905>,
                         <0.0192599, 0.453294, -4.25743>, <-1.8522e-05, 0.0001388, 0.000138754>,
                         <0.012591, 0.455164, -4.26011>, <-1.8804e-05, 0.000138456, 0.000139214> }
        smooth_triangle {<-0.0350611, 0.450081, -4.26033>, <-2.16912e-05, 0.000225113, 0.00018654>,
                         <-0.0829475, 0.445841, -4.25933>, <-2.03279e-05, 0.000315777, 0.000220705>,
                         <-0.0696999, 0.442639, -4.25367>, <-1.884e-05, 0.000316932, 0.000217877> }
        smooth_triangle {<-0.0696999, 0.442639, -4.25367>, <-1.75441e-05, 0.00029032, 0.000204434>,
                         <-0.0250968, 0.447485, -4.25617>, <-1.89298e-05, 0.000222288, 0.000179648>,
                         <-0.0350611, 0.450081, -4.26033>, <-1.96825e-05, 0.000221456, 0.000180931> }
        smooth_triangle {<-0.0829475, 0.445841, -4.25933>, <-2.03279e-05, 0.000315777, 0.000220705>,
                         <-0.131022, 0.442139, -4.25708>, <-1.60458e-05, 0.000416519, 0.000250294>,
                         <-0.114493, 0.438408, -4.24996>, <-1.42963e-05, 0.000416842, 0.000246406> }
        smooth_triangle {<-0.114493, 0.438408, -4.24996>, <-1.37375e-05, 0.000388335, 0.000234679>,
                         <-0.0696999, 0.442639, -4.25367>, <-1.71453e-05, 0.000313402, 0.000213282>,
                         <-0.0829475, 0.445841, -4.25933>, <-1.82613e-05, 0.000312536, 0.000215403> }
        smooth_triangle {<-0.131022, 0.442139, -4.25708>, <-1.60458e-05, 0.000416519, 0.000250294>,
                         <-0.179299, 0.438917, -4.25304>, <-5.52128e-06, 0.000538106, 0.000273753>,
                         <-0.159482, 0.434725, -4.24453>, <-3.73233e-06, 0.000536119, 0.000268604> }
        smooth_triangle {<-0.159482, 0.434725, -4.24453>, <-4.30396e-06, 0.000504677, 0.00025864>,
                         <-0.114493, 0.438408, -4.24996>, <-1.22269e-05, 0.000415219, 0.000241992>,
                         <-0.131022, 0.442139, -4.25708>, <-1.3539e-05, 0.000414977, 0.000244907> }
        smooth_triangle {<-0.179299, 0.438917, -4.25304>, <-5.52128e-06, 0.000538106, 0.000273753>,
                         <-0.227747, 0.436216, -4.24598>, <1.92052e-05, 0.000711402, 0.000286614>,
                         <-0.204641, 0.431638, -4.2363>, <2.04895e-05, 0.000703309, 0.000279725> }
        smooth_triangle {<-0.204641, 0.431638, -4.2363>, <1.74379e-05, 0.000664274, 0.000272408>,
                         <-0.159482, 0.434725, -4.24453>, <-7.28522e-07, 0.000538882, 0.000264067>,
                         <-0.179299, 0.438917, -4.25304>, <-2.07023e-06, 0.000540372, 0.000267929> }
        smooth_triangle {<-0.227747, 0.436216, -4.24598>, <1.92052e-05, 0.000711402, 0.000286614>,
                         <-0.275817, 0.43425, -4.2321>, <7.47716e-05, 0.00100227, 0.00027558>,
                         <-0.249463, 0.429392, -4.22171>, <7.40206e-05, 0.00097891, 0.000266559> }
        smooth_triangle {<-0.249463, 0.429392, -4.22171>, <6.67685e-05, 0.00092697, 0.000264189>,
                         <-0.204641, 0.431638, -4.2363>, <2.66202e-05, 0.000720269, 0.000274063>,
                         <-0.227747, 0.436216, -4.24598>, <2.5657e-05, 0.000726339, 0.000279229> }
        smooth_triangle {<-0.275817, 0.43425, -4.2321>, <7.47716e-05, 0.00100227, 0.00027558>,
                         <-0.319449, 0.433244, -4.20394>, <0.00016618, 0.00140703, 0.000213509>,
                         <-0.290196, 0.428242, -4.19392>, <0.000161013, 0.00135804, 0.000204147> }
        smooth_triangle {<-0.290196, 0.428242, -4.19392>, <0.000151531, 0.00130742, 0.000210156>,
                         <-0.249463, 0.429392, -4.22171>, <8.62867e-05, 0.00102307, 0.000256966>,
                         <-0.275817, 0.43425, -4.2321>, <8.68499e-05, 0.0010406, 0.000263731> }
        smooth_triangle {<-0.319449, 0.433244, -4.20394>, <0.00016618, 0.00140703, 0.000213509>,
                         <-0.34584, 0.433161, -4.15717>, <0.00024774, 0.00165245, 7.80892e-05>,
                         <-0.315018, 0.428147, -4.14892>, <0.000238145, 0.00158603, 7.35704e-05> }
        smooth_triangle {<-0.315018, 0.428147, -4.14892>, <0.000234636, 0.00158081, 8.69176e-05>,
                         <-0.290196, 0.428242, -4.19392>, <0.000176787, 0.00140983, 0.00018485>,
                         <-0.319449, 0.433244, -4.20394>, <0.000180662, 0.00144657, 0.000191872> }
        smooth_triangle {<-0.34584, 0.433161, -4.15717>, <0.00024774, 0.00165245, 7.80892e-05>,
                         <-0.34092, 0.433788, -4.1038>, <0.000254731, 0.00144778, -8.02732e-05>,
                         <-0.310937, 0.428864, -4.09785>, <0.000245136, 0.00139335, -7.6969e-05> }
        smooth_triangle {<-0.310937, 0.428864, -4.09785>, <0.000249352, 0.00143015, -6.83683e-05>,
                         <-0.315018, 0.428147, -4.14892>, <0.000244108, 0.00157466, 4.45362e-05>,
                         <-0.34584, 0.433161, -4.15717>, <0.000251305, 0.00162447, 4.79253e-05> }
        smooth_triangle {<-0.34092, 0.433788, -4.1038>, <0.000254731, 0.00144778, -8.02732e-05>,
                         <-0.315349, 0.434933, -4.05854>, <0.000208629, 0.00104751, -0.000167922>,
                         <-0.28779, 0.430173, -4.05426>, <0.000202274, 0.00101739, -0.000160507> }
        smooth_triangle {<-0.28779, 0.430173, -4.05426>, <0.000207314, 0.00105529, -0.000158687>,
                         <-0.310937, 0.428864, -4.09785>, <0.000239461, 0.00133726, -9.60335e-05>,
                         <-0.34092, 0.433788, -4.1038>, <0.000246657, 0.00137808, -9.85118e-05> }
        smooth_triangle {<-0.315349, 0.434933, -4.05854>, <0.000208629, 0.00104751, -0.000167922>,
                         <-0.281953, 0.436509, -4.02043>, <0.000169712, 0.000773073, -0.000195338>,
                         <-0.257416, 0.431974, -4.01729>, <0.000165745, 0.000757174, -0.000187284> }
        smooth_triangle {<-0.257416, 0.431974, -4.01729>, <0.000170233, 0.000790095, -0.000189021>,
                         <-0.28779, 0.430173, -4.05426>, <0.00019763, 0.000985255, -0.000168938>,
                         <-0.315349, 0.434933, -4.05854>, <0.000202396, 0.00100785, -0.0001745> }
        smooth_triangle {<-0.281953, 0.436509, -4.02043>, <0.000169712, 0.000773073, -0.000195338>,
                         <-0.245446, 0.4385, -3.98644>, <0.000142069, 0.00059466, -0.000198953>,
                         <-0.224165, 0.434248, -3.98415>, <0.000139455, 0.000585582, -0.000191512> }
        smooth_triangle {<-0.224165, 0.434248, -3.98415>, <0.000143958, 0.00061645, -0.00019529>,
                         <-0.257416, 0.431974, -4.01729>, <0.000163675, 0.000745144, -0.000192119>,
                         <-0.281953, 0.436509, -4.02043>, <0.000166651, 0.000757068, -0.00019816> }
        smooth_triangle {<-0.245446, 0.4385, -3.98644>, <0.000142069, 0.00059466, -0.000198953>,
                         <-0.207183, 0.441016, -3.95534>, <0.000117431, 0.000451408, -0.000192739>,
                         <-0.189287, 0.437125, -3.9537>, <0.000115749, 0.00044628, -0.000186549> }
        smooth_triangle {<-0.189287, 0.437125, -3.9537>, <0.000120815, 0.000476708, -0.000192284>,
                         <-0.224165, 0.434248, -3.98415>, <0.000138594, 0.000581185, -0.000196007>,
                         <-0.245446, 0.4385, -3.98644>, <0.000140554, 0.000587993, -0.000201588> }
        smooth_triangle {<-0.207183, 0.441016, -3.95534>, <0.000117431, 0.000451408, -0.000192739>,
                         <-0.167429, 0.444322, -3.92719>, <9.12554e-05, 0.000319094, -0.000178264>,
                         <-0.153016, 0.440903, -3.92604>, <9.03594e-05, 0.00031682, -0.000173782> }
        smooth_triangle {<-0.153016, 0.440903, -3.92604>, <9.62288e-05, 0.000346549, -0.000182528>,
                         <-0.189287, 0.437125, -3.9537>, <0.000115271, 0.000443644, -0.000192103>,
                         <-0.207183, 0.441016, -3.95534>, <0.000116532, 0.00044749, -0.000196746> }
        smooth_triangle {<-0.167429, 0.444322, -3.92719>, <9.12554e-05, 0.000319094, -0.000178264>,
                         <-0.126207, 0.448673, -3.90253>, <6.34221e-05, 0.000198613, -0.000151261>,
                         <-0.115361, 0.445875, -3.90172>, <6.31229e-05, 0.000198211, -0.000148655> }
        smooth_triangle {<-0.115361, 0.445875, -3.90172>, <6.95597e-05, 0.000225502, -0.000161598>,
                         <-0.153016, 0.440903, -3.92604>, <8.99871e-05, 0.00031446, -0.000180443>,
                         <-0.167429, 0.444322, -3.92719>, <9.06591e-05, 0.000316165, -0.000183805> }
        smooth_triangle {<-0.126207, 0.448673, -3.90253>, <6.34221e-05, 0.000198613, -0.000151261>,
                         <-0.0837027, 0.454335, -3.88161>, <3.65313e-05, 0.000101849, -0.000107023>,
                         <-0.0764703, 0.452346, -3.88105>, <3.65073e-05, 0.000102029, -0.000106079> }
        smooth_triangle {<-0.0764703, 0.452346, -3.88105>, <4.31533e-05, 0.000124652, -0.000124309>,
                         <-0.115361, 0.445875, -3.90172>, <6.3115e-05, 0.000196788, -0.000156241>,
                         <-0.126207, 0.448673, -3.90253>, <6.33394e-05, 0.00019709, -0.000158196> }
        smooth_triangle {<-0.0837027, 0.454335, -3.88161>, <3.65313e-05, 0.000101849, -0.000107023>,
                         <-0.0402563, 0.461149, -3.86394>, <1.29575e-05, 3.44085e-05, -4.5122e-05>,
                         <-0.0366429, 0.460133, -3.86365>, <1.29647e-05, 3.44456e-05, -4.50829e-05> }
        smooth_triangle {<-0.0366429, 0.460133, -3.86365>, <1.94734e-05, 5.17026e-05, -6.76972e-05>,
                         <-0.0764703, 0.452346, -3.88105>, <3.71304e-05, 0.00010239, -0.000113444>,
                         <-0.0837027, 0.454335, -3.88161>, <3.71484e-05, 0.000102255, -0.000114153> }
        smooth_triangle {<-0.0402563, 0.461149, -3.86394>, <1.29575e-05, 3.44085e-05, -4.5122e-05>,
                         <0.00373453, 0.46863, -3.84833>, <-1.03012e-06, 1.38013e-06, 2.38302e-06>,
                         <0.00374156, 0.468683, -3.84836>, <-1.04256e-06, 1.2779e-06, 2.184e-06> }
        smooth_triangle {<0.00374156, 0.468683, -3.84836>, <5.3232e-06, 1.52826e-05, -2.25131e-05>,
                         <-0.0366429, 0.460133, -3.86365>, <1.42372e-05, 3.66572e-05, -5.1789e-05>,
                         <-0.0402563, 0.461149, -3.86394>, <1.42318e-05, 3.66294e-05, -5.18183e-05> }
        smooth_triangle {<0.10691, 0.468577, -4.25531>, <-1.24094e-05, 5.16512e-05, 6.9798e-05>,
                         <0.0565656, 0.4624, -4.25969>, <-1.49507e-05, 7.29416e-05, 8.9984e-05>,
                         <0.0599071, 0.461423, -4.25837>, <-1.50096e-05, 7.27603e-05, 8.9999e-05> }
        smooth_triangle {<0.0599071, 0.461423, -4.25837>, <-1.13935e-05, 5.57527e-05, 6.68304e-05>,
                         <0.106885, 0.46863, -4.25521>, <-6.56072e-06, 2.80086e-05, 3.36377e-05>,
                         <0.10691, 0.468577, -4.25531>, <-6.47744e-06, 2.81905e-05, 3.35612e-05> }
        smooth_triangle {<0.0565656, 0.4624, -4.25969>, <-1.49507e-05, 7.29416e-05, 8.9984e-05>,
                         <0.00592219, 0.457035, -4.26279>, <-2.10337e-05, 0.0001417, 0.000145663>,
                         <0.012591, 0.455164, -4.26011>, <-2.06577e-05, 0.00014216, 0.000145048> }
        smooth_triangle {<0.012591, 0.455164, -4.26011>, <-1.79779e-05, 0.000120742, 0.000125565>,
                         <0.0599071, 0.461423, -4.25837>, <-1.37418e-05, 6.86926e-05, 8.4278e-05>,
                         <0.0565656, 0.4624, -4.25969>, <-1.36976e-05, 6.88285e-05, 8.42667e-05> }
        smooth_triangle {<0.00592219, 0.457035, -4.26279>, <-2.10337e-05, 0.0001417, 0.000145663>,
                         <-0.0450254, 0.452678, -4.26449>, <-2.26947e-05, 0.000224003, 0.000188251>,
                         <-0.0350611, 0.450081, -4.26033>, <-2.16912e-05, 0.000225113, 0.00018654> }
        smooth_triangle {<-0.0350611, 0.450081, -4.26033>, <-1.97829e-05, 0.000200418, 0.000170663>,
                         <0.012591, 0.455164, -4.26011>, <-1.90078e-05, 0.000138203, 0.000139545>,
                         <0.00592219, 0.457035, -4.26279>, <-1.92898e-05, 0.000137859, 0.000140006> }
        smooth_triangle {<-0.0450254, 0.452678, -4.26449>, <-2.26947e-05, 0.000224003, 0.000188251>,
                         <-0.0961951, 0.449044, -4.26499>, <-2.18159e-05, 0.000314623, 0.000223533>,
                         <-0.0829475, 0.445841, -4.25933>, <-2.03279e-05, 0.000315777, 0.000220705> }
        smooth_triangle {<-0.0829475, 0.445841, -4.25933>, <-1.90052e-05, 0.000289127, 0.000207178>,
                         <-0.0350611, 0.450081, -4.26033>, <-2.00276e-05, 0.000221129, 0.000181554>,
                         <-0.0450254, 0.452678, -4.26449>, <-2.07803e-05, 0.000220297, 0.000182837> }
        smooth_triangle {<-0.0961951, 0.449044, -4.26499>, <-2.18159e-05, 0.000314623, 0.000223533>,
                         <-0.147552, 0.44587, -4.26421>, <-1.77952e-05, 0.000416196, 0.000254182>,
                         <-0.131022, 0.442139, -4.25708>, <-1.60458e-05, 0.000416519, 0.000250294> }
        smooth_triangle {<-0.131022, 0.442139, -4.25708>, <-1.54753e-05, 0.000387881, 0.000238471>,
                         <-0.0829475, 0.445841, -4.25933>, <-1.86869e-05, 0.000312325, 0.000216279>,
                         <-0.0961951, 0.449044, -4.26499>, <-1.98029e-05, 0.000311459, 0.000218401> }
        smooth_triangle {<-0.147552, 0.44587, -4.26421>, <-1.77952e-05, 0.000416196, 0.000254182>,
                         <-0.199115, 0.443108, -4.26154>, <-7.31022e-06, 0.000540093, 0.000278902>,
                         <-0.179299, 0.438917, -4.25304>, <-5.52128e-06, 0.000538106, 0.000273753> }
        smooth_triangle {<-0.179299, 0.438917, -4.25304>, <-6.10654e-06, 0.000506348, 0.000263665>,
                         <-0.131022, 0.442139, -4.25708>, <-1.39999e-05, 0.000415157, 0.000246071>,
                         <-0.147552, 0.44587, -4.26421>, <-1.5312e-05, 0.000414915, 0.000248986> }
        smooth_triangle {<-0.199115, 0.443108, -4.26154>, <-7.31022e-06, 0.000540093, 0.000278902>,
                         <-0.250853, 0.440793, -4.25567>, <1.79208e-05, 0.000719495, 0.000293503>,
                         <-0.227747, 0.436216, -4.24598>, <1.92052e-05, 0.000711402, 0.000286614> }
        smooth_triangle {<-0.227747, 0.436216, -4.24598>, <1.60546e-05, 0.000671473, 0.00027911>,
                         <-0.179299, 0.438917, -4.25304>, <-2.49019e-06, 0.000541501, 0.000269465>,
                         <-0.199115, 0.443108, -4.26154>, <-3.83189e-06, 0.000542991, 0.000273326> }
        smooth_triangle {<-0.250853, 0.440793, -4.25567>, <1.79208e-05, 0.000719495, 0.000293503>,
                         <-0.302172, 0.439108, -4.24248>, <7.55226e-05, 0.00102563, 0.000284601>,
                         <-0.275817, 0.43425, -4.2321>, <7.47716e-05, 0.00100227, 0.00027558> }
        smooth_triangle {<-0.275817, 0.43425, -4.2321>, <6.72084e-05, 0.000948303, 0.00027305>,
                         <-0.227747, 0.436216, -4.24598>, <2.55336e-05, 0.000730151, 0.000281325>,
                         <-0.250853, 0.440793, -4.25567>, <2.45704e-05, 0.000736221, 0.000286492> }
        smooth_triangle {<-0.302172, 0.439108, -4.24248>, <7.55226e-05, 0.00102563, 0.000284601>,
                         <-0.348702, 0.438246, -4.21397>, <0.000171347, 0.00145602, 0.000222872>,
                         <-0.319449, 0.433244, -4.20394>, <0.00016618, 0.00140703, 0.000213509> }
        smooth_triangle {<-0.319449, 0.433244, -4.20394>, <0.000156216, 0.00135406, 0.000219752>,
                         <-0.275817, 0.43425, -4.2321>, <8.76599e-05, 0.00105049, 0.000266305>,
                         <-0.302172, 0.439108, -4.24248>, <8.82231e-05, 0.00106801, 0.000273071> }
        smooth_triangle {<-0.348702, 0.438246, -4.21397>, <0.000171347, 0.00145602, 0.000222872>,
                         <-0.376662, 0.438175, -4.16542>, <0.000257336, 0.00171887, 8.2608e-05>,
                         <-0.34584, 0.433161, -4.15717>, <0.00024774, 0.00165245, 7.80892e-05> }
        smooth_triangle {<-0.34584, 0.433161, -4.15717>, <0.000244088, 0.00164757, 9.21813e-05>,
                         <-0.319449, 0.433244, -4.20394>, <0.000182917, 0.00146351, 0.000193746>,
                         <-0.348702, 0.438246, -4.21397>, <0.000186793, 0.00150025, 0.000200769> }
        smooth_triangle {<-0.376662, 0.438175, -4.16542>, <0.000257336, 0.00171887, 8.2608e-05>,
                         <-0.370904, 0.438712, -4.10976>, <0.000264326, 0.0015022, -8.35775e-05>,
                         <-0.34092, 0.433788, -4.1038>, <0.000254731, 0.00144778, -8.02732e-05> }
        smooth_triangle {<-0.34092, 0.433788, -4.1038>, <0.000259235, 0.00148689, -7.12067e-05>,
                         <-0.34584, 0.433161, -4.15717>, <0.000253992, 0.0016404, 4.75651e-05>,
                         <-0.376662, 0.438175, -4.16542>, <0.000261188, 0.00169021, 5.09543e-05> }
        smooth_triangle {<-0.370904, 0.438712, -4.10976>, <0.000264326, 0.0015022, -8.35775e-05>,
                         <-0.342909, 0.439694, -4.06282>, <0.000214984, 0.00107764, -0.000175338>,
                         <-0.315349, 0.434933, -4.05854>, <0.000208629, 0.00104751, -0.000167922> }
        smooth_triangle {<-0.315349, 0.434933, -4.05854>, <0.000213904, 0.00108686, -0.000166006>,
                         <-0.34092, 0.433788, -4.1038>, <0.00024848, 0.00138706, -0.00010027>,
                         <-0.370904, 0.438712, -4.10976>, <0.000255676, 0.00142788, -0.000102748> }
        smooth_triangle {<-0.342909, 0.439694, -4.06282>, <0.000214984, 0.00107764, -0.000175338>,
                         <-0.306491, 0.441045, -4.02356>, <0.00017368, 0.000788971, -0.000203392>,
                         <-0.281953, 0.436509, -4.02043>, <0.000169712, 0.000773073, -0.000195338> }
        smooth_triangle {<-0.281953, 0.436509, -4.02043>, <0.000174329, 0.000806664, -0.000197108>,
                         <-0.315349, 0.434933, -4.05854>, <0.000203517, 0.00101249, -0.000176546>,
                         <-0.342909, 0.439694, -4.06282>, <0.000208283, 0.00103509, -0.000182108> }
        smooth_triangle {<-0.306491, 0.441045, -4.02356>, <0.00017368, 0.000788971, -0.000203392>,
                         <-0.266726, 0.442751, -3.98873>, <0.000144683, 0.000603738, -0.000206394>,
                         <-0.245446, 0.4385, -3.98644>, <0.000142069, 0.00059466, -0.000198953> }
        smooth_triangle {<-0.245446, 0.4385, -3.98644>, <0.000146654, 0.000625892, -0.00020282>,
                         <-0.281953, 0.436509, -4.02043>, <0.000167387, 0.000759702, -0.000200108>,
                         <-0.306491, 0.441045, -4.02356>, <0.000170363, 0.000771626, -0.000206149> }
        smooth_triangle {<-0.266726, 0.442751, -3.98873>, <0.000144683, 0.000603738, -0.000206394>,
                         <-0.22508, 0.444908, -3.95697>, <0.000119112, 0.000456536, -0.00019893>,
                         <-0.207183, 0.441016, -3.95534>, <0.000117431, 0.000451408, -0.000192739> }
        smooth_triangle {<-0.207183, 0.441016, -3.95534>, <0.000122565, 0.000482095, -0.000198611>,
                         <-0.245446, 0.4385, -3.98644>, <0.000141043, 0.000589534, -0.000203271>,
                         <-0.266726, 0.442751, -3.98873>, <0.000143004, 0.000596343, -0.000208852> }
        smooth_triangle {<-0.22508, 0.444908, -3.95697>, <0.000119112, 0.000456536, -0.00019893>,
                         <-0.181843, 0.447742, -3.92833>, <9.21514e-05, 0.000321367, -0.000182746>,
                         <-0.167429, 0.444322, -3.92719>, <9.12554e-05, 0.000319094, -0.000178264> }
        smooth_triangle {<-0.167429, 0.444322, -3.92719>, <9.71834e-05, 0.000349018, -0.000187166>,
                         <-0.207183, 0.441016, -3.95534>, <0.000116815, 0.000448253, -0.000198022>,
                         <-0.22508, 0.444908, -3.95697>, <0.000118076, 0.000452099, -0.000202665> }
        smooth_triangle {<-0.181843, 0.447742, -3.92833>, <9.21514e-05, 0.000321367, -0.000182746>,
                         <-0.137053, 0.451471, -3.90334>, <6.37214e-05, 0.000199016, -0.000153867>,
                         <-0.126207, 0.448673, -3.90253>, <6.34221e-05, 0.000198613, -0.000151261> }
        smooth_triangle {<-0.126207, 0.448673, -3.90253>, <6.98908e-05, 0.000225982, -0.000164363>,
                         <-0.167429, 0.444322, -3.92719>, <9.07658e-05, 0.000316343, -0.000184615>,
                         <-0.181843, 0.447742, -3.92833>, <9.14378e-05, 0.000318048, -0.000187976> }
        smooth_triangle {<-0.137053, 0.451471, -3.90334>, <6.37214e-05, 0.000199016, -0.000153867>,
                         <-0.090935, 0.456324, -3.88217>, <3.65553e-05, 0.000101669, -0.000107968>,
                         <-0.0837027, 0.454335, -3.88161>, <3.65313e-05, 0.000101849, -0.000107023> }
        smooth_triangle {<-0.0837027, 0.454335, -3.88161>, <4.31824e-05, 0.000124463, -0.000125352>,
                         <-0.126207, 0.448673, -3.90253>, <6.33506e-05, 0.000197036, -0.00015853>,
                         <-0.137053, 0.451471, -3.90334>, <6.3575e-05, 0.000197338, -0.000160484> }
        smooth_triangle {<-0.090935, 0.456324, -3.88217>, <3.65553e-05, 0.000101669, -0.000107968>,
                         <-0.0438696, 0.462165, -3.86424>, <1.29502e-05, 3.43715e-05, -4.51611e-05>,
                         <-0.0402563, 0.461149, -3.86394>, <1.29575e-05, 3.44085e-05, -4.5122e-05> }
        smooth_triangle {<-0.0402563, 0.461149, -3.86394>, <1.94637e-05, 5.16482e-05, -6.77661e-05>,
                         <-0.0837027, 0.454335, -3.88161>, <3.71441e-05, 0.000102229, -0.000114192>,
                         <-0.090935, 0.456324, -3.88217>, <3.71621e-05, 0.000102094, -0.000114901> }
        smooth_triangle {<-0.0438696, 0.462165, -3.86424>, <1.29502e-05, 3.43715e-05, -4.51611e-05>,
                         <0.00372751, 0.468577, -3.8483>, <-1.01768e-06, 1.48236e-06, 2.58204e-06>,
                         <0.00373453, 0.46863, -3.84833>, <-1.03012e-06, 1.38013e-06, 2.38302e-06> }
        smooth_triangle {<0.00373453, 0.46863, -3.84833>, <5.33564e-06, 1.53848e-05, -2.23141e-05>,
                         <-0.0402563, 0.461149, -3.86394>, <1.42349e-05, 3.66549e-05, -5.17686e-05>,
                         <-0.0438696, 0.462165, -3.86424>, <1.42295e-05, 3.66271e-05, -5.17979e-05> }
        smooth_triangle {<0.106935, 0.468524, -4.25541>, <-1.22428e-05, 5.2015e-05, 6.9645e-05>,
                         <0.053224, 0.463376, -4.261>, <-1.48918e-05, 7.31228e-05, 8.99691e-05>,
                         <0.0565656, 0.4624, -4.25969>, <-1.49507e-05, 7.29416e-05, 8.9984e-05> }
        smooth_triangle {<0.0565656, 0.4624, -4.25969>, <-1.13077e-05, 5.59796e-05, 6.67809e-05>,
                         <0.10691, 0.468577, -4.25531>, <-6.39415e-06, 2.83724e-05, 3.34847e-05>,
                         <0.106935, 0.468524, -4.25541>, <-6.31086e-06, 2.85543e-05, 3.34083e-05> }
        smooth_triangle {<0.053224, 0.463376, -4.261>, <-1.48918e-05, 7.31228e-05, 8.99691e-05>,
                         <-0.000746657, 0.458905, -4.26547>, <-2.14097e-05, 0.000141241, 0.000146278>,
                         <0.00592219, 0.457035, -4.26279>, <-2.10337e-05, 0.0001417, 0.000145663> }
        smooth_triangle {<0.00592219, 0.457035, -4.26279>, <-1.8299e-05, 0.000120352, 0.000126091>,
                         <0.0565656, 0.4624, -4.25969>, <-1.37368e-05, 6.87825e-05, 8.4332e-05>,
                         <0.053224, 0.463376, -4.261>, <-1.36926e-05, 6.89184e-05, 8.43207e-05> }
        smooth_triangle {<-0.000746657, 0.458905, -4.26547>, <-2.14097e-05, 0.000141241, 0.000146278>,
                         <-0.0549898, 0.455275, -4.26865>, <-2.36982e-05, 0.000222894, 0.000189962>,
                         <-0.0450254, 0.452678, -4.26449>, <-2.26947e-05, 0.000224003, 0.000188251> }
        smooth_triangle {<-0.0450254, 0.452678, -4.26449>, <-2.07392e-05, 0.000199334, 0.000172277>,
                         <0.00592219, 0.457035, -4.26279>, <-1.94935e-05, 0.000137607, 0.000140336>,
                         <-0.000746657, 0.458905, -4.26547>, <-1.97755e-05, 0.000137262, 0.000140797> }
        smooth_triangle {<-0.0549898, 0.455275, -4.26865>, <-2.36982e-05, 0.000222894, 0.000189962>,
                         <-0.109443, 0.452246, -4.27066>, <-2.33039e-05, 0.000313468, 0.000226362>,
                         <-0.0961951, 0.449044, -4.26499>, <-2.18159e-05, 0.000314623, 0.000223533> }
        smooth_triangle {<-0.0961951, 0.449044, -4.26499>, <-2.04663e-05, 0.000287934, 0.000209921>,
                         <-0.0450254, 0.452678, -4.26449>, <-2.11254e-05, 0.000219969, 0.00018346>,
                         <-0.0549898, 0.455275, -4.26865>, <-2.1878e-05, 0.000219137, 0.000184743> }
        smooth_triangle {<-0.109443, 0.452246, -4.27066>, <-2.33039e-05, 0.000313468, 0.000226362>,
                         <-0.164082, 0.449602, -4.27134>, <-1.95447e-05, 0.000415873, 0.000258069>,
                         <-0.147552, 0.44587, -4.26421>, <-1.77952e-05, 0.000416196, 0.000254182> }
        smooth_triangle {<-0.147552, 0.44587, -4.26421>, <-1.7213e-05, 0.000387428, 0.000242263>,
                         <-0.0961951, 0.449044, -4.26499>, <-2.02285e-05, 0.000311248, 0.000219277>,
                         <-0.109443, 0.452246, -4.27066>, <-2.13445e-05, 0.000310382, 0.000221398> }
        smooth_triangle {<-0.164082, 0.449602, -4.27134>, <-1.95447e-05, 0.000415873, 0.000258069>,
                         <-0.218931, 0.4473, -4.27004>, <-9.09916e-06, 0.00054208, 0.000284051>,
                         <-0.199115, 0.443108, -4.26154>, <-7.31022e-06, 0.000540093, 0.000278902> }
        smooth_triangle {<-0.199115, 0.443108, -4.26154>, <-7.90912e-06, 0.000508018, 0.00026869>,
                         <-0.147552, 0.44587, -4.26421>, <-1.57729e-05, 0.000415096, 0.00025015>,
                         <-0.164082, 0.449602, -4.27134>, <-1.7085e-05, 0.000414854, 0.000253065> }
        smooth_triangle {<-0.218931, 0.4473, -4.27004>, <-9.09916e-06, 0.00054208, 0.000284051>,
                         <-0.273958, 0.445371, -4.26535>, <1.66365e-05, 0.000727588, 0.000300391>,
                         <-0.250853, 0.440793, -4.25567>, <1.79208e-05, 0.000719495, 0.000293503> }
        smooth_triangle {<-0.250853, 0.440793, -4.25567>, <1.46714e-05, 0.000678671, 0.000285812>,
                         <-0.199115, 0.443108, -4.26154>, <-4.25185e-06, 0.00054412, 0.000274862>,
                         <-0.218931, 0.4473, -4.27004>, <-5.59356e-06, 0.00054561, 0.000278724> }
        smooth_triangle {<-0.273958, 0.445371, -4.26535>, <1.66365e-05, 0.000727588, 0.000300391>,
                         <-0.328526, 0.443967, -4.25287>, <7.62736e-05, 0.00104899, 0.000293622>,
                         <-0.302172, 0.439108, -4.24248>, <7.55226e-05, 0.00102563, 0.000284601> }
        smooth_triangle {<-0.302172, 0.439108, -4.24248>, <6.76484e-05, 0.000969636, 0.000281912>,
                         <-0.250853, 0.440793, -4.25567>, <2.4447e-05, 0.000740033, 0.000288588>,
                         <-0.273958, 0.445371, -4.26535>, <2.34838e-05, 0.000746103, 0.000293755> }
        smooth_triangle {<-0.328526, 0.443967, -4.25287>, <7.62736e-05, 0.00104899, 0.000293622>,
                         <-0.377955, 0.443248, -4.224>, <0.000176513, 0.001505, 0.000232235>,
                         <-0.348702, 0.438246, -4.21397>, <0.000171347, 0.00145602, 0.000222872> }
        smooth_triangle {<-0.348702, 0.438246, -4.21397>, <0.000160901, 0.0014007, 0.000229348>,
                         <-0.302172, 0.439108, -4.24248>, <8.90331e-05, 0.00107791, 0.000275645>,
                         <-0.328526, 0.443967, -4.25287>, <8.95963e-05, 0.00109543, 0.00028241> }
        smooth_triangle {<-0.377955, 0.443248, -4.224>, <0.000176513, 0.001505, 0.000232235>,
                         <-0.407484, 0.443189, -4.17367>, <0.000266932, 0.00178529, 8.71269e-05>,
                         <-0.376662, 0.438175, -4.16542>, <0.000257336, 0.00171887, 8.2608e-05> }
        smooth_triangle {<-0.376662, 0.438175, -4.16542>, <0.000253539, 0.00171434, 9.74451e-05>,
                         <-0.348702, 0.438246, -4.21397>, <0.000189048, 0.0015172, 0.000202643>,
                         <-0.377955, 0.443248, -4.224>, <0.000192923, 0.00155394, 0.000209665> }
        smooth_triangle {<-0.407484, 0.443189, -4.17367>, <0.000266932, 0.00178529, 8.71269e-05>,
                         <-0.400888, 0.443637, -4.11572>, <0.000273921, 0.00155663, -8.68818e-05>,
                         <-0.370904, 0.438712, -4.10976>, <0.000264326, 0.0015022, -8.35775e-05> }
        smooth_triangle {<-0.370904, 0.438712, -4.10976>, <0.000269117, 0.00154363, -7.40451e-05>,
                         <-0.376662, 0.438175, -4.16542>, <0.000263875, 0.00170613, 5.05941e-05>,
                         <-0.407484, 0.443189, -4.17367>, <0.000271072, 0.00175595, 5.39832e-05> }
        smooth_triangle {<-0.400888, 0.443637, -4.11572>, <0.000273921, 0.00155663, -8.68818e-05>,
                         <-0.370468, 0.444455, -4.0671>, <0.00022134, 0.00110777, -0.000182754>,
                         <-0.342909, 0.439694, -4.06282>, <0.000214984, 0.00107764, -0.000175338> }
        smooth_triangle {<-0.342909, 0.439694, -4.06282>, <0.000220493, 0.00111843, -0.000173326>,
                         <-0.370904, 0.438712, -4.10976>, <0.000257499, 0.00143685, -0.000104506>,
                         <-0.400888, 0.443637, -4.11572>, <0.000264696, 0.00147767, -0.000106984> }
        smooth_triangle {<-0.370468, 0.444455, -4.0671>, <0.00022134, 0.00110777, -0.000182754>,
                         <-0.331028, 0.44558, -4.0267>, <0.000177648, 0.00080487, -0.000211446>,
                         <-0.306491, 0.441045, -4.02356>, <0.00017368, 0.000788971, -0.000203392> }
        smooth_triangle {<-0.306491, 0.441045, -4.02356>, <0.000178425, 0.000823233, -0.000205194>,
                         <-0.342909, 0.439694, -4.06282>, <0.000209403, 0.00103973, -0.000184154>,
                         <-0.370468, 0.444455, -4.0671>, <0.00021417, 0.00106233, -0.000189716> }
        smooth_triangle {<-0.331028, 0.44558, -4.0267>, <0.000177648, 0.00080487, -0.000211446>,
                         <-0.288007, 0.447002, -3.99102>, <0.000147297, 0.000612816, -0.000213836>,
                         <-0.266726, 0.442751, -3.98873>, <0.000144683, 0.000603738, -0.000206394> }
        smooth_triangle {<-0.266726, 0.442751, -3.98873>, <0.000149351, 0.000635334, -0.000210349>,
                         <-0.306491, 0.441045, -4.02356>, <0.000171098, 0.000774259, -0.000208098>,
                         <-0.331028, 0.44558, -4.0267>, <0.000174074, 0.000786184, -0.000214138> }
        smooth_triangle {<-0.288007, 0.447002, -3.99102>, <0.000147297, 0.000612816, -0.000213836>,
                         <-0.242976, 0.4488, -3.95861>, <0.000120793, 0.000461664, -0.000205121>,
                         <-0.22508, 0.444908, -3.95697>, <0.000119112, 0.000456536, -0.00019893> }
        smooth_triangle {<-0.22508, 0.444908, -3.95697>, <0.000124314, 0.000487483, -0.000204937>,
                         <-0.266726, 0.442751, -3.98873>, <0.000143493, 0.000597884, -0.000210536>,
                         <-0.288007, 0.447002, -3.99102>, <0.000145454, 0.000604693, -0.000216117> }
        smooth_triangle {<-0.242976, 0.4488, -3.95861>, <0.000120793, 0.000461664, -0.000205121>,
                         <-0.196256, 0.451161, -3.92948>, <9.30474e-05, 0.000323641, -0.000187229>,
                         <-0.181843, 0.447742, -3.92833>, <9.21514e-05, 0.000321367, -0.000182746> }
        smooth_triangle {<-0.181843, 0.447742, -3.92833>, <9.81381e-05, 0.000351486, -0.000191803>,
                         <-0.22508, 0.444908, -3.95697>, <0.000118358, 0.000452863, -0.000203941>,
                         <-0.242976, 0.4488, -3.95861>, <0.000119619, 0.000456709, -0.000208584> }
        smooth_triangle {<-0.196256, 0.451161, -3.92948>, <9.30474e-05, 0.000323641, -0.000187229>,
                         <-0.147899, 0.454269, -3.90416>, <6.40207e-05, 0.000199418, -0.000156473>,
                         <-0.137053, 0.451471, -3.90334>, <6.37214e-05, 0.000199016, -0.000153867> }
        smooth_triangle {<-0.137053, 0.451471, -3.90334>, <7.02219e-05, 0.000226462, -0.000167127>,
                         <-0.181843, 0.447742, -3.92833>, <9.15444e-05, 0.000318226, -0.000188786>,
                         <-0.196256, 0.451161, -3.92948>, <9.22164e-05, 0.000319931, -0.000192148> }
        smooth_triangle {<-0.147899, 0.454269, -3.90416>, <6.40207e-05, 0.000199418, -0.000156473>,
                         <-0.0981674, 0.458313, -3.88274>, <3.65792e-05, 0.000101489, -0.000108913>,
                         <-0.090935, 0.456324, -3.88217>, <3.65553e-05, 0.000101669, -0.000107968> }
        smooth_triangle {<-0.090935, 0.456324, -3.88217>, <4.32116e-05, 0.000124274, -0.000126395>,
                         <-0.137053, 0.451471, -3.90334>, <6.35862e-05, 0.000197283, -0.000160819>,
                         <-0.147899, 0.454269, -3.90416>, <6.38106e-05, 0.000197585, -0.000162773> }
        smooth_triangle {<-0.0981674, 0.458313, -3.88274>, <3.65792e-05, 0.000101489, -0.000108913>,
                         <-0.047483, 0.46318, -3.86453>, <1.2943e-05, 3.43344e-05, -4.52002e-05>,
                         <-0.0438696, 0.462165, -3.86424>, <1.29502e-05, 3.43715e-05, -4.51611e-05> }
        smooth_triangle {<-0.0438696, 0.462165, -3.86424>, <1.94541e-05, 5.15937e-05, -6.78349e-05>,
                         <-0.090935, 0.456324, -3.88217>, <3.71578e-05, 0.000102067, -0.00011494>,
                         <-0.0981674, 0.458313, -3.88274>, <3.71758e-05, 0.000101932, -0.000115649> }
        smooth_triangle {<-0.047483, 0.46318, -3.86453>, <1.2943e-05, 3.43344e-05, -4.52002e-05>,
                         <0.00372048, 0.468524, -3.84827>, <-1.00524e-06, 1.58459e-06, 2.78106e-06>,
                         <0.00372751, 0.468577, -3.8483>, <-1.01768e-06, 1.48236e-06, 2.58204e-06> }
        smooth_triangle {<0.00372751, 0.468577, -3.8483>, <5.34808e-06, 1.5487e-05, -2.21151e-05>,
                         <-0.0438696, 0.462165, -3.86424>, <1.42326e-05, 3.66527e-05, -5.17481e-05>,
                         <-0.047483, 0.46318, -3.86453>, <1.42272e-05, 3.66249e-05, -5.17774e-05> }
        smooth_triangle {<0.10696, 0.468471, -4.2555>, <-1.20763e-05, 5.23789e-05, 6.94921e-05>,
                         <0.0498824, 0.464353, -4.26232>, <-1.4833e-05, 7.3304e-05, 8.99541e-05>,
                         <0.053224, 0.463376, -4.261>, <-1.48918e-05, 7.31228e-05, 8.99691e-05> }
        smooth_triangle {<0.053224, 0.463376, -4.261>, <-1.1222e-05, 5.62064e-05, 6.67314e-05>,
                         <0.106935, 0.468524, -4.25541>, <-6.22757e-06, 2.87362e-05, 3.33318e-05>,
                         <0.10696, 0.468471, -4.2555>, <-6.14429e-06, 2.89181e-05, 3.32553e-05> }
        smooth_triangle {<0.0498824, 0.464353, -4.26232>, <-1.4833e-05, 7.3304e-05, 8.99541e-05>,
                         <-0.0074155, 0.460776, -4.26816>, <-2.17857e-05, 0.000140782, 0.000146892>,
                         <-0.000746657, 0.458905, -4.26547>, <-2.14097e-05, 0.000141241, 0.000146278> }
        smooth_triangle {<-0.000746657, 0.458905, -4.26547>, <-1.86202e-05, 0.000119961, 0.000126617>,
                         <0.053224, 0.463376, -4.261>, <-1.37318e-05, 6.88725e-05, 8.4386e-05>,
                         <0.0498824, 0.464353, -4.26232>, <-1.36876e-05, 6.90084e-05, 8.43747e-05> }
        smooth_triangle {<-0.0074155, 0.460776, -4.26816>, <-2.17857e-05, 0.000140782, 0.000146892>,
                         <-0.0649541, 0.457871, -4.27281>, <-2.47017e-05, 0.000221785, 0.000191674>,
                         <-0.0549898, 0.455275, -4.26865>, <-2.36982e-05, 0.000222894, 0.000189962> }
        smooth_triangle {<-0.0549898, 0.455275, -4.26865>, <-2.16956e-05, 0.000198249, 0.000173891>,
                         <-0.000746657, 0.458905, -4.26547>, <-1.99792e-05, 0.00013701, 0.000141128>,
                         <-0.0074155, 0.460776, -4.26816>, <-2.02612e-05, 0.000136665, 0.000141589> }
        smooth_triangle {<-0.0649541, 0.457871, -4.27281>, <-2.47017e-05, 0.000221785, 0.000191674>,
                         <-0.12269, 0.455449, -4.27632>, <-2.47918e-05, 0.000312313, 0.00022919>,
                         <-0.109443, 0.452246, -4.27066>, <-2.33039e-05, 0.000313468, 0.000226362> }
        smooth_triangle {<-0.109443, 0.452246, -4.27066>, <-2.19275e-05, 0.000286741, 0.000212665>,
                         <-0.0549898, 0.455275, -4.26865>, <-2.22232e-05, 0.00021881, 0.000185366>,
                         <-0.0649541, 0.457871, -4.27281>, <-2.29758e-05, 0.000217978, 0.000186649> }
        smooth_triangle {<-0.12269, 0.455449, -4.27632>, <-2.47918e-05, 0.000312313, 0.00022919>,
                         <-0.180612, 0.453333, -4.27847>, <-2.12942e-05, 0.00041555, 0.000261957>,
                         <-0.164082, 0.449602, -4.27134>, <-1.95447e-05, 0.000415873, 0.000258069> }
        smooth_triangle {<-0.164082, 0.449602, -4.27134>, <-1.89507e-05, 0.000386974, 0.000246055>,
                         <-0.109443, 0.452246, -4.27066>, <-2.17701e-05, 0.00031017, 0.000222275>,
                         <-0.12269, 0.455449, -4.27632>, <-2.28861e-05, 0.000309304, 0.000224396> }
        smooth_triangle {<-0.180612, 0.453333, -4.27847>, <-2.12942e-05, 0.00041555, 0.000261957>,
                         <-0.238748, 0.451492, -4.27854>, <-1.08881e-05, 0.000544067, 0.0002892>,
                         <-0.218931, 0.4473, -4.27004>, <-9.09916e-06, 0.00054208, 0.000284051> }
        smooth_triangle {<-0.218931, 0.4473, -4.27004>, <-9.7117e-06, 0.000509689, 0.000273715>,
                         <-0.164082, 0.449602, -4.27134>, <-1.75459e-05, 0.000415034, 0.000254229>,
                         <-0.180612, 0.453333, -4.27847>, <-1.8858e-05, 0.000414792, 0.000257144> }
        smooth_triangle {<-0.238748, 0.451492, -4.27854>, <-1.08881e-05, 0.000544067, 0.0002892>,
                         <-0.297064, 0.449948, -4.27504>, <1.53521e-05, 0.000735681, 0.00030728>,
                         <-0.273958, 0.445371, -4.26535>, <1.66365e-05, 0.000727588, 0.000300391> }
        smooth_triangle {<-0.273958, 0.445371, -4.26535>, <1.32882e-05, 0.00068587, 0.000292514>,
                         <-0.218931, 0.4473, -4.27004>, <-6.01352e-06, 0.000546739, 0.000280259>,
                         <-0.238748, 0.451492, -4.27854>, <-7.35523e-06, 0.000548229, 0.000284121> }
        smooth_triangle {<-0.297064, 0.449948, -4.27504>, <1.53521e-05, 0.000735681, 0.00030728>,
                         <-0.354881, 0.448825, -4.26326>, <7.70246e-05, 0.00107235, 0.000302643>,
                         <-0.328526, 0.443967, -4.25287>, <7.62736e-05, 0.00104899, 0.000293622> }
        smooth_triangle {<-0.328526, 0.443967, -4.25287>, <6.80883e-05, 0.000990969, 0.000290773>,
                         <-0.273958, 0.445371, -4.26535>, <2.33604e-05, 0.000749915, 0.000295851>,
                         <-0.297064, 0.449948, -4.27504>, <2.23972e-05, 0.000755985, 0.000301017> }
        smooth_triangle {<-0.354881, 0.448825, -4.26326>, <7.70246e-05, 0.00107235, 0.000302643>,
                         <-0.407208, 0.44825, -4.23403>, <0.00018168, 0.00155399, 0.000241598>,
                         <-0.377955, 0.443248, -4.224>, <0.000176513, 0.001505, 0.000232235> }
        smooth_triangle {<-0.377955, 0.443248, -4.224>, <0.000165586, 0.00144733, 0.000238944>,
                         <-0.328526, 0.443967, -4.25287>, <9.04062e-05, 0.00110533, 0.000284984>,
                         <-0.354881, 0.448825, -4.26326>, <9.09695e-05, 0.00112285, 0.00029175> }
        smooth_triangle {<-0.407208, 0.44825, -4.23403>, <0.00018168, 0.00155399, 0.000241598>,
                         <-0.438306, 0.448202, -4.18191>, <0.000276527, 0.00185171, 9.16457e-05>,
                         <-0.407484, 0.443189, -4.17367>, <0.000266932, 0.00178529, 8.71269e-05> }
        smooth_triangle {<-0.407484, 0.443189, -4.17367>, <0.000262991, 0.0017811, 0.000102709>,
                         <-0.377955, 0.443248, -4.224>, <0.000195178, 0.00157089, 0.00021154>,
                         <-0.407208, 0.44825, -4.23403>, <0.000199053, 0.00160762, 0.000218562> }
        smooth_triangle {<-0.438306, 0.448202, -4.18191>, <0.000276527, 0.00185171, 9.16457e-05>,
                         <-0.430871, 0.448561, -4.12168>, <0.000283516, 0.00161105, -9.01861e-05>,
                         <-0.400888, 0.443637, -4.11572>, <0.000273921, 0.00155663, -8.68818e-05> }
        smooth_triangle {<-0.400888, 0.443637, -4.11572>, <0.000279, 0.00160037, -7.68835e-05>,
                         <-0.407484, 0.443189, -4.17367>, <0.000273758, 0.00177187, 5.36231e-05>,
                         <-0.438306, 0.448202, -4.18191>, <0.000280955, 0.00182169, 5.70122e-05> }
        smooth_triangle {<-0.430871, 0.448561, -4.12168>, <0.000283516, 0.00161105, -9.01861e-05>,
                         <-0.398028, 0.449215, -4.07137>, <0.000227695, 0.00113789, -0.000190169>,
                         <-0.370468, 0.444455, -4.0671>, <0.00022134, 0.00110777, -0.000182754> }
        smooth_triangle {<-0.370468, 0.444455, -4.0671>, <0.000227083, 0.00115, -0.000180646>,
                         <-0.400888, 0.443637, -4.11572>, <0.000266519, 0.00148664, -0.000108742>,
                         <-0.430871, 0.448561, -4.12168>, <0.000273715, 0.00152746, -0.00011122> }
        smooth_triangle {<-0.398028, 0.449215, -4.07137>, <0.000227695, 0.00113789, -0.000190169>,
                         <-0.355565, 0.450116, -4.02983>, <0.000181616, 0.000820769, -0.0002195>,
                         <-0.331028, 0.44558, -4.0267>, <0.000177648, 0.00080487, -0.000211446> }
        smooth_triangle {<-0.331028, 0.44558, -4.0267>, <0.000182521, 0.000839803, -0.000213281>,
                         <-0.370468, 0.444455, -4.0671>, <0.00021529, 0.00106697, -0.000191762>,
                         <-0.398028, 0.449215, -4.07137>, <0.000220056, 0.00108957, -0.000197323> }
        smooth_triangle {<-0.355565, 0.450116, -4.02983>, <0.000181616, 0.000820769, -0.0002195>,
                         <-0.309287, 0.451253, -3.99331>, <0.000149912, 0.000621894, -0.000221277>,
                         <-0.288007, 0.447002, -3.99102>, <0.000147297, 0.000612816, -0.000213836> }
        smooth_triangle {<-0.288007, 0.447002, -3.99102>, <0.000152047, 0.000644776, -0.000217879>,
                         <-0.331028, 0.44558, -4.0267>, <0.00017481, 0.000788817, -0.000216087>,
                         <-0.355565, 0.450116, -4.02983>, <0.000177786, 0.000800741, -0.000222127> }
        smooth_triangle {<-0.309287, 0.451253, -3.99331>, <0.000149912, 0.000621894, -0.000221277>,
                         <-0.260873, 0.452692, -3.96025>, <0.000122474, 0.000466792, -0.000211311>,
                         <-0.242976, 0.4488, -3.95861>, <0.000120793, 0.000461664, -0.000205121> }
        smooth_triangle {<-0.242976, 0.4488, -3.95861>, <0.000126064, 0.00049287, -0.000211264>,
                         <-0.288007, 0.447002, -3.99102>, <0.000145943, 0.000606234, -0.0002178>,
                         <-0.309287, 0.451253, -3.99331>, <0.000147903, 0.000613042, -0.000223381> }
        smooth_triangle {<-0.260873, 0.452692, -3.96025>, <0.000122474, 0.000466792, -0.000211311>,
                         <-0.21067, 0.454581, -3.93063>, <9.39434e-05, 0.000325914, -0.000191711>,
                         <-0.196256, 0.451161, -3.92948>, <9.30474e-05, 0.000323641, -0.000187229> }
        smooth_triangle {<-0.196256, 0.451161, -3.92948>, <9.90928e-05, 0.000353955, -0.00019644>,
                         <-0.242976, 0.4488, -3.95861>, <0.000119902, 0.000457472, -0.00020986>,
                         <-0.260873, 0.452692, -3.96025>, <0.000121162, 0.000461319, -0.000214503> }
        smooth_triangle {<-0.21067, 0.454581, -3.93063>, <9.39434e-05, 0.000325914, -0.000191711>,
                         <-0.158746, 0.457067, -3.90497>, <6.432e-05, 0.00019982, -0.000159079>,
                         <-0.147899, 0.454269, -3.90416>, <6.40207e-05, 0.000199418, -0.000156473> }
        smooth_triangle {<-0.147899, 0.454269, -3.90416>, <7.05531e-05, 0.000226942, -0.000169891>,
                         <-0.196256, 0.451161, -3.92948>, <9.23231e-05, 0.000320109, -0.000192958>,
                         <-0.21067, 0.454581, -3.93063>, <9.29951e-05, 0.000321814, -0.000196319> }
        smooth_triangle {<-0.158746, 0.457067, -3.90497>, <6.432e-05, 0.00019982, -0.000159079>,
                         <-0.1054, 0.460302, -3.8833>, <3.66032e-05, 0.000101309, -0.000109857>,
                         <-0.0981674, 0.458313, -3.88274>, <3.65792e-05, 0.000101489, -0.000108913> }
        smooth_triangle {<-0.0981674, 0.458313, -3.88274>, <4.32407e-05, 0.000124085, -0.000127438>,
                         <-0.147899, 0.454269, -3.90416>, <6.38217e-05, 0.000197531, -0.000163108>,
                         <-0.158746, 0.457067, -3.90497>, <6.40462e-05, 0.000197833, -0.000165062> }
        smooth_triangle {<-0.1054, 0.460302, -3.8833>, <3.66032e-05, 0.000101309, -0.000109857>,
                         <-0.0510963, 0.464196, -3.86483>, <1.29358e-05, 3.42973e-05, -4.52393e-05>,
                         <-0.047483, 0.46318, -3.86453>, <1.2943e-05, 3.43344e-05, -4.52002e-05> }
        smooth_triangle {<-0.047483, 0.46318, -3.86453>, <1.94444e-05, 5.15392e-05, -6.79037e-05>,
                         <-0.0981674, 0.458313, -3.88274>, <3.71715e-05, 0.000101905, -0.000115688>,
                         <-0.1054, 0.460302, -3.8833>, <3.71895e-05, 0.00010177, -0.000116397> }
        smooth_triangle {<-0.0510963, 0.464196, -3.86483>, <1.29358e-05, 3.42973e-05, -4.52393e-05>,
                         <0.00371345, 0.468471, -3.84825>, <-9.92797e-07, 1.68682e-06, 2.98008e-06>,
                         <0.00372048, 0.468524, -3.84827>, <-1.00524e-06, 1.58459e-06, 2.78106e-06> }
        smooth_triangle {<0.00372048, 0.468524, -3.84827>, <5.36053e-06, 1.55892e-05, -2.1916e-05>,
                         <-0.047483, 0.46318, -3.86453>, <1.42303e-05, 3.66504e-05, -5.17277e-05>,
                         <-0.0510963, 0.464196, -3.86483>, <1.42249e-05, 3.66226e-05, -5.1757e-05> }
        smooth_triangle {<0.106986, 0.468418, -4.2556>, <-1.19097e-05, 5.27427e-05, 6.93391e-05>,
                         <0.0465409, 0.465329, -4.26364>, <-1.47741e-05, 7.34852e-05, 8.99391e-05>,
                         <0.0498824, 0.464353, -4.26232>, <-1.4833e-05, 7.3304e-05, 8.99541e-05> }
        smooth_triangle {<0.0498824, 0.464353, -4.26232>, <-1.11362e-05, 5.64333e-05, 6.66819e-05>,
                         <0.10696, 0.468471, -4.2555>, <-6.061e-06, 2.91001e-05, 3.31788e-05>,
                         <0.106986, 0.468418, -4.2556>, <-5.97771e-06, 2.9282e-05, 3.31024e-05> }
        smooth_triangle {<0.0465409, 0.465329, -4.26364>, <-1.47741e-05, 7.34852e-05, 8.99391e-05>,
                         <-0.0140843, 0.462647, -4.27084>, <-2.21617e-05, 0.000140323, 0.000147507>,
                         <-0.0074155, 0.460776, -4.26816>, <-2.17857e-05, 0.000140782, 0.000146892> }
        smooth_triangle {<-0.0074155, 0.460776, -4.26816>, <-1.89413e-05, 0.000119571, 0.000127143>,
                         <0.0498824, 0.464353, -4.26232>, <-1.37268e-05, 6.89624e-05, 8.44399e-05>,
                         <0.0465409, 0.465329, -4.26364>, <-1.36826e-05, 6.90983e-05, 8.44287e-05> }
        smooth_triangle {<-0.0140843, 0.462647, -4.27084>, <-2.21617e-05, 0.000140323, 0.000147507>,
                         <-0.0749184, 0.460468, -4.27697>, <-2.57052e-05, 0.000220675, 0.000193385>,
                         <-0.0649541, 0.457871, -4.27281>, <-2.47017e-05, 0.000221785, 0.000191674> }
        smooth_triangle {<-0.0649541, 0.457871, -4.27281>, <-2.26519e-05, 0.000197165, 0.000175505>,
                         <-0.0074155, 0.460776, -4.26816>, <-2.0465e-05, 0.000136413, 0.000141919>,
                         <-0.0140843, 0.462647, -4.27084>, <-2.0747e-05, 0.000136069, 0.00014238> }
        smooth_triangle {<-0.0749184, 0.460468, -4.27697>, <-2.57052e-05, 0.000220675, 0.000193385>,
                         <-0.135938, 0.458651, -4.28198>, <-2.62798e-05, 0.000311159, 0.000232019>,
                         <-0.12269, 0.455449, -4.27632>, <-2.47918e-05, 0.000312313, 0.00022919> }
        smooth_triangle {<-0.12269, 0.455449, -4.27632>, <-2.33886e-05, 0.000285548, 0.000215409>,
                         <-0.0649541, 0.457871, -4.27281>, <-2.3321e-05, 0.000217651, 0.000187272>,
                         <-0.0749184, 0.460468, -4.27697>, <-2.40736e-05, 0.000216819, 0.000188555> }
        smooth_triangle {<-0.135938, 0.458651, -4.28198>, <-2.62798e-05, 0.000311159, 0.000232019>,
                         <-0.197142, 0.457064, -4.2856>, <-2.30437e-05, 0.000415227, 0.000265845>,
                         <-0.180612, 0.453333, -4.27847>, <-2.12942e-05, 0.00041555, 0.000261957> }
        smooth_triangle {<-0.180612, 0.453333, -4.27847>, <-2.06885e-05, 0.00038652, 0.000249847>,
                         <-0.12269, 0.455449, -4.27632>, <-2.33117e-05, 0.000309093, 0.000225272>,
                         <-0.135938, 0.458651, -4.28198>, <-2.44276e-05, 0.000308227, 0.000227393> }
        smooth_triangle {<-0.197142, 0.457064, -4.2856>, <-2.30437e-05, 0.000415227, 0.000265845>,
                         <-0.258564, 0.455683, -4.28704>, <-1.2677e-05, 0.000546053, 0.000294349>,
                         <-0.238748, 0.451492, -4.27854>, <-1.08881e-05, 0.000544067, 0.0002892> }
        smooth_triangle {<-0.238748, 0.451492, -4.27854>, <-1.15143e-05, 0.00051136, 0.00027874>,
                         <-0.180612, 0.453333, -4.27847>, <-1.93189e-05, 0.000414973, 0.000258308>,
                         <-0.197142, 0.457064, -4.2856>, <-2.0631e-05, 0.00041473, 0.000261224> }
        smooth_triangle {<-0.258564, 0.455683, -4.28704>, <-1.2677e-05, 0.000546053, 0.000294349>,
                         <-0.320169, 0.454526, -4.28472>, <1.40678e-05, 0.000743774, 0.000314169>,
                         <-0.297064, 0.449948, -4.27504>, <1.53521e-05, 0.000735681, 0.00030728> }
        smooth_triangle {<-0.297064, 0.449948, -4.27504>, <1.1905e-05, 0.000693069, 0.000299216>,
                         <-0.238748, 0.451492, -4.27854>, <-7.77519e-06, 0.000549358, 0.000285656>,
                         <-0.258564, 0.455683, -4.28704>, <-9.11689e-06, 0.000550848, 0.000289518> }
        smooth_triangle {<-0.320169, 0.454526, -4.28472>, <1.40678e-05, 0.000743774, 0.000314169>,
                         <-0.381236, 0.453683, -4.27365>, <7.77756e-05, 0.00109572, 0.000311663>,
                         <-0.354881, 0.448825, -4.26326>, <7.70246e-05, 0.00107235, 0.000302643> }
        smooth_triangle {<-0.354881, 0.448825, -4.26326>, <6.85282e-05, 0.0010123, 0.000299635>,
                         <-0.297064, 0.449948, -4.27504>, <2.22738e-05, 0.000759797, 0.000303113>,
                         <-0.320169, 0.454526, -4.28472>, <2.13106e-05, 0.000765867, 0.00030828> }
        smooth_triangle {<-0.381236, 0.453683, -4.27365>, <7.77756e-05, 0.00109572, 0.000311663>,
                         <-0.436461, 0.453252, -4.24406>, <0.000186847, 0.00160297, 0.000250961>,
                         <-0.407208, 0.44825, -4.23403>, <0.00018168, 0.00155399, 0.000241598> }
        smooth_triangle {<-0.407208, 0.44825, -4.23403>, <0.000170271, 0.00149397, 0.00024854>,
                         <-0.354881, 0.448825, -4.26326>, <9.17794e-05, 0.00113274, 0.000294323>,
                         <-0.381236, 0.453683, -4.27365>, <9.23427e-05, 0.00115026, 0.000301089> }
        smooth_triangle {<-0.436461, 0.453252, -4.24406>, <0.000186847, 0.00160297, 0.000250961>,
                         <-0.469128, 0.453216, -4.19016>, <0.000286123, 0.00191813, 9.61645e-05>,
                         <-0.438306, 0.448202, -4.18191>, <0.000276527, 0.00185171, 9.16457e-05> }
        smooth_triangle {<-0.438306, 0.448202, -4.18191>, <0.000272443, 0.00184786, 0.000107973>,
                         <-0.407208, 0.44825, -4.23403>, <0.000201308, 0.00162457, 0.000220437>,
                         <-0.436461, 0.453252, -4.24406>, <0.000205183, 0.00166131, 0.000227459> }
        smooth_triangle {<-0.469128, 0.453216, -4.19016>, <0.000286123, 0.00191813, 9.61645e-05>,
                         <-0.460855, 0.453485, -4.12764>, <0.000293111, 0.00166548, -9.34904e-05>,
                         <-0.430871, 0.448561, -4.12168>, <0.000283516, 0.00161105, -9.01861e-05> }
        smooth_triangle {<-0.430871, 0.448561, -4.12168>, <0.000288883, 0.00165712, -7.97218e-05>,
                         <-0.438306, 0.448202, -4.18191>, <0.000283641, 0.00183761, 5.6652e-05>,
                         <-0.469128, 0.453216, -4.19016>, <0.000290838, 0.00188742, 6.00411e-05> }
        smooth_triangle {<-0.460855, 0.453485, -4.12764>, <0.000293111, 0.00166548, -9.34904e-05>,
                         <-0.425587, 0.453976, -4.07565>, <0.00023405, 0.00116802, -0.000197585>,
                         <-0.398028, 0.449215, -4.07137>, <0.000227695, 0.00113789, -0.000190169> }
        smooth_triangle {<-0.398028, 0.449215, -4.07137>, <0.000233673, 0.00118157, -0.000187966>,
                         <-0.430871, 0.448561, -4.12168>, <0.000275538, 0.00153644, -0.000112978>,
                         <-0.460855, 0.453485, -4.12764>, <0.000282734, 0.00157726, -0.000115456> }
        smooth_triangle {<-0.425587, 0.453976, -4.07565>, <0.00023405, 0.00116802, -0.000197585>,
                         <-0.380102, 0.454652, -4.03297>, <0.000185584, 0.000836668, -0.000227554>,
                         <-0.355565, 0.450116, -4.02983>, <0.000181616, 0.000820769, -0.0002195> }
        smooth_triangle {<-0.355565, 0.450116, -4.02983>, <0.000186617, 0.000856372, -0.000221367>,
                         <-0.398028, 0.449215, -4.07137>, <0.000221176, 0.00109421, -0.000199369>,
                         <-0.425587, 0.453976, -4.07565>, <0.000225943, 0.00111681, -0.000204931> }
        smooth_triangle {<-0.380102, 0.454652, -4.03297>, <0.000185584, 0.000836668, -0.000227554>,
                         <-0.330568, 0.455505, -3.9956>, <0.000152526, 0.000630972, -0.000228718>,
                         <-0.309287, 0.451253, -3.99331>, <0.000149912, 0.000621894, -0.000221277> }
        smooth_triangle {<-0.309287, 0.451253, -3.99331>, <0.000154744, 0.000654218, -0.000225408>,
                         <-0.355565, 0.450116, -4.02983>, <0.000178522, 0.000803375, -0.000224076>,
                         <-0.380102, 0.454652, -4.03297>, <0.000181498, 0.000815299, -0.000230117> }
        smooth_triangle {<-0.330568, 0.455505, -3.9956>, <0.000152526, 0.000630972, -0.000228718>,
                         <-0.278769, 0.456583, -3.96188>, <0.000124155, 0.00047192, -0.000217502>,
                         <-0.260873, 0.452692, -3.96025>, <0.000122474, 0.000466792, -0.000211311> }
        smooth_triangle {<-0.260873, 0.452692, -3.96025>, <0.000127814, 0.000498257, -0.000217591>,
                         <-0.309287, 0.451253, -3.99331>, <0.000148393, 0.000614583, -0.000225065>,
                         <-0.330568, 0.455505, -3.9956>, <0.000150353, 0.000621392, -0.000230646> }
        smooth_triangle {<-0.278769, 0.456583, -3.96188>, <0.000124155, 0.00047192, -0.000217502>,
                         <-0.225083, 0.458, -3.93177>, <9.48394e-05, 0.000328188, -0.000196193>,
                         <-0.21067, 0.454581, -3.93063>, <9.39434e-05, 0.000325914, -0.000191711> }
        smooth_triangle {<-0.21067, 0.454581, -3.93063>, <0.000100047, 0.000356424, -0.000201078>,
                         <-0.260873, 0.452692, -3.96025>, <0.000121445, 0.000462082, -0.000215778>,
                         <-0.278769, 0.456583, -3.96188>, <0.000122706, 0.000465928, -0.000220421> }
        smooth_triangle {<-0.225083, 0.458, -3.93177>, <9.48394e-05, 0.000328188, -0.000196193>,
                         <-0.169592, 0.459865, -3.90579>, <6.46192e-05, 0.000200223, -0.000161685>,
                         <-0.158746, 0.457067, -3.90497>, <6.432e-05, 0.00019982, -0.000159079> }
        smooth_triangle {<-0.158746, 0.457067, -3.90497>, <7.08842e-05, 0.000227421, -0.000172656>,
                         <-0.21067, 0.454581, -3.93063>, <9.31018e-05, 0.000321992, -0.000197129>,
                         <-0.225083, 0.458, -3.93177>, <9.37738e-05, 0.000323697, -0.000200491> }
        smooth_triangle {<-0.169592, 0.459865, -3.90579>, <6.46192e-05, 0.000200223, -0.000161685>,
                         <-0.112632, 0.462291, -3.88386>, <3.66272e-05, 0.000101129, -0.000110802>,
                         <-0.1054, 0.460302, -3.8833>, <3.66032e-05, 0.000101309, -0.000109857> }
        smooth_triangle {<-0.1054, 0.460302, -3.8833>, <4.32698e-05, 0.000123895, -0.000128481>,
                         <-0.158746, 0.457067, -3.90497>, <6.40573e-05, 0.000197779, -0.000165397>,
                         <-0.169592, 0.459865, -3.90579>, <6.42818e-05, 0.00019808, -0.000167351> }
        smooth_triangle {<-0.112632, 0.462291, -3.88386>, <3.66272e-05, 0.000101129, -0.000110802>,
                         <-0.0547096, 0.465211, -3.86512>, <1.29286e-05, 3.42602e-05, -4.52783e-05>,
                         <-0.0510963, 0.464196, -3.86483>, <1.29358e-05, 3.42973e-05, -4.52393e-05> }
        smooth_triangle {<-0.0510963, 0.464196, -3.86483>, <1.94347e-05, 5.14847e-05, -6.79726e-05>,
                         <-0.1054, 0.460302, -3.8833>, <3.71853e-05, 0.000101744, -0.000116436>,
                         <-0.112632, 0.462291, -3.88386>, <3.72033e-05, 0.000101609, -0.000117145> }
        smooth_triangle {<-0.0547096, 0.465211, -3.86512>, <1.29286e-05, 3.42602e-05, -4.52783e-05>,
                         <0.00370642, 0.468418, -3.84822>, <-9.80356e-07, 1.78905e-06, 3.1791e-06>,
                         <0.00371345, 0.468471, -3.84825>, <-9.92797e-07, 1.68682e-06, 2.98008e-06> }
        smooth_triangle {<0.00371345, 0.468471, -3.84825>, <5.37297e-06, 1.56915e-05, -2.1717e-05>,
                         <-0.0510963, 0.464196, -3.86483>, <1.4228e-05, 3.66482e-05, -5.17072e-05>,
                         <-0.0547096, 0.465211, -3.86512>, <1.42226e-05, 3.66204e-05, -5.17366e-05> }
        smooth_triangle {<0.107011, 0.468364, -4.2557>, <-1.17431e-05, 5.31065e-05, 6.91862e-05>,
                         <0.0431993, 0.466305, -4.26495>, <-1.47153e-05, 7.36665e-05, 8.99241e-05>,
                         <0.0465409, 0.465329, -4.26364>, <-1.47741e-05, 7.34852e-05, 8.99391e-05> }
        smooth_triangle {<0.0465409, 0.465329, -4.26364>, <-1.10504e-05, 5.66602e-05, 6.66325e-05>,
                         <0.106986, 0.468418, -4.2556>, <-5.89442e-06, 2.94639e-05, 3.30259e-05>,
                         <0.107011, 0.468364, -4.2557>, <-5.81114e-06, 2.96458e-05, 3.29494e-05> }
        smooth_triangle {<0.0431993, 0.466305, -4.26495>, <-1.47153e-05, 7.36665e-05, 8.99241e-05>,
                         <-0.0207532, 0.464517, -4.27352>, <-2.25377e-05, 0.000139864, 0.000148121>,
                         <-0.0140843, 0.462647, -4.27084>, <-2.21617e-05, 0.000140323, 0.000147507> }
        smooth_triangle {<-0.0140843, 0.462647, -4.27084>, <-1.92625e-05, 0.000119181, 0.00012767>,
                         <0.0465409, 0.465329, -4.26364>, <-1.37218e-05, 6.90523e-05, 8.44939e-05>,
                         <0.0431993, 0.466305, -4.26495>, <-1.36776e-05, 6.91882e-05, 8.44827e-05> }
        smooth_triangle {<-0.0207532, 0.464517, -4.27352>, <-2.25377e-05, 0.000139864, 0.000148121>,
                         <-0.0848827, 0.463065, -4.28113>, <-2.67087e-05, 0.000219566, 0.000195096>,
                         <-0.0749184, 0.460468, -4.27697>, <-2.57052e-05, 0.000220675, 0.000193385> }
        smooth_triangle {<-0.0749184, 0.460468, -4.27697>, <-2.36083e-05, 0.00019608, 0.000177119>,
                         <-0.0140843, 0.462647, -4.27084>, <-2.09507e-05, 0.000135816, 0.00014271>,
                         <-0.0207532, 0.464517, -4.27352>, <-2.12327e-05, 0.000135472, 0.000143171> }
        smooth_triangle {<-0.0848827, 0.463065, -4.28113>, <-2.67087e-05, 0.000219566, 0.000195096>,
                         <-0.149185, 0.461853, -4.28764>, <-2.77677e-05, 0.000310004, 0.000234847>,
                         <-0.135938, 0.458651, -4.28198>, <-2.62798e-05, 0.000311159, 0.000232019> }
        smooth_triangle {<-0.135938, 0.458651, -4.28198>, <-2.48498e-05, 0.000284354, 0.000218153>,
                         <-0.0749184, 0.460468, -4.27697>, <-2.44188e-05, 0.000216492, 0.000189178>,
                         <-0.0848827, 0.463065, -4.28113>, <-2.51714e-05, 0.00021566, 0.000190461> }
        smooth_triangle {<-0.149185, 0.461853, -4.28764>, <-2.77677e-05, 0.000310004, 0.000234847>,
                         <-0.213672, 0.460796, -4.29273>, <-2.47932e-05, 0.000414904, 0.000269733>,
                         <-0.197142, 0.457064, -4.2856>, <-2.30437e-05, 0.000415227, 0.000265845> }
        smooth_triangle {<-0.197142, 0.457064, -4.2856>, <-2.24262e-05, 0.000386067, 0.000253639>,
                         <-0.135938, 0.458651, -4.28198>, <-2.48533e-05, 0.000308015, 0.00022827>,
                         <-0.149185, 0.461853, -4.28764>, <-2.59692e-05, 0.000307149, 0.000230391> }
        smooth_triangle {<-0.213672, 0.460796, -4.29273>, <-2.47932e-05, 0.000414904, 0.000269733>,
                         <-0.278381, 0.459875, -4.29555>, <-1.4466e-05, 0.00054804, 0.000299499>,
                         <-0.258564, 0.455683, -4.28704>, <-1.2677e-05, 0.000546053, 0.000294349> }
        smooth_triangle {<-0.258564, 0.455683, -4.28704>, <-1.33169e-05, 0.000513031, 0.000283765>,
                         <-0.197142, 0.457064, -4.2856>, <-2.10919e-05, 0.000414911, 0.000262387>,
                         <-0.213672, 0.460796, -4.29273>, <-2.2404e-05, 0.000414669, 0.000265303> }
        smooth_triangle {<-0.278381, 0.459875, -4.29555>, <-1.4466e-05, 0.00054804, 0.000299499>,
                         <-0.343275, 0.459103, -4.29441>, <1.27834e-05, 0.000751867, 0.000321058>,
                         <-0.320169, 0.454526, -4.28472>, <1.40678e-05, 0.000743774, 0.000314169> }
        smooth_triangle {<-0.320169, 0.454526, -4.28472>, <1.05217e-05, 0.000700267, 0.000305918>,
                         <-0.258564, 0.455683, -4.28704>, <-9.53685e-06, 0.000551977, 0.000291053>,
                         <-0.278381, 0.459875, -4.29555>, <-1.08786e-05, 0.000553467, 0.000294915> }
        smooth_triangle {<-0.343275, 0.459103, -4.29441>, <1.27834e-05, 0.000751867, 0.000321058>,
                         <-0.40759, 0.458542, -4.28403>, <7.85266e-05, 0.00111908, 0.000320684>,
                         <-0.381236, 0.453683, -4.27365>, <7.77756e-05, 0.00109572, 0.000311663> }
        smooth_triangle {<-0.381236, 0.453683, -4.27365>, <6.89681e-05, 0.00103364, 0.000308497>,
                         <-0.320169, 0.454526, -4.28472>, <2.11872e-05, 0.000769679, 0.000310376>,
                         <-0.343275, 0.459103, -4.29441>, <2.0224e-05, 0.000775749, 0.000315543> }
        smooth_triangle {<-0.40759, 0.458542, -4.28403>, <7.85266e-05, 0.00111908, 0.000320684>,
                         <-0.465714, 0.458254, -4.25408>, <0.000192014, 0.00165196, 0.000260323>,
                         <-0.436461, 0.453252, -4.24406>, <0.000186847, 0.00160297, 0.000250961> }
        smooth_triangle {<-0.436461, 0.453252, -4.24406>, <0.000174956, 0.0015406, 0.000258136>,
                         <-0.381236, 0.453683, -4.27365>, <9.31526e-05, 0.00116016, 0.000303663>,
                         <-0.40759, 0.458542, -4.28403>, <9.37159e-05, 0.00117768, 0.000310428> }
        smooth_triangle {<-0.465714, 0.458254, -4.25408>, <0.000192014, 0.00165196, 0.000260323>,
                         <-0.49995, 0.45823, -4.19841>, <0.000295719, 0.00198455, 0.000100683>,
                         <-0.469128, 0.453216, -4.19016>, <0.000286123, 0.00191813, 9.61645e-05> }
        smooth_triangle {<-0.469128, 0.453216, -4.19016>, <0.000281895, 0.00191462, 0.000113236>,
                         <-0.436461, 0.453252, -4.24406>, <0.000207438, 0.00167826, 0.000229333>,
                         <-0.465714, 0.458254, -4.25408>, <0.000211313, 0.001715, 0.000236356> }
        smooth_triangle {<-0.49995, 0.45823, -4.19841>, <0.000295719, 0.00198455, 0.000100683>,
                         <-0.490839, 0.45841, -4.13359>, <0.000302705, 0.0017199, -9.67947e-05>,
                         <-0.460855, 0.453485, -4.12764>, <0.000293111, 0.00166548, -9.34904e-05> }
        smooth_triangle {<-0.460855, 0.453485, -4.12764>, <0.000298765, 0.00171386, -8.25602e-05>,
                         <-0.469128, 0.453216, -4.19016>, <0.000293525, 0.00190335, 5.9681e-05>,
                         <-0.49995, 0.45823, -4.19841>, <0.000300721, 0.00195316, 6.30701e-05> }
        smooth_triangle {<-0.490839, 0.45841, -4.13359>, <0.000302705, 0.0017199, -9.67947e-05>,
                         <-0.453147, 0.458737, -4.07993>, <0.000240406, 0.00119814, -0.000205001>,
                         <-0.425587, 0.453976, -4.07565>, <0.00023405, 0.00116802, -0.000197585> }
        smooth_triangle {<-0.425587, 0.453976, -4.07565>, <0.000240262, 0.00121314, -0.000195285>,
                         <-0.460855, 0.453485, -4.12764>, <0.000284558, 0.00158623, -0.000117214>,
                         <-0.490839, 0.45841, -4.13359>, <0.000291754, 0.00162705, -0.000119692> }
        smooth_triangle {<-0.453147, 0.458737, -4.07993>, <0.000240406, 0.00119814, -0.000205001>,
                         <-0.40464, 0.459187, -4.0361>, <0.000189552, 0.000852567, -0.000235608>,
                         <-0.380102, 0.454652, -4.03297>, <0.000185584, 0.000836668, -0.000227554> }
        smooth_triangle {<-0.380102, 0.454652, -4.03297>, <0.000190713, 0.000872942, -0.000229454>,
                         <-0.425587, 0.453976, -4.07565>, <0.000227063, 0.00112145, -0.000206977>,
                         <-0.453147, 0.458737, -4.07993>, <0.000231829, 0.00114405, -0.000212539> }
        smooth_triangle {<-0.40464, 0.459187, -4.0361>, <0.000189552, 0.000852567, -0.000235608>,
                         <-0.351848, 0.459756, -3.99789>, <0.00015514, 0.00064005, -0.000236159>,
                         <-0.330568, 0.455505, -3.9956>, <0.000152526, 0.000630972, -0.000228718> }
        smooth_triangle {<-0.330568, 0.455505, -3.9956>, <0.00015744, 0.000663661, -0.000232938>,
                         <-0.380102, 0.454652, -4.03297>, <0.000182234, 0.000817933, -0.000232065>,
                         <-0.40464, 0.459187, -4.0361>, <0.00018521, 0.000829857, -0.000238106> }
        smooth_triangle {<-0.351848, 0.459756, -3.99789>, <0.00015514, 0.00064005, -0.000236159>,
                         <-0.296666, 0.460475, -3.96352>, <0.000125836, 0.000477048, -0.000223693>,
                         <-0.278769, 0.456583, -3.96188>, <0.000124155, 0.00047192, -0.000217502> }
        smooth_triangle {<-0.278769, 0.456583, -3.96188>, <0.000129564, 0.000503644, -0.000223918>,
                         <-0.330568, 0.455505, -3.9956>, <0.000150842, 0.000622933, -0.000232329>,
                         <-0.351848, 0.459756, -3.99789>, <0.000152803, 0.000629742, -0.00023791> }
        smooth_triangle {<-0.296666, 0.460475, -3.96352>, <0.000125836, 0.000477048, -0.000223693>,
                         <-0.239497, 0.461419, -3.93292>, <9.57355e-05, 0.000330461, -0.000200675>,
                         <-0.225083, 0.458, -3.93177>, <9.48394e-05, 0.000328188, -0.000196193> }
        smooth_triangle {<-0.225083, 0.458, -3.93177>, <0.000101002, 0.000358893, -0.000205715>,
                         <-0.278769, 0.456583, -3.96188>, <0.000122989, 0.000466692, -0.000221697>,
                         <-0.296666, 0.460475, -3.96352>, <0.000124249, 0.000470538, -0.00022634> }
        smooth_triangle {<-0.239497, 0.461419, -3.93292>, <9.57355e-05, 0.000330461, -0.000200675>,
                         <-0.180438, 0.462662, -3.9066>, <6.49185e-05, 0.000200625, -0.000164291>,
                         <-0.169592, 0.459865, -3.90579>, <6.46192e-05, 0.000200223, -0.000161685> }
        smooth_triangle {<-0.169592, 0.459865, -3.90579>, <7.12153e-05, 0.000227901, -0.00017542>,
                         <-0.225083, 0.458, -3.93177>, <9.38805e-05, 0.000323875, -0.000201301>,
                         <-0.239497, 0.461419, -3.93292>, <9.45525e-05, 0.00032558, -0.000204662> }
        smooth_triangle {<-0.180438, 0.462662, -3.9066>, <6.49185e-05, 0.000200625, -0.000164291>,
                         <-0.119865, 0.46428, -3.88443>, <3.66512e-05, 0.00010095, -0.000111747>,
                         <-0.112632, 0.462291, -3.88386>, <3.66272e-05, 0.000101129, -0.000110802> }
        smooth_triangle {<-0.112632, 0.462291, -3.88386>, <4.32989e-05, 0.000123706, -0.000129524>,
                         <-0.169592, 0.459865, -3.90579>, <6.42929e-05, 0.000198026, -0.000167686>,
                         <-0.180438, 0.462662, -3.9066>, <6.45174e-05, 0.000198328, -0.00016964> }
        smooth_triangle {<-0.119865, 0.46428, -3.88443>, <3.66512e-05, 0.00010095, -0.000111747>,
                         <-0.058323, 0.466227, -3.86542>, <1.29213e-05, 3.42231e-05, -4.53174e-05>,
                         <-0.0547096, 0.465211, -3.86512>, <1.29286e-05, 3.42602e-05, -4.52783e-05> }
        smooth_triangle {<-0.0547096, 0.465211, -3.86512>, <1.9425e-05, 5.14302e-05, -6.80414e-05>,
                         <-0.112632, 0.462291, -3.88386>, <3.7199e-05, 0.000101582, -0.000117184>,
                         <-0.119865, 0.46428, -3.88443>, <3.7217e-05, 0.000101447, -0.000117893> }
        smooth_triangle {<-0.058323, 0.466227, -3.86542>, <1.29213e-05, 3.42231e-05, -4.53174e-05>,
                         <0.0036994, 0.468364, -3.84819>, <-9.67914e-07, 1.89128e-06, 3.37812e-06>,
                         <0.00370642, 0.468418, -3.84822>, <-9.80356e-07, 1.78905e-06, 3.1791e-06> }
        smooth_triangle {<0.00370642, 0.468418, -3.84822>, <5.38541e-06, 1.57937e-05, -2.1518e-05>,
                         <-0.0547096, 0.465211, -3.86512>, <1.42257e-05, 3.66459e-05, -5.16868e-05>,
                         <-0.058323, 0.466227, -3.86542>, <1.42202e-05, 3.66181e-05, -5.17161e-05> }
        smooth_triangle {<0.107036, 0.468311, -4.2558>, <-1.15765e-05, 5.34704e-05, 6.90332e-05>,
                         <0.0398577, 0.467282, -4.26627>, <-1.46564e-05, 7.38477e-05, 8.99091e-05>,
                         <0.0431993, 0.466305, -4.26495>, <-1.47153e-05, 7.36665e-05, 8.99241e-05> }
        smooth_triangle {<0.0431993, 0.466305, -4.26495>, <-1.09646e-05, 5.68871e-05, 6.6583e-05>,
                         <0.107011, 0.468364, -4.2557>, <-5.72785e-06, 2.98277e-05, 3.28729e-05>,
                         <0.107036, 0.468311, -4.2558>, <-5.64456e-06, 3.00096e-05, 3.27965e-05> }
        smooth_triangle {<0.0398577, 0.467282, -4.26627>, <-1.46564e-05, 7.38477e-05, 8.99091e-05>,
                         <-0.027422, 0.466388, -4.2762>, <-2.29137e-05, 0.000139405, 0.000148736>,
                         <-0.0207532, 0.464517, -4.27352>, <-2.25377e-05, 0.000139864, 0.000148121> }
        smooth_triangle {<-0.0207532, 0.464517, -4.27352>, <-1.95836e-05, 0.00011879, 0.000128196>,
                         <0.0431993, 0.466305, -4.26495>, <-1.37168e-05, 6.91422e-05, 8.45479e-05>,
                         <0.0398577, 0.467282, -4.26627>, <-1.36726e-05, 6.92781e-05, 8.45367e-05> }
        smooth_triangle {<-0.027422, 0.466388, -4.2762>, <-2.29137e-05, 0.000139405, 0.000148736>,
                         <-0.0948471, 0.465662, -4.28529>, <-2.77122e-05, 0.000218456, 0.000196807>,
                         <-0.0848827, 0.463065, -4.28113>, <-2.67087e-05, 0.000219566, 0.000195096> }
        smooth_triangle {<-0.0848827, 0.463065, -4.28113>, <-2.45646e-05, 0.000194996, 0.000178733>,
                         <-0.0207532, 0.464517, -4.27352>, <-2.14364e-05, 0.00013522, 0.000143502>,
                         <-0.027422, 0.466388, -4.2762>, <-2.17184e-05, 0.000134875, 0.000143963> }
        smooth_triangle {<-0.0948471, 0.465662, -4.28529>, <-2.77122e-05, 0.000218456, 0.000196807>,
                         <-0.162433, 0.465056, -4.2933>, <-2.92557e-05, 0.00030885, 0.000237676>,
                         <-0.149185, 0.461853, -4.28764>, <-2.77677e-05, 0.000310004, 0.000234847> }
        smooth_triangle {<-0.149185, 0.461853, -4.28764>, <-2.63109e-05, 0.000283161, 0.000220897>,
                         <-0.0848827, 0.463065, -4.28113>, <-2.55166e-05, 0.000215332, 0.000191084>,
                         <-0.0948471, 0.465662, -4.28529>, <-2.62692e-05, 0.0002145, 0.000192367> }
        smooth_triangle {<-0.162433, 0.465056, -4.2933>, <-2.92557e-05, 0.00030885, 0.000237676>,
                         <-0.230202, 0.464527, -4.29986>, <-2.65427e-05, 0.000414581, 0.00027362>,
                         <-0.213672, 0.460796, -4.29273>, <-2.47932e-05, 0.000414904, 0.000269733> }
        smooth_triangle {<-0.213672, 0.460796, -4.29273>, <-2.4164e-05, 0.000385613, 0.000257431>,
                         <-0.149185, 0.461853, -4.28764>, <-2.63949e-05, 0.000306938, 0.000231267>,
                         <-0.162433, 0.465056, -4.2933>, <-2.75108e-05, 0.000306072, 0.000233389> }
        smooth_triangle {<-0.230202, 0.464527, -4.29986>, <-2.65427e-05, 0.000414581, 0.00027362>,
                         <-0.298197, 0.464067, -4.30405>, <-1.62549e-05, 0.000550027, 0.000304648>,
                         <-0.278381, 0.459875, -4.29555>, <-1.4466e-05, 0.00054804, 0.000299499> }
        smooth_triangle {<-0.278381, 0.459875, -4.29555>, <-1.51194e-05, 0.000514701, 0.00028879>,
                         <-0.213672, 0.460796, -4.29273>, <-2.28648e-05, 0.000414849, 0.000266466>,
                         <-0.230202, 0.464527, -4.29986>, <-2.4177e-05, 0.000414607, 0.000269382> }
        smooth_triangle {<-0.298197, 0.464067, -4.30405>, <-1.62549e-05, 0.000550027, 0.000304648>,
                         <-0.36638, 0.463681, -4.30409>, <1.14991e-05, 0.000759961, 0.000327947>,
                         <-0.343275, 0.459103, -4.29441>, <1.27834e-05, 0.000751867, 0.000321058> }
        smooth_triangle {<-0.343275, 0.459103, -4.29441>, <9.13852e-06, 0.000707466, 0.00031262>,
                         <-0.278381, 0.459875, -4.29555>, <-1.12985e-05, 0.000554596, 0.000296451>,
                         <-0.298197, 0.464067, -4.30405>, <-1.26402e-05, 0.000556086, 0.000300313> }
        smooth_triangle {<-0.36638, 0.463681, -4.30409>, <1.14991e-05, 0.000759961, 0.000327947>,
                         <-0.433945, 0.4634, -4.29442>, <7.92776e-05, 0.00114244, 0.000329705>,
                         <-0.40759, 0.458542, -4.28403>, <7.85266e-05, 0.00111908, 0.000320684> }
        smooth_triangle {<-0.40759, 0.458542, -4.28403>, <6.9408e-05, 0.00105497, 0.000317358>,
                         <-0.343275, 0.459103, -4.29441>, <2.01006e-05, 0.000779561, 0.000317638>,
                         <-0.36638, 0.463681, -4.30409>, <1.91374e-05, 0.000785631, 0.000322805> }
        smooth_triangle {<-0.433945, 0.4634, -4.29442>, <7.92776e-05, 0.00114244, 0.000329705>,
                         <-0.494967, 0.463256, -4.26411>, <0.00019718, 0.00170095, 0.000269686>,
                         <-0.465714, 0.458254, -4.25408>, <0.000192014, 0.00165196, 0.000260323> }
        smooth_triangle {<-0.465714, 0.458254, -4.25408>, <0.000179641, 0.00158724, 0.000267731>,
                         <-0.40759, 0.458542, -4.28403>, <9.45258e-05, 0.00118758, 0.000313002>,
                         <-0.433945, 0.4634, -4.29442>, <9.50891e-05, 0.0012051, 0.000319768> }
        smooth_triangle {<-0.494967, 0.463256, -4.26411>, <0.00019718, 0.00170095, 0.000269686>,
                         <-0.530772, 0.463244, -4.20666>, <0.000305314, 0.00205097, 0.000105202>,
                         <-0.49995, 0.45823, -4.19841>, <0.000295719, 0.00198455, 0.000100683> }
        smooth_triangle {<-0.49995, 0.45823, -4.19841>, <0.000291347, 0.00198139, 0.0001185>,
                         <-0.465714, 0.458254, -4.25408>, <0.000213568, 0.00173194, 0.00023823>,
                         <-0.494967, 0.463256, -4.26411>, <0.000217443, 0.00176868, 0.000245252> }
        smooth_triangle {<-0.530772, 0.463244, -4.20666>, <0.000305314, 0.00205097, 0.000105202>,
                         <-0.520822, 0.463334, -4.13955>, <0.0003123, 0.00177433, -0.000100099>,
                         <-0.490839, 0.45841, -4.13359>, <0.000302705, 0.0017199, -9.67947e-05> }
        smooth_triangle {<-0.490839, 0.45841, -4.13359>, <0.000308648, 0.0017706, -8.53986e-05>,
                         <-0.49995, 0.45823, -4.19841>, <0.000303408, 0.00196908, 6.27099e-05>,
                         <-0.530772, 0.463244, -4.20666>, <0.000310605, 0.0020189, 6.60991e-05> }
        smooth_triangle {<-0.520822, 0.463334, -4.13955>, <0.0003123, 0.00177433, -0.000100099>,
                         <-0.480706, 0.463498, -4.08421>, <0.000246761, 0.00122827, -0.000212416>,
                         <-0.453147, 0.458737, -4.07993>, <0.000240406, 0.00119814, -0.000205001> }
        smooth_triangle {<-0.453147, 0.458737, -4.07993>, <0.000246852, 0.00124471, -0.000202605>,
                         <-0.490839, 0.45841, -4.13359>, <0.000293577, 0.00163602, -0.00012145>,
                         <-0.520822, 0.463334, -4.13955>, <0.000300773, 0.00167684, -0.000123929> }
        smooth_triangle {<-0.480706, 0.463498, -4.08421>, <0.000246761, 0.00122827, -0.000212416>,
                         <-0.429177, 0.463723, -4.03924>, <0.00019352, 0.000868465, -0.000243662>,
                         <-0.40464, 0.459187, -4.0361>, <0.000189552, 0.000852567, -0.000235608> }
        smooth_triangle {<-0.40464, 0.459187, -4.0361>, <0.000194809, 0.000889511, -0.00023754>,
                         <-0.453147, 0.458737, -4.07993>, <0.000232949, 0.00114869, -0.000214585>,
                         <-0.480706, 0.463498, -4.08421>, <0.000237716, 0.00117129, -0.000220146> }
        smooth_triangle {<-0.429177, 0.463723, -4.03924>, <0.00019352, 0.000868465, -0.000243662>,
                         <-0.373129, 0.464007, -4.00017>, <0.000157754, 0.000649128, -0.000243601>,
                         <-0.351848, 0.459756, -3.99789>, <0.00015514, 0.00064005, -0.000236159> }
        smooth_triangle {<-0.351848, 0.459756, -3.99789>, <0.000160136, 0.000673103, -0.000240468>,
                         <-0.40464, 0.459187, -4.0361>, <0.000185945, 0.00083249, -0.000240054>,
                         <-0.429177, 0.463723, -4.03924>, <0.000188921, 0.000844414, -0.000246095> }
        smooth_triangle {<-0.373129, 0.464007, -4.00017>, <0.000157754, 0.000649128, -0.000243601>,
                         <-0.314562, 0.464367, -3.96515>, <0.000127517, 0.000482176, -0.000229884>,
                         <-0.296666, 0.460475, -3.96352>, <0.000125836, 0.000477048, -0.000223693> }
        smooth_triangle {<-0.296666, 0.460475, -3.96352>, <0.000131314, 0.000509032, -0.000230244>,
                         <-0.351848, 0.459756, -3.99789>, <0.000153292, 0.000631283, -0.000239594>,
                         <-0.373129, 0.464007, -4.00017>, <0.000155253, 0.000638091, -0.000245175> }
        smooth_triangle {<-0.314562, 0.464367, -3.96515>, <0.000127517, 0.000482176, -0.000229884>,
                         <-0.25391, 0.464839, -3.93407>, <9.66315e-05, 0.000332735, -0.000205157>,
                         <-0.239497, 0.461419, -3.93292>, <9.57355e-05, 0.000330461, -0.000200675> }
        smooth_triangle {<-0.239497, 0.461419, -3.93292>, <0.000101957, 0.000361361, -0.000210353>,
                         <-0.296666, 0.460475, -3.96352>, <0.000124532, 0.000471301, -0.000227616>,
                         <-0.314562, 0.464367, -3.96515>, <0.000125793, 0.000475148, -0.000232259> }
        smooth_triangle {<-0.25391, 0.464839, -3.93407>, <9.66315e-05, 0.000332735, -0.000205157>,
                         <-0.191284, 0.46546, -3.90741>, <6.52178e-05, 0.000201027, -0.000166896>,
                         <-0.180438, 0.462662, -3.9066>, <6.49185e-05, 0.000200625, -0.000164291> }
        smooth_triangle {<-0.180438, 0.462662, -3.9066>, <7.15464e-05, 0.000228381, -0.000178184>,
                         <-0.239497, 0.461419, -3.93292>, <9.46591e-05, 0.000325758, -0.000205472>,
                         <-0.25391, 0.464839, -3.93407>, <9.53311e-05, 0.000327463, -0.000208834> }
        smooth_triangle {<-0.191284, 0.46546, -3.90741>, <6.52178e-05, 0.000201027, -0.000166896>,
                         <-0.127097, 0.466269, -3.88499>, <3.66752e-05, 0.00010077, -0.000112691>,
                         <-0.119865, 0.46428, -3.88443>, <3.66512e-05, 0.00010095, -0.000111747> }
        smooth_triangle {<-0.119865, 0.46428, -3.88443>, <4.3328e-05, 0.000123517, -0.000130567>,
                         <-0.180438, 0.462662, -3.9066>, <6.45285e-05, 0.000198274, -0.000169974>,
                         <-0.191284, 0.46546, -3.90741>, <6.4753e-05, 0.000198576, -0.000171929> }
        smooth_triangle {<-0.127097, 0.466269, -3.88499>, <3.66752e-05, 0.00010077, -0.000112691>,
                         <-0.0619363, 0.467243, -3.86572>, <1.29141e-05, 3.41861e-05, -4.53565e-05>,
                         <-0.058323, 0.466227, -3.86542>, <1.29213e-05, 3.42231e-05, -4.53174e-05> }
        smooth_triangle {<-0.058323, 0.466227, -3.86542>, <1.94153e-05, 5.13757e-05, -6.81103e-05>,
                         <-0.119865, 0.46428, -3.88443>, <3.72127e-05, 0.00010142, -0.000117932>,
                         <-0.127097, 0.466269, -3.88499>, <3.72307e-05, 0.000101285, -0.000118641> }
        smooth_triangle {<-0.0619363, 0.467243, -3.86572>, <1.29141e-05, 3.41861e-05, -4.53565e-05>,
                         <0.00369237, 0.468311, -3.84816>, <-9.55473e-07, 1.99352e-06, 3.57714e-06>,
                         <0.0036994, 0.468364, -3.84819>, <-9.67914e-07, 1.89128e-06, 3.37812e-06> }
        smooth_triangle {<0.0036994, 0.468364, -3.84819>, <5.39785e-06, 1.58959e-05, -2.1319e-05>,
                         <-0.058323, 0.466227, -3.86542>, <1.42234e-05, 3.66437e-05, -5.16664e-05>,
                         <-0.0619363, 0.467243, -3.86572>, <1.42179e-05, 3.66159e-05, -5.16957e-05> }
        smooth_triangle {<0.107061, 0.468258, -4.2559>, <-1.141e-05, 5.38342e-05, 6.88803e-05>,
                         <0.0365162, 0.468258, -4.26759>, <-1.62746e-05, 8.39444e-05, 0.000100477>,
                         <0.0398577, 0.467282, -4.26627>, <-1.46564e-05, 7.38477e-05, 8.99091e-05> }
        smooth_triangle {<0.0398577, 0.467282, -4.26627>, <-1.08788e-05, 5.7114e-05, 6.65335e-05>,
                         <0.107036, 0.468311, -4.2558>, <-5.56127e-06, 3.01915e-05, 3.272e-05>,
                         <0.107061, 0.468258, -4.2559>, <-5.47799e-06, 3.03735e-05, 3.26435e-05> }
        smooth_triangle {<0.0365162, 0.468258, -4.26759>, <-1.62746e-05, 8.39444e-05, 0.000100477>,
                         <-0.0340909, 0.468258, -4.27889>, <-2.42867e-05, 0.000151483, 0.000157858>,
                         <-0.027422, 0.466388, -4.2762>, <-2.29137e-05, 0.000139405, 0.000148736> }
        smooth_triangle {<-0.027422, 0.466388, -4.2762>, <-1.99048e-05, 0.0001184, 0.000128722>,
                         <0.0398577, 0.467282, -4.26627>, <-1.37118e-05, 6.92322e-05, 8.46019e-05>,
                         <0.0365162, 0.468258, -4.26759>, <-1.44757e-05, 7.44248e-05, 8.98784e-05> }
        smooth_triangle {<-0.0340909, 0.468258, -4.27889>, <-2.42867e-05, 0.000151483, 0.000157858>,
                         <-0.104811, 0.468258, -4.28945>, <-2.8949e-05, 0.00023207, 0.000205297>,
                         <-0.0948471, 0.465662, -4.28529>, <-2.77122e-05, 0.000218456, 0.000196807> }
        smooth_triangle {<-0.0948471, 0.465662, -4.28529>, <-2.5521e-05, 0.000193912, 0.000180347>,
                         <-0.027422, 0.466388, -4.2762>, <-2.19222e-05, 0.000134623, 0.000144293>,
                         <-0.0340909, 0.468258, -4.27889>, <-2.25069e-05, 0.000141081, 0.000148893> }
        smooth_triangle {<-0.104811, 0.468258, -4.28945>, <-2.8949e-05, 0.00023207, 0.000205297>,
                         <-0.175681, 0.468258, -4.29897>, <-3.01932e-05, 0.000324583, 0.000246035>,
                         <-0.162433, 0.465056, -4.2933>, <-2.92557e-05, 0.00030885, 0.000237676> }
        smooth_triangle {<-0.162433, 0.465056, -4.2933>, <-2.77721e-05, 0.000281968, 0.000223641>,
                         <-0.0948471, 0.465662, -4.28529>, <-2.66144e-05, 0.000214173, 0.00019299>,
                         <-0.104811, 0.468258, -4.28945>, <-2.7073e-05, 0.000221821, 0.000197377> }
        smooth_triangle {<-0.175681, 0.468258, -4.29897>, <-3.01932e-05, 0.000324583, 0.000246035>,
                         <-0.246732, 0.468258, -4.30698>, <-2.66257e-05, 0.000434842, 0.000281951>,
                         <-0.230202, 0.464527, -4.29986>, <-2.65427e-05, 0.000414581, 0.00027362> }
        smooth_triangle {<-0.230202, 0.464527, -4.29986>, <-2.59017e-05, 0.000385159, 0.000261223>,
                         <-0.162433, 0.465056, -4.2933>, <-2.79364e-05, 0.00030586, 0.000234265>,
                         <-0.175681, 0.468258, -4.29897>, <-2.81217e-05, 0.000315353, 0.000238701> }
        smooth_triangle {<-0.246732, 0.468258, -4.30698>, <-2.66257e-05, 0.000434842, 0.000281951>,
                         <-0.318013, 0.468258, -4.31255>, <-1.44796e-05, 0.000579786, 0.000312976>,
                         <-0.298197, 0.464067, -4.30405>, <-1.62549e-05, 0.000550027, 0.000304648> }
        smooth_triangle {<-0.298197, 0.464067, -4.30405>, <-1.6922e-05, 0.000516372, 0.000293815>,
                         <-0.230202, 0.464527, -4.29986>, <-2.46378e-05, 0.000414788, 0.000270545>,
                         <-0.246732, 0.468258, -4.30698>, <-2.40582e-05, 0.000428364, 0.000275074> }
        smooth_triangle {<-0.318013, 0.468258, -4.31255>, <-1.44796e-05, 0.000579786, 0.000312976>,
                         <-0.389486, 0.468258, -4.31378>, <1.89772e-05, 0.00081791, 0.0003356>,
                         <-0.36638, 0.463681, -4.30409>, <1.14991e-05, 0.000759961, 0.000327947> }
        smooth_triangle {<-0.36638, 0.463681, -4.30409>, <7.7553e-06, 0.000714665, 0.000319322>,
                         <-0.298197, 0.464067, -4.30405>, <-1.30602e-05, 0.000557215, 0.000301848>,
                         <-0.318013, 0.468258, -4.31255>, <-1.08117e-05, 0.00057945, 0.000306467> }
        smooth_triangle {<-0.389486, 0.468258, -4.31378>, <1.89772e-05, 0.00081791, 0.0003356>,
                         <-0.460299, 0.468258, -4.30481>, <9.84972e-05, 0.00125508, 0.000331881>,
                         <-0.433945, 0.4634, -4.29442>, <7.92776e-05, 0.00114244, 0.000329705> }
        smooth_triangle {<-0.433945, 0.4634, -4.29442>, <6.98479e-05, 0.0010763, 0.00032622>,
                         <-0.36638, 0.463681, -4.30409>, <1.9014e-05, 0.000789443, 0.000324901>,
                         <-0.389486, 0.468258, -4.31378>, <2.65044e-05, 0.000837904, 0.000328988> }
        smooth_triangle {<-0.460299, 0.468258, -4.30481>, <9.84972e-05, 0.00125508, 0.000331881>,
                         <-0.52422, 0.468258, -4.27414>, <0.000225196, 0.00183603, 0.000253562>,
                         <-0.494967, 0.463256, -4.26411>, <0.00019718, 0.00170095, 0.000269686> }
        smooth_triangle {<-0.494967, 0.463256, -4.26411>, <0.000184326, 0.00163388, 0.000277327>,
                         <-0.433945, 0.4634, -4.29442>, <9.5899e-05, 0.00121499, 0.000322341>,
                         <-0.460299, 0.468258, -4.30481>, <0.000114253, 0.00131427, 0.000321337> }
        smooth_triangle {<-0.52422, 0.468258, -4.27414>, <0.000225196, 0.00183603, 0.000253562>,
                         <-0.561594, 0.468258, -4.21491>, <0.000319364, 0.00207524, 6.7135e-05>,
                         <-0.530772, 0.463244, -4.20666>, <0.000305314, 0.00205097, 0.000105202> }
        smooth_triangle {<-0.530772, 0.463244, -4.20666>, <0.000300799, 0.00204815, 0.000123764>,
                         <-0.494967, 0.463256, -4.26411>, <0.000219698, 0.00178563, 0.000247127>,
                         <-0.52422, 0.468258, -4.27414>, <0.000245882, 0.00190391, 0.000228857> }
        smooth_triangle {<-0.561594, 0.468258, -4.21491>, <0.000319364, 0.00207524, 6.7135e-05>,
                         <-0.550806, 0.468258, -4.14551>, <0.000306597, 0.00170299, -0.000127823>,
                         <-0.520822, 0.463334, -4.13955>, <0.0003123, 0.00177433, -0.000100099> }
        smooth_triangle {<-0.520822, 0.463334, -4.13955>, <0.000318531, 0.00182734, -8.8237e-05>,
                         <-0.530772, 0.463244, -4.20666>, <0.000313291, 0.00203482, 6.57389e-05>,
                         <-0.561594, 0.468258, -4.21491>, <0.000325316, 0.00204562, 2.72064e-05> }
        smooth_triangle {<-0.550806, 0.468258, -4.14551>, <0.000306597, 0.00170299, -0.000127823>,
                         <-0.508266, 0.468258, -4.08849>, <0.000240304, 0.00117495, -0.000224972>,
                         <-0.480706, 0.463498, -4.08421>, <0.000246761, 0.00122827, -0.000212416> }
        smooth_triangle {<-0.480706, 0.463498, -4.08421>, <0.000253442, 0.00127627, -0.000209925>,
                         <-0.520822, 0.463334, -4.13955>, <0.000302596, 0.00168582, -0.000125687>,
                         <-0.550806, 0.468258, -4.14551>, <0.000295559, 0.00160876, -0.000152698> }
        smooth_triangle {<-0.508266, 0.468258, -4.08849>, <0.000240304, 0.00117495, -0.000224972>,
                         <-0.453714, 0.468258, -4.04237>, <0.000189412, 0.000837001, -0.000249771>,
                         <-0.429177, 0.463723, -4.03924>, <0.00019352, 0.000868465, -0.000243662> }
        smooth_triangle {<-0.429177, 0.463723, -4.03924>, <0.000198905, 0.00090608, -0.000245627>,
                         <-0.480706, 0.463498, -4.08421>, <0.000238836, 0.00117593, -0.000222192>,
                         <-0.508266, 0.468258, -4.08849>, <0.00023189, 0.00112294, -0.000233821> }
        smooth_triangle {<-0.453714, 0.468258, -4.04237>, <0.000189412, 0.000837001, -0.000249771>,
                         <-0.394409, 0.468258, -4.00246>, <0.000154249, 0.000625295, -0.000246606>,
                         <-0.373129, 0.464007, -4.00017>, <0.000157754, 0.000649128, -0.000243601> }
        smooth_triangle {<-0.373129, 0.464007, -4.00017>, <0.000162833, 0.000682545, -0.000247997>,
                         <-0.429177, 0.463723, -4.03924>, <0.000189657, 0.000847048, -0.000248044>,
                         <-0.453714, 0.468258, -4.04237>, <0.000185631, 0.000818933, -0.000253577> }
        smooth_triangle {<-0.394409, 0.468258, -4.00246>, <0.000154249, 0.000625295, -0.000246606>,
                         <-0.332459, 0.468258, -3.96679>, <0.000123402, 0.000459327, -0.000230198>,
                         <-0.314562, 0.464367, -3.96515>, <0.000127517, 0.000482176, -0.000229884> }
        smooth_triangle {<-0.314562, 0.464367, -3.96515>, <0.000133064, 0.000514419, -0.000236571>,
                         <-0.373129, 0.464007, -4.00017>, <0.000155742, 0.000639633, -0.000246859>,
                         <-0.394409, 0.468258, -4.00246>, <0.000152734, 0.000620579, -0.000249948> }
        smooth_triangle {<-0.332459, 0.468258, -3.96679>, <0.000123402, 0.000459327, -0.000230198>,
                         <-0.268324, 0.468258, -3.93521>, <9.17404e-05, 0.000310207, -0.000202254>,
                         <-0.25391, 0.464839, -3.93407>, <9.66315e-05, 0.000332735, -0.000205157> }
        smooth_triangle {<-0.25391, 0.464839, -3.93407>, <0.000102912, 0.00036383, -0.00021499>,
                         <-0.314562, 0.464367, -3.96515>, <0.000126076, 0.000475911, -0.000233535>,
                         <-0.332459, 0.468258, -3.96679>, <0.000122852, 0.000458589, -0.000234962> }
        smooth_triangle {<-0.268324, 0.468258, -3.93521>, <9.17404e-05, 0.000310207, -0.000202254>,
                         <-0.20213, 0.468258, -3.90823>, <6.03073e-05, 0.000182361, -0.000160031>,
                         <-0.191284, 0.46546, -3.90741>, <6.52178e-05, 0.000201027, -0.000166896> }
        smooth_triangle {<-0.191284, 0.46546, -3.90741>, <7.18776e-05, 0.00022886, -0.000180949>,
                         <-0.25391, 0.464839, -3.93407>, <9.54378e-05, 0.000327641, -0.000209644>,
                         <-0.268324, 0.468258, -3.93521>, <9.17792e-05, 0.000310924, -0.000209205> }
        smooth_triangle {<-0.20213, 0.468258, -3.90823>, <6.03073e-05, 0.000182361, -0.000160031>,
                         <-0.134329, 0.468258, -3.88555>, <3.24741e-05, 8.806e-05, -0.000102356>,
                         <-0.127097, 0.466269, -3.88499>, <3.66752e-05, 0.00010077, -0.000112691> }
        smooth_triangle {<-0.127097, 0.466269, -3.88499>, <4.33571e-05, 0.000123328, -0.00013161>,
                         <-0.191284, 0.46546, -3.90741>, <6.47641e-05, 0.000198521, -0.000172263>,
                         <-0.20213, 0.468258, -3.90823>, <6.13392e-05, 0.000185242, -0.000169476> }
        smooth_triangle {<-0.134329, 0.468258, -3.88555>, <3.24741e-05, 8.806e-05, -0.000102356>,
                         <-0.0655497, 0.468258, -3.86601>, <9.44713e-06, 2.61496e-05, -3.3088e-05>,
                         <-0.0619363, 0.467243, -3.86572>, <1.29141e-05, 3.41861e-05, -4.53565e-05> }
        smooth_triangle {<-0.0619363, 0.467243, -3.86572>, <1.94056e-05, 5.13212e-05, -6.81791e-05>,
                         <-0.127097, 0.466269, -3.88499>, <3.72264e-05, 0.000101259, -0.00011868>,
                         <-0.134329, 0.468258, -3.88555>, <3.46095e-05, 9.29488e-05, -0.000113786> }
        smooth_triangle {<-0.0655497, 0.468258, -3.86601>, <9.44713e-06, 2.61496e-05, -3.3088e-05>,
                         <0.00368534, 0.468258, -3.84814>, <-9.49252e-07, 2.04463e-06, 3.67665e-06>,
                         <0.00369237, 0.468311, -3.84816>, <-9.55473e-07, 1.99352e-06, 3.57714e-06> }
        smooth_triangle {<0.00369237, 0.468311, -3.84816>, <5.41029e-06, 1.59982e-05, -2.112e-05>,
                         <-0.0619363, 0.467243, -3.86572>, <1.4221e-05, 3.66414e-05, -5.16459e-05>,
                         <-0.0655497, 0.468258, -3.86601>, <1.23454e-05, 3.21022e-05, -4.55634e-05> }
        texture { Semi_smooth_steel }
    }
    merge { // Poly_Pipe
        cone { <0.0325255, 0.368942, -4.05848>, 0.02, <0.0330062, 0.392552, -4.05836>, 0.02 }
        sphere { <0.0330062, 0.392552, -4.05836>, 0.02 }
        cone { <0.0330062, 0.392552, -4.05836>, 0.02, <0.033751, 0.416154, -4.05817>, 0.02 }
        sphere { <0.033751, 0.416154, -4.05817>, 0.02 }
        cone { <0.033751, 0.416154, -4.05817>, 0.02, <0.0350024, 0.439732, -4.05786>, 0.02 }
        sphere { <0.0350024, 0.439732, -4.05786>, 0.02 }
        cone { <0.0350024, 0.439732, -4.05786>, 0.02, <0.0369783, 0.463257, -4.05736>, 0.02 }
        sphere { <0.0369783, 0.463257, -4.05736>, 0.02 }
        cone { <0.0369783, 0.463257, -4.05736>, 0.02, <0.0398015, 0.48669, -4.05664>, 0.02 }
        sphere { <0.0398015, 0.48669, -4.05664>, 0.02 }
        cone { <0.0398015, 0.48669, -4.05664>, 0.02, <0.043602, 0.509975, -4.05568>, 0.02 }
        sphere { <0.043602, 0.509975, -4.05568>, 0.02 }
        cone { <0.043602, 0.509975, -4.05568>, 0.02, <0.0487071, 0.532989, -4.05438>, 0.02 }
        sphere { <0.0487071, 0.532989, -4.05438>, 0.02 }
        cone { <0.0487071, 0.532989, -4.05438>, 0.02, <0.0564263, 0.555175, -4.05243>, 0.02 }
        sphere { <0.0564263, 0.555175, -4.05243>, 0.02 }
        cone { <0.0564263, 0.555175, -4.05243>, 0.02, <0.0706392, 0.573391, -4.04882>, 0.02 }
        sphere { <0.0706392, 0.573391, -4.04882>, 0.02 }
        cone { <0.0706392, 0.573391, -4.04882>, 0.02, <0.0908987, 0.584123, -4.04369>, 0.02 }
        sphere { <0.0908987, 0.584123, -4.04369>, 0.02 }
        cone { <0.0908987, 0.584123, -4.04369>, 0.02, <0.112992, 0.590221, -4.03809>, 0.02 }
        sphere { <0.112992, 0.590221, -4.03809>, 0.02 }
        cone { <0.112992, 0.590221, -4.03809>, 0.02, <0.135603, 0.593857, -4.03235>, 0.02 }
        sphere { <0.135603, 0.593857, -4.03235>, 0.02 }
        cone { <0.135603, 0.593857, -4.03235>, 0.02, <0.158405, 0.595876, -4.02657>, 0.02 }
        sphere { <0.158405, 0.595876, -4.02657>, 0.02 }
        cone { <0.158405, 0.595876, -4.02657>, 0.02, <0.181283, 0.596581, -4.02077>, 0.02 }
        sphere { <0.181283, 0.596581, -4.02077>, 0.02 }
        cone { <0.181283, 0.596581, -4.02077>, 0.02, <0.204169, 0.596215, -4.01497>, 0.02 }
        sphere { <0.204169, 0.596215, -4.01497>, 0.02 }
        cone { <0.204169, 0.596215, -4.01497>, 0.02, <0.227043, 0.595299, -4.00917>, 0.02 }
        texture { Semi_smooth_steel }
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 0.25, 0.0>, 0.05  
        texture { DMFWood4 }
        rotate <269.427, .0, .0>
        rotate <.0, 255.774, .0>
        translate <0.204186, 0.593876, -4.01662>
    }
    sphere { <0.0, 0.0, 0.0>, 0.05 
        texture { DMFWood4 }
        scale <1, 1, 0.5>
        rotate <.0, 255.774, .0>
        translate <0.203961, 0.594061, -4.01668>
    }
    sphere { <0.0, 0.0, 0.0>, 0.05 
        texture { DMFWood4 }
        scale <1, 1, 0.5>
        rotate <.0, 255.774, .0>
        translate <0.446877, 0.59204, -3.9551>
    }
}

union {  // Layer name: trowellA
    union { // Poly_Mesh
        smooth_triangle {<0.409593, 0.977213, -1.63494>, <6.2352e-05, 4.69215e-05, 3.84437e-05>,
                         <0.418071, 0.957653, -1.62481>, <7.92221e-05, 7.05856e-05, 4.58595e-05>,
                         <0.420459, 0.956676, -1.6275>, <6.2352e-05, 4.69215e-05, 3.84437e-05> }
        smooth_triangle {<0.420459, 0.956676, -1.6275>, <3.03859e-05, 2.34607e-05, 2.03756e-05>,
                         <0.409677, 0.977266, -1.63488>, <-1.58026e-06, -1.71538e-18, 2.30745e-06>,
                         <0.409593, 0.977213, -1.63494>, <3.03859e-05, 2.34607e-05, 2.03756e-05> }
        smooth_triangle {<0.418071, 0.957653, -1.62481>, <7.92221e-05, 7.05856e-05, 4.58595e-05>,
                         <0.429277, 0.940664, -1.61282>, <0.000123653, 0.00014767, 6.26467e-05>,
                         <0.434095, 0.938793, -1.61816>, <0.000113048, 0.00011755, 6.09001e-05> }
        smooth_triangle {<0.434095, 0.938793, -1.61816>, <8.50667e-05, 8.82156e-05, 4.515e-05>,
                         <0.420459, 0.956676, -1.6275>, <5.97186e-05, 5.29013e-05, 3.39219e-05>,
                         <0.418071, 0.957653, -1.62481>, <7.36879e-05, 6.76595e-05, 4.17446e-05> }
        smooth_triangle {<0.429277, 0.940664, -1.61282>, <0.000123653, 0.00014767, 6.26467e-05>,
                         <0.442906, 0.926867, -1.59918>, <0.000152486, 0.000238425, 6.63223e-05>,
                         <0.450248, 0.92427, -1.6071>, <0.000144673, 0.000208092, 6.5903e-05> }
        smooth_triangle {<0.450248, 0.92427, -1.6071>, <0.000121416, 0.000173775, 5.28346e-05>,
                         <0.434095, 0.938793, -1.61816>, <0.000105603, 0.000128504, 5.03332e-05>,
                         <0.429277, 0.940664, -1.61282>, <0.00011728, 0.000145617, 5.69266e-05> }
        smooth_triangle {<0.442906, 0.926867, -1.59918>, <0.000152486, 0.000238425, 6.63223e-05>,
                         <0.457836, 0.915358, -1.58465>, <0.000174446, 0.000329633, 6.67469e-05>,
                         <0.46772, 0.912156, -1.59513>, <0.000167154, 0.0003001, 6.59399e-05> }
        smooth_triangle {<0.46772, 0.912156, -1.59513>, <0.000147071, 0.000263147, 5.47543e-05>,
                         <0.450248, 0.92427, -1.6071>, <0.000135831, 0.000217143, 5.47359e-05>,
                         <0.442906, 0.926867, -1.59918>, <0.000146112, 0.000235367, 6.06339e-05> }
        smooth_triangle {<0.457836, 0.915358, -1.58465>, <0.000174446, 0.000329633, 6.67469e-05>,
                         <0.473469, 0.905309, -1.56965>, <0.000192848, 0.000420395, 6.56041e-05>,
                         <0.485863, 0.901578, -1.58271>, <0.000187171, 0.000390007, 6.6206e-05> }
        smooth_triangle {<0.485863, 0.901578, -1.58271>, <0.000168915, 0.000351485, 5.63303e-05>,
                         <0.46772, 0.912156, -1.59513>, <0.000158906, 0.000306532, 5.61973e-05>,
                         <0.457836, 0.915358, -1.58465>, <0.0001685, 0.000325465, 6.16738e-05> }
        smooth_triangle {<0.473469, 0.905309, -1.56965>, <0.000192848, 0.000420395, 6.56041e-05>,
                         <0.489691, 0.896563, -1.55427>, <0.000204453, 0.000514264, 5.8152e-05>,
                         <0.504507, 0.892371, -1.56994>, <0.0002015, 0.000482018, 6.1593e-05> }
        smooth_triangle {<0.504507, 0.892371, -1.56994>, <0.000184676, 0.000441848, 5.30631e-05>,
                         <0.485863, 0.901578, -1.58271>, <0.000177512, 0.000395843, 5.53696e-05>,
                         <0.473469, 0.905309, -1.56965>, <0.000186599, 0.000415716, 6.03364e-05> }
        smooth_triangle {<0.489691, 0.896563, -1.55427>, <0.000204453, 0.000514264, 5.8152e-05>,
                         <0.506544, 0.889232, -1.53851>, <0.00020337, 0.000614284, 3.78614e-05>,
                         <0.523605, 0.884654, -1.55686>, <0.000206628, 0.000578035, 4.79344e-05> }
        smooth_triangle {<0.523605, 0.884654, -1.55686>, <0.000191175, 0.000535511, 4.11075e-05>,
                         <0.504507, 0.892371, -1.56994>, <0.000188611, 0.000487502, 4.79368e-05>,
                         <0.489691, 0.896563, -1.55427>, <0.00019727, 0.000508945, 5.21841e-05> }
        smooth_triangle {<0.506544, 0.889232, -1.53851>, <0.00020337, 0.000614284, 3.78614e-05>,
                         <0.52435, 0.883896, -1.52229>, <0.000179743, 0.000721938, -4.00064e-06>,
                         <0.543191, 0.879038, -1.54344>, <0.000191669, 0.000682268, 1.40202e-05> }
        smooth_triangle {<0.543191, 0.879038, -1.54344>, <0.000178052, 0.000635216, 1.00951e-05>,
                         <0.523605, 0.884654, -1.55686>, <0.000185532, 0.0005831, 2.70522e-05>,
                         <0.506544, 0.889232, -1.53851>, <0.000193636, 0.000607754, 2.99386e-05> }
        smooth_triangle {<0.52435, 0.883896, -1.52229>, <0.000179743, 0.000721938, -4.00064e-06>,
                         <0.54367, 0.881167, -1.50576>, <0.000130885, 0.000819195, -6.289e-05>,
                         <0.563173, 0.876165, -1.52976>, <0.000148192, 0.000786029, -4.33976e-05> }
        smooth_triangle {<0.563173, 0.876165, -1.52976>, <0.000137732, 0.000733284, -4.31688e-05>,
                         <0.543191, 0.879038, -1.54344>, <0.00015947, 0.000681403, -1.44599e-05>,
                         <0.52435, 0.883896, -1.52229>, <0.000166625, 0.000711588, -1.37355e-05> }
        smooth_triangle {<0.54367, 0.881167, -1.50576>, <0.000130885, 0.000819195, -6.289e-05>,
                         <0.564922, 0.880939, -1.48989>, <6.81377e-05, 0.000855394, -0.000116221>,
                         <0.583297, 0.875925, -1.51598>, <8.54887e-05, 0.00084594, -0.000102385> }
        smooth_triangle {<0.583297, 0.875925, -1.51598>, <8.00819e-05, 0.000798831, -9.919e-05>,
                         <0.563173, 0.876165, -1.52976>, <0.000111434, 0.000768876, -6.96961e-05>,
                         <0.54367, 0.881167, -1.50576>, <0.000116832, 0.000802327, -7.11662e-05> }
        smooth_triangle {<0.564922, 0.880939, -1.48989>, <6.81377e-05, 0.000855394, -0.000116221>,
                         <0.587437, 0.882643, -1.47614>, <1.00258e-05, 0.000794679, -0.000145036>,
                         <0.603373, 0.877718, -1.50223>, <2.32857e-05, 0.000806515, -0.000138012> }
        smooth_triangle {<0.603373, 0.877718, -1.50223>, <2.27275e-05, 0.000791407, -0.000135807>,
                         <0.583297, 0.875925, -1.51598>, <5.3829e-05, 0.000811119, -0.000117994>,
                         <0.564922, 0.880939, -1.48989>, <5.66456e-05, 0.00083562, -0.000120566> }
        smooth_triangle {<0.587437, 0.882643, -1.47614>, <1.00258e-05, 0.000794679, -0.000145036>,
                         <0.609801, 0.885751, -1.46417>, <-2.84278e-05, 0.000686002, -0.000151469>,
                         <0.623324, 0.88099, -1.48857>, <-1.88488e-05, 0.000707319, -0.000148502> }
        smooth_triangle {<0.623324, 0.88099, -1.48857>, <-1.8464e-05, 0.000722769, -0.000149445>,
                         <0.603373, 0.877718, -1.50223>, <2.60328e-06, 0.000772367, -0.0001442>,
                         <0.587437, 0.882643, -1.47614>, <2.99954e-06, 0.000780564, -0.000146374> }
        smooth_triangle {<0.609801, 0.885751, -1.46417>, <-2.84278e-05, 0.000686002, -0.000151469>,
                         <0.631703, 0.890028, -1.45307>, <-5.05126e-05, 0.000582287, -0.000148647>,
                         <0.643111, 0.885493, -1.47501>, <-4.35016e-05, 0.00060747, -0.000148133> }
        smooth_triangle {<0.643111, 0.885493, -1.47501>, <-4.44066e-05, 0.000636678, -0.00015161>,
                         <0.623324, 0.88099, -1.48857>, <-3.20801e-05, 0.000686602, -0.000151794>,
                         <0.609801, 0.885751, -1.46417>, <-3.26488e-05, 0.000680973, -0.000152373> }
        smooth_triangle {<0.631703, 0.890028, -1.45307>, <-5.05126e-05, 0.000582287, -0.000148647>,
                         <0.653197, 0.895431, -1.44242>, <-6.47399e-05, 0.000485725, -0.000141731>,
                         <0.662687, 0.89118, -1.46161>, <-5.83987e-05, 0.000513339, -0.000142645> }
        smooth_triangle {<0.662687, 0.89118, -1.46161>, <-6.12047e-05, 0.00054799, -0.000148153>,
                         <0.643111, 0.885493, -1.47501>, <-5.37561e-05, 0.000595056, -0.000150897>,
                         <0.631703, 0.890028, -1.45307>, <-5.38871e-05, 0.000582376, -0.0001499> }
        smooth_triangle {<0.653197, 0.895431, -1.44242>, <-6.47399e-05, 0.000485725, -0.000141731>,
                         <0.674213, 0.902262, -1.4322>, <-7.76292e-05, 0.000389871, -0.000132149>,
                         <0.681922, 0.898371, -1.44844>, <-7.11213e-05, 0.000419961, -0.000134452> }
        smooth_triangle {<0.681922, 0.898371, -1.44844>, <-7.65395e-05, 0.000456987, -0.000142234>,
                         <0.662687, 0.89118, -1.46161>, <-7.01782e-05, 0.000503676, -0.000146331>,
                         <0.653197, 0.895431, -1.44242>, <-6.90443e-05, 0.000487797, -0.000143802> }
        smooth_triangle {<0.674213, 0.902262, -1.4322>, <-7.76292e-05, 0.000389871, -0.000132149>,
                         <0.694424, 0.911235, -1.4226>, <-8.90679e-05, 0.000291812, -0.000118502>,
                         <0.700472, 0.907816, -1.43573>, <-8.49988e-05, 0.000323525, -0.000123383> }
        smooth_triangle {<0.700472, 0.907816, -1.43573>, <-9.4441e-05, 0.000361304, -0.000134194>,
                         <0.681922, 0.898371, -1.44844>, <-8.75022e-05, 0.000409522, -0.000139729>,
                         <0.674213, 0.902262, -1.4322>, <-8.41927e-05, 0.000392174, -0.000135363> }
        smooth_triangle {<0.694424, 0.911235, -1.4226>, <-8.90679e-05, 0.000291812, -0.000118502>,
                         <0.713265, 0.923044, -1.41398>, <-9.19863e-05, 0.000193785, -9.75505e-05>,
                         <0.717771, 0.920246, -1.42388>, <-9.28062e-05, 0.000225332, -0.00010592> }
        smooth_triangle {<0.717771, 0.920246, -1.42388>, <-0.000107774, 0.000262084, -0.000120129>,
                         <0.700472, 0.907816, -1.43573>, <-0.00010387, 0.00031118, -0.00012886>,
                         <0.694424, 0.911235, -1.4226>, <-9.74863e-05, 0.000293568, -0.000122461> }
        smooth_triangle {<0.713265, 0.923044, -1.41398>, <-9.19863e-05, 0.000193785, -9.75505e-05>,
                         <0.729774, 0.938413, -1.407>, <-7.73113e-05, 0.000104009, -6.70272e-05>,
                         <0.732797, 0.936424, -1.41359>, <-8.74529e-05, 0.00012998, -7.92944e-05> }
        smooth_triangle {<0.732797, 0.936424, -1.41359>, <-0.000109407, 0.000162549, -9.71105e-05>,
                         <0.717771, 0.920246, -1.42388>, <-0.000112084, 0.000210225, -0.000110423>,
                         <0.713265, 0.923044, -1.41398>, <-0.00010183, 0.000194119, -0.000101895> }
        smooth_triangle {<0.729774, 0.938413, -1.407>, <-7.73113e-05, 0.000104009, -6.70272e-05>,
                         <0.743363, 0.956908, -1.40202>, <-3.74124e-05, 3.48535e-05, -2.7647e-05>,
                         <0.744887, 0.955892, -1.40531>, <-5.57878e-05, 5.22825e-05, -4.19897e-05> }
        smooth_triangle {<0.744887, 0.955892, -1.40531>, <-8.38514e-05, 7.85186e-05, -6.24445e-05>,
                         <0.732797, 0.936424, -1.41359>, <-9.9684e-05, 0.000117367, -8.10969e-05>,
                         <0.729774, 0.938413, -1.407>, <-8.59623e-05, 0.000104195, -7.09953e-05> }
        smooth_triangle {<0.743363, 0.956908, -1.40202>, <-3.74124e-05, 3.48535e-05, -2.7647e-05>,
                         <0.754618, 0.977213, -1.39865>, <-4.11741e-07, 1.53347e-07, 1.10523e-06>,
                         <0.754594, 0.977266, -1.39867>, <-5.07288e-07, 1.02232e-07, 1.07674e-06> }
        smooth_triangle {<0.754594, 0.977266, -1.39867>, <-3.20328e-05, 2.10837e-05, -2.06794e-05>,
                         <0.744887, 0.955892, -1.40531>, <-5.9673e-05, 4.71738e-05, -4.22126e-05>,
                         <0.743363, 0.956908, -1.40202>, <-4.39489e-05, 3.66564e-05, -3.13441e-05> }
        smooth_triangle {<0.409509, 0.97716, -1.635>, <6.22659e-05, 4.72853e-05, 3.82346e-05>,
                         <0.415682, 0.958629, -1.62213>, <7.92283e-05, 7.07669e-05, 4.57991e-05>,
                         <0.418071, 0.957653, -1.62481>, <7.92221e-05, 7.05856e-05, 4.58595e-05> }
        smooth_triangle {<0.418071, 0.957653, -1.62481>, <5.9e-05, 5.30302e-05, 3.49192e-05>,
                         <0.409593, 0.977213, -1.63494>, <3.03428e-05, 2.36426e-05, 2.0271e-05>,
                         <0.409509, 0.97716, -1.635>, <3.02998e-05, 2.38246e-05, 2.01665e-05> }
        smooth_triangle {<0.415682, 0.958629, -1.62213>, <7.92283e-05, 7.07669e-05, 4.57991e-05>,
                         <0.424458, 0.942534, -1.60749>, <0.000124101, 0.00014721, 6.32117e-05>,
                         <0.429277, 0.940664, -1.61282>, <0.000123653, 0.00014767, 6.26467e-05> }
        smooth_triangle {<0.429277, 0.940664, -1.61282>, <0.000107059, 0.000125426, 5.43943e-05>,
                         <0.418071, 0.957653, -1.62481>, <7.37356e-05, 6.76135e-05, 4.18039e-05>,
                         <0.415682, 0.958629, -1.62213>, <7.37403e-05, 6.77494e-05, 4.17585e-05> }
        smooth_triangle {<0.424458, 0.942534, -1.60749>, <0.000124101, 0.00014721, 6.32117e-05>,
                         <0.435564, 0.929464, -1.59126>, <0.000153746, 0.000237316, 6.78545e-05>,
                         <0.442906, 0.926867, -1.59918>, <0.000152486, 0.000238425, 6.63223e-05> }
        smooth_triangle {<0.442906, 0.926867, -1.59918>, <0.000139144, 0.000213431, 5.99885e-05>,
                         <0.429277, 0.940664, -1.61282>, <0.00011752, 0.000145364, 5.72318e-05>,
                         <0.424458, 0.942534, -1.60749>, <0.000117855, 0.00014502, 5.76555e-05> }
        smooth_triangle {<0.435564, 0.929464, -1.59126>, <0.000153746, 0.000237316, 6.78545e-05>,
                         <0.447952, 0.918561, -1.57417>, <0.000176588, 0.000328478, 6.91193e-05>,
                         <0.457836, 0.915358, -1.58465>, <0.000174446, 0.000329633, 6.67469e-05> }
        smooth_triangle {<0.457836, 0.915358, -1.58465>, <0.000163047, 0.000303446, 6.14911e-05>,
                         <0.442906, 0.926867, -1.59918>, <0.000146577, 0.00023504, 6.11726e-05>,
                         <0.435564, 0.929464, -1.59126>, <0.000147522, 0.000234208, 6.23218e-05> }
        smooth_triangle {<0.447952, 0.918561, -1.57417>, <0.000176588, 0.000328478, 6.91193e-05>,
                         <0.461076, 0.909041, -1.55659>, <0.000195894, 0.000420072, 6.85873e-05>,
                         <0.473469, 0.905309, -1.56965>, <0.000192848, 0.000420395, 6.56041e-05> }
        smooth_triangle {<0.473469, 0.905309, -1.56965>, <0.000182976, 0.000393326, 6.15185e-05>,
                         <0.457836, 0.915358, -1.58465>, <0.000169175, 0.000325254, 6.23756e-05>,
                         <0.447952, 0.918561, -1.57417>, <0.000170781, 0.000324388, 6.41549e-05> }
        smooth_triangle {<0.461076, 0.909041, -1.55659>, <0.000195894, 0.000420072, 6.85873e-05>,
                         <0.474875, 0.900754, -1.5386>, <0.000208669, 0.000516251, 6.16074e-05>,
                         <0.489691, 0.896563, -1.55427>, <0.000204453, 0.000514264, 5.8152e-05> }
        smooth_triangle {<0.489691, 0.896563, -1.55427>, <0.000196236, 0.000486298, 5.55811e-05>,
                         <0.473469, 0.905309, -1.56965>, <0.000187532, 0.000415897, 6.11702e-05>,
                         <0.461076, 0.909041, -1.55659>, <0.000189816, 0.000415654, 6.34076e-05> }
        smooth_triangle {<0.474875, 0.900754, -1.5386>, <0.000208669, 0.000516251, 6.16074e-05>,
                         <0.489482, 0.893809, -1.52017>, <0.000209393, 0.000622377, 4.14433e-05>,
                         <0.506544, 0.889232, -1.53851>, <0.00020337, 0.000614284, 3.78614e-05> }
        smooth_triangle {<0.506544, 0.889232, -1.53851>, <0.000197754, 0.000585089, 3.78901e-05>,
                         <0.489691, 0.896563, -1.55427>, <0.000198566, 0.000510074, 5.3108e-05>,
                         <0.474875, 0.900754, -1.5386>, <0.000201728, 0.000511564, 5.56995e-05> }
        smooth_triangle {<0.489482, 0.893809, -1.52017>, <0.000209393, 0.000622377, 4.14433e-05>,
                         <0.505508, 0.888755, -1.50114>, <0.000188469, 0.000745299, -1.59369e-06>,
                         <0.52435, 0.883896, -1.52229>, <0.000179743, 0.000721938, -4.00064e-06> }
        smooth_triangle {<0.52435, 0.883896, -1.52229>, <0.000177841, 0.000692307, -6.19193e-07>,
                         <0.506544, 0.889232, -1.53851>, <0.000195561, 0.000611567, 3.07774e-05>,
                         <0.489482, 0.893809, -1.52017>, <0.000200078, 0.000617636, 3.34638e-05> }
        smooth_triangle {<0.505508, 0.888755, -1.50114>, <0.000188469, 0.000745299, -1.59369e-06>,
                         <0.524166, 0.886169, -1.48176>, <0.000141455, 0.000868181, -6.45098e-05>,
                         <0.54367, 0.881167, -1.50576>, <0.000130885, 0.000819195, -6.289e-05> }
        smooth_triangle {<0.54367, 0.881167, -1.50576>, <0.000132676, 0.000794427, -5.77749e-05>,
                         <0.52435, 0.883896, -1.52229>, <0.00016932, 0.000721485, -1.36079e-05>,
                         <0.505508, 0.888755, -1.50114>, <0.000175865, 0.000739005, -1.18027e-05> }
        smooth_triangle {<0.524166, 0.886169, -1.48176>, <0.000141455, 0.000868181, -6.45098e-05>,
                         <0.546548, 0.885953, -1.46381>, <7.56893e-05, 0.000921815, -0.000123669>,
                         <0.564922, 0.880939, -1.48989>, <6.81377e-05, 0.000855394, -0.000116221> }
        smooth_triangle {<0.564922, 0.880939, -1.48989>, <7.23095e-05, 0.000846423, -0.000112634>,
                         <0.54367, 0.881167, -1.50576>, <0.00011937, 0.000819274, -7.26362e-05>,
                         <0.524166, 0.886169, -1.48176>, <0.000127298, 0.000856013, -7.3851e-05> }
        smooth_triangle {<0.546548, 0.885953, -1.46381>, <7.56893e-05, 0.000921815, -0.000123669>,
                         <0.571502, 0.887567, -1.45005>, <1.02342e-05, 0.000849104, -0.000155182>,
                         <0.587437, 0.882643, -1.47614>, <1.00258e-05, 0.000794679, -0.000145036> }
        smooth_triangle {<0.587437, 0.882643, -1.47614>, <1.36503e-05, 0.000806006, -0.000144824>,
                         <0.564922, 0.880939, -1.48989>, <5.72343e-05, 0.000851542, -0.000123212>,
                         <0.546548, 0.885953, -1.46381>, <6.2898e-05, 0.000901358, -0.000128798> }
        smooth_triangle {<0.571502, 0.887567, -1.45005>, <1.02342e-05, 0.000849104, -0.000155182>,
                         <0.596278, 0.890512, -1.43978>, <-3.3196e-05, 0.000716128, -0.000159993>,
                         <0.609801, 0.885751, -1.46417>, <-2.84278e-05, 0.000686002, -0.000151469> }
        smooth_triangle {<0.609801, 0.885751, -1.46417>, <-2.68617e-05, 0.000708031, -0.000153516>,
                         <0.587437, 0.882643, -1.47614>, <1.97847e-06, 0.000789539, -0.000148692>,
                         <0.571502, 0.887567, -1.45005>, <2.13477e-06, 0.000830357, -0.000156301> }
        smooth_triangle {<0.596278, 0.890512, -1.43978>, <-3.3196e-05, 0.000716128, -0.000159993>,
                         <0.620296, 0.894564, -1.43112>, <-5.67035e-05, 0.000598186, -0.000155149>,
                         <0.631703, 0.890028, -1.45307>, <-5.05126e-05, 0.000582287, -0.000148647> }
        smooth_triangle {<0.631703, 0.890028, -1.45307>, <-5.07463e-05, 0.000607832, -0.000152014>,
                         <0.609801, 0.885751, -1.46417>, <-3.41827e-05, 0.000685618, -0.00015413>,
                         <0.596278, 0.890512, -1.43978>, <-3.77588e-05, 0.000708213, -0.000160523> }
        smooth_triangle {<0.620296, 0.894564, -1.43112>, <-5.67035e-05, 0.000598186, -0.000155149>,
                         <0.643707, 0.899682, -1.42324>, <-7.08226e-05, 0.000494803, -0.000146752>,
                         <0.653197, 0.895431, -1.44242>, <-6.47399e-05, 0.000485725, -0.000141731> }
        smooth_triangle {<0.653197, 0.895431, -1.44242>, <-6.61328e-05, 0.000512587, -0.000146077>,
                         <0.631703, 0.890028, -1.45307>, <-5.54623e-05, 0.000585009, -0.000151263>,
                         <0.620296, 0.894564, -1.43112>, <-6.01055e-05, 0.000596933, -0.00015614> }
        smooth_triangle {<0.643707, 0.899682, -1.42324>, <-7.08226e-05, 0.000494803, -0.000146752>,
                         <0.666504, 0.906154, -1.41597>, <-8.28601e-05, 0.000394999, -0.000135862>,
                         <0.674213, 0.902262, -1.4322>, <-7.76292e-05, 0.000389871, -0.000132149> }
        smooth_triangle {<0.674213, 0.902262, -1.4322>, <-8.01229e-05, 0.000417447, -0.000137656>,
                         <0.653197, 0.895431, -1.44242>, <-7.04559e-05, 0.000489338, -0.000144842>,
                         <0.643707, 0.899682, -1.42324>, <-7.50179e-05, 0.000496146, -0.000148608> }
        smooth_triangle {<0.666504, 0.906154, -1.41597>, <-8.28601e-05, 0.000394999, -0.000135862>,
                         <0.688375, 0.914655, -1.40946>, <-9.29658e-05, 0.000294086, -0.000120889>,
                         <0.694424, 0.911235, -1.4226>, <-8.90679e-05, 0.000291812, -0.000118502> }
        smooth_triangle {<0.694424, 0.911235, -1.4226>, <-9.38717e-05, 0.000319393, -0.000125833>,
                         <0.674213, 0.902262, -1.4322>, <-8.52927e-05, 0.000392937, -0.000136068>,
                         <0.666504, 0.906154, -1.41597>, <-8.92158e-05, 0.000396783, -0.000138853> }
        smooth_triangle {<0.688375, 0.914655, -1.40946>, <-9.29658e-05, 0.000294086, -0.000120889>,
                         <0.70876, 0.925842, -1.40408>, <-9.4329e-05, 0.000194188, -9.87303e-05>,
                         <0.713265, 0.923044, -1.41398>, <-9.19863e-05, 0.000193785, -9.75505e-05> }
        smooth_triangle {<0.713265, 0.923044, -1.41398>, <-0.000100399, 0.000220226, -0.000107127>,
                         <0.694424, 0.911235, -1.4226>, <-9.82098e-05, 0.000293746, -0.000122841>,
                         <0.688375, 0.914655, -1.40946>, <-0.000101133, 0.000295451, -0.000124631> }
        smooth_triangle {<0.70876, 0.925842, -1.40408>, <-9.4329e-05, 0.000194188, -9.87303e-05>,
                         <0.726751, 0.940402, -1.4004>, <-7.81897e-05, 0.000103829, -6.73756e-05>,
                         <0.729774, 0.938413, -1.407>, <-7.73113e-05, 0.000104009, -6.70272e-05> }
        smooth_triangle {<0.729774, 0.938413, -1.407>, <-9.11339e-05, 0.000126732, -7.91279e-05>,
                         <0.713265, 0.923044, -1.41398>, <-0.00010214, 0.000194065, -0.00010202>,
                         <0.70876, 0.925842, -1.40408>, <-0.000103897, 0.000194366, -0.000102905> }
        smooth_triangle {<0.726751, 0.940402, -1.4004>, <-7.81897e-05, 0.000103829, -6.73756e-05>,
                         <0.741839, 0.957924, -1.39873>, <-3.74515e-05, 3.48164e-05, -2.76537e-05>,
                         <0.743363, 0.956908, -1.40202>, <-3.74124e-05, 3.48535e-05, -2.7647e-05> }
        smooth_triangle {<0.743363, 0.956908, -1.40202>, <-5.60766e-05, 5.23021e-05, -4.14698e-05>,
                         <0.729774, 0.938413, -1.407>, <-8.60008e-05, 0.000104169, -7.10049e-05>,
                         <0.726751, 0.940402, -1.4004>, <-8.66596e-05, 0.000104034, -7.12662e-05> }
        smooth_triangle {<0.741839, 0.957924, -1.39873>, <-3.74515e-05, 3.48164e-05, -2.76537e-05>,
                         <0.754641, 0.97716, -1.39863>, <-2.20646e-07, 2.55579e-07, 1.1622e-06>,
                         <0.754618, 0.977213, -1.39865>, <-4.11741e-07, 1.53347e-07, 1.10523e-06> }
        smooth_triangle {<0.754618, 0.977213, -1.39865>, <-2.13969e-05, 1.4158e-05, -1.33893e-05>,
                         <0.743363, 0.956908, -1.40202>, <-4.39011e-05, 3.6682e-05, -3.13299e-05>,
                         <0.741839, 0.957924, -1.39873>, <-4.39305e-05, 3.66542e-05, -3.13349e-05> }
        smooth_triangle {<0.409425, 0.977107, -1.63505>, <6.21798e-05, 4.76491e-05, 3.80255e-05>,
                         <0.413294, 0.959605, -1.61945>, <7.92346e-05, 7.09481e-05, 4.57387e-05>,
                         <0.415682, 0.958629, -1.62213>, <7.92283e-05, 7.07669e-05, 4.57991e-05> }
        smooth_triangle {<0.415682, 0.958629, -1.62213>, <5.89831e-05, 5.32571e-05, 3.48216e-05>,
                         <0.409509, 0.97716, -1.635>, <3.02567e-05, 2.40065e-05, 2.00619e-05>,
                         <0.409425, 0.977107, -1.63505>, <3.02137e-05, 2.41884e-05, 1.99574e-05> }
        smooth_triangle {<0.413294, 0.959605, -1.61945>, <7.92346e-05, 7.09481e-05, 4.57387e-05>,
                         <0.41964, 0.944405, -1.60216>, <0.000124548, 0.000146751, 6.37766e-05>,
                         <0.424458, 0.942534, -1.60749>, <0.000124101, 0.00014721, 6.32117e-05> }
        smooth_triangle {<0.424458, 0.942534, -1.60749>, <0.000107442, 0.000125036, 5.48772e-05>,
                         <0.415682, 0.958629, -1.62213>, <7.3788e-05, 6.77034e-05, 4.18178e-05>,
                         <0.413294, 0.959605, -1.61945>, <7.37926e-05, 6.78394e-05, 4.17725e-05> }
        smooth_triangle {<0.41964, 0.944405, -1.60216>, <0.000124548, 0.000146751, 6.37766e-05>,
                         <0.428222, 0.93206, -1.58334>, <0.000155006, 0.000236206, 6.93867e-05>,
                         <0.435564, 0.929464, -1.59126>, <0.000153746, 0.000237316, 6.78545e-05> }
        smooth_triangle {<0.435564, 0.929464, -1.59126>, <0.000140329, 0.000212347, 6.14428e-05>,
                         <0.424458, 0.942534, -1.60749>, <0.000118095, 0.000144768, 5.79607e-05>,
                         <0.41964, 0.944405, -1.60216>, <0.00011843, 0.000144423, 5.83844e-05> }
        smooth_triangle {<0.428222, 0.93206, -1.58334>, <0.000155006, 0.000236206, 6.93867e-05>,
                         <0.438068, 0.921763, -1.56369>, <0.00017873, 0.000327323, 7.14916e-05>,
                         <0.447952, 0.918561, -1.57417>, <0.000176588, 0.000328478, 6.91193e-05> }
        smooth_triangle {<0.447952, 0.918561, -1.57417>, <0.000165119, 0.000302253, 6.38091e-05>,
                         <0.435564, 0.929464, -1.59126>, <0.000147988, 0.000233881, 6.28605e-05>,
                         <0.428222, 0.93206, -1.58334>, <0.000148933, 0.000233049, 6.40097e-05> }
        smooth_triangle {<0.438068, 0.921763, -1.56369>, <0.00017873, 0.000327323, 7.14916e-05>,
                         <0.448683, 0.912772, -1.54354>, <0.000198939, 0.000419749, 7.15705e-05>,
                         <0.461076, 0.909041, -1.55659>, <0.000195894, 0.000420072, 6.85873e-05> }
        smooth_triangle {<0.461076, 0.909041, -1.55659>, <0.000185936, 0.000392872, 6.44577e-05>,
                         <0.447952, 0.918561, -1.57417>, <0.000171457, 0.000324177, 6.48566e-05>,
                         <0.438068, 0.921763, -1.56369>, <0.000173063, 0.000323311, 6.66359e-05> }
        smooth_triangle {<0.448683, 0.912772, -1.54354>, <0.000198939, 0.000419749, 7.15705e-05>,
                         <0.460059, 0.904946, -1.52294>, <0.000212885, 0.000518238, 6.50627e-05>,
                         <0.474875, 0.900754, -1.5386>, <0.000208669, 0.000516251, 6.16074e-05> }
        smooth_triangle {<0.474875, 0.900754, -1.5386>, <0.000200331, 0.000487969, 5.90065e-05>,
                         <0.461076, 0.909041, -1.55659>, <0.000190749, 0.000415835, 6.42415e-05>,
                         <0.448683, 0.912772, -1.54354>, <0.000193033, 0.000415593, 6.64789e-05> }
        smooth_triangle {<0.460059, 0.904946, -1.52294>, <0.000212885, 0.000518238, 6.50627e-05>,
                         <0.472421, 0.898387, -1.50182>, <0.000215416, 0.000630471, 4.50253e-05>,
                         <0.489482, 0.893809, -1.52017>, <0.000209393, 0.000622377, 4.14433e-05> }
        smooth_triangle {<0.489482, 0.893809, -1.52017>, <0.000203567, 0.000592287, 4.15003e-05>,
                         <0.474875, 0.900754, -1.5386>, <0.000203025, 0.000512693, 5.66233e-05>,
                         <0.460059, 0.904946, -1.52294>, <0.000206187, 0.000514183, 5.92149e-05> }
        smooth_triangle {<0.472421, 0.898387, -1.50182>, <0.000215416, 0.000630471, 4.50253e-05>,
                         <0.486667, 0.893613, -1.47998>, <0.000197195, 0.00076866, 8.13255e-07>,
                         <0.505508, 0.888755, -1.50114>, <0.000188469, 0.000745299, -1.59369e-06> }
        smooth_triangle {<0.505508, 0.888755, -1.50114>, <0.00018631, 0.00071364, 2.02481e-06>,
                         <0.489482, 0.893809, -1.52017>, <0.000202003, 0.000621449, 3.43026e-05>,
                         <0.472421, 0.898387, -1.50182>, <0.00020652, 0.000627518, 3.6989e-05> }
        smooth_triangle {<0.486667, 0.893613, -1.47998>, <0.000197195, 0.00076866, 8.13255e-07>,
                         <0.504663, 0.891171, -1.45777>, <0.000152025, 0.000917167, -6.61295e-05>,
                         <0.524166, 0.886169, -1.48176>, <0.000141455, 0.000868181, -6.45098e-05> }
        smooth_triangle {<0.524166, 0.886169, -1.48176>, <0.000143299, 0.000841063, -5.88621e-05>,
                         <0.505508, 0.888755, -1.50114>, <0.00017856, 0.000748902, -1.16751e-05>,
                         <0.486667, 0.893613, -1.47998>, <0.000185105, 0.000766423, -9.86985e-06> }
        smooth_triangle {<0.504663, 0.891171, -1.45777>, <0.000152025, 0.000917167, -6.61295e-05>,
                         <0.528173, 0.890967, -1.43772>, <8.32409e-05, 0.000988236, -0.000131117>,
                         <0.546548, 0.885953, -1.46381>, <7.56893e-05, 0.000921815, -0.000123669> }
        smooth_triangle {<0.546548, 0.885953, -1.46381>, <8.05107e-05, 0.000913186, -0.00011969>,
                         <0.524166, 0.886169, -1.48176>, <0.000129835, 0.00087296, -7.53211e-05>,
                         <0.504663, 0.891171, -1.45777>, <0.000137763, 0.0009097, -7.65359e-05> }
        smooth_triangle {<0.528173, 0.890967, -1.43772>, <8.32409e-05, 0.000988236, -0.000131117>,
                         <0.555567, 0.892491, -1.42397>, <1.04426e-05, 0.000903528, -0.000165328>,
                         <0.571502, 0.887567, -1.45005>, <1.02342e-05, 0.000849104, -0.000155182> }
        smooth_triangle {<0.571502, 0.887567, -1.45005>, <1.43953e-05, 0.000862746, -0.000155079>,
                         <0.546548, 0.885953, -1.46381>, <6.34867e-05, 0.00091728, -0.000131444>,
                         <0.528173, 0.890967, -1.43772>, <6.91504e-05, 0.000967096, -0.00013703> }
        smooth_triangle {<0.555567, 0.892491, -1.42397>, <1.04426e-05, 0.000903528, -0.000165328>,
                         <0.582755, 0.895273, -1.41539>, <-3.79641e-05, 0.000746254, -0.000168516>,
                         <0.596278, 0.890512, -1.43978>, <-3.3196e-05, 0.000716128, -0.000159993> }
        smooth_triangle {<0.596278, 0.890512, -1.43978>, <-3.14589e-05, 0.0007396, -0.000162227>,
                         <0.571502, 0.887567, -1.45005>, <1.1137e-06, 0.000839332, -0.000158619>,
                         <0.555567, 0.892491, -1.42397>, <1.27e-06, 0.00088015, -0.000166228> }
        smooth_triangle {<0.582755, 0.895273, -1.41539>, <-3.79641e-05, 0.000746254, -0.000168516>,
                         <0.608889, 0.8991, -1.40917>, <-6.28944e-05, 0.000614085, -0.000161652>,
                         <0.620296, 0.894564, -1.43112>, <-5.67035e-05, 0.000598186, -0.000155149> }
        smooth_triangle {<0.620296, 0.894564, -1.43112>, <-5.69234e-05, 0.000624401, -0.000158648>,
                         <0.596278, 0.890512, -1.43978>, <-3.92928e-05, 0.000712858, -0.00016228>,
                         <0.582755, 0.895273, -1.41539>, <-4.28689e-05, 0.000735453, -0.000168673> }
        smooth_triangle {<0.608889, 0.8991, -1.40917>, <-6.28944e-05, 0.000614085, -0.000161652>,
                         <0.634217, 0.903933, -1.40405>, <-7.69053e-05, 0.00050388, -0.000151772>,
                         <0.643707, 0.899682, -1.42324>, <-7.08226e-05, 0.000494803, -0.000146752> }
        smooth_triangle {<0.643707, 0.899682, -1.42324>, <-7.227e-05, 0.000522029, -0.000151205>,
                         <0.620296, 0.894564, -1.43112>, <-6.16807e-05, 0.000599567, -0.000157503>,
                         <0.608889, 0.8991, -1.40917>, <-6.63239e-05, 0.000611491, -0.00016238> }
        smooth_triangle {<0.634217, 0.903933, -1.40405>, <-7.69053e-05, 0.00050388, -0.000151772>,
                         <0.658794, 0.910046, -1.39973>, <-8.80909e-05, 0.000400127, -0.000139576>,
                         <0.666504, 0.906154, -1.41597>, <-8.28601e-05, 0.000394999, -0.000135862> }
        smooth_triangle {<0.666504, 0.906154, -1.41597>, <-8.54576e-05, 0.000422835, -0.00014148>,
                         <0.643707, 0.899682, -1.42324>, <-7.64295e-05, 0.000497688, -0.000149648>,
                         <0.634217, 0.903933, -1.40405>, <-8.09915e-05, 0.000504496, -0.000153413> }
        smooth_triangle {<0.658794, 0.910046, -1.39973>, <-8.80909e-05, 0.000400127, -0.000139576>,
                         <0.682327, 0.918074, -1.39633>, <-9.68636e-05, 0.000296359, -0.000123277>,
                         <0.688375, 0.914655, -1.40946>, <-9.29658e-05, 0.000294086, -0.000120889> }
        smooth_triangle {<0.688375, 0.914655, -1.40946>, <-9.78951e-05, 0.000321862, -0.000128329>,
                         <0.666504, 0.906154, -1.41597>, <-9.03158e-05, 0.000397547, -0.000139559>,
                         <0.658794, 0.910046, -1.39973>, <-9.42389e-05, 0.000401393, -0.000142344> }
        smooth_triangle {<0.682327, 0.918074, -1.39633>, <-9.68636e-05, 0.000296359, -0.000123277>,
                         <0.704255, 0.92864, -1.39418>, <-9.66716e-05, 0.00019459, -9.99102e-05>,
                         <0.70876, 0.925842, -1.40408>, <-9.4329e-05, 0.000194188, -9.87303e-05> }
        smooth_triangle {<0.70876, 0.925842, -1.40408>, <-0.000102879, 0.000220705, -0.000108391>,
                         <0.688375, 0.914655, -1.40946>, <-0.000101857, 0.000295629, -0.000125011>,
                         <0.682327, 0.918074, -1.39633>, <-0.00010478, 0.000297334, -0.000126801> }
        smooth_triangle {<0.704255, 0.92864, -1.39418>, <-9.66716e-05, 0.00019459, -9.99102e-05>,
                         <0.723728, 0.942391, -1.39381>, <-7.90681e-05, 0.000103649, -6.7724e-05>,
                         <0.726751, 0.940402, -1.4004>, <-7.81897e-05, 0.000103829, -6.73756e-05> }
        smooth_triangle {<0.726751, 0.940402, -1.4004>, <-9.21028e-05, 0.000126543, -7.9515e-05>,
                         <0.70876, 0.925842, -1.40408>, <-0.000104207, 0.000194312, -0.000103031>,
                         <0.704255, 0.92864, -1.39418>, <-0.000105964, 0.000194614, -0.000103916> }
        smooth_triangle {<0.723728, 0.942391, -1.39381>, <-7.90681e-05, 0.000103649, -6.7724e-05>,
                         <0.740315, 0.958939, -1.39545>, <-3.74907e-05, 3.47794e-05, -2.76604e-05>,
                         <0.741839, 0.957924, -1.39873>, <-3.74515e-05, 3.48164e-05, -2.76537e-05> }
        smooth_triangle {<0.741839, 0.957924, -1.39873>, <-5.61446e-05, 5.22476e-05, -4.14844e-05>,
                         <0.726751, 0.940402, -1.4004>, <-8.66982e-05, 0.000104007, -7.12758e-05>,
                         <0.723728, 0.942391, -1.39381>, <-8.7357e-05, 0.000103872, -7.15371e-05> }
        smooth_triangle {<0.740315, 0.958939, -1.39545>, <-3.74907e-05, 3.47794e-05, -2.76604e-05>,
                         <0.754665, 0.977107, -1.39862>, <-2.95519e-08, 3.57811e-07, 1.21918e-06>,
                         <0.754641, 0.97716, -1.39863>, <-2.20646e-07, 2.55579e-07, 1.1622e-06> }
        smooth_triangle {<0.754641, 0.97716, -1.39863>, <-2.12058e-05, 1.42602e-05, -1.33324e-05>,
                         <0.741839, 0.957924, -1.39873>, <-4.38827e-05, 3.66797e-05, -3.13207e-05>,
                         <0.740315, 0.958939, -1.39545>, <-4.39121e-05, 3.66519e-05, -3.13257e-05> }
        smooth_triangle {<0.40934, 0.977054, -1.63511>, <6.20937e-05, 4.80129e-05, 3.78164e-05>,
                         <0.410905, 0.960582, -1.61677>, <7.92408e-05, 7.11293e-05, 4.56782e-05>,
                         <0.413294, 0.959605, -1.61945>, <7.92346e-05, 7.09481e-05, 4.57387e-05> }
        smooth_triangle {<0.413294, 0.959605, -1.61945>, <5.89663e-05, 5.34839e-05, 3.4724e-05>,
                         <0.409425, 0.977107, -1.63505>, <3.01706e-05, 2.43703e-05, 1.98528e-05>,
                         <0.40934, 0.977054, -1.63511>, <3.01276e-05, 2.45522e-05, 1.97483e-05> }
        smooth_triangle {<0.410905, 0.960582, -1.61677>, <7.92408e-05, 7.11293e-05, 4.56782e-05>,
                         <0.414821, 0.946275, -1.59682>, <0.000124995, 0.000146292, 6.43415e-05>,
                         <0.41964, 0.944405, -1.60216>, <0.000124548, 0.000146751, 6.37766e-05> }
        smooth_triangle {<0.41964, 0.944405, -1.60216>, <0.000107825, 0.000124646, 5.53601e-05>,
                         <0.413294, 0.959605, -1.61945>, <7.38404e-05, 6.77934e-05, 4.18317e-05>,
                         <0.410905, 0.960582, -1.61677>, <7.3845e-05, 6.79293e-05, 4.17864e-05> }
        smooth_triangle {<0.414821, 0.946275, -1.59682>, <0.000124995, 0.000146292, 6.43415e-05>,
                         <0.420881, 0.934657, -1.57543>, <0.000156267, 0.000235097, 7.09189e-05>,
                         <0.428222, 0.93206, -1.58334>, <0.000155006, 0.000236206, 6.93867e-05> }
        smooth_triangle {<0.428222, 0.93206, -1.58334>, <0.000141514, 0.000211262, 6.28972e-05>,
                         <0.41964, 0.944405, -1.60216>, <0.00011867, 0.000144171, 5.86896e-05>,
                         <0.414821, 0.946275, -1.59682>, <0.000119005, 0.000143827, 5.91133e-05> }
        smooth_triangle {<0.420881, 0.934657, -1.57543>, <0.000156267, 0.000235097, 7.09189e-05>,
                         <0.428183, 0.924966, -1.55321>, <0.000180871, 0.000326169, 7.38639e-05>,
                         <0.438068, 0.921763, -1.56369>, <0.00017873, 0.000327323, 7.14916e-05> }
        smooth_triangle {<0.438068, 0.921763, -1.56369>, <0.00016719, 0.000301059, 6.61271e-05>,
                         <0.428222, 0.93206, -1.58334>, <0.000149398, 0.000232722, 6.45484e-05>,
                         <0.420881, 0.934657, -1.57543>, <0.000150343, 0.00023189, 6.56976e-05> }
        smooth_triangle {<0.428183, 0.924966, -1.55321>, <0.000180871, 0.000326169, 7.38639e-05>,
                         <0.43629, 0.916503, -1.53048>, <0.000201985, 0.000419426, 7.45537e-05>,
                         <0.448683, 0.912772, -1.54354>, <0.000198939, 0.000419749, 7.15705e-05> }
        smooth_triangle {<0.448683, 0.912772, -1.54354>, <0.000188896, 0.000392418, 6.73969e-05>,
                         <0.438068, 0.921763, -1.56369>, <0.000173739, 0.000323099, 6.73377e-05>,
                         <0.428183, 0.924966, -1.55321>, <0.000175345, 0.000322233, 6.91169e-05> }
        smooth_triangle {<0.43629, 0.916503, -1.53048>, <0.000201985, 0.000419426, 7.45537e-05>,
                         <0.445243, 0.909138, -1.50727>, <0.000217101, 0.000520225, 6.85181e-05>,
                         <0.460059, 0.904946, -1.52294>, <0.000212885, 0.000518238, 6.50627e-05> }
        smooth_triangle {<0.460059, 0.904946, -1.52294>, <0.000204425, 0.00048964, 6.24319e-05>,
                         <0.448683, 0.912772, -1.54354>, <0.000193966, 0.000415773, 6.73128e-05>,
                         <0.43629, 0.916503, -1.53048>, <0.00019625, 0.000415531, 6.95502e-05> }
        smooth_triangle {<0.445243, 0.909138, -1.50727>, <0.000217101, 0.000520225, 6.85181e-05>,
                         <0.455359, 0.902964, -1.48347>, <0.000221439, 0.000638564, 4.86072e-05>,
                         <0.472421, 0.898387, -1.50182>, <0.000215416, 0.000630471, 4.50253e-05> }
        smooth_triangle {<0.472421, 0.898387, -1.50182>, <0.000209381, 0.000599486, 4.51106e-05>,
                         <0.460059, 0.904946, -1.52294>, <0.000207483, 0.000515312, 6.01387e-05>,
                         <0.445243, 0.909138, -1.50727>, <0.000210645, 0.000516802, 6.27302e-05> }
        smooth_triangle {<0.455359, 0.902964, -1.48347>, <0.000221439, 0.000638564, 4.86072e-05>,
                         <0.467826, 0.898471, -1.45883>, <0.000205922, 0.000792021, 3.2202e-06>,
                         <0.486667, 0.893613, -1.47998>, <0.000197195, 0.00076866, 8.13255e-07> }
        smooth_triangle {<0.486667, 0.893613, -1.47998>, <0.00019478, 0.000734973, 4.66882e-06>,
                         <0.472421, 0.898387, -1.50182>, <0.000208445, 0.000631331, 3.78278e-05>,
                         <0.455359, 0.902964, -1.48347>, <0.000212962, 0.0006374, 4.05143e-05> }
        smooth_triangle {<0.467826, 0.898471, -1.45883>, <0.000205922, 0.000792021, 3.2202e-06>,
                         <0.48516, 0.896173, -1.43377>, <0.000162596, 0.000966154, -6.77492e-05>,
                         <0.504663, 0.891171, -1.45777>, <0.000152025, 0.000917167, -6.61295e-05> }
        smooth_triangle {<0.504663, 0.891171, -1.45777>, <0.000153922, 0.000887699, -5.99493e-05>,
                         <0.486667, 0.893613, -1.47998>, <0.0001878, 0.000776319, -9.74223e-06>,
                         <0.467826, 0.898471, -1.45883>, <0.000194344, 0.00079384, -7.93702e-06> }
        smooth_triangle {<0.48516, 0.896173, -1.43377>, <0.000162596, 0.000966154, -6.77492e-05>,
                         <0.509799, 0.895981, -1.41164>, <9.07925e-05, 0.00105466, -0.000138565>,
                         <0.528173, 0.890967, -1.43772>, <8.32409e-05, 0.000988236, -0.000131117> }
        smooth_triangle {<0.528173, 0.890967, -1.43772>, <8.87119e-05, 0.000979948, -0.000126746>,
                         <0.504663, 0.891171, -1.45777>, <0.0001403, 0.000926647, -7.80059e-05>,
                         <0.48516, 0.896173, -1.43377>, <0.000148228, 0.000963386, -7.92207e-05> }
        smooth_triangle {<0.509799, 0.895981, -1.41164>, <9.07925e-05, 0.00105466, -0.000138565>,
                         <0.539632, 0.897416, -1.39788>, <1.0651e-05, 0.000957953, -0.000175474>,
                         <0.555567, 0.892491, -1.42397>, <1.04426e-05, 0.000903528, -0.000165328> }
        smooth_triangle {<0.555567, 0.892491, -1.42397>, <1.51403e-05, 0.000919487, -0.000165334>,
                         <0.528173, 0.890967, -1.43772>, <6.9739e-05, 0.000983018, -0.000139676>,
                         <0.509799, 0.895981, -1.41164>, <7.54027e-05, 0.00103283, -0.000145261> }
        smooth_triangle {<0.539632, 0.897416, -1.39788>, <1.0651e-05, 0.000957953, -0.000175474>,
                         <0.569232, 0.900033, -1.391>, <-4.27323e-05, 0.00077638, -0.000177039>,
                         <0.582755, 0.895273, -1.41539>, <-3.79641e-05, 0.000746254, -0.000168516> }
        smooth_triangle {<0.582755, 0.895273, -1.41539>, <-3.60561e-05, 0.000771169, -0.000170937>,
                         <0.555567, 0.892491, -1.42397>, <2.48934e-07, 0.000889125, -0.000168546>,
                         <0.539632, 0.897416, -1.39788>, <4.05237e-07, 0.000929944, -0.000176155> }
        smooth_triangle {<0.569232, 0.900033, -1.391>, <-4.27323e-05, 0.00077638, -0.000177039>,
                         <0.597482, 0.903635, -1.38722>, <-6.90853e-05, 0.000629983, -0.000168155>,
                         <0.608889, 0.8991, -1.40917>, <-6.28944e-05, 0.000614085, -0.000161652> }
        smooth_triangle {<0.608889, 0.8991, -1.40917>, <-6.31006e-05, 0.000640971, -0.000165282>,
                         <0.582755, 0.895273, -1.41539>, <-4.44029e-05, 0.000740098, -0.00017043>,
                         <0.569232, 0.900033, -1.391>, <-4.7979e-05, 0.000762692, -0.000176822> }
        smooth_triangle {<0.597482, 0.903635, -1.38722>, <-6.90853e-05, 0.000629983, -0.000168155>,
                         <0.624727, 0.908185, -1.38487>, <-8.2988e-05, 0.000512958, -0.000156793>,
                         <0.634217, 0.903933, -1.40405>, <-7.69053e-05, 0.00050388, -0.000151772> }
        smooth_triangle {<0.634217, 0.903933, -1.40405>, <-7.84073e-05, 0.000531471, -0.000156333>,
                         <0.608889, 0.8991, -1.40917>, <-6.78991e-05, 0.000614125, -0.000163743>,
                         <0.597482, 0.903635, -1.38722>, <-7.25423e-05, 0.000626049, -0.00016862> }
        smooth_triangle {<0.624727, 0.908185, -1.38487>, <-8.2988e-05, 0.000512958, -0.000156793>,
                         <0.651085, 0.913937, -1.3835>, <-9.33217e-05, 0.000405255, -0.000143289>,
                         <0.658794, 0.910046, -1.39973>, <-8.80909e-05, 0.000400127, -0.000139576> }
        smooth_triangle {<0.658794, 0.910046, -1.39973>, <-9.07923e-05, 0.000428222, -0.000145305>,
                         <0.634217, 0.903933, -1.40405>, <-8.24031e-05, 0.000506037, -0.000154453>,
                         <0.624727, 0.908185, -1.38487>, <-8.69651e-05, 0.000512846, -0.000158218> }
        smooth_triangle {<0.651085, 0.913937, -1.3835>, <-9.33217e-05, 0.000405255, -0.000143289>,
                         <0.676278, 0.921493, -1.3832>, <-0.000100762, 0.000298633, -0.000125664>,
                         <0.682327, 0.918074, -1.39633>, <-9.68636e-05, 0.000296359, -0.000123277> }
        smooth_triangle {<0.682327, 0.918074, -1.39633>, <-0.000101918, 0.000324331, -0.000130825>,
                         <0.658794, 0.910046, -1.39973>, <-9.53389e-05, 0.000402157, -0.000143049>,
                         <0.651085, 0.913937, -1.3835>, <-9.9262e-05, 0.000406003, -0.000145834> }
        smooth_triangle {<0.676278, 0.921493, -1.3832>, <-0.000100762, 0.000298633, -0.000125664>,
                         <0.69975, 0.931438, -1.38429>, <-9.90143e-05, 0.000194992, -0.00010109>,
                         <0.704255, 0.92864, -1.39418>, <-9.66716e-05, 0.00019459, -9.99102e-05> }
        smooth_triangle {<0.704255, 0.92864, -1.39418>, <-0.000105359, 0.000221185, -0.000109656>,
                         <0.682327, 0.918074, -1.39633>, <-0.000105503, 0.000297512, -0.00012718>,
                         <0.676278, 0.921493, -1.3832>, <-0.000108427, 0.000299217, -0.000128971> }
        smooth_triangle {<0.69975, 0.931438, -1.38429>, <-9.90143e-05, 0.000194992, -0.00010109>,
                         <0.720705, 0.94438, -1.38722>, <-7.99465e-05, 0.000103469, -6.80724e-05>,
                         <0.723728, 0.942391, -1.39381>, <-7.90681e-05, 0.000103649, -6.7724e-05> }
        smooth_triangle {<0.723728, 0.942391, -1.39381>, <-9.30717e-05, 0.000126354, -7.99021e-05>,
                         <0.704255, 0.92864, -1.39418>, <-0.000106274, 0.00019456, -0.000104042>,
                         <0.69975, 0.931438, -1.38429>, <-0.000108031, 0.000194861, -0.000104927> }
        smooth_triangle {<0.720705, 0.94438, -1.38722>, <-7.99465e-05, 0.000103469, -6.80724e-05>,
                         <0.73879, 0.959955, -1.39216>, <-3.75299e-05, 3.47423e-05, -2.76671e-05>,
                         <0.740315, 0.958939, -1.39545>, <-3.74907e-05, 3.47794e-05, -2.76604e-05> }
        smooth_triangle {<0.740315, 0.958939, -1.39545>, <-5.62125e-05, 5.21931e-05, -4.14991e-05>,
                         <0.723728, 0.942391, -1.39381>, <-8.73956e-05, 0.000103845, -7.15467e-05>,
                         <0.720705, 0.94438, -1.38722>, <-8.80544e-05, 0.00010371, -7.1808e-05> }
        smooth_triangle {<0.73879, 0.959955, -1.39216>, <-3.75299e-05, 3.47423e-05, -2.76671e-05>,
                         <0.754689, 0.977054, -1.3986>, <1.61543e-07, 4.60042e-07, 1.27615e-06>,
                         <0.754665, 0.977107, -1.39862>, <-2.95519e-08, 3.57811e-07, 1.21918e-06> }
        smooth_triangle {<0.754665, 0.977107, -1.39862>, <-2.10147e-05, 1.43625e-05, -1.32754e-05>,
                         <0.740315, 0.958939, -1.39545>, <-4.38643e-05, 3.66775e-05, -3.13115e-05>,
                         <0.73879, 0.959955, -1.39216>, <-4.38937e-05, 3.66497e-05, -3.13165e-05> }
        smooth_triangle {<0.409256, 0.977001, -1.63517>, <6.20076e-05, 4.83768e-05, 3.76073e-05>,
                         <0.408517, 0.961558, -1.61409>, <7.9247e-05, 7.13105e-05, 4.56178e-05>,
                         <0.410905, 0.960582, -1.61677>, <7.92408e-05, 7.11293e-05, 4.56782e-05> }
        smooth_triangle {<0.410905, 0.960582, -1.61677>, <5.89494e-05, 5.37108e-05, 3.46264e-05>,
                         <0.40934, 0.977054, -1.63511>, <3.00846e-05, 2.47341e-05, 1.96437e-05>,
                         <0.409256, 0.977001, -1.63517>, <3.00415e-05, 2.4916e-05, 1.95392e-05> }
        smooth_triangle {<0.408517, 0.961558, -1.61409>, <7.9247e-05, 7.13105e-05, 4.56178e-05>,
                         <0.410003, 0.948146, -1.59149>, <0.000125442, 0.000145833, 6.49064e-05>,
                         <0.414821, 0.946275, -1.59682>, <0.000124995, 0.000146292, 6.43415e-05> }
        smooth_triangle {<0.414821, 0.946275, -1.59682>, <0.000108208, 0.000124255, 5.58431e-05>,
                         <0.410905, 0.960582, -1.61677>, <7.38928e-05, 6.78833e-05, 4.18456e-05>,
                         <0.408517, 0.961558, -1.61409>, <7.38974e-05, 6.80192e-05, 4.18003e-05> }
        smooth_triangle {<0.410003, 0.948146, -1.59149>, <0.000125442, 0.000145833, 6.49064e-05>,
                         <0.413539, 0.937254, -1.56751>, <0.000157527, 0.000233988, 7.24511e-05>,
                         <0.420881, 0.934657, -1.57543>, <0.000156267, 0.000235097, 7.09189e-05> }
        smooth_triangle {<0.420881, 0.934657, -1.57543>, <0.000142699, 0.000210178, 6.43516e-05>,
                         <0.414821, 0.946275, -1.59682>, <0.000119245, 0.000143574, 5.94185e-05>,
                         <0.410003, 0.948146, -1.59149>, <0.000119581, 0.00014323, 5.98422e-05> }
        smooth_triangle {<0.413539, 0.937254, -1.56751>, <0.000157527, 0.000233988, 7.24511e-05>,
                         <0.418299, 0.928168, -1.54272>, <0.000183013, 0.000325014, 7.62362e-05>,
                         <0.428183, 0.924966, -1.55321>, <0.000180871, 0.000326169, 7.38639e-05> }
        smooth_triangle {<0.428183, 0.924966, -1.55321>, <0.000169262, 0.000299866, 6.84451e-05>,
                         <0.420881, 0.934657, -1.57543>, <0.000150808, 0.000231562, 6.62363e-05>,
                         <0.413539, 0.937254, -1.56751>, <0.000151753, 0.00023073, 6.73855e-05> }
        smooth_triangle {<0.418299, 0.928168, -1.54272>, <0.000183013, 0.000325014, 7.62362e-05>,
                         <0.423897, 0.920235, -1.51742>, <0.00020503, 0.000419103, 7.75369e-05>,
                         <0.43629, 0.916503, -1.53048>, <0.000201985, 0.000419426, 7.45537e-05> }
        smooth_triangle {<0.43629, 0.916503, -1.53048>, <0.000191856, 0.000391965, 7.0336e-05>,
                         <0.428183, 0.924966, -1.55321>, <0.000176021, 0.000322022, 6.98187e-05>,
                         <0.418299, 0.928168, -1.54272>, <0.000177627, 0.000321156, 7.15979e-05> }
        smooth_triangle {<0.423897, 0.920235, -1.51742>, <0.00020503, 0.000419103, 7.75369e-05>,
                         <0.430427, 0.913329, -1.4916>, <0.000221317, 0.000522211, 7.19735e-05>,
                         <0.445243, 0.909138, -1.50727>, <0.000217101, 0.000520225, 6.85181e-05> }
        smooth_triangle {<0.445243, 0.909138, -1.50727>, <0.00020852, 0.000491311, 6.58573e-05>,
                         <0.43629, 0.916503, -1.53048>, <0.000197183, 0.000415712, 7.0384e-05>,
                         <0.423897, 0.920235, -1.51742>, <0.000199467, 0.00041547, 7.26214e-05> }
        smooth_triangle {<0.430427, 0.913329, -1.4916>, <0.000221317, 0.000522211, 7.19735e-05>,
                         <0.438298, 0.907542, -1.46513>, <0.000227462, 0.000646657, 5.21891e-05>,
                         <0.455359, 0.902964, -1.48347>, <0.000221439, 0.000638564, 4.86072e-05> }
        smooth_triangle {<0.455359, 0.902964, -1.48347>, <0.000215194, 0.000606685, 4.87208e-05>,
                         <0.445243, 0.909138, -1.50727>, <0.000211941, 0.00051793, 6.3654e-05>,
                         <0.430427, 0.913329, -1.4916>, <0.000215103, 0.000519421, 6.62456e-05> }
        smooth_triangle {<0.438298, 0.907542, -1.46513>, <0.000227462, 0.000646657, 5.21891e-05>,
                         <0.448985, 0.90333, -1.43768>, <0.000214648, 0.000815382, 5.62715e-06>,
                         <0.467826, 0.898471, -1.45883>, <0.000205922, 0.000792021, 3.2202e-06> }
        smooth_triangle {<0.467826, 0.898471, -1.45883>, <0.000203249, 0.000756306, 7.31282e-06>,
                         <0.455359, 0.902964, -1.48347>, <0.000214887, 0.000641213, 4.13531e-05>,
                         <0.438298, 0.907542, -1.46513>, <0.000219404, 0.000647283, 4.40395e-05> }
        smooth_triangle {<0.448985, 0.90333, -1.43768>, <0.000214648, 0.000815382, 5.62715e-06>,
                         <0.465656, 0.901175, -1.40977>, <0.000173166, 0.00101514, -6.9369e-05>,
                         <0.48516, 0.896173, -1.43377>, <0.000162596, 0.000966154, -6.77492e-05> }
        smooth_triangle {<0.48516, 0.896173, -1.43377>, <0.000164545, 0.000934336, -6.10365e-05>,
                         <0.467826, 0.898471, -1.45883>, <0.00019704, 0.000803736, -7.8094e-06>,
                         <0.448985, 0.90333, -1.43768>, <0.000203584, 0.000821257, -6.00419e-06> }
        smooth_triangle {<0.465656, 0.901175, -1.40977>, <0.000173166, 0.00101514, -6.9369e-05>,
                         <0.491425, 0.900995, -1.38555>, <9.83441e-05, 0.00112108, -0.000146012>,
                         <0.509799, 0.895981, -1.41164>, <9.07925e-05, 0.00105466, -0.000138565> }
        smooth_triangle {<0.509799, 0.895981, -1.41164>, <9.69131e-05, 0.00104671, -0.000133802>,
                         <0.48516, 0.896173, -1.43377>, <0.000150766, 0.000980333, -8.06907e-05>,
                         <0.465656, 0.901175, -1.40977>, <0.000158693, 0.00101707, -8.19055e-05> }
        smooth_triangle {<0.491425, 0.900995, -1.38555>, <9.83441e-05, 0.00112108, -0.000146012>,
                         <0.523697, 0.90234, -1.37179>, <1.08594e-05, 0.00101238, -0.00018562>,
                         <0.539632, 0.897416, -1.39788>, <1.0651e-05, 0.000957953, -0.000175474> }
        smooth_triangle {<0.539632, 0.897416, -1.39788>, <1.58853e-05, 0.000976228, -0.000175589>,
                         <0.509799, 0.895981, -1.41164>, <7.59914e-05, 0.00104876, -0.000147907>,
                         <0.491425, 0.900995, -1.38555>, <8.16551e-05, 0.00109857, -0.000153493> }
        smooth_triangle {<0.523697, 0.90234, -1.37179>, <1.08594e-05, 0.00101238, -0.00018562>,
                         <0.555709, 0.904794, -1.36661>, <-4.75004e-05, 0.000806506, -0.000185563>,
                         <0.569232, 0.900033, -1.391>, <-4.27323e-05, 0.00077638, -0.000177039> }
        smooth_triangle {<0.569232, 0.900033, -1.391>, <-4.06533e-05, 0.000802738, -0.000179647>,
                         <0.539632, 0.897416, -1.39788>, <-6.15833e-07, 0.000938918, -0.000178473>,
                         <0.523697, 0.90234, -1.37179>, <-4.5953e-07, 0.000979737, -0.000186082> }
        smooth_triangle {<0.555709, 0.904794, -1.36661>, <-4.75004e-05, 0.000806506, -0.000185563>,
                         <0.586074, 0.908171, -1.36527>, <-7.52762e-05, 0.000645882, -0.000174658>,
                         <0.597482, 0.903635, -1.38722>, <-6.90853e-05, 0.000629983, -0.000168155> }
        smooth_triangle {<0.597482, 0.903635, -1.38722>, <-6.92777e-05, 0.00065754, -0.000171916>,
                         <0.569232, 0.900033, -1.391>, <-4.9513e-05, 0.000767338, -0.000178579>,
                         <0.555709, 0.904794, -1.36661>, <-5.30891e-05, 0.000789932, -0.000184972> }
        smooth_triangle {<0.586074, 0.908171, -1.36527>, <-7.52762e-05, 0.000645882, -0.000174658>,
                         <0.615236, 0.912436, -1.36569>, <-8.90707e-05, 0.000522036, -0.000161814>,
                         <0.624727, 0.908185, -1.38487>, <-8.2988e-05, 0.000512958, -0.000156793> }
        smooth_triangle {<0.624727, 0.908185, -1.38487>, <-8.45445e-05, 0.000540914, -0.000161462>,
                         <0.597482, 0.903635, -1.38722>, <-7.41175e-05, 0.000628682, -0.000169983>,
                         <0.586074, 0.908171, -1.36527>, <-7.87607e-05, 0.000640606, -0.00017486> }
        smooth_triangle {<0.615236, 0.912436, -1.36569>, <-8.90707e-05, 0.000522036, -0.000161814>,
                         <0.643376, 0.917829, -1.36727>, <-9.85526e-05, 0.000410383, -0.000147002>,
                         <0.651085, 0.913937, -1.3835>, <-9.33217e-05, 0.000405255, -0.000143289> }
        smooth_triangle {<0.651085, 0.913937, -1.3835>, <-9.6127e-05, 0.000433609, -0.00014913>,
                         <0.624727, 0.908185, -1.38487>, <-8.83767e-05, 0.000514387, -0.000159258>,
                         <0.615236, 0.912436, -1.36569>, <-9.29387e-05, 0.000521195, -0.000163024> }
        smooth_triangle {<0.643376, 0.917829, -1.36727>, <-9.85526e-05, 0.000410383, -0.000147002>,
                         <0.670229, 0.924913, -1.37007>, <-0.000104659, 0.000300906, -0.000128051>,
                         <0.676278, 0.921493, -1.3832>, <-0.000100762, 0.000298633, -0.000125664> }
        smooth_triangle {<0.676278, 0.921493, -1.3832>, <-0.000105942, 0.0003268, -0.000133321>,
                         <0.651085, 0.913937, -1.3835>, <-0.000100362, 0.000406766, -0.00014654>,
                         <0.643376, 0.917829, -1.36727>, <-0.000104285, 0.000410612, -0.000149325> }
        smooth_triangle {<0.670229, 0.924913, -1.37007>, <-0.000104659, 0.000300906, -0.000128051>,
                         <0.695244, 0.934236, -1.37439>, <-0.000101357, 0.000195395, -0.00010227>,
                         <0.69975, 0.931438, -1.38429>, <-9.90143e-05, 0.000194992, -0.00010109> }
        smooth_triangle {<0.69975, 0.931438, -1.38429>, <-0.00010784, 0.000221665, -0.00011092>,
                         <0.676278, 0.921493, -1.3832>, <-0.00010915, 0.000299395, -0.00012935>,
                         <0.670229, 0.924913, -1.37007>, <-0.000112074, 0.0003011, -0.000131141> }
        smooth_triangle {<0.695244, 0.934236, -1.37439>, <-0.000101357, 0.000195395, -0.00010227>,
                         <0.717682, 0.946369, -1.38062>, <-8.08249e-05, 0.000103289, -6.84208e-05>,
                         <0.720705, 0.94438, -1.38722>, <-7.99465e-05, 0.000103469, -6.80724e-05> }
        smooth_triangle {<0.720705, 0.94438, -1.38722>, <-9.40407e-05, 0.000126165, -8.02892e-05>,
                         <0.69975, 0.931438, -1.38429>, <-0.000108341, 0.000194807, -0.000105052>,
                         <0.695244, 0.934236, -1.37439>, <-0.000110098, 0.000195109, -0.000105937> }
        smooth_triangle {<0.717682, 0.946369, -1.38062>, <-8.08249e-05, 0.000103289, -6.84208e-05>,
                         <0.737266, 0.96097, -1.38887>, <-3.75691e-05, 3.47052e-05, -2.76738e-05>,
                         <0.73879, 0.959955, -1.39216>, <-3.75299e-05, 3.47423e-05, -2.76671e-05> }
        smooth_triangle {<0.73879, 0.959955, -1.39216>, <-5.62805e-05, 5.21386e-05, -4.15137e-05>,
                         <0.720705, 0.94438, -1.38722>, <-8.8093e-05, 0.000103684, -7.18177e-05>,
                         <0.717682, 0.946369, -1.38062>, <-8.87518e-05, 0.000103549, -7.2079e-05> }
        smooth_triangle {<0.737266, 0.96097, -1.38887>, <-3.75691e-05, 3.47052e-05, -2.76738e-05>,
                         <0.754712, 0.977001, -1.39858>, <3.52637e-07, 5.62274e-07, 1.33313e-06>,
                         <0.754689, 0.977054, -1.3986>, <1.61543e-07, 4.60042e-07, 1.27615e-06> }
        smooth_triangle {<0.754689, 0.977054, -1.3986>, <-2.08236e-05, 1.44647e-05, -1.32184e-05>,
                         <0.73879, 0.959955, -1.39216>, <-4.38459e-05, 3.66752e-05, -3.13022e-05>,
                         <0.737266, 0.96097, -1.38887>, <-4.38753e-05, 3.66474e-05, -3.13073e-05> }
        smooth_triangle {<0.409172, 0.976948, -1.63523>, <6.19215e-05, 4.87406e-05, 3.73982e-05>,
                         <0.406128, 0.962535, -1.6114>, <7.92533e-05, 7.14918e-05, 4.55574e-05>,
                         <0.408517, 0.961558, -1.61409>, <7.9247e-05, 7.13105e-05, 4.56178e-05> }
        smooth_triangle {<0.408517, 0.961558, -1.61409>, <5.89326e-05, 5.39377e-05, 3.45288e-05>,
                         <0.409256, 0.977001, -1.63517>, <2.99985e-05, 2.5098e-05, 1.94346e-05>,
                         <0.409172, 0.976948, -1.63523>, <2.99554e-05, 2.52799e-05, 1.933e-05> }
        smooth_triangle {<0.406128, 0.962535, -1.6114>, <7.92533e-05, 7.14918e-05, 4.55574e-05>,
                         <0.405184, 0.950017, -1.58615>, <0.000125889, 0.000145374, 6.54713e-05>,
                         <0.410003, 0.948146, -1.59149>, <0.000125442, 0.000145833, 6.49064e-05> }
        smooth_triangle {<0.410003, 0.948146, -1.59149>, <0.000108591, 0.000123865, 5.6326e-05>,
                         <0.408517, 0.961558, -1.61409>, <7.39452e-05, 6.79732e-05, 4.18596e-05>,
                         <0.406128, 0.962535, -1.6114>, <7.39498e-05, 6.81091e-05, 4.18142e-05> }
        smooth_triangle {<0.405184, 0.950017, -1.58615>, <0.000125889, 0.000145374, 6.54713e-05>,
                         <0.406197, 0.93985, -1.55959>, <0.000158787, 0.000232878, 7.39833e-05>,
                         <0.413539, 0.937254, -1.56751>, <0.000157527, 0.000233988, 7.24511e-05> }
        smooth_triangle {<0.413539, 0.937254, -1.56751>, <0.000143884, 0.000209093, 6.58059e-05>,
                         <0.410003, 0.948146, -1.59149>, <0.00011982, 0.000142977, 6.01474e-05>,
                         <0.405184, 0.950017, -1.58615>, <0.000120156, 0.000142633, 6.05711e-05> }
        smooth_triangle {<0.406197, 0.93985, -1.55959>, <0.000158787, 0.000232878, 7.39833e-05>,
                         <0.408415, 0.931371, -1.53224>, <0.000185154, 0.00032386, 7.86086e-05>,
                         <0.418299, 0.928168, -1.54272>, <0.000183013, 0.000325014, 7.62362e-05> }
        smooth_triangle {<0.418299, 0.928168, -1.54272>, <0.000171333, 0.000298673, 7.07631e-05>,
                         <0.413539, 0.937254, -1.56751>, <0.000152218, 0.000230403, 6.79242e-05>,
                         <0.406197, 0.93985, -1.55959>, <0.000153163, 0.000229571, 6.90734e-05> }
        smooth_triangle {<0.408415, 0.931371, -1.53224>, <0.000185154, 0.00032386, 7.86086e-05>,
                         <0.411503, 0.923966, -1.50437>, <0.000208076, 0.00041878, 8.05201e-05>,
                         <0.423897, 0.920235, -1.51742>, <0.00020503, 0.000419103, 7.75369e-05> }
        smooth_triangle {<0.423897, 0.920235, -1.51742>, <0.000194816, 0.000391511, 7.32752e-05>,
                         <0.418299, 0.928168, -1.54272>, <0.000178303, 0.000320944, 7.22997e-05>,
                         <0.408415, 0.931371, -1.53224>, <0.000179909, 0.000320078, 7.4079e-05> }
        smooth_triangle {<0.411503, 0.923966, -1.50437>, <0.000208076, 0.00041878, 8.05201e-05>,
                         <0.415611, 0.917521, -1.47593>, <0.000225533, 0.000524198, 7.54289e-05>,
                         <0.430427, 0.913329, -1.4916>, <0.000221317, 0.000522211, 7.19735e-05> }
        smooth_triangle {<0.430427, 0.913329, -1.4916>, <0.000212615, 0.000492981, 6.92827e-05>,
                         <0.423897, 0.920235, -1.51742>, <0.0002004, 0.00041565, 7.34553e-05>,
                         <0.411503, 0.923966, -1.50437>, <0.000202684, 0.000415408, 7.56927e-05> }
        smooth_triangle {<0.415611, 0.917521, -1.47593>, <0.000225533, 0.000524198, 7.54289e-05>,
                         <0.421236, 0.912119, -1.44678>, <0.000233485, 0.00065475, 5.5771e-05>,
                         <0.438298, 0.907542, -1.46513>, <0.000227462, 0.000646657, 5.21891e-05> }
        smooth_triangle {<0.438298, 0.907542, -1.46513>, <0.000221008, 0.000613883, 5.23311e-05>,
                         <0.430427, 0.913329, -1.4916>, <0.000216399, 0.000520549, 6.71694e-05>,
                         <0.415611, 0.917521, -1.47593>, <0.000219561, 0.00052204, 6.97609e-05> }
        smooth_triangle {<0.421236, 0.912119, -1.44678>, <0.000233485, 0.00065475, 5.5771e-05>,
                         <0.430144, 0.908188, -1.41652>, <0.000223374, 0.000838743, 8.03409e-06>,
                         <0.448985, 0.90333, -1.43768>, <0.000214648, 0.000815382, 5.62715e-06> }
        smooth_triangle {<0.448985, 0.90333, -1.43768>, <0.000211719, 0.000777639, 9.95683e-06>,
                         <0.438298, 0.907542, -1.46513>, <0.000221329, 0.000651095, 4.48783e-05>,
                         <0.421236, 0.912119, -1.44678>, <0.000225846, 0.000657165, 4.75647e-05> }
        smooth_triangle {<0.430144, 0.908188, -1.41652>, <0.000223374, 0.000838743, 8.03409e-06>,
                         <0.446153, 0.906177, -1.38577>, <0.000183737, 0.00106413, -7.09887e-05>,
                         <0.465656, 0.901175, -1.40977>, <0.000173166, 0.00101514, -6.9369e-05> }
        smooth_triangle {<0.465656, 0.901175, -1.40977>, <0.000175168, 0.000980972, -6.21237e-05>,
                         <0.448985, 0.90333, -1.43768>, <0.000206279, 0.000831154, -5.87657e-06>,
                         <0.430144, 0.908188, -1.41652>, <0.000212824, 0.000848674, -4.07136e-06> }
        smooth_triangle {<0.446153, 0.906177, -1.38577>, <0.000183737, 0.00106413, -7.09887e-05>,
                         <0.47305, 0.906009, -1.35947>, <0.000105896, 0.0011875, -0.00015346>,
                         <0.491425, 0.900995, -1.38555>, <9.83441e-05, 0.00112108, -0.000146012> }
        smooth_triangle {<0.491425, 0.900995, -1.38555>, <0.000105114, 0.00111347, -0.000140858>,
                         <0.465656, 0.901175, -1.40977>, <0.000161231, 0.00103402, -8.33756e-05>,
                         <0.446153, 0.906177, -1.38577>, <0.000169159, 0.00107076, -8.45904e-05> }
        smooth_triangle {<0.47305, 0.906009, -1.35947>, <0.000105896, 0.0011875, -0.00015346>,
                         <0.507762, 0.907264, -1.3457>, <1.10678e-05, 0.0010668, -0.000195765>,
                         <0.523697, 0.90234, -1.37179>, <1.08594e-05, 0.00101238, -0.00018562> }
        smooth_triangle {<0.523697, 0.90234, -1.37179>, <1.66303e-05, 0.00103297, -0.000185844>,
                         <0.491425, 0.900995, -1.38555>, <8.22438e-05, 0.00111449, -0.000156139>,
                         <0.47305, 0.906009, -1.35947>, <8.79075e-05, 0.00116431, -0.000161725> }
        smooth_triangle {<0.507762, 0.907264, -1.3457>, <1.10678e-05, 0.0010668, -0.000195765>,
                         <0.542185, 0.909555, -1.34221>, <-5.22686e-05, 0.000836632, -0.000194086>,
                         <0.555709, 0.904794, -1.36661>, <-4.75004e-05, 0.000806506, -0.000185563> }
        smooth_triangle {<0.555709, 0.904794, -1.36661>, <-4.52505e-05, 0.000834307, -0.000188357>,
                         <0.523697, 0.90234, -1.37179>, <-1.4806e-06, 0.000988711, -0.0001884>,
                         <0.507762, 0.907264, -1.3457>, <-1.3243e-06, 0.00102953, -0.000196009> }
        smooth_triangle {<0.542185, 0.909555, -1.34221>, <-5.22686e-05, 0.000836632, -0.000194086>,
                         <0.574667, 0.912706, -1.34332>, <-8.14671e-05, 0.000661781, -0.00018116>,
                         <0.586074, 0.908171, -1.36527>, <-7.52762e-05, 0.000645882, -0.000174658> }
        smooth_triangle {<0.586074, 0.908171, -1.36527>, <-7.54549e-05, 0.000674109, -0.00017855>,
                         <0.555709, 0.904794, -1.36661>, <-5.46231e-05, 0.000794577, -0.000186729>,
                         <0.542185, 0.909555, -1.34221>, <-5.81992e-05, 0.000817172, -0.000193121> }
        smooth_triangle {<0.574667, 0.912706, -1.34332>, <-8.14671e-05, 0.000661781, -0.00018116>,
                         <0.605746, 0.916687, -1.3465>, <-9.51534e-05, 0.000531114, -0.000166835>,
                         <0.615236, 0.912436, -1.36569>, <-8.90707e-05, 0.000522036, -0.000161814> }
        smooth_triangle {<0.615236, 0.912436, -1.36569>, <-9.06818e-05, 0.000550356, -0.00016659>,
                         <0.586074, 0.908171, -1.36527>, <-8.03359e-05, 0.00064324, -0.000176223>,
                         <0.574667, 0.912706, -1.34332>, <-8.49791e-05, 0.000655164, -0.0001811> }
        smooth_triangle {<0.605746, 0.916687, -1.3465>, <-9.51534e-05, 0.000531114, -0.000166835>,
                         <0.635667, 0.921721, -1.35103>, <-0.000103783, 0.000415511, -0.000150716>,
                         <0.643376, 0.917829, -1.36727>, <-9.85526e-05, 0.000410383, -0.000147002> }
        smooth_triangle {<0.643376, 0.917829, -1.36727>, <-0.000101462, 0.000438997, -0.000152955>,
                         <0.615236, 0.912436, -1.36569>, <-9.43503e-05, 0.000522737, -0.000164064>,
                         <0.605746, 0.916687, -1.3465>, <-9.89123e-05, 0.000529545, -0.000167829> }
        smooth_triangle {<0.635667, 0.921721, -1.35103>, <-0.000103783, 0.000415511, -0.000150716>,
                         <0.664181, 0.928332, -1.35693>, <-0.000108557, 0.00030318, -0.000130438>,
                         <0.670229, 0.924913, -1.37007>, <-0.000104659, 0.000300906, -0.000128051> }
        smooth_triangle {<0.670229, 0.924913, -1.37007>, <-0.000109965, 0.000329268, -0.000135817>,
                         <0.643376, 0.917829, -1.36727>, <-0.000105385, 0.000411376, -0.00015003>,
                         <0.635667, 0.921721, -1.35103>, <-0.000109308, 0.000415222, -0.000152815> }
        smooth_triangle {<0.664181, 0.928332, -1.35693>, <-0.000108557, 0.00030318, -0.000130438>,
                         <0.690739, 0.937034, -1.36449>, <-0.0001037, 0.000195797, -0.00010345>,
                         <0.695244, 0.934236, -1.37439>, <-0.000101357, 0.000195395, -0.00010227> }
        smooth_triangle {<0.695244, 0.934236, -1.37439>, <-0.00011032, 0.000222145, -0.000112184>,
                         <0.670229, 0.924913, -1.37007>, <-0.000112797, 0.000301278, -0.00013152>,
                         <0.664181, 0.928332, -1.35693>, <-0.000115721, 0.000302983, -0.000133311> }
        smooth_triangle {<0.690739, 0.937034, -1.36449>, <-0.0001037, 0.000195797, -0.00010345>,
                         <0.71466, 0.948358, -1.37403>, <-8.17033e-05, 0.000103109, -6.87692e-05>,
                         <0.717682, 0.946369, -1.38062>, <-8.08249e-05, 0.000103289, -6.84208e-05> }
        smooth_triangle {<0.717682, 0.946369, -1.38062>, <-9.50096e-05, 0.000125976, -8.06764e-05>,
                         <0.695244, 0.934236, -1.37439>, <-0.000110409, 0.000195055, -0.000106063>,
                         <0.690739, 0.937034, -1.36449>, <-0.000112166, 0.000195357, -0.000106948> }
        smooth_triangle {<0.71466, 0.948358, -1.37403>, <-8.17033e-05, 0.000103109, -6.87692e-05>,
                         <0.735742, 0.961986, -1.38558>, <-3.76082e-05, 3.46681e-05, -2.76805e-05>,
                         <0.737266, 0.96097, -1.38887>, <-3.75691e-05, 3.47052e-05, -2.76738e-05> }
        smooth_triangle {<0.737266, 0.96097, -1.38887>, <-5.63485e-05, 5.20841e-05, -4.15284e-05>,
                         <0.717682, 0.946369, -1.38062>, <-8.87903e-05, 0.000103522, -7.20886e-05>,
                         <0.71466, 0.948358, -1.37403>, <-8.94491e-05, 0.000103387, -7.23499e-05> }
        smooth_triangle {<0.735742, 0.961986, -1.38558>, <-3.76082e-05, 3.46681e-05, -2.76805e-05>,
                         <0.754736, 0.976948, -1.39857>, <5.43731e-07, 6.64505e-07, 1.39011e-06>,
                         <0.754712, 0.977001, -1.39858>, <3.52637e-07, 5.62274e-07, 1.33313e-06> }
        smooth_triangle {<0.754712, 0.977001, -1.39858>, <-2.06325e-05, 1.45669e-05, -1.31614e-05>,
                         <0.737266, 0.96097, -1.38887>, <-4.38275e-05, 3.6673e-05, -3.1293e-05>,
                         <0.735742, 0.961986, -1.38558>, <-4.38569e-05, 3.66451e-05, -3.12981e-05> }
        smooth_triangle {<0.409087, 0.976895, -1.63529>, <6.18355e-05, 4.91044e-05, 3.71891e-05>,
                         <0.40374, 0.963511, -1.60872>, <7.92595e-05, 7.1673e-05, 4.5497e-05>,
                         <0.406128, 0.962535, -1.6114>, <7.92533e-05, 7.14918e-05, 4.55574e-05> }
        smooth_triangle {<0.406128, 0.962535, -1.6114>, <5.89157e-05, 5.41646e-05, 3.44312e-05>,
                         <0.409172, 0.976948, -1.63523>, <2.99124e-05, 2.54618e-05, 1.92255e-05>,
                         <0.409087, 0.976895, -1.63529>, <2.98693e-05, 2.56437e-05, 1.91209e-05> }
        smooth_triangle {<0.40374, 0.963511, -1.60872>, <7.92595e-05, 7.1673e-05, 4.5497e-05>,
                         <0.400366, 0.951887, -1.58082>, <0.000126336, 0.000144915, 6.60363e-05>,
                         <0.405184, 0.950017, -1.58615>, <0.000125889, 0.000145374, 6.54713e-05> }
        smooth_triangle {<0.405184, 0.950017, -1.58615>, <0.000108974, 0.000123475, 5.68089e-05>,
                         <0.406128, 0.962535, -1.6114>, <7.39976e-05, 6.80631e-05, 4.18735e-05>,
                         <0.40374, 0.963511, -1.60872>, <7.40022e-05, 6.81991e-05, 4.18282e-05> }
        smooth_triangle {<0.400366, 0.951887, -1.58082>, <0.000126336, 0.000144915, 6.60363e-05>,
                         <0.398855, 0.942447, -1.55167>, <0.000160047, 0.000231769, 7.55155e-05>,
                         <0.406197, 0.93985, -1.55959>, <0.000158787, 0.000232878, 7.39833e-05> }
        smooth_triangle {<0.406197, 0.93985, -1.55959>, <0.000145069, 0.000208009, 6.72603e-05>,
                         <0.405184, 0.950017, -1.58615>, <0.000120396, 0.000142381, 6.08763e-05>,
                         <0.400366, 0.951887, -1.58082>, <0.000120731, 0.000142036, 6.13e-05> }
        smooth_triangle {<0.398855, 0.942447, -1.55167>, <0.000160047, 0.000231769, 7.55155e-05>,
                         <0.398531, 0.934573, -1.52176>, <0.000187296, 0.000322705, 8.09809e-05>,
                         <0.408415, 0.931371, -1.53224>, <0.000185154, 0.00032386, 7.86086e-05> }
        smooth_triangle {<0.408415, 0.931371, -1.53224>, <0.000173404, 0.00029748, 7.3081e-05>,
                         <0.406197, 0.93985, -1.55959>, <0.000153629, 0.000229244, 6.96121e-05>,
                         <0.398855, 0.942447, -1.55167>, <0.000154574, 0.000228412, 7.07613e-05> }
        smooth_triangle {<0.398531, 0.934573, -1.52176>, <0.000187296, 0.000322705, 8.09809e-05>,
                         <0.39911, 0.927697, -1.49131>, <0.000211121, 0.000418457, 8.35034e-05>,
                         <0.411503, 0.923966, -1.50437>, <0.000208076, 0.00041878, 8.05201e-05> }
        smooth_triangle {<0.411503, 0.923966, -1.50437>, <0.000197776, 0.000391057, 7.62144e-05>,
                         <0.408415, 0.931371, -1.53224>, <0.000180584, 0.000319867, 7.47807e-05>,
                         <0.398531, 0.934573, -1.52176>, <0.000182191, 0.000319001, 7.656e-05> }
        smooth_triangle {<0.39911, 0.927697, -1.49131>, <0.000211121, 0.000418457, 8.35034e-05>,
                         <0.400795, 0.921713, -1.46027>, <0.000229749, 0.000526185, 7.88843e-05>,
                         <0.415611, 0.917521, -1.47593>, <0.000225533, 0.000524198, 7.54289e-05> }
        smooth_triangle {<0.415611, 0.917521, -1.47593>, <0.00021671, 0.000494652, 7.27082e-05>,
                         <0.411503, 0.923966, -1.50437>, <0.000203617, 0.000415589, 7.65266e-05>,
                         <0.39911, 0.927697, -1.49131>, <0.000205901, 0.000415346, 7.8764e-05> }
        smooth_triangle {<0.400795, 0.921713, -1.46027>, <0.000229749, 0.000526185, 7.88843e-05>,
                         <0.404175, 0.916697, -1.42843>, <0.000239507, 0.000662843, 5.93529e-05>,
                         <0.421236, 0.912119, -1.44678>, <0.000233485, 0.00065475, 5.5771e-05> }
        smooth_triangle {<0.421236, 0.912119, -1.44678>, <0.000226821, 0.000621082, 5.59414e-05>,
                         <0.415611, 0.917521, -1.47593>, <0.000220858, 0.000523168, 7.06848e-05>,
                         <0.400795, 0.921713, -1.46027>, <0.000224019, 0.000524658, 7.32763e-05> }
        smooth_triangle {<0.404175, 0.916697, -1.42843>, <0.000239507, 0.000662843, 5.93529e-05>,
                         <0.411303, 0.913046, -1.39537>, <0.0002321, 0.000862105, 1.0441e-05>,
                         <0.430144, 0.908188, -1.41652>, <0.000223374, 0.000838743, 8.03409e-06> }
        smooth_triangle {<0.430144, 0.908188, -1.41652>, <0.000220188, 0.000798972, 1.26008e-05>,
                         <0.421236, 0.912119, -1.44678>, <0.000227771, 0.000660977, 4.84035e-05>,
                         <0.404175, 0.916697, -1.42843>, <0.000232288, 0.000667047, 5.109e-05> }
        smooth_triangle {<0.411303, 0.913046, -1.39537>, <0.0002321, 0.000862105, 1.0441e-05>,
                         <0.426649, 0.911179, -1.36177>, <0.000194307, 0.00111311, -7.26084e-05>,
                         <0.446153, 0.906177, -1.38577>, <0.000183737, 0.00106413, -7.09887e-05> }
        smooth_triangle {<0.446153, 0.906177, -1.38577>, <0.000185791, 0.00102761, -6.32108e-05>,
                         <0.430144, 0.908188, -1.41652>, <0.000215519, 0.000858571, -3.94374e-06>,
                         <0.411303, 0.913046, -1.39537>, <0.000222064, 0.000876092, -2.13853e-06> }
        smooth_triangle {<0.426649, 0.911179, -1.36177>, <0.000194307, 0.00111311, -7.26084e-05>,
                         <0.454676, 0.911023, -1.33339>, <0.000113447, 0.00125392, -0.000160908>,
                         <0.47305, 0.906009, -1.35947>, <0.000105896, 0.0011875, -0.00015346> }
        smooth_triangle {<0.47305, 0.906009, -1.35947>, <0.000113315, 0.00118024, -0.000147914>,
                         <0.446153, 0.906177, -1.38577>, <0.000171696, 0.00108771, -8.60604e-05>,
                         <0.426649, 0.911179, -1.36177>, <0.000179624, 0.00112445, -8.72752e-05> }
        smooth_triangle {<0.454676, 0.911023, -1.33339>, <0.000113447, 0.00125392, -0.000160908>,
                         <0.491826, 0.912188, -1.31961>, <1.12762e-05, 0.00112123, -0.000205911>,
                         <0.507762, 0.907264, -1.3457>, <1.10678e-05, 0.0010668, -0.000195765> }
        smooth_triangle {<0.507762, 0.907264, -1.3457>, <1.73753e-05, 0.00108971, -0.000196099>,
                         <0.47305, 0.906009, -1.35947>, <8.84962e-05, 0.00118023, -0.000164371>,
                         <0.454676, 0.911023, -1.33339>, <9.41599e-05, 0.00123005, -0.000169957> }
        smooth_triangle {<0.491826, 0.912188, -1.31961>, <1.12762e-05, 0.00112123, -0.000205911>,
                         <0.528662, 0.914315, -1.31782>, <-5.70367e-05, 0.000866758, -0.000202609>,
                         <0.542185, 0.909555, -1.34221>, <-5.22686e-05, 0.000836632, -0.000194086> }
        smooth_triangle {<0.542185, 0.909555, -1.34221>, <-4.98476e-05, 0.000865876, -0.000197068>,
                         <0.507762, 0.907264, -1.3457>, <-2.34537e-06, 0.0010385, -0.000198327>,
                         <0.491826, 0.912188, -1.31961>, <-2.18906e-06, 0.00107932, -0.000205937> }
        smooth_triangle {<0.528662, 0.914315, -1.31782>, <-5.70367e-05, 0.000866758, -0.000202609>,
                         <0.56326, 0.917242, -1.32137>, <-8.7658e-05, 0.00067768, -0.000187663>,
                         <0.574667, 0.912706, -1.34332>, <-8.14671e-05, 0.000661781, -0.00018116> }
        smooth_triangle {<0.574667, 0.912706, -1.34332>, <-8.1632e-05, 0.000690679, -0.000185184>,
                         <0.542185, 0.909555, -1.34221>, <-5.97331e-05, 0.000821817, -0.000194878>,
                         <0.528662, 0.914315, -1.31782>, <-6.33092e-05, 0.000844411, -0.000201271> }
        smooth_triangle {<0.56326, 0.917242, -1.32137>, <-8.7658e-05, 0.00067768, -0.000187663>,
                         <0.596256, 0.920938, -1.32732>, <-0.000101236, 0.000540192, -0.000171855>,
                         <0.605746, 0.916687, -1.3465>, <-9.51534e-05, 0.000531114, -0.000166835> }
        smooth_triangle {<0.605746, 0.916687, -1.3465>, <-9.68191e-05, 0.000559798, -0.000171718>,
                         <0.574667, 0.912706, -1.34332>, <-8.65543e-05, 0.000657798, -0.000182463>,
                         <0.56326, 0.917242, -1.32137>, <-9.11975e-05, 0.000669722, -0.00018734> }
        smooth_triangle {<0.596256, 0.920938, -1.32732>, <-0.000101236, 0.000540192, -0.000171855>,
                         <0.627958, 0.925613, -1.3348>, <-0.000109014, 0.000420639, -0.000154429>,
                         <0.635667, 0.921721, -1.35103>, <-0.000103783, 0.000415511, -0.000150716> }
        smooth_triangle {<0.635667, 0.921721, -1.35103>, <-0.000106796, 0.000444384, -0.00015678>,
                         <0.605746, 0.916687, -1.3465>, <-0.000100324, 0.000531086, -0.000168869>,
                         <0.596256, 0.920938, -1.32732>, <-0.000104886, 0.000537895, -0.000172635> }
        smooth_triangle {<0.627958, 0.925613, -1.3348>, <-0.000109014, 0.000420639, -0.000154429>,
                         <0.658132, 0.931752, -1.3438>, <-0.000112455, 0.000305453, -0.000132825>,
                         <0.664181, 0.928332, -1.35693>, <-0.000108557, 0.00030318, -0.000130438> }
        smooth_triangle {<0.664181, 0.928332, -1.35693>, <-0.000113989, 0.000331737, -0.000138312>,
                         <0.635667, 0.921721, -1.35103>, <-0.000110408, 0.000415986, -0.000153521>,
                         <0.627958, 0.925613, -1.3348>, <-0.000114331, 0.000419832, -0.000156306> }
        smooth_triangle {<0.658132, 0.931752, -1.3438>, <-0.000112455, 0.000305453, -0.000132825>,
                         <0.686234, 0.939831, -1.35459>, <-0.000106042, 0.000196199, -0.000104629>,
                         <0.690739, 0.937034, -1.36449>, <-0.0001037, 0.000195797, -0.00010345> }
        smooth_triangle {<0.690739, 0.937034, -1.36449>, <-0.000112801, 0.000222624, -0.000113449>,
                         <0.664181, 0.928332, -1.35693>, <-0.000116444, 0.000303161, -0.00013369>,
                         <0.658132, 0.931752, -1.3438>, <-0.000119367, 0.000304866, -0.00013548> }
        smooth_triangle {<0.686234, 0.939831, -1.35459>, <-0.000106042, 0.000196199, -0.000104629>,
                         <0.711637, 0.950347, -1.36743>, <-8.25817e-05, 0.000102929, -6.91175e-05>,
                         <0.71466, 0.948358, -1.37403>, <-8.17033e-05, 0.000103109, -6.87692e-05> }
        smooth_triangle {<0.71466, 0.948358, -1.37403>, <-9.59785e-05, 0.000125787, -8.10635e-05>,
                         <0.690739, 0.937034, -1.36449>, <-0.000112476, 0.000195303, -0.000107074>,
                         <0.686234, 0.939831, -1.35459>, <-0.000114233, 0.000195604, -0.000107959> }
        smooth_triangle {<0.711637, 0.950347, -1.36743>, <-8.25817e-05, 0.000102929, -6.91175e-05>,
                         <0.734218, 0.963002, -1.38229>, <-3.76474e-05, 3.4631e-05, -2.76873e-05>,
                         <0.735742, 0.961986, -1.38558>, <-3.76082e-05, 3.46681e-05, -2.76805e-05> }
        smooth_triangle {<0.735742, 0.961986, -1.38558>, <-5.64164e-05, 5.20296e-05, -4.15431e-05>,
                         <0.71466, 0.948358, -1.37403>, <-8.94877e-05, 0.00010336, -7.23595e-05>,
                         <0.711637, 0.950347, -1.36743>, <-9.01465e-05, 0.000103225, -7.26208e-05> }
        smooth_triangle {<0.734218, 0.963002, -1.38229>, <-3.76474e-05, 3.4631e-05, -2.76873e-05>,
                         <0.754759, 0.976895, -1.39855>, <7.34826e-07, 7.66737e-07, 1.44708e-06>,
                         <0.754736, 0.976948, -1.39857>, <5.43731e-07, 6.64505e-07, 1.39011e-06> }
        smooth_triangle {<0.754736, 0.976948, -1.39857>, <-2.04414e-05, 1.46692e-05, -1.31045e-05>,
                         <0.735742, 0.961986, -1.38558>, <-4.38091e-05, 3.66707e-05, -3.12838e-05>,
                         <0.734218, 0.963002, -1.38229>, <-4.38385e-05, 3.66429e-05, -3.12888e-05> }
        smooth_triangle {<0.409003, 0.976842, -1.63534>, <6.17494e-05, 4.94683e-05, 3.698e-05>,
                         <0.401351, 0.964488, -1.60604>, <7.92657e-05, 7.18542e-05, 4.54366e-05>,
                         <0.40374, 0.963511, -1.60872>, <7.92595e-05, 7.1673e-05, 4.5497e-05> }
        smooth_triangle {<0.40374, 0.963511, -1.60872>, <5.88989e-05, 5.43914e-05, 3.43336e-05>,
                         <0.409087, 0.976895, -1.63529>, <2.98263e-05, 2.58256e-05, 1.90164e-05>,
                         <0.409003, 0.976842, -1.63534>, <2.97832e-05, 2.60075e-05, 1.89118e-05> }
        smooth_triangle {<0.401351, 0.964488, -1.60604>, <7.92657e-05, 7.18542e-05, 4.54366e-05>,
                         <0.395547, 0.953758, -1.57549>, <0.000126783, 0.000144455, 6.66012e-05>,
                         <0.400366, 0.951887, -1.58082>, <0.000126336, 0.000144915, 6.60363e-05> }
        smooth_triangle {<0.400366, 0.951887, -1.58082>, <0.000109357, 0.000123084, 5.72919e-05>,
                         <0.40374, 0.963511, -1.60872>, <7.405e-05, 6.81531e-05, 4.18874e-05>,
                         <0.401351, 0.964488, -1.60604>, <7.40546e-05, 6.8289e-05, 4.18421e-05> }
        smooth_triangle {<0.395547, 0.953758, -1.57549>, <0.000126783, 0.000144455, 6.66012e-05>,
                         <0.391513, 0.945044, -1.54376>, <0.000161307, 0.000230659, 7.70477e-05>,
                         <0.398855, 0.942447, -1.55167>, <0.000160047, 0.000231769, 7.55155e-05> }
        smooth_triangle {<0.398855, 0.942447, -1.55167>, <0.000146254, 0.000206925, 6.87147e-05>,
                         <0.400366, 0.951887, -1.58082>, <0.000120971, 0.000141784, 6.16052e-05>,
                         <0.395547, 0.953758, -1.57549>, <0.000121306, 0.000141439, 6.20289e-05> }
        smooth_triangle {<0.391513, 0.945044, -1.54376>, <0.000161307, 0.000230659, 7.70477e-05>,
                         <0.388647, 0.937775, -1.51128>, <0.000189437, 0.00032155, 8.33532e-05>,
                         <0.398531, 0.934573, -1.52176>, <0.000187296, 0.000322705, 8.09809e-05> }
        smooth_triangle {<0.398531, 0.934573, -1.52176>, <0.000175476, 0.000296287, 7.5399e-05>,
                         <0.398855, 0.942447, -1.55167>, <0.000155039, 0.000228084, 7.13e-05>,
                         <0.391513, 0.945044, -1.54376>, <0.000155984, 0.000227252, 7.24492e-05> }
        smooth_triangle {<0.388647, 0.937775, -1.51128>, <0.000189437, 0.00032155, 8.33532e-05>,
                         <0.386717, 0.931429, -1.47826>, <0.000214167, 0.000418134, 8.64866e-05>,
                         <0.39911, 0.927697, -1.49131>, <0.000211121, 0.000418457, 8.35034e-05> }
        smooth_triangle {<0.39911, 0.927697, -1.49131>, <0.000200735, 0.000390604, 7.91536e-05>,
                         <0.398531, 0.934573, -1.52176>, <0.000182866, 0.000318789, 7.72618e-05>,
                         <0.388647, 0.937775, -1.51128>, <0.000184472, 0.000317923, 7.9041e-05> }
        smooth_triangle {<0.386717, 0.931429, -1.47826>, <0.000214167, 0.000418134, 8.64866e-05>,
                         <0.385979, 0.925904, -1.4446>, <0.000233965, 0.000528172, 8.23397e-05>,
                         <0.400795, 0.921713, -1.46027>, <0.000229749, 0.000526185, 7.88843e-05> }
        smooth_triangle {<0.400795, 0.921713, -1.46027>, <0.000220805, 0.000496323, 7.61336e-05>,
                         <0.39911, 0.927697, -1.49131>, <0.000206834, 0.000415527, 7.95978e-05>,
                         <0.386717, 0.931429, -1.47826>, <0.000209118, 0.000415285, 8.18353e-05> }
        smooth_triangle {<0.385979, 0.925904, -1.4446>, <0.000233965, 0.000528172, 8.23397e-05>,
                         <0.387114, 0.921274, -1.41009>, <0.00024553, 0.000670936, 6.29349e-05>,
                         <0.404175, 0.916697, -1.42843>, <0.000239507, 0.000662843, 5.93529e-05> }
        smooth_triangle {<0.404175, 0.916697, -1.42843>, <0.000232635, 0.000628281, 5.95516e-05>,
                         <0.400795, 0.921713, -1.46027>, <0.000225316, 0.000525787, 7.42001e-05>,
                         <0.385979, 0.925904, -1.4446>, <0.000228478, 0.000527277, 7.67917e-05> }
        smooth_triangle {<0.387114, 0.921274, -1.41009>, <0.00024553, 0.000670936, 6.29349e-05>,
                         <0.392462, 0.917905, -1.37422>, <0.000240826, 0.000885466, 1.2848e-05>,
                         <0.411303, 0.913046, -1.39537>, <0.0002321, 0.000862105, 1.0441e-05> }
        smooth_triangle {<0.411303, 0.913046, -1.39537>, <0.000228657, 0.000820305, 1.52448e-05>,
                         <0.404175, 0.916697, -1.42843>, <0.000234213, 0.000670859, 5.19288e-05>,
                         <0.387114, 0.921274, -1.41009>, <0.00023873, 0.000676929, 5.46152e-05> }
        smooth_triangle {<0.392462, 0.917905, -1.37422>, <0.000240826, 0.000885466, 1.2848e-05>,
                         <0.407146, 0.916181, -1.33777>, <0.000204877, 0.0011621, -7.42282e-05>,
                         <0.426649, 0.911179, -1.36177>, <0.000194307, 0.00111311, -7.26084e-05> }
        smooth_triangle {<0.426649, 0.911179, -1.36177>, <0.000196414, 0.00107424, -6.4298e-05>,
                         <0.411303, 0.913046, -1.39537>, <0.000224759, 0.000885988, -2.01092e-06>,
                         <0.392462, 0.917905, -1.37422>, <0.000231304, 0.000903509, -2.05705e-07> }
        smooth_triangle {<0.407146, 0.916181, -1.33777>, <0.000204877, 0.0011621, -7.42282e-05>,
                         <0.436301, 0.916037, -1.3073>, <0.000120999, 0.00132034, -0.000168356>,
                         <0.454676, 0.911023, -1.33339>, <0.000113447, 0.00125392, -0.000160908> }
        smooth_triangle {<0.454676, 0.911023, -1.33339>, <0.000121517, 0.001247, -0.00015497>,
                         <0.426649, 0.911179, -1.36177>, <0.000182161, 0.00114139, -8.87453e-05>,
                         <0.407146, 0.916181, -1.33777>, <0.000190089, 0.00117813, -8.99601e-05> }
        smooth_triangle {<0.436301, 0.916037, -1.3073>, <0.000120999, 0.00132034, -0.000168356>,
                         <0.475891, 0.917113, -1.29353>, <1.14846e-05, 0.00117565, -0.000216057>,
                         <0.491826, 0.912188, -1.31961>, <1.12762e-05, 0.00112123, -0.000205911> }
        smooth_triangle {<0.491826, 0.912188, -1.31961>, <1.81203e-05, 0.00114645, -0.000206355>,
                         <0.454676, 0.911023, -1.33339>, <9.47485e-05, 0.00124597, -0.000172602>,
                         <0.436301, 0.916037, -1.3073>, <0.000100412, 0.00129578, -0.000178188> }
        smooth_triangle {<0.475891, 0.917113, -1.29353>, <1.14846e-05, 0.00117565, -0.000216057>,
                         <0.515139, 0.919076, -1.29343>, <-6.18049e-05, 0.000896884, -0.000211133>,
                         <0.528662, 0.914315, -1.31782>, <-5.70367e-05, 0.000866758, -0.000202609> }
        smooth_triangle {<0.528662, 0.914315, -1.31782>, <-5.44448e-05, 0.000897446, -0.000205778>,
                         <0.491826, 0.912188, -1.31961>, <-3.21013e-06, 0.0010883, -0.000208254>,
                         <0.475891, 0.917113, -1.29353>, <-3.05383e-06, 0.00112912, -0.000215864> }
        smooth_triangle {<0.515139, 0.919076, -1.29343>, <-6.18049e-05, 0.000896884, -0.000211133>,
                         <0.551853, 0.921777, -1.29942>, <-9.38489e-05, 0.000693579, -0.000194166>,
                         <0.56326, 0.917242, -1.32137>, <-8.7658e-05, 0.00067768, -0.000187663> }
        smooth_triangle {<0.56326, 0.917242, -1.32137>, <-8.78091e-05, 0.000707248, -0.000191818>,
                         <0.528662, 0.914315, -1.31782>, <-6.48432e-05, 0.000849057, -0.000203028>,
                         <0.515139, 0.919076, -1.29343>, <-6.84193e-05, 0.000871651, -0.000209421> }
        smooth_triangle {<0.551853, 0.921777, -1.29942>, <-9.38489e-05, 0.000693579, -0.000194166>,
                         <0.586766, 0.925189, -1.30813>, <-0.000107319, 0.00054927, -0.000176876>,
                         <0.596256, 0.920938, -1.32732>, <-0.000101236, 0.000540192, -0.000171855> }
        smooth_triangle {<0.596256, 0.920938, -1.32732>, <-0.000102956, 0.00056924, -0.000176847>,
                         <0.56326, 0.917242, -1.32137>, <-9.27727e-05, 0.000672355, -0.000188702>,
                         <0.551853, 0.921777, -1.29942>, <-9.74159e-05, 0.00068428, -0.00019358> }
        smooth_triangle {<0.586766, 0.925189, -1.30813>, <-0.000107319, 0.00054927, -0.000176876>,
                         <0.620248, 0.929504, -1.31857>, <-0.000114245, 0.000425767, -0.000158143>,
                         <0.627958, 0.925613, -1.3348>, <-0.000109014, 0.000420639, -0.000154429> }
        smooth_triangle {<0.627958, 0.925613, -1.3348>, <-0.000112131, 0.000449771, -0.000160605>,
                         <0.596256, 0.920938, -1.32732>, <-0.000106298, 0.000539436, -0.000173674>,
                         <0.586766, 0.925189, -1.30813>, <-0.00011086, 0.000546245, -0.00017744> }
        smooth_triangle {<0.620248, 0.929504, -1.31857>, <-0.000114245, 0.000425767, -0.000158143>,
                         <0.652083, 0.935171, -1.33067>, <-0.000116353, 0.000307727, -0.000135212>,
                         <0.658132, 0.931752, -1.3438>, <-0.000112455, 0.000305453, -0.000132825> }
        smooth_triangle {<0.658132, 0.931752, -1.3438>, <-0.000118012, 0.000334206, -0.000140808>,
                         <0.627958, 0.925613, -1.3348>, <-0.000115431, 0.000420595, -0.000157011>,
                         <0.620248, 0.929504, -1.31857>, <-0.000119354, 0.000424441, -0.000159796> }
        smooth_triangle {<0.652083, 0.935171, -1.33067>, <-0.000116353, 0.000307727, -0.000135212>,
                         <0.681729, 0.942629, -1.34469>, <-0.000108385, 0.000196602, -0.000105809>,
                         <0.686234, 0.939831, -1.35459>, <-0.000106042, 0.000196199, -0.000104629> }
        smooth_triangle {<0.686234, 0.939831, -1.35459>, <-0.000115281, 0.000223104, -0.000114713>,
                         <0.658132, 0.931752, -1.3438>, <-0.000120091, 0.000305044, -0.00013586>,
                         <0.652083, 0.935171, -1.33067>, <-0.000123014, 0.000306749, -0.00013765> }
        smooth_triangle {<0.681729, 0.942629, -1.34469>, <-0.000108385, 0.000196602, -0.000105809>,
                         <0.708614, 0.952336, -1.36084>, <-8.34601e-05, 0.000102749, -6.94659e-05>,
                         <0.711637, 0.950347, -1.36743>, <-8.25817e-05, 0.000102929, -6.91175e-05> }
        smooth_triangle {<0.711637, 0.950347, -1.36743>, <-9.69474e-05, 0.000125597, -8.14506e-05>,
                         <0.686234, 0.939831, -1.35459>, <-0.000114543, 0.00019555, -0.000108085>,
                         <0.681729, 0.942629, -1.34469>, <-0.0001163, 0.000195852, -0.000108969> }
        smooth_triangle {<0.708614, 0.952336, -1.36084>, <-8.34601e-05, 0.000102749, -6.94659e-05>,
                         <0.732694, 0.964017, -1.379>, <-3.76866e-05, 3.45939e-05, -2.7694e-05>,
                         <0.734218, 0.963002, -1.38229>, <-3.76474e-05, 3.4631e-05, -2.76873e-05> }
        smooth_triangle {<0.734218, 0.963002, -1.38229>, <-5.64844e-05, 5.19751e-05, -4.15577e-05>,
                         <0.711637, 0.950347, -1.36743>, <-9.01851e-05, 0.000103199, -7.26304e-05>,
                         <0.708614, 0.952336, -1.36084>, <-9.08439e-05, 0.000103064, -7.28917e-05> }
        smooth_triangle {<0.732694, 0.964017, -1.379>, <-3.76866e-05, 3.45939e-05, -2.7694e-05>,
                         <0.754783, 0.976842, -1.39854>, <9.2592e-07, 8.68969e-07, 1.50406e-06>,
                         <0.754759, 0.976895, -1.39855>, <7.34826e-07, 7.66737e-07, 1.44708e-06> }
        smooth_triangle {<0.754759, 0.976895, -1.39855>, <-2.02503e-05, 1.47714e-05, -1.30475e-05>,
                         <0.734218, 0.963002, -1.38229>, <-4.37907e-05, 3.66685e-05, -3.12746e-05>,
                         <0.732694, 0.964017, -1.379>, <-4.38201e-05, 3.66406e-05, -3.12796e-05> }
        smooth_triangle {<0.408919, 0.976789, -1.6354>, <6.16633e-05, 4.98321e-05, 3.67709e-05>,
                         <0.398963, 0.965464, -1.60336>, <7.9272e-05, 7.20354e-05, 4.53761e-05>,
                         <0.401351, 0.964488, -1.60604>, <7.92657e-05, 7.18542e-05, 4.54366e-05> }
        smooth_triangle {<0.401351, 0.964488, -1.60604>, <5.8882e-05, 5.46183e-05, 3.42361e-05>,
                         <0.409003, 0.976842, -1.63534>, <2.97402e-05, 2.61894e-05, 1.88073e-05>,
                         <0.408919, 0.976789, -1.6354>, <2.96971e-05, 2.63714e-05, 1.87027e-05> }
        smooth_triangle {<0.398963, 0.965464, -1.60336>, <7.9272e-05, 7.20354e-05, 4.53761e-05>,
                         <0.390729, 0.955628, -1.57015>, <0.00012723, 0.000143996, 6.71661e-05>,
                         <0.395547, 0.953758, -1.57549>, <0.000126783, 0.000144455, 6.66012e-05> }
        smooth_triangle {<0.395547, 0.953758, -1.57549>, <0.000109741, 0.000122694, 5.77748e-05>,
                         <0.401351, 0.964488, -1.60604>, <7.41024e-05, 6.8243e-05, 4.19013e-05>,
                         <0.398963, 0.965464, -1.60336>, <7.4107e-05, 6.83789e-05, 4.1856e-05> }
        smooth_triangle {<0.390729, 0.955628, -1.57015>, <0.00012723, 0.000143996, 6.71661e-05>,
                         <0.384172, 0.947641, -1.53584>, <0.000162567, 0.00022955, 7.858e-05>,
                         <0.391513, 0.945044, -1.54376>, <0.000161307, 0.000230659, 7.70477e-05> }
        smooth_triangle {<0.391513, 0.945044, -1.54376>, <0.000147439, 0.00020584, 7.01691e-05>,
                         <0.395547, 0.953758, -1.57549>, <0.000121546, 0.000141187, 6.23341e-05>,
                         <0.390729, 0.955628, -1.57015>, <0.000121881, 0.000140843, 6.27578e-05> }
        smooth_triangle {<0.384172, 0.947641, -1.53584>, <0.000162567, 0.00022955, 7.858e-05>,
                         <0.378762, 0.940978, -1.5008>, <0.000191579, 0.000320396, 8.57256e-05>,
                         <0.388647, 0.937775, -1.51128>, <0.000189437, 0.00032155, 8.33532e-05> }
        smooth_triangle {<0.388647, 0.937775, -1.51128>, <0.000177547, 0.000295093, 7.7717e-05>,
                         <0.391513, 0.945044, -1.54376>, <0.000156449, 0.000226925, 7.29879e-05>,
                         <0.384172, 0.947641, -1.53584>, <0.000157394, 0.000226093, 7.41371e-05> }
        smooth_triangle {<0.378762, 0.940978, -1.5008>, <0.000191579, 0.000320396, 8.57256e-05>,
                         <0.374324, 0.93516, -1.4652>, <0.000217213, 0.000417811, 8.94698e-05>,
                         <0.386717, 0.931429, -1.47826>, <0.000214167, 0.000418134, 8.64866e-05> }
        smooth_triangle {<0.386717, 0.931429, -1.47826>, <0.000203695, 0.00039015, 8.20928e-05>,
                         <0.388647, 0.937775, -1.51128>, <0.000185148, 0.000317712, 7.97428e-05>,
                         <0.378762, 0.940978, -1.5008>, <0.000186754, 0.000316846, 8.1522e-05> }
        smooth_triangle {<0.374324, 0.93516, -1.4652>, <0.000217213, 0.000417811, 8.94698e-05>,
                         <0.371163, 0.930096, -1.42893>, <0.000238181, 0.000530159, 8.57951e-05>,
                         <0.385979, 0.925904, -1.4446>, <0.000233965, 0.000528172, 8.23397e-05> }
        smooth_triangle {<0.385979, 0.925904, -1.4446>, <0.0002249, 0.000497994, 7.9559e-05>,
                         <0.386717, 0.931429, -1.47826>, <0.000210051, 0.000415465, 8.26691e-05>,
                         <0.374324, 0.93516, -1.4652>, <0.000212336, 0.000415223, 8.49065e-05> }
        smooth_triangle {<0.371163, 0.930096, -1.42893>, <0.000238181, 0.000530159, 8.57951e-05>,
                         <0.370052, 0.925852, -1.39174>, <0.000251553, 0.000679029, 6.65168e-05>,
                         <0.387114, 0.921274, -1.41009>, <0.00024553, 0.000670936, 6.29349e-05> }
        smooth_triangle {<0.387114, 0.921274, -1.41009>, <0.000238448, 0.000635479, 6.31619e-05>,
                         <0.385979, 0.925904, -1.4446>, <0.000229774, 0.000528406, 7.77155e-05>,
                         <0.371163, 0.930096, -1.42893>, <0.000232936, 0.000529896, 8.0307e-05> }
        smooth_triangle {<0.370052, 0.925852, -1.39174>, <0.000251553, 0.000679029, 6.65168e-05>,
                         <0.373621, 0.922763, -1.35306>, <0.000249553, 0.000908827, 1.52549e-05>,
                         <0.392462, 0.917905, -1.37422>, <0.000240826, 0.000885466, 1.2848e-05> }
        smooth_triangle {<0.392462, 0.917905, -1.37422>, <0.000237127, 0.000841638, 1.78888e-05>,
                         <0.387114, 0.921274, -1.41009>, <0.000240655, 0.000680741, 5.5454e-05>,
                         <0.370052, 0.925852, -1.39174>, <0.000245172, 0.000686811, 5.81404e-05> }
        smooth_triangle {<0.373621, 0.922763, -1.35306>, <0.000249553, 0.000908827, 1.52549e-05>,
                         <0.387643, 0.921182, -1.31378>, <0.000215448, 0.00121108, -7.58479e-05>,
                         <0.407146, 0.916181, -1.33777>, <0.000204877, 0.0011621, -7.42282e-05> }
        smooth_triangle {<0.407146, 0.916181, -1.33777>, <0.000207037, 0.00112088, -6.53852e-05>,
                         <0.392462, 0.917905, -1.37422>, <0.000233999, 0.000913405, -7.80866e-08>,
                         <0.373621, 0.922763, -1.35306>, <0.000240543, 0.000930926, 1.72712e-06> }
        smooth_triangle {<0.387643, 0.921182, -1.31378>, <0.000215448, 0.00121108, -7.58479e-05>,
                         <0.417927, 0.921051, -1.28122>, <0.00012855, 0.00138676, -0.000175804>,
                         <0.436301, 0.916037, -1.3073>, <0.000120999, 0.00132034, -0.000168356> }
        smooth_triangle {<0.436301, 0.916037, -1.3073>, <0.000129718, 0.00131376, -0.000162026>,
                         <0.407146, 0.916181, -1.33777>, <0.000192627, 0.00119508, -9.14301e-05>,
                         <0.387643, 0.921182, -1.31378>, <0.000200555, 0.00123182, -9.26449e-05> }
        smooth_triangle {<0.417927, 0.921051, -1.28122>, <0.00012855, 0.00138676, -0.000175804>,
                         <0.459956, 0.922037, -1.26744>, <1.1693e-05, 0.00123008, -0.000226203>,
                         <0.475891, 0.917113, -1.29353>, <1.14846e-05, 0.00117565, -0.000216057> }
        smooth_triangle {<0.475891, 0.917113, -1.29353>, <1.88653e-05, 0.00120319, -0.00021661>,
                         <0.436301, 0.916037, -1.3073>, <0.000101001, 0.00131171, -0.000180834>,
                         <0.417927, 0.921051, -1.28122>, <0.000106665, 0.00136152, -0.00018642> }
        smooth_triangle {<0.459956, 0.922037, -1.26744>, <1.1693e-05, 0.00123008, -0.000226203>,
                         <0.501616, 0.923837, -1.26904>, <-6.6573e-05, 0.00092701, -0.000219656>,
                         <0.515139, 0.919076, -1.29343>, <-6.18049e-05, 0.000896884, -0.000211133> }
        smooth_triangle {<0.515139, 0.919076, -1.29343>, <-5.9042e-05, 0.000929015, -0.000214488>,
                         <0.475891, 0.917113, -1.29353>, <-4.0749e-06, 0.00113809, -0.000218181>,
                         <0.459956, 0.922037, -1.26744>, <-3.9186e-06, 0.00117891, -0.000225791> }
        smooth_triangle {<0.501616, 0.923837, -1.26904>, <-6.6573e-05, 0.00092701, -0.000219656>,
                         <0.540445, 0.926313, -1.27747>, <-0.00010004, 0.000709477, -0.000200668>,
                         <0.551853, 0.921777, -1.29942>, <-9.38489e-05, 0.000693579, -0.000194166> }
        smooth_triangle {<0.551853, 0.921777, -1.29942>, <-9.39863e-05, 0.000723817, -0.000198452>,
                         <0.515139, 0.919076, -1.29343>, <-6.99533e-05, 0.000876296, -0.000211178>,
                         <0.501616, 0.923837, -1.26904>, <-7.35294e-05, 0.000898891, -0.00021757> }
        smooth_triangle {<0.540445, 0.926313, -1.27747>, <-0.00010004, 0.000709477, -0.000200668>,
                         <0.577276, 0.929441, -1.28895>, <-0.000113401, 0.000558348, -0.000181897>,
                         <0.586766, 0.925189, -1.30813>, <-0.000107319, 0.00054927, -0.000176876> }
        smooth_triangle {<0.586766, 0.925189, -1.30813>, <-0.000109094, 0.000578682, -0.000181975>,
                         <0.551853, 0.921777, -1.29942>, <-9.89911e-05, 0.000686913, -0.000194942>,
                         <0.540445, 0.926313, -1.27747>, <-0.000103634, 0.000698837, -0.000199819> }
        smooth_triangle {<0.577276, 0.929441, -1.28895>, <-0.000113401, 0.000558348, -0.000181897>,
                         <0.612539, 0.933396, -1.30233>, <-0.000119476, 0.000430895, -0.000161856>,
                         <0.620248, 0.929504, -1.31857>, <-0.000114245, 0.000425767, -0.000158143> }
        smooth_triangle {<0.620248, 0.929504, -1.31857>, <-0.000117466, 0.000455159, -0.00016443>,
                         <0.586766, 0.925189, -1.30813>, <-0.000112271, 0.000547786, -0.00017848>,
                         <0.577276, 0.929441, -1.28895>, <-0.000116833, 0.000554594, -0.000182245> }
        smooth_triangle {<0.612539, 0.933396, -1.30233>, <-0.000119476, 0.000430895, -0.000161856>,
                         <0.646035, 0.938591, -1.31753>, <-0.000120251, 0.00031, -0.0001376>,
                         <0.652083, 0.935171, -1.33067>, <-0.000116353, 0.000307727, -0.000135212> }
        smooth_triangle {<0.652083, 0.935171, -1.33067>, <-0.000122035, 0.000336674, -0.000143304>,
                         <0.620248, 0.929504, -1.31857>, <-0.000120454, 0.000425205, -0.000160502>,
                         <0.612539, 0.933396, -1.30233>, <-0.000124378, 0.000429051, -0.000163287> }
        smooth_triangle {<0.646035, 0.938591, -1.31753>, <-0.000120251, 0.00031, -0.0001376>,
                         <0.677223, 0.945427, -1.33479>, <-0.000110728, 0.000197004, -0.000106989>,
                         <0.681729, 0.942629, -1.34469>, <-0.000108385, 0.000196602, -0.000105809> }
        smooth_triangle {<0.681729, 0.942629, -1.34469>, <-0.000117762, 0.000223584, -0.000115978>,
                         <0.652083, 0.935171, -1.33067>, <-0.000123738, 0.000306927, -0.00013803>,
                         <0.646035, 0.938591, -1.31753>, <-0.000126661, 0.000308632, -0.00013982> }
        smooth_triangle {<0.677223, 0.945427, -1.33479>, <-0.000110728, 0.000197004, -0.000106989>,
                         <0.705591, 0.954325, -1.35424>, <-8.43385e-05, 0.000102569, -6.98143e-05>,
                         <0.708614, 0.952336, -1.36084>, <-8.34601e-05, 0.000102749, -6.94659e-05> }
        smooth_triangle {<0.708614, 0.952336, -1.36084>, <-9.79163e-05, 0.000125408, -8.18377e-05>,
                         <0.681729, 0.942629, -1.34469>, <-0.00011661, 0.000195798, -0.000109095>,
                         <0.677223, 0.945427, -1.33479>, <-0.000118367, 0.0001961, -0.00010998> }
        smooth_triangle {<0.705591, 0.954325, -1.35424>, <-8.43385e-05, 0.000102569, -6.98143e-05>,
                         <0.73117, 0.965033, -1.37571>, <-3.77258e-05, 3.45569e-05, -2.77007e-05>,
                         <0.732694, 0.964017, -1.379>, <-3.76866e-05, 3.45939e-05, -2.7694e-05> }
        smooth_triangle {<0.732694, 0.964017, -1.379>, <-5.65523e-05, 5.19206e-05, -4.15724e-05>,
                         <0.708614, 0.952336, -1.36084>, <-9.08825e-05, 0.000103037, -7.29014e-05>,
                         <0.705591, 0.954325, -1.35424>, <-9.15413e-05, 0.000102902, -7.31627e-05> }
        smooth_triangle {<0.73117, 0.965033, -1.37571>, <-3.77258e-05, 3.45569e-05, -2.77007e-05>,
                         <0.754807, 0.976789, -1.39852>, <1.11701e-06, 9.712e-07, 1.56104e-06>,
                         <0.754783, 0.976842, -1.39854>, <9.2592e-07, 8.68969e-07, 1.50406e-06> }
        smooth_triangle {<0.754783, 0.976842, -1.39854>, <-2.00592e-05, 1.48736e-05, -1.29905e-05>,
                         <0.732694, 0.964017, -1.379>, <-4.37723e-05, 3.66662e-05, -3.12654e-05>,
                         <0.73117, 0.965033, -1.37571>, <-4.38017e-05, 3.66384e-05, -3.12704e-05> }
        smooth_triangle {<0.408835, 0.976735, -1.63546>, <6.15772e-05, 5.01959e-05, 3.65617e-05>,
                         <0.396574, 0.96644, -1.60067>, <7.92782e-05, 7.22167e-05, 4.53157e-05>,
                         <0.398963, 0.965464, -1.60336>, <7.9272e-05, 7.20354e-05, 4.53761e-05> }
        smooth_triangle {<0.398963, 0.965464, -1.60336>, <5.88652e-05, 5.48452e-05, 3.41385e-05>,
                         <0.408919, 0.976789, -1.6354>, <2.96541e-05, 2.65533e-05, 1.85982e-05>,
                         <0.408835, 0.976735, -1.63546>, <2.9611e-05, 2.67352e-05, 1.84936e-05> }
        smooth_triangle {<0.396574, 0.96644, -1.60067>, <7.92782e-05, 7.22167e-05, 4.53157e-05>,
                         <0.38591, 0.957499, -1.56482>, <0.000127677, 0.000143537, 6.7731e-05>,
                         <0.390729, 0.955628, -1.57015>, <0.00012723, 0.000143996, 6.71661e-05> }
        smooth_triangle {<0.390729, 0.955628, -1.57015>, <0.000110124, 0.000122303, 5.82577e-05>,
                         <0.398963, 0.965464, -1.60336>, <7.41548e-05, 6.83329e-05, 4.19153e-05>,
                         <0.396574, 0.96644, -1.60067>, <7.41594e-05, 6.84688e-05, 4.18699e-05> }
        smooth_triangle {<0.38591, 0.957499, -1.56482>, <0.000127677, 0.000143537, 6.7731e-05>,
                         <0.37683, 0.950237, -1.52792>, <0.000163827, 0.000228441, 8.01122e-05>,
                         <0.384172, 0.947641, -1.53584>, <0.000162567, 0.00022955, 7.858e-05> }
        smooth_triangle {<0.384172, 0.947641, -1.53584>, <0.000148624, 0.000204756, 7.16234e-05>,
                         <0.390729, 0.955628, -1.57015>, <0.000122121, 0.00014059, 6.30631e-05>,
                         <0.38591, 0.957499, -1.56482>, <0.000122457, 0.000140246, 6.34867e-05> }
        smooth_triangle {<0.37683, 0.950237, -1.52792>, <0.000163827, 0.000228441, 8.01122e-05>,
                         <0.368878, 0.94418, -1.49032>, <0.00019372, 0.000319241, 8.80979e-05>,
                         <0.378762, 0.940978, -1.5008>, <0.000191579, 0.000320396, 8.57256e-05> }
        smooth_triangle {<0.378762, 0.940978, -1.5008>, <0.000179619, 0.0002939, 8.0035e-05>,
                         <0.384172, 0.947641, -1.53584>, <0.00015786, 0.000225766, 7.46758e-05>,
                         <0.37683, 0.950237, -1.52792>, <0.000158805, 0.000224934, 7.5825e-05> }
        smooth_triangle {<0.368878, 0.94418, -1.49032>, <0.00019372, 0.000319241, 8.80979e-05>,
                         <0.361931, 0.938891, -1.45214>, <0.000220258, 0.000417488, 9.2453e-05>,
                         <0.374324, 0.93516, -1.4652>, <0.000217213, 0.000417811, 8.94698e-05> }
        smooth_triangle {<0.374324, 0.93516, -1.4652>, <0.000206655, 0.000389696, 8.5032e-05>,
                         <0.378762, 0.940978, -1.5008>, <0.00018743, 0.000316635, 8.22238e-05>,
                         <0.368878, 0.94418, -1.49032>, <0.000189036, 0.000315769, 8.40031e-05> }
        smooth_triangle {<0.361931, 0.938891, -1.45214>, <0.000220258, 0.000417488, 9.2453e-05>,
                         <0.356347, 0.934288, -1.41327>, <0.000242397, 0.000532146, 8.92505e-05>,
                         <0.371163, 0.930096, -1.42893>, <0.000238181, 0.000530159, 8.57951e-05> }
        smooth_triangle {<0.371163, 0.930096, -1.42893>, <0.000228994, 0.000499665, 8.29844e-05>,
                         <0.374324, 0.93516, -1.4652>, <0.000213268, 0.000415404, 8.57404e-05>,
                         <0.361931, 0.938891, -1.45214>, <0.000215553, 0.000415162, 8.79778e-05> }
        smooth_triangle {<0.356347, 0.934288, -1.41327>, <0.000242397, 0.000532146, 8.92505e-05>,
                         <0.352991, 0.930429, -1.3734>, <0.000257576, 0.000687122, 7.00987e-05>,
                         <0.370052, 0.925852, -1.39174>, <0.000251553, 0.000679029, 6.65168e-05> }
        smooth_triangle {<0.370052, 0.925852, -1.39174>, <0.000244262, 0.000642678, 6.67721e-05>,
                         <0.371163, 0.930096, -1.42893>, <0.000234232, 0.000531025, 8.12309e-05>,
                         <0.356347, 0.934288, -1.41327>, <0.000237394, 0.000532515, 8.38224e-05> }
        smooth_triangle {<0.352991, 0.930429, -1.3734>, <0.000257576, 0.000687122, 7.00987e-05>,
                         <0.35478, 0.927621, -1.33191>, <0.000258279, 0.000932188, 1.76619e-05>,
                         <0.373621, 0.922763, -1.35306>, <0.000249553, 0.000908827, 1.52549e-05> }
        smooth_triangle {<0.373621, 0.922763, -1.35306>, <0.000245596, 0.000862971, 2.05329e-05>,
                         <0.370052, 0.925852, -1.39174>, <0.000247097, 0.000690623, 5.89792e-05>,
                         <0.352991, 0.930429, -1.3734>, <0.000251614, 0.000696693, 6.16657e-05> }
        smooth_triangle {<0.35478, 0.927621, -1.33191>, <0.000258279, 0.000932188, 1.76619e-05>,
                         <0.368139, 0.926184, -1.28978>, <0.000226018, 0.00126007, -7.74676e-05>,
                         <0.387643, 0.921182, -1.31378>, <0.000215448, 0.00121108, -7.58479e-05> }
        smooth_triangle {<0.387643, 0.921182, -1.31378>, <0.00021766, 0.00116752, -6.64724e-05>,
                         <0.373621, 0.922763, -1.35306>, <0.000243239, 0.000940822, 1.85474e-06>,
                         <0.35478, 0.927621, -1.33191>, <0.000249783, 0.000958343, 3.65995e-06> }
        smooth_triangle {<0.368139, 0.926184, -1.28978>, <0.000226018, 0.00126007, -7.74676e-05>,
                         <0.399552, 0.926065, -1.25513>, <0.000136102, 0.00145318, -0.000183252>,
                         <0.417927, 0.921051, -1.28122>, <0.00012855, 0.00138676, -0.000175804> }
        smooth_triangle {<0.417927, 0.921051, -1.28122>, <0.000137919, 0.00138052, -0.000169082>,
                         <0.387643, 0.921182, -1.31378>, <0.000203092, 0.00124877, -9.41149e-05>,
                         <0.368139, 0.926184, -1.28978>, <0.00021102, 0.00128551, -9.53297e-05> }
        smooth_triangle {<0.399552, 0.926065, -1.25513>, <0.000136102, 0.00145318, -0.000183252>,
                         <0.444021, 0.926961, -1.24135>, <1.19014e-05, 0.0012845, -0.000236349>,
                         <0.459956, 0.922037, -1.26744>, <1.1693e-05, 0.00123008, -0.000226203> }
        smooth_triangle {<0.459956, 0.922037, -1.26744>, <1.96102e-05, 0.00125993, -0.000226865>,
                         <0.417927, 0.921051, -1.28122>, <0.000107253, 0.00137744, -0.000189066>,
                         <0.399552, 0.926065, -1.25513>, <0.000112917, 0.00142726, -0.000194652> }
        smooth_triangle {<0.444021, 0.926961, -1.24135>, <1.19014e-05, 0.0012845, -0.000236349>,
                         <0.488093, 0.928597, -1.24465>, <-7.13412e-05, 0.000957136, -0.000228179>,
                         <0.501616, 0.923837, -1.26904>, <-6.6573e-05, 0.00092701, -0.000219656> }
        smooth_triangle {<0.501616, 0.923837, -1.26904>, <-6.36392e-05, 0.000960584, -0.000223198>,
                         <0.459956, 0.922037, -1.26744>, <-4.93967e-06, 0.00118788, -0.000228108>,
                         <0.444021, 0.926961, -1.24135>, <-4.78337e-06, 0.0012287, -0.000235718> }
        smooth_triangle {<0.488093, 0.928597, -1.24465>, <-7.13412e-05, 0.000957136, -0.000228179>,
                         <0.529038, 0.930849, -1.25552>, <-0.000106231, 0.000725376, -0.000207171>,
                         <0.540445, 0.926313, -1.27747>, <-0.00010004, 0.000709477, -0.000200668> }
        smooth_triangle {<0.540445, 0.926313, -1.27747>, <-0.000100163, 0.000740387, -0.000205086>,
                         <0.501616, 0.923837, -1.26904>, <-7.50634e-05, 0.000903536, -0.000219327>,
                         <0.488093, 0.928597, -1.24465>, <-7.86395e-05, 0.000926131, -0.00022572> }
        smooth_triangle {<0.529038, 0.930849, -1.25552>, <-0.000106231, 0.000725376, -0.000207171>,
                         <0.567785, 0.933692, -1.26976>, <-0.000119484, 0.000567426, -0.000186917>,
                         <0.577276, 0.929441, -1.28895>, <-0.000113401, 0.000558348, -0.000181897> }
        smooth_triangle {<0.577276, 0.929441, -1.28895>, <-0.000115231, 0.000588124, -0.000187104>,
                         <0.540445, 0.926313, -1.27747>, <-0.00010521, 0.000701471, -0.000201182>,
                         <0.529038, 0.930849, -1.25552>, <-0.000109853, 0.000713395, -0.000206059> }
        smooth_triangle {<0.567785, 0.933692, -1.26976>, <-0.000119484, 0.000567426, -0.000186917>,
                         <0.60483, 0.937288, -1.2861>, <-0.000124707, 0.000436024, -0.00016557>,
                         <0.612539, 0.933396, -1.30233>, <-0.000119476, 0.000430895, -0.000161856> }
        smooth_triangle {<0.612539, 0.933396, -1.30233>, <-0.000122801, 0.000460546, -0.000168255>,
                         <0.577276, 0.929441, -1.28895>, <-0.000118245, 0.000556136, -0.000183285>,
                         <0.567785, 0.933692, -1.26976>, <-0.000122807, 0.000562944, -0.000187051> }
        smooth_triangle {<0.60483, 0.937288, -1.2861>, <-0.000124707, 0.000436024, -0.00016557>,
                         <0.639986, 0.94201, -1.3044>, <-0.000124149, 0.000312274, -0.000139987>,
                         <0.646035, 0.938591, -1.31753>, <-0.000120251, 0.00031, -0.0001376> }
        smooth_triangle {<0.646035, 0.938591, -1.31753>, <-0.000126059, 0.000339143, -0.0001458>,
                         <0.612539, 0.933396, -1.30233>, <-0.000125478, 0.000429815, -0.000163992>,
                         <0.60483, 0.937288, -1.2861>, <-0.000129401, 0.000433661, -0.000166777> }
        smooth_triangle {<0.639986, 0.94201, -1.3044>, <-0.000124149, 0.000312274, -0.000139987>,
                         <0.672718, 0.948225, -1.32489>, <-0.00011307, 0.000197406, -0.000108169>,
                         <0.677223, 0.945427, -1.33479>, <-0.000110728, 0.000197004, -0.000106989> }
        smooth_triangle {<0.677223, 0.945427, -1.33479>, <-0.000120242, 0.000224063, -0.000117242>,
                         <0.646035, 0.938591, -1.31753>, <-0.000127385, 0.00030881, -0.0001402>,
                         <0.639986, 0.94201, -1.3044>, <-0.000130308, 0.000310515, -0.00014199> }
        smooth_triangle {<0.672718, 0.948225, -1.32489>, <-0.00011307, 0.000197406, -0.000108169>,
                         <0.702568, 0.956314, -1.34765>, <-8.52169e-05, 0.000102389, -7.01627e-05>,
                         <0.705591, 0.954325, -1.35424>, <-8.43385e-05, 0.000102569, -6.98143e-05> }
        smooth_triangle {<0.705591, 0.954325, -1.35424>, <-9.88852e-05, 0.000125219, -8.22248e-05>,
                         <0.677223, 0.945427, -1.33479>, <-0.000118677, 0.000196045, -0.000110106>,
                         <0.672718, 0.948225, -1.32489>, <-0.000120434, 0.000196347, -0.000110991> }
        smooth_triangle {<0.702568, 0.956314, -1.34765>, <-8.52169e-05, 0.000102389, -7.01627e-05>,
                         <0.729646, 0.966048, -1.37242>, <-3.77649e-05, 3.45198e-05, -2.77074e-05>,
                         <0.73117, 0.965033, -1.37571>, <-3.77258e-05, 3.45569e-05, -2.77007e-05> }
        smooth_triangle {<0.73117, 0.965033, -1.37571>, <-5.66203e-05, 5.18661e-05, -4.1587e-05>,
                         <0.705591, 0.954325, -1.35424>, <-9.15799e-05, 0.000102875, -7.31723e-05>,
                         <0.702568, 0.956314, -1.34765>, <-9.22387e-05, 0.00010274, -7.34336e-05> }
        smooth_triangle {<0.729646, 0.966048, -1.37242>, <-3.77649e-05, 3.45198e-05, -2.77074e-05>,
                         <0.75483, 0.976735, -1.3985>, <1.30811e-06, 1.07343e-06, 1.61801e-06>,
                         <0.754807, 0.976789, -1.39852>, <1.11701e-06, 9.712e-07, 1.56104e-06> }
        smooth_triangle {<0.754807, 0.976789, -1.39852>, <-1.98682e-05, 1.49759e-05, -1.29335e-05>,
                         <0.73117, 0.965033, -1.37571>, <-4.37539e-05, 3.66639e-05, -3.12562e-05>,
                         <0.729646, 0.966048, -1.37242>, <-4.37833e-05, 3.66361e-05, -3.12612e-05> }
        smooth_triangle {<0.40875, 0.976682, -1.63552>, <6.14911e-05, 5.05597e-05, 3.63526e-05>,
                         <0.394185, 0.967417, -1.59799>, <7.92844e-05, 7.23979e-05, 4.52553e-05>,
                         <0.396574, 0.96644, -1.60067>, <7.92782e-05, 7.22167e-05, 4.53157e-05> }
        smooth_triangle {<0.396574, 0.96644, -1.60067>, <5.88483e-05, 5.50721e-05, 3.40409e-05>,
                         <0.408835, 0.976735, -1.63546>, <2.9568e-05, 2.69171e-05, 1.8389e-05>,
                         <0.40875, 0.976682, -1.63552>, <2.95249e-05, 2.7099e-05, 1.82845e-05> }
        smooth_triangle {<0.394185, 0.967417, -1.59799>, <7.92844e-05, 7.23979e-05, 4.52553e-05>,
                         <0.381091, 0.959369, -1.55948>, <0.000128125, 0.000143078, 6.8296e-05>,
                         <0.38591, 0.957499, -1.56482>, <0.000127677, 0.000143537, 6.7731e-05> }
        smooth_triangle {<0.38591, 0.957499, -1.56482>, <0.000110507, 0.000121913, 5.87407e-05>,
                         <0.396574, 0.96644, -1.60067>, <7.42072e-05, 6.84228e-05, 4.19292e-05>,
                         <0.394185, 0.967417, -1.59799>, <7.42118e-05, 6.85587e-05, 4.18839e-05> }
        smooth_triangle {<0.381091, 0.959369, -1.55948>, <0.000128125, 0.000143078, 6.8296e-05>,
                         <0.369488, 0.952834, -1.52>, <0.000165087, 0.000227331, 8.16444e-05>,
                         <0.37683, 0.950237, -1.52792>, <0.000163827, 0.000228441, 8.01122e-05> }
        smooth_triangle {<0.37683, 0.950237, -1.52792>, <0.000149809, 0.000203671, 7.30778e-05>,
                         <0.38591, 0.957499, -1.56482>, <0.000122697, 0.000139994, 6.3792e-05>,
                         <0.381091, 0.959369, -1.55948>, <0.000123032, 0.000139649, 6.42156e-05> }
        smooth_triangle {<0.369488, 0.952834, -1.52>, <0.000165087, 0.000227331, 8.16444e-05>,
                         <0.358994, 0.947383, -1.47984>, <0.000195862, 0.000318086, 9.04702e-05>,
                         <0.368878, 0.94418, -1.49032>, <0.00019372, 0.000319241, 8.80979e-05> }
        smooth_triangle {<0.368878, 0.94418, -1.49032>, <0.00018169, 0.000292707, 8.2353e-05>,
                         <0.37683, 0.950237, -1.52792>, <0.00015927, 0.000224607, 7.63637e-05>,
                         <0.369488, 0.952834, -1.52>, <0.000160215, 0.000223775, 7.75128e-05> }
        smooth_triangle {<0.358994, 0.947383, -1.47984>, <0.000195862, 0.000318086, 9.04702e-05>,
                         <0.349538, 0.942623, -1.43909>, <0.000223304, 0.000417165, 9.54362e-05>,
                         <0.361931, 0.938891, -1.45214>, <0.000220258, 0.000417488, 9.2453e-05> }
        smooth_triangle {<0.361931, 0.938891, -1.45214>, <0.000209615, 0.000389242, 8.79712e-05>,
                         <0.368878, 0.94418, -1.49032>, <0.000189712, 0.000315557, 8.47048e-05>,
                         <0.358994, 0.947383, -1.47984>, <0.000191318, 0.000314691, 8.64841e-05> }
        smooth_triangle {<0.349538, 0.942623, -1.43909>, <0.000223304, 0.000417165, 9.54362e-05>,
                         <0.341531, 0.938479, -1.3976>, <0.000246612, 0.000534132, 9.27058e-05>,
                         <0.356347, 0.934288, -1.41327>, <0.000242397, 0.000532146, 8.92505e-05> }
        smooth_triangle {<0.356347, 0.934288, -1.41327>, <0.000233089, 0.000501335, 8.64098e-05>,
                         <0.361931, 0.938891, -1.45214>, <0.000216485, 0.000415342, 8.88117e-05>,
                         <0.349538, 0.942623, -1.43909>, <0.00021877, 0.0004151, 9.10491e-05> }
        smooth_triangle {<0.341531, 0.938479, -1.3976>, <0.000246612, 0.000534132, 9.27058e-05>,
                         <0.335929, 0.935007, -1.35505>, <0.000263599, 0.000695216, 7.36806e-05>,
                         <0.352991, 0.930429, -1.3734>, <0.000257576, 0.000687122, 7.00987e-05> }
        smooth_triangle {<0.352991, 0.930429, -1.3734>, <0.000250075, 0.000649877, 7.03824e-05>,
                         <0.356347, 0.934288, -1.41327>, <0.00023869, 0.000533644, 8.47462e-05>,
                         <0.341531, 0.938479, -1.3976>, <0.000241852, 0.000535134, 8.73378e-05> }
        smooth_triangle {<0.335929, 0.935007, -1.35505>, <0.000263599, 0.000695216, 7.36806e-05>,
                         <0.335939, 0.93248, -1.31076>, <0.000267005, 0.000955549, 2.00688e-05>,
                         <0.35478, 0.927621, -1.33191>, <0.000258279, 0.000932188, 1.76619e-05> }
        smooth_triangle {<0.35478, 0.927621, -1.33191>, <0.000254066, 0.000884304, 2.31769e-05>,
                         <0.352991, 0.930429, -1.3734>, <0.000253539, 0.000700505, 6.25045e-05>,
                         <0.335929, 0.935007, -1.35505>, <0.000258056, 0.000706575, 6.51909e-05> }
        smooth_triangle {<0.335939, 0.93248, -1.31076>, <0.000267005, 0.000955549, 2.00688e-05>,
                         <0.348636, 0.931186, -1.26578>, <0.000236589, 0.00130906, -7.90874e-05>,
                         <0.368139, 0.926184, -1.28978>, <0.000226018, 0.00126007, -7.74676e-05> }
        smooth_triangle {<0.368139, 0.926184, -1.28978>, <0.000228283, 0.00121415, -6.75596e-05>,
                         <0.35478, 0.927621, -1.33191>, <0.000252478, 0.00096824, 3.78757e-06>,
                         <0.335939, 0.93248, -1.31076>, <0.000259023, 0.000985761, 5.59278e-06> }
        smooth_triangle {<0.348636, 0.931186, -1.26578>, <0.000236589, 0.00130906, -7.90874e-05>,
                         <0.381178, 0.931079, -1.22905>, <0.000143654, 0.0015196, -0.0001907>,
                         <0.399552, 0.926065, -1.25513>, <0.000136102, 0.00145318, -0.000183252> }
        smooth_triangle {<0.399552, 0.926065, -1.25513>, <0.00014612, 0.00144729, -0.000176138>,
                         <0.368139, 0.926184, -1.28978>, <0.000213557, 0.00130245, -9.67998e-05>,
                         <0.348636, 0.931186, -1.26578>, <0.000221485, 0.00133919, -9.80146e-05> }
        smooth_triangle {<0.381178, 0.931079, -1.22905>, <0.000143654, 0.0015196, -0.0001907>,
                         <0.428086, 0.931886, -1.21526>, <1.21098e-05, 0.00133893, -0.000246494>,
                         <0.444021, 0.926961, -1.24135>, <1.19014e-05, 0.0012845, -0.000236349> }
        smooth_triangle {<0.444021, 0.926961, -1.24135>, <2.03552e-05, 0.00131667, -0.00023712>,
                         <0.399552, 0.926065, -1.25513>, <0.000113506, 0.00144318, -0.000197297>,
                         <0.381178, 0.931079, -1.22905>, <0.000119169, 0.001493, -0.000202883> }
        smooth_triangle {<0.428086, 0.931886, -1.21526>, <1.21098e-05, 0.00133893, -0.000246494>,
                         <0.47457, 0.933358, -1.22026>, <-7.61093e-05, 0.000987262, -0.000236703>,
                         <0.488093, 0.928597, -1.24465>, <-7.13412e-05, 0.000957136, -0.000228179> }
        smooth_triangle {<0.488093, 0.928597, -1.24465>, <-6.82364e-05, 0.000992153, -0.000231909>,
                         <0.444021, 0.926961, -1.24135>, <-5.80444e-06, 0.00123768, -0.000238035>,
                         <0.428086, 0.931886, -1.21526>, <-5.64813e-06, 0.0012785, -0.000245645> }
        smooth_triangle {<0.47457, 0.933358, -1.22026>, <-7.61093e-05, 0.000987262, -0.000236703>,
                         <0.517631, 0.935384, -1.23357>, <-0.000112422, 0.000741275, -0.000213674>,
                         <0.529038, 0.930849, -1.25552>, <-0.000106231, 0.000725376, -0.000207171> }
        smooth_triangle {<0.529038, 0.930849, -1.25552>, <-0.000106341, 0.000756956, -0.000211721>,
                         <0.488093, 0.928597, -1.24465>, <-8.01735e-05, 0.000930776, -0.000227477>,
                         <0.47457, 0.933358, -1.22026>, <-8.37496e-05, 0.00095337, -0.000233869> }
        smooth_triangle {<0.517631, 0.935384, -1.23357>, <-0.000112422, 0.000741275, -0.000213674>,
                         <0.558295, 0.937943, -1.25058>, <-0.000125567, 0.000576504, -0.000191938>,
                         <0.567785, 0.933692, -1.26976>, <-0.000119484, 0.000567426, -0.000186917> }
        smooth_triangle {<0.567785, 0.933692, -1.26976>, <-0.000121368, 0.000597566, -0.000192232>,
                         <0.529038, 0.930849, -1.25552>, <-0.000111428, 0.000716029, -0.000207422>,
                         <0.517631, 0.935384, -1.23357>, <-0.000116071, 0.000727953, -0.000212299> }
        smooth_triangle {<0.558295, 0.937943, -1.25058>, <-0.000125567, 0.000576504, -0.000191938>,
                         <0.597121, 0.941179, -1.26987>, <-0.000129938, 0.000441152, -0.000169283>,
                         <0.60483, 0.937288, -1.2861>, <-0.000124707, 0.000436024, -0.00016557> }
        smooth_triangle {<0.60483, 0.937288, -1.2861>, <-0.000128135, 0.000465933, -0.00017208>,
                         <0.567785, 0.933692, -1.26976>, <-0.000124218, 0.000564485, -0.00018809>,
                         <0.558295, 0.937943, -1.25058>, <-0.00012878, 0.000571294, -0.000191856> }
        smooth_triangle {<0.597121, 0.941179, -1.26987>, <-0.000129938, 0.000441152, -0.000169283>,
                         <0.633938, 0.945429, -1.29127>, <-0.000128047, 0.000314547, -0.000142374>,
                         <0.639986, 0.94201, -1.3044>, <-0.000124149, 0.000312274, -0.000139987> }
        smooth_triangle {<0.639986, 0.94201, -1.3044>, <-0.000130082, 0.000341612, -0.000148296>,
                         <0.60483, 0.937288, -1.2861>, <-0.000130501, 0.000434424, -0.000167483>,
                         <0.597121, 0.941179, -1.26987>, <-0.000134424, 0.00043827, -0.000170268> }
        smooth_triangle {<0.633938, 0.945429, -1.29127>, <-0.000128047, 0.000314547, -0.000142374>,
                         <0.668213, 0.951023, -1.31499>, <-0.000115413, 0.000197809, -0.000109349>,
                         <0.672718, 0.948225, -1.32489>, <-0.00011307, 0.000197406, -0.000108169> }
        smooth_triangle {<0.672718, 0.948225, -1.32489>, <-0.000122722, 0.000224543, -0.000118506>,
                         <0.639986, 0.94201, -1.3044>, <-0.000131031, 0.000310693, -0.00014237>,
                         <0.633938, 0.945429, -1.29127>, <-0.000133955, 0.000312399, -0.00014416> }
        smooth_triangle {<0.668213, 0.951023, -1.31499>, <-0.000115413, 0.000197809, -0.000109349>,
                         <0.699545, 0.958303, -1.34106>, <-8.60953e-05, 0.000102209, -7.05111e-05>,
                         <0.702568, 0.956314, -1.34765>, <-8.52169e-05, 0.000102389, -7.01627e-05> }
        smooth_triangle {<0.702568, 0.956314, -1.34765>, <-9.98541e-05, 0.00012503, -8.26119e-05>,
                         <0.672718, 0.948225, -1.32489>, <-0.000120744, 0.000196293, -0.000111117>,
                         <0.668213, 0.951023, -1.31499>, <-0.000122501, 0.000196595, -0.000112001> }
        smooth_triangle {<0.699545, 0.958303, -1.34106>, <-8.60953e-05, 0.000102209, -7.05111e-05>,
                         <0.728122, 0.967064, -1.36913>, <-3.78041e-05, 3.44827e-05, -2.77141e-05>,
                         <0.729646, 0.966048, -1.37242>, <-3.77649e-05, 3.45198e-05, -2.77074e-05> }
        smooth_triangle {<0.729646, 0.966048, -1.37242>, <-5.66882e-05, 5.18116e-05, -4.16017e-05>,
                         <0.702568, 0.956314, -1.34765>, <-9.22772e-05, 0.000102714, -7.34432e-05>,
                         <0.699545, 0.958303, -1.34106>, <-9.2936e-05, 0.000102579, -7.37045e-05> }
        smooth_triangle {<0.728122, 0.967064, -1.36913>, <-3.78041e-05, 3.44827e-05, -2.77141e-05>,
                         <0.754854, 0.976682, -1.39849>, <1.4992e-06, 1.17566e-06, 1.67499e-06>,
                         <0.75483, 0.976735, -1.3985>, <1.30811e-06, 1.07343e-06, 1.61801e-06> }
        smooth_triangle {<0.75483, 0.976735, -1.3985>, <-1.96771e-05, 1.50781e-05, -1.28766e-05>,
                         <0.729646, 0.966048, -1.37242>, <-4.37355e-05, 3.66617e-05, -3.12469e-05>,
                         <0.728122, 0.967064, -1.36913>, <-4.37649e-05, 3.66339e-05, -3.1252e-05> }
        smooth_triangle {<0.408666, 0.976629, -1.63557>, <6.1405e-05, 5.09236e-05, 3.61435e-05>,
                         <0.391797, 0.968393, -1.59531>, <7.92907e-05, 7.25791e-05, 4.51949e-05>,
                         <0.394185, 0.967417, -1.59799>, <7.92844e-05, 7.23979e-05, 4.52553e-05> }
        smooth_triangle {<0.394185, 0.967417, -1.59799>, <5.88315e-05, 5.52989e-05, 3.39433e-05>,
                         <0.40875, 0.976682, -1.63552>, <2.94819e-05, 2.72809e-05, 1.81799e-05>,
                         <0.408666, 0.976629, -1.63557>, <2.94388e-05, 2.74628e-05, 1.80754e-05> }
        smooth_triangle {<0.391797, 0.968393, -1.59531>, <7.92907e-05, 7.25791e-05, 4.51949e-05>,
                         <0.376273, 0.96124, -1.55415>, <0.000128572, 0.000142619, 6.88609e-05>,
                         <0.381091, 0.959369, -1.55948>, <0.000128125, 0.000143078, 6.8296e-05> }
        smooth_triangle {<0.381091, 0.959369, -1.55948>, <0.00011089, 0.000121523, 5.92236e-05>,
                         <0.394185, 0.967417, -1.59799>, <7.42595e-05, 6.85128e-05, 4.19431e-05>,
                         <0.391797, 0.968393, -1.59531>, <7.42642e-05, 6.86487e-05, 4.18978e-05> }
        smooth_triangle {<0.376273, 0.96124, -1.55415>, <0.000128572, 0.000142619, 6.88609e-05>,
                         <0.362146, 0.955431, -1.51208>, <0.000166347, 0.000226222, 8.31766e-05>,
                         <0.369488, 0.952834, -1.52>, <0.000165087, 0.000227331, 8.16444e-05> }
        smooth_triangle {<0.369488, 0.952834, -1.52>, <0.000150993, 0.000202587, 7.45322e-05>,
                         <0.381091, 0.959369, -1.55948>, <0.000123272, 0.000139397, 6.45209e-05>,
                         <0.376273, 0.96124, -1.55415>, <0.000123607, 0.000139052, 6.49446e-05> }
        smooth_triangle {<0.362146, 0.955431, -1.51208>, <0.000166347, 0.000226222, 8.31766e-05>,
                         <0.34911, 0.950585, -1.46936>, <0.000198003, 0.000316932, 9.28426e-05>,
                         <0.358994, 0.947383, -1.47984>, <0.000195862, 0.000318086, 9.04702e-05> }
        smooth_triangle {<0.358994, 0.947383, -1.47984>, <0.000183761, 0.000291514, 8.4671e-05>,
                         <0.369488, 0.952834, -1.52>, <0.00016068, 0.000223447, 7.80516e-05>,
                         <0.362146, 0.955431, -1.51208>, <0.000161625, 0.000222615, 7.92007e-05> }
        smooth_triangle {<0.34911, 0.950585, -1.46936>, <0.000198003, 0.000316932, 9.28426e-05>,
                         <0.337144, 0.946354, -1.42603>, <0.000226349, 0.000416842, 9.84194e-05>,
                         <0.349538, 0.942623, -1.43909>, <0.000223304, 0.000417165, 9.54362e-05> }
        smooth_triangle {<0.349538, 0.942623, -1.43909>, <0.000212575, 0.000388789, 9.09103e-05>,
                         <0.358994, 0.947383, -1.47984>, <0.000191993, 0.00031448, 8.71859e-05>,
                         <0.34911, 0.950585, -1.46936>, <0.0001936, 0.000313614, 8.89651e-05> }
        smooth_triangle {<0.337144, 0.946354, -1.42603>, <0.000226349, 0.000416842, 9.84194e-05>,
                         <0.326715, 0.942671, -1.38193>, <0.000250828, 0.000536119, 9.61612e-05>,
                         <0.341531, 0.938479, -1.3976>, <0.000246612, 0.000534132, 9.27058e-05> }
        smooth_triangle {<0.341531, 0.938479, -1.3976>, <0.000237184, 0.000503006, 8.98352e-05>,
                         <0.349538, 0.942623, -1.43909>, <0.000219702, 0.000415281, 9.18829e-05>,
                         <0.337144, 0.946354, -1.42603>, <0.000221987, 0.000415038, 9.41203e-05> }
        smooth_triangle {<0.326715, 0.942671, -1.38193>, <0.000250828, 0.000536119, 9.61612e-05>,
                         <0.318868, 0.939584, -1.3367>, <0.000269622, 0.000703309, 7.72625e-05>,
                         <0.335929, 0.935007, -1.35505>, <0.000263599, 0.000695216, 7.36806e-05> }
        smooth_triangle {<0.335929, 0.935007, -1.35505>, <0.000255889, 0.000657075, 7.39927e-05>,
                         <0.341531, 0.938479, -1.3976>, <0.000243149, 0.000536263, 8.82616e-05>,
                         <0.326715, 0.942671, -1.38193>, <0.000246311, 0.000537753, 9.08531e-05> }
        smooth_triangle {<0.318868, 0.939584, -1.3367>, <0.000269622, 0.000703309, 7.72625e-05>,
                         <0.317097, 0.937338, -1.2896>, <0.000275731, 0.00097891, 2.24758e-05>,
                         <0.335939, 0.93248, -1.31076>, <0.000267005, 0.000955549, 2.00688e-05> }
        smooth_triangle {<0.335939, 0.93248, -1.31076>, <0.000262535, 0.000905637, 2.58209e-05>,
                         <0.335929, 0.935007, -1.35505>, <0.000259981, 0.000710387, 6.60297e-05>,
                         <0.318868, 0.939584, -1.3367>, <0.000264498, 0.000716457, 6.87161e-05> }
        smooth_triangle {<0.317097, 0.937338, -1.2896>, <0.000275731, 0.00097891, 2.24758e-05>,
                         <0.329133, 0.936188, -1.24178>, <0.000247159, 0.00135804, -8.07071e-05>,
                         <0.348636, 0.931186, -1.26578>, <0.000236589, 0.00130906, -7.90874e-05> }
        smooth_triangle {<0.348636, 0.931186, -1.26578>, <0.000238906, 0.00126079, -6.86468e-05>,
                         <0.335939, 0.93248, -1.31076>, <0.000261718, 0.000995657, 5.7204e-06>,
                         <0.317097, 0.937338, -1.2896>, <0.000268263, 0.00101318, 7.52561e-06> }
        smooth_triangle {<0.329133, 0.936188, -1.24178>, <0.000247159, 0.00135804, -8.07071e-05>,
                         <0.362804, 0.936093, -1.20296>, <0.000151205, 0.00158603, -0.000198147>,
                         <0.381178, 0.931079, -1.22905>, <0.000143654, 0.0015196, -0.0001907> }
        smooth_triangle {<0.381178, 0.931079, -1.22905>, <0.000154321, 0.00151405, -0.000183194>,
                         <0.348636, 0.931186, -1.26578>, <0.000224023, 0.00135614, -9.94846e-05>,
                         <0.329133, 0.936188, -1.24178>, <0.00023195, 0.00139288, -0.000100699> }
        smooth_triangle {<0.362804, 0.936093, -1.20296>, <0.000151205, 0.00158603, -0.000198147>,
                         <0.412151, 0.93681, -1.18917>, <1.23182e-05, 0.00139335, -0.00025664>,
                         <0.428086, 0.931886, -1.21526>, <1.21098e-05, 0.00133893, -0.000246494> }
        smooth_triangle {<0.428086, 0.931886, -1.21526>, <2.11002e-05, 0.00137341, -0.000247375>,
                         <0.381178, 0.931079, -1.22905>, <0.000119758, 0.00150892, -0.000205529>,
                         <0.362804, 0.936093, -1.20296>, <0.000125422, 0.00155874, -0.000211115> }
        smooth_triangle {<0.412151, 0.93681, -1.18917>, <1.23182e-05, 0.00139335, -0.00025664>,
                         <0.461047, 0.938119, -1.19586>, <-8.08775e-05, 0.00101739, -0.000245226>,
                         <0.47457, 0.933358, -1.22026>, <-7.61093e-05, 0.000987262, -0.000236703> }
        smooth_triangle {<0.47457, 0.933358, -1.22026>, <-7.28336e-05, 0.00102372, -0.000240619>,
                         <0.428086, 0.931886, -1.21526>, <-6.6692e-06, 0.00128747, -0.000247963>,
                         <0.412151, 0.93681, -1.18917>, <-6.5129e-06, 0.00132829, -0.000255572> }
        smooth_triangle {<0.461047, 0.938119, -1.19586>, <-8.08775e-05, 0.00101739, -0.000245226>,
                         <0.506224, 0.93992, -1.21162>, <-0.000118612, 0.000757174, -0.000220176>,
                         <0.517631, 0.935384, -1.23357>, <-0.000112422, 0.000741275, -0.000213674> }
        smooth_triangle {<0.517631, 0.935384, -1.23357>, <-0.000112518, 0.000773525, -0.000218355>,
                         <0.47457, 0.933358, -1.22026>, <-8.52836e-05, 0.000958015, -0.000235626>,
                         <0.461047, 0.938119, -1.19586>, <-8.88597e-05, 0.00098061, -0.000242019> }
        smooth_triangle {<0.506224, 0.93992, -1.21162>, <-0.000118612, 0.000757174, -0.000220176>,
                         <0.548805, 0.942194, -1.2314>, <-0.00013165, 0.000585582, -0.000196959>,
                         <0.558295, 0.937943, -1.25058>, <-0.000125567, 0.000576504, -0.000191938> }
        smooth_triangle {<0.558295, 0.937943, -1.25058>, <-0.000127505, 0.000607008, -0.00019736>,
                         <0.517631, 0.935384, -1.23357>, <-0.000117646, 0.000730586, -0.000213662>,
                         <0.506224, 0.93992, -1.21162>, <-0.000122289, 0.00074251, -0.000218539> }
        smooth_triangle {<0.548805, 0.942194, -1.2314>, <-0.00013165, 0.000585582, -0.000196959>,
                         <0.589412, 0.945071, -1.25363>, <-0.000135168, 0.00044628, -0.000172997>,
                         <0.597121, 0.941179, -1.26987>, <-0.000129938, 0.000441152, -0.000169283> }
        smooth_triangle {<0.597121, 0.941179, -1.26987>, <-0.00013347, 0.000471321, -0.000175904>,
                         <0.558295, 0.937943, -1.25058>, <-0.000130192, 0.000572835, -0.000192896>,
                         <0.548805, 0.942194, -1.2314>, <-0.000134754, 0.000579643, -0.000196661> }
        smooth_triangle {<0.589412, 0.945071, -1.25363>, <-0.000135168, 0.00044628, -0.000172997>,
                         <0.627889, 0.948849, -1.27813>, <-0.000131944, 0.00031682, -0.000144761>,
                         <0.633938, 0.945429, -1.29127>, <-0.000128047, 0.000314547, -0.000142374> }
        smooth_triangle {<0.633938, 0.945429, -1.29127>, <-0.000134106, 0.00034408, -0.000150791>,
                         <0.597121, 0.941179, -1.26987>, <-0.000135524, 0.000439034, -0.000170973>,
                         <0.589412, 0.945071, -1.25363>, <-0.000139447, 0.00044288, -0.000173758> }
        smooth_triangle {<0.627889, 0.948849, -1.27813>, <-0.000131944, 0.00031682, -0.000144761>,
                         <0.663708, 0.953821, -1.30509>, <-0.000117756, 0.000198211, -0.000110529>,
                         <0.668213, 0.951023, -1.31499>, <-0.000115413, 0.000197809, -0.000109349> }
        smooth_triangle {<0.668213, 0.951023, -1.31499>, <-0.000125203, 0.000225023, -0.000119771>,
                         <0.633938, 0.945429, -1.29127>, <-0.000134678, 0.000312576, -0.00014454>,
                         <0.627889, 0.948849, -1.27813>, <-0.000137602, 0.000314282, -0.00014633> }
        smooth_triangle {<0.663708, 0.953821, -1.30509>, <-0.000117756, 0.000198211, -0.000110529>,
                         <0.696522, 0.960292, -1.33446>, <-8.69737e-05, 0.000102029, -7.08595e-05>,
                         <0.699545, 0.958303, -1.34106>, <-8.60953e-05, 0.000102209, -7.05111e-05> }
        smooth_triangle {<0.699545, 0.958303, -1.34106>, <-0.000100823, 0.000124841, -8.2999e-05>,
                         <0.668213, 0.951023, -1.31499>, <-0.000122811, 0.000196541, -0.000112127>,
                         <0.663708, 0.953821, -1.30509>, <-0.000124568, 0.000196842, -0.000113012> }
        smooth_triangle {<0.696522, 0.960292, -1.33446>, <-8.69737e-05, 0.000102029, -7.08595e-05>,
                         <0.726597, 0.96808, -1.36584>, <-3.78433e-05, 3.44456e-05, -2.77208e-05>,
                         <0.728122, 0.967064, -1.36913>, <-3.78041e-05, 3.44827e-05, -2.77141e-05> }
        smooth_triangle {<0.728122, 0.967064, -1.36913>, <-5.67562e-05, 5.17571e-05, -4.16164e-05>,
                         <0.699545, 0.958303, -1.34106>, <-9.29746e-05, 0.000102552, -7.37141e-05>,
                         <0.696522, 0.960292, -1.33446>, <-9.36334e-05, 0.000102417, -7.39754e-05> }
        smooth_triangle {<0.726597, 0.96808, -1.36584>, <-3.78433e-05, 3.44456e-05, -2.77208e-05>,
                         <0.754877, 0.976629, -1.39847>, <1.6903e-06, 1.2779e-06, 1.73196e-06>,
                         <0.754854, 0.976682, -1.39849>, <1.4992e-06, 1.17566e-06, 1.67499e-06> }
        smooth_triangle {<0.754854, 0.976682, -1.39849>, <-1.9486e-05, 1.51803e-05, -1.28196e-05>,
                         <0.728122, 0.967064, -1.36913>, <-4.37171e-05, 3.66594e-05, -3.12377e-05>,
                         <0.726597, 0.96808, -1.36584>, <-4.37465e-05, 3.66316e-05, -3.12427e-05> }
        smooth_triangle {<0.408582, 0.976576, -1.63563>, <6.13189e-05, 5.12874e-05, 3.59344e-05>,
                         <0.389408, 0.96937, -1.59263>, <7.92969e-05, 7.27603e-05, 4.51345e-05>,
                         <0.391797, 0.968393, -1.59531>, <7.92907e-05, 7.25791e-05, 4.51949e-05> }
        smooth_triangle {<0.391797, 0.968393, -1.59531>, <5.88146e-05, 5.55258e-05, 3.38457e-05>,
                         <0.408666, 0.976629, -1.63557>, <2.93958e-05, 2.76448e-05, 1.79708e-05>,
                         <0.408582, 0.976576, -1.63563>, <2.93527e-05, 2.78267e-05, 1.78663e-05> }
        smooth_triangle {<0.389408, 0.96937, -1.59263>, <7.92969e-05, 7.27603e-05, 4.51345e-05>,
                         <0.371454, 0.96311, -1.54882>, <0.000129019, 0.00014216, 6.94258e-05>,
                         <0.376273, 0.96124, -1.55415>, <0.000128572, 0.000142619, 6.88609e-05> }
        smooth_triangle {<0.376273, 0.96124, -1.55415>, <0.000111273, 0.000121132, 5.97065e-05>,
                         <0.391797, 0.968393, -1.59531>, <7.43119e-05, 6.86027e-05, 4.1957e-05>,
                         <0.389408, 0.96937, -1.59263>, <7.43166e-05, 6.87386e-05, 4.19117e-05> }
        smooth_triangle {<0.371454, 0.96311, -1.54882>, <0.000129019, 0.00014216, 6.94258e-05>,
                         <0.354805, 0.958027, -1.50417>, <0.000167607, 0.000225113, 8.47088e-05>,
                         <0.362146, 0.955431, -1.51208>, <0.000166347, 0.000226222, 8.31766e-05> }
        smooth_triangle {<0.362146, 0.955431, -1.51208>, <0.000152178, 0.000201503, 7.59866e-05>,
                         <0.376273, 0.96124, -1.55415>, <0.000123847, 0.0001388, 6.52498e-05>,
                         <0.371454, 0.96311, -1.54882>, <0.000124182, 0.000138456, 6.56735e-05> }
        smooth_triangle {<0.354805, 0.958027, -1.50417>, <0.000167607, 0.000225113, 8.47088e-05>,
                         <0.339226, 0.953787, -1.45887>, <0.000200145, 0.000315777, 9.52149e-05>,
                         <0.34911, 0.950585, -1.46936>, <0.000198003, 0.000316932, 9.28426e-05> }
        smooth_triangle {<0.34911, 0.950585, -1.46936>, <0.000185833, 0.00029032, 8.6989e-05>,
                         <0.362146, 0.955431, -1.51208>, <0.00016209, 0.000222288, 7.97395e-05>,
                         <0.354805, 0.958027, -1.50417>, <0.000163035, 0.000221456, 8.08886e-05> }
        smooth_triangle {<0.339226, 0.953787, -1.45887>, <0.000200145, 0.000315777, 9.52149e-05>,
                         <0.324751, 0.950085, -1.41297>, <0.000229395, 0.000416519, 0.000101403>,
                         <0.337144, 0.946354, -1.42603>, <0.000226349, 0.000416842, 9.84194e-05> }
        smooth_triangle {<0.337144, 0.946354, -1.42603>, <0.000215535, 0.000388335, 9.38495e-05>,
                         <0.34911, 0.950585, -1.46936>, <0.000194275, 0.000313402, 8.96669e-05>,
                         <0.339226, 0.953787, -1.45887>, <0.000195881, 0.000312536, 9.14461e-05> }
        smooth_triangle {<0.324751, 0.950085, -1.41297>, <0.000229395, 0.000416519, 0.000101403>,
                         <0.311898, 0.946863, -1.36627>, <0.000255044, 0.000538106, 9.96166e-05>,
                         <0.326715, 0.942671, -1.38193>, <0.000250828, 0.000536119, 9.61612e-05> }
        smooth_triangle {<0.326715, 0.942671, -1.38193>, <0.000241279, 0.000504677, 9.32606e-05>,
                         <0.337144, 0.946354, -1.42603>, <0.00022292, 0.000415219, 9.49542e-05>,
                         <0.324751, 0.950085, -1.41297>, <0.000225204, 0.000414977, 9.71916e-05> }
        smooth_triangle {<0.311898, 0.946863, -1.36627>, <0.000255044, 0.000538106, 9.96166e-05>,
                         <0.301806, 0.944162, -1.31836>, <0.000275645, 0.000711402, 8.08444e-05>,
                         <0.318868, 0.939584, -1.3367>, <0.000269622, 0.000703309, 7.72625e-05> }
        smooth_triangle {<0.318868, 0.939584, -1.3367>, <0.000261702, 0.000664274, 7.76029e-05>,
                         <0.326715, 0.942671, -1.38193>, <0.000247607, 0.000538882, 9.17769e-05>,
                         <0.311898, 0.946863, -1.36627>, <0.000250769, 0.000540372, 9.43685e-05> }
        smooth_triangle {<0.301806, 0.944162, -1.31836>, <0.000275645, 0.000711402, 8.08444e-05>,
                         <0.298256, 0.942196, -1.26845>, <0.000284457, 0.00100227, 2.48827e-05>,
                         <0.317097, 0.937338, -1.2896>, <0.000275731, 0.00097891, 2.24758e-05> }
        smooth_triangle {<0.317097, 0.937338, -1.2896>, <0.000271004, 0.00092697, 2.84649e-05>,
                         <0.318868, 0.939584, -1.3367>, <0.000266423, 0.000720269, 6.95549e-05>,
                         <0.301806, 0.944162, -1.31836>, <0.00027094, 0.000726339, 7.22414e-05> }
        smooth_triangle {<0.298256, 0.942196, -1.26845>, <0.000284457, 0.00100227, 2.48827e-05>,
                         <0.309629, 0.94119, -1.21778>, <0.000257729, 0.00140703, -8.23269e-05>,
                         <0.329133, 0.936188, -1.24178>, <0.000247159, 0.00135804, -8.07071e-05> }
        smooth_triangle {<0.329133, 0.936188, -1.24178>, <0.000249529, 0.00130742, -6.97339e-05>,
                         <0.317097, 0.937338, -1.2896>, <0.000270958, 0.00102307, 7.65323e-06>,
                         <0.298256, 0.942196, -1.26845>, <0.000277503, 0.0010406, 9.45844e-06> }
        smooth_triangle {<0.309629, 0.94119, -1.21778>, <0.000257729, 0.00140703, -8.23269e-05>,
                         <0.344429, 0.941107, -1.17688>, <0.000158757, 0.00165245, -0.000205595>,
                         <0.362804, 0.936093, -1.20296>, <0.000151205, 0.00158603, -0.000198147> }
        smooth_triangle {<0.362804, 0.936093, -1.20296>, <0.000162523, 0.00158081, -0.00019025>,
                         <0.329133, 0.936188, -1.24178>, <0.000234488, 0.00140983, -0.000102169>,
                         <0.309629, 0.94119, -1.21778>, <0.000242416, 0.00144657, -0.000103384> }
        smooth_triangle {<0.344429, 0.941107, -1.17688>, <0.000158757, 0.00165245, -0.000205595>,
                         <0.396216, 0.941734, -1.16309>, <1.25266e-05, 0.00144778, -0.000266786>,
                         <0.412151, 0.93681, -1.18917>, <1.23182e-05, 0.00139335, -0.00025664> }
        smooth_triangle {<0.412151, 0.93681, -1.18917>, <2.18452e-05, 0.00143015, -0.00025763>,
                         <0.362804, 0.936093, -1.20296>, <0.00012601, 0.00157466, -0.000213761>,
                         <0.344429, 0.941107, -1.17688>, <0.000131674, 0.00162447, -0.000219347> }
        smooth_triangle {<0.396216, 0.941734, -1.16309>, <1.25266e-05, 0.00144778, -0.000266786>,
                         <0.447524, 0.94288, -1.17147>, <-8.56456e-05, 0.00104751, -0.000253749>,
                         <0.461047, 0.938119, -1.19586>, <-8.08775e-05, 0.00101739, -0.000245226> }
        smooth_triangle {<0.461047, 0.938119, -1.19586>, <-7.74307e-05, 0.00105529, -0.000249329>,
                         <0.412151, 0.93681, -1.18917>, <-7.53397e-06, 0.00133726, -0.00025789>,
                         <0.396216, 0.941734, -1.16309>, <-7.37767e-06, 0.00137808, -0.000265499> }
        smooth_triangle {<0.447524, 0.94288, -1.17147>, <-8.56456e-05, 0.00104751, -0.000253749>,
                         <0.494816, 0.944455, -1.18967>, <-0.000124803, 0.000773073, -0.000226679>,
                         <0.506224, 0.93992, -1.21162>, <-0.000118612, 0.000757174, -0.000220176> }
        smooth_triangle {<0.506224, 0.93992, -1.21162>, <-0.000118695, 0.000790095, -0.000224989>,
                         <0.461047, 0.938119, -1.19586>, <-9.03936e-05, 0.000985255, -0.000243776>,
                         <0.447524, 0.94288, -1.17147>, <-9.39697e-05, 0.00100785, -0.000250169> }
        smooth_triangle {<0.494816, 0.944455, -1.18967>, <-0.000124803, 0.000773073, -0.000226679>,
                         <0.539315, 0.946446, -1.21221>, <-0.000137732, 0.00059466, -0.000201979>,
                         <0.548805, 0.942194, -1.2314>, <-0.00013165, 0.000585582, -0.000196959> }
        smooth_triangle {<0.548805, 0.942194, -1.2314>, <-0.000133643, 0.00061645, -0.000202489>,
                         <0.506224, 0.93992, -1.21162>, <-0.000123865, 0.000745144, -0.000219902>,
                         <0.494816, 0.944455, -1.18967>, <-0.000128508, 0.000757068, -0.000224779> }
        smooth_triangle {<0.539315, 0.946446, -1.21221>, <-0.000137732, 0.00059466, -0.000201979>,
                         <0.581703, 0.948963, -1.2374>, <-0.000140399, 0.000451408, -0.00017671>,
                         <0.589412, 0.945071, -1.25363>, <-0.000135168, 0.00044628, -0.000172997> }
        smooth_triangle {<0.589412, 0.945071, -1.25363>, <-0.000138805, 0.000476708, -0.000179729>,
                         <0.548805, 0.942194, -1.2314>, <-0.000136166, 0.000581185, -0.000197701>,
                         <0.539315, 0.946446, -1.21221>, <-0.000140728, 0.000587993, -0.000201467> }
        smooth_triangle {<0.581703, 0.948963, -1.2374>, <-0.000140399, 0.000451408, -0.00017671>,
                         <0.62184, 0.952268, -1.265>, <-0.000135842, 0.000319094, -0.000147148>,
                         <0.627889, 0.948849, -1.27813>, <-0.000131944, 0.00031682, -0.000144761> }
        smooth_triangle {<0.627889, 0.948849, -1.27813>, <-0.000138129, 0.000346549, -0.000153287>,
                         <0.589412, 0.945071, -1.25363>, <-0.000140547, 0.000443644, -0.000174464>,
                         <0.581703, 0.948963, -1.2374>, <-0.00014447, 0.00044749, -0.000177249> }
        smooth_triangle {<0.62184, 0.952268, -1.265>, <-0.000135842, 0.000319094, -0.000147148>,
                         <0.659202, 0.956619, -1.29519>, <-0.000120098, 0.000198613, -0.000111708>,
                         <0.663708, 0.953821, -1.30509>, <-0.000117756, 0.000198211, -0.000110529> }
        smooth_triangle {<0.663708, 0.953821, -1.30509>, <-0.000127683, 0.000225502, -0.000121035>,
                         <0.627889, 0.948849, -1.27813>, <-0.000138325, 0.00031446, -0.000146709>,
                         <0.62184, 0.952268, -1.265>, <-0.000141248, 0.000316165, -0.0001485> }
        smooth_triangle {<0.659202, 0.956619, -1.29519>, <-0.000120098, 0.000198613, -0.000111708>,
                         <0.693499, 0.962281, -1.32787>, <-8.78521e-05, 0.000101849, -7.12079e-05>,
                         <0.696522, 0.960292, -1.33446>, <-8.69737e-05, 0.000102029, -7.08595e-05> }
        smooth_triangle {<0.696522, 0.960292, -1.33446>, <-0.000101792, 0.000124652, -8.33862e-05>,
                         <0.663708, 0.953821, -1.30509>, <-0.000124878, 0.000196788, -0.000113138>,
                         <0.659202, 0.956619, -1.29519>, <-0.000126635, 0.00019709, -0.000114023> }
        smooth_triangle {<0.693499, 0.962281, -1.32787>, <-8.78521e-05, 0.000101849, -7.12079e-05>,
                         <0.725073, 0.969095, -1.36255>, <-3.78824e-05, 3.44085e-05, -2.77275e-05>,
                         <0.726597, 0.96808, -1.36584>, <-3.78433e-05, 3.44456e-05, -2.77208e-05> }
        smooth_triangle {<0.726597, 0.96808, -1.36584>, <-5.68242e-05, 5.17026e-05, -4.1631e-05>,
                         <0.696522, 0.960292, -1.33446>, <-9.3672e-05, 0.00010239, -7.39851e-05>,
                         <0.693499, 0.962281, -1.32787>, <-9.43308e-05, 0.000102255, -7.42463e-05> }
        smooth_triangle {<0.725073, 0.969095, -1.36255>, <-3.78824e-05, 3.44085e-05, -2.77275e-05>,
                         <0.754901, 0.976576, -1.39846>, <1.88139e-06, 1.38013e-06, 1.78894e-06>,
                         <0.754877, 0.976629, -1.39847>, <1.6903e-06, 1.2779e-06, 1.73196e-06> }
        smooth_triangle {<0.754877, 0.976629, -1.39847>, <-1.92949e-05, 1.52826e-05, -1.27626e-05>,
                         <0.726597, 0.96808, -1.36584>, <-4.36988e-05, 3.66572e-05, -3.12285e-05>,
                         <0.725073, 0.969095, -1.36255>, <-4.37281e-05, 3.66294e-05, -3.12335e-05> }
        smooth_triangle {<0.408498, 0.976523, -1.63569>, <6.12328e-05, 5.16512e-05, 3.57253e-05>,
                         <0.38702, 0.970346, -1.58995>, <7.93031e-05, 7.29416e-05, 4.5074e-05>,
                         <0.389408, 0.96937, -1.59263>, <7.92969e-05, 7.27603e-05, 4.51345e-05> }
        smooth_triangle {<0.389408, 0.96937, -1.59263>, <5.87978e-05, 5.57527e-05, 3.37481e-05>,
                         <0.408582, 0.976576, -1.63563>, <2.93097e-05, 2.80086e-05, 1.77617e-05>,
                         <0.408498, 0.976523, -1.63569>, <2.92666e-05, 2.81905e-05, 1.76572e-05> }
        smooth_triangle {<0.38702, 0.970346, -1.58995>, <7.93031e-05, 7.29416e-05, 4.5074e-05>,
                         <0.366636, 0.964981, -1.54348>, <0.000129466, 0.0001417, 6.99907e-05>,
                         <0.371454, 0.96311, -1.54882>, <0.000129019, 0.00014216, 6.94258e-05> }
        smooth_triangle {<0.371454, 0.96311, -1.54882>, <0.000111656, 0.000120742, 6.01895e-05>,
                         <0.389408, 0.96937, -1.59263>, <7.43643e-05, 6.86926e-05, 4.1971e-05>,
                         <0.38702, 0.970346, -1.58995>, <7.4369e-05, 6.88285e-05, 4.19256e-05> }
        smooth_triangle {<0.366636, 0.964981, -1.54348>, <0.000129466, 0.0001417, 6.99907e-05>,
                         <0.347463, 0.960624, -1.49625>, <0.000168867, 0.000224003, 8.6241e-05>,
                         <0.354805, 0.958027, -1.50417>, <0.000167607, 0.000225113, 8.47088e-05> }
        smooth_triangle {<0.354805, 0.958027, -1.50417>, <0.000153363, 0.000200418, 7.74409e-05>,
                         <0.371454, 0.96311, -1.54882>, <0.000124422, 0.000138203, 6.59787e-05>,
                         <0.366636, 0.964981, -1.54348>, <0.000124758, 0.000137859, 6.64024e-05> }
        smooth_triangle {<0.347463, 0.960624, -1.49625>, <0.000168867, 0.000224003, 8.6241e-05>,
                         <0.329341, 0.95699, -1.44839>, <0.000202287, 0.000314623, 9.75872e-05>,
                         <0.339226, 0.953787, -1.45887>, <0.000200145, 0.000315777, 9.52149e-05> }
        smooth_triangle {<0.339226, 0.953787, -1.45887>, <0.000187904, 0.000289127, 8.93069e-05>,
                         <0.354805, 0.958027, -1.50417>, <0.000163501, 0.000221129, 8.14274e-05>,
                         <0.347463, 0.960624, -1.49625>, <0.000164446, 0.000220297, 8.25765e-05> }
        smooth_triangle {<0.329341, 0.95699, -1.44839>, <0.000202287, 0.000314623, 9.75872e-05>,
                         <0.312358, 0.953817, -1.39992>, <0.000232441, 0.000416196, 0.000104386>,
                         <0.324751, 0.950085, -1.41297>, <0.000229395, 0.000416519, 0.000101403> }
        smooth_triangle {<0.324751, 0.950085, -1.41297>, <0.000218495, 0.000387881, 9.67887e-05>,
                         <0.339226, 0.953787, -1.45887>, <0.000196557, 0.000312325, 9.21479e-05>,
                         <0.329341, 0.95699, -1.44839>, <0.000198163, 0.000311459, 9.39272e-05> }
        smooth_triangle {<0.312358, 0.953817, -1.39992>, <0.000232441, 0.000416196, 0.000104386>,
                         <0.297082, 0.951054, -1.3506>, <0.00025926, 0.000540093, 0.000103072>,
                         <0.311898, 0.946863, -1.36627>, <0.000255044, 0.000538106, 9.96166e-05> }
        smooth_triangle {<0.311898, 0.946863, -1.36627>, <0.000245374, 0.000506348, 9.6686e-05>,
                         <0.324751, 0.950085, -1.41297>, <0.000226137, 0.000415157, 9.80255e-05>,
                         <0.312358, 0.953817, -1.39992>, <0.000228421, 0.000414915, 0.000100263> }
        smooth_triangle {<0.297082, 0.951054, -1.3506>, <0.00025926, 0.000540093, 0.000103072>,
                         <0.284745, 0.948739, -1.30001>, <0.000281668, 0.000719495, 8.44264e-05>,
                         <0.301806, 0.944162, -1.31836>, <0.000275645, 0.000711402, 8.08444e-05> }
        smooth_triangle {<0.301806, 0.944162, -1.31836>, <0.000267516, 0.000671473, 8.12132e-05>,
                         <0.311898, 0.946863, -1.36627>, <0.000252065, 0.000541501, 9.52923e-05>,
                         <0.297082, 0.951054, -1.3506>, <0.000255227, 0.000542991, 9.78838e-05> }
        smooth_triangle {<0.284745, 0.948739, -1.30001>, <0.000281668, 0.000719495, 8.44264e-05>,
                         <0.279415, 0.947055, -1.24729>, <0.000293184, 0.00102563, 2.72897e-05>,
                         <0.298256, 0.942196, -1.26845>, <0.000284457, 0.00100227, 2.48827e-05> }
        smooth_triangle {<0.298256, 0.942196, -1.26845>, <0.000279474, 0.000948303, 3.11089e-05>,
                         <0.301806, 0.944162, -1.31836>, <0.000272865, 0.000730151, 7.30802e-05>,
                         <0.284745, 0.948739, -1.30001>, <0.000277382, 0.000736221, 7.57666e-05> }
        smooth_triangle {<0.279415, 0.947055, -1.24729>, <0.000293184, 0.00102563, 2.72897e-05>,
                         <0.290126, 0.946192, -1.19379>, <0.0002683, 0.00145602, -8.39466e-05>,
                         <0.309629, 0.94119, -1.21778>, <0.000257729, 0.00140703, -8.23269e-05> }
        smooth_triangle {<0.309629, 0.94119, -1.21778>, <0.000260152, 0.00135406, -7.08211e-05>,
                         <0.298256, 0.942196, -1.26845>, <0.000280198, 0.00105049, 9.58606e-06>,
                         <0.279415, 0.947055, -1.24729>, <0.000286742, 0.00106801, 1.13913e-05> }
        smooth_triangle {<0.290126, 0.946192, -1.19379>, <0.0002683, 0.00145602, -8.39466e-05>,
                         <0.326055, 0.946121, -1.15079>, <0.000166308, 0.00171887, -0.000213043>,
                         <0.344429, 0.941107, -1.17688>, <0.000158757, 0.00165245, -0.000205595> }
        smooth_triangle {<0.344429, 0.941107, -1.17688>, <0.000170724, 0.00164757, -0.000197306>,
                         <0.309629, 0.94119, -1.21778>, <0.000244953, 0.00146351, -0.000104854>,
                         <0.290126, 0.946192, -1.19379>, <0.000252881, 0.00150025, -0.000106069> }
        smooth_triangle {<0.326055, 0.946121, -1.15079>, <0.000166308, 0.00171887, -0.000213043>,
                         <0.38028, 0.946659, -1.137>, <1.2735e-05, 0.0015022, -0.000276932>,
                         <0.396216, 0.941734, -1.16309>, <1.25266e-05, 0.00144778, -0.000266786> }
        smooth_triangle {<0.396216, 0.941734, -1.16309>, <2.25902e-05, 0.00148689, -0.000267886>,
                         <0.344429, 0.941107, -1.17688>, <0.000132263, 0.0016404, -0.000221993>,
                         <0.326055, 0.946121, -1.15079>, <0.000137926, 0.00169021, -0.000227578> }
        smooth_triangle {<0.38028, 0.946659, -1.137>, <1.2735e-05, 0.0015022, -0.000276932>,
                         <0.434001, 0.94764, -1.14708>, <-9.04138e-05, 0.00107764, -0.000262273>,
                         <0.447524, 0.94288, -1.17147>, <-8.56456e-05, 0.00104751, -0.000253749> }
        smooth_triangle {<0.447524, 0.94288, -1.17147>, <-8.20279e-05, 0.00108686, -0.000258039>,
                         <0.396216, 0.941734, -1.16309>, <-8.39874e-06, 0.00138706, -0.000267817>,
                         <0.38028, 0.946659, -1.137>, <-8.24243e-06, 0.00142788, -0.000275426> }
        smooth_triangle {<0.434001, 0.94764, -1.14708>, <-9.04138e-05, 0.00107764, -0.000262273>,
                         <0.483409, 0.948991, -1.16772>, <-0.000130994, 0.000788971, -0.000233182>,
                         <0.494816, 0.944455, -1.18967>, <-0.000124803, 0.000773073, -0.000226679> }
        smooth_triangle {<0.494816, 0.944455, -1.18967>, <-0.000124872, 0.000806664, -0.000231623>,
                         <0.447524, 0.94288, -1.17147>, <-9.55037e-05, 0.00101249, -0.000251926>,
                         <0.434001, 0.94764, -1.14708>, <-9.90798e-05, 0.00103509, -0.000258318> }
        smooth_triangle {<0.483409, 0.948991, -1.16772>, <-0.000130994, 0.000788971, -0.000233182>,
                         <0.529824, 0.950697, -1.19303>, <-0.000143815, 0.000603738, -0.000207>,
                         <0.539315, 0.946446, -1.21221>, <-0.000137732, 0.00059466, -0.000201979> }
        smooth_triangle {<0.539315, 0.946446, -1.21221>, <-0.00013978, 0.000625892, -0.000207617>,
                         <0.494816, 0.944455, -1.18967>, <-0.000130083, 0.000759702, -0.000226142>,
                         <0.483409, 0.948991, -1.16772>, <-0.000134726, 0.000771626, -0.000231019> }
        smooth_triangle {<0.529824, 0.950697, -1.19303>, <-0.000143815, 0.000603738, -0.000207>,
                         <0.573993, 0.952854, -1.22116>, <-0.00014563, 0.000456536, -0.000180423>,
                         <0.581703, 0.948963, -1.2374>, <-0.000140399, 0.000451408, -0.00017671> }
        smooth_triangle {<0.581703, 0.948963, -1.2374>, <-0.000144139, 0.000482095, -0.000183554>,
                         <0.539315, 0.946446, -1.21221>, <-0.000142139, 0.000589534, -0.000202506>,
                         <0.529824, 0.950697, -1.19303>, <-0.000146701, 0.000596343, -0.000206272> }
        smooth_triangle {<0.573993, 0.952854, -1.22116>, <-0.00014563, 0.000456536, -0.000180423>,
                         <0.615792, 0.955688, -1.25187>, <-0.00013974, 0.000321367, -0.000149535>,
                         <0.62184, 0.952268, -1.265>, <-0.000135842, 0.000319094, -0.000147148> }
        smooth_triangle {<0.62184, 0.952268, -1.265>, <-0.000142152, 0.000349018, -0.000155783>,
                         <0.581703, 0.948963, -1.2374>, <-0.00014557, 0.000448253, -0.000177954>,
                         <0.573993, 0.952854, -1.22116>, <-0.000149493, 0.000452099, -0.000180739> }
        smooth_triangle {<0.615792, 0.955688, -1.25187>, <-0.00013974, 0.000321367, -0.000149535>,
                         <0.654697, 0.959417, -1.28529>, <-0.000122441, 0.000199016, -0.000112888>,
                         <0.659202, 0.956619, -1.29519>, <-0.000120098, 0.000198613, -0.000111708> }
        smooth_triangle {<0.659202, 0.956619, -1.29519>, <-0.000130164, 0.000225982, -0.000122299>,
                         <0.62184, 0.952268, -1.265>, <-0.000141972, 0.000316343, -0.000148879>,
                         <0.615792, 0.955688, -1.25187>, <-0.000144895, 0.000318048, -0.00015067> }
        smooth_triangle {<0.654697, 0.959417, -1.28529>, <-0.000122441, 0.000199016, -0.000112888>,
                         <0.690476, 0.96427, -1.32127>, <-8.87305e-05, 0.000101669, -7.15562e-05>,
                         <0.693499, 0.962281, -1.32787>, <-8.78521e-05, 0.000101849, -7.12079e-05> }
        smooth_triangle {<0.693499, 0.962281, -1.32787>, <-0.000102761, 0.000124463, -8.37733e-05>,
                         <0.659202, 0.956619, -1.29519>, <-0.000126945, 0.000197036, -0.000114149>,
                         <0.654697, 0.959417, -1.28529>, <-0.000128702, 0.000197338, -0.000115034> }
        smooth_triangle {<0.690476, 0.96427, -1.32127>, <-8.87305e-05, 0.000101669, -7.15562e-05>,
                         <0.723549, 0.970111, -1.35926>, <-3.79216e-05, 3.43715e-05, -2.77342e-05>,
                         <0.725073, 0.969095, -1.36255>, <-3.78824e-05, 3.44085e-05, -2.77275e-05> }
        smooth_triangle {<0.725073, 0.969095, -1.36255>, <-5.68921e-05, 5.16482e-05, -4.16457e-05>,
                         <0.693499, 0.962281, -1.32787>, <-9.43694e-05, 0.000102229, -7.4256e-05>,
                         <0.690476, 0.96427, -1.32127>, <-9.50282e-05, 0.000102094, -7.45173e-05> }
        smooth_triangle {<0.723549, 0.970111, -1.35926>, <-3.79216e-05, 3.43715e-05, -2.77342e-05>,
                         <0.754925, 0.976523, -1.39844>, <2.07249e-06, 1.48236e-06, 1.84592e-06>,
                         <0.754901, 0.976576, -1.39846>, <1.88139e-06, 1.38013e-06, 1.78894e-06> }
        smooth_triangle {<0.754901, 0.976576, -1.39846>, <-1.91038e-05, 1.53848e-05, -1.27056e-05>,
                         <0.725073, 0.969095, -1.36255>, <-4.36804e-05, 3.66549e-05, -3.12193e-05>,
                         <0.723549, 0.970111, -1.35926>, <-4.37097e-05, 3.66271e-05, -3.12243e-05> }
        smooth_triangle {<0.408413, 0.97647, -1.63575>, <6.11467e-05, 5.2015e-05, 3.55162e-05>,
                         <0.384631, 0.971322, -1.58726>, <7.93094e-05, 7.31228e-05, 4.50136e-05>,
                         <0.38702, 0.970346, -1.58995>, <7.93031e-05, 7.29416e-05, 4.5074e-05> }
        smooth_triangle {<0.38702, 0.970346, -1.58995>, <5.87809e-05, 5.59796e-05, 3.36505e-05>,
                         <0.408498, 0.976523, -1.63569>, <2.92236e-05, 2.83724e-05, 1.75526e-05>,
                         <0.408413, 0.97647, -1.63575>, <2.91805e-05, 2.85543e-05, 1.7448e-05> }
        smooth_triangle {<0.384631, 0.971322, -1.58726>, <7.93094e-05, 7.31228e-05, 4.50136e-05>,
                         <0.361817, 0.966852, -1.53815>, <0.000129913, 0.000141241, 7.05556e-05>,
                         <0.366636, 0.964981, -1.54348>, <0.000129466, 0.0001417, 6.99907e-05> }
        smooth_triangle {<0.366636, 0.964981, -1.54348>, <0.000112039, 0.000120352, 6.06724e-05>,
                         <0.38702, 0.970346, -1.58995>, <7.44167e-05, 6.87825e-05, 4.19849e-05>,
                         <0.384631, 0.971322, -1.58726>, <7.44214e-05, 6.89184e-05, 4.19396e-05> }
        smooth_triangle {<0.361817, 0.966852, -1.53815>, <0.000129913, 0.000141241, 7.05556e-05>,
                         <0.340121, 0.963221, -1.48833>, <0.000170127, 0.000222894, 8.77732e-05>,
                         <0.347463, 0.960624, -1.49625>, <0.000168867, 0.000224003, 8.6241e-05> }
        smooth_triangle {<0.347463, 0.960624, -1.49625>, <0.000154548, 0.000199334, 7.88953e-05>,
                         <0.366636, 0.964981, -1.54348>, <0.000124997, 0.000137607, 6.67076e-05>,
                         <0.361817, 0.966852, -1.53815>, <0.000125333, 0.000137262, 6.71313e-05> }
        smooth_triangle {<0.340121, 0.963221, -1.48833>, <0.000170127, 0.000222894, 8.77732e-05>,
                         <0.319457, 0.960192, -1.43791>, <0.000204428, 0.000313468, 9.99596e-05>,
                         <0.329341, 0.95699, -1.44839>, <0.000202287, 0.000314623, 9.75872e-05> }
        smooth_triangle {<0.329341, 0.95699, -1.44839>, <0.000189976, 0.000287934, 9.16249e-05>,
                         <0.347463, 0.960624, -1.49625>, <0.000164911, 0.000219969, 8.31153e-05>,
                         <0.340121, 0.963221, -1.48833>, <0.000165856, 0.000219137, 8.42644e-05> }
        smooth_triangle {<0.319457, 0.960192, -1.43791>, <0.000204428, 0.000313468, 9.99596e-05>,
                         <0.299965, 0.957548, -1.38686>, <0.000235486, 0.000415873, 0.000107369>,
                         <0.312358, 0.953817, -1.39992>, <0.000232441, 0.000416196, 0.000104386> }
        smooth_triangle {<0.312358, 0.953817, -1.39992>, <0.000221454, 0.000387428, 9.97279e-05>,
                         <0.329341, 0.95699, -1.44839>, <0.000198839, 0.000311248, 9.46289e-05>,
                         <0.319457, 0.960192, -1.43791>, <0.000200445, 0.000310382, 9.64082e-05> }
        smooth_triangle {<0.299965, 0.957548, -1.38686>, <0.000235486, 0.000415873, 0.000107369>,
                         <0.282266, 0.955246, -1.33493>, <0.000263476, 0.00054208, 0.000106527>,
                         <0.297082, 0.951054, -1.3506>, <0.00025926, 0.000540093, 0.000103072> }
        smooth_triangle {<0.297082, 0.951054, -1.3506>, <0.000249468, 0.000508018, 0.000100111>,
                         <0.312358, 0.953817, -1.39992>, <0.000229354, 0.000415096, 0.000101097>,
                         <0.299965, 0.957548, -1.38686>, <0.000231638, 0.000414854, 0.000103334> }
        smooth_triangle {<0.282266, 0.955246, -1.33493>, <0.000263476, 0.00054208, 0.000106527>,
                         <0.267683, 0.953317, -1.28167>, <0.000287691, 0.000727588, 8.80083e-05>,
                         <0.284745, 0.948739, -1.30001>, <0.000281668, 0.000719495, 8.44264e-05> }
        smooth_triangle {<0.284745, 0.948739, -1.30001>, <0.000273329, 0.000678671, 8.48234e-05>,
                         <0.297082, 0.951054, -1.3506>, <0.000256523, 0.00054412, 9.88077e-05>,
                         <0.282266, 0.955246, -1.33493>, <0.000259685, 0.00054561, 0.000101399> }
        smooth_triangle {<0.267683, 0.953317, -1.28167>, <0.000287691, 0.000727588, 8.80083e-05>,
                         <0.260574, 0.951913, -1.22614>, <0.00030191, 0.00104899, 2.96966e-05>,
                         <0.279415, 0.947055, -1.24729>, <0.000293184, 0.00102563, 2.72897e-05> }
        smooth_triangle {<0.279415, 0.947055, -1.24729>, <0.000287943, 0.000969636, 3.37529e-05>,
                         <0.284745, 0.948739, -1.30001>, <0.000279307, 0.000740033, 7.66054e-05>,
                         <0.267683, 0.953317, -1.28167>, <0.000283824, 0.000746103, 7.92918e-05> }
        smooth_triangle {<0.260574, 0.951913, -1.22614>, <0.00030191, 0.00104899, 2.96966e-05>,
                         <0.270623, 0.951194, -1.16979>, <0.00027887, 0.001505, -8.55663e-05>,
                         <0.290126, 0.946192, -1.19379>, <0.0002683, 0.00145602, -8.39466e-05> }
        smooth_triangle {<0.290126, 0.946192, -1.19379>, <0.000270775, 0.0014007, -7.19083e-05>,
                         <0.279415, 0.947055, -1.24729>, <0.000289438, 0.00107791, 1.15189e-05>,
                         <0.260574, 0.951913, -1.22614>, <0.000295982, 0.00109543, 1.33241e-05> }
        smooth_triangle {<0.270623, 0.951194, -1.16979>, <0.00027887, 0.001505, -8.55663e-05>,
                         <0.30768, 0.951135, -1.12471>, <0.00017386, 0.00178529, -0.000220491>,
                         <0.326055, 0.946121, -1.15079>, <0.000166308, 0.00171887, -0.000213043> }
        smooth_triangle {<0.326055, 0.946121, -1.15079>, <0.000178925, 0.00171434, -0.000204362>,
                         <0.290126, 0.946192, -1.19379>, <0.000255419, 0.0015172, -0.000107539>,
                         <0.270623, 0.951194, -1.16979>, <0.000263346, 0.00155394, -0.000108754> }
        smooth_triangle {<0.30768, 0.951135, -1.12471>, <0.00017386, 0.00178529, -0.000220491>,
                         <0.364345, 0.951583, -1.11091>, <1.29434e-05, 0.00155663, -0.000287078>,
                         <0.38028, 0.946659, -1.137>, <1.2735e-05, 0.0015022, -0.000276932> }
        smooth_triangle {<0.38028, 0.946659, -1.137>, <2.33352e-05, 0.00154363, -0.000278141>,
                         <0.326055, 0.946121, -1.15079>, <0.000138515, 0.00170613, -0.000230224>,
                         <0.30768, 0.951135, -1.12471>, <0.000144179, 0.00175595, -0.00023581> }
        smooth_triangle {<0.364345, 0.951583, -1.11091>, <1.29434e-05, 0.00155663, -0.000287078>,
                         <0.420478, 0.952401, -1.12269>, <-9.51819e-05, 0.00110777, -0.000270796>,
                         <0.434001, 0.94764, -1.14708>, <-9.04138e-05, 0.00107764, -0.000262273> }
        smooth_triangle {<0.434001, 0.94764, -1.14708>, <-8.66251e-05, 0.00111843, -0.00026675>,
                         <0.38028, 0.946659, -1.137>, <-9.2635e-06, 0.00143685, -0.000277744>,
                         <0.364345, 0.951583, -1.11091>, <-9.1072e-06, 0.00147767, -0.000285353> }
        smooth_triangle {<0.420478, 0.952401, -1.12269>, <-9.51819e-05, 0.00110777, -0.000270796>,
                         <0.472002, 0.953527, -1.14577>, <-0.000137185, 0.00080487, -0.000239684>,
                         <0.483409, 0.948991, -1.16772>, <-0.000130994, 0.000788971, -0.000233182> }
        smooth_triangle {<0.483409, 0.948991, -1.16772>, <-0.000131049, 0.000823233, -0.000238257>,
                         <0.434001, 0.94764, -1.14708>, <-0.000100614, 0.00103973, -0.000260075>,
                         <0.420478, 0.952401, -1.12269>, <-0.00010419, 0.00106233, -0.000266468> }
        smooth_triangle {<0.472002, 0.953527, -1.14577>, <-0.000137185, 0.00080487, -0.000239684>,
                         <0.520334, 0.954948, -1.17384>, <-0.000149898, 0.000612816, -0.000212021>,
                         <0.529824, 0.950697, -1.19303>, <-0.000143815, 0.000603738, -0.000207> }
        smooth_triangle {<0.529824, 0.950697, -1.19303>, <-0.000145917, 0.000635334, -0.000212745>,
                         <0.483409, 0.948991, -1.16772>, <-0.000136301, 0.000774259, -0.000232382>,
                         <0.472002, 0.953527, -1.14577>, <-0.000140945, 0.000786184, -0.000237259> }
        smooth_triangle {<0.520334, 0.954948, -1.17384>, <-0.000149898, 0.000612816, -0.000212021>,
                         <0.566284, 0.956746, -1.20493>, <-0.000150861, 0.000461664, -0.000184137>,
                         <0.573993, 0.952854, -1.22116>, <-0.00014563, 0.000456536, -0.000180423> }
        smooth_triangle {<0.573993, 0.952854, -1.22116>, <-0.000149474, 0.000487483, -0.000187379>,
                         <0.529824, 0.950697, -1.19303>, <-0.000148113, 0.000597884, -0.000207312>,
                         <0.520334, 0.954948, -1.17384>, <-0.000152675, 0.000604693, -0.000211077> }
        smooth_triangle {<0.566284, 0.956746, -1.20493>, <-0.000150861, 0.000461664, -0.000184137>,
                         <0.609743, 0.959107, -1.23873>, <-0.000143638, 0.000323641, -0.000151923>,
                         <0.615792, 0.955688, -1.25187>, <-0.00013974, 0.000321367, -0.000149535> }
        smooth_triangle {<0.615792, 0.955688, -1.25187>, <-0.000146176, 0.000351486, -0.000158279>,
                         <0.573993, 0.952854, -1.22116>, <-0.000150593, 0.000452863, -0.000181445>,
                         <0.566284, 0.956746, -1.20493>, <-0.000154516, 0.000456709, -0.00018423> }
        smooth_triangle {<0.609743, 0.959107, -1.23873>, <-0.000143638, 0.000323641, -0.000151923>,
                         <0.650192, 0.962215, -1.27539>, <-0.000124784, 0.000199418, -0.000114068>,
                         <0.654697, 0.959417, -1.28529>, <-0.000122441, 0.000199016, -0.000112888> }
        smooth_triangle {<0.654697, 0.959417, -1.28529>, <-0.000132644, 0.000226462, -0.000123564>,
                         <0.615792, 0.955688, -1.25187>, <-0.000145619, 0.000318226, -0.000151049>,
                         <0.609743, 0.959107, -1.23873>, <-0.000148542, 0.000319931, -0.00015284> }
        smooth_triangle {<0.650192, 0.962215, -1.27539>, <-0.000124784, 0.000199418, -0.000114068>,
                         <0.687453, 0.966259, -1.31468>, <-8.96089e-05, 0.000101489, -7.19046e-05>,
                         <0.690476, 0.96427, -1.32127>, <-8.87305e-05, 0.000101669, -7.15562e-05> }
        smooth_triangle {<0.690476, 0.96427, -1.32127>, <-0.00010373, 0.000124274, -8.41604e-05>,
                         <0.654697, 0.959417, -1.28529>, <-0.000129013, 0.000197283, -0.000115159>,
                         <0.650192, 0.962215, -1.27539>, <-0.00013077, 0.000197585, -0.000116044> }
        smooth_triangle {<0.687453, 0.966259, -1.31468>, <-8.96089e-05, 0.000101489, -7.19046e-05>,
                         <0.722025, 0.971126, -1.35597>, <-3.79608e-05, 3.43344e-05, -2.77409e-05>,
                         <0.723549, 0.970111, -1.35926>, <-3.79216e-05, 3.43715e-05, -2.77342e-05> }
        smooth_triangle {<0.723549, 0.970111, -1.35926>, <-5.69601e-05, 5.15937e-05, -4.16603e-05>,
                         <0.690476, 0.96427, -1.32127>, <-9.50667e-05, 0.000102067, -7.45269e-05>,
                         <0.687453, 0.966259, -1.31468>, <-9.57255e-05, 0.000101932, -7.47882e-05> }
        smooth_triangle {<0.722025, 0.971126, -1.35597>, <-3.79608e-05, 3.43344e-05, -2.77409e-05>,
                         <0.754948, 0.97647, -1.39842>, <2.26358e-06, 1.58459e-06, 1.90289e-06>,
                         <0.754925, 0.976523, -1.39844>, <2.07249e-06, 1.48236e-06, 1.84592e-06> }
        smooth_triangle {<0.754925, 0.976523, -1.39844>, <-1.89127e-05, 1.5487e-05, -1.26486e-05>,
                         <0.723549, 0.970111, -1.35926>, <-4.3662e-05, 3.66527e-05, -3.12101e-05>,
                         <0.722025, 0.971126, -1.35597>, <-4.36913e-05, 3.66249e-05, -3.12151e-05> }
        smooth_triangle {<0.408329, 0.976417, -1.6358>, <6.10606e-05, 5.23789e-05, 3.53071e-05>,
                         <0.382243, 0.972299, -1.58458>, <7.93156e-05, 7.3304e-05, 4.49532e-05>,
                         <0.384631, 0.971322, -1.58726>, <7.93094e-05, 7.31228e-05, 4.50136e-05> }
        smooth_triangle {<0.384631, 0.971322, -1.58726>, <5.87641e-05, 5.62064e-05, 3.35529e-05>,
                         <0.408413, 0.97647, -1.63575>, <2.91375e-05, 2.87362e-05, 1.73435e-05>,
                         <0.408329, 0.976417, -1.6358>, <2.90944e-05, 2.89181e-05, 1.72389e-05> }
        smooth_triangle {<0.382243, 0.972299, -1.58458>, <7.93156e-05, 7.3304e-05, 4.49532e-05>,
                         <0.356999, 0.968722, -1.53281>, <0.00013036, 0.000140782, 7.11206e-05>,
                         <0.361817, 0.966852, -1.53815>, <0.000129913, 0.000141241, 7.05556e-05> }
        smooth_triangle {<0.361817, 0.966852, -1.53815>, <0.000112422, 0.000119961, 6.11553e-05>,
                         <0.384631, 0.971322, -1.58726>, <7.44691e-05, 6.88725e-05, 4.19988e-05>,
                         <0.382243, 0.972299, -1.58458>, <7.44738e-05, 6.90084e-05, 4.19535e-05> }
        smooth_triangle {<0.356999, 0.968722, -1.53281>, <0.00013036, 0.000140782, 7.11206e-05>,
                         <0.332779, 0.965818, -1.48041>, <0.000171387, 0.000221785, 8.93055e-05>,
                         <0.340121, 0.963221, -1.48833>, <0.000170127, 0.000222894, 8.77732e-05> }
        smooth_triangle {<0.340121, 0.963221, -1.48833>, <0.000155733, 0.000198249, 8.03497e-05>,
                         <0.361817, 0.966852, -1.53815>, <0.000125573, 0.00013701, 6.74365e-05>,
                         <0.356999, 0.968722, -1.53281>, <0.000125908, 0.000136665, 6.78602e-05> }
        smooth_triangle {<0.332779, 0.965818, -1.48041>, <0.000171387, 0.000221785, 8.93055e-05>,
                         <0.309573, 0.963395, -1.42743>, <0.00020657, 0.000312313, 0.000102332>,
                         <0.319457, 0.960192, -1.43791>, <0.000204428, 0.000313468, 9.99596e-05> }
        smooth_triangle {<0.319457, 0.960192, -1.43791>, <0.000192047, 0.000286741, 9.39429e-05>,
                         <0.340121, 0.963221, -1.48833>, <0.000166321, 0.00021881, 8.48032e-05>,
                         <0.332779, 0.965818, -1.48041>, <0.000167266, 0.000217978, 8.59523e-05> }
        smooth_triangle {<0.309573, 0.963395, -1.42743>, <0.00020657, 0.000312313, 0.000102332>,
                         <0.287572, 0.961279, -1.37381>, <0.000238532, 0.00041555, 0.000110352>,
                         <0.299965, 0.957548, -1.38686>, <0.000235486, 0.000415873, 0.000107369> }
        smooth_triangle {<0.299965, 0.957548, -1.38686>, <0.000224414, 0.000386974, 0.000102667>,
                         <0.319457, 0.960192, -1.43791>, <0.000201121, 0.00031017, 9.711e-05>,
                         <0.309573, 0.963395, -1.42743>, <0.000202727, 0.000309304, 9.88892e-05> }
        smooth_triangle {<0.287572, 0.961279, -1.37381>, <0.000238532, 0.00041555, 0.000110352>,
                         <0.26745, 0.959438, -1.31926>, <0.000267692, 0.000544067, 0.000109983>,
                         <0.282266, 0.955246, -1.33493>, <0.000263476, 0.00054208, 0.000106527> }
        smooth_triangle {<0.282266, 0.955246, -1.33493>, <0.000253563, 0.000509689, 0.000103537>,
                         <0.299965, 0.957548, -1.38686>, <0.000232571, 0.000415034, 0.000104168>,
                         <0.287572, 0.961279, -1.37381>, <0.000234855, 0.000414792, 0.000106405> }
        smooth_triangle {<0.26745, 0.959438, -1.31926>, <0.000267692, 0.000544067, 0.000109983>,
                         <0.250622, 0.957894, -1.26332>, <0.000293714, 0.000735681, 9.15902e-05>,
                         <0.267683, 0.953317, -1.28167>, <0.000287691, 0.000727588, 8.80083e-05> }
        smooth_triangle {<0.267683, 0.953317, -1.28167>, <0.000279143, 0.00068587, 8.84337e-05>,
                         <0.282266, 0.955246, -1.33493>, <0.000260981, 0.000546739, 0.000102323>,
                         <0.26745, 0.959438, -1.31926>, <0.000264143, 0.000548229, 0.000104915> }
        smooth_triangle {<0.250622, 0.957894, -1.26332>, <0.000293714, 0.000735681, 9.15902e-05>,
                         <0.241733, 0.956771, -1.20499>, <0.000310636, 0.00107235, 3.21036e-05>,
                         <0.260574, 0.951913, -1.22614>, <0.00030191, 0.00104899, 2.96966e-05> }
        smooth_triangle {<0.260574, 0.951913, -1.22614>, <0.000296413, 0.000990969, 3.63969e-05>,
                         <0.267683, 0.953317, -1.28167>, <0.000285749, 0.000749915, 8.01306e-05>,
                         <0.250622, 0.957894, -1.26332>, <0.000290266, 0.000755985, 8.28171e-05> }
        smooth_triangle {<0.241733, 0.956771, -1.20499>, <0.000310636, 0.00107235, 3.21036e-05>,
                         <0.251119, 0.956196, -1.14579>, <0.00028944, 0.00155399, -8.71861e-05>,
                         <0.270623, 0.951194, -1.16979>, <0.00027887, 0.001505, -8.55663e-05> }
        smooth_triangle {<0.270623, 0.951194, -1.16979>, <0.000281398, 0.00144733, -7.29955e-05>,
                         <0.260574, 0.951913, -1.22614>, <0.000298677, 0.00110533, 1.34517e-05>,
                         <0.241733, 0.956771, -1.20499>, <0.000305222, 0.00112285, 1.52569e-05> }
        smooth_triangle {<0.251119, 0.956196, -1.14579>, <0.00028944, 0.00155399, -8.71861e-05>,
                         <0.289306, 0.956149, -1.09862>, <0.000181411, 0.00185171, -0.000227939>,
                         <0.30768, 0.951135, -1.12471>, <0.00017386, 0.00178529, -0.000220491> }
        smooth_triangle {<0.30768, 0.951135, -1.12471>, <0.000187126, 0.0017811, -0.000211418>,
                         <0.270623, 0.951194, -1.16979>, <0.000265884, 0.00157089, -0.000110224>,
                         <0.251119, 0.956196, -1.14579>, <0.000273812, 0.00160762, -0.000111439> }
        smooth_triangle {<0.289306, 0.956149, -1.09862>, <0.000181411, 0.00185171, -0.000227939>,
                         <0.34841, 0.956507, -1.08482>, <1.31518e-05, 0.00161105, -0.000297223>,
                         <0.364345, 0.951583, -1.11091>, <1.29434e-05, 0.00155663, -0.000287078> }
        smooth_triangle {<0.364345, 0.951583, -1.11091>, <2.40802e-05, 0.00160037, -0.000288396>,
                         <0.30768, 0.951135, -1.12471>, <0.000144768, 0.00177187, -0.000238456>,
                         <0.289306, 0.956149, -1.09862>, <0.000150431, 0.00182169, -0.000244042> }
        smooth_triangle {<0.34841, 0.956507, -1.08482>, <1.31518e-05, 0.00161105, -0.000297223>,
                         <0.406955, 0.957162, -1.0983>, <-9.99501e-05, 0.00113789, -0.00027932>,
                         <0.420478, 0.952401, -1.12269>, <-9.51819e-05, 0.00110777, -0.000270796> }
        smooth_triangle {<0.420478, 0.952401, -1.12269>, <-9.12223e-05, 0.00115, -0.00027546>,
                         <0.364345, 0.951583, -1.11091>, <-1.01283e-05, 0.00148664, -0.000287671>,
                         <0.34841, 0.956507, -1.08482>, <-9.97197e-06, 0.00152746, -0.00029528> }
        smooth_triangle {<0.406955, 0.957162, -1.0983>, <-9.99501e-05, 0.00113789, -0.00027932>,
                         <0.460595, 0.958062, -1.12382>, <-0.000143376, 0.000820769, -0.000246187>,
                         <0.472002, 0.953527, -1.14577>, <-0.000137185, 0.00080487, -0.000239684> }
        smooth_triangle {<0.472002, 0.953527, -1.14577>, <-0.000137226, 0.000839803, -0.000244891>,
                         <0.420478, 0.952401, -1.12269>, <-0.000105724, 0.00106697, -0.000268225>,
                         <0.406955, 0.957162, -1.0983>, <-0.0001093, 0.00108957, -0.000274617> }
        smooth_triangle {<0.460595, 0.958062, -1.12382>, <-0.000143376, 0.000820769, -0.000246187>,
                         <0.510844, 0.959199, -1.15466>, <-0.00015598, 0.000621894, -0.000217042>,
                         <0.520334, 0.954948, -1.17384>, <-0.000149898, 0.000612816, -0.000212021> }
        smooth_triangle {<0.520334, 0.954948, -1.17384>, <-0.000152054, 0.000644776, -0.000217874>,
                         <0.472002, 0.953527, -1.14577>, <-0.00014252, 0.000788817, -0.000238621>,
                         <0.460595, 0.958062, -1.12382>, <-0.000147163, 0.000800741, -0.000243498> }
        smooth_triangle {<0.510844, 0.959199, -1.15466>, <-0.00015598, 0.000621894, -0.000217042>,
                         <0.558575, 0.960638, -1.1887>, <-0.000156092, 0.000466792, -0.00018785>,
                         <0.566284, 0.956746, -1.20493>, <-0.000150861, 0.000461664, -0.000184137> }
        smooth_triangle {<0.566284, 0.956746, -1.20493>, <-0.000154809, 0.00049287, -0.000191204>,
                         <0.520334, 0.954948, -1.17384>, <-0.000154086, 0.000606234, -0.000212117>,
                         <0.510844, 0.959199, -1.15466>, <-0.000158648, 0.000613042, -0.000215883> }
        smooth_triangle {<0.558575, 0.960638, -1.1887>, <-0.000156092, 0.000466792, -0.00018785>,
                         <0.603694, 0.962527, -1.2256>, <-0.000147536, 0.000325914, -0.00015431>,
                         <0.609743, 0.959107, -1.23873>, <-0.000143638, 0.000323641, -0.000151923> }
        smooth_triangle {<0.609743, 0.959107, -1.23873>, <-0.000150199, 0.000353955, -0.000160775>,
                         <0.566284, 0.956746, -1.20493>, <-0.000155616, 0.000457472, -0.000184935>,
                         <0.558575, 0.960638, -1.1887>, <-0.000159539, 0.000461319, -0.00018772> }
        smooth_triangle {<0.603694, 0.962527, -1.2256>, <-0.000147536, 0.000325914, -0.00015431>,
                         <0.645686, 0.965013, -1.26549>, <-0.000127126, 0.00019982, -0.000115248>,
                         <0.650192, 0.962215, -1.27539>, <-0.000124784, 0.000199418, -0.000114068> }
        smooth_triangle {<0.650192, 0.962215, -1.27539>, <-0.000135125, 0.000226942, -0.000124828>,
                         <0.609743, 0.959107, -1.23873>, <-0.000149266, 0.000320109, -0.000153219>,
                         <0.603694, 0.962527, -1.2256>, <-0.000152189, 0.000321814, -0.000155009> }
        smooth_triangle {<0.645686, 0.965013, -1.26549>, <-0.000127126, 0.00019982, -0.000115248>,
                         <0.684431, 0.968248, -1.30808>, <-9.04873e-05, 0.000101309, -7.2253e-05>,
                         <0.687453, 0.966259, -1.31468>, <-8.96089e-05, 0.000101489, -7.19046e-05> }
        smooth_triangle {<0.687453, 0.966259, -1.31468>, <-0.000104699, 0.000124085, -8.45475e-05>,
                         <0.650192, 0.962215, -1.27539>, <-0.00013108, 0.000197531, -0.00011617>,
                         <0.645686, 0.965013, -1.26549>, <-0.000132837, 0.000197833, -0.000117055> }
        smooth_triangle {<0.684431, 0.968248, -1.30808>, <-9.04873e-05, 0.000101309, -7.2253e-05>,
                         <0.720501, 0.972142, -1.35268>, <-3.8e-05, 3.42973e-05, -2.77476e-05>,
                         <0.722025, 0.971126, -1.35597>, <-3.79608e-05, 3.43344e-05, -2.77409e-05> }
        smooth_triangle {<0.722025, 0.971126, -1.35597>, <-5.7028e-05, 5.15392e-05, -4.1675e-05>,
                         <0.687453, 0.966259, -1.31468>, <-9.57641e-05, 0.000101905, -7.47978e-05>,
                         <0.684431, 0.968248, -1.30808>, <-9.64229e-05, 0.00010177, -7.50591e-05> }
        smooth_triangle {<0.720501, 0.972142, -1.35268>, <-3.8e-05, 3.42973e-05, -2.77476e-05>,
                         <0.754972, 0.976417, -1.39841>, <2.45468e-06, 1.68682e-06, 1.95987e-06>,
                         <0.754948, 0.97647, -1.39842>, <2.26358e-06, 1.58459e-06, 1.90289e-06> }
        smooth_triangle {<0.754948, 0.97647, -1.39842>, <-1.87216e-05, 1.55892e-05, -1.25917e-05>,
                         <0.722025, 0.971126, -1.35597>, <-4.36436e-05, 3.66504e-05, -3.12008e-05>,
                         <0.720501, 0.972142, -1.35268>, <-4.3673e-05, 3.66226e-05, -3.12059e-05> }
        smooth_triangle {<0.408245, 0.976364, -1.63586>, <6.09745e-05, 5.27427e-05, 3.5098e-05>,
                         <0.379854, 0.973275, -1.5819>, <7.93218e-05, 7.34852e-05, 4.48928e-05>,
                         <0.382243, 0.972299, -1.58458>, <7.93156e-05, 7.3304e-05, 4.49532e-05> }
        smooth_triangle {<0.382243, 0.972299, -1.58458>, <5.87472e-05, 5.64333e-05, 3.34553e-05>,
                         <0.408329, 0.976417, -1.6358>, <2.90514e-05, 2.91001e-05, 1.71344e-05>,
                         <0.408245, 0.976364, -1.63586>, <2.90084e-05, 2.9282e-05, 1.70298e-05> }
        smooth_triangle {<0.379854, 0.973275, -1.5819>, <7.93218e-05, 7.34852e-05, 4.48928e-05>,
                         <0.35218, 0.970593, -1.52748>, <0.000130807, 0.000140323, 7.16855e-05>,
                         <0.356999, 0.968722, -1.53281>, <0.00013036, 0.000140782, 7.11206e-05> }
        smooth_triangle {<0.356999, 0.968722, -1.53281>, <0.000112805, 0.000119571, 6.16383e-05>,
                         <0.382243, 0.972299, -1.58458>, <7.45215e-05, 6.89624e-05, 4.20127e-05>,
                         <0.379854, 0.973275, -1.5819>, <7.45262e-05, 6.90983e-05, 4.19674e-05> }
        smooth_triangle {<0.35218, 0.970593, -1.52748>, <0.000130807, 0.000140323, 7.16855e-05>,
                         <0.325438, 0.968414, -1.4725>, <0.000172647, 0.000220675, 9.08377e-05>,
                         <0.332779, 0.965818, -1.48041>, <0.000171387, 0.000221785, 8.93055e-05> }
        smooth_triangle {<0.332779, 0.965818, -1.48041>, <0.000156918, 0.000197165, 8.1804e-05>,
                         <0.356999, 0.968722, -1.53281>, <0.000126148, 0.000136413, 6.81654e-05>,
                         <0.35218, 0.970593, -1.52748>, <0.000126483, 0.000136069, 6.85891e-05> }
        smooth_triangle {<0.325438, 0.968414, -1.4725>, <0.000172647, 0.000220675, 9.08377e-05>,
                         <0.299689, 0.966597, -1.41695>, <0.000208711, 0.000311159, 0.000104704>,
                         <0.309573, 0.963395, -1.42743>, <0.00020657, 0.000312313, 0.000102332> }
        smooth_triangle {<0.309573, 0.963395, -1.42743>, <0.000194119, 0.000285548, 9.62609e-05>,
                         <0.332779, 0.965818, -1.48041>, <0.000167732, 0.000217651, 8.64911e-05>,
                         <0.325438, 0.968414, -1.4725>, <0.000168677, 0.000216819, 8.76402e-05> }
        smooth_triangle {<0.299689, 0.966597, -1.41695>, <0.000208711, 0.000311159, 0.000104704>,
                         <0.275179, 0.96501, -1.36075>, <0.000241577, 0.000415227, 0.000113336>,
                         <0.287572, 0.961279, -1.37381>, <0.000238532, 0.00041555, 0.000110352> }
        smooth_triangle {<0.287572, 0.961279, -1.37381>, <0.000227374, 0.00038652, 0.000105606>,
                         <0.309573, 0.963395, -1.42743>, <0.000203403, 0.000309093, 9.9591e-05>,
                         <0.299689, 0.966597, -1.41695>, <0.000205009, 0.000308227, 0.00010137> }
        smooth_triangle {<0.275179, 0.96501, -1.36075>, <0.000241577, 0.000415227, 0.000113336>,
                         <0.252634, 0.963629, -1.3036>, <0.000271908, 0.000546053, 0.000113438>,
                         <0.26745, 0.959438, -1.31926>, <0.000267692, 0.000544067, 0.000109983> }
        smooth_triangle {<0.26745, 0.959438, -1.31926>, <0.000257658, 0.00051136, 0.000106962>,
                         <0.287572, 0.961279, -1.37381>, <0.000235788, 0.000414973, 0.000107239>,
                         <0.275179, 0.96501, -1.36075>, <0.000238072, 0.00041473, 0.000109477> }
        smooth_triangle {<0.252634, 0.963629, -1.3036>, <0.000271908, 0.000546053, 0.000113438>,
                         <0.23356, 0.962472, -1.24497>, <0.000299737, 0.000743774, 9.51721e-05>,
                         <0.250622, 0.957894, -1.26332>, <0.000293714, 0.000735681, 9.15902e-05> }
        smooth_triangle {<0.250622, 0.957894, -1.26332>, <0.000284956, 0.000693069, 9.2044e-05>,
                         <0.26745, 0.959438, -1.31926>, <0.00026544, 0.000549358, 0.000105838>,
                         <0.252634, 0.963629, -1.3036>, <0.000268602, 0.000550848, 0.00010843> }
        smooth_triangle {<0.23356, 0.962472, -1.24497>, <0.000299737, 0.000743774, 9.51721e-05>,
                         <0.222892, 0.961629, -1.18383>, <0.000319362, 0.00109572, 3.45105e-05>,
                         <0.241733, 0.956771, -1.20499>, <0.000310636, 0.00107235, 3.21036e-05> }
        smooth_triangle {<0.241733, 0.956771, -1.20499>, <0.000304882, 0.0010123, 3.90409e-05>,
                         <0.250622, 0.957894, -1.26332>, <0.000292191, 0.000759797, 8.36559e-05>,
                         <0.23356, 0.962472, -1.24497>, <0.000296708, 0.000765867, 8.63423e-05> }
        smooth_triangle {<0.222892, 0.961629, -1.18383>, <0.000319362, 0.00109572, 3.45105e-05>,
                         <0.231616, 0.961198, -1.12179>, <0.000300011, 0.00160297, -8.88058e-05>,
                         <0.251119, 0.956196, -1.14579>, <0.00028944, 0.00155399, -8.71861e-05> }
        smooth_triangle {<0.251119, 0.956196, -1.14579>, <0.000292021, 0.00149397, -7.40827e-05>,
                         <0.241733, 0.956771, -1.20499>, <0.000307917, 0.00113274, 1.53845e-05>,
                         <0.222892, 0.961629, -1.18383>, <0.000314462, 0.00115026, 1.71898e-05> }
        smooth_triangle {<0.231616, 0.961198, -1.12179>, <0.000300011, 0.00160297, -8.88058e-05>,
                         <0.270932, 0.961163, -1.07254>, <0.000188963, 0.00191813, -0.000235387>,
                         <0.289306, 0.956149, -1.09862>, <0.000181411, 0.00185171, -0.000227939> }
        smooth_triangle {<0.289306, 0.956149, -1.09862>, <0.000195327, 0.00184786, -0.000218473>,
                         <0.251119, 0.956196, -1.14579>, <0.000276349, 0.00162457, -0.000112909>,
                         <0.231616, 0.961198, -1.12179>, <0.000284277, 0.00166131, -0.000114124> }
        smooth_triangle {<0.270932, 0.961163, -1.07254>, <0.000188963, 0.00191813, -0.000235387>,
                         <0.332475, 0.961431, -1.05873>, <1.33602e-05, 0.00166548, -0.000307369>,
                         <0.34841, 0.956507, -1.08482>, <1.31518e-05, 0.00161105, -0.000297223> }
        smooth_triangle {<0.34841, 0.956507, -1.08482>, <2.48252e-05, 0.00165712, -0.000298651>,
                         <0.289306, 0.956149, -1.09862>, <0.00015102, 0.00183761, -0.000246688>,
                         <0.270932, 0.961163, -1.07254>, <0.000156684, 0.00188742, -0.000252274> }
        smooth_triangle {<0.332475, 0.961431, -1.05873>, <1.33602e-05, 0.00166548, -0.000307369>,
                         <0.393432, 0.961922, -1.0739>, <-0.000104718, 0.00116802, -0.000287843>,
                         <0.406955, 0.957162, -1.0983>, <-9.99501e-05, 0.00113789, -0.00027932> }
        smooth_triangle {<0.406955, 0.957162, -1.0983>, <-9.58195e-05, 0.00118157, -0.00028417>,
                         <0.34841, 0.956507, -1.08482>, <-1.0993e-05, 0.00153644, -0.000297598>,
                         <0.332475, 0.961431, -1.05873>, <-1.08367e-05, 0.00157726, -0.000305207> }
        smooth_triangle {<0.393432, 0.961922, -1.0739>, <-0.000104718, 0.00116802, -0.000287843>,
                         <0.449187, 0.962598, -1.10187>, <-0.000149567, 0.000836668, -0.00025269>,
                         <0.460595, 0.958062, -1.12382>, <-0.000143376, 0.000820769, -0.000246187> }
        smooth_triangle {<0.460595, 0.958062, -1.12382>, <-0.000143403, 0.000856372, -0.000251525>,
                         <0.406955, 0.957162, -1.0983>, <-0.000110834, 0.00109421, -0.000276375>,
                         <0.393432, 0.961922, -1.0739>, <-0.00011441, 0.00111681, -0.000282767> }
        smooth_triangle {<0.449187, 0.962598, -1.10187>, <-0.000149567, 0.000836668, -0.00025269>,
                         <0.501354, 0.963451, -1.13547>, <-0.000162063, 0.000630972, -0.000222062>,
                         <0.510844, 0.959199, -1.15466>, <-0.00015598, 0.000621894, -0.000217042> }
        smooth_triangle {<0.510844, 0.959199, -1.15466>, <-0.000158192, 0.000654218, -0.000223002>,
                         <0.460595, 0.958062, -1.12382>, <-0.000148738, 0.000803375, -0.000244861>,
                         <0.449187, 0.962598, -1.10187>, <-0.000153381, 0.000815299, -0.000249738> }
        smooth_triangle {<0.501354, 0.963451, -1.13547>, <-0.000162063, 0.000630972, -0.000222062>,
                         <0.550866, 0.964529, -1.17246>, <-0.000161323, 0.00047192, -0.000191564>,
                         <0.558575, 0.960638, -1.1887>, <-0.000156092, 0.000466792, -0.00018785> }
        smooth_triangle {<0.558575, 0.960638, -1.1887>, <-0.000160143, 0.000498257, -0.000195029>,
                         <0.510844, 0.959199, -1.15466>, <-0.00016006, 0.000614583, -0.000216923>,
                         <0.501354, 0.963451, -1.13547>, <-0.000164622, 0.000621392, -0.000220688> }
        smooth_triangle {<0.550866, 0.964529, -1.17246>, <-0.000161323, 0.00047192, -0.000191564>,
                         <0.597646, 0.965946, -1.21247>, <-0.000151434, 0.000328188, -0.000156697>,
                         <0.603694, 0.962527, -1.2256>, <-0.000147536, 0.000325914, -0.00015431> }
        smooth_triangle {<0.603694, 0.962527, -1.2256>, <-0.000154222, 0.000356424, -0.00016327>,
                         <0.558575, 0.960638, -1.1887>, <-0.000160639, 0.000462082, -0.000188426>,
                         <0.550866, 0.964529, -1.17246>, <-0.000164562, 0.000465928, -0.000191211> }
        smooth_triangle {<0.597646, 0.965946, -1.21247>, <-0.000151434, 0.000328188, -0.000156697>,
                         <0.641181, 0.967811, -1.25559>, <-0.000129469, 0.000200223, -0.000116428>,
                         <0.645686, 0.965013, -1.26549>, <-0.000127126, 0.00019982, -0.000115248> }
        smooth_triangle {<0.645686, 0.965013, -1.26549>, <-0.000137605, 0.000227421, -0.000126093>,
                         <0.603694, 0.962527, -1.2256>, <-0.000152912, 0.000321992, -0.000155389>,
                         <0.597646, 0.965946, -1.21247>, <-0.000155836, 0.000323697, -0.000157179> }
        smooth_triangle {<0.641181, 0.967811, -1.25559>, <-0.000129469, 0.000200223, -0.000116428>,
                         <0.681408, 0.970237, -1.30149>, <-9.13657e-05, 0.000101129, -7.26014e-05>,
                         <0.684431, 0.968248, -1.30808>, <-9.04873e-05, 0.000101309, -7.2253e-05> }
        smooth_triangle {<0.684431, 0.968248, -1.30808>, <-0.000105668, 0.000123895, -8.49346e-05>,
                         <0.645686, 0.965013, -1.26549>, <-0.000133147, 0.000197779, -0.000117181>,
                         <0.641181, 0.967811, -1.25559>, <-0.000134904, 0.00019808, -0.000118066> }
        smooth_triangle {<0.681408, 0.970237, -1.30149>, <-9.13657e-05, 0.000101129, -7.26014e-05>,
                         <0.718977, 0.973158, -1.34939>, <-3.80391e-05, 3.42602e-05, -2.77543e-05>,
                         <0.720501, 0.972142, -1.35268>, <-3.8e-05, 3.42973e-05, -2.77476e-05> }
        smooth_triangle {<0.720501, 0.972142, -1.35268>, <-5.7096e-05, 5.14847e-05, -4.16897e-05>,
                         <0.684431, 0.968248, -1.30808>, <-9.64615e-05, 0.000101744, -7.50688e-05>,
                         <0.681408, 0.970237, -1.30149>, <-9.71203e-05, 0.000101609, -7.533e-05> }
        smooth_triangle {<0.718977, 0.973158, -1.34939>, <-3.80391e-05, 3.42602e-05, -2.77543e-05>,
                         <0.754995, 0.976364, -1.39839>, <2.64577e-06, 1.78905e-06, 2.01685e-06>,
                         <0.754972, 0.976417, -1.39841>, <2.45468e-06, 1.68682e-06, 1.95987e-06> }
        smooth_triangle {<0.754972, 0.976417, -1.39841>, <-1.85305e-05, 1.56915e-05, -1.25347e-05>,
                         <0.720501, 0.972142, -1.35268>, <-4.36252e-05, 3.66482e-05, -3.11916e-05>,
                         <0.718977, 0.973158, -1.34939>, <-4.36546e-05, 3.66204e-05, -3.11967e-05> }
        smooth_triangle {<0.408161, 0.976311, -1.63592>, <6.08884e-05, 5.31065e-05, 3.48889e-05>,
                         <0.377466, 0.974252, -1.57922>, <7.9328e-05, 7.36665e-05, 4.48323e-05>,
                         <0.379854, 0.973275, -1.5819>, <7.93218e-05, 7.34852e-05, 4.48928e-05> }
        smooth_triangle {<0.379854, 0.973275, -1.5819>, <5.87304e-05, 5.66602e-05, 3.33577e-05>,
                         <0.408245, 0.976364, -1.63586>, <2.89653e-05, 2.94639e-05, 1.69253e-05>,
                         <0.408161, 0.976311, -1.63592>, <2.89223e-05, 2.96458e-05, 1.68207e-05> }
        smooth_triangle {<0.377466, 0.974252, -1.57922>, <7.9328e-05, 7.36665e-05, 4.48323e-05>,
                         <0.347362, 0.972463, -1.52215>, <0.000131254, 0.000139864, 7.22504e-05>,
                         <0.35218, 0.970593, -1.52748>, <0.000130807, 0.000140323, 7.16855e-05> }
        smooth_triangle {<0.35218, 0.970593, -1.52748>, <0.000113188, 0.000119181, 6.21212e-05>,
                         <0.379854, 0.973275, -1.5819>, <7.45739e-05, 6.90523e-05, 4.20267e-05>,
                         <0.377466, 0.974252, -1.57922>, <7.45786e-05, 6.91882e-05, 4.19813e-05> }
        smooth_triangle {<0.347362, 0.972463, -1.52215>, <0.000131254, 0.000139864, 7.22504e-05>,
                         <0.318096, 0.971011, -1.46458>, <0.000173907, 0.000219566, 9.23699e-05>,
                         <0.325438, 0.968414, -1.4725>, <0.000172647, 0.000220675, 9.08377e-05> }
        smooth_triangle {<0.325438, 0.968414, -1.4725>, <0.000158103, 0.00019608, 8.32584e-05>,
                         <0.35218, 0.970593, -1.52748>, <0.000126723, 0.000135816, 6.88943e-05>,
                         <0.347362, 0.972463, -1.52215>, <0.000127058, 0.000135472, 6.9318e-05> }
        smooth_triangle {<0.318096, 0.971011, -1.46458>, <0.000173907, 0.000219566, 9.23699e-05>,
                         <0.289805, 0.9698, -1.40647>, <0.000210853, 0.000310004, 0.000107077>,
                         <0.299689, 0.966597, -1.41695>, <0.000208711, 0.000311159, 0.000104704> }
        smooth_triangle {<0.299689, 0.966597, -1.41695>, <0.00019619, 0.000284354, 9.85789e-05>,
                         <0.325438, 0.968414, -1.4725>, <0.000169142, 0.000216492, 8.8179e-05>,
                         <0.318096, 0.971011, -1.46458>, <0.000170087, 0.00021566, 8.93281e-05> }
        smooth_triangle {<0.289805, 0.9698, -1.40647>, <0.000210853, 0.000310004, 0.000107077>,
                         <0.262785, 0.968742, -1.34769>, <0.000244623, 0.000414904, 0.000116319>,
                         <0.275179, 0.96501, -1.36075>, <0.000241577, 0.000415227, 0.000113336> }
        smooth_triangle {<0.275179, 0.96501, -1.36075>, <0.000230334, 0.000386067, 0.000108545>,
                         <0.299689, 0.966597, -1.41695>, <0.000205684, 0.000308015, 0.000102072>,
                         <0.289805, 0.9698, -1.40647>, <0.000207291, 0.000307149, 0.000103851> }
        smooth_triangle {<0.262785, 0.968742, -1.34769>, <0.000244623, 0.000414904, 0.000116319>,
                         <0.237818, 0.967821, -1.28793>, <0.000276124, 0.00054804, 0.000116894>,
                         <0.252634, 0.963629, -1.3036>, <0.000271908, 0.000546053, 0.000113438> }
        smooth_triangle {<0.252634, 0.963629, -1.3036>, <0.000261753, 0.000513031, 0.000110388>,
                         <0.275179, 0.96501, -1.36075>, <0.000239005, 0.000414911, 0.000110311>,
                         <0.262785, 0.968742, -1.34769>, <0.000241289, 0.000414669, 0.000112548> }
        smooth_triangle {<0.237818, 0.967821, -1.28793>, <0.000276124, 0.00054804, 0.000116894>,
                         <0.216499, 0.967049, -1.22663>, <0.00030576, 0.000751867, 9.8754e-05>,
                         <0.23356, 0.962472, -1.24497>, <0.000299737, 0.000743774, 9.51721e-05> }
        smooth_triangle {<0.23356, 0.962472, -1.24497>, <0.00029077, 0.000700267, 9.56542e-05>,
                         <0.252634, 0.963629, -1.3036>, <0.000269898, 0.000551977, 0.000109354>,
                         <0.237818, 0.967821, -1.28793>, <0.00027306, 0.000553467, 0.000111945> }
        smooth_triangle {<0.216499, 0.967049, -1.22663>, <0.00030576, 0.000751867, 9.8754e-05>,
                         <0.204051, 0.966488, -1.16268>, <0.000328088, 0.00111908, 3.69175e-05>,
                         <0.222892, 0.961629, -1.18383>, <0.000319362, 0.00109572, 3.45105e-05> }
        smooth_triangle {<0.222892, 0.961629, -1.18383>, <0.000313351, 0.00103364, 4.16849e-05>,
                         <0.23356, 0.962472, -1.24497>, <0.000298633, 0.000769679, 8.71811e-05>,
                         <0.216499, 0.967049, -1.22663>, <0.00030315, 0.000775749, 8.98675e-05> }
        smooth_triangle {<0.204051, 0.966488, -1.16268>, <0.000328088, 0.00111908, 3.69175e-05>,
                         <0.212112, 0.9662, -1.09779>, <0.000310581, 0.00165196, -9.04255e-05>,
                         <0.231616, 0.961198, -1.12179>, <0.000300011, 0.00160297, -8.88058e-05> }
        smooth_triangle {<0.231616, 0.961198, -1.12179>, <0.000302643, 0.0015406, -7.51699e-05>,
                         <0.222892, 0.961629, -1.18383>, <0.000317157, 0.00116016, 1.73174e-05>,
                         <0.204051, 0.966488, -1.16268>, <0.000323702, 0.00117768, 1.91226e-05> }
        smooth_triangle {<0.212112, 0.9662, -1.09779>, <0.000310581, 0.00165196, -9.04255e-05>,
                         <0.252557, 0.966177, -1.04645>, <0.000196515, 0.00198455, -0.000242835>,
                         <0.270932, 0.961163, -1.07254>, <0.000188963, 0.00191813, -0.000235387> }
        smooth_triangle {<0.270932, 0.961163, -1.07254>, <0.000203529, 0.00191462, -0.000225529>,
                         <0.231616, 0.961198, -1.12179>, <0.000286814, 0.00167826, -0.000115594>,
                         <0.212112, 0.9662, -1.09779>, <0.000294742, 0.001715, -0.000116808> }
        smooth_triangle {<0.252557, 0.966177, -1.04645>, <0.000196515, 0.00198455, -0.000242835>,
                         <0.31654, 0.966356, -1.03265>, <1.35686e-05, 0.0017199, -0.000317515>,
                         <0.332475, 0.961431, -1.05873>, <1.33602e-05, 0.00166548, -0.000307369> }
        smooth_triangle {<0.332475, 0.961431, -1.05873>, <2.55702e-05, 0.00171386, -0.000308906>,
                         <0.270932, 0.961163, -1.07254>, <0.000157272, 0.00190335, -0.000254919>,
                         <0.252557, 0.966177, -1.04645>, <0.000162936, 0.00195316, -0.000260505> }
        smooth_triangle {<0.31654, 0.966356, -1.03265>, <1.35686e-05, 0.0017199, -0.000317515>,
                         <0.379909, 0.966683, -1.04951>, <-0.000109486, 0.00119814, -0.000296366>,
                         <0.393432, 0.961922, -1.0739>, <-0.000104718, 0.00116802, -0.000287843> }
        smooth_triangle {<0.393432, 0.961922, -1.0739>, <-0.000100417, 0.00121314, -0.00029288>,
                         <0.332475, 0.961431, -1.05873>, <-1.18578e-05, 0.00158623, -0.000307525>,
                         <0.31654, 0.966356, -1.03265>, <-1.17015e-05, 0.00162705, -0.000315134> }
        smooth_triangle {<0.379909, 0.966683, -1.04951>, <-0.000109486, 0.00119814, -0.000296366>,
                         <0.43778, 0.967133, -1.07992>, <-0.000155758, 0.000852567, -0.000259193>,
                         <0.449187, 0.962598, -1.10187>, <-0.000149567, 0.000836668, -0.00025269> }
        smooth_triangle {<0.449187, 0.962598, -1.10187>, <-0.000149581, 0.000872942, -0.000258159>,
                         <0.393432, 0.961922, -1.0739>, <-0.000115944, 0.00112145, -0.000284524>,
                         <0.379909, 0.966683, -1.04951>, <-0.00011952, 0.00114405, -0.000290917> }
        smooth_triangle {<0.43778, 0.967133, -1.07992>, <-0.000155758, 0.000852567, -0.000259193>,
                         <0.491864, 0.967702, -1.11629>, <-0.000168146, 0.00064005, -0.000227083>,
                         <0.501354, 0.963451, -1.13547>, <-0.000162063, 0.000630972, -0.000222062> }
        smooth_triangle {<0.501354, 0.963451, -1.13547>, <-0.000164329, 0.000663661, -0.000228131>,
                         <0.449187, 0.962598, -1.10187>, <-0.000154957, 0.000817933, -0.000251101>,
                         <0.43778, 0.967133, -1.07992>, <-0.0001596, 0.000829857, -0.000255978> }
        smooth_triangle {<0.491864, 0.967702, -1.11629>, <-0.000168146, 0.00064005, -0.000227083>,
                         <0.543157, 0.968421, -1.15623>, <-0.000166553, 0.000477048, -0.000195277>,
                         <0.550866, 0.964529, -1.17246>, <-0.000161323, 0.00047192, -0.000191564> }
        smooth_triangle {<0.550866, 0.964529, -1.17246>, <-0.000165478, 0.000503644, -0.000198854>,
                         <0.501354, 0.963451, -1.13547>, <-0.000166034, 0.000622933, -0.000221728>,
                         <0.491864, 0.967702, -1.11629>, <-0.000170596, 0.000629742, -0.000225493> }
        smooth_triangle {<0.543157, 0.968421, -1.15623>, <-0.000166553, 0.000477048, -0.000195277>,
                         <0.591597, 0.969366, -1.19933>, <-0.000155332, 0.000330461, -0.000159084>,
                         <0.597646, 0.965946, -1.21247>, <-0.000151434, 0.000328188, -0.000156697> }
        smooth_triangle {<0.597646, 0.965946, -1.21247>, <-0.000158246, 0.000358893, -0.000165766>,
                         <0.550866, 0.964529, -1.17246>, <-0.000165662, 0.000466692, -0.000191916>,
                         <0.543157, 0.968421, -1.15623>, <-0.000169586, 0.000470538, -0.000194701> }
        smooth_triangle {<0.591597, 0.969366, -1.19933>, <-0.000155332, 0.000330461, -0.000159084>,
                         <0.636676, 0.970609, -1.24569>, <-0.000131811, 0.000200625, -0.000117608>,
                         <0.641181, 0.967811, -1.25559>, <-0.000129469, 0.000200223, -0.000116428> }
        smooth_triangle {<0.641181, 0.967811, -1.25559>, <-0.000140086, 0.000227901, -0.000127357>,
                         <0.597646, 0.965946, -1.21247>, <-0.000156559, 0.000323875, -0.000157559>,
                         <0.591597, 0.969366, -1.19933>, <-0.000159483, 0.00032558, -0.000159349> }
        smooth_triangle {<0.636676, 0.970609, -1.24569>, <-0.000131811, 0.000200625, -0.000117608>,
                         <0.678385, 0.972226, -1.29489>, <-9.22441e-05, 0.00010095, -7.29498e-05>,
                         <0.681408, 0.970237, -1.30149>, <-9.13657e-05, 0.000101129, -7.26014e-05> }
        smooth_triangle {<0.681408, 0.970237, -1.30149>, <-0.000106637, 0.000123706, -8.53217e-05>,
                         <0.641181, 0.967811, -1.25559>, <-0.000135214, 0.000198026, -0.000118191>,
                         <0.636676, 0.970609, -1.24569>, <-0.000136971, 0.000198328, -0.000119076> }
        smooth_triangle {<0.678385, 0.972226, -1.29489>, <-9.22441e-05, 0.00010095, -7.29498e-05>,
                         <0.717453, 0.974173, -1.3461>, <-3.80783e-05, 3.42231e-05, -2.7761e-05>,
                         <0.718977, 0.973158, -1.34939>, <-3.80391e-05, 3.42602e-05, -2.77543e-05> }
        smooth_triangle {<0.718977, 0.973158, -1.34939>, <-5.71639e-05, 5.14302e-05, -4.17043e-05>,
                         <0.681408, 0.970237, -1.30149>, <-9.71589e-05, 0.000101582, -7.53397e-05>,
                         <0.678385, 0.972226, -1.29489>, <-9.78177e-05, 0.000101447, -7.5601e-05> }
        smooth_triangle {<0.717453, 0.974173, -1.3461>, <-3.80783e-05, 3.42231e-05, -2.7761e-05>,
                         <0.755019, 0.976311, -1.39837>, <2.83686e-06, 1.89128e-06, 2.07382e-06>,
                         <0.754995, 0.976364, -1.39839>, <2.64577e-06, 1.78905e-06, 2.01685e-06> }
        smooth_triangle {<0.754995, 0.976364, -1.39839>, <-1.83394e-05, 1.57937e-05, -1.24777e-05>,
                         <0.718977, 0.973158, -1.34939>, <-4.36068e-05, 3.66459e-05, -3.11824e-05>,
                         <0.717453, 0.974173, -1.3461>, <-4.36362e-05, 3.66181e-05, -3.11874e-05> }
        smooth_triangle {<0.408076, 0.976258, -1.63598>, <6.08023e-05, 5.34704e-05, 3.46797e-05>,
                         <0.375077, 0.975228, -1.57653>, <7.93343e-05, 7.38477e-05, 4.47719e-05>,
                         <0.377466, 0.974252, -1.57922>, <7.9328e-05, 7.36665e-05, 4.48323e-05> }
        smooth_triangle {<0.377466, 0.974252, -1.57922>, <5.87135e-05, 5.68871e-05, 3.32601e-05>,
                         <0.408161, 0.976311, -1.63592>, <2.88792e-05, 2.98277e-05, 1.67162e-05>,
                         <0.408076, 0.976258, -1.63598>, <2.88362e-05, 3.00096e-05, 1.66116e-05> }
        smooth_triangle {<0.375077, 0.975228, -1.57653>, <7.93343e-05, 7.38477e-05, 4.47719e-05>,
                         <0.342543, 0.974334, -1.51681>, <0.000131701, 0.000139405, 7.28153e-05>,
                         <0.347362, 0.972463, -1.52215>, <0.000131254, 0.000139864, 7.22504e-05> }
        smooth_triangle {<0.347362, 0.972463, -1.52215>, <0.000113571, 0.00011879, 6.26041e-05>,
                         <0.377466, 0.974252, -1.57922>, <7.46263e-05, 6.91422e-05, 4.20406e-05>,
                         <0.375077, 0.975228, -1.57653>, <7.4631e-05, 6.92781e-05, 4.19953e-05> }
        smooth_triangle {<0.342543, 0.974334, -1.51681>, <0.000131701, 0.000139405, 7.28153e-05>,
                         <0.310754, 0.973608, -1.45666>, <0.000175167, 0.000218456, 9.39021e-05>,
                         <0.318096, 0.971011, -1.46458>, <0.000173907, 0.000219566, 9.23699e-05> }
        smooth_triangle {<0.318096, 0.971011, -1.46458>, <0.000159288, 0.000194996, 8.47128e-05>,
                         <0.347362, 0.972463, -1.52215>, <0.000127298, 0.00013522, 6.96232e-05>,
                         <0.342543, 0.974334, -1.51681>, <0.000127634, 0.000134875, 7.00469e-05> }
        smooth_triangle {<0.310754, 0.973608, -1.45666>, <0.000175167, 0.000218456, 9.39021e-05>,
                         <0.27992, 0.973002, -1.39599>, <0.000212994, 0.00030885, 0.000109449>,
                         <0.289805, 0.9698, -1.40647>, <0.000210853, 0.000310004, 0.000107077> }
        smooth_triangle {<0.289805, 0.9698, -1.40647>, <0.000198261, 0.000283161, 0.000100897>,
                         <0.318096, 0.971011, -1.46458>, <0.000170552, 0.000215332, 8.98669e-05>,
                         <0.310754, 0.973608, -1.45666>, <0.000171497, 0.0002145, 9.1016e-05> }
        smooth_triangle {<0.27992, 0.973002, -1.39599>, <0.000212994, 0.00030885, 0.000109449>,
                         <0.250392, 0.972473, -1.33464>, <0.000247668, 0.000414581, 0.000119302>,
                         <0.262785, 0.968742, -1.34769>, <0.000244623, 0.000414904, 0.000116319> }
        smooth_triangle {<0.262785, 0.968742, -1.34769>, <0.000233294, 0.000385613, 0.000111485>,
                         <0.289805, 0.9698, -1.40647>, <0.000207966, 0.000306938, 0.000104553>,
                         <0.27992, 0.973002, -1.39599>, <0.000209572, 0.000306072, 0.000106332> }
        smooth_triangle {<0.250392, 0.972473, -1.33464>, <0.000247668, 0.000414581, 0.000119302>,
                         <0.223002, 0.972013, -1.27226>, <0.00028034, 0.000550027, 0.000120349>,
                         <0.237818, 0.967821, -1.28793>, <0.000276124, 0.00054804, 0.000116894> }
        smooth_triangle {<0.237818, 0.967821, -1.28793>, <0.000265848, 0.000514701, 0.000113813>,
                         <0.262785, 0.968742, -1.34769>, <0.000242222, 0.000414849, 0.000113382>,
                         <0.250392, 0.972473, -1.33464>, <0.000244506, 0.000414607, 0.000115619> }
        smooth_triangle {<0.223002, 0.972013, -1.27226>, <0.00028034, 0.000550027, 0.000120349>,
                         <0.199437, 0.971627, -1.20828>, <0.000311783, 0.000759961, 0.000102336>,
                         <0.216499, 0.967049, -1.22663>, <0.00030576, 0.000751867, 9.8754e-05> }
        smooth_triangle {<0.216499, 0.967049, -1.22663>, <0.000296583, 0.000707466, 9.92645e-05>,
                         <0.237818, 0.967821, -1.28793>, <0.000274356, 0.000554596, 0.000112869>,
                         <0.223002, 0.972013, -1.27226>, <0.000277518, 0.000556086, 0.000115461> }
        smooth_triangle {<0.199437, 0.971627, -1.20828>, <0.000311783, 0.000759961, 0.000102336>,
                         <0.18521, 0.971346, -1.14153>, <0.000336815, 0.00114244, 3.93244e-05>,
                         <0.204051, 0.966488, -1.16268>, <0.000328088, 0.00111908, 3.69175e-05> }
        smooth_triangle {<0.204051, 0.966488, -1.16268>, <0.000321821, 0.00105497, 4.43289e-05>,
                         <0.216499, 0.967049, -1.22663>, <0.000305075, 0.000779561, 9.07063e-05>,
                         <0.199437, 0.971627, -1.20828>, <0.000309592, 0.000785631, 9.33928e-05> }
        smooth_triangle {<0.18521, 0.971346, -1.14153>, <0.000336815, 0.00114244, 3.93244e-05>,
                         <0.192609, 0.971202, -1.07379>, <0.000321152, 0.00170095, -9.20453e-05>,
                         <0.212112, 0.9662, -1.09779>, <0.000310581, 0.00165196, -9.04255e-05> }
        smooth_triangle {<0.212112, 0.9662, -1.09779>, <0.000313266, 0.00158724, -7.6257e-05>,
                         <0.204051, 0.966488, -1.16268>, <0.000326397, 0.00118758, 1.92502e-05>,
                         <0.18521, 0.971346, -1.14153>, <0.000332941, 0.0012051, 2.10554e-05> }
        smooth_triangle {<0.192609, 0.971202, -1.07379>, <0.000321152, 0.00170095, -9.20453e-05>,
                         <0.234183, 0.97119, -1.02037>, <0.000204066, 0.00205097, -0.000250282>,
                         <0.252557, 0.966177, -1.04645>, <0.000196515, 0.00198455, -0.000242835> }
        smooth_triangle {<0.252557, 0.966177, -1.04645>, <0.00021173, 0.00198139, -0.000232585>,
                         <0.212112, 0.9662, -1.09779>, <0.00029728, 0.00173194, -0.000118279>,
                         <0.192609, 0.971202, -1.07379>, <0.000305207, 0.00176868, -0.000119493> }
        smooth_triangle {<0.234183, 0.97119, -1.02037>, <0.000204066, 0.00205097, -0.000250282>,
                         <0.300605, 0.97128, -1.00656>, <1.3777e-05, 0.00177433, -0.000327661>,
                         <0.31654, 0.966356, -1.03265>, <1.35686e-05, 0.0017199, -0.000317515> }
        smooth_triangle {<0.31654, 0.966356, -1.03265>, <2.63152e-05, 0.0017706, -0.000319161>,
                         <0.252557, 0.966177, -1.04645>, <0.000163525, 0.00196908, -0.000263151>,
                         <0.234183, 0.97119, -1.02037>, <0.000169188, 0.0020189, -0.000268737> }
        smooth_triangle {<0.300605, 0.97128, -1.00656>, <1.3777e-05, 0.00177433, -0.000327661>,
                         <0.366386, 0.971444, -1.02512>, <-0.000114255, 0.00122827, -0.00030489>,
                         <0.379909, 0.966683, -1.04951>, <-0.000109486, 0.00119814, -0.000296366> }
        smooth_triangle {<0.379909, 0.966683, -1.04951>, <-0.000105014, 0.00124471, -0.00030159>,
                         <0.31654, 0.966356, -1.03265>, <-1.27226e-05, 0.00163602, -0.000317452>,
                         <0.300605, 0.97128, -1.00656>, <-1.25663e-05, 0.00167684, -0.000325061> }
        smooth_triangle {<0.366386, 0.971444, -1.02512>, <-0.000114255, 0.00122827, -0.00030489>,
                         <0.426373, 0.971669, -1.05797>, <-0.000161949, 0.000868465, -0.000265695>,
                         <0.43778, 0.967133, -1.07992>, <-0.000155758, 0.000852567, -0.000259193> }
        smooth_triangle {<0.43778, 0.967133, -1.07992>, <-0.000155758, 0.000889511, -0.000264793>,
                         <0.379909, 0.966683, -1.04951>, <-0.000121054, 0.00114869, -0.000292674>,
                         <0.366386, 0.971444, -1.02512>, <-0.00012463, 0.00117129, -0.000299066> }
        smooth_triangle {<0.426373, 0.971669, -1.05797>, <-0.000161949, 0.000868465, -0.000265695>,
                         <0.482373, 0.971953, -1.09711>, <-0.000174229, 0.000649128, -0.000232104>,
                         <0.491864, 0.967702, -1.11629>, <-0.000168146, 0.00064005, -0.000227083> }
        smooth_triangle {<0.491864, 0.967702, -1.11629>, <-0.000170466, 0.000673103, -0.000233259>,
                         <0.43778, 0.967133, -1.07992>, <-0.000161175, 0.00083249, -0.000257341>,
                         <0.426373, 0.971669, -1.05797>, <-0.000165818, 0.000844414, -0.000262218> }
        smooth_triangle {<0.482373, 0.971953, -1.09711>, <-0.000174229, 0.000649128, -0.000232104>,
                         <0.535448, 0.972313, -1.14>, <-0.000171784, 0.000482176, -0.000198991>,
                         <0.543157, 0.968421, -1.15623>, <-0.000166553, 0.000477048, -0.000195277> }
        smooth_triangle {<0.543157, 0.968421, -1.15623>, <-0.000170813, 0.000509032, -0.000202679>,
                         <0.491864, 0.967702, -1.11629>, <-0.000172007, 0.000631283, -0.000226533>,
                         <0.482373, 0.971953, -1.09711>, <-0.000176569, 0.000638091, -0.000230299> }
        smooth_triangle {<0.535448, 0.972313, -1.14>, <-0.000171784, 0.000482176, -0.000198991>,
                         <0.585548, 0.972785, -1.1862>, <-0.00015923, 0.000332735, -0.000161471>,
                         <0.591597, 0.969366, -1.19933>, <-0.000155332, 0.000330461, -0.000159084> }
        smooth_triangle {<0.591597, 0.969366, -1.19933>, <-0.000162269, 0.000361361, -0.000168262>,
                         <0.543157, 0.968421, -1.15623>, <-0.000170686, 0.000471301, -0.000195407>,
                         <0.535448, 0.972313, -1.14>, <-0.000174609, 0.000475148, -0.000198192> }
        smooth_triangle {<0.585548, 0.972785, -1.1862>, <-0.00015923, 0.000332735, -0.000161471>,
                         <0.632171, 0.973406, -1.23579>, <-0.000134154, 0.000201027, -0.000118787>,
                         <0.636676, 0.970609, -1.24569>, <-0.000131811, 0.000200625, -0.000117608> }
        smooth_triangle {<0.636676, 0.970609, -1.24569>, <-0.000142566, 0.000228381, -0.000128621>,
                         <0.591597, 0.969366, -1.19933>, <-0.000160206, 0.000325758, -0.000159729>,
                         <0.585548, 0.972785, -1.1862>, <-0.000163129, 0.000327463, -0.000161519> }
        smooth_triangle {<0.632171, 0.973406, -1.23579>, <-0.000134154, 0.000201027, -0.000118787>,
                         <0.675362, 0.974215, -1.2883>, <-9.31225e-05, 0.00010077, -7.32982e-05>,
                         <0.678385, 0.972226, -1.29489>, <-9.22441e-05, 0.00010095, -7.29498e-05> }
        smooth_triangle {<0.678385, 0.972226, -1.29489>, <-0.000107605, 0.000123517, -8.57089e-05>,
                         <0.636676, 0.970609, -1.24569>, <-0.000137281, 0.000198274, -0.000119202>,
                         <0.632171, 0.973406, -1.23579>, <-0.000139038, 0.000198576, -0.000120087> }
        smooth_triangle {<0.675362, 0.974215, -1.2883>, <-9.31225e-05, 0.00010077, -7.32982e-05>,
                         <0.715929, 0.975189, -1.34281>, <-3.81175e-05, 3.41861e-05, -2.77677e-05>,
                         <0.717453, 0.974173, -1.3461>, <-3.80783e-05, 3.42231e-05, -2.7761e-05> }
        smooth_triangle {<0.717453, 0.974173, -1.3461>, <-5.72319e-05, 5.13757e-05, -4.1719e-05>,
                         <0.678385, 0.972226, -1.29489>, <-9.78562e-05, 0.00010142, -7.56106e-05>,
                         <0.675362, 0.974215, -1.2883>, <-9.8515e-05, 0.000101285, -7.58719e-05> }
        smooth_triangle {<0.715929, 0.975189, -1.34281>, <-3.81175e-05, 3.41861e-05, -2.77677e-05>,
                         <0.755043, 0.976258, -1.39836>, <3.02796e-06, 1.99352e-06, 2.1308e-06>,
                         <0.755019, 0.976311, -1.39837>, <2.83686e-06, 1.89128e-06, 2.07382e-06> }
        smooth_triangle {<0.755019, 0.976311, -1.39837>, <-1.81483e-05, 1.58959e-05, -1.24207e-05>,
                         <0.717453, 0.974173, -1.3461>, <-4.35884e-05, 3.66437e-05, -3.11732e-05>,
                         <0.715929, 0.975189, -1.34281>, <-4.36178e-05, 3.66159e-05, -3.11782e-05> }
        smooth_triangle {<0.407992, 0.976204, -1.63604>, <6.07162e-05, 5.38342e-05, 3.44706e-05>,
                         <0.372689, 0.976204, -1.57385>, <8.86957e-05, 8.39444e-05, 4.99365e-05>,
                         <0.375077, 0.975228, -1.57653>, <7.93343e-05, 7.38477e-05, 4.47719e-05> }
        smooth_triangle {<0.375077, 0.975228, -1.57653>, <5.86967e-05, 5.7114e-05, 3.31625e-05>,
                         <0.408076, 0.976258, -1.63598>, <2.87931e-05, 3.01915e-05, 1.65071e-05>,
                         <0.407992, 0.976204, -1.63604>, <2.87501e-05, 3.03735e-05, 1.64025e-05> }
        smooth_triangle {<0.372689, 0.976204, -1.57385>, <8.86957e-05, 8.39444e-05, 4.99365e-05>,
                         <0.337725, 0.976204, -1.51148>, <0.00013979, 0.000151483, 7.72507e-05>,
                         <0.342543, 0.974334, -1.51681>, <0.000131701, 0.000139405, 7.28153e-05> }
        smooth_triangle {<0.342543, 0.974334, -1.51681>, <0.000113954, 0.0001184, 6.30871e-05>,
                         <0.375077, 0.975228, -1.57653>, <7.46787e-05, 6.92322e-05, 4.20545e-05>,
                         <0.372689, 0.976204, -1.57385>, <7.93678e-05, 7.44248e-05, 4.45917e-05> }
        smooth_triangle {<0.337725, 0.976204, -1.51148>, <0.00013979, 0.000151483, 7.72507e-05>,
                         <0.303412, 0.976204, -1.44874>, <0.000182709, 0.00023207, 9.79915e-05>,
                         <0.310754, 0.973608, -1.45666>, <0.000175167, 0.000218456, 9.39021e-05> }
        smooth_triangle {<0.310754, 0.973608, -1.45666>, <0.000160473, 0.000193912, 8.61672e-05>,
                         <0.342543, 0.974334, -1.51681>, <0.000127874, 0.000134623, 7.03521e-05>,
                         <0.337725, 0.976204, -1.51148>, <0.00013199, 0.000141081, 7.24879e-05> }
        smooth_triangle {<0.303412, 0.976204, -1.44874>, <0.000182709, 0.00023207, 9.79915e-05>,
                         <0.270036, 0.976204, -1.38551>, <0.000220517, 0.000324583, 0.000113212>,
                         <0.27992, 0.973002, -1.39599>, <0.000212994, 0.00030885, 0.000109449> }
        smooth_triangle {<0.27992, 0.973002, -1.39599>, <0.000200333, 0.000281968, 0.000103215>,
                         <0.310754, 0.973608, -1.45666>, <0.000171962, 0.000214173, 9.15548e-05>,
                         <0.303412, 0.976204, -1.44874>, <0.000175922, 0.000221821, 9.34986e-05> }
        smooth_triangle {<0.270036, 0.976204, -1.38551>, <0.000220517, 0.000324583, 0.000113212>,
                         <0.237999, 0.976204, -1.32158>, <0.000255459, 0.000434842, 0.000122254>,
                         <0.250392, 0.972473, -1.33464>, <0.000247668, 0.000414581, 0.000119302> }
        smooth_triangle {<0.250392, 0.972473, -1.33464>, <0.000236254, 0.000385159, 0.000114424>,
                         <0.27992, 0.973002, -1.39599>, <0.000210248, 0.00030586, 0.000107034>,
                         <0.270036, 0.976204, -1.38551>, <0.000214348, 0.000315353, 0.000108738> }
        smooth_triangle {<0.237999, 0.976204, -1.32158>, <0.000255459, 0.000434842, 0.000122254>,
                         <0.208186, 0.976204, -1.2566>, <0.00028877, 0.000579786, 0.000121556>,
                         <0.223002, 0.972013, -1.27226>, <0.00028034, 0.000550027, 0.000120349> }
        smooth_triangle {<0.223002, 0.972013, -1.27226>, <0.000269943, 0.000516372, 0.000117238>,
                         <0.250392, 0.972473, -1.33464>, <0.000245439, 0.000414788, 0.000116453>,
                         <0.237999, 0.976204, -1.32158>, <0.000249889, 0.000428364, 0.000117471> }
        smooth_triangle {<0.208186, 0.976204, -1.2566>, <0.00028877, 0.000579786, 0.000121556>,
                         <0.182376, 0.976204, -1.18993>, <0.000321546, 0.00081791, 9.79568e-05>,
                         <0.199437, 0.971627, -1.20828>, <0.000311783, 0.000759961, 0.000102336> }
        smooth_triangle {<0.199437, 0.971627, -1.20828>, <0.000302397, 0.000714665, 0.000102875>,
                         <0.223002, 0.972013, -1.27226>, <0.000278814, 0.000557215, 0.000116384>,
                         <0.208186, 0.976204, -1.2566>, <0.000283925, 0.00057945, 0.000115867> }
        smooth_triangle {<0.182376, 0.976204, -1.18993>, <0.000321546, 0.00081791, 9.79568e-05>,
                         <0.166369, 0.976204, -1.12037>, <0.000345487, 0.00125508, 2.20351e-05>,
                         <0.18521, 0.971346, -1.14153>, <0.000336815, 0.00114244, 3.93244e-05> }
        smooth_triangle {<0.18521, 0.971346, -1.14153>, <0.00033029, 0.0010763, 4.69729e-05>,
                         <0.199437, 0.971627, -1.20828>, <0.000311517, 0.000789443, 9.42316e-05>,
                         <0.182376, 0.976204, -1.18993>, <0.000317936, 0.000837904, 8.86106e-05> }
        smooth_triangle {<0.166369, 0.976204, -1.12037>, <0.000345487, 0.00125508, 2.20351e-05>,
                         <0.173106, 0.976204, -1.0498>, <0.000315681, 0.00183603, -0.000123903>,
                         <0.192609, 0.971202, -1.07379>, <0.000321152, 0.00170095, -9.20453e-05> }
        smooth_triangle {<0.192609, 0.971202, -1.07379>, <0.000323889, 0.00163388, -7.73442e-05>,
                         <0.18521, 0.971346, -1.14153>, <0.000335637, 0.00121499, 2.1183e-05>,
                         <0.166369, 0.976204, -1.12037>, <0.000341025, 0.00131427, 3.60969e-06> }
        smooth_triangle {<0.173106, 0.976204, -1.0498>, <0.000315681, 0.00183603, -0.000123903>,
                         <0.215808, 0.976204, -0.994284>, <0.000173182, 0.00207524, -0.000276601>,
                         <0.234183, 0.97119, -1.02037>, <0.000204066, 0.00205097, -0.000250282> }
        smooth_triangle {<0.234183, 0.97119, -1.02037>, <0.000219931, 0.00204815, -0.000239641>,
                         <0.192609, 0.971202, -1.07379>, <0.000307745, 0.00178563, -0.000120963>,
                         <0.173106, 0.976204, -1.0498>, <0.000299629, 0.00190391, -0.000151842> }
        smooth_triangle {<0.215808, 0.976204, -0.994284>, <0.000173182, 0.00207524, -0.000276601>,
                         <0.28467, 0.976204, -0.980469>, <-1.42121e-05, 0.00170299, -0.000331871>,
                         <0.300605, 0.97128, -1.00656>, <1.3777e-05, 0.00177433, -0.000327661> }
        smooth_triangle {<0.300605, 0.97128, -1.00656>, <2.70601e-05, 0.00182734, -0.000329416>,
                         <0.234183, 0.97119, -1.02037>, <0.000169777, 0.00203482, -0.000271383>,
                         <0.215808, 0.976204, -0.994284>, <0.000137758, 0.00204562, -0.000295962> }
        smooth_triangle {<0.28467, 0.976204, -0.980469>, <-1.42121e-05, 0.00170299, -0.000331871>,
                         <0.352863, 0.976204, -1.00073>, <-0.000128267, 0.00117495, -0.00030316>,
                         <0.366386, 0.971444, -1.02512>, <-0.000114255, 0.00122827, -0.00030489> }
        smooth_triangle {<0.366386, 0.971444, -1.02512>, <-0.000109611, 0.00127627, -0.000310301>,
                         <0.300605, 0.97128, -1.00656>, <-1.35873e-05, 0.00168582, -0.000327379>,
                         <0.28467, 0.976204, -0.980469>, <-4.13683e-05, 0.00160876, -0.000330092> }
        smooth_triangle {<0.352863, 0.976204, -1.00073>, <-0.000128267, 0.00117495, -0.00030316>,
                         <0.414966, 0.976204, -1.03602>, <-0.0001691, 0.000837001, -0.000263947>,
                         <0.426373, 0.971669, -1.05797>, <-0.000161949, 0.000868465, -0.000265695> }
        smooth_triangle {<0.426373, 0.971669, -1.05797>, <-0.000161935, 0.00090608, -0.000271428>,
                         <0.366386, 0.971444, -1.02512>, <-0.000126164, 0.00117593, -0.000300823>,
                         <0.352863, 0.976204, -1.00073>, <-0.000139476, 0.00112294, -0.000298315> }
        smooth_triangle {<0.414966, 0.976204, -1.03602>, <-0.0001691, 0.000837001, -0.000263947>,
                         <0.472883, 0.976204, -1.07792>, <-0.000178258, 0.000625295, -0.00022985>,
                         <0.482373, 0.971953, -1.09711>, <-0.000174229, 0.000649128, -0.000232104> }
        smooth_triangle {<0.482373, 0.971953, -1.09711>, <-0.000176603, 0.000682545, -0.000238387>,
                         <0.426373, 0.971669, -1.05797>, <-0.000167393, 0.000847048, -0.000263581>,
                         <0.414966, 0.976204, -1.03602>, <-0.000173976, 0.000818933, -0.000261711> }
        smooth_triangle {<0.472883, 0.976204, -1.07792>, <-0.000178258, 0.000625295, -0.00022985>,
                         <0.527738, 0.976204, -1.12376>, <-0.000173499, 0.000459327, -0.000195237>,
                         <0.535448, 0.972313, -1.14>, <-0.000171784, 0.000482176, -0.000198991> }
        smooth_triangle {<0.535448, 0.972313, -1.14>, <-0.000176148, 0.000514419, -0.000206504>,
                         <0.482373, 0.971953, -1.09711>, <-0.000177981, 0.000639633, -0.000231339>,
                         <0.472883, 0.976204, -1.07792>, <-0.000181918, 0.000620579, -0.000229581> }
        smooth_triangle {<0.527738, 0.976204, -1.12376>, <-0.000173499, 0.000459327, -0.000195237>,
                         <0.5795, 0.976204, -1.17307>, <-0.000158192, 0.000310207, -0.000155879>,
                         <0.585548, 0.972785, -1.1862>, <-0.00015923, 0.000332735, -0.000161471> }
        smooth_triangle {<0.585548, 0.972785, -1.1862>, <-0.000166293, 0.00036383, -0.000170758>,
                         <0.535448, 0.972313, -1.14>, <-0.000175709, 0.000475911, -0.000198897>,
                         <0.527738, 0.976204, -1.12376>, <-0.00017816, 0.000458589, -0.000196364> }
        smooth_triangle {<0.5795, 0.976204, -1.17307>, <-0.000158192, 0.000310207, -0.000155879>,
                         <0.627665, 0.976204, -1.22589>, <-0.000129404, 0.000182361, -0.00011181>,
                         <0.632171, 0.973406, -1.23579>, <-0.000134154, 0.000201027, -0.000118787> }
        smooth_triangle {<0.632171, 0.973406, -1.23579>, <-0.000145046, 0.00022886, -0.000129886>,
                         <0.585548, 0.972785, -1.1862>, <-0.000163853, 0.000327641, -0.000161899>,
                         <0.5795, 0.976204, -1.17307>, <-0.000164703, 0.000310924, -0.000158313> }
        smooth_triangle {<0.627665, 0.976204, -1.22589>, <-0.000129404, 0.000182361, -0.00011181>,
                         <0.672339, 0.976204, -1.28171>, <-8.48705e-05, 8.806e-05, -6.57896e-05>,
                         <0.675362, 0.974215, -1.2883>, <-9.31225e-05, 0.00010077, -7.32982e-05> }
        smooth_triangle {<0.675362, 0.974215, -1.2883>, <-0.000108574, 0.000123328, -8.6096e-05>,
                         <0.632171, 0.973406, -1.23579>, <-0.000139348, 0.000198521, -0.000120213>,
                         <0.627665, 0.976204, -1.22589>, <-0.000137913, 0.000185242, -0.000116037> }
        smooth_triangle {<0.672339, 0.976204, -1.28171>, <-8.48705e-05, 8.806e-05, -6.57896e-05>,
                         <0.714405, 0.976204, -1.33952>, <-2.7798e-05, 2.61496e-05, -2.02813e-05>,
                         <0.715929, 0.975189, -1.34281>, <-3.81175e-05, 3.41861e-05, -2.77677e-05> }
        smooth_triangle {<0.715929, 0.975189, -1.34281>, <-5.72999e-05, 5.13212e-05, -4.17337e-05>,
                         <0.675362, 0.974215, -1.2883>, <-9.85536e-05, 0.000101259, -7.58815e-05>,
                         <0.672339, 0.976204, -1.28171>, <-9.48626e-05, 9.29488e-05, -7.17369e-05> }
        smooth_triangle {<0.714405, 0.976204, -1.33952>, <-2.7798e-05, 2.61496e-05, -2.02813e-05>,
                         <0.755066, 0.976204, -1.39834>, <3.12351e-06, 2.04463e-06, 2.15929e-06>,
                         <0.755043, 0.976258, -1.39836>, <3.02796e-06, 1.99352e-06, 2.1308e-06> }
        smooth_triangle {<0.755043, 0.976258, -1.39836>, <-1.79572e-05, 1.59982e-05, -1.23638e-05>,
                         <0.715929, 0.975189, -1.34281>, <-4.357e-05, 3.66414e-05, -3.1164e-05>,
                         <0.714405, 0.976204, -1.33952>, <-3.85079e-05, 3.21022e-05, -2.73052e-05> }
        texture { Semi_smooth_steel }
    }
    merge { // Poly_Pipe
        cone { <0.567578, 0.876888, -1.49797>, 0.02, <0.567858, 0.900498, -1.49838>, 0.02 }
        sphere { <0.567858, 0.900498, -1.49838>, 0.02 }
        cone { <0.567858, 0.900498, -1.49838>, 0.02, <0.568292, 0.9241, -1.49902>, 0.02 }
        sphere { <0.568292, 0.9241, -1.49902>, 0.02 }
        cone { <0.568292, 0.9241, -1.49902>, 0.02, <0.569022, 0.947678, -1.50008>, 0.02 }
        sphere { <0.569022, 0.947678, -1.50008>, 0.02 }
        cone { <0.569022, 0.947678, -1.50008>, 0.02, <0.570174, 0.971203, -1.50176>, 0.02 }
        sphere { <0.570174, 0.971203, -1.50176>, 0.02 }
        cone { <0.570174, 0.971203, -1.50176>, 0.02, <0.571819, 0.994636, -1.50417>, 0.02 }
        sphere { <0.571819, 0.994636, -1.50417>, 0.02 }
        cone { <0.571819, 0.994636, -1.50417>, 0.02, <0.574035, 1.01792, -1.5074>, 0.02 }
        sphere { <0.574035, 1.01792, -1.5074>, 0.02 }
        cone { <0.574035, 1.01792, -1.5074>, 0.02, <0.577011, 1.04093, -1.51175>, 0.02 }
        sphere { <0.577011, 1.04093, -1.51175>, 0.02 }
        cone { <0.577011, 1.04093, -1.51175>, 0.02, <0.58151, 1.06312, -1.51832>, 0.02 }
        sphere { <0.58151, 1.06312, -1.51832>, 0.02 }
        cone { <0.58151, 1.06312, -1.51832>, 0.02, <0.589795, 1.08134, -1.53042>, 0.02 }
        sphere { <0.589795, 1.08134, -1.53042>, 0.02 }
        cone { <0.589795, 1.08134, -1.53042>, 0.02, <0.601605, 1.09207, -1.54766>, 0.02 }
        sphere { <0.601605, 1.09207, -1.54766>, 0.02 }
        cone { <0.601605, 1.09207, -1.54766>, 0.02, <0.614483, 1.09817, -1.56646>, 0.02 }
        sphere { <0.614483, 1.09817, -1.56646>, 0.02 }
        cone { <0.614483, 1.09817, -1.56646>, 0.02, <0.627664, 1.1018, -1.58571>, 0.02 }
        sphere { <0.627664, 1.1018, -1.58571>, 0.02 }
        cone { <0.627664, 1.1018, -1.58571>, 0.02, <0.640956, 1.10382, -1.60512>, 0.02 }
        sphere { <0.640956, 1.10382, -1.60512>, 0.02 }
        cone { <0.640956, 1.10382, -1.60512>, 0.02, <0.654291, 1.10453, -1.62459>, 0.02 }
        sphere { <0.654291, 1.10453, -1.62459>, 0.02 }
        cone { <0.654291, 1.10453, -1.62459>, 0.02, <0.667632, 1.10416, -1.64407>, 0.02 }
        sphere { <0.667632, 1.10416, -1.64407>, 0.02 }
        cone { <0.667632, 1.10416, -1.64407>, 0.02, <0.680966, 1.10324, -1.66354>, 0.02 }
        texture { Semi_smooth_steel }
    }
    cone { <0.0, 0.0, 0.0>, 0.05, <0.0, 0.25, 0.0>, 0.05  
        texture { DMFWood4 }
        rotate <269.427, .0, .0>
        rotate <.0, 325.595, .0>
        translate <0.666087, 1.10182, -1.64466>
    }
    sphere { <0.0, 0.0, 0.0>, 0.05 
        texture { DMFWood4 }
        scale <1, 1, 0.5>
        rotate <.0, 325.595, .0>
        translate <0.665956, 1.10201, -1.64447>
    }
    sphere { <0.0, 0.0, 0.0>, 0.05 
        texture { DMFWood4 }
        scale <1, 1, 0.5>
        rotate <.0, 325.595, .0>
        translate <0.807556, 1.09999, -1.85123>
    }
}

union {  // Layer name: brushA
    box { <0.0, 0.0, 0.0>, <0.0777802, 0.0750981, 0.351352> 
        texture { DMFWood4 }
        rotate <.0, 283.829, .0>
        translate <-2.67596, 1.19307, 0.767479>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.26012, 0.862557>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.26012, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.26012, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.26012, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.26012, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.26012, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.26012, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.26012, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.26012, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.26012, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.26012, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.26012, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.26012, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.26012, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.26012, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.26012, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.26012, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.26012, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.26012, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.26012, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.26012, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.26012, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.26012, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.26012, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.26012, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.26012, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.26012, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.26012, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.26012, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.26012, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.26012, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.26012, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.26012, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.26012, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.26012, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.26012, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.26012, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.26012, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.26012, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.26012, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.26012, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.26012, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.26012, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.26012, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.26012, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.26012, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.26012, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.26012, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.26012, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.26012, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.26012, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.26012, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.26012, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.26012, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.26012, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.26012, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.26012, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.26012, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.26012, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.26012, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.26012, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.26012, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.26012, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.24939, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.23866, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.22793, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.2172, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68317, 1.20648, 0.783064>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.24939, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.23866, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.22793, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.2172, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.68838, 1.20648, 0.784347>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.24939, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.23866, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.22793, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.2172, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.69359, 1.20648, 0.785629>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.24939, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.23866, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.22793, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.2172, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.6988, 1.20648, 0.786911>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.24939, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.23866, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.22793, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.2172, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.704, 1.20648, 0.788193>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.24939, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.23866, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.22793, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.2172, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.70921, 1.20648, 0.789475>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.24939, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.23866, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.22793, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.2172, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71442, 1.20648, 0.790757>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.24939, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.23866, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.22793, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.2172, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.71963, 1.20648, 0.792039>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.24939, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.23866, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.22793, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.2172, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.72484, 1.20648, 0.793322>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.24939, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.23866, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.22793, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.2172, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73005, 1.20648, 0.794604>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.24939, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.23866, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.22793, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.2172, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.73526, 1.20648, 0.795886>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.24939, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.23866, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.22793, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.2172, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74046, 1.20648, 0.797168>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.24939, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.23866, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.22793, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.2172, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.74567, 1.20648, 0.79845>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.24939, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.23866, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.22793, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.2172, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75088, 1.20648, 0.799732>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.24939, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.23866, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.22793, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.2172, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.75609, 1.20648, 0.801014>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.24939, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.23866, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.22793, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.2172, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.7613, 1.20648, 0.802297>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.24939, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.23866, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.22793, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.2172, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.76651, 1.20648, 0.803579>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.24939, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.23866, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.22793, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.2172, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77172, 1.20648, 0.804861>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.24939, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.23866, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.22793, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.2172, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.77693, 1.20648, 0.806143>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.24939, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.23866, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.22793, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.2172, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78213, 1.20648, 0.807425>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.24939, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.23866, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.22793, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.2172, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.78734, 1.20648, 0.808707>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.24939, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.23866, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.22793, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.2172, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79255, 1.20648, 0.809989>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.24939, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.23866, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.22793, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.2172, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.79776, 1.20648, 0.811271>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.24939, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.23866, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.22793, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.2172, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80297, 1.20648, 0.812554>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.24939, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.23866, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.22793, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.2172, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.80818, 1.20648, 0.813836>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.24939, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.23866, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.22793, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.2172, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81339, 1.20648, 0.815118>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.24939, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.23866, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.22793, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.2172, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.81859, 1.20648, 0.8164>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.24939, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.23866, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.22793, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.2172, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8238, 1.20648, 0.817682>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.24939, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.23866, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.22793, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.2172, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.82901, 1.20648, 0.818964>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.24939, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.23866, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.22793, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.2172, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83422, 1.20648, 0.820246>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.24939, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.23866, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.22793, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.2172, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.83943, 1.20648, 0.821529>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.24939, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.23866, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.22793, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.2172, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84464, 1.20648, 0.822811>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.24939, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.23866, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.22793, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.2172, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.84985, 1.20648, 0.824093>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.24939, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.23866, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.22793, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.2172, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.85506, 1.20648, 0.825375>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.24939, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.23866, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.22793, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.2172, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86026, 1.20648, 0.826657>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.24939, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.23866, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.22793, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.2172, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.86547, 1.20648, 0.827939>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.24939, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.23866, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.22793, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.2172, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87068, 1.20648, 0.829221>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.24939, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.23866, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.22793, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.2172, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.87589, 1.20648, 0.830503>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.24939, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.23866, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.22793, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.2172, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.8811, 1.20648, 0.831786>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.24939, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.23866, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.22793, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.2172, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.88631, 1.20648, 0.833068>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.24939, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.23866, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.22793, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.2172, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89152, 1.20648, 0.83435>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.24939, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.23866, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.22793, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.2172, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.89672, 1.20648, 0.835632>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.24939, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.23866, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.22793, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.2172, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90193, 1.20648, 0.836914>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.24939, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.23866, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.22793, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.2172, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.90714, 1.20648, 0.838196>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.24939, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.23866, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.22793, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.2172, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91235, 1.20648, 0.839478>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.24939, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.23866, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.22793, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.2172, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.91756, 1.20648, 0.840761>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.24939, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.23866, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.22793, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.2172, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92277, 1.20648, 0.842043>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.24939, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.23866, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.22793, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.2172, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.92798, 1.20648, 0.843325>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.24939, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.23866, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.22793, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.2172, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93319, 1.20648, 0.844607>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.24939, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.23866, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.22793, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.2172, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.93839, 1.20648, 0.845889>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.24939, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.23866, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.22793, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.2172, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.9436, 1.20648, 0.847171>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.24939, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.23866, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.22793, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.2172, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.94881, 1.20648, 0.848453>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.24939, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.23866, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.22793, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.2172, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95402, 1.20648, 0.849735>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.24939, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.23866, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.22793, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.2172, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.95923, 1.20648, 0.851018>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.24939, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.23866, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.22793, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.2172, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96444, 1.20648, 0.8523>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.24939, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.23866, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.22793, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.2172, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.96965, 1.20648, 0.853582>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.24939, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.23866, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.22793, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.2172, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.97485, 1.20648, 0.854864>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.24939, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.23866, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.22793, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.2172, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98006, 1.20648, 0.856146>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.24939, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.23866, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.22793, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.2172, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.98527, 1.20648, 0.857428>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.24939, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.23866, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.22793, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.2172, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99048, 1.20648, 0.85871>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.24939, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.23866, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.22793, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.2172, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-2.99569, 1.20648, 0.859993>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.24939, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.23866, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.22793, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.2172, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.0009, 1.20648, 0.861275>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.24939, 0.862557>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.23866, 0.862557>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.22793, 0.862557>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.2172, 0.862557>
    }
    cone { <0.0, 0.0, 0.0>, 0.001, <0.0, 0.32186, 0.0>, 0.001  
        texture { Plane_White }
        rotate <.0, .0, 90>
        rotate <.0, 283.829, .0>
        translate <-3.00611, 1.20648, 0.862557>
    }
    union { // Surface of Revolution
        smooth_triangle {<-2.87017, 1.20026, 0.892637>, <0.000157804, -3.21275e-05, -3.45228e-05>,
                         <-2.86544, 1.2004, 0.914131>, <0.000151008, -5.21502e-05, -3.27878e-05>,
                         <-2.86686, 1.19307, 0.914468>, <0.000158983, 1.09436e-05, -3.46782e-05> }
        smooth_triangle {<-2.86686, 1.19307, 0.914468>, <0.000157903, 3.35816e-07, -3.44675e-05>,
                         <-2.87156, 1.19307, 0.892967>, <0.000156233, 3.19302e-07, -3.4179e-05>,
                         <-2.87017, 1.20026, 0.892637>, <0.000156233, -3.18075e-05, -3.4179e-05> }
        smooth_triangle {<-2.86544, 1.2004, 0.914131>, <0.000151008, -5.21502e-05, -3.27878e-05>,
                         <-2.86074, 1.20057, 0.935633>, <0.000154634, -5.33388e-05, -3.31417e-05>,
                         <-2.86219, 1.19307, 0.935977>, <0.000162785, 1.12269e-05, -3.50737e-05> }
        smooth_triangle {<-2.86219, 1.19307, 0.935977>, <0.000161555, 3.88609e-07, -3.48641e-05>,
                         <-2.86686, 1.19307, 0.914468>, <0.000158704, 1.76118e-07, -3.45676e-05>,
                         <-2.86544, 1.2004, 0.914131>, <0.000152723, -4.71443e-05, -3.31497e-05> }
        smooth_triangle {<-2.86074, 1.20057, 0.935633>, <0.000154634, -5.33388e-05, -3.31417e-05>,
                         <-2.85613, 1.20076, 0.957152>, <0.000159256, -5.48036e-05, -3.32227e-05>,
                         <-2.85762, 1.19307, 0.957505>, <0.000167618, 1.16019e-05, -3.52047e-05> }
        smooth_triangle {<-2.85762, 1.19307, 0.957505>, <0.000166083, 4.93788e-07, -3.49912e-05>,
                         <-2.86219, 1.19307, 0.935977>, <0.000162458, 2.12577e-07, -3.4893e-05>,
                         <-2.86074, 1.20057, 0.935633>, <0.000156345, -4.82117e-05, -3.3444e-05> }
        smooth_triangle {<-2.85613, 1.20076, 0.957152>, <0.000159256, -5.48036e-05, -3.32227e-05>,
                         <-2.85166, 1.20102, 0.978701>, <0.000165834, -5.68039e-05, -3.27307e-05>,
                         <-2.8532, 1.19307, 0.979066>, <0.000174475, 1.21597e-05, -3.47788e-05> }
        smooth_triangle {<-2.8532, 1.19307, 0.979066>, <0.000172339, 7.00777e-07, -3.45806e-05>,
                         <-2.85762, 1.19307, 0.957505>, <0.000167197, 2.824e-07, -3.49e-05>,
                         <-2.85613, 1.20076, 0.957152>, <0.000160925, -4.95217e-05, -3.34135e-05> }
        smooth_triangle {<-2.85166, 1.20102, 0.978701>, <0.000165834, -5.68039e-05, -3.27307e-05>,
                         <-2.8475, 1.20141, 1.00031>, <0.000176546, -5.98976e-05, -3.06558e-05>,
                         <-2.84911, 1.19307, 1.00069>, <0.000185602, 1.31073e-05, -3.28025e-05> }
        smooth_triangle {<-2.84911, 1.19307, 1.00069>, <0.000182208, 1.13386e-06, -3.27261e-05>,
                         <-2.8532, 1.19307, 0.979066>, <0.000173862, 4.23157e-07, -3.42084e-05>,
                         <-2.85166, 1.20102, 0.978701>, <0.000167381, -5.12996e-05, -3.26723e-05> }
        smooth_triangle {<-2.8475, 1.20141, 1.00031>, <0.000176546, -5.98976e-05, -3.06558e-05>,
                         <-2.84401, 1.20208, 1.02203>, <0.000195244, -6.51445e-05, -2.48308e-05>,
                         <-2.84576, 1.19307, 1.02244>, <0.000205006, 1.47083e-05, -2.71447e-05> }
        smooth_triangle {<-2.84576, 1.19307, 1.02244>, <0.000199112, 1.93102e-06, -2.73582e-05>,
                         <-2.84911, 1.19307, 1.00069>, <0.00018456, 7.30279e-07, -3.16015e-05>,
                         <-2.8475, 1.20141, 1.00031>, <0.000177767, -5.40234e-05, -2.99915e-05> }
        smooth_triangle {<-2.84401, 1.20208, 1.02203>, <0.000195244, -6.51445e-05, -2.48308e-05>,
                         <-2.84173, 1.20324, 1.04388>, <0.000224733, -7.35599e-05, -1.40649e-05>,
                         <-2.8437, 1.19307, 1.04435>, <0.000235687, 1.69638e-05, -1.66614e-05> }
        smooth_triangle {<-2.8437, 1.19307, 1.04435>, <0.000226125, 2.9567e-06, -1.71307e-05>,
                         <-2.84576, 1.19307, 1.02244>, <0.000203114, 1.26505e-06, -2.49932e-05>,
                         <-2.84401, 1.20208, 1.02203>, <0.000195792, -5.86245e-05, -2.32577e-05> }
        smooth_triangle {<-2.84173, 1.20324, 1.04388>, <0.000224733, -7.35599e-05, -1.40649e-05>,
                         <-2.84072, 1.20493, 1.0658>, <0.000262435, -8.48528e-05, -2.83336e-06>,
                         <-2.84302, 1.19307, 1.06635>, <0.000275069, 1.95783e-05, -5.82798e-06> }
        smooth_triangle {<-2.84302, 1.19307, 1.06635>, <0.00026228, 3.76949e-06, -6.10873e-06>,
                         <-2.8437, 1.19307, 1.04435>, <0.000232743, 1.80861e-06, -1.42338e-05>,
                         <-2.84173, 1.20324, 1.04388>, <0.000224527, -6.60842e-05, -1.22864e-05> }
        smooth_triangle {<-2.84072, 1.20493, 1.0658>, <0.000262435, -8.48528e-05, -2.83336e-06>,
                         <-2.84026, 1.20684, 1.08772>, <0.000302073, -9.75694e-05, 1.17771e-06>,
                         <-2.84292, 1.19307, 1.08836>, <0.000316653, 2.22353e-05, -2.27843e-06> }
        smooth_triangle {<-2.84292, 1.19307, 1.08836>, <0.000302783, 4.02636e-06, -1.98405e-06>,
                         <-2.84302, 1.19307, 1.06635>, <0.000271595, 2.03367e-06, -4.64622e-06>,
                         <-2.84072, 1.20493, 1.0658>, <0.000262119, -7.62897e-05, -2.40025e-06> }
        smooth_triangle {<-2.84026, 1.20684, 1.08772>, <0.000302073, -9.75694e-05, 1.17771e-06>,
                         <-2.83963, 1.20868, 1.10965>, <0.000337657, -0.000110103, -6.064e-06>,
                         <-2.84265, 1.19307, 1.11036>, <0.000354216, 2.45456e-05, -9.98913e-06> }
        smooth_triangle {<-2.84265, 1.19307, 1.11036>, <0.000341446, 3.69793e-06, -8.43563e-06>,
                         <-2.84292, 1.19307, 1.08836>, <0.000313274, 1.9652e-06, -2.6526e-06>,
                         <-2.84026, 1.20684, 1.08772>, <0.000302338, -8.78883e-05, -6.0497e-08> }
        smooth_triangle {<-2.83963, 1.20868, 1.10965>, <0.000337657, -0.000110103, -6.064e-06>,
                         <-2.83809, 1.21015, 1.13155>, <0.000361263, -0.000120339, -2.88843e-05>,
                         <-2.8414, 1.19307, 1.13233>, <0.000379543, 2.58927e-05, -3.32172e-05> }
        smooth_triangle {<-2.8414, 1.19307, 1.13233>, <0.000370416, 2.5965e-06, -2.98039e-05>,
                         <-2.84265, 1.19307, 1.11036>, <0.000351421, 1.58617e-06, -1.23828e-05>,
                         <-2.83963, 1.20868, 1.10965>, <0.000339001, -9.93999e-05, -9.43893e-06> }
        smooth_triangle {<-2.83809, 1.21015, 1.13155>, <0.000361263, -0.000120339, -2.88843e-05>,
                         <-2.83476, 1.21089, 1.15328>, <0.000360304, -0.000124749, -7.03413e-05>,
                         <-2.83821, 1.19307, 1.15409>, <0.000379587, 2.512e-05, -7.4912e-05> }
        smooth_triangle {<-2.83821, 1.19307, 1.15409>, <0.000377666, 2.19613e-07, -6.98079e-05>,
                         <-2.8414, 1.19307, 1.13233>, <0.000377632, 7.99093e-07, -3.85368e-05>,
                         <-2.83809, 1.21015, 1.13155>, <0.000363922, -0.000108875, -3.52871e-05> }
        smooth_triangle {<-2.83476, 1.21089, 1.15328>, <0.000360304, -0.000124749, -7.03413e-05>,
                         <-2.82844, 1.21035, 1.17431>, <0.000307035, -0.000115594, -0.000129202>,
                         <-2.83178, 1.19307, 1.1751>, <0.000325742, 1.89379e-05, -0.000133637> }
        smooth_triangle {<-2.83178, 1.19307, 1.1751>, <0.000337896, -5.22436e-06, -0.00012886>,
                         <-2.83821, 1.19307, 1.15409>, <0.00037828, -5.87743e-07, -8.48168e-05>,
                         <-2.83476, 1.21089, 1.15328>, <0.000363817, -0.00011299, -8.13888e-05> }
        smooth_triangle {<-2.82844, 1.21035, 1.17431>, <0.000307035, -0.000115594, -0.000129202>,
                         <-2.8164, 1.20721, 1.19221>, <0.000171629, -7.86595e-05, -0.000164897>,
                         <-2.81914, 1.19307, 1.19286>, <0.000185732, 5.79086e-06, -0.00016824> }
        smooth_triangle {<-2.81914, 1.19307, 1.19286>, <0.00021603, -1.30137e-05, -0.000180797>,
                         <-2.83178, 1.19307, 1.1751>, <0.000321037, -3.15346e-06, -0.000154845>,
                         <-2.82844, 1.21035, 1.17431>, <0.000307007, -0.000104052, -0.000151519> }
        smooth_triangle {<-2.8164, 1.20721, 1.19221>, <0.000171629, -7.86595e-05, -0.000164897>,
                         <-2.79751, 1.20034, 1.20007>, <3.2969e-05, -2.20678e-05, -8.94759e-05>,
                         <-2.79892, 1.19307, 1.2004>, <3.72817e-05, -2.1419e-07, -9.04981e-05> }
        smooth_triangle {<-2.79892, 1.19307, 1.2004>, <5.46178e-05, -8.59968e-06, -0.000139361>,
                         <-2.81914, 1.19307, 1.19286>, <0.000165956, -4.09589e-06, -0.000197668>,
                         <-2.8164, 1.20721, 1.19221>, <0.000155378, -6.74337e-05, -0.00019516> }
        smooth_triangle {<-2.79751, 1.20034, 1.20007>, <3.2969e-05, -2.20678e-05, -8.94759e-05>,
                         <-2.77725, 1.19202, 1.19844>, <2.33286e-06, 1.23613e-06, 2.27812e-05>,
                         <-2.77705, 1.19307, 1.1984>, <2.09361e-06, 7.52075e-12, 2.28379e-05> }
        smooth_triangle {<-2.77705, 1.19307, 1.1984>, <-3.46926e-06, -1.49305e-06, -3.7844e-05>,
                         <-2.79892, 1.19307, 1.2004>, <2.43125e-05, -1.28043e-06, -0.000107676>,
                         <-2.79751, 1.20034, 1.20007>, <2.1078e-05, -1.76707e-05, -0.000106909> }
        smooth_triangle {<-2.86621, 1.20636, 0.891698>, <0.000133878, -9.149e-05, -2.88516e-05>,
                         <-2.86139, 1.20663, 0.913172>, <0.000120146, -0.000107305, -2.54724e-05>,
                         <-2.86544, 1.2004, 0.914131>, <0.000151008, -5.21502e-05, -3.27878e-05> }
        smooth_triangle {<-2.86544, 1.2004, 0.914131>, <0.000146059, -6.15296e-05, -3.166e-05>,
                         <-2.87017, 1.20026, 0.892637>, <0.000144508, -6.08976e-05, -3.13998e-05>,
                         <-2.86621, 1.20636, 0.891698>, <0.000132545, -9.05788e-05, -2.85642e-05> }
        smooth_triangle {<-2.86139, 1.20663, 0.913172>, <0.000120146, -0.000107305, -2.54724e-05>,
                         <-2.85661, 1.20693, 0.934653>, <0.000123062, -0.000109784, -2.56581e-05>,
                         <-2.86074, 1.20057, 0.935633>, <0.000154634, -5.33388e-05, -3.31417e-05> }
        smooth_triangle {<-2.86074, 1.20057, 0.935633>, <0.000149461, -6.28758e-05, -3.19974e-05>,
                         <-2.86544, 1.2004, 0.914131>, <0.000146741, -6.19844e-05, -3.1732e-05>,
                         <-2.86139, 1.20663, 0.913172>, <0.000123595, -0.00010335, -2.62455e-05> }
        smooth_triangle {<-2.85661, 1.20693, 0.934653>, <0.000123062, -0.000109784, -2.56581e-05>,
                         <-2.85188, 1.20729, 0.956146>, <0.000126804, -0.000112866, -2.55305e-05>,
                         <-2.85613, 1.20076, 0.957152>, <0.000159256, -5.48036e-05, -3.32227e-05> }
        smooth_triangle {<-2.85613, 1.20076, 0.957152>, <0.000153699, -6.44758e-05, -3.20559e-05>,
                         <-2.86074, 1.20057, 0.935633>, <0.000150233, -6.33772e-05, -3.19951e-05>,
                         <-2.85661, 1.20693, 0.934653>, <0.000126553, -0.000105711, -2.63824e-05> }
        smooth_triangle {<-2.85188, 1.20729, 0.956146>, <0.000126804, -0.000112866, -2.55305e-05>,
                         <-2.84728, 1.20776, 0.977662>, <0.000132171, -0.00011712, -2.47516e-05>,
                         <-2.85166, 1.20102, 0.978701>, <0.000165834, -5.68039e-05, -3.27307e-05> }
        smooth_triangle {<-2.85166, 1.20102, 0.978701>, <0.000159589, -6.6578e-05, -3.15583e-05>,
                         <-2.85613, 1.20076, 0.957152>, <0.000154656, -6.50778e-05, -3.19274e-05>,
                         <-2.85188, 1.20729, 0.956146>, <0.000130316, -0.000108624, -2.61582e-05> }
        smooth_triangle {<-2.84728, 1.20776, 0.977662>, <0.000132171, -0.00011712, -2.47516e-05>,
                         <-2.8429, 1.20848, 0.999219>, <0.000140995, -0.000123784, -2.22291e-05>,
                         <-2.8475, 1.20141, 1.00031>, <0.000176546, -5.98976e-05, -3.06558e-05> }
        smooth_triangle {<-2.8475, 1.20141, 1.00031>, <0.000168939, -6.96889e-05, -2.9581e-05>,
                         <-2.85166, 1.20102, 0.978701>, <0.000160905, -6.73686e-05, -3.11372e-05>,
                         <-2.84728, 1.20776, 0.977662>, <0.000135657, -0.000112605, -2.51528e-05> }
        smooth_triangle {<-2.8429, 1.20848, 0.999219>, <0.000140995, -0.000123784, -2.22291e-05>,
                         <-2.83905, 1.20972, 1.02085>, <0.000156491, -0.00013508, -1.56451e-05>,
                         <-2.84401, 1.20208, 1.02203>, <0.000195244, -6.51445e-05, -2.48308e-05> }
        smooth_triangle {<-2.84401, 1.20208, 1.02203>, <0.000185014, -7.47734e-05, -2.40164e-05>,
                         <-2.8475, 1.20141, 1.00031>, <0.00017099, -7.08382e-05, -2.83851e-05>,
                         <-2.8429, 1.20848, 0.999219>, <0.000144327, -0.000118753, -2.2065e-05> }
        smooth_triangle {<-2.83905, 1.20972, 1.02085>, <0.000156491, -0.00013508, -1.56451e-05>,
                         <-2.83612, 1.21187, 1.04255>, <0.000180905, -0.000152885, -3.6763e-06>,
                         <-2.84173, 1.20324, 1.04388>, <0.000224733, -7.35599e-05, -1.40649e-05> }
        smooth_triangle {<-2.84173, 1.20324, 1.04388>, <0.000210636, -8.29814e-05, -1.34594e-05>,
                         <-2.84401, 1.20208, 1.02203>, <0.000188519, -7.66699e-05, -2.15338e-05>,
                         <-2.83905, 1.20972, 1.02085>, <0.000159454, -0.000129121, -1.46445e-05> }
        smooth_triangle {<-2.83612, 1.21187, 1.04255>, <0.000180905, -0.000152885, -3.6763e-06>,
                         <-2.83418, 1.21499, 1.06425>, <0.000211877, -0.000176366, 9.15059e-06>,
                         <-2.84072, 1.20493, 1.0658>, <0.000262435, -8.48528e-05, -2.83336e-06> }
        smooth_triangle {<-2.84072, 1.20493, 1.0658>, <0.000244676, -9.47206e-05, -1.93614e-06>,
                         <-2.84173, 1.20324, 1.04388>, <0.000216399, -8.6251e-05, -1.03598e-05>,
                         <-2.83612, 1.21187, 1.04255>, <0.000183528, -0.000145745, -2.56835e-06> }
        smooth_triangle {<-2.83418, 1.21499, 1.06425>, <0.000211877, -0.000176366, 9.15059e-06>,
                         <-2.83267, 1.21852, 1.08592>, <0.00024399, -0.00020252, 1.49449e-05>,
                         <-2.84026, 1.20684, 1.08772>, <0.000302073, -9.75694e-05, 1.17771e-06> }
        smooth_triangle {<-2.84026, 1.20684, 1.08772>, <0.000282426, -0.000109201, 2.84109e-06>,
                         <-2.84072, 1.20493, 1.0658>, <0.000252698, -9.96638e-05, -1.67213e-07>,
                         <-2.83418, 1.21499, 1.06425>, <0.000214779, -0.000168299, 8.82075e-06> }
        smooth_triangle {<-2.83267, 1.21852, 1.08592>, <0.00024399, -0.00020252, 1.49449e-05>,
                         <-2.83102, 1.22192, 1.10761>, <0.000272219, -0.000227989, 9.44664e-06>,
                         <-2.83963, 1.20868, 1.10965>, <0.000337657, -0.000110103, -6.064e-06> }
        smooth_triangle {<-2.83963, 1.20868, 1.10965>, <0.00031807, -0.000124471, -2.89489e-06>,
                         <-2.84026, 1.20684, 1.08772>, <0.000291382, -0.000115071, 2.53639e-06>,
                         <-2.83267, 1.21852, 1.08592>, <0.00024782, -0.000193784, 1.28618e-05> }
        smooth_triangle {<-2.83102, 1.22192, 1.10761>, <0.000272219, -0.000227989, 9.44664e-06>,
                         <-2.82867, 1.22464, 1.12931>, <0.000289923, -0.00024825, -1.19745e-05>,
                         <-2.83809, 1.21015, 1.13155>, <0.000361263, -0.000120339, -2.88843e-05> }
        smooth_triangle {<-2.83809, 1.21015, 1.13155>, <0.000344177, -0.000138162, -2.35845e-05>,
                         <-2.83963, 1.20868, 1.10965>, <0.000326473, -0.000130485, -6.46927e-06>,
                         <-2.83102, 1.22192, 1.10761>, <0.000277395, -0.000218899, 5.16371e-06> }
        smooth_triangle {<-2.82867, 1.22464, 1.12931>, <0.000289923, -0.00024825, -1.19745e-05>,
                         <-2.82494, 1.22599, 1.15095>, <0.000286682, -0.000255627, -5.28908e-05>,
                         <-2.83476, 1.21089, 1.15328>, <0.000360304, -0.000124749, -7.03413e-05> }
        smooth_triangle {<-2.83476, 1.21089, 1.15328>, <0.000349336, -0.000146588, -6.30929e-05>,
                         <-2.83809, 1.21015, 1.13155>, <0.000350055, -0.000143281, -3.20002e-05>,
                         <-2.82867, 1.22464, 1.12931>, <0.00029655, -0.000239214, -1.93178e-05> }
        smooth_triangle {<-2.82494, 1.22599, 1.15095>, <0.000286682, -0.000255627, -5.28908e-05>,
                         <-2.81891, 1.225, 1.17205>, <0.000239656, -0.000232528, -0.000113232>,
                         <-2.82844, 1.21035, 1.17431>, <0.000307035, -0.000115594, -0.000129202> }
        smooth_triangle {<-2.82844, 1.21035, 1.17431>, <0.000309397, -0.000142021, -0.000122105>,
                         <-2.83476, 1.21089, 1.15328>, <0.000349349, -0.000148888, -7.79593e-05>,
                         <-2.82494, 1.22599, 1.15095>, <0.000294133, -0.000247046, -6.48714e-05> }
        smooth_triangle {<-2.81891, 1.225, 1.17205>, <0.000239656, -0.000232528, -0.000113232>,
                         <-2.80861, 1.2192, 1.19036>, <0.000127152, -0.000151135, -0.000154355>,
                         <-2.8164, 1.20721, 1.19221>, <0.000171629, -7.86595e-05, -0.000164897> }
        smooth_triangle {<-2.8164, 1.20721, 1.19221>, <0.000192526, -0.000108423, -0.000175226>,
                         <-2.82844, 1.21035, 1.17431>, <0.00029408, -0.000136124, -0.000148455>,
                         <-2.81891, 1.225, 1.17205>, <0.000243546, -0.000223824, -0.000136477> }
        smooth_triangle {<-2.80861, 1.2192, 1.19036>, <0.000127152, -0.000151135, -0.000154355>,
                         <-2.7935, 1.20651, 1.19912>, <2.08471e-05, -4.05619e-05, -8.66026e-05>,
                         <-2.79751, 1.20034, 1.20007>, <3.2969e-05, -2.20678e-05, -8.94759e-05> }
        smooth_triangle {<-2.79751, 1.20034, 1.20007>, <4.50985e-05, -4.05832e-05, -0.000137105>,
                         <-2.8164, 1.20721, 1.19221>, <0.000149093, -8.30269e-05, -0.000193671>,
                         <-2.80861, 1.2192, 1.19036>, <0.000115736, -0.000137383, -0.000185764> }
        smooth_triangle {<-2.7935, 1.20651, 1.19912>, <2.08471e-05, -4.05619e-05, -8.66026e-05>,
                         <-2.77782, 1.19114, 1.19858>, <3.01419e-06, 2.28407e-06, 2.26197e-05>,
                         <-2.77725, 1.19202, 1.19844>, <2.33286e-06, 1.23613e-06, 2.27812e-05> }
        smooth_triangle {<-2.77725, 1.19202, 1.19844>, <-4.42167e-06, -3.42774e-06, -3.76182e-05>,
                         <-2.79751, 1.20034, 1.20007>, <2.02441e-05, -1.97397e-05, -0.000106711>,
                         <-2.7935, 1.20651, 1.19912>, <1.11526e-05, -3.36103e-05, -0.000104556> }
        smooth_triangle {<-2.86027, 1.21043, 0.890291>, <8.9669e-05, -0.000136924, -1.83726e-05>,
                         <-2.85534, 1.21078, 0.911737>, <7.10947e-05, -0.000146123, -1.38459e-05>,
                         <-2.86139, 1.20663, 0.913172>, <0.000120146, -0.000107305, -2.54724e-05> }
        smooth_triangle {<-2.86139, 1.20663, 0.913172>, <0.00011208, -0.000114028, -2.3606e-05>,
                         <-2.86621, 1.20636, 0.891698>, <0.000110881, -0.000112843, -2.34291e-05>,
                         <-2.86027, 1.21043, 0.890291>, <8.87759e-05, -0.00013556, -1.81896e-05> }
        smooth_triangle {<-2.85534, 1.21078, 0.911737>, <7.10947e-05, -0.000146123, -1.38459e-05>,
                         <-2.85042, 1.21117, 0.933186>, <7.28741e-05, -0.000149516, -1.37622e-05>,
                         <-2.85661, 1.20693, 0.934653>, <0.000123062, -0.000109784, -2.56581e-05> }
        smooth_triangle {<-2.85661, 1.20693, 0.934653>, <0.00011473, -0.000116568, -2.37651e-05>,
                         <-2.86139, 1.20663, 0.913172>, <0.000112543, -0.000114708, -2.36258e-05>,
                         <-2.85534, 1.21078, 0.911737>, <7.57545e-05, -0.000143822, -1.49059e-05> }
        smooth_triangle {<-2.85042, 1.21117, 0.933186>, <7.28741e-05, -0.000149516, -1.37622e-05>,
                         <-2.84554, 1.21164, 0.954641>, <7.52013e-05, -0.000153745, -1.32992e-05>,
                         <-2.85188, 1.20729, 0.956146>, <0.000126804, -0.000112866, -2.55305e-05> }
        smooth_triangle {<-2.85188, 1.20729, 0.956146>, <0.000118066, -0.000119629, -2.36097e-05>,
                         <-2.85661, 1.20693, 0.934653>, <0.000115259, -0.000117318, -2.37054e-05>,
                         <-2.85042, 1.21117, 0.933186>, <7.76184e-05, -0.000147117, -1.47834e-05> }
        smooth_triangle {<-2.84554, 1.21164, 0.954641>, <7.52013e-05, -0.000153745, -1.32992e-05>,
                         <-2.84071, 1.21227, 0.976107>, <7.86109e-05, -0.000159605, -1.20563e-05>,
                         <-2.84728, 1.20776, 0.977662>, <0.000132171, -0.00011712, -2.47516e-05> }
        smooth_triangle {<-2.84728, 1.20776, 0.977662>, <0.000122756, -0.000123721, -2.2828e-05>,
                         <-2.85188, 1.20729, 0.956146>, <0.000118731, -0.00012053, -2.34122e-05>,
                         <-2.84554, 1.21164, 0.954641>, <8.00293e-05, -0.00015119, -1.42387e-05> }
        smooth_triangle {<-2.84071, 1.21227, 0.976107>, <7.86109e-05, -0.000159605, -1.20563e-05>,
                         <-2.83602, 1.2132, 0.997588>, <8.43604e-05, -0.000168825, -8.80506e-06>,
                         <-2.8429, 1.20848, 0.999219>, <0.000140995, -0.000123784, -2.22291e-05> }
        smooth_triangle {<-2.8429, 1.20848, 0.999219>, <0.000130308, -0.000129902, -2.04244e-05>,
                         <-2.84728, 1.20776, 0.977662>, <0.00012369, -0.000124904, -2.23163e-05>,
                         <-2.84071, 1.21227, 0.976107>, <8.35204e-05, -0.000156768, -1.27948e-05> }
        smooth_triangle {<-2.83602, 1.2132, 0.997588>, <8.43604e-05, -0.000168825, -8.80506e-06>,
                         <-2.83161, 1.21482, 1.01909>, <9.46462e-05, -0.00018445, -9.86057e-07>,
                         <-2.83905, 1.20972, 1.02085>, <0.000156491, -0.00013508, -1.56451e-05> }
        smooth_triangle {<-2.83905, 1.20972, 1.02085>, <0.000143426, -0.000140094, -1.41589e-05>,
                         <-2.8429, 1.20848, 0.999219>, <0.000131804, -0.000131622, -1.90968e-05>,
                         <-2.83602, 1.2132, 0.997588>, <8.93284e-05, -0.000165403, -9.02882e-06> }
        smooth_triangle {<-2.83161, 1.21482, 1.01909>, <9.46462e-05, -0.00018445, -9.86057e-07>,
                         <-2.82772, 1.21764, 1.04056>, <0.000110875, -0.000208934, 1.29229e-05>,
                         <-2.83612, 1.21187, 1.04255>, <0.000180905, -0.000152885, -3.6763e-06> }
        smooth_triangle {<-2.83612, 1.21187, 1.04255>, <0.000164326, -0.000156286, -2.48245e-06>,
                         <-2.83905, 1.20972, 1.02085>, <0.000146015, -0.000142933, -1.14591e-05>,
                         <-2.83161, 1.21482, 1.01909>, <9.96317e-05, -0.00017996, -4.64769e-07> }
        smooth_triangle {<-2.82772, 1.21764, 1.04056>, <0.000110875, -0.000208934, 1.29229e-05>,
                         <-2.82439, 1.22171, 1.06193>, <0.00013109, -0.000241029, 2.82994e-05>,
                         <-2.83418, 1.21499, 1.06425>, <0.000211877, -0.000176366, 9.15059e-06> }
        smooth_triangle {<-2.83418, 1.21499, 1.06425>, <0.000191738, -0.00017879, 1.06117e-05>,
                         <-2.83612, 1.21187, 1.04255>, <0.000168509, -0.00016118, 9.91576e-07>,
                         <-2.82772, 1.21764, 1.04056>, <0.000115987, -0.000203217, 1.3441e-05> }
        smooth_triangle {<-2.82439, 1.22171, 1.06193>, <0.00013109, -0.000241029, 2.82994e-05>,
                         <-2.8213, 1.22632, 1.08323>, <0.000151249, -0.000276639, 3.69273e-05>,
                         <-2.83267, 1.21852, 1.08592>, <0.00024399, -0.00020252, 1.49449e-05> }
        smooth_triangle {<-2.83267, 1.21852, 1.08592>, <0.000221457, -0.000205804, 1.72926e-05>,
                         <-2.83418, 1.21499, 1.06425>, <0.000197372, -0.000186188, 1.29469e-05>,
                         <-2.82439, 1.22171, 1.06193>, <0.000136782, -0.000234686, 2.73085e-05> }
        smooth_triangle {<-2.8213, 1.22632, 1.08323>, <0.000151249, -0.000276639, 3.69273e-05>,
                         <-2.81814, 1.23076, 1.10455>, <0.000167866, -0.000311165, 3.41814e-05>,
                         <-2.83102, 1.22192, 1.10761>, <0.000272219, -0.000227989, 9.44664e-06> }
        smooth_triangle {<-2.83102, 1.22192, 1.10761>, <0.000248748, -0.00023369, 1.35365e-05>,
                         <-2.83267, 1.21852, 1.08592>, <0.000227577, -0.000214589, 1.76602e-05>,
                         <-2.8213, 1.22632, 1.08323>, <0.000158021, -0.000270178, 3.4147e-05> }
        smooth_triangle {<-2.81814, 1.23076, 1.10455>, <0.000167866, -0.000311165, 3.41814e-05>,
                         <-2.81458, 1.23432, 1.12597>, <0.000176383, -0.000338367, 1.49378e-05>,
                         <-2.82867, 1.22464, 1.12931>, <0.000289923, -0.00024825, -1.19745e-05> }
        smooth_triangle {<-2.82867, 1.22464, 1.12931>, <0.000267522, -0.000257886, -5.41494e-06>,
                         <-2.83102, 1.22192, 1.10761>, <0.000254245, -0.00024269, 1.06509e-05>,
                         <-2.81814, 1.23076, 1.10455>, <0.00017598, -0.000305073, 2.9202e-05> }
        smooth_triangle {<-2.81458, 1.23432, 1.12597>, <0.000176383, -0.000338367, 1.49378e-05>,
                         <-2.81024, 1.23609, 1.14746>, <0.000169931, -0.000347588, -2.52171e-05>,
                         <-2.82494, 1.22599, 1.15095>, <0.000286682, -0.000255627, -5.28908e-05> }
        smooth_triangle {<-2.82494, 1.22599, 1.15095>, <0.000268497, -0.00027108, -4.39316e-05>,
                         <-2.82867, 1.22464, 1.12931>, <0.000270927, -0.000265547, -1.32444e-05>,
                         <-2.81458, 1.23432, 1.12597>, <0.000185772, -0.000333135, 6.93984e-06> }
        smooth_triangle {<-2.81024, 1.23609, 1.14746>, <0.000169931, -0.000347588, -2.52171e-05>,
                         <-2.80466, 1.23479, 1.16867>, <0.000133864, -0.000314062, -8.81557e-05>,
                         <-2.81891, 1.225, 1.17205>, <0.000239656, -0.000232528, -0.000113232> }
        smooth_triangle {<-2.81891, 1.225, 1.17205>, <0.000232128, -0.000257196, -0.00010379>,
                         <-2.82494, 1.22599, 1.15095>, <0.000267398, -0.000274521, -5.85346e-05>,
                         <-2.81024, 1.23609, 1.14746>, <0.000179834, -0.000343491, -3.77793e-05> }
        smooth_triangle {<-2.80466, 1.23479, 1.16867>, <0.000133864, -0.000314062, -8.81557e-05>,
                         <-2.79694, 1.22721, 1.1876>, <5.90739e-05, -0.000200601, -0.000138218>,
                         <-2.80861, 1.2192, 1.19036>, <0.000127152, -0.000151135, -0.000154355> }
        smooth_triangle {<-2.80861, 1.2192, 1.19036>, <0.000135284, -0.000187325, -0.000161658>,
                         <-2.81891, 1.225, 1.17205>, <0.000219662, -0.00024837, -0.000130815>,
                         <-2.80466, 1.23479, 1.16867>, <0.000140318, -0.000309521, -0.000112009> }
        smooth_triangle {<-2.79694, 1.22721, 1.1876>, <5.90739e-05, -0.000200601, -0.000138218>,
                         <-2.7875, 1.21064, 1.19769>, <2.7613e-06, -5.28807e-05, -8.23157e-05>,
                         <-2.7935, 1.20651, 1.19912>, <2.08471e-05, -4.05619e-05, -8.66026e-05> }
        smooth_triangle {<-2.7935, 1.20651, 1.19912>, <2.43943e-05, -6.63883e-05, -0.000132198>,
                         <-2.80861, 1.2192, 1.19036>, <0.000104123, -0.000149318, -0.000183011>,
                         <-2.79694, 1.22721, 1.1876>, <5.30644e-05, -0.000186418, -0.000170909> }
        smooth_triangle {<-2.7875, 1.21064, 1.19769>, <2.7613e-06, -5.28807e-05, -8.23157e-05>,
                         <-2.77868, 1.19054, 1.19878>, <4.03388e-06, 2.98427e-06, 2.2378e-05>,
                         <-2.77782, 1.19114, 1.19858>, <3.01419e-06, 2.28407e-06, 2.26197e-05> }
        smooth_triangle {<-2.77782, 1.19114, 1.19858>, <-6.022e-06, -4.84059e-06, -3.72389e-05>,
                         <-2.7935, 1.20651, 1.19912>, <9.6117e-06, -3.51939e-05, -0.000104191>,
                         <-2.7875, 1.21064, 1.19769>, <-3.95263e-06, -4.4433e-05, -0.000100976> }
        smooth_triangle {<-2.85327, 1.21186, 0.888632>, <3.19067e-05, -0.000161513, -4.68123e-06>,
                         <-2.8482, 1.21224, 0.910045>, <1.13231e-05, -0.000162695, 3.21722e-07>,
                         <-2.85534, 1.21078, 0.911737>, <7.10947e-05, -0.000146123, -1.38459e-05> }
        smooth_triangle {<-2.85534, 1.21078, 0.911737>, <6.11388e-05, -0.000149166, -1.15315e-05>,
                         <-2.86027, 1.21043, 0.890291>, <6.04701e-05, -0.00014761, -1.14803e-05>,
                         <-2.85327, 1.21186, 0.888632>, <3.15889e-05, -0.000159904, -4.63461e-06> }
        smooth_triangle {<-2.8482, 1.21224, 0.910045>, <1.13231e-05, -0.000162695, 3.21722e-07>,
                         <-2.84312, 1.21267, 0.931456>, <1.17122e-05, -0.000166485, 7.35035e-07>,
                         <-2.85042, 1.21117, 0.933186>, <7.28741e-05, -0.000149516, -1.37622e-05> }
        smooth_triangle {<-2.85042, 1.21117, 0.933186>, <6.2649e-05, -0.000152514, -1.14204e-05>,
                         <-2.85534, 1.21078, 0.911737>, <6.13144e-05, -0.000149969, -1.14832e-05>,
                         <-2.8482, 1.21224, 0.910045>, <1.64857e-05, -0.000162398, -8.57474e-07> }
        smooth_triangle {<-2.84312, 1.21267, 0.931456>, <1.17122e-05, -0.000166485, 7.35035e-07>,
                         <-2.83805, 1.21318, 0.952866>, <1.23048e-05, -0.000171218, 1.60916e-06>,
                         <-2.84554, 1.21164, 0.954641>, <7.52013e-05, -0.000153745, -1.32992e-05> }
        smooth_triangle {<-2.84554, 1.21164, 0.954641>, <6.46072e-05, -0.000156571, -1.09384e-05>,
                         <-2.85042, 1.21117, 0.933186>, <6.28618e-05, -0.000153399, -1.12857e-05>,
                         <-2.84312, 1.21267, 0.931456>, <1.69904e-05, -0.000166126, -4.1278e-07> }
        smooth_triangle {<-2.83805, 1.21318, 0.952866>, <1.23048e-05, -0.000171218, 1.60916e-06>,
                         <-2.83297, 1.21385, 0.974272>, <1.33079e-05, -0.000177792, 3.4225e-06>,
                         <-2.84071, 1.21227, 0.976107>, <7.86109e-05, -0.000159605, -1.20563e-05> }
        smooth_triangle {<-2.84071, 1.21227, 0.976107>, <6.74498e-05, -0.000162028, -9.71867e-06>,
                         <-2.84554, 1.21164, 0.954641>, <6.48926e-05, -0.000157633, -1.06509e-05>,
                         <-2.83805, 1.21318, 0.952866>, <1.77202e-05, -0.000170738, 5.30398e-07> }
        smooth_triangle {<-2.83297, 1.21385, 0.974272>, <1.33079e-05, -0.000177792, 3.4225e-06>,
                         <-2.8279, 1.21486, 0.995664>, <1.52654e-05, -0.000188164, 7.57252e-06>,
                         <-2.83602, 1.2132, 0.997588>, <8.43604e-05, -0.000168825, -8.80506e-06> }
        smooth_triangle {<-2.83602, 1.2132, 0.997588>, <7.21967e-05, -0.000170339, -6.65021e-06>,
                         <-2.84071, 1.21227, 0.976107>, <6.78845e-05, -0.000163424, -9.08861e-06>,
                         <-2.83297, 1.21385, 0.974272>, <1.89072e-05, -0.000177064, 2.52045e-06> }
        smooth_triangle {<-2.8279, 1.21486, 0.995664>, <1.52654e-05, -0.000188164, 7.57252e-06>,
                         <-2.82284, 1.21661, 1.01701>, <1.91251e-05, -0.00020574, 1.69147e-05>,
                         <-2.83161, 1.21482, 1.01909>, <9.46462e-05, -0.00018445, -9.86057e-07> }
        smooth_triangle {<-2.83161, 1.21482, 1.01909>, <8.06812e-05, -0.000184087, 7.13589e-07>,
                         <-2.83602, 1.2132, 0.997588>, <7.29669e-05, -0.000172368, -5.15066e-06>,
                         <-2.8279, 1.21486, 0.995664>, <2.11456e-05, -0.000186872, 7.13252e-06> }
        smooth_triangle {<-2.82284, 1.21661, 1.01701>, <1.91251e-05, -0.00020574, 1.69147e-05>,
                         <-2.81782, 1.21967, 1.03821>, <2.53046e-05, -0.000233176, 3.32056e-05>,
                         <-2.82772, 1.21764, 1.04056>, <0.000110875, -0.000208934, 1.29229e-05> }
        smooth_triangle {<-2.82772, 1.21764, 1.04056>, <9.42443e-05, -0.000205798, 1.41289e-05>,
                         <-2.83161, 1.21482, 1.01909>, <8.20729e-05, -0.000187435, 3.6972e-06>,
                         <-2.82284, 1.21661, 1.01701>, <2.54321e-05, -0.000203402, 1.71228e-05> }
        smooth_triangle {<-2.81782, 1.21967, 1.03821>, <2.53046e-05, -0.000233176, 3.32056e-05>,
                         <-2.81284, 1.22407, 1.05919>, <3.23747e-05, -0.000268997, 5.16979e-05>,
                         <-2.82439, 1.22171, 1.06193>, <0.00013109, -0.000241029, 2.82994e-05> }
        smooth_triangle {<-2.82439, 1.22171, 1.06193>, <0.000111525, -0.000235641, 2.96246e-05>,
                         <-2.82772, 1.21764, 1.04056>, <9.63636e-05, -0.00021157, 1.80922e-05>,
                         <-2.81782, 1.21967, 1.03821>, <3.2186e-05, -0.000229751, 3.33042e-05> }
        smooth_triangle {<-2.81284, 1.22407, 1.05919>, <3.23747e-05, -0.000268997, 5.16979e-05>,
                         <-2.8079, 1.22906, 1.08005>, <3.79687e-05, -0.000308642, 6.37782e-05>,
                         <-2.8213, 1.22632, 1.08323>, <0.000151249, -0.000276639, 3.69273e-05> }
        smooth_triangle {<-2.8213, 1.22632, 1.08323>, <0.000129157, -0.000271075, 3.91704e-05>,
                         <-2.82439, 1.22171, 1.06193>, <0.000114038, -0.000244368, 3.26995e-05>,
                         <-2.81284, 1.22407, 1.05919>, <4.00014e-05, -0.000265344, 5.02483e-05> }
        smooth_triangle {<-2.8079, 1.22906, 1.08005>, <3.79687e-05, -0.000308642, 6.37782e-05>,
                         <-2.80295, 1.23387, 1.10095>, <4.04844e-05, -0.00034697, 6.43747e-05>,
                         <-2.81814, 1.23076, 1.10455>, <0.000167866, -0.000311165, 3.41814e-05> }
        smooth_triangle {<-2.81814, 1.23076, 1.10455>, <0.000144034, -0.000307332, 3.8357e-05>,
                         <-2.8213, 1.22632, 1.08323>, <0.000131571, -0.000281437, 4.04164e-05>,
                         <-2.8079, 1.22906, 1.08005>, <4.66105e-05, -0.000305439, 6.05546e-05> }
        smooth_triangle {<-2.80295, 1.23387, 1.10095>, <4.04844e-05, -0.00034697, 6.43747e-05>,
                         <-2.79795, 1.23772, 1.12203>, <3.79295e-05, -0.000376971, 4.77554e-05>,
                         <-2.81458, 1.23432, 1.12597>, <0.000176383, -0.000338367, 1.49378e-05> }
        smooth_triangle {<-2.81458, 1.23432, 1.12597>, <0.000152121, -0.00033835, 2.19386e-05>,
                         <-2.81814, 1.23076, 1.10455>, <0.000145733, -0.000317949, 3.63714e-05>,
                         <-2.80295, 1.23387, 1.10095>, <5.01969e-05, -0.000344802, 5.90163e-05> }
        smooth_triangle {<-2.79795, 1.23772, 1.12203>, <3.79295e-05, -0.000376971, 4.77554e-05>,
                         <-2.7929, 1.23963, 1.14335>, <2.78229e-05, -0.000386631, 8.46668e-06>,
                         <-2.81024, 1.23609, 1.14746>, <0.000169931, -0.000347588, -2.52171e-05> }
        smooth_triangle {<-2.81024, 1.23609, 1.14746>, <0.000147455, -0.000354302, -1.52409e-05>,
                         <-2.81458, 1.23432, 1.12597>, <0.000152294, -0.000347386, 1.48752e-05>,
                         <-2.79795, 1.23772, 1.12203>, <4.84537e-05, -0.000376339, 3.94884e-05> }
        smooth_triangle {<-2.7929, 1.23963, 1.14335>, <2.78229e-05, -0.000386631, 8.46668e-06>,
                         <-2.78784, 1.23822, 1.16469>, <5.76411e-06, -0.000347782, -5.77923e-05>,
                         <-2.80466, 1.23479, 1.16867>, <0.000133864, -0.000314062, -8.81557e-05> }
        smooth_triangle {<-2.80466, 1.23479, 1.16867>, <0.000117854, -0.000333216, -7.67038e-05>,
                         <-2.81024, 1.23609, 1.14746>, <0.000144904, -0.00035836, -2.94999e-05>,
                         <-2.7929, 1.23963, 1.14335>, <3.83237e-05, -0.000387643, -4.23705e-06> }
        smooth_triangle {<-2.78784, 1.23822, 1.16469>, <5.76411e-06, -0.000347782, -5.77923e-05>,
                         <-2.78318, 1.23002, 1.18434>, <-2.22418e-05, -0.000219528, -0.000118944>,
                         <-2.79694, 1.22721, 1.1876>, <5.90739e-05, -0.000200601, -0.000138218> }
        smooth_triangle {<-2.79694, 1.22721, 1.1876>, <5.30187e-05, -0.000237709, -0.000142158>,
                         <-2.80466, 1.23479, 1.16867>, <0.000109111, -0.000322805, -0.000104612>,
                         <-2.78784, 1.23822, 1.16469>, <1.30364e-05, -0.000348095, -8.18391e-05> }
        smooth_triangle {<-2.78318, 1.23002, 1.18434>, <-2.22418e-05, -0.000219528, -0.000118944>,
                         <-2.78041, 1.21208, 1.19601>, <-1.85349e-05, -5.7149e-05, -7.72679e-05>,
                         <-2.7875, 1.21064, 1.19769>, <2.7613e-06, -5.28807e-05, -8.23157e-05> }
        smooth_triangle {<-2.7875, 1.21064, 1.19769>, <-4.34293e-06, -8.20864e-05, -0.000125386>,
                         <-2.79694, 1.22721, 1.1876>, <3.78915e-05, -0.000192877, -0.000167313>,
                         <-2.78318, 1.23002, 1.18434>, <-2.30953e-05, -0.000207072, -0.000152857> }
        smooth_triangle {<-2.78041, 1.21208, 1.19601>, <-1.85349e-05, -5.7149e-05, -7.72679e-05>,
                         <-2.7797, 1.19034, 1.19902>, <5.23667e-06, 3.23015e-06, 2.20929e-05>,
                         <-2.77868, 1.19054, 1.19878>, <4.03388e-06, 2.98427e-06, 2.2378e-05> }
        smooth_triangle {<-2.77868, 1.19054, 1.19878>, <-8.02661e-06, -5.51651e-06, -3.67638e-05>,
                         <-2.7875, 1.21064, 1.19769>, <-5.96592e-06, -4.52901e-05, -0.000100499>,
                         <-2.78041, 1.21208, 1.19601>, <-2.19381e-05, -4.84912e-05, -9.67127e-05> }
        smooth_triangle {<-2.84627, 1.21043, 0.886973>, <-3.06146e-05, -0.000161512, 1.01382e-05>,
                         <-2.84106, 1.21078, 0.908352>, <-5.00697e-05, -0.000154499, 1.48736e-05>,
                         <-2.8482, 1.21224, 0.910045>, <1.13231e-05, -0.000162695, 3.21722e-07> }
        smooth_triangle {<-2.8482, 1.21224, 0.910045>, <9.91109e-07, -0.000161595, 2.72535e-06>,
                         <-2.85327, 1.21186, 0.888632>, <9.50943e-07, -0.000159904, 2.6275e-06>,
                         <-2.84627, 1.21043, 0.886973>, <-3.03097e-05, -0.000159904, 1.00372e-05> }
        smooth_triangle {<-2.84106, 1.21078, 0.908352>, <-5.00697e-05, -0.000154499, 1.48736e-05>,
                         <-2.83582, 1.21117, 0.929726>, <-5.11128e-05, -0.000158109, 1.56264e-05>,
                         <-2.84312, 1.21267, 0.931456>, <1.17122e-05, -0.000166485, 7.35035e-07> }
        smooth_triangle {<-2.84312, 1.21267, 0.931456>, <1.14773e-06, -0.000165241, 3.15724e-06>,
                         <-2.8482, 1.21224, 0.910045>, <8.55881e-07, -0.000162398, 2.84725e-06>,
                         <-2.84106, 1.21078, 0.908352>, <-4.51887e-05, -0.000156251, 1.37612e-05> }
        smooth_triangle {<-2.83582, 1.21117, 0.929726>, <-5.11128e-05, -0.000158109, 1.56264e-05>,
                         <-2.83056, 1.21164, 0.951091>, <-5.23104e-05, -0.000162625, 1.69249e-05>,
                         <-2.83805, 1.21318, 0.952866>, <1.23048e-05, -0.000171218, 1.60916e-06> }
        smooth_triangle {<-2.83805, 1.21318, 0.952866>, <1.4624e-06, -0.000169675, 4.02875e-06>,
                         <-2.84312, 1.21267, 0.931456>, <1.018e-06, -0.000166126, 3.37315e-06>,
                         <-2.83582, 1.21117, 0.929726>, <-4.61008e-05, -0.000159843, 1.45417e-05> }
        smooth_triangle {<-2.83056, 1.21164, 0.951091>, <-5.23104e-05, -0.000162625, 1.69249e-05>,
                         <-2.82523, 1.21227, 0.972437>, <-5.37965e-05, -0.000168912, 1.93282e-05>,
                         <-2.83297, 1.21385, 0.974272>, <1.33079e-05, -0.000177792, 3.4225e-06> }
        smooth_triangle {<-2.83297, 1.21385, 0.974272>, <2.08876e-06, -0.000175668, 5.77385e-06>,
                         <-2.83805, 1.21318, 0.952866>, <1.33643e-06, -0.000170738, 4.41384e-06>,
                         <-2.83056, 1.21164, 0.951091>, <-4.7125e-05, -0.000164293, 1.59006e-05> }
        smooth_triangle {<-2.82523, 1.21227, 0.972437>, <-5.37965e-05, -0.000168912, 1.93282e-05>,
                         <-2.81979, 1.2132, 0.99374>, <-5.57713e-05, -0.000178857, 2.44103e-05>,
                         <-2.8279, 1.21486, 0.995664>, <1.52654e-05, -0.000188164, 7.57252e-06> }
        smooth_triangle {<-2.8279, 1.21486, 0.995664>, <3.4513e-06, -0.000184843, 9.64448e-06>,
                         <-2.83297, 1.21385, 0.974272>, <1.98315e-06, -0.000177064, 6.53197e-06>,
                         <-2.82523, 1.21227, 0.972437>, <-4.83451e-05, -0.000170404, 1.84613e-05> }
        smooth_triangle {<-2.81979, 1.2132, 0.99374>, <-5.57713e-05, -0.000178857, 2.44103e-05>,
                         <-2.81407, 1.21482, 1.01493>, <-5.85748e-05, -0.000195707, 3.53319e-05>,
                         <-2.82284, 1.21661, 1.01701>, <1.91251e-05, -0.00020574, 1.69147e-05> }
        smooth_triangle {<-2.82284, 1.21661, 1.01701>, <6.33089e-06, -0.000200054, 1.83368e-05>,
                         <-2.8279, 1.21486, 0.995664>, <3.4361e-06, -0.000186872, 1.13302e-05>,
                         <-2.81979, 1.2132, 0.99374>, <-4.98414e-05, -0.000179892, 2.39586e-05> }
        smooth_triangle {<-2.81407, 1.21482, 1.01493>, <-5.85748e-05, -0.000195707, 3.53319e-05>,
                         <-2.80791, 1.21764, 1.03587>, <-6.27786e-05, -0.000221918, 5.40839e-05>,
                         <-2.81782, 1.21967, 1.03821>, <2.53046e-05, -0.000233176, 3.32056e-05> }
        smooth_triangle {<-2.81782, 1.21967, 1.03821>, <1.10611e-05, -0.000223979, 3.38458e-05>,
                         <-2.82284, 1.21661, 1.01701>, <6.42649e-06, -0.000203402, 2.16276e-05>,
                         <-2.81407, 1.21482, 1.01493>, <-5.18484e-05, -0.000195878, 3.54405e-05> }
        smooth_triangle {<-2.80791, 1.21764, 1.03587>, <-6.27786e-05, -0.000221918, 5.40839e-05>,
                         <-2.8013, 1.22171, 1.05646>, <-6.92409e-05, -0.000256013, 7.57838e-05>,
                         <-2.81284, 1.22407, 1.05919>, <3.23747e-05, -0.000268997, 5.16979e-05> }
        smooth_triangle {<-2.81284, 1.22407, 1.05919>, <1.62488e-05, -0.000256617, 5.2208e-05>,
                         <-2.81782, 1.21967, 1.03821>, <1.09461e-05, -0.000229751, 3.83387e-05>,
                         <-2.80791, 1.21764, 1.03587>, <-5.51162e-05, -0.000221308, 5.39974e-05> }
        smooth_triangle {<-2.8013, 1.22171, 1.05646>, <-6.92409e-05, -0.000256013, 7.57838e-05>,
                         <-2.7945, 1.22632, 1.07688>, <-7.8606e-05, -0.000293657, 9.14099e-05>,
                         <-2.8079, 1.22906, 1.08005>, <3.79687e-05, -0.000308642, 6.37782e-05> }
        smooth_triangle {<-2.8079, 1.22906, 1.08005>, <1.95789e-05, -0.000295077, 6.51438e-05>,
                         <-2.81284, 1.22407, 1.05919>, <1.53835e-05, -0.000265344, 5.60835e-05>,
                         <-2.8013, 1.22171, 1.05646>, <-6.08282e-05, -0.000255606, 7.41479e-05> }
        smooth_triangle {<-2.7945, 1.22632, 1.07688>, <-7.8606e-05, -0.000293657, 9.14099e-05>,
                         <-2.78775, 1.23076, 1.09735>, <-9.05336e-05, -0.000329952, 9.54299e-05>,
                         <-2.80295, 1.23387, 1.10095>, <4.04844e-05, -0.00034697, 6.43747e-05> }
        smooth_triangle {<-2.80295, 1.23387, 1.10095>, <1.98681e-05, -0.000334186, 6.77879e-05>,
                         <-2.8079, 1.22906, 1.08005>, <1.79813e-05, -0.000305439, 6.73405e-05>,
                         <-2.7945, 1.22632, 1.07688>, <-6.94496e-05, -0.000294201, 8.80643e-05> }
        smooth_triangle {<-2.78775, 1.23076, 1.09735>, <-9.05336e-05, -0.000329952, 9.54299e-05>,
                         <-2.78132, 1.23432, 1.11809>, <-0.00010436, -0.000358185, 8.14821e-05>,
                         <-2.79795, 1.23772, 1.12203>, <3.79295e-05, -0.000376971, 4.77554e-05> }
        smooth_triangle {<-2.79795, 1.23772, 1.12203>, <1.5542e-05, -0.000367303, 5.43119e-05>,
                         <-2.80295, 1.23387, 1.10095>, <1.74581e-05, -0.000344802, 6.67764e-05>,
                         <-2.78775, 1.23076, 1.09735>, <-8.08054e-05, -0.000332038, 9.00677e-05> }
        smooth_triangle {<-2.78132, 1.23432, 1.11809>, <-0.00010436, -0.000358185, 8.14821e-05>,
                         <-2.77556, 1.23609, 1.13924>, <-0.000118006, -0.000366814, 4.30324e-05>,
                         <-2.7929, 1.23963, 1.14335>, <2.78229e-05, -0.000386631, 8.46668e-06> }
        smooth_triangle {<-2.7929, 1.23963, 1.14335>, <4.63707e-06, -0.000383584, 1.86111e-05>,
                         <-2.79795, 1.23772, 1.12203>, <1.2217e-05, -0.000376339, 4.80776e-05>,
                         <-2.78132, 1.23432, 1.11809>, <-9.44998e-05, -0.000362249, 7.33726e-05> }
        smooth_triangle {<-2.77556, 1.23609, 1.13924>, <-0.000118006, -0.000366814, 4.30324e-05>,
                         <-2.77102, 1.23479, 1.1607>, <-0.000125141, -0.000328556, -2.67639e-05>,
                         <-2.78784, 1.23822, 1.16469>, <5.76411e-06, -0.000347782, -5.77923e-05> }
        smooth_triangle {<-2.78784, 1.23822, 1.16469>, <-1.60283e-05, -0.000358506, -4.49697e-05>,
                         <-2.7929, 1.23963, 1.14335>, <5.15826e-07, -0.000387643, 4.72454e-06>,
                         <-2.77556, 1.23609, 1.13924>, <-0.000108856, -0.00037278, 3.06489e-05> }
        smooth_triangle {<-2.77102, 1.23479, 1.1607>, <-0.000125141, -0.000328556, -2.67639e-05>,
                         <-2.76942, 1.22721, 1.18108>, <-0.000104415, -0.000205033, -9.94661e-05>,
                         <-2.78318, 1.23002, 1.18434>, <-2.22418e-05, -0.000219528, -0.000118944> }
        smooth_triangle {<-2.78318, 1.23002, 1.18434>, <-4.17458e-05, -0.000251904, -0.000119696>,
                         <-2.78784, 1.23822, 1.16469>, <-2.07414e-05, -0.000348095, -7.38327e-05>,
                         <-2.77102, 1.23479, 1.1607>, <-0.00011892, -0.000333676, -5.05615e-05> }
        smooth_triangle {<-2.76942, 1.22721, 1.18108>, <-0.000104415, -0.000205033, -9.94661e-05>,
                         <-2.77333, 1.21064, 1.19434>, <-3.97994e-05, -5.27168e-05, -7.22276e-05>,
                         <-2.78041, 1.21208, 1.19601>, <-1.85349e-05, -5.7149e-05, -7.72679e-05> }
        smooth_triangle {<-2.78041, 1.21208, 1.19601>, <-3.67381e-05, -8.52876e-05, -0.000117707>,
                         <-2.78318, 1.23002, 1.18434>, <-3.95183e-05, -0.000207072, -0.000148964>,
                         <-2.76942, 1.22721, 1.18108>, <-0.000101148, -0.000196201, -0.000134356> }
        smooth_triangle {<-2.77333, 1.21064, 1.19434>, <-3.97994e-05, -5.27168e-05, -7.22276e-05>,
                         <-2.78072, 1.19054, 1.19927>, <6.43947e-06, 2.98427e-06, 2.18078e-05>,
                         <-2.7797, 1.19034, 1.19902>, <5.23667e-06, 3.23015e-06, 2.20929e-05> }
        smooth_triangle {<-2.7797, 1.19034, 1.19902>, <-1.01303e-05, -5.35259e-06, -3.62651e-05>,
                         <-2.78041, 1.21208, 1.19601>, <-2.41172e-05, -4.84912e-05, -9.61962e-05>,
                         <-2.77333, 1.21064, 1.19434>, <-4.00656e-05, -4.51671e-05, -9.2416e-05> }
        smooth_triangle {<-2.84034, 1.20636, 0.885566>, <-8.83766e-05, -0.000136923, 2.38295e-05>,
                         <-2.835, 1.20663, 0.906917>, <-0.000103737, -0.000122781, 2.75944e-05>,
                         <-2.84106, 1.21078, 0.908352>, <-5.00697e-05, -0.000154499, 1.48736e-05> }
        smooth_triangle {<-2.84106, 1.21078, 0.908352>, <-5.92064e-05, -0.000149423, 1.69939e-05>,
                         <-2.84627, 1.21043, 0.886973>, <-5.86155e-05, -0.000147854, 1.67465e-05>,
                         <-2.84034, 1.20636, 0.885566>, <-8.74965e-05, -0.00013556, 2.35922e-05> }
        smooth_triangle {<-2.835, 1.20663, 0.906917>, <-0.000103737, -0.000122781, 2.75944e-05>,
                         <-2.82964, 1.20693, 0.92826>, <-0.000106036, -0.000125662, 2.86449e-05>,
                         <-2.83582, 1.21117, 0.929726>, <-5.11128e-05, -0.000158109, 1.56264e-05> }
        smooth_triangle {<-2.83582, 1.21117, 0.929726>, <-6.04111e-05, -0.000152811, 1.77485e-05>,
                         <-2.84106, 1.21078, 0.908352>, <-5.96287e-05, -0.000150104, 1.71839e-05>,
                         <-2.835, 1.20663, 0.906917>, <-9.98793e-05, -0.000126316, 2.67245e-05> }
        smooth_triangle {<-2.82964, 1.20693, 0.92826>, <-0.000106036, -0.000125662, 2.86449e-05>,
                         <-2.82421, 1.20729, 0.949587>, <-0.000108807, -0.000129273, 3.03163e-05>,
                         <-2.83056, 1.21164, 0.951091>, <-5.23104e-05, -0.000162625, 1.69249e-05> }
        smooth_triangle {<-2.83056, 1.21164, 0.951091>, <-6.17555e-05, -0.000156949, 1.90133e-05>,
                         <-2.83582, 1.21117, 0.929726>, <-6.08573e-05, -0.000153561, 1.80394e-05>,
                         <-2.82964, 1.20693, 0.92826>, <-0.00010205, -0.000129226, 2.78033e-05> }
        smooth_triangle {<-2.82421, 1.20729, 0.949587>, <-0.000108807, -0.000129273, 3.03163e-05>,
                         <-2.81867, 1.20776, 0.970882>, <-0.000112486, -0.000134316, 3.32394e-05>,
                         <-2.82523, 1.21227, 0.972437>, <-5.37965e-05, -0.000168912, 1.93282e-05> }
        smooth_triangle {<-2.82523, 1.21227, 0.972437>, <-6.33761e-05, -0.000162565, 2.1291e-05>,
                         <-2.83056, 1.21164, 0.951091>, <-6.22616e-05, -0.00015785, 1.94885e-05>,
                         <-2.82421, 1.20729, 0.949587>, <-0.000104634, -0.000132836, 2.9532e-05> }
        smooth_triangle {<-2.81867, 1.20776, 0.970882>, <-0.000112486, -0.000134316, 3.32394e-05>,
                         <-2.8129, 1.20848, 0.992109>, <-0.000117935, -0.00014232, 3.9145e-05>,
                         <-2.81979, 1.2132, 0.99374>, <-5.57713e-05, -0.000178857, 2.44103e-05> }
        smooth_triangle {<-2.81979, 1.2132, 0.99374>, <-6.5462e-05, -0.000171207, 2.5979e-05>,
                         <-2.82523, 1.21227, 0.972437>, <-6.39809e-05, -0.000163748, 2.21674e-05>,
                         <-2.81867, 1.20776, 0.970882>, <-0.000107998, -0.000137801, 3.26008e-05> }
        smooth_triangle {<-2.8129, 1.20848, 0.992109>, <-0.000117935, -0.00014232, 3.9145e-05>,
                         <-2.80664, 1.20972, 1.01317>, <-0.000126624, -0.00015588, 5.14616e-05>,
                         <-2.81407, 1.21482, 1.01493>, <-5.85748e-05, -0.000195707, 3.53319e-05> }
        smooth_triangle {<-2.81407, 1.21482, 1.01493>, <-6.83055e-05, -0.000185565, 3.60279e-05>,
                         <-2.81979, 1.2132, 0.99374>, <-6.62029e-05, -0.000172927, 2.78367e-05>,
                         <-2.8129, 1.20848, 0.992109>, <-0.000112826, -0.000145525, 3.88877e-05> }
        smooth_triangle {<-2.80664, 1.20972, 1.01317>, <-0.000126624, -0.00015588, 5.14616e-05>,
                         <-2.79952, 1.21187, 1.03388>, <-0.000139965, -0.000176875, 7.23793e-05>,
                         <-2.80791, 1.21764, 1.03587>, <-6.27786e-05, -0.000221918, 5.40839e-05> }
        smooth_triangle {<-2.80791, 1.21764, 1.03587>, <-7.25601e-05, -0.000208061, 5.36665e-05>,
                         <-2.81407, 1.21482, 1.01493>, <-6.94073e-05, -0.000188403, 3.96025e-05>,
                         <-2.80664, 1.20972, 1.01317>, <-0.000120444, -0.000158533, 5.16998e-05> }
        smooth_triangle {<-2.79952, 1.21187, 1.03388>, <-0.000139965, -0.000176875, 7.23793e-05>,
                         <-2.79151, 1.21499, 1.05414>, <-0.000158287, -0.000204054, 9.68903e-05>,
                         <-2.8013, 1.22171, 1.05646>, <-6.92409e-05, -0.000256013, 7.57838e-05> }
        smooth_triangle {<-2.8013, 1.22171, 1.05646>, <-7.9586e-05, -0.000238526, 7.49236e-05>,
                         <-2.80791, 1.21764, 1.03587>, <-7.47393e-05, -0.000212954, 5.86487e-05>,
                         <-2.79952, 1.21187, 1.03388>, <-0.000132629, -0.000179172, 7.23703e-05> }
        smooth_triangle {<-2.79151, 1.21499, 1.05414>, <-0.000158287, -0.000204054, 9.68903e-05>,
                         <-2.78313, 1.21852, 1.07418>, <-0.000180727, -0.000233965, 0.000115616>,
                         <-2.7945, 1.22632, 1.07688>, <-7.8606e-05, -0.000293657, 9.14099e-05> }
        smooth_triangle {<-2.7945, 1.22632, 1.07688>, <-9.0596e-05, -0.000274157, 9.12585e-05>,
                         <-2.8013, 1.22171, 1.05646>, <-8.35722e-05, -0.000245924, 7.95389e-05>,
                         <-2.79151, 1.21499, 1.05414>, <-0.000150357, -0.000206954, 9.53688e-05> }
        smooth_triangle {<-2.78313, 1.21852, 1.07418>, <-0.000180727, -0.000233965, 0.000115616>,
                         <-2.77487, 1.22192, 1.0943>, <-0.000205241, -0.000262701, 0.000122619>,
                         <-2.78775, 1.23076, 1.09735>, <-9.05336e-05, -0.000329952, 9.54299e-05> }
        smooth_triangle {<-2.78775, 1.23076, 1.09735>, <-0.000104845, -0.000310162, 9.73486e-05>,
                         <-2.7945, 1.22632, 1.07688>, <-9.58995e-05, -0.000282941, 9.43337e-05>,
                         <-2.78313, 1.21852, 1.07418>, <-0.00017249, -0.000238173, 0.000112488> }
        smooth_triangle {<-2.77487, 1.22192, 1.0943>, <-0.000205241, -0.000262701, 0.000122619>,
                         <-2.76723, 1.22464, 1.11475>, <-0.000228822, -0.000284868, 0.000110983>,
                         <-2.78132, 1.23432, 1.11809>, <-0.00010436, -0.000358185, 8.14821e-05> }
        smooth_triangle {<-2.78132, 1.23432, 1.11809>, <-0.000121422, -0.000340337, 8.67763e-05>,
                         <-2.78775, 1.23076, 1.09735>, <-0.000111052, -0.000319163, 9.72371e-05>,
                         <-2.77487, 1.22192, 1.0943>, <-0.000197083, -0.000268725, 0.000117629> }
        smooth_triangle {<-2.76723, 1.22464, 1.11475>, <-0.000228822, -0.000284868, 0.000110983>,
                         <-2.76086, 1.22599, 1.13576>, <-0.000245355, -0.000291152, 7.32179e-05>,
                         <-2.77556, 1.23609, 1.13924>, <-0.000118006, -0.000366814, 4.30324e-05> }
        smooth_triangle {<-2.77556, 1.23609, 1.13924>, <-0.000138213, -0.00035447, 5.24707e-05>,
                         <-2.78132, 1.23432, 1.11809>, <-0.000127978, -0.000347998, 8.1308e-05>,
                         <-2.76723, 1.22464, 1.11475>, <-0.000221325, -0.00029301, 0.000103434> }
        smooth_triangle {<-2.76086, 1.22599, 1.13576>, <-0.000245355, -0.000291152, 7.32179e-05>,
                         <-2.75677, 1.225, 1.15732>, <-0.000238922, -0.00025931, 2.05567e-07>,
                         <-2.77102, 1.23479, 1.1607>, <-0.000125141, -0.000328556, -2.67639e-05> }
        smooth_triangle {<-2.77102, 1.23479, 1.1607>, <-0.000149137, -0.000329217, -1.3419e-05>,
                         <-2.77556, 1.23609, 1.13924>, <-0.000143786, -0.000357911, 3.89283e-05>,
                         <-2.76086, 1.22599, 1.13576>, <-0.000239297, -0.000301164, 6.15674e-05> }
        smooth_triangle {<-2.75677, 1.225, 1.15732>, <-0.000238922, -0.00025931, 2.05567e-07>,
                         <-2.75776, 1.2192, 1.17831>, <-0.000174937, -0.000159324, -8.27505e-05>,
                         <-2.76942, 1.22721, 1.18108>, <-0.000104415, -0.000205033, -9.94661e-05> }
        smooth_triangle {<-2.76942, 1.22721, 1.18108>, <-0.000134583, -0.000227749, -9.76912e-05>,
                         <-2.77102, 1.23479, 1.1607>, <-0.000150127, -0.000320391, -4.31646e-05>,
                         <-2.75677, 1.225, 1.15732>, <-0.000235463, -0.000268457, -2.29375e-05> }
        smooth_triangle {<-2.75776, 1.2192, 1.17831>, <-0.000174937, -0.000159324, -8.27505e-05>,
                         <-2.76733, 1.20651, 1.19291>, <-5.77948e-05, -4.0259e-05, -6.79622e-05>,
                         <-2.77333, 1.21064, 1.19434>, <-3.97994e-05, -5.27168e-05, -7.22276e-05> }
        smooth_triangle {<-2.77333, 1.21064, 1.19434>, <-6.78593e-05, -7.55045e-05, -0.000110331>,
                         <-2.76942, 1.22721, 1.18108>, <-0.000116321, -0.000189742, -0.00013076>,
                         <-2.75776, 1.2192, 1.17831>, <-0.000169212, -0.00015546, -0.000118223> }
        smooth_triangle {<-2.76733, 1.20651, 1.19291>, <-5.77948e-05, -4.0259e-05, -6.79622e-05>,
                         <-2.78158, 1.19114, 1.19947>, <7.45915e-06, 2.28406e-06, 2.15661e-05>,
                         <-2.78072, 1.19054, 1.19927>, <6.43947e-06, 2.98427e-06, 2.18078e-05> }
        smooth_triangle {<-2.78072, 1.19054, 1.19927>, <-1.20128e-05, -4.37379e-06, -3.58189e-05>,
                         <-2.77333, 1.21064, 1.19434>, <-4.20789e-05, -4.43101e-05, -9.19388e-05>,
                         <-2.76733, 1.20651, 1.19291>, <-5.55754e-05, -3.49667e-05, -8.87397e-05> }
        smooth_triangle {<-2.83637, 1.20026, 0.884627>, <-0.000132586, -9.14889e-05, 3.43083e-05>,
                         <-2.83096, 1.2004, 0.905958>, <-0.000141509, -7.23714e-05, 3.65474e-05>,
                         <-2.835, 1.20663, 0.906917>, <-0.000103737, -0.000122781, 2.75944e-05> }
        smooth_triangle {<-2.835, 1.20663, 0.906917>, <-0.000110289, -0.000114503, 2.9102e-05>,
                         <-2.84034, 1.20636, 0.885566>, <-0.000109161, -0.000113295, 2.87272e-05>,
                         <-2.83637, 1.20026, 0.884627>, <-0.000131265, -9.05777e-05, 3.39666e-05> }
        smooth_triangle {<-2.83096, 1.2004, 0.905958>, <-0.000141509, -7.23714e-05, 3.65474e-05>,
                         <-2.8255, 1.20057, 0.92728>, <-0.000144697, -7.40835e-05, 3.78086e-05>,
                         <-2.82964, 1.20693, 0.92826>, <-0.000106036, -0.000125662, 2.86449e-05> }
        smooth_triangle {<-2.82964, 1.20693, 0.92826>, <-0.000112656, -0.000117118, 3.0132e-05>,
                         <-2.835, 1.20663, 0.906917>, <-0.000110931, -0.000114957, 2.93441e-05>,
                         <-2.83096, 1.2004, 0.905958>, <-0.00013926, -7.715e-05, 3.60589e-05> }
        smooth_triangle {<-2.8255, 1.20057, 0.92728>, <-0.000144697, -7.40835e-05, 3.78086e-05>,
                         <-2.81997, 1.20076, 0.948581>, <-0.000148584, -7.62411e-05, 3.97446e-05>,
                         <-2.82421, 1.20729, 0.949587>, <-0.000108807, -0.000129273, 3.03163e-05> }
        smooth_triangle {<-2.82421, 1.20729, 0.949587>, <-0.000115422, -0.000120328, 3.17339e-05>,
                         <-2.82964, 1.20693, 0.92826>, <-0.000113344, -0.000117619, 3.04804e-05>,
                         <-2.8255, 1.20057, 0.92728>, <-0.00014234, -7.89354e-05, 3.73531e-05> }
        smooth_triangle {<-2.81997, 1.20076, 0.948581>, <-0.000148584, -7.62411e-05, 3.97446e-05>,
                         <-2.81429, 1.20102, 0.969843>, <-0.000153826, -7.92721e-05, 4.30381e-05>,
                         <-2.81867, 1.20776, 0.970882>, <-0.000112486, -0.000134316, 3.32394e-05> }
        smooth_triangle {<-2.81867, 1.20776, 0.970882>, <-0.000118978, -0.000124712, 3.44703e-05>,
                         <-2.82421, 1.20729, 0.949587>, <-0.000116219, -0.00012093, 3.2278e-05>,
                         <-2.81997, 1.20076, 0.948581>, <-0.000146052, -8.11557e-05, 3.93493e-05> }
        smooth_triangle {<-2.81429, 1.20102, 0.969843>, <-0.000153826, -7.92721e-05, 4.30381e-05>,
                         <-2.80831, 1.20141, 0.99102>, <-0.000161762, -8.41168e-05, 4.95332e-05>,
                         <-2.8129, 1.20848, 0.992109>, <-0.000117935, -0.00014232, 3.9145e-05> }
        smooth_triangle {<-2.8129, 1.20848, 0.992109>, <-0.000124052, -0.000131506, 3.98665e-05>,
                         <-2.81867, 1.20776, 0.970882>, <-0.000119965, -0.000125503, 3.54373e-05>,
                         <-2.81429, 1.20102, 0.969843>, <-0.00015097, -8.42196e-05, 4.27864e-05> }
        smooth_triangle {<-2.80831, 1.20141, 0.99102>, <-0.000161762, -8.41168e-05, 4.95332e-05>,
                         <-2.80167, 1.20208, 1.01199>, <-0.000174664, -9.23219e-05, 6.28484e-05>,
                         <-2.80664, 1.20972, 1.01317>, <-0.000126624, -0.00015588, 5.14616e-05> }
        smooth_triangle {<-2.80664, 1.20972, 1.01317>, <-0.000131865, -0.000142825, 5.10934e-05>,
                         <-2.8129, 1.20848, 0.992109>, <-0.000125348, -0.000132655, 4.18559e-05>,
                         <-2.80831, 1.20141, 0.99102>, <-0.000158218, -8.90024e-05, 4.9647e-05> }
        smooth_triangle {<-2.80167, 1.20208, 1.01199>, <-0.000174664, -9.23219e-05, 6.28484e-05>,
                         <-2.7939, 1.20324, 1.03255>, <-0.000194503, -0.000104905, 8.53065e-05>,
                         <-2.79952, 1.21187, 1.03388>, <-0.000139965, -0.000176875, 7.23793e-05> }
        smooth_triangle {<-2.79952, 1.21187, 1.03388>, <-0.000143889, -0.000160468, 7.05735e-05>,
                         <-2.80664, 1.20972, 1.01317>, <-0.000133883, -0.000144722, 5.48852e-05>,
                         <-2.80167, 1.20208, 1.01199>, <-0.000169913, -9.70528e-05, 6.34253e-05> }
        smooth_triangle {<-2.7939, 1.20324, 1.03255>, <-0.000194503, -0.000104905, 8.53065e-05>,
                         <-2.78497, 1.20493, 1.05259>, <-0.000221206, -0.000121029, 0.000111804>,
                         <-2.79151, 1.21499, 1.05414>, <-0.000158287, -0.000204054, 9.68903e-05> }
        smooth_triangle {<-2.79151, 1.21499, 1.05414>, <-0.000161389, -0.000184121, 9.43134e-05>,
                         <-2.79952, 1.21187, 1.03388>, <-0.000147648, -0.000163737, 7.59302e-05>,
                         <-2.7939, 1.20324, 1.03255>, <-0.000188552, -0.00010976, 8.56256e-05> }
        smooth_triangle {<-2.78497, 1.20493, 1.05259>, <-0.000221206, -0.000121029, 0.000111804>,
                         <-2.77554, 1.20684, 1.07238>, <-0.000252848, -0.000138655, 0.00013271>,
                         <-2.78313, 1.21852, 1.07418>, <-0.000180727, -0.000233965, 0.000115616> }
        smooth_triangle {<-2.78313, 1.21852, 1.07418>, <-0.000184594, -0.000211498, 0.000113539>,
                         <-2.79151, 1.21499, 1.05414>, <-0.000167764, -0.000189064, 9.94949e-05>,
                         <-2.78497, 1.20493, 1.05259>, <-0.000214954, -0.000126796, 0.00011068> }
        smooth_triangle {<-2.77554, 1.20684, 1.07238>, <-0.000252848, -0.000138655, 0.00013271>,
                         <-2.76627, 1.20868, 1.09226>, <-0.000286176, -0.000155457, 0.000141803>,
                         <-2.77487, 1.22192, 1.0943>, <-0.000205241, -0.000262701, 0.000122619> }
        smooth_triangle {<-2.77487, 1.22192, 1.0943>, <-0.00021112, -0.00023892, 0.000122539>,
                         <-2.78313, 1.21852, 1.07418>, <-0.000192734, -0.000217368, 0.000117286>,
                         <-2.77554, 1.20684, 1.07238>, <-0.000246824, -0.000145885, 0.000130107> }
        smooth_triangle {<-2.76627, 1.20868, 1.09226>, <-0.000286176, -0.000155457, 0.000141803>,
                         <-2.75781, 1.21015, 1.11252>, <-0.00031651, -0.000168182, 0.000131768>,
                         <-2.76723, 1.22464, 1.11475>, <-0.000228822, -0.000284868, 0.000110983> }
        smooth_triangle {<-2.76723, 1.22464, 1.11475>, <-0.000237918, -0.000261558, 0.000114389>,
                         <-2.77487, 1.22192, 1.0943>, <-0.000220233, -0.000244934, 0.000123116>,
                         <-2.76627, 1.20868, 1.09226>, <-0.000280933, -0.0001645, 0.000137504> }
        smooth_triangle {<-2.75781, 1.21015, 1.11252>, <-0.00031651, -0.000168182, 0.000131768>,
                         <-2.75103, 1.21089, 1.13343>, <-0.000334836, -0.000171165, 9.44276e-05>,
                         <-2.76086, 1.22599, 1.13576>, <-0.000245355, -0.000291152, 7.32179e-05> }
        smooth_triangle {<-2.76086, 1.22599, 1.13576>, <-0.000259348, -0.00027139, 8.11833e-05>,
                         <-2.76723, 1.22464, 1.11475>, <-0.000246948, -0.000266677, 0.000109507>,
                         <-2.75781, 1.21015, 1.11252>, <-0.000312714, -0.000179163, 0.000125096> }
        smooth_triangle {<-2.75103, 1.21089, 1.13343>, <-0.000334836, -0.000171165, 9.44276e-05>,
                         <-2.74724, 1.21035, 1.15506>, <-0.000318257, -0.000150587, 1.90104e-05>,
                         <-2.75677, 1.225, 1.15732>, <-0.000238922, -0.00025931, 2.05567e-07> }
        smooth_triangle {<-2.75677, 1.225, 1.15732>, <-0.000261207, -0.000249808, 1.31449e-05>,
                         <-2.76086, 1.22599, 1.13576>, <-0.000266032, -0.000273689, 6.79042e-05>,
                         <-2.75103, 1.21089, 1.13343>, <-0.000333143, -0.000183699, 8.38114e-05> }
        smooth_triangle {<-2.74724, 1.21035, 1.15506>, <-0.000318257, -0.000150587, 1.90104e-05>,
                         <-2.74996, 1.20721, 1.17646>, <-0.000223069, -8.93597e-05, -7.13417e-05>,
                         <-2.75776, 1.2192, 1.17831>, <-0.000174937, -0.000159324, -8.27505e-05> }
        smooth_triangle {<-2.75776, 1.2192, 1.17831>, <-0.000211358, -0.000168921, -7.94932e-05>,
                         <-2.75677, 1.225, 1.15732>, <-0.000259347, -0.000243911, -1.72761e-05>,
                         <-2.74724, 1.21035, 1.15506>, <-0.000318849, -0.000162368, -3.17253e-06> }
        smooth_triangle {<-2.74996, 1.20721, 1.17646>, <-0.000223069, -8.93597e-05, -7.13417e-05>,
                         <-2.76332, 1.20034, 1.19196>, <-6.97815e-05, -2.16721e-05, -6.5121e-05>,
                         <-2.76733, 1.20651, 1.19291>, <-5.77948e-05, -4.0259e-05, -6.79622e-05> }
        smooth_triangle {<-2.76733, 1.20651, 1.19291>, <-9.29687e-05, -5.42265e-05, -0.000104379>,
                         <-2.75776, 1.2192, 1.17831>, <-0.000180825, -0.000143525, -0.00011547>,
                         <-2.74996, 1.20721, 1.17646>, <-0.000216925, -9.10521e-05, -0.000106914> }
        smooth_triangle {<-2.76332, 1.20034, 1.19196>, <-6.97815e-05, -2.16721e-05, -6.5121e-05>,
                         <-2.78215, 1.19202, 1.19961>, <8.14048e-06, 1.23613e-06, 2.14046e-05>,
                         <-2.78158, 1.19114, 1.19947>, <7.45915e-06, 2.28406e-06, 2.15661e-05> }
        smooth_triangle {<-2.78158, 1.19114, 1.19947>, <-1.33876e-05, -2.72912e-06, -3.5493e-05>,
                         <-2.76733, 1.20651, 1.19291>, <-5.71164e-05, -3.33831e-05, -8.83745e-05>,
                         <-2.76332, 1.20034, 1.19196>, <-6.61064e-05, -1.94429e-05, -8.62435e-05> }
        smooth_triangle {<-2.83498, 1.19307, 0.884297>, <-0.000156511, -3.21262e-05, 3.99794e-05>,
                         <-2.82954, 1.19307, 0.905621>, <-0.000157634, -1.09436e-05, 4.03696e-05>,
                         <-2.83096, 1.2004, 0.905958>, <-0.000141509, -7.23714e-05, 3.65474e-05> }
        smooth_triangle {<-2.83096, 1.2004, 0.905958>, <-0.00014448, -6.21501e-05, 3.72063e-05>,
                         <-2.83637, 1.20026, 0.884627>, <-0.00014299, -6.14875e-05, 3.67457e-05>,
                         <-2.83498, 1.19307, 0.884297>, <-0.000154953, -3.18062e-05, 3.95812e-05> }
        smooth_triangle {<-2.82954, 1.19307, 0.905621>, <-0.000157634, -1.09436e-05, 4.03696e-05>,
                         <-2.82405, 1.19307, 0.926936>, <-0.000161209, -1.12269e-05, 4.17224e-05>,
                         <-2.8255, 1.20057, 0.92728>, <-0.000144697, -7.40835e-05, 3.78086e-05> }
        smooth_triangle {<-2.8255, 1.20057, 0.92728>, <-0.000147632, -6.35939e-05, 3.84225e-05>,
                         <-2.83096, 1.2004, 0.905958>, <-0.000145241, -6.23098e-05, 3.74766e-05>,
                         <-2.82954, 1.19307, 0.905621>, <-0.000157335, -1.6239e-05, 4.03432e-05> }
        smooth_triangle {<-2.82405, 1.19307, 0.926936>, <-0.000161209, -1.12269e-05, 4.17224e-05>,
                         <-2.81848, 1.19307, 0.948228>, <-0.000165586, -1.16019e-05, 4.37746e-05>,
                         <-2.81997, 1.20076, 0.948581>, <-0.000148584, -7.62411e-05, 3.97446e-05> }
        smooth_triangle {<-2.81997, 1.20076, 0.948581>, <-0.000151368, -6.53882e-05, 4.02539e-05>,
                         <-2.8255, 1.20057, 0.92728>, <-0.000148452, -6.37699e-05, 3.88019e-05>,
                         <-2.82405, 1.19307, 0.926936>, <-0.000160836, -1.66275e-05, 4.17373e-05> }
        smooth_triangle {<-2.81848, 1.19307, 0.948228>, <-0.000165586, -1.16019e-05, 4.37746e-05>,
                         <-2.81275, 1.19307, 0.969478>, <-0.000171523, -1.21597e-05, 4.72327e-05>,
                         <-2.81429, 1.20102, 0.969843>, <-0.000153826, -7.92721e-05, 4.30381e-05> }
        smooth_triangle {<-2.81429, 1.20102, 0.969843>, <-0.000156253, -6.78728e-05, 4.33055e-05>,
                         <-2.81997, 1.20076, 0.948581>, <-0.000152322, -6.55996e-05, 4.08354e-05>,
                         <-2.81848, 1.19307, 0.948228>, <-0.000165073, -1.71202e-05, 4.38579e-05> }
        smooth_triangle {<-2.81275, 1.19307, 0.969478>, <-0.000171523, -1.21597e-05, 4.72327e-05>,
                         <-2.80669, 1.19307, 0.990637>, <-0.000180579, -1.31073e-05, 5.39935e-05>,
                         <-2.80831, 1.20141, 0.99102>, <-0.000161762, -8.41168e-05, 4.95332e-05> }
        smooth_triangle {<-2.80831, 1.20141, 0.99102>, <-0.000163399, -7.1784e-05, 4.91928e-05>,
                         <-2.81429, 1.20102, 0.969843>, <-0.000157447, -6.81505e-05, 4.43215e-05>,
                         <-2.81275, 1.19307, 0.969478>, <-0.000170719, -1.78162e-05, 4.74675e-05> }
        smooth_triangle {<-2.80669, 1.19307, 0.990637>, <-0.000180579, -1.31073e-05, 5.39935e-05>,
                         <-2.79993, 1.19307, 1.01158>, <-0.000195379, -1.47083e-05, 6.77586e-05>,
                         <-2.80167, 1.20208, 1.01199>, <-0.000174664, -9.23219e-05, 6.28484e-05> }
        smooth_triangle {<-2.80167, 1.20208, 1.01199>, <-0.000174672, -7.83414e-05, 6.12398e-05>,
                         <-2.80831, 1.20141, 0.99102>, <-0.000164995, -7.21876e-05, 5.12534e-05>,
                         <-2.80669, 1.19307, 0.990637>, <-0.000179109, -1.89305e-05, 5.45987e-05> }
        smooth_triangle {<-2.79993, 1.19307, 1.01158>, <-0.000195379, -1.47083e-05, 6.77586e-05>,
                         <-2.79193, 1.19307, 1.03208>, <-0.000218091, -1.69638e-05, 9.08975e-05>,
                         <-2.7939, 1.20324, 1.03255>, <-0.000194503, -0.000104905, 8.53065e-05> }
        smooth_triangle {<-2.7939, 1.20324, 1.03255>, <-0.000192066, -8.84447e-05, 8.19928e-05>,
                         <-2.80167, 1.20208, 1.01199>, <-0.000177186, -7.90074e-05, 6.51492e-05>,
                         <-2.79993, 1.19307, 1.01158>, <-0.000192723, -2.07972e-05, 6.88319e-05> }
        smooth_triangle {<-2.79193, 1.19307, 1.03208>, <-0.000218091, -1.69638e-05, 9.08975e-05>,
                         <-2.78267, 1.19307, 1.05204>, <-0.000248421, -1.95783e-05, 0.000118255>,
                         <-2.78497, 1.20493, 1.05259>, <-0.000221206, -0.000121029, 0.000111804> }
        smooth_triangle {<-2.78497, 1.20493, 1.05259>, <-0.000216707, -0.000101686, 0.000107425>,
                         <-2.7939, 1.20324, 1.03255>, <-0.00019668, -8.95928e-05, 8.75522e-05>,
                         <-2.79193, 1.19307, 1.03208>, <-0.00021437, -2.36369e-05, 9.17454e-05> }
        smooth_triangle {<-2.78267, 1.19307, 1.05204>, <-0.000248421, -1.95783e-05, 0.000118255>,
                         <-2.77288, 1.19307, 1.07175>, <-0.000283988, -2.22352e-05, 0.000140091>,
                         <-2.77554, 1.20684, 1.07238>, <-0.000252848, -0.000138655, 0.00013271> }
        smooth_triangle {<-2.77554, 1.20684, 1.07238>, <-0.000248106, -0.000116641, 0.000128593>,
                         <-2.78497, 1.20493, 1.05259>, <-0.000224375, -0.000103422, 0.000112913>,
                         <-2.78267, 1.19307, 1.05204>, <-0.000244785, -2.73337e-05, 0.000117751> }
        smooth_triangle {<-2.77288, 1.19307, 1.07175>, <-0.000283988, -2.22352e-05, 0.000140091>,
                         <-2.76324, 1.19307, 1.09154>, <-0.000321015, -2.45455e-05, 0.000150061>,
                         <-2.76627, 1.20868, 1.09226>, <-0.000286176, -0.000155457, 0.000141803> }
        smooth_triangle {<-2.76627, 1.20868, 1.09226>, <-0.000282776, -0.000131304, 0.000139524>,
                         <-2.77554, 1.20684, 1.07238>, <-0.00025778, -0.000118702, 0.000132704>,
                         <-2.77288, 1.19307, 1.07175>, <-0.000281135, -3.13875e-05, 0.00013824> }
        smooth_triangle {<-2.76324, 1.19307, 1.09154>, <-0.000321015, -2.45455e-05, 0.000150061>,
                         <-2.7545, 1.19307, 1.11173>, <-0.000354073, -2.58926e-05, 0.000140671>,
                         <-2.75781, 1.21015, 1.11252>, <-0.00031651, -0.000168182, 0.000131768> }
        smooth_triangle {<-2.75781, 1.21015, 1.11252>, <-0.000316213, -0.00014296, 0.000132947>,
                         <-2.76627, 1.20868, 1.09226>, <-0.000293462, -0.000133416, 0.000140474>,
                         <-2.76324, 1.19307, 1.09154>, <-0.000319592, -3.5232e-05, 0.000146667> }
        smooth_triangle {<-2.7545, 1.19307, 1.11173>, <-0.000354073, -2.58926e-05, 0.000140671>,
                         <-2.74758, 1.19307, 1.13261>, <-0.000372827, -2.512e-05, 0.000103433>,
                         <-2.75103, 1.21089, 1.13343>, <-0.000334836, -0.000171165, 9.44276e-05> }
        smooth_triangle {<-2.75103, 1.21089, 1.13343>, <-0.000340326, -0.000146994, 0.000100377>,
                         <-2.75781, 1.21015, 1.11252>, <-0.000326581, -0.000144757, 0.000128383>,
                         <-2.7545, 1.19307, 1.11173>, <-0.000354754, -3.80398e-05, 0.00013506> }
        smooth_triangle {<-2.74758, 1.19307, 1.13261>, <-0.000372827, -2.512e-05, 0.000103433>,
                         <-2.7439, 1.19307, 1.15427>, <-0.000351069, -1.89379e-05, 2.67876e-05>,
                         <-2.74724, 1.21035, 1.15506>, <-0.000318257, -0.000150587, 1.90104e-05> }
        smooth_triangle {<-2.74724, 1.21035, 1.15506>, <-0.000335177, -0.000132368, 3.0678e-05>,
                         <-2.75103, 1.21089, 1.13343>, <-0.000347611, -0.000147802, 8.72409e-05>,
                         <-2.74758, 1.19307, 1.13261>, <-0.000376104, -3.82677e-05, 9.39946e-05> }
        smooth_triangle {<-2.7439, 1.19307, 1.15427>, <-0.000351069, -1.89379e-05, 2.67876e-05>,
                         <-2.74722, 1.19307, 1.17581>, <-0.000241486, -5.79092e-06, -6.69765e-05>,
                         <-2.74996, 1.20721, 1.17646>, <-0.000223069, -8.93597e-05, -7.13417e-05> }
        smooth_triangle {<-2.74996, 1.20721, 1.17646>, <-0.000260384, -8.43766e-05, -6.78727e-05>,
                         <-2.74724, 1.21035, 1.15506>, <-0.000331775, -0.000130297, -1.08647e-07>,
                         <-2.7439, 1.19307, 1.15427>, <-0.000356383, -3.15602e-05, 5.72429e-06> }
        smooth_triangle {<-2.74722, 1.19307, 1.17581>, <-0.000241486, -5.79092e-06, -6.69765e-05>,
                         <-2.76191, 1.19307, 1.19163>, <-7.39347e-05, 2.14149e-07, -6.41365e-05>,
                         <-2.76332, 1.20034, 1.19196>, <-6.97815e-05, -2.16721e-05, -6.5121e-05> }
        smooth_triangle {<-2.76332, 1.20034, 1.19196>, <-0.000108244, -2.46931e-05, -0.000100758>,
                         <-2.74996, 1.20721, 1.17646>, <-0.000223209, -7.54588e-05, -0.000105424>,
                         <-2.74722, 1.19307, 1.17581>, <-0.000237022, -1.27822e-05, -0.00010215> }
        smooth_triangle {<-2.76191, 1.19307, 1.19163>, <-7.39347e-05, 2.14149e-07, -6.41365e-05>,
                         <-2.78236, 1.19307, 1.19965>, <8.37973e-06, 4.24418e-12, 2.13479e-05>,
                         <-2.78215, 1.19202, 1.19961>, <8.14048e-06, 1.23613e-06, 2.14046e-05> }
        smooth_triangle {<-2.78215, 1.19202, 1.19961>, <-1.40453e-05, -6.68967e-07, -3.53371e-05>,
                         <-2.76332, 1.20034, 1.19196>, <-6.69403e-05, -1.73739e-05, -8.60459e-05>,
                         <-2.76191, 1.19307, 1.19163>, <-7.00552e-05, -9.59177e-07, -8.53076e-05> }
        smooth_triangle {<-2.83637, 1.18587, 0.884627>, <-0.000156511, 3.21275e-05, 3.99793e-05>,
                         <-2.83096, 1.18573, 0.905958>, <-0.000149659, 5.21502e-05, 3.84792e-05>,
                         <-2.82954, 1.19307, 0.905621>, <-0.000157634, -1.09436e-05, 4.03696e-05> }
        smooth_triangle {<-2.82954, 1.19307, 0.905621>, <-0.000156574, -3.35815e-07, 4.0073e-05>,
                         <-2.83498, 1.19307, 0.884297>, <-0.000154952, -3.19301e-07, 3.95812e-05>,
                         <-2.83637, 1.18587, 0.884627>, <-0.000154952, 3.18075e-05, 3.95812e-05> }
        smooth_triangle {<-2.83096, 1.18573, 0.905958>, <-0.000149659, 5.21502e-05, 3.84792e-05>,
                         <-2.8255, 1.18556, 0.92728>, <-0.000153058, 5.33388e-05, 3.97904e-05>,
                         <-2.82405, 1.19307, 0.926936>, <-0.000161209, -1.12269e-05, 4.17224e-05> }
        smooth_triangle {<-2.82405, 1.19307, 0.926936>, <-0.000160016, -3.88607e-07, 4.13578e-05>,
                         <-2.82954, 1.19307, 0.905621>, <-0.000157335, -1.76117e-07, 4.03432e-05>,
                         <-2.83096, 1.18573, 0.905958>, <-0.000151354, 4.71443e-05, 3.89254e-05> }
        smooth_triangle {<-2.8255, 1.18556, 0.92728>, <-0.000153058, 5.33388e-05, 3.97904e-05>,
                         <-2.81997, 1.18537, 0.948581>, <-0.000157225, 5.48036e-05, 4.17926e-05>,
                         <-2.81848, 1.19307, 0.948228>, <-0.000165586, -1.16019e-05, 4.37746e-05> }
        smooth_triangle {<-2.81848, 1.19307, 0.948228>, <-0.000164119, -4.93786e-07, 4.32764e-05>,
                         <-2.82405, 1.19307, 0.926936>, <-0.000160836, -2.12575e-07, 4.17372e-05>,
                         <-2.8255, 1.18556, 0.92728>, <-0.000154723, 4.82117e-05, 4.02882e-05> }
        smooth_triangle {<-2.81997, 1.18537, 0.948581>, <-0.000157225, 5.48036e-05, 4.17926e-05>,
                         <-2.81429, 1.18511, 0.969843>, <-0.000162882, 5.68039e-05, 4.51846e-05>,
                         <-2.81275, 1.19307, 0.969478>, <-0.000171523, -1.21597e-05, 4.72327e-05> }
        smooth_triangle {<-2.81275, 1.19307, 0.969478>, <-0.000169525, -7.00773e-07, 4.64515e-05>,
                         <-2.81848, 1.19307, 0.948228>, <-0.000165073, -2.82397e-07, 4.38579e-05>,
                         <-2.81997, 1.18537, 0.948581>, <-0.000158802, 4.95217e-05, 4.23714e-05> }
        smooth_triangle {<-2.81429, 1.18511, 0.969843>, <-0.000162882, 5.68039e-05, 4.51846e-05>,
                         <-2.80831, 1.18472, 0.99102>, <-0.000171523, 5.98976e-05, 5.18469e-05>,
                         <-2.80669, 1.19307, 0.990637>, <-0.000180579, -1.31073e-05, 5.39935e-05> }
        smooth_triangle {<-2.80669, 1.19307, 0.990637>, <-0.000177512, -1.13385e-06, 5.2538e-05>,
                         <-2.81275, 1.19307, 0.969478>, <-0.000170719, -4.23153e-07, 4.74675e-05>,
                         <-2.81429, 1.18511, 0.969843>, <-0.000164238, 5.12996e-05, 4.59313e-05> }
        smooth_triangle {<-2.80831, 1.18472, 0.99102>, <-0.000171523, 5.98976e-05, 5.18469e-05>,
                         <-2.80167, 1.18405, 1.01199>, <-0.000185618, 6.51445e-05, 6.54447e-05>,
                         <-2.79993, 1.19307, 1.01158>, <-0.000195379, -1.47083e-05, 6.77586e-05> }
        smooth_triangle {<-2.79993, 1.19307, 1.01158>, <-0.000190209, -1.93101e-06, 6.49225e-05>,
                         <-2.80669, 1.19307, 0.990637>, <-0.000179109, -7.30273e-07, 5.45987e-05>,
                         <-2.80831, 1.18472, 0.99102>, <-0.000172316, 5.40235e-05, 5.29887e-05> }
        smooth_triangle {<-2.80167, 1.18405, 1.01199>, <-0.000185618, 6.51445e-05, 6.54447e-05>,
                         <-2.7939, 1.18289, 1.03255>, <-0.000207137, 7.35599e-05, 8.8301e-05>,
                         <-2.79193, 1.19307, 1.03208>, <-0.000218091, -1.69638e-05, 9.08975e-05> }
        smooth_triangle {<-2.79193, 1.19307, 1.03208>, <-0.000209756, -2.95668e-06, 8.6186e-05>,
                         <-2.79993, 1.19307, 1.01158>, <-0.000192723, -1.26504e-06, 6.88319e-05>,
                         <-2.80167, 1.18405, 1.01199>, <-0.000185401, 5.86245e-05, 6.70965e-05> }
        smooth_triangle {<-2.7939, 1.18289, 1.03255>, <-0.000207137, 7.35599e-05, 8.8301e-05>,
                         <-2.78497, 1.1812, 1.05259>, <-0.000235787, 8.48528e-05, 0.00011526>,
                         <-2.78267, 1.19307, 1.05204>, <-0.000248421, -1.95783e-05, 0.000118255> }
        smooth_triangle {<-2.78267, 1.19307, 1.05204>, <-0.000237118, -3.76946e-06, 0.000112263>,
                         <-2.79193, 1.19307, 1.03208>, <-0.00021437, -1.80859e-06, 9.17454e-05>,
                         <-2.7939, 1.18289, 1.03255>, <-0.000206155, 6.60842e-05, 8.9798e-05> }
        smooth_triangle {<-2.78497, 1.1812, 1.05259>, <-0.000235787, 8.48528e-05, 0.00011526>,
                         <-2.77554, 1.17929, 1.07238>, <-0.000269407, 9.75694e-05, 0.000136635>,
                         <-2.77288, 1.19307, 1.07175>, <-0.000283988, -2.22352e-05, 0.000140091> }
        smooth_triangle {<-2.77288, 1.19307, 1.07175>, <-0.000271461, -4.02632e-06, 0.000134129>,
                         <-2.78267, 1.19307, 1.05204>, <-0.000244785, -2.03364e-06, 0.000117751>,
                         <-2.78497, 1.1812, 1.05259>, <-0.00023531, 7.62897e-05, 0.000115505> }
        smooth_triangle {<-2.77554, 1.17929, 1.07238>, <-0.000269407, 9.75694e-05, 0.000136635>,
                         <-2.76627, 1.17745, 1.09226>, <-0.000304456, 0.000110103, 0.000146136>,
                         <-2.76324, 1.19307, 1.09154>, <-0.000321015, -2.45455e-05, 0.000150061> }
        smooth_triangle {<-2.76324, 1.19307, 1.09154>, <-0.000308906, -3.69789e-06, 0.000145717>,
                         <-2.77288, 1.19307, 1.07175>, <-0.000281135, -1.96516e-06, 0.00013824>,
                         <-2.77554, 1.17929, 1.07238>, <-0.0002702, 8.78883e-05, 0.000135648> }
        smooth_triangle {<-2.76627, 1.17745, 1.09226>, <-0.000304456, 0.000110103, 0.000146136>,
                         <-2.75781, 1.17598, 1.11252>, <-0.000335793, 0.000120339, 0.000136339>,
                         <-2.7545, 1.19307, 1.11173>, <-0.000354073, -2.58926e-05, 0.000140671> }
        smooth_triangle {<-2.7545, 1.19307, 1.11173>, <-0.000344385, -2.59647e-06, 0.000139625>,
                         <-2.76324, 1.19307, 1.09154>, <-0.000319592, -1.58614e-06, 0.000146667>,
                         <-2.76627, 1.17745, 1.09226>, <-0.000307172, 9.94e-05, 0.000143723> }
        smooth_triangle {<-2.75781, 1.17598, 1.11252>, <-0.000335793, 0.000120339, 0.000136339>,
                         <-2.75103, 1.17524, 1.13343>, <-0.000353544, 0.000124749, 9.88618e-05>,
                         <-2.74758, 1.19307, 1.13261>, <-0.000372827, -2.512e-05, 0.000103433> }
        smooth_triangle {<-2.74758, 1.19307, 1.13261>, <-0.000368819, -2.19603e-07, 0.000107131>,
                         <-2.7545, 1.19307, 1.11173>, <-0.000354753, -7.99067e-07, 0.00013506>,
                         <-2.75781, 1.17598, 1.11252>, <-0.000341043, 0.000108875, 0.000131811> }
        smooth_triangle {<-2.75103, 1.17524, 1.13343>, <-0.000353544, 0.000124749, 9.88618e-05>,
                         <-2.74724, 1.17578, 1.15506>, <-0.000332361, 0.000115594, 2.23533e-05>,
                         <-2.7439, 1.19307, 1.15427>, <-0.000351069, -1.89379e-05, 2.67876e-05> }
        smooth_triangle {<-2.7439, 1.19307, 1.15427>, <-0.000359786, 5.22434e-06, 3.65109e-05>,
                         <-2.74758, 1.19307, 1.13261>, <-0.000376104, 5.87745e-07, 9.39946e-05>,
                         <-2.75103, 1.17524, 1.13343>, <-0.000361642, 0.00011299, 9.05665e-05> }
        smooth_triangle {<-2.74724, 1.17578, 1.15506>, <-0.000332361, 0.000115594, 2.23533e-05>,
                         <-2.74996, 1.17892, 1.17646>, <-0.000227382, 7.86595e-05, -7.03195e-05>,
                         <-2.74722, 1.19307, 1.17581>, <-0.000241486, -5.79092e-06, -6.69765e-05> }
        smooth_triangle {<-2.74722, 1.19307, 1.17581>, <-0.000274196, 1.30136e-05, -6.45988e-05>,
                         <-2.7439, 1.19307, 1.15427>, <-0.000356383, 3.15342e-06, 5.72428e-06>,
                         <-2.74724, 1.17578, 1.15506>, <-0.000342353, 0.000104052, 2.39853e-06> }
        smooth_triangle {<-2.74996, 1.17892, 1.17646>, <-0.000227382, 7.86595e-05, -7.03195e-05>,
                         <-2.76332, 1.18579, 1.19196>, <-6.9622e-05, 2.20678e-05, -6.51588e-05>,
                         <-2.76191, 1.19307, 1.19163>, <-7.39347e-05, 2.14149e-07, -6.41365e-05> }
        smooth_triangle {<-2.76191, 1.19307, 1.19163>, <-0.000111358, 8.59962e-06, -0.00010002>,
                         <-2.74722, 1.19307, 1.17581>, <-0.000237022, 4.09581e-06, -0.00010215>,
                         <-2.74996, 1.17892, 1.17646>, <-0.000226444, 6.74336e-05, -0.000104657> }
        smooth_triangle {<-2.76332, 1.18579, 1.19196>, <-6.9622e-05, 2.20678e-05, -6.51588e-05>,
                         <-2.78215, 1.19411, 1.19961>, <8.14048e-06, -1.23612e-06, 2.14046e-05>,
                         <-2.78236, 1.19307, 1.19965>, <8.37973e-06, 4.24418e-12, 2.13479e-05> }
        smooth_triangle {<-2.78236, 1.19307, 1.19965>, <-1.38858e-05, 1.49303e-06, -3.5375e-05>,
                         <-2.76191, 1.19307, 1.19163>, <-7.00552e-05, 1.28038e-06, -8.53076e-05>,
                         <-2.76332, 1.18579, 1.19196>, <-6.68207e-05, 1.76706e-05, -8.60742e-05> }
        smooth_triangle {<-2.84034, 1.17977, 0.885567>, <-0.000132585, 9.149e-05, 3.43081e-05>,
                         <-2.835, 1.1795, 0.906917>, <-0.000118797, 0.000107305, 3.11639e-05>,
                         <-2.83096, 1.18573, 0.905958>, <-0.000149659, 5.21502e-05, 3.84792e-05> }
        smooth_triangle {<-2.83096, 1.18573, 0.905958>, <-0.00014473, 6.15296e-05, 3.72656e-05>,
                         <-2.83637, 1.18587, 0.884627>, <-0.000143228, 6.08976e-05, 3.6802e-05>,
                         <-2.84034, 1.17977, 0.885567>, <-0.000131265, 9.05788e-05, 3.39664e-05> }
        smooth_triangle {<-2.835, 1.1795, 0.906917>, <-0.000118797, 0.000107305, 3.11639e-05>,
                         <-2.82964, 1.17921, 0.92826>, <-0.000121486, 0.000109784, 3.23068e-05>,
                         <-2.8255, 1.18556, 0.92728>, <-0.000153058, 5.33388e-05, 3.97904e-05> }
        smooth_triangle {<-2.8255, 1.18556, 0.92728>, <-0.000147922, 6.28758e-05, 3.84911e-05>,
                         <-2.83096, 1.18573, 0.905958>, <-0.000145372, 6.19844e-05, 3.75076e-05>,
                         <-2.835, 1.1795, 0.906917>, <-0.000122226, 0.00010335, 3.20211e-05> }
        smooth_triangle {<-2.82964, 1.17921, 0.92826>, <-0.000121486, 0.000109784, 3.23068e-05>,
                         <-2.82421, 1.17885, 0.949587>, <-0.000124772, 0.000112866, 3.41004e-05>,
                         <-2.81997, 1.18537, 0.948581>, <-0.000157225, 5.48036e-05, 4.17926e-05> }
        smooth_triangle {<-2.81997, 1.18537, 0.948581>, <-0.000151735, 6.44758e-05, 4.03411e-05>,
                         <-2.8255, 1.18556, 0.92728>, <-0.00014861, 6.33772e-05, 3.88394e-05>,
                         <-2.82964, 1.17921, 0.92826>, <-0.000124931, 0.000105711, 3.32267e-05> }
        smooth_triangle {<-2.82421, 1.17885, 0.949587>, <-0.000124772, 0.000112866, 3.41004e-05>,
                         <-2.81867, 1.17837, 0.970882>, <-0.000129219, 0.00011712, 3.72055e-05>,
                         <-2.81429, 1.18511, 0.969843>, <-0.000162882, 5.68039e-05, 4.51846e-05> }
        smooth_triangle {<-2.81429, 1.18511, 0.969843>, <-0.000156775, 6.6578e-05, 4.34292e-05>,
                         <-2.81997, 1.18537, 0.948581>, <-0.000152532, 6.50778e-05, 4.08852e-05>,
                         <-2.82421, 1.17885, 0.949587>, <-0.000128193, 0.000108624, 3.51161e-05> }
        smooth_triangle {<-2.81867, 1.17837, 0.970882>, <-0.000129219, 0.00011712, 3.72055e-05>,
                         <-2.8129, 1.17765, 0.992109>, <-0.000135972, 0.000123784, 4.34201e-05>,
                         <-2.80831, 1.18472, 0.99102>, <-0.000171523, 5.98976e-05, 5.18469e-05> }
        smooth_triangle {<-2.80831, 1.18472, 0.99102>, <-0.000164243, 6.96889e-05, 4.93929e-05>,
                         <-2.81429, 1.18511, 0.969843>, <-0.000157762, 6.73686e-05, 4.43962e-05>,
                         <-2.81867, 1.17837, 0.970882>, <-0.000132515, 0.000112605, 3.84119e-05> }
        smooth_triangle {<-2.8129, 1.17765, 0.992109>, <-0.000135972, 0.000123784, 4.34201e-05>,
                         <-2.80664, 1.17641, 1.01317>, <-0.000167634, 0.000118822, 6.38004e-05>,
                         <-2.80167, 1.18405, 1.01199>, <-0.000185618, 6.51445e-05, 6.54447e-05> }
        smooth_triangle {<-2.80167, 1.18405, 1.01199>, <-0.00017611, 7.47734e-05, 6.15806e-05>,
                         <-2.80831, 1.18472, 0.99102>, <-0.000165539, 7.08382e-05, 5.13823e-05>,
                         <-2.8129, 1.17765, 0.992109>, <-0.000138876, 0.000118753, 4.50622e-05> }
        smooth_triangle {<-2.80664, 1.17641, 1.01317>, <-0.000167634, 0.000118822, 6.38004e-05>,
                         <-2.79952, 1.17426, 1.03388>, <-0.000163309, 0.000152885, 7.79124e-05>,
                         <-2.7939, 1.18289, 1.03255>, <-0.000207137, 7.35599e-05, 8.8301e-05> }
        smooth_triangle {<-2.7939, 1.18289, 1.03255>, <-0.000194268, 8.29815e-05, 8.25147e-05>,
                         <-2.80167, 1.18405, 1.01199>, <-0.000178128, 7.66699e-05, 6.53725e-05>,
                         <-2.80664, 1.17641, 1.01317>, <-0.000163642, 0.000116297, 6.42522e-05> }
        smooth_triangle {<-2.79952, 1.17426, 1.03388>, <-0.000163309, 0.000152885, 7.79124e-05>,
                         <-2.79151, 1.17114, 1.05414>, <-0.000185228, 0.000176366, 0.000103276>,
                         <-2.78497, 1.1812, 1.05259>, <-0.000235787, 8.48528e-05, 0.00011526> }
        smooth_triangle {<-2.78497, 1.1812, 1.05259>, <-0.000219514, 9.47207e-05, 0.000108091>,
                         <-2.7939, 1.18289, 1.03255>, <-0.000198027, 8.6251e-05, 8.78714e-05>,
                         <-2.79952, 1.17426, 1.03388>, <-0.000165155, 0.000145745, 8.00799e-05> }
        smooth_triangle {<-2.79151, 1.17114, 1.05414>, <-0.000185228, 0.000176366, 0.000103276>,
                         <-2.78313, 1.16761, 1.07418>, <-0.000211325, 0.00020252, 0.000122868>,
                         <-2.77554, 1.17929, 1.07238>, <-0.000269407, 9.75694e-05, 0.000136635> }
        smooth_triangle {<-2.77554, 1.17929, 1.07238>, <-0.000251104, 0.000109201, 0.000129304>,
                         <-2.78497, 1.1812, 1.05259>, <-0.000225889, 9.96639e-05, 0.000113272>,
                         <-2.79151, 1.17114, 1.05414>, <-0.00018797, 0.000168299, 0.000104284> }
        smooth_triangle {<-2.78313, 1.16761, 1.07418>, <-0.000211325, 0.00020252, 0.000122868>,
                         <-2.77487, 1.16421, 1.0943>, <-0.000239018, 0.000227989, 0.000130625>,
                         <-2.76627, 1.17745, 1.09226>, <-0.000304456, 0.000110103, 0.000146136> }
        smooth_triangle {<-2.76627, 1.17745, 1.09226>, <-0.00028553, 0.000124471, 0.000140176>,
                         <-2.77554, 1.17929, 1.07238>, <-0.000259244, 0.000115071, 0.000133051>,
                         <-2.78313, 1.16761, 1.07418>, <-0.000215682, 0.000193784, 0.000122726> }
        smooth_triangle {<-2.77487, 1.16421, 1.0943>, <-0.000239018, 0.000227989, 0.000130625>,
                         <-2.76723, 1.16149, 1.11475>, <-0.000264453, 0.00024825, 0.000119429>,
                         <-2.75781, 1.17598, 1.11252>, <-0.000335793, 0.000120339, 0.000136339> }
        smooth_triangle {<-2.75781, 1.17598, 1.11252>, <-0.000318146, 0.000138162, 0.000133406>,
                         <-2.76627, 1.17745, 1.09226>, <-0.000294643, 0.000130485, 0.000140754>,
                         <-2.77487, 1.16421, 1.0943>, <-0.000245565, 0.000218899, 0.000129121> }
        smooth_triangle {<-2.76723, 1.16149, 1.11475>, <-0.000264453, 0.00024825, 0.000119429>,
                         <-2.76086, 1.16014, 1.13576>, <-0.000279922, 0.000255627, 8.14112e-05>,
                         <-2.75103, 1.17524, 1.13343>, <-0.000353544, 0.000124749, 9.88618e-05> }
        smooth_triangle {<-2.75103, 1.17524, 1.13343>, <-0.00034049, 0.000146588, 0.000100416>,
                         <-2.75781, 1.17598, 1.11252>, <-0.000327176, 0.000143281, 0.000128524>,
                         <-2.76723, 1.16149, 1.11475>, <-0.000273671, 0.000239214, 0.000115841> }
        smooth_triangle {<-2.76086, 1.16014, 1.13576>, <-0.000279922, 0.000255627, 8.14112e-05>,
                         <-2.75677, 1.16113, 1.15732>, <-0.000264982, 0.000232528, 6.38247e-06>,
                         <-2.74724, 1.17578, 1.15506>, <-0.000332361, 0.000115594, 2.23533e-05> }
        smooth_triangle {<-2.74724, 1.17578, 1.15506>, <-0.000331286, 0.000142021, 2.97557e-05>,
                         <-2.75103, 1.17524, 1.13343>, <-0.000347173, 0.000148888, 8.71371e-05>,
                         <-2.76086, 1.16014, 1.13576>, <-0.000291957, 0.000247046, 7.40491e-05> }
        smooth_triangle {<-2.75677, 1.16113, 1.15732>, <-0.000264982, 0.000232528, 6.38247e-06>,
                         <-2.75776, 1.16693, 1.17831>, <-0.000182905, 0.000151135, -8.08618e-05>,
                         <-2.74996, 1.17892, 1.17646>, <-0.000227382, 7.86595e-05, -7.03195e-05> }
        smooth_triangle {<-2.74996, 1.17892, 1.17646>, <-0.000250692, 0.000108423, -7.017e-05>,
                         <-2.74724, 1.17578, 1.15506>, <-0.000329426, 0.000136124, -6.65372e-07>,
                         <-2.75677, 1.16113, 1.15732>, <-0.000278892, 0.000223824, -1.26435e-05> }
        smooth_triangle {<-2.75776, 1.16693, 1.17831>, <-0.000182905, 0.000151135, -8.08618e-05>,
                         <-2.76733, 1.17962, 1.19291>, <-5.75001e-05, 4.05618e-05, -6.8032e-05>,
                         <-2.76332, 1.18579, 1.19196>, <-6.9622e-05, 2.20678e-05, -6.51588e-05> }
        smooth_triangle {<-2.76332, 1.18579, 1.19196>, <-0.000101839, 4.05831e-05, -0.000102277>,
                         <-2.74996, 1.17892, 1.17646>, <-0.000220159, 8.30269e-05, -0.000106147>,
                         <-2.75776, 1.16693, 1.17831>, <-0.000186802, 0.000137383, -0.000114054> }
        smooth_triangle {<-2.76733, 1.17962, 1.19291>, <-5.75001e-05, 4.05618e-05, -6.8032e-05>,
                         <-2.78158, 1.19499, 1.19947>, <7.45915e-06, -2.28405e-06, 2.15661e-05>,
                         <-2.78215, 1.19411, 1.19961>, <8.14048e-06, -1.23612e-06, 2.14046e-05> }
        smooth_triangle {<-2.78215, 1.19411, 1.19961>, <-1.29334e-05, 3.42772e-06, -3.56007e-05>,
                         <-2.76332, 1.18579, 1.19196>, <-6.59868e-05, 1.97397e-05, -8.62719e-05>,
                         <-2.76733, 1.17962, 1.19291>, <-5.68953e-05, 3.36102e-05, -8.84269e-05> }
        smooth_triangle {<-2.84627, 1.1757, 0.886973>, <-8.83756e-05, 0.000136924, 2.38292e-05>,
                         <-2.84106, 1.17535, 0.908352>, <-6.97457e-05, 0.000146123, 1.95374e-05>,
                         <-2.835, 1.1795, 0.906917>, <-0.000118797, 0.000107305, 3.11639e-05> }
        smooth_triangle {<-2.835, 1.1795, 0.906917>, <-0.000110751, 0.000114028, 2.92115e-05>,
                         <-2.84034, 1.17977, 0.885567>, <-0.0001096, 0.000112843, 2.88313e-05>,
                         <-2.84627, 1.1757, 0.886973>, <-8.74954e-05, 0.00013556, 2.35918e-05> }
        smooth_triangle {<-2.84106, 1.17535, 0.908352>, <-6.97457e-05, 0.000146123, 1.95374e-05>,
                         <-2.83582, 1.17496, 0.929726>, <-7.12982e-05, 0.000149516, 2.04109e-05>,
                         <-2.82964, 1.17921, 0.92826>, <-0.000121486, 0.000109784, 3.23068e-05> }
        smooth_triangle {<-2.82964, 1.17921, 0.92826>, <-0.00011319, 0.000116568, 3.02587e-05>,
                         <-2.835, 1.1795, 0.906917>, <-0.000111174, 0.000114708, 2.94015e-05>,
                         <-2.84106, 1.17535, 0.908352>, <-7.43855e-05, 0.000143822, 2.06816e-05> }
        smooth_triangle {<-2.83582, 1.17496, 0.929726>, <-7.12982e-05, 0.000149516, 2.04109e-05>,
                         <-2.83056, 1.17449, 0.951091>, <-7.317e-05, 0.000153745, 2.18691e-05>,
                         <-2.82421, 1.17885, 0.949587>, <-0.000124772, 0.000112866, 3.41004e-05> }
        smooth_triangle {<-2.82421, 1.17885, 0.949587>, <-0.000116102, 0.000119629, 3.18949e-05>,
                         <-2.82964, 1.17921, 0.92826>, <-0.000113637, 0.000117318, 3.05496e-05>,
                         <-2.83582, 1.17496, 0.929726>, <-7.59961e-05, 0.000147117, 2.16277e-05> }
        smooth_triangle {<-2.83056, 1.17449, 0.951091>, <-7.317e-05, 0.000153745, 2.18691e-05>,
                         <-2.82523, 1.17386, 0.972437>, <-7.56589e-05, 0.000159605, 2.45102e-05>,
                         <-2.81867, 1.17837, 0.970882>, <-0.000129219, 0.00011712, 3.72055e-05> }
        smooth_triangle {<-2.81867, 1.17837, 0.970882>, <-0.000119943, 0.000123721, 3.46988e-05>,
                         <-2.82421, 1.17885, 0.949587>, <-0.000116608, 0.00012053, 3.23701e-05>,
                         <-2.83056, 1.17449, 0.951091>, <-7.7906e-05, 0.00015119, 2.31966e-05> }
        smooth_triangle {<-2.82523, 1.17386, 0.972437>, <-7.56589e-05, 0.000159605, 2.45102e-05>,
                         <-2.81979, 1.17293, 0.99374>, <-7.93375e-05, 0.000168825, 2.99961e-05>,
                         <-2.8129, 1.17765, 0.992109>, <-0.000135972, 0.000123784, 4.34201e-05> }
        smooth_triangle {<-2.8129, 1.17765, 0.992109>, <-0.000125612, 0.000129902, 4.02363e-05>,
                         <-2.81867, 1.17837, 0.970882>, <-0.000120548, 0.000124904, 3.55753e-05>,
                         <-2.82523, 1.17386, 0.972437>, <-8.03776e-05, 0.000156768, 2.60538e-05> }
        smooth_triangle {<-2.81979, 1.17293, 0.99374>, <-7.93375e-05, 0.000168825, 2.99961e-05>,
                         <-2.81407, 1.17131, 1.01493>, <-8.50195e-05, 0.00018445, 4.15999e-05>,
                         <-2.80664, 1.17641, 1.01317>, <-0.000105326, 0.000167595, 4.11762e-05> }
        smooth_triangle {<-2.80664, 1.17641, 1.01317>, <-0.000101411, 0.000161366, 3.96459e-05>,
                         <-2.8129, 1.17765, 0.992109>, <-0.000126353, 0.000131622, 4.2094e-05>,
                         <-2.81979, 1.17293, 0.99374>, <-8.38774e-05, 0.000165403, 3.2026e-05> }
        smooth_triangle {<-2.81407, 1.17131, 1.01493>, <-8.50195e-05, 0.00018445, 4.15999e-05>,
                         <-2.80791, 1.16849, 1.03587>, <-9.32786e-05, 0.000208934, 6.13132e-05>,
                         <-2.79952, 1.17426, 1.03388>, <-0.000163309, 0.000152885, 7.79124e-05> }
        smooth_triangle {<-2.79952, 1.17426, 1.03388>, <-0.000147957, 0.000156286, 7.15378e-05>,
                         <-2.80664, 1.17641, 1.01317>, <-0.000103615, 0.000167043, 4.67952e-05>,
                         <-2.81407, 1.17131, 1.01493>, <-8.92406e-05, 0.00017996, 4.43035e-05> }
        smooth_triangle {<-2.80791, 1.16849, 1.03587>, <-9.32786e-05, 0.000208934, 6.13132e-05>,
                         <-2.8013, 1.16442, 1.05646>, <-0.000104442, 0.000241029, 8.41273e-05>,
                         <-2.79151, 1.17114, 1.05414>, <-0.000185228, 0.000176366, 0.000103276> }
        smooth_triangle {<-2.79151, 1.17114, 1.05414>, <-0.000166576, 0.00017879, 9.55428e-05>,
                         <-2.79952, 1.17426, 1.03388>, <-0.000150137, 0.00016118, 7.652e-05>,
                         <-2.80791, 1.16849, 1.03587>, <-9.76142e-05, 0.000203217, 6.40706e-05> }
        smooth_triangle {<-2.8013, 1.16442, 1.05646>, <-0.000104442, 0.000241029, 8.41273e-05>,
                         <-2.7945, 1.15981, 1.07688>, <-0.000118584, 0.000276639, 0.000100886>,
                         <-2.78313, 1.16761, 1.07418>, <-0.000211325, 0.00020252, 0.000122868> }
        smooth_triangle {<-2.78313, 1.16761, 1.07418>, <-0.000190135, 0.000205804, 0.000114852>,
                         <-2.79151, 1.17114, 1.05414>, <-0.000170563, 0.000186188, 0.000100158>,
                         <-2.8013, 1.16442, 1.05646>, <-0.000109973, 0.000234686, 8.57965e-05> }
        smooth_triangle {<-2.7945, 1.15981, 1.07688>, <-0.000118584, 0.000276639, 0.000100886>,
                         <-2.78775, 1.15537, 1.09735>, <-0.000134665, 0.000311165, 0.00010589>,
                         <-2.77487, 1.16421, 1.0943>, <-0.000239018, 0.000227989, 0.000130625> }
        smooth_triangle {<-2.77487, 1.16421, 1.0943>, <-0.000216208, 0.00023369, 0.000123745>,
                         <-2.78313, 1.16761, 1.07418>, <-0.000195438, 0.000214589, 0.000117927>,
                         <-2.7945, 1.15981, 1.07688>, <-0.000125883, 0.000270178, 0.00010144> }
        smooth_triangle {<-2.78775, 1.15537, 1.09735>, <-0.000134665, 0.000311165, 0.00010589>,
                         <-2.78132, 1.15181, 1.11809>, <-0.000150913, 0.000338367, 9.25165e-05>,
                         <-2.76723, 1.16149, 1.11475>, <-0.000264453, 0.00024825, 0.000119429> }
        smooth_triangle {<-2.76723, 1.16149, 1.11475>, <-0.000241491, 0.000257887, 0.000115236>,
                         <-2.77487, 1.16421, 1.0943>, <-0.000222415, 0.00024269, 0.000123633>,
                         <-2.78775, 1.15537, 1.09735>, <-0.000144151, 0.000305073, 0.000105082> }
        smooth_triangle {<-2.78132, 1.15181, 1.11809>, <-0.000150913, 0.000338367, 9.25165e-05>,
                         <-2.77556, 1.15004, 1.13924>, <-0.00016317, 0.000347588, 5.37375e-05>,
                         <-2.76086, 1.16014, 1.13576>, <-0.000279922, 0.000255627, 8.14112e-05> }
        smooth_triangle {<-2.76086, 1.16014, 1.13576>, <-0.00025965, 0.00027108, 8.12548e-05>,
                         <-2.76723, 1.16149, 1.11475>, <-0.000248048, 0.000265547, 0.000109768>,
                         <-2.78132, 1.15181, 1.11809>, <-0.000162893, 0.000333135, 8.95837e-05> }
        smooth_triangle {<-2.77556, 1.15004, 1.13924>, <-0.00016317, 0.000347588, 5.37375e-05>,
                         <-2.77102, 1.15134, 1.1607>, <-0.00015919, 0.000314062, -1.86934e-05>,
                         <-2.75677, 1.16113, 1.15732>, <-0.000264982, 0.000232528, 6.38247e-06> }
        smooth_triangle {<-2.75677, 1.16113, 1.15732>, <-0.000254018, 0.000257196, 1.14408e-05>,
                         <-2.76086, 1.16014, 1.13576>, <-0.000265223, 0.000274521, 6.77123e-05>,
                         <-2.77556, 1.15004, 1.13924>, <-0.000177659, 0.000343491, 4.69571e-05> }
        smooth_triangle {<-2.77102, 1.15134, 1.1607>, <-0.00015919, 0.000314062, -1.86934e-05>,
                         <-2.76942, 1.15892, 1.18108>, <-0.000114827, 0.000200601, -9.69984e-05>,
                         <-2.75776, 1.16693, 1.17831>, <-0.000182905, 0.000151135, -8.08618e-05> }
        smooth_triangle {<-2.75776, 1.16693, 1.17831>, <-0.00019345, 0.000187325, -8.3738e-05>,
                         <-2.75677, 1.16113, 1.15732>, <-0.000255008, 0.00024837, -1.83048e-05>,
                         <-2.77102, 1.15134, 1.1607>, <-0.000175664, 0.00030952, -3.71118e-05> }
        smooth_triangle {<-2.76942, 1.15892, 1.18108>, <-0.000114827, 0.000200601, -9.69984e-05>,
                         <-2.77333, 1.17549, 1.19434>, <-3.94143e-05, 5.28807e-05, -7.23189e-05>,
                         <-2.76733, 1.17962, 1.19291>, <-5.75001e-05, 4.05618e-05, -6.8032e-05> }
        smooth_triangle {<-2.76733, 1.17962, 1.19291>, <-8.11348e-05, 6.63882e-05, -0.000107184>,
                         <-2.75776, 1.16693, 1.17831>, <-0.000175189, 0.000149318, -0.000116806>,
                         <-2.76942, 1.15892, 1.18108>, <-0.00012413, 0.000186418, -0.000128909> }
        smooth_triangle {<-2.77333, 1.17549, 1.19434>, <-3.94143e-05, 5.28807e-05, -7.23189e-05>,
                         <-2.78072, 1.19559, 1.19927>, <6.43947e-06, -2.98426e-06, 2.18078e-05>,
                         <-2.78158, 1.19499, 1.19947>, <7.45915e-06, -2.28405e-06, 2.15661e-05> }
        smooth_triangle {<-2.78158, 1.19499, 1.19947>, <-1.13331e-05, 4.84057e-06, -3.598e-05>,
                         <-2.76733, 1.17962, 1.19291>, <-5.53544e-05, 3.51938e-05, -8.87921e-05>,
                         <-2.77333, 1.17549, 1.19434>, <-4.17901e-05, 4.4433e-05, -9.20073e-05> }
        smooth_triangle {<-2.85327, 1.17427, 0.888632>, <-3.06134e-05, 0.000161513, 1.01378e-05>,
                         <-2.8482, 1.17389, 0.910045>, <-9.97406e-06, 0.000162695, 5.36969e-06>,
                         <-2.84106, 1.17535, 0.908352>, <-6.97457e-05, 0.000146123, 1.95374e-05> }
        smooth_triangle {<-2.84106, 1.17535, 0.908352>, <-5.98102e-05, 0.000149166, 1.7137e-05>,
                         <-2.84627, 1.1757, 0.886973>, <-5.91896e-05, 0.00014761, 1.68825e-05>,
                         <-2.85327, 1.17427, 0.888632>, <-3.03084e-05, 0.000159904, 1.00368e-05> }
        smooth_triangle {<-2.8482, 1.17389, 0.910045>, <-9.97406e-06, 0.000162695, 5.36969e-06>,
                         <-2.84312, 1.17346, 0.931456>, <-1.01363e-05, 0.000166485, 5.91369e-06>,
                         <-2.83582, 1.17496, 0.929726>, <-7.12982e-05, 0.000149516, 2.04109e-05> }
        smooth_triangle {<-2.83582, 1.17496, 0.929726>, <-6.11098e-05, 0.000152514, 1.7914e-05>,
                         <-2.84106, 1.17535, 0.908352>, <-5.99454e-05, 0.000149969, 1.72589e-05>,
                         <-2.8482, 1.17389, 0.910045>, <-1.51167e-05, 0.000162398, 6.63314e-06> }
        smooth_triangle {<-2.84312, 1.17346, 0.931456>, <-1.01363e-05, 0.000166485, 5.91369e-06>,
                         <-2.83805, 1.17296, 0.952866>, <-1.02734e-05, 0.000171218, 6.96077e-06>,
                         <-2.83056, 1.17449, 0.951091>, <-7.317e-05, 0.000153745, 2.18691e-05> }
        smooth_triangle {<-2.83056, 1.17449, 0.951091>, <-6.26434e-05, 0.000156571, 1.92236e-05>,
                         <-2.83582, 1.17496, 0.929726>, <-6.12395e-05, 0.000153399, 1.81299e-05>,
                         <-2.84312, 1.17346, 0.931456>, <-1.53681e-05, 0.000166126, 7.25706e-06> }
        smooth_triangle {<-2.83805, 1.17296, 0.952866>, <-1.02734e-05, 0.000171218, 6.96077e-06>,
                         <-2.83297, 1.17228, 0.974272>, <-1.03559e-05, 0.000177792, 9.03142e-06>,
                         <-2.82523, 1.17386, 0.972437>, <-7.56589e-05, 0.000159605, 2.45102e-05> }
        smooth_triangle {<-2.82523, 1.17386, 0.972437>, <-6.46361e-05, 0.000162028, 2.15895e-05>,
                         <-2.83056, 1.17449, 0.951091>, <-6.27693e-05, 0.000157633, 1.96087e-05>,
                         <-2.83805, 1.17296, 0.952866>, <-1.5597e-05, 0.000170738, 8.42747e-06> }
        smooth_triangle {<-2.83297, 1.17228, 0.974272>, <-1.03559e-05, 0.000177792, 9.03142e-06>,
                         <-2.8279, 1.17127, 0.995664>, <-1.02425e-05, 0.000188164, 1.36185e-05>,
                         <-2.81979, 1.17293, 0.99374>, <-7.93375e-05, 0.000168825, 2.99961e-05> }
        smooth_triangle {<-2.81979, 1.17293, 0.99374>, <-6.75007e-05, 0.000170339, 2.64621e-05>,
                         <-2.82523, 1.17386, 0.972437>, <-6.47417e-05, 0.000163424, 2.23477e-05>,
                         <-2.83297, 1.17228, 0.974272>, <-1.57645e-05, 0.000177064, 1.07386e-05> }
        smooth_triangle {<-2.8279, 1.17127, 0.995664>, <-1.02425e-05, 0.000188164, 1.36185e-05>,
                         <-2.82284, 1.16952, 1.01701>, <-9.49842e-06, 0.00020574, 2.36992e-05>,
                         <-2.81407, 1.17131, 1.01493>, <-8.50195e-05, 0.00018445, 4.15999e-05> }
        smooth_triangle {<-2.81407, 1.17131, 1.01493>, <-7.17774e-05, 0.000184087, 3.68507e-05>,
                         <-2.81979, 1.17293, 0.99374>, <-6.75159e-05, 0.000172368, 2.81478e-05>,
                         <-2.8279, 1.17127, 0.995664>, <-1.56946e-05, 0.000186872, 1.58646e-05> }
        smooth_triangle {<-2.82284, 1.16952, 1.01701>, <-9.49842e-06, 0.00020574, 2.36992e-05>,
                         <-2.81782, 1.16647, 1.03821>, <-7.7084e-06, 0.000233176, 4.10305e-05>,
                         <-2.80791, 1.16849, 1.03587>, <-9.32786e-05, 0.000208934, 6.13132e-05> }
        smooth_triangle {<-2.80791, 1.16849, 1.03587>, <-7.78761e-05, 0.000205798, 5.49264e-05>,
                         <-2.81407, 1.17131, 1.01493>, <-7.16818e-05, 0.000187435, 4.01415e-05>,
                         <-2.82284, 1.16952, 1.01701>, <-1.5041e-05, 0.000203402, 2.6716e-05> }
        smooth_triangle {<-2.81782, 1.16647, 1.03821>, <-7.7084e-06, 0.000233176, 4.10305e-05>,
                         <-2.81284, 1.16206, 1.05919>, <-5.72626e-06, 0.000268997, 6.07288e-05>,
                         <-2.8013, 1.16442, 1.05646>, <-0.000104442, 0.000241029, 8.41273e-05> }
        smooth_triangle {<-2.8013, 1.16442, 1.05646>, <-8.63633e-05, 0.000235641, 7.65299e-05>,
                         <-2.80791, 1.16849, 1.03587>, <-7.79911e-05, 0.00021157, 5.94193e-05>,
                         <-2.81782, 1.16647, 1.03821>, <-1.38134e-05, 0.000229751, 4.42073e-05> }
        smooth_triangle {<-2.81284, 1.16206, 1.05919>, <-5.72626e-06, 0.000268997, 6.07288e-05>,
                         <-2.8079, 1.15707, 1.08005>, <-5.3029e-06, 0.000308642, 7.40347e-05>,
                         <-2.7945, 1.15981, 1.07688>, <-0.000118584, 0.000276639, 0.000100886> }
        smooth_triangle {<-2.7945, 1.15981, 1.07688>, <-9.78352e-05, 0.000271075, 9.29742e-05>,
                         <-2.8013, 1.16442, 1.05646>, <-8.72286e-05, 0.000244368, 8.04055e-05>,
                         <-2.81284, 1.16206, 1.05919>, <-1.31921e-05, 0.000265344, 6.28566e-05> }
        smooth_triangle {<-2.8079, 1.15707, 1.08005>, <-5.3029e-06, 0.000308642, 7.40347e-05>,
                         <-2.80295, 1.15226, 1.10095>, <-7.28323e-06, 0.00034697, 7.56969e-05>,
                         <-2.78775, 1.15537, 1.09735>, <-0.000134665, 0.000311165, 0.00010589> }
        smooth_triangle {<-2.78775, 1.15537, 1.09735>, <-0.000111494, 0.000307332, 9.89244e-05>,
                         <-2.7945, 1.15981, 1.07688>, <-9.94328e-05, 0.000281437, 9.5171e-05>,
                         <-2.8079, 1.15707, 1.08005>, <-1.44722e-05, 0.000305439, 7.50328e-05> }
        smooth_triangle {<-2.80295, 1.15226, 1.10095>, <-7.28323e-06, 0.00034697, 7.56969e-05>,
                         <-2.79795, 1.14841, 1.12203>, <-1.24597e-05, 0.000376971, 5.96989e-05>,
                         <-2.78132, 1.15181, 1.11809>, <-0.000150913, 0.000338367, 9.25165e-05> }
        smooth_triangle {<-2.78132, 1.15181, 1.11809>, <-0.00012609, 0.00033835, 8.78826e-05>,
                         <-2.78775, 1.15537, 1.09735>, <-0.000113904, 0.000317949, 9.79129e-05>,
                         <-2.80295, 1.15226, 1.10095>, <-1.83675e-05, 0.000344802, 7.52679e-05> }
        smooth_triangle {<-2.79795, 1.14841, 1.12203>, <-1.24597e-05, 0.000376971, 5.96989e-05>,
                         <-2.7929, 1.1465, 1.14335>, <-2.10627e-05, 0.000386631, 2.00538e-05>,
                         <-2.77556, 1.15004, 1.13924>, <-0.00016317, 0.000347588, 5.37375e-05> }
        smooth_triangle {<-2.77556, 1.15004, 1.13924>, <-0.000138608, 0.000354302, 5.25641e-05>,
                         <-2.78132, 1.15181, 1.11809>, <-0.000129415, 0.000347386, 8.16483e-05>,
                         <-2.79795, 1.14841, 1.12203>, <-2.55748e-05, 0.000376339, 5.70352e-05> }
        smooth_triangle {<-2.7929, 1.1465, 1.14335>, <-2.10627e-05, 0.000386631, 2.00538e-05>,
                         <-2.78784, 1.14791, 1.16469>, <-3.10905e-05, 0.000347782, -4.90568e-05>,
                         <-2.77102, 1.15134, 1.1607>, <-0.00015919, 0.000314062, -1.86934e-05> }
        smooth_triangle {<-2.77102, 1.15134, 1.1607>, <-0.000139744, 0.000333216, -1.56456e-05>,
                         <-2.77556, 1.15004, 1.13924>, <-0.000142729, 0.00035836, 3.86776e-05>,
                         <-2.7929, 1.1465, 1.14335>, <-3.61483e-05, 0.000387643, 1.34148e-05> }
        smooth_triangle {<-2.78784, 1.14791, 1.16469>, <-3.10905e-05, 0.000347782, -4.90568e-05>,
                         <-2.78318, 1.15611, 1.18434>, <-3.35114e-05, 0.000219528, -0.000116273>,
                         <-2.76942, 1.15892, 1.18108>, <-0.000114827, 0.000200601, -9.69984e-05> }
        smooth_triangle {<-2.76942, 1.15892, 1.18108>, <-0.000111185, 0.000237709, -0.000103237>,
                         <-2.77102, 1.15134, 1.1607>, <-0.000144457, 0.000322805, -4.45086e-05>,
                         <-2.78784, 1.14791, 1.16469>, <-4.83823e-05, 0.000348095, -6.72812e-05> }
        smooth_triangle {<-2.78318, 1.15611, 1.18434>, <-3.35114e-05, 0.000219528, -0.000116273>,
                         <-2.78041, 1.17405, 1.19601>, <-1.81181e-05, 5.71489e-05, -7.73667e-05>,
                         <-2.77333, 1.17549, 1.19434>, <-3.94143e-05, 5.28807e-05, -7.23189e-05> }
        smooth_triangle {<-2.77333, 1.17549, 1.19434>, <-5.23976e-05, 8.20863e-05, -0.000113996>,
                         <-2.76942, 1.15892, 1.18108>, <-0.000108957, 0.000192876, -0.000132505>,
                         <-2.78318, 1.15611, 1.18434>, <-4.79704e-05, 0.000207071, -0.000146961> }
        smooth_triangle {<-2.78041, 1.17405, 1.19601>, <-1.81181e-05, 5.71489e-05, -7.73667e-05>,
                         <-2.7797, 1.19579, 1.19902>, <5.23667e-06, -3.23014e-06, 2.20929e-05>,
                         <-2.78072, 1.19559, 1.19927>, <6.43947e-06, -2.98426e-06, 2.18078e-05> }
        smooth_triangle {<-2.78072, 1.19559, 1.19927>, <-9.32845e-06, 5.51649e-06, -3.64552e-05>,
                         <-2.77333, 1.17549, 1.19434>, <-3.97768e-05, 4.529e-05, -9.24845e-05>,
                         <-2.78041, 1.17405, 1.19601>, <-2.38047e-05, 4.84912e-05, -9.62703e-05> }
        smooth_triangle {<-2.86027, 1.1757, 0.890291>, <3.19079e-05, 0.000161512, -4.68161e-06>,
                         <-2.85534, 1.17535, 0.911737>, <5.14187e-05, 0.000154499, -9.18222e-06>,
                         <-2.8482, 1.17389, 0.910045>, <-9.97406e-06, 0.000162695, 5.36969e-06> }
        smooth_triangle {<-2.8482, 1.17389, 0.910045>, <3.37566e-07, 0.000161595, 2.88017e-06>,
                         <-2.85327, 1.17427, 0.888632>, <3.29539e-07, 0.000159904, 2.7747e-06>,
                         <-2.86027, 1.1757, 0.890291>, <3.15902e-05, 0.000159904, -4.635e-06> }
        smooth_triangle {<-2.85534, 1.17535, 0.911737>, <5.14187e-05, 0.000154499, -9.18222e-06>,
                         <-2.85042, 1.17496, 0.933186>, <5.26887e-05, 0.000158109, -8.9777e-06>,
                         <-2.84312, 1.17346, 0.931456>, <-1.01363e-05, 0.000166485, 5.91369e-06> }
        smooth_triangle {<-2.84312, 1.17346, 0.931456>, <3.91453e-07, 0.000165241, 3.33641e-06>,
                         <-2.8482, 1.17389, 0.910045>, <5.13123e-07, 0.000162398, 2.92841e-06>,
                         <-2.85534, 1.17535, 0.911737>, <4.65577e-05, 0.000156251, -7.98552e-06> }
        smooth_triangle {<-2.85042, 1.17496, 0.933186>, <5.26887e-05, 0.000158109, -8.9777e-06>,
                         <-2.84554, 1.17449, 0.954641>, <5.43418e-05, 0.000162625, -8.35494e-06>,
                         <-2.83805, 1.17296, 0.952866>, <-1.02734e-05, 0.000171218, 6.96077e-06> }
        smooth_triangle {<-2.83805, 1.17296, 0.952866>, <5.01432e-07, 0.000169675, 4.25643e-06>,
                         <-2.84312, 1.17346, 0.931456>, <6.04294e-07, 0.000166126, 3.47112e-06>,
                         <-2.85042, 1.17496, 0.933186>, <4.77231e-05, 0.000159843, -7.69742e-06> }
        smooth_triangle {<-2.84554, 1.17449, 0.954641>, <5.43418e-05, 0.000162625, -8.35494e-06>,
                         <-2.84071, 1.17386, 0.976107>, <5.67484e-05, 0.000168912, -6.87429e-06>,
                         <-2.83297, 1.17228, 0.974272>, <-1.03559e-05, 0.000177792, 9.03142e-06> }
        smooth_triangle {<-2.83297, 1.17228, 0.974272>, <7.24981e-07, 0.000175668, 6.09701e-06>,
                         <-2.83805, 1.17296, 0.952866>, <7.86845e-07, 0.000170738, 4.54402e-06>,
                         <-2.84554, 1.17449, 0.954641>, <4.92482e-05, 0.000164293, -6.94276e-06> }
        smooth_triangle {<-2.84071, 1.17386, 0.976107>, <5.67484e-05, 0.000168912, -6.87429e-06>,
                         <-2.83602, 1.17293, 0.997588>, <6.07942e-05, 0.000178857, -3.21926e-06>,
                         <-2.8279, 1.17127, 0.995664>, <-1.02425e-05, 0.000188164, 1.36185e-05> }
        smooth_triangle {<-2.8279, 1.17127, 0.995664>, <1.24471e-06, 0.000184843, 1.01674e-05>,
                         <-2.83297, 1.17228, 0.974272>, <1.15964e-06, 0.000177064, 6.72707e-06>,
                         <-2.84071, 1.17386, 0.976107>, <5.14879e-05, 0.000170404, -5.20221e-06> }
        smooth_triangle {<-2.83602, 1.17293, 0.997588>, <6.07942e-05, 0.000178857, -3.21926e-06>,
                         <-2.83161, 1.17131, 1.01909>, <6.82015e-05, 0.000195707, 5.28202e-06>,
                         <-2.82284, 1.16952, 1.01701>, <-9.49842e-06, 0.00020574, 2.36992e-05> }
        smooth_triangle {<-2.82284, 1.16952, 1.01701>, <2.57296e-06, 0.000200054, 1.92275e-05>,
                         <-2.8279, 1.17127, 0.995664>, <2.01491e-06, 0.000186872, 1.1667e-05>,
                         <-2.83602, 1.17293, 0.997588>, <5.52924e-05, 0.000179892, -9.61385e-07> }
        smooth_triangle {<-2.83161, 1.17131, 1.01909>, <6.82015e-05, 0.000195707, 5.28202e-06>,
                         <-2.82772, 1.16849, 1.04056>, <8.03747e-05, 0.000221918, 2.01522e-05>,
                         <-2.81782, 1.16647, 1.03821>, <-7.7084e-06, 0.000233176, 4.10305e-05> }
        smooth_triangle {<-2.81782, 1.16647, 1.03821>, <5.3071e-06, 0.000223979, 3.52095e-05>,
                         <-2.82284, 1.16952, 1.01701>, <3.96459e-06, 0.000203402, 2.22111e-05>,
                         <-2.83161, 1.17131, 1.01909>, <6.22395e-05, 0.000195878, 8.39819e-06> }
        smooth_triangle {<-2.82772, 1.16849, 1.04056>, <8.03747e-05, 0.000221918, 2.01522e-05>,
                         <-2.82439, 1.16442, 1.06193>, <9.58893e-05, 0.000256013, 3.66429e-05>,
                         <-2.81284, 1.16206, 1.05919>, <-5.72626e-06, 0.000268997, 6.07288e-05> }
        smooth_triangle {<-2.81284, 1.16206, 1.05919>, <8.91303e-06, 0.000256617, 5.39466e-05>,
                         <-2.81782, 1.16647, 1.03821>, <7.42642e-06, 0.000229751, 3.91729e-05>,
                         <-2.82772, 1.16849, 1.04056>, <7.34888e-05, 0.000221308, 2.35141e-05> }
        smooth_triangle {<-2.82439, 1.16442, 1.06193>, <9.58893e-05, 0.000256013, 3.66429e-05>,
                         <-2.8213, 1.15981, 1.08323>, <0.000111272, 0.000293657, 4.64031e-05>,
                         <-2.8079, 1.15707, 1.08005>, <-5.3029e-06, 0.000308642, 7.40347e-05> }
        smooth_triangle {<-2.8079, 1.15707, 1.08005>, <1.17433e-05, 0.000295077, 6.70009e-05>,
                         <-2.81284, 1.16206, 1.05919>, <1.14258e-05, 0.000265344, 5.70215e-05>,
                         <-2.82439, 1.16442, 1.06193>, <8.76375e-05, 0.000255606, 3.8957e-05> }
        smooth_triangle {<-2.8213, 1.15981, 1.08323>, <0.000111272, 0.000293657, 4.64031e-05>,
                         <-2.81814, 1.15537, 1.10455>, <0.000123735, 0.000329952, 4.46417e-05>,
                         <-2.80295, 1.15226, 1.10095>, <-7.28323e-06, 0.00034697, 7.56969e-05> }
        smooth_triangle {<-2.80295, 1.15226, 1.10095>, <1.26716e-05, 0.000334186, 6.94935e-05>,
                         <-2.8079, 1.15707, 1.08005>, <1.41569e-05, 0.000305439, 6.82469e-05>,
                         <-2.8213, 1.15981, 1.08323>, <0.000101588, 0.000294201, 4.75231e-05> }
        smooth_triangle {<-2.81814, 1.15537, 1.10455>, <0.000123735, 0.000329952, 4.46417e-05>,
                         <-2.81458, 1.15181, 1.12597>, <0.000129829, 0.000358185, 2.59721e-05>,
                         <-2.79795, 1.14841, 1.12203>, <-1.24597e-05, 0.000376971, 5.96989e-05> }
        smooth_triangle {<-2.79795, 1.14841, 1.12203>, <1.04889e-05, 0.000367303, 5.55094e-05>,
                         <-2.80295, 1.15226, 1.10095>, <1.43713e-05, 0.000344802, 6.75079e-05>,
                         <-2.81814, 1.15537, 1.10455>, <0.000112635, 0.000332039, 4.42165e-05> }
        smooth_triangle {<-2.81458, 1.15181, 1.12597>, <0.000129829, 0.000358185, 2.59721e-05>,
                         <-2.81024, 1.15004, 1.14746>, <0.000124766, 0.000366814, -1.4512e-05>,
                         <-2.7929, 1.1465, 1.14335>, <-2.10627e-05, 0.000386631, 2.00538e-05> }
        smooth_triangle {<-2.7929, 1.1465, 1.14335>, <4.20965e-06, 0.000383584, 1.87122e-05>,
                         <-2.79795, 1.14841, 1.12203>, <1.06619e-05, 0.000376339, 4.8446e-05>,
                         <-2.81458, 1.15181, 1.12597>, <0.000117379, 0.000362249, 2.31509e-05> }
        smooth_triangle {<-2.81024, 1.15004, 1.14746>, <0.000124766, 0.000366814, -1.4512e-05>,
                         <-2.80466, 1.15134, 1.16867>, <9.98144e-05, 0.000328556, -8.00852e-05>,
                         <-2.78784, 1.14791, 1.16469>, <-3.10905e-05, 0.000347782, -4.90568e-05> }
        smooth_triangle {<-2.78784, 1.14791, 1.16469>, <-5.8613e-06, 0.000358506, -4.73797e-05>,
                         <-2.7929, 1.1465, 1.14335>, <1.65958e-06, 0.000387643, 4.45323e-06>,
                         <-2.81024, 1.15004, 1.14746>, <0.000111031, 0.00037278, -2.14711e-05> }
        smooth_triangle {<-2.80466, 1.15134, 1.16867>, <9.98144e-05, 0.000328556, -8.00852e-05>,
                         <-2.79694, 1.15892, 1.1876>, <4.86621e-05, 0.000205033, -0.00013575>,
                         <-2.78318, 1.15611, 1.18434>, <-3.35114e-05, 0.000219528, -0.000116273> }
        smooth_triangle {<-2.78318, 1.15611, 1.18434>, <-1.64202e-05, 0.000251904, -0.000125699>,
                         <-2.78784, 1.14791, 1.16469>, <-1.46046e-05, 0.000348095, -7.52875e-05>,
                         <-2.80466, 1.15134, 1.16867>, <8.35741e-05, 0.000333676, -9.85588e-05> }
        smooth_triangle {<-2.79694, 1.15892, 1.1876>, <4.86621e-05, 0.000205033, -0.00013575>,
                         <-2.7875, 1.17549, 1.19769>, <3.14635e-06, 5.27168e-05, -8.2407e-05>,
                         <-2.78041, 1.17405, 1.19601>, <-1.81181e-05, 5.71489e-05, -7.73667e-05> }
        smooth_triangle {<-2.78041, 1.17405, 1.19601>, <-2.00025e-05, 8.52875e-05, -0.000121674>,
                         <-2.78318, 1.15611, 1.18434>, <-3.15474e-05, 0.000207071, -0.000150854>,
                         <-2.79694, 1.15892, 1.1876>, <3.00827e-05, 0.000196201, -0.000165462> }
        smooth_triangle {<-2.7875, 1.17549, 1.19769>, <3.14635e-06, 5.27168e-05, -8.2407e-05>,
                         <-2.77868, 1.19559, 1.19878>, <4.03387e-06, -2.98426e-06, 2.2378e-05>,
                         <-2.7797, 1.19579, 1.19902>, <5.23667e-06, -3.23014e-06, 2.20929e-05> }
        smooth_triangle {<-2.7797, 1.19579, 1.19902>, <-7.22475e-06, 5.35257e-06, -3.69538e-05>,
                         <-2.78041, 1.17405, 1.19601>, <-2.16255e-05, 4.84912e-05, -9.67869e-05>,
                         <-2.7875, 1.17549, 1.19769>, <-5.67713e-06, 4.51671e-05, -0.000100567> }
        smooth_triangle {<-2.86621, 1.17977, 0.891698>, <8.967e-05, 0.000136923, -1.83729e-05>,
                         <-2.86139, 1.1795, 0.913172>, <0.000105086, 0.000122781, -2.1903e-05>,
                         <-2.85534, 1.17535, 0.911737>, <5.14187e-05, 0.000154499, -9.18222e-06> }
        smooth_triangle {<-2.85534, 1.17535, 0.911737>, <6.0535e-05, 0.000149423, -1.13884e-05>,
                         <-2.86027, 1.1757, 0.890291>, <5.9896e-05, 0.000147854, -1.13443e-05>,
                         <-2.86621, 1.17977, 0.891698>, <8.8777e-05, 0.00013556, -1.819e-05> }
        smooth_triangle {<-2.86139, 1.1795, 0.913172>, <0.000105086, 0.000122781, -2.1903e-05>,
                         <-2.85661, 1.17921, 0.934653>, <0.000107612, 0.000125662, -2.19962e-05>,
                         <-2.85042, 1.17496, 0.933186>, <5.26887e-05, 0.000158109, -8.9777e-06> }
        smooth_triangle {<-2.85042, 1.17496, 0.933186>, <6.19502e-05, 0.000152811, -1.12548e-05>,
                         <-2.85534, 1.17535, 0.911737>, <6.09978e-05, 0.000150104, -1.14082e-05>,
                         <-2.86139, 1.1795, 0.913172>, <0.000101248, 0.000126316, -2.09488e-05> }
        smooth_triangle {<-2.85661, 1.17921, 0.934653>, <0.000107612, 0.000125662, -2.19962e-05>,
                         <-2.85188, 1.17885, 0.956146>, <0.000110839, 0.000129273, -2.17463e-05>,
                         <-2.84554, 1.17449, 0.954641>, <5.43418e-05, 0.000162625, -8.35494e-06> }
        smooth_triangle {<-2.84554, 1.17449, 0.954641>, <6.37194e-05, 0.000156949, -1.07281e-05>,
                         <-2.85042, 1.17496, 0.933186>, <6.24796e-05, 0.000153561, -1.11952e-05>,
                         <-2.85661, 1.17921, 0.934653>, <0.000103672, 0.000129226, -2.0959e-05> }
        smooth_triangle {<-2.85188, 1.17885, 0.956146>, <0.000110839, 0.000129273, -2.17463e-05>,
                         <-2.84728, 1.17837, 0.977662>, <0.000115438, 0.000134316, -2.07855e-05>,
                         <-2.84071, 1.17386, 0.976107>, <5.67484e-05, 0.000168912, -6.87429e-06> }
        smooth_triangle {<-2.84071, 1.17386, 0.976107>, <6.61899e-05, 0.000162565, -9.4201e-06>,
                         <-2.84554, 1.17449, 0.954641>, <6.43849e-05, 0.00015785, -1.05306e-05>,
                         <-2.85188, 1.17885, 0.956146>, <0.000106757, 0.000132836, -2.05741e-05> }
        smooth_triangle {<-2.84728, 1.17837, 0.977662>, <0.000115438, 0.000134316, -2.07855e-05>,
                         <-2.8429, 1.17765, 0.99922>, <0.000122958, 0.00014232, -1.79539e-05>,
                         <-2.83602, 1.17293, 0.997588>, <6.07942e-05, 0.000178857, -3.21926e-06> }
        smooth_triangle {<-2.83602, 1.17293, 0.997588>, <7.0158e-05, 0.000171207, -6.16709e-06>,
                         <-2.84071, 1.17386, 0.976107>, <6.71237e-05, 0.000163748, -8.90836e-06>,
                         <-2.84728, 1.17837, 0.977662>, <0.000111141, 0.000137801, -1.93417e-05> }
        smooth_triangle {<-2.8429, 1.17765, 0.99922>, <0.000122958, 0.00014232, -1.79539e-05>,
                         <-2.83905, 1.17641, 1.02085>, <0.000136251, 0.00015588, -1.08478e-05>,
                         <-2.83161, 1.17131, 1.01909>, <6.82015e-05, 0.000195707, 5.28202e-06> }
        smooth_triangle {<-2.83161, 1.17131, 1.01909>, <7.72093e-05, 0.000185565, 1.53643e-06>,
                         <-2.83602, 1.17293, 0.997588>, <7.16539e-05, 0.000172927, -4.83953e-06>,
                         <-2.8429, 1.17765, 0.99922>, <0.000118277, 0.000145525, -1.58905e-05> }
        smooth_triangle {<-2.83905, 1.17641, 1.02085>, <0.000136251, 0.00015588, -1.08478e-05>,
                         <-2.83612, 1.17426, 1.04255>, <0.000157561, 0.000176875, 1.85676e-06>,
                         <-2.82772, 1.16849, 1.04056>, <8.03747e-05, 0.000221918, 2.01522e-05> }
        smooth_triangle {<-2.82772, 1.16849, 1.04056>, <8.89283e-05, 0.000208061, 1.53888e-05>,
                         <-2.83161, 1.17131, 1.01909>, <7.97983e-05, 0.000188403, 4.23623e-06>,
                         <-2.83905, 1.17641, 1.02085>, <0.000130836, 0.000158533, -7.8611e-06> }
        smooth_triangle {<-2.83612, 1.17426, 1.04255>, <0.000157561, 0.000176875, 1.85676e-06>,
                         <-2.83418, 1.17114, 1.06425>, <0.000184935, 0.000204054, 1.55364e-05>,
                         <-2.82439, 1.16442, 1.06193>, <9.58893e-05, 0.000256013, 3.66429e-05> }
        smooth_triangle {<-2.82439, 1.16442, 1.06193>, <0.000104748, 0.000238526, 3.12309e-05>,
                         <-2.82772, 1.16849, 1.04056>, <9.31118e-05, 0.000212954, 1.88629e-05>,
                         <-2.83612, 1.17426, 1.04255>, <0.000151002, 0.000179172, 5.14131e-06> }
        smooth_triangle {<-2.83418, 1.17114, 1.06425>, <0.000184935, 0.000204054, 1.55364e-05>,
                         <-2.83267, 1.16761, 1.08592>, <0.000213393, 0.000233965, 2.21974e-05>,
                         <-2.8213, 1.15981, 1.08323>, <0.000111272, 0.000293657, 4.64031e-05> }
        smooth_triangle {<-2.8213, 1.15981, 1.08323>, <0.000121918, 0.000274157, 4.08861e-05>,
                         <-2.82439, 1.16442, 1.06193>, <0.000110381, 0.000245924, 3.3566e-05>,
                         <-2.83418, 1.17114, 1.06425>, <0.000177166, 0.000206954, 1.77362e-05> }
        smooth_triangle {<-2.83267, 1.16761, 1.08592>, <0.000213393, 0.000233965, 2.21974e-05>,
                         <-2.83102, 1.16421, 1.10761>, <0.000238442, 0.000262701, 1.74526e-05>,
                         <-2.81814, 1.15537, 1.10455>, <0.000123735, 0.000329952, 4.46417e-05> }
        smooth_triangle {<-2.81814, 1.15537, 1.10455>, <0.000137385, 0.000310162, 3.99327e-05>,
                         <-2.8213, 1.15981, 1.08323>, <0.000128038, 0.000282941, 4.12537e-05>,
                         <-2.83267, 1.16761, 1.08592>, <0.000204629, 0.000238173, 2.30995e-05> }
        smooth_triangle {<-2.83102, 1.16421, 1.10761>, <0.000238442, 0.000262701, 1.74526e-05>,
                         <-2.82867, 1.16149, 1.12931>, <0.000254292, 0.000284868, -3.52914e-06>,
                         <-2.81458, 1.15181, 1.12597>, <0.000129829, 0.000358185, 2.59721e-05> }
        smooth_triangle {<-2.81458, 1.15181, 1.12597>, <0.000147452, 0.000340337, 2.3045e-05>,
                         <-2.81814, 1.15537, 1.10455>, <0.000142881, 0.000319163, 3.70472e-05>,
                         <-2.83102, 1.16421, 1.10761>, <0.000228912, 0.000268725, 1.66553e-05> }
        smooth_triangle {<-2.82867, 1.16149, 1.12931>, <0.000254292, 0.000284868, -3.52914e-06>,
                         <-2.82494, 1.16014, 1.15095>, <0.000252115, 0.000291152, -4.46974e-05>,
                         <-2.81024, 1.15004, 1.14746>, <0.000124766, 0.000366814, -1.4512e-05> }
        smooth_triangle {<-2.81024, 1.15004, 1.14746>, <0.00014706, 0.00035447, -1.51475e-05>,
                         <-2.81458, 1.15181, 1.12597>, <0.000150857, 0.000347998, 1.52156e-05>,
                         <-2.82867, 1.16149, 1.12931>, <0.000244204, 0.00029301, -6.9104e-06> }
        smooth_triangle {<-2.82494, 1.16014, 1.15095>, <0.000252115, 0.000291152, -4.46974e-05>,
                         <-2.81891, 1.16113, 1.17205>, <0.000213596, 0.00025931, -0.000107055>,
                         <-2.80466, 1.15134, 1.16867>, <9.98144e-05, 0.000328556, -8.00852e-05> }
        smooth_triangle {<-2.80466, 1.15134, 1.16867>, <0.000127247, 0.000329217, -7.89304e-05>,
                         <-2.81024, 1.15004, 1.14746>, <0.000145961, 0.000357911, -2.97505e-05>,
                         <-2.82494, 1.16014, 1.15095>, <0.000241473, 0.000301164, -5.23896e-05> }
        smooth_triangle {<-2.81891, 1.16113, 1.17205>, <0.000213596, 0.00025931, -0.000107055>,
                         <-2.80861, 1.16693, 1.19036>, <0.000119183, 0.000159324, -0.000152466>,
                         <-2.79694, 1.15892, 1.1876>, <4.86621e-05, 0.000205033, -0.00013575> }
        smooth_triangle {<-2.79694, 1.15892, 1.1876>, <7.64165e-05, 0.000227749, -0.000147704>,
                         <-2.80466, 1.15134, 1.16867>, <0.000114781, 0.000320391, -0.000105956>,
                         <-2.81891, 1.16113, 1.17205>, <0.000200117, 0.000268457, -0.000126183> }
        smooth_triangle {<-2.80861, 1.16693, 1.19036>, <0.000119183, 0.000159324, -0.000152466>,
                         <-2.7935, 1.17962, 1.19912>, <2.11418e-05, 4.02589e-05, -8.66725e-05>,
                         <-2.7875, 1.17549, 1.19769>, <3.14635e-06, 5.27168e-05, -8.2407e-05> }
        smooth_triangle {<-2.7875, 1.17549, 1.19769>, <1.11187e-05, 7.55044e-05, -0.000129051>,
                         <-2.79694, 1.15892, 1.1876>, <4.52556e-05, 0.000189742, -0.000169058>,
                         <-2.80861, 1.16693, 1.19036>, <9.81465e-05, 0.00015546, -0.000181595> }
        smooth_triangle {<-2.7935, 1.17962, 1.19912>, <2.11418e-05, 4.02589e-05, -8.66725e-05>,
                         <-2.77782, 1.19499, 1.19858>, <3.01419e-06, -2.28405e-06, 2.26197e-05>,
                         <-2.77868, 1.19559, 1.19878>, <4.03387e-06, -2.98426e-06, 2.2378e-05> }
        smooth_triangle {<-2.77868, 1.19559, 1.19878>, <-5.34222e-06, 4.37377e-06, -3.74e-05>,
                         <-2.7875, 1.17549, 1.19769>, <-3.66383e-06, 4.431e-05, -0.000101044>,
                         <-2.7935, 1.17962, 1.19912>, <9.83273e-06, 3.49667e-05, -0.000104243> }
        smooth_triangle {<-2.87017, 1.18587, 0.892637>, <0.000133879, 9.14889e-05, -2.88518e-05>,
                         <-2.86544, 1.18573, 0.914131>, <0.000142858, 7.23714e-05, -3.0856e-05>,
                         <-2.86139, 1.1795, 0.913172>, <0.000105086, 0.000122781, -2.1903e-05> }
        smooth_triangle {<-2.86139, 1.1795, 0.913172>, <0.000111618, 0.000114503, -2.34965e-05>,
                         <-2.86621, 1.17977, 0.891698>, <0.000110441, 0.000113295, -2.3325e-05>,
                         <-2.87017, 1.18587, 0.892637>, <0.000132546, 9.05777e-05, -2.85644e-05> }
        smooth_triangle {<-2.86544, 1.18573, 0.914131>, <0.000142858, 7.23714e-05, -3.0856e-05>,
                         <-2.86074, 1.18556, 0.935633>, <0.000146273, 7.40835e-05, -3.11599e-05>,
                         <-2.85661, 1.17921, 0.934653>, <0.000107612, 0.000125662, -2.19962e-05> }
        smooth_triangle {<-2.85661, 1.17921, 0.934653>, <0.000114195, 0.000117118, -2.36384e-05>,
                         <-2.86139, 1.1795, 0.913172>, <0.0001123, 0.000114957, -2.35684e-05>,
                         <-2.86544, 1.18573, 0.914131>, <0.000140629, 7.715e-05, -3.02832e-05> }
        smooth_triangle {<-2.86074, 1.18556, 0.935633>, <0.000146273, 7.40835e-05, -3.11599e-05>,
                         <-2.85613, 1.18537, 0.957152>, <0.000150616, 7.62411e-05, -3.11747e-05>,
                         <-2.85188, 1.17885, 0.956146>, <0.000110839, 0.000129273, -2.17463e-05> }
        smooth_triangle {<-2.85188, 1.17885, 0.956146>, <0.000117386, 0.000120328, -2.34487e-05>,
                         <-2.85661, 1.17921, 0.934653>, <0.000114966, 0.000117619, -2.36361e-05>,
                         <-2.86074, 1.18556, 0.935633>, <0.000143962, 7.89354e-05, -3.05089e-05> }
        smooth_triangle {<-2.85613, 1.18537, 0.957152>, <0.000150616, 7.62411e-05, -3.11747e-05>,
                         <-2.85166, 1.18511, 0.978701>, <0.000156778, 7.92721e-05, -3.05842e-05>,
                         <-2.84728, 1.17837, 0.977662>, <0.000115438, 0.000134316, -2.07855e-05> }
        smooth_triangle {<-2.84728, 1.17837, 0.977662>, <0.000121792, 0.000124712, -2.25995e-05>,
                         <-2.85188, 1.17885, 0.956146>, <0.000118343, 0.00012093, -2.33201e-05>,
                         <-2.85613, 1.18537, 0.957152>, <0.000148175, 8.11557e-05, -3.03914e-05> }
        smooth_triangle {<-2.85166, 1.18511, 0.978701>, <0.000156778, 7.92721e-05, -3.05842e-05>,
                         <-2.8475, 1.18472, 1.00031>, <0.000166785, 8.41168e-05, -2.83421e-05>,
                         <-2.8429, 1.17765, 0.99922>, <0.000122958, 0.00014232, -1.79539e-05> }
        smooth_triangle {<-2.8429, 1.17765, 0.99922>, <0.000128748, 0.000131506, -2.00546e-05>,
                         <-2.84728, 1.17837, 0.977662>, <0.000123108, 0.000125503, -2.21783e-05>,
                         <-2.85166, 1.18511, 0.978701>, <0.000154113, 8.42196e-05, -2.95274e-05> }
        smooth_triangle {<-2.8475, 1.18472, 1.00031>, <0.000166785, 8.41168e-05, -2.83421e-05>,
                         <-2.84401, 1.18405, 1.02203>, <0.000184291, 9.23219e-05, -2.22345e-05>,
                         <-2.83905, 1.17641, 1.02085>, <0.000136251, 0.00015588, -1.08478e-05> }
        smooth_triangle {<-2.83905, 1.17641, 1.02085>, <0.000140769, 0.000142825, -1.35291e-05>,
                         <-2.8429, 1.17765, 0.99922>, <0.000130799, 0.000132655, -1.88587e-05>,
                         <-2.8475, 1.18472, 1.00031>, <0.000163669, 8.90024e-05, -2.66499e-05> }
        smooth_triangle {<-2.84401, 1.18405, 1.02203>, <0.000184291, 9.23219e-05, -2.22345e-05>,
                         <-2.84173, 1.18289, 1.04388>, <0.000212099, 0.000104905, -1.10705e-05>,
                         <-2.83612, 1.17426, 1.04255>, <0.000157561, 0.000176875, 1.85676e-06> }
        smooth_triangle {<-2.83612, 1.17426, 1.04255>, <0.000160257, 0.000160468, -1.51814e-06>,
                         <-2.83905, 1.17641, 1.02085>, <0.000144275, 0.000144722, -1.10465e-05>,
                         <-2.84401, 1.18405, 1.02203>, <0.000180304, 9.70528e-05, -1.95866e-05> }
        smooth_triangle {<-2.84173, 1.18289, 1.04388>, <0.000212099, 0.000104905, -1.10705e-05>,
                         <-2.84072, 1.1812, 1.0658>, <0.000247855, 0.000121029, 6.22625e-07>,
                         <-2.83418, 1.17114, 1.06425>, <0.000184935, 0.000204054, 1.55364e-05> }
        smooth_triangle {<-2.83418, 1.17114, 1.06425>, <0.000186551, 0.000184121, 1.18412e-05>,
                         <-2.83612, 1.17426, 1.04255>, <0.00016602, 0.000163737, 1.58141e-06>,
                         <-2.84173, 1.18289, 1.04388>, <0.000206924, 0.00010976, -8.114e-06> }
        smooth_triangle {<-2.84072, 1.1812, 1.0658>, <0.000247855, 0.000121029, 6.22625e-07>,
                         <-2.84026, 1.17929, 1.08772>, <0.000285513, 0.000138655, 5.10269e-06>,
                         <-2.83267, 1.16761, 1.08592>, <0.000213393, 0.000233965, 2.21974e-05> }
        smooth_triangle {<-2.83267, 1.16761, 1.08592>, <0.000215917, 0.000211498, 1.86058e-05>,
                         <-2.83418, 1.17114, 1.06425>, <0.000194573, 0.000189064, 1.36101e-05>,
                         <-2.84072, 1.1812, 1.0658>, <0.000241763, 0.000126796, 2.42474e-06> }
        smooth_triangle {<-2.84026, 1.17929, 1.08772>, <0.000285513, 0.000138655, 5.10269e-06>,
                         <-2.83963, 1.17745, 1.10965>, <0.000319377, 0.000155457, -1.7312e-06>,
                         <-2.83102, 1.16421, 1.10761>, <0.000238442, 0.000262701, 1.74526e-05> }
        smooth_triangle {<-2.83102, 1.16421, 1.10761>, <0.00024366, 0.00023892, 1.47425e-05>,
                         <-2.83267, 1.16761, 1.08592>, <0.000224872, 0.000217368, 1.83011e-05>,
                         <-2.84026, 1.17929, 1.08772>, <0.000278963, 0.000145885, 5.48009e-06> }
        smooth_triangle {<-2.83963, 1.17745, 1.10965>, <0.000319377, 0.000155457, -1.7312e-06>,
                         <-2.83809, 1.17598, 1.13155>, <0.00034198, 0.000168182, -2.43137e-05>,
                         <-2.82867, 1.16149, 1.12931>, <0.000254292, 0.000284868, -3.52914e-06> }
        smooth_triangle {<-2.82867, 1.16149, 1.12931>, <0.000263949, 0.000261559, -4.56817e-06>,
                         <-2.83102, 1.16421, 1.10761>, <0.000252062, 0.000244934, 1.11681e-05>,
                         <-2.83963, 1.17745, 1.10965>, <0.000312763, 0.0001645, -3.21971e-06> }
        smooth_triangle {<-2.83809, 1.17598, 1.13155>, <0.00034198, 0.000168182, -2.43137e-05>,
                         <-2.83476, 1.17524, 1.15328>, <0.000341596, 0.000171165, -6.59071e-05>,
                         <-2.82494, 1.16014, 1.15095>, <0.000252115, 0.000291152, -4.46974e-05> }
        smooth_triangle {<-2.82494, 1.16014, 1.15095>, <0.000268195, 0.00027139, -4.38601e-05>,
                         <-2.82867, 1.16149, 1.12931>, <0.000269827, 0.000266677, -1.29839e-05>,
                         <-2.83809, 1.17598, 1.13155>, <0.000335593, 0.000179163, -2.85723e-05> }
        smooth_triangle {<-2.83476, 1.17524, 1.15328>, <0.000341596, 0.000171165, -6.59071e-05>,
                         <-2.82844, 1.17578, 1.17431>, <0.000292931, 0.000150587, -0.000125859>,
                         <-2.81891, 1.16113, 1.17205>, <0.000213596, 0.00025931, -0.000107055> }
        smooth_triangle {<-2.81891, 1.16113, 1.17205>, <0.000239317, 0.000249808, -0.000105494>,
                         <-2.82494, 1.16014, 1.15095>, <0.000268207, 0.000273689, -5.87264e-05>,
                         <-2.83476, 1.17524, 1.15328>, <0.000335318, 0.000183699, -7.46337e-05> }
        smooth_triangle {<-2.82844, 1.17578, 1.17431>, <0.000292931, 0.000150587, -0.000125859>,
                         <-2.8164, 1.17892, 1.19221>, <0.000167316, 8.93596e-05, -0.000163875>,
                         <-2.80861, 1.16693, 1.19036>, <0.000119183, 0.000159324, -0.000152466> }
        smooth_triangle {<-2.80861, 1.16693, 1.19036>, <0.000153192, 0.000168921, -0.000165902>,
                         <-2.81891, 1.16113, 1.17205>, <0.000224001, 0.000243911, -0.000131844>,
                         <-2.82844, 1.17578, 1.17431>, <0.000283503, 0.000162368, -0.000145948> }
        smooth_triangle {<-2.8164, 1.17892, 1.19221>, <0.000167316, 8.93596e-05, -0.000163875>,
                         <-2.79751, 1.18579, 1.20007>, <3.31285e-05, 2.16721e-05, -8.95137e-05>,
                         <-2.7935, 1.17962, 1.19912>, <2.11418e-05, 4.02589e-05, -8.66725e-05> }
        smooth_triangle {<-2.7935, 1.17962, 1.19912>, <3.62281e-05, 5.42265e-05, -0.000135003>,
                         <-2.80861, 1.16693, 1.19036>, <0.000109759, 0.000143525, -0.000184348>,
                         <-2.8164, 1.17892, 1.19221>, <0.000145859, 9.1052e-05, -0.000192904> }
        smooth_triangle {<-2.79751, 1.18579, 1.20007>, <3.31285e-05, 2.16721e-05, -8.95137e-05>,
                         <-2.77725, 1.19411, 1.19844>, <2.33286e-06, -1.23612e-06, 2.27812e-05>,
                         <-2.77782, 1.19499, 1.19858>, <3.01419e-06, -2.28405e-06, 2.26197e-05> }
        smooth_triangle {<-2.77782, 1.19499, 1.19858>, <-3.96745e-06, 2.7291e-06, -3.77259e-05>,
                         <-2.7935, 1.17962, 1.19912>, <1.13736e-05, 3.33831e-05, -0.000104609>,
                         <-2.79751, 1.18579, 1.20007>, <2.03637e-05, 1.94429e-05, -0.00010674> }
        smooth_triangle {<-2.87156, 1.19307, 0.892967>, <0.000157805, 3.21262e-05, -3.45228e-05>,
                         <-2.86686, 1.19307, 0.914468>, <0.000158983, 1.09436e-05, -3.46782e-05>,
                         <-2.86544, 1.18573, 0.914131>, <0.000142858, 7.23714e-05, -3.0856e-05> }
        smooth_triangle {<-2.86544, 1.18573, 0.914131>, <0.000145809, 6.21501e-05, -3.16008e-05>,
                         <-2.87017, 1.18587, 0.892637>, <0.00014427, 6.14876e-05, -3.13435e-05>,
                         <-2.87156, 1.19307, 0.892967>, <0.000156233, 3.18062e-05, -3.4179e-05> }
        smooth_triangle {<-2.86686, 1.19307, 0.914468>, <0.000158983, 1.09436e-05, -3.46782e-05>,
                         <-2.86219, 1.19307, 0.935977>, <0.000162785, 1.12269e-05, -3.50737e-05>,
                         <-2.86074, 1.18556, 0.935633>, <0.000146273, 7.40835e-05, -3.11599e-05> }
        smooth_triangle {<-2.86074, 1.18556, 0.935633>, <0.000149171, 6.35939e-05, -3.19288e-05>,
                         <-2.86544, 1.18573, 0.914131>, <0.00014661, 6.23098e-05, -3.17009e-05>,
                         <-2.86686, 1.19307, 0.914468>, <0.000158704, 1.6239e-05, -3.45676e-05> }
        smooth_triangle {<-2.86219, 1.19307, 0.935977>, <0.000162785, 1.12269e-05, -3.50737e-05>,
                         <-2.85762, 1.19307, 0.957505>, <0.000167618, 1.16019e-05, -3.52047e-05>,
                         <-2.85613, 1.18537, 0.957152>, <0.000150616, 7.62411e-05, -3.11747e-05> }
        smooth_triangle {<-2.85613, 1.18537, 0.957152>, <0.000153331, 6.53882e-05, -3.19688e-05>,
                         <-2.86074, 1.18556, 0.935633>, <0.000150074, 6.37699e-05, -3.19576e-05>,
                         <-2.86219, 1.19307, 0.935977>, <0.000162458, 1.66275e-05, -3.4893e-05> }
        smooth_triangle {<-2.85762, 1.19307, 0.957505>, <0.000167618, 1.16019e-05, -3.52047e-05>,
                         <-2.8532, 1.19307, 0.979066>, <0.000174475, 1.21597e-05, -3.47788e-05>,
                         <-2.85166, 1.18511, 0.978701>, <0.000156778, 7.92721e-05, -3.05842e-05> }
        smooth_triangle {<-2.85166, 1.18511, 0.978701>, <0.000159067, 6.78728e-05, -3.14347e-05>,
                         <-2.85613, 1.18537, 0.957152>, <0.000154445, 6.55996e-05, -3.18775e-05>,
                         <-2.85762, 1.19307, 0.957505>, <0.000167197, 1.71202e-05, -3.49e-05> }
        smooth_triangle {<-2.8532, 1.19307, 0.979066>, <0.000174475, 1.21597e-05, -3.47788e-05>,
                         <-2.84911, 1.19307, 1.00069>, <0.000185602, 1.31073e-05, -3.28025e-05>,
                         <-2.8475, 1.18472, 1.00031>, <0.000166785, 8.41168e-05, -2.83421e-05> }
        smooth_triangle {<-2.8475, 1.18472, 1.00031>, <0.000168095, 7.1784e-05, -2.93809e-05>,
                         <-2.85166, 1.18511, 0.978701>, <0.000160589, 6.81505e-05, -3.10625e-05>,
                         <-2.8532, 1.19307, 0.979066>, <0.000173862, 1.78162e-05, -3.42084e-05> }
        smooth_triangle {<-2.84911, 1.19307, 1.00069>, <0.000185602, 1.31073e-05, -3.28025e-05>,
                         <-2.84576, 1.19307, 1.02244>, <0.000205006, 1.47083e-05, -2.71447e-05>,
                         <-2.84401, 1.18405, 1.02203>, <0.000184291, 9.23219e-05, -2.22345e-05> }
        smooth_triangle {<-2.84401, 1.18405, 1.02203>, <0.000183576, 7.83414e-05, -2.36755e-05>,
                         <-2.8475, 1.18472, 1.00031>, <0.000170446, 7.21876e-05, -2.82562e-05>,
                         <-2.84911, 1.19307, 1.00069>, <0.00018456, 1.89305e-05, -3.16015e-05> }
        smooth_triangle {<-2.84576, 1.19307, 1.02244>, <0.000205006, 1.47083e-05, -2.71447e-05>,
                         <-2.8437, 1.19307, 1.04435>, <0.000235687, 1.69638e-05, -1.66614e-05>,
                         <-2.84173, 1.18289, 1.04388>, <0.000212099, 0.000104905, -1.10705e-05> }
        smooth_triangle {<-2.84173, 1.18289, 1.04388>, <0.000208434, 8.84447e-05, -1.29375e-05>,
                         <-2.84401, 1.18405, 1.02203>, <0.000187577, 7.90074e-05, -2.13105e-05>,
                         <-2.84576, 1.19307, 1.02244>, <0.000203114, 2.07972e-05, -2.49932e-05> }
        smooth_triangle {<-2.8437, 1.19307, 1.04435>, <0.000235687, 1.69638e-05, -1.66614e-05>,
                         <-2.84302, 1.19307, 1.06635>, <0.000275069, 1.95783e-05, -5.82798e-06>,
                         <-2.84072, 1.1812, 1.0658>, <0.000247855, 0.000121029, 6.22625e-07> }
        smooth_triangle {<-2.84072, 1.1812, 1.0658>, <0.000241869, 0.000101686, -1.27079e-06>,
                         <-2.84173, 1.18289, 1.04388>, <0.000215052, 8.95928e-05, -1.00406e-05>,
                         <-2.8437, 1.19307, 1.04435>, <0.000232743, 2.3637e-05, -1.42338e-05> }
        smooth_triangle {<-2.84302, 1.19307, 1.06635>, <0.000275069, 1.95783e-05, -5.82798e-06>,
                         <-2.84292, 1.19307, 1.08836>, <0.000316653, 2.22353e-05, -2.27843e-06>,
                         <-2.84026, 1.17929, 1.08772>, <0.000285513, 0.000138655, 5.10269e-06> }
        smooth_triangle {<-2.84026, 1.17929, 1.08772>, <0.000279428, 0.000116641, 3.55177e-06>,
                         <-2.84072, 1.1812, 1.0658>, <0.000251184, 0.000103422, 1.91724e-07>,
                         <-2.84302, 1.19307, 1.06635>, <0.000271595, 2.73337e-05, -4.64623e-06> }
        smooth_triangle {<-2.84292, 1.19307, 1.08836>, <0.000316653, 2.22353e-05, -2.27843e-06>,
                         <-2.84265, 1.19307, 1.11036>, <0.000354216, 2.45456e-05, -9.98913e-06>,
                         <-2.83963, 1.17745, 1.10965>, <0.000319377, 0.000155457, -1.7312e-06> }
        smooth_triangle {<-2.83963, 1.17745, 1.10965>, <0.000315316, 0.000131304, -2.24219e-06>,
                         <-2.84026, 1.17929, 1.08772>, <0.000289919, 0.000118702, 2.88323e-06>,
                         <-2.84292, 1.19307, 1.08836>, <0.000313274, 3.13876e-05, -2.65261e-06> }
        smooth_triangle {<-2.84265, 1.19307, 1.11036>, <0.000354216, 2.45456e-05, -9.98913e-06>,
                         <-2.8414, 1.19307, 1.13233>, <0.000379543, 2.58927e-05, -3.32172e-05>,
                         <-2.83809, 1.17598, 1.13155>, <0.00034198, 0.000168182, -2.43137e-05> }
        smooth_triangle {<-2.83809, 1.17598, 1.13155>, <0.000342243, 0.00014296, -2.31262e-05>,
                         <-2.83963, 1.17745, 1.10965>, <0.000325291, 0.000133416, -6.18934e-06>,
                         <-2.84265, 1.19307, 1.11036>, <0.000351421, 3.52321e-05, -1.23828e-05> }
        smooth_triangle {<-2.8414, 1.19307, 1.13233>, <0.000379543, 2.58927e-05, -3.32172e-05>,
                         <-2.83821, 1.19307, 1.15409>, <0.000379587, 2.512e-05, -7.4912e-05>,
                         <-2.83476, 1.17524, 1.15328>, <0.000341596, 0.000171165, -6.59071e-05> }
        smooth_triangle {<-2.83476, 1.17524, 1.15328>, <0.000349173, 0.000146994, -6.30542e-05>,
                         <-2.83809, 1.17598, 1.13155>, <0.00034946, 0.000144757, -3.18592e-05>,
                         <-2.8414, 1.19307, 1.13233>, <0.000377632, 3.80398e-05, -3.85368e-05> }
        smooth_triangle {<-2.83821, 1.19307, 1.15409>, <0.000379587, 2.512e-05, -7.4912e-05>,
                         <-2.83178, 1.19307, 1.1751>, <0.000325742, 1.89379e-05, -0.000133637>,
                         <-2.82844, 1.17578, 1.17431>, <0.000292931, 0.000150587, -0.000125859> }
        smooth_triangle {<-2.82844, 1.17578, 1.17431>, <0.000313287, 0.000132368, -0.000123027>,
                         <-2.83476, 1.17524, 1.15328>, <0.000349786, 0.000147802, -7.80631e-05>,
                         <-2.83821, 1.19307, 1.15409>, <0.00037828, 3.82677e-05, -8.48168e-05> }
        smooth_triangle {<-2.83178, 1.19307, 1.1751>, <0.000325742, 1.89379e-05, -0.000133637>,
                         <-2.81914, 1.19307, 1.19286>, <0.000185732, 5.79086e-06, -0.00016824>,
                         <-2.8164, 1.17892, 1.19221>, <0.000167316, 8.93596e-05, -0.000163875> }
        smooth_triangle {<-2.8164, 1.17892, 1.19221>, <0.000202218, 8.43765e-05, -0.000177523>,
                         <-2.82844, 1.17578, 1.17431>, <0.000296429, 0.000130297, -0.000149012>,
                         <-2.83178, 1.19307, 1.1751>, <0.000321037, 3.15602e-05, -0.000154845> }
        smooth_triangle {<-2.81914, 1.19307, 1.19286>, <0.000185732, 5.79086e-06, -0.00016824>,
                         <-2.79892, 1.19307, 1.2004>, <3.72817e-05, -2.1419e-07, -9.04981e-05>,
                         <-2.79751, 1.18579, 1.20007>, <3.31285e-05, 2.16721e-05, -8.95137e-05> }
        smooth_triangle {<-2.79751, 1.18579, 1.20007>, <5.1503e-05, 2.4693e-05, -0.000138623>,
                         <-2.8164, 1.17892, 1.19221>, <0.000152144, 7.54587e-05, -0.000194394>,
                         <-2.81914, 1.19307, 1.19286>, <0.000165956, 1.27821e-05, -0.000197668> }
        smooth_triangle {<-2.79892, 1.19307, 1.2004>, <3.72817e-05, -2.1419e-07, -9.04981e-05>,
                         <-2.77705, 1.19307, 1.1984>, <2.09361e-06, 7.52075e-12, 2.28379e-05>,
                         <-2.77725, 1.19411, 1.19844>, <2.33286e-06, -1.23612e-06, 2.27812e-05> }
        smooth_triangle {<-2.77725, 1.19411, 1.19844>, <-3.30976e-06, 6.68947e-07, -3.78818e-05>,
                         <-2.79751, 1.18579, 1.20007>, <2.11976e-05, 1.73738e-05, -0.000106937>,
                         <-2.79892, 1.19307, 1.2004>, <2.43125e-05, 9.59126e-07, -0.000107676> }
        texture { DMFWood4 }
    }
}

union {  // Layer name: tools
}

union {  // Layer name: flag
    height_field { gif "amhf1.gif"  water_level 0 smooth 
        texture { America_flad_fade }
        scale <2, 0.5, 3>
        translate <-2, 0.697927, -3>
        no_shadow
    }
}

union {  // Layer name: land
    plane { y, 0.0 
        texture { bigsky }
        scale <3000, 3000, 3000>
        translate <2.5, 1158, -0.5>
        no_shadow
    }
    light_source {  <-27.0812, 1061, -122>
        color rgb<1, 1, 1>
    
        area_light <-5, 7.13364, 7.00794>, <10, 3.56682, 3.50397>, 4, 4  adaptive 1   jitter
    }
    plane { y, 0.0 
        texture { Grass }
        scale <6, 6, 6>
    }
    height_field { gif "amland1.gif"  water_level 2.122e-314 smooth 
        texture { Lighttan_dirt }
        scale <10, 2, 10>
        translate <-5, 0, -5>
    }
}