

#declare radius_delta = radius_end - radius_start
#declare ang_delta =  turns * 2.0 * pi / density

#declare Spring = union
   {
   #declare ang = 0
   #while ( ang <= (2.0 * turns * pi ) )
      #declare radius1 = radius_start + radius_delta*ang / (turns*2.0*pi)
      #declare radius2 = radius_start + radius_delta*(ang+ang_delta) / (turns*2.0*pi)
      #declare x1 = radius1 * cos( ang )
      #declare x2 = radius2 * cos( ang + ang_delta )
      #declare y1 = radius1 * sin( ang )
      #declare y2 = radius2 * sin( ang + ang_delta )
      smooth_triangle { < x1, y1, 1.0 > < -x1, -y1, 0.0 >
                        < x1, y1, 0.0 > < -x1, -y1, 0.0 >
                        < x2, y2, 1.0 > < -x2, -y2, 0.0 > }
      smooth_triangle { < x2, y2, 1.0 > < -x2, -y2, 0.0 >
                        < x2, y2, 0.0 > < -x2, -y2, 0.0 >
                        < x1, y1, 0.0 > < -x1, -y1, 0.0 > }
   #declare ang = ang + ang_delta
   #end
   }
