
#declare SC1    =  5
#declare SC3    =  8.3235

#declare RXX    =  6.4098
#declare ThTHXX =  2.1504
#declare ThTCXX =  1.4496
#declare DXX    =  6.4087
#declare TDXX   = (RXX + TH - SC3)
#declare RotXX  = (ThTCXX + ThTHXX)

#declare R6    =  0.5892
#declare ThTH6 = 41.2509
#declare ThTC6 = 18.7491
#declare D6    =  0.5514
#declare TD6   = (R6 + TH - SC1)
#declare Rot6  = (ThTC6 + ThTH6)

#declare R8    =  0.7789
#declare ThTH8 = 30.5989
#declare ThTC8 = 14.4011
#declare D8    =  0.7513
#declare TD8   = (R8 + TH - SC1)
#declare Rot8  = (ThTC8 + ThTH8)

#declare R40    =  4.2771
#declare ThTH40 =  5.3857
#declare ThTC40 =  3.6143
#declare D40    =  4.2723
#declare TD40   = (R40 + TH - SC1)
#declare Rot40  = (ThTC40 + ThTH40)

#declare RXSC3    =  0.5788
#declare ThTHXSC3 = 24.2740
#declare ThTCXSC3 = 11.7260
#declare DXSC3    =  0.5659
#declare TDXSC3   = (RXSC3 + TH - SC3)
#declare RotXSC3  = (ThTCXSC3 + ThTHXSC3)

#declare R10    =  0.9693
#declare ThTH10 = 24.3417
#declare ThTC10 = 11.6583
#declare D10    =  0.9475
#declare TD10   = (R10 + TH - SC1)
#declare Rot10  = (ThTC10 + ThTH10)

#declare Bound_BoxXX =
box
   {
   <-One,    DXX, -One>
   < One, RXX+TH,  One>
   }

#declare Bound_Box6 =
box
   {
   <-One,    D6, -One>
   < One, R6+TH,  One>
   }

#declare Bound_Box8 =
box
   {
   <-One,    D8, -One>
   < One, R8+TH,  One>
   }

#declare Bound_Box40 =
box
   {
   <-One,    D40, -One>
   < One, R40+TH,  One>
   }

#declare Bound_Box10 =
box
   {
   <-One,    D10, -One>
   < One, R10+TH,  One>
   }

#declare Bound_BoxXSC3 =
box
   {
   <-One,    DXSC3, -One>
   < One, RXSC3+TH/2.5,  One>
   }

#declare ToothXX =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC3, 1-.01>
      translate <0, TDXX+TC, 0>
      }
   object { Bound_BoxXX inverse }
   bounded_by { Bound_BoxXX }
   }

#declare Tooth6 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC1, 1-.01>
      translate <0, TD6+TC, 0>
      }
   object { Bound_Box6 inverse }
   bounded_by { Bound_Box6 }
   }

#declare Tooth8 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC1, 1-.01>
      translate <0, TD8+TC, 0>
      }
   object { Bound_Box8 inverse }
   bounded_by { Bound_Box8 }
   }

#declare Tooth40 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC1, 1-.01>
      translate <0, TD40+TC, 0>
      }
   object { Bound_Box40 inverse }
   bounded_by { Bound_Box40 }
   }

#declare Tooth10 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC1, 1-.01>
      translate <0, TD10+TC, 0>
      }
   object { Bound_Box10 inverse }
   bounded_by { Bound_Box10 }
   }

#declare ToothXSC3 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC3, 1-.01>
      translate <0, TDXSC3+TC, 0>
      }
   object { Bound_BoxXSC3 inverse }
   bounded_by { Bound_BoxXSC3 }
   }

#declare TeethXX =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 100 )
         object { ToothXX rotate z*Count*RotXX }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> RXX }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> RXX+TH } }
   }

#declare Teeth6 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 6 )
         object { Tooth6 rotate z*Count*Rot6 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R6 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R6+TH } }
   }

#declare Teeth8 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 8 )
         object { Tooth8 rotate z*Count*Rot8 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R8 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R8+TH } }
   }

#declare Teeth40 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 40 )
         object { Tooth40 rotate z*Count*Rot40 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R40 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R40+TH } }
   }

#declare Teeth10 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 10 )
         object { Tooth10 rotate z*Count*Rot10 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R10 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R10+TH } }
   }

#declare TeethXSC3 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 9 )
         object { ToothXSC3 rotate z*Count*RotXSC3 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> RXSC3 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> RXSC3+TH } }
   }

#declare GearXX =
union
   {
   union
      {
      object { TeethXX }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> RXX }
         cylinder { <0, 0, -One> <0, 0, One> 4*RXX/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> RXX+TH } }
      }
   object { Gear_Big_Center scale <RXX, RXX, 1> }
//   pigment { quick_color Yellow }
   }

#declare Gear6 =
union
   {
   union
      {
      object { Teeth6 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R6 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R6/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R6+TH } }
      }
   object { Gear_Big_Center scale <R6, R6, 1> }
//   pigment { quick_color Green }
   }

#declare Gear8 =
union
   {
   union
      {
      object { Teeth8 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R8 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R8/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R8+TH } }
      }
   object { Gear_Big_Center scale <R8, R8, 1> }
//   pigment { quick_color Orange }
   }

#declare Gear40 =
union
   {
   union
      {
      object { Teeth40 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R40 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R40/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R40+TH } }
      }
   object { Gear_Big_Center scale <R40, R40, 1> }
//   pigment { quick_color Blue }
   }

#declare Gear10 =
union
   {
   union
      {
      object { Teeth10 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R10 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R10/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R10+TH } }
      }
   object { Gear_Big_Center scale <R10, R10, 1> }
//   pigment { quick_color Red }
   }

#declare GearXSC3 =
union
   {
   union
      {
      object { TeethXSC3 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> RXSC3 }
         cylinder { <0, 0, -One> <0, 0, One> 4*RXSC3/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> RXSC3+TH } }
      }
   object { Gear_Big_Center scale <RXSC3, RXSC3, 1> }
//   pigment { quick_color Green }
   }


