// Clock.Pov:   Stop-watch, designed in Moray, then modified to
//              include True-Type font Objects for the labelling.
//
//              Rex McDonald
//              rexm@xmission.com
//              1-801-974-3706
//

#include "clock.inc"

// ********  OBJECTS  *******

#declare Clock = union { // GroupClock
  box { // CubeSecond
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackSteel
    }
    scale <1.7, 0.02, 0.02>
    rotate -45.0*z
    translate  <1.0, -1.0, 1.2>
  }
  box { // CubeMin
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackSteel
    }
    scale <0.065, 1.2, 0.03>
    rotate -15.0*z
    translate  <0.3, 1.0, 1.3>
  }
  box { // CubeHour
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackSteel
    }
    scale <1.7, 0.075, 0.03>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.2, 0.0, 1.25>
  }
  cylinder { // CylCenter
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal
    }
    scale <0.15, 0.15, 0.5>
    translate  0.95*z
  }
  cylinder { // CylTagL
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackSteel
    }
    scale <0.08, 0.08, 0.30>
    translate <-1.2, 1.2, 0.95>
  }
  cylinder { // CylTagR
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackSteel
    }
    scale <0.08, 0.08, 0.30>
    translate <1.2, 1.2, 0.95>
  }
  cylinder { // CylMain
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Metal
    }
    scale <4.0, 4.0, 1.0>
  }
  text { // Text10
    ttf "TIMES.TTF", "X", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-2.58, 1.05, 0.75> // translate  <-2.33, 1.35, 0.75>
  }
  text { // Text9
    ttf "TIMES.TTF", "IX", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-2.95, -0.3, 0.75> // translate  <-2.7, 0.0, 0.75>
  }
  text { // Text8
    ttf "TIMES.TTF", "VIII", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-2.83, -1.65, 0.75> // translate  <-2.33, -1.35, 0.75>
  }
  text { // Text7
    ttf "TIMES.TTF", "VII", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-1.70, -2.63, 0.75> // translate  <-1.35, -2.33, 0.75>
  }
  text { // Text6
    ttf "TIMES.TTF", "VI", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-0.25, -3.0, 0.75> // translate  <0.0, -2.7, 0.75>
  }
  text { // Text5
    ttf "TIMES.TTF", "V", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <1.20, -2.63, 0.75> // translate  <1.35, -2.33, 0.75>
  }
  text { // Text4
    ttf "TIMES.TTF", "IV", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <2.03, -1.65, 0.75> // translate  <2.33, -1.35, 0.75>
  }
  text { // Text3
    ttf "TIMES.TTF", "III", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <2.4, -0.3, 0.75> // translate  <2.7, 0.0, 0.75>
  }
  text { // Text2
    ttf "TIMES.TTF", "II", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate<2.13,1.05,0.75>   //translate  <2.33, 1.35, 0.75>
  }
  text { // Text1
    ttf "TIMES.TTF", "I", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <1.30, 2.04, 0.75>
  }
  text { // Text12
    ttf "TIMES.TTF", "XII", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-0.4, 2.4, 0.75>
  }
  disc { // DiscPlate
    <0,0,0>, <0,0,1>, 1.0
    texture {
      WhitePaper
    }
    scale <3.6, 3.6, 1.0>
    translate  1.01*z
  }
  disc { // DiscCenter
    <0,0,0>, <0,0,1>, 1.0, 0.5
    texture {
      Chrome_Metal
    }
    scale <0.8, 0.8, 1.0>
    translate  1.02*z
  }
  text { // Text11
    ttf "TIMES.TTF", "XI", 1, 0
    texture {
      BlackSteel
    }
    scale <0.75,1.0,0.4>
    translate <-1.75, 2.03, 0.75> // translate  <-1.35, 2.33, 0.75>
  }
  sphere { // SphereGlassT
    <0,0,0>,1
    texture {
      Glass
    }
    scale <3.5, 3.5, 0.85>
    translate  0.9*z
  }
  torus { // TorusBack
    1.3125, 0.0625  rotate -x*90
    texture {
      Brass_Metal
    }
    scale <3.2, 3.2, 6.0>
    translate  0.5*z
  }
  cylinder { // CylndrLockBase
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal
    }
    scale <0.2, 0.2, 1.0>
    rotate -90.0*x
    translate  <0.0, 4.0, 0.5>
  }
  torus { // TorusRing
    1.75, 0.25  rotate -x*90
    texture {
      Chrome_Metal
    }
    scale 0.3
    translate  <0.0, 5.2, 0.5>
  }
  cylinder { // CylndrWind
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*y
    translate  <-3.7, 0.0, 0.5>
  }
  cylinder { // CylndrWind2
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Metal
    }
    scale <0.5, 0.5, 0.25>
    rotate -90.0*y
    translate  <-4.5, 0.0, 0.5>
  }
  text { // Text7
    ttf "LHANDW.TTF", "Walton Paynes", 1, 0
    texture {
      BlackSteel
    }
    scale <0.35, 0.5, 0.4>
    translate <-1.15, -1.3, 0.7> // translate  <0.0, -1.4, 0.7>
  }
}
