/*
  Sandglass.
  ----------
  Created 28.5.96 by Warp
  File: sandglas.pov
*/

#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"

global_settings
{ #max_trace_level 8
}

//============================================================================
// Sandglass
//============================================================================
#declare SandglassColumn =
  union
  { sphere { <0,0,0>,.75 scale <1,13.33,1> }
    sphere { <0,9,0>,1 }
    sphere { <0,-9,0>,1 }
    torus { .7,.3 translate <0,8,0> }
    torus { .7,.3 translate <0,-8,0> }
  }

#declare Sandglass =
  union
// The glass
  { difference
    { sor { 7,<0,-11><3.6,-10><4.75,-6><.5,0><4.75,6><3.6,10><0,11> }
      sor { 7,<0,-11><3.4,-10><4.55,-6><.3,0><4.55,6><3.4,10><0,11> }
      texture
      { pigment { color White filter 0.9 }
        finish { Glass_Finish }
      }
    }

// The sand
    union
    { difference
      { sor { 7,<0,-11><3.4,-10><4.55,-6><.29,0><4.55,6><3.4,10><0,11> }
        box { <-20,0,-20><20,-12,20> }
        cone { <0,2,0>,0,<0,12,0>,50 }
      }
      cone { <0,-10,0>,3,<0,-6,0>,0 }
      cylinder { <0,-10,0><0,1,0>,.1 }
      texture
      { pigment { color rgb <1,.8,.4> }
        finish { crand 0.1 }
      }
    }

// Wood
    union
    { box { <-5.5,10,-5.5><5.5,11,5.5> }
      box { <-5.5,-10,-5.5><5.5,-11,5.5> }
      object
      { SandglassColumn
        translate <-4.5,0,-4.5>
      }
      object
      { SandglassColumn
        translate <4.5,0,-4.5>
      }
      object
      { SandglassColumn
        translate <4.5,0,4.5>
      }
      object
      { SandglassColumn
        translate <-4.5,0,4.5>
      }
      texture
      { pigment { DMFWood4 }
        scale 4
        rotate <40,5,0>
      }
    }

  }

//============================================================================
// Room
//============================================================================
#declare Table =
  box
  { <-30,-11,-30><35,-20,30>
    texture
    { pigment { Tom_Wood }
      finish { reflection 0.2 }
      rotate <5,20,0>
      scale 2
    }
  }

#declare Walls =
  union
  { plane
    { <0,0,-1>,-32
      texture
      { pigment { color Red }
        normal { waves 1.0 }
        scale <1,20,1>
        translate <-20,0,0>
      }
    }
    plane
    { <-1,0,0>,-39
    }
    pigment { color White }
  }

#declare Room =
  union
  { object { Table }
    object { Walls }
  }

//============================================================================
// Mirror
//============================================================================
#declare TheMirror =
  union
  { box { <-7,-9,0><7,9,.1> finish { reflection 1 ambient 0 diffuse 0 } }
    difference
    { box { <-8,-10,-.5><8,10,1> }
      box { <-7,-9,-1><7,9,.5> }
    }
    texture
    { pigment { Dark_Wood }
      finish { Shiny }
    }
    rotate <5,0,0>
  }

//============================================================================
// Calendar
//============================================================================
#declare Calendar =
  union
  { difference
    { box { <-6,-5,-4><6,5,4> }
      box { <-7,-8,-4><7,8,4> rotate <20,0,0> translate <0,0,-3> }
      pigment { color White }
    }
    union
    { text { ttf "TIMES.TTF","25",.01,0 scale 7.5 }
      text { ttf "TIMES.TTF","September",.01,0 scale 1.5 translate <0,5.6,0> }
      text { ttf "TIMES.TTF","1985",.01,0 scale 1.5 translate <2,-1.5,0> }
      pigment { color Black }
      rotate <20,0,0>
      translate <-3.5,-3,.1>
    }
#declare Count=-5.5
#while (Count < 6)
   torus { 1,.2 rotate <0,0,90> translate <Count,5,2> }
   #declare Count=Count+1
#end
    texture
    { pigment { color White }
      finish { Shiny }
    }
  }

//============================================================================
// Dice
//============================================================================
#declare Dice =
  union
  { difference
    { superellipsoid { <.15,.15> scale 2 }
      sphere { <-1,2.2,-1>,.5 }
      sphere { <-1,2.2,1>,.5 }
      sphere { <1,2.2,1>,.5 }
      sphere { <1,2.2,-1>,.5 }
      sphere { <2.2,0,0>,.5 }
      sphere { <1,1,-2.2>,.5 }
      sphere { <-1,-1,-2.2>,.5 }
      texture
      { pigment { color White }
        finish { Shiny }
      }
    }
    difference
    { sphere { <-1,2.2,-1>,.5 }
      sphere { <-1,2.2,-1>,.45 }
      box { <-2,2,-2><2,4,2> }
    }
    difference
    { sphere { <-1,2.2,1>,.5 }
      sphere { <-1,2.2,1>,.45 }
      box { <-2,2,-2><2,4,2> }
    }
    difference
    { sphere { <1,2.2,1>,.5 }
      sphere { <1,2.2,1>,.45 }
      box { <-2,2,-2><2,4,2> }
    }
    difference
    { sphere { <1,2.2,-1>,.5 }
      sphere { <1,2.2,-1>,.45 }
      box { <-2,2,-2><2,4,2> }
    }
    difference
    { sphere { <2.2,0,0>,.5 }
      sphere { <2.2,0,0>,.45 }
      box { <2,-2,-2><4,2,2> }
    }
    difference
    { sphere { <1,1,-2.2>,.5 }
      sphere { <1,1,-2.2>,.45 }
      box { <-2,-2,-2><2,2,-4> }
    }
    difference
    { sphere { <-1,-1,-2.2>,.5 }
      sphere { <-1,-1,-2.2>,.45 }
      box { <-2,-2,-2><2,2,-4> }
    }
    difference
    { sphere { <-2.2,1,1>,.5 }
      box { <-2.01,-2,-2><-4,2,2> }
    }
    difference
    { sphere { <-2.2,-1,-1>,.5 }
      box { <-2.01,-2,-2><-4,2,2> }
    }
    difference
    { sphere { <-2.2,0,0>,.5 }
      box { <-2.01,-2,-2><-4,2,2> }
    }

    texture
    { pigment { color Black }
      finish { Shiny }
    }
  }

//============================================================================
// Main scene
//============================================================================

light_source
{ <20, 0, 1> color White
  fade_distance 20
  fade_power 1
}

camera
{ direction <0,0,2>
  location <0,20,-50>
  look_at <0,0,0>
}

object
{ Sandglass
  rotate <0,25,0>
  translate <-4,0,1>
}

object
{ Room
  rotate <0,-20,0>
}

object
{ TheMirror
  rotate <0,-8,0>
  translate <0,-1,22>
  rotate <0,35,0>
}

object
{ Calendar
  translate <-8,-6,20>
  rotate <0,-20,0>
}

object
{ Dice
  rotate <0,-45,0>
  translate <7,-9,0>
}

object
{ Dice
  rotate <0,30,0>
  translate <14,-9,5>
}
