#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "golds.inc"
#include "teak.map"

camera {    location <0.0, 22,-35.0>
            direction z*1.9
            look_at <3.0, 6.0, 0.00>}

light_source { <-20.00, -10.00, -50.00> color rgb<1,1,1> shadowless}
light_source { <50.00, 30.00, 70.00> color rgb<1,1,1> shadowless}
#declare GlAss=texture
  {T_Old_Glass}

#declare WOODFRAME=texture
    {pigment{    wood      turbulence 0.02    octaves 4    lambda 3    scale 0.175    rotate <2, 2, 0>
        color_map{M_Teak}}
    finish {  specular 0.25  roughness 0.05
              ambient 0.45   diffuse 0.33  reflection 0.15  }
    }

#declare HOURGLASS=
union{
    sor { 10, <4,-7>, <4,-5>, <3.9,-2>, <2.5,-1>, <.75,-.25>,   <.75,.25>, <2.5,1>, <3.9,2>, <4,5>, <4,7>  open
            texture{GlAss}   }
    union{  cylinder{<0,-5.5 ,0><0,-5,0>5.5}
        cylinder{<0,5,0><0,5.5,0>5.5}
        torus{5.85,.2 rotate 0*x translate -5.25*y texture {T_Gold_2A}}
        torus{5.85,.2 rotate 0*x translate 5.25*y texture {T_Gold_2A}}
        torus{5.5,.5 rotate 0*x translate -5.25*y}
        torus{5.5,.5 rotate 0*x translate 5.25*y}

        sor { 11, <.275,-7>, <.25,-4>, <.5,-3.5>, <.26,-3>, <.26,-.5>,   <.4,0>,   <.26,.5>, <.26,3>, <.5,3.5>, <.25,4>, <.275,7> translate< 5,0,0>             scale <1,1.2,1> }
        sor { 11, <.275,-7>, <.25,-4>, <.5,-3.5>, <.26,-3>, <.26,-.5>,   <.4,0>,   <.26,.5>, <.26,3>, <.5,3.5>, <.25,4>, <.275,7> translate<-2.5,0, 4.33012702> scale <1,1.2,1> }
        sor { 11, <.275,-7>, <.25,-4>, <.5,-3.5>, <.26,-3>, <.26,-.5>,   <.4,0>,   <.26,.5>, <.26,3>, <.5,3.5>, <.25,4>, <.275,7> translate<-2.5,0,-4.33012702> scale <1,1.2,1> }

        texture{WOODFRAME scale 1.5 translate <2,3,4> rotate <20,40,60>}
	}
   scale<.65,1,.65>
   translate 6*y
}

#declare SAND=
union{
      sor { 6,   <.15,-.5>,  < .15,.25>, <.5,.5>, <2.35,1>, <3.5,2>, <3.75, 3> }
    cylinder{<0,-4,0>< 0,1,  0 >.02}
    cylinder{<-.05,-4,.20><0,1,-.05>.02}
    cylinder{<.2,-4,-.10><0,1,  0 >.02}
    cylinder{< .05,-4,   0><-.05,1,-.05>.02}
    cylinder{<-.05,-4,-.19><0,1,-.15>.01}
    cylinder{<   0,-4,-.13><0,1, 0  >.02}

    cone{<0,-5,0>,3<0,-4,0>.25}
 pigment{granite turbulence 7
    color_map{  [0,.4 color Tan color rgb<0.878824,0.606471,0.449216>]
                [.4,1 color rgb<0.878824,0.606471,0.449216> color Tan]
    }}
 finish{crand .1} scale<.65,1,.65>
 translate 6*y
  }

box{<-50,-1,-50><50,0,50> texture{DMFWood6 scale 5}}

union{
    object{HOURGLASS}
    object{SAND}
    scale <.9,1,.9>
    }

#declare Atmosphere = atmosphere {
  type 4
  samples 10      
  distance 40     
  scattering 0.401  
  aa_level 4      
  aa_threshold 0.1
  jitter 0.251
}

atmosphere { Atmosphere }

light_source {<10,30,-100> color red 1 green 1 blue 1
  spotlight  point_at <27, 5, 0>  radius 5  falloff 6  atmospheric_attenuation on}

light_source {  <10, 80, -30> color red 1 green 1 blue 1
  spotlight  point_at <0, 14, 0>  radius 10  falloff 17  atmospheric_attenuation on}
