
#declare	PI2 = 3.1415926 * 2
#declare	From = PI2 * 4 / 8
#declare	To = PI2 * 8 / 8

#declare	nMarks = 12
#declare	StepSize = (To - From) / nMarks

#declare	MSize = .02

	
	
declare VPlane = union {
	difference {
		cylinder {
			<-.5, 0, 0>, <.5, 0, 0>, .5
		}
		cylinder {
			<-.5, 0, 0>, <.5, 0, 0>, .49
		}
		box {
			-.5, <.5, .6, .5>
			rotate <0, 0, -7>
			translate <-.6, 0, 0>
		}
		box {
			-.5, <.5, .6, .5>
			rotate <0, 0, 7>
			translate <.6, 0, 0>
		}
	}

	#declare counter = 0
	#while (counter <= nMarks)
		#declare	Angle = From + counter * StepSize
		#declare	Y = sin(Angle) * .47
		#declare Z = cos(Angle) * .47
		union {
			box {
				<0, 0, 0>, <.1, MSize, MSize>
			} 
			text {
	 			ttf "C:\windows\fonts\Harngton.ttf",
	 			str(mod(17 - counter, 12) + 1,0,0), .2, 0
	 			rotate <0, 0, -90>
	 			translate <-.8, .4, 0>

	 			scale .1
	 		} 
			rotate <-Angle * 360 / PI2, 0, 0>
			translate <0, Y, Z>
		}

		#declare counter = counter + 1
	#end

}

#declare Height = .4
#declare	Width = .4
#declare	Thick = .01

#declare	Rad = .35

#declare Stand = difference {
	union {
		box {
			<-Width, 0, -Thick>, <Width, Height, Thick>
		}
		box {
			<-Thick, 0, -Width>, <Thick, Height, Width>
		}
	}
	sphere {
		<-Width, Height, 0>, Rad
	}
	sphere {
		<Width, Height, 0>, Rad
	}
	sphere {
		<0, Height, -Width>, Rad
	}
	sphere {
		<0, Height, Width>, Rad
	}
	sphere {
		<-.1, Height + .45, 0>, .5
	}
}


#declare DialBody = union {
	object {
		VPlane
		rotate <0, 0, 20>
	}
	difference {
		cylinder {
			<0, -.01, 0>, <0, .01, 0>, .52
		}
		cylinder {
			<0, -.011, 0>, <0, .011, 0>, .48
		}
	}
	cylinder {
		<-.5, 0, 0>, <.5, 0, 0>, .02
	}
}

#declare SunDial = union {
	object {
		DialBody
		translate <0, .36 + .5, 0>
	}
	object {
		Stand
		translate <.1, 0, 0>
	}
#ifdef (TESTS)
	pigment { color Yellow } 
#else
	texture { T_Brass_4A }
#end
}

