#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "textures.inc"

// *SETUP LIGHTS AND CAMERA*
// Place camera

// "Sundial" View
camera {
	location <9.25, 5.5, -7.75>
	up <0, 1, 0>
	right <1.3, 0, 0>
	direction <0,0,1>
	look_at  <0, 4, 0>
}

// "Plan" View
//camera {
//	location <0, 175, 0>
//	up <0, 1, 0>
//	right <1.3, 0, 0>
//	direction <0,0,1>
//	look_at  <0, 4, 0>
//}

// Place Light Source
light_source {<50, 100, 20> color White}


// *CREATE BACKGROUND*
// Sky
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 color SkyBlue]
			[1 color MidnightBlue]
		}
		scale 2
	}
}

// Mountains
height_field {
	gif "terrain.ghf"
	pigment {image_map {gif "terrain.ghf"} rotate x*90}
	finish {ambient .3}
	translate<-.5,0,-.5>
	scale <1000,75,1000>
	translate<0,.02,0>
}

// Ground Fog
fog {
	distance 19
	color rgbf <1,1,1,1>
	fog_type 2
	fog_offset .15
	fog_alt .6
	turbulence .4
}

// *CREATE OBJECTS*
#declare Post_Stone=
object {
	intersection{
		box{<-2, 0, -1.25> <2, 10, 1.25>}
		blob{
			threshold .3
			cylinder{<-1, 0, 0>, <-.5, 9.5, 0>, 1.5, strength 1}
			cylinder{<1, 0, 0>, <.5, 9.5, 0>, 1.5, strength 1}
			component 1, 5, <0, 0, 0>
			component 1, 1.75, <0, 3, 0>
			component 1, 1.5 <0, 6.5, 0>
		}
	}
}

#declare Cap_Stone=
object {
	intersection {
		box{<-3, 8.5, -1.25> <3, 11.5, 1.25>}
		blob{
			threshold .3
			component 1, 1.9, <-2,10,0>
			component 1, 1.75 <0,10,0>
			component 1, 1.9 <1.5,10,0>
		}
	}
}

#declare Radius=37
#declare Stonehenge=
union {
	object{Post_Stone translate <0,0,Radius> rotate y*-45}
	object{Post_Stone translate <0,0,Radius> rotate y*-35}
	object{Post_Stone translate <0,0,Radius> rotate y*-25}
	object{Post_Stone translate <0,0,Radius> rotate y*-15}
	object{Post_Stone translate <0,0,Radius> rotate y*-5}
	object{Post_Stone translate <0,0,Radius> rotate y*5}
	object{Post_Stone translate <0,0,Radius> rotate y*15}
	object{Post_Stone translate <0,0,Radius> rotate y*25}
	object{Post_Stone translate <0,0,Radius> rotate y*35}
	object{Post_Stone translate <0,0,Radius> rotate y*45}
	object{Cap_Stone  translate <0,0,Radius> rotate y*-40}
	object{Cap_Stone  translate <0,0,Radius> rotate y*-30}
	object{Cap_Stone  translate <0,0,Radius> rotate y*-20}
	object{Cap_Stone  translate <0,0,Radius> rotate y*-10}
	object{Cap_Stone  translate <0,0,Radius> rotate y*10}
	object{Cap_Stone  translate <0,0,Radius> rotate y*20}
	object{Cap_Stone  translate <0,0,Radius> rotate y*30}
	object{Cap_Stone  translate <0,0,Radius> rotate y*40}
	translate <0,0,-20>
	texture{T_Stone28}
	normal {bumps .3}
}

#declare Bowl=
union {
	object {
		union {
			intersection {
				difference{
					sphere{<0,3,0> 3.05}
					sphere{<0,3,0> 2.95}
				}
				box{<-3,0,-3> <3,1,3>}
			}
			torus{.75,.5}
		}
		texture{T_Grnt11}
		finish {phong .3 reflection .3}
	}
	object {
		intersection {
			sphere{<0, 3, 0> 3}
			box{<-3, 0, -3> <3, .9, 3>}
		}
		texture {T_Old_Glass}
		finish{phong .3 reflection .4}
		normal{ripples .5 scale <.5, .5, .5>}
	}
}

#declare GrassBlade=
object{
	intersection{
		difference{
			sphere{<1.75,0,0> 1.75}
			sphere{<1.75,.1,0> 1.7}
		}
		intersection {
			box{<-.1,-.1,-.03> <2, 2, .03> rotate x*4}
			box{<-.1,-.1,-.03> <2, 2, .03> rotate x*-4}
		}
	}
	pigment {color MediumForestGreen}
	finish {ambient .5}
}

#declare R1=seed(1)
#declare GrassTuft=
union {
	object{GrassBlade}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*3)+.5,1> rotate y*(rand(R1)*360)}
}

#declare Petal=
object {
	intersection {
		union {
			cone{<0,0,0>, 0, <0,0,.15>, .03}
			sphere{<0,0,.15>, .03}
		}
		box{<-.3, -.01, 0> <.3, .01, .18>}
	}
	pigment {
		gradient z
		color_map{
			[0 color DarkPurple]
			[1 color Pink]
		}
		scale .18
	}
}

#declare Blossom=
union {
	object{Petal rotate z*1}
	object{Petal rotate z*3 rotate y*41}
	object{Petal rotate z*-2 rotate y*82}
	object{Petal rotate z*2 rotate y*119}
	object{Petal rotate z*-4 rotate y*160}
	object{Petal rotate z*-3 rotate y*199}
	object{Petal rotate z*1 rotate y*238}
	object{Petal rotate z*4 rotate y*281}
	object{Petal rotate z*-2 rotate y*320}
	object{
		cylinder{<0,0,0>,<0,.02,0>,.03}
		pigment {color Yellow}
	}
}

#declare Flower=
union {
	object{GrassBlade scale <1,(rand(R1)*2)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*2)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*2)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*2)+.5,1> rotate y*(rand(R1)*360)}
	object{GrassBlade scale <1,(rand(R1)*2)+.5,1> rotate y*(rand(R1)*360)}
	object{Blossom	translate <0,1.25,0>}
	object{cylinder {<0,0,0>,<0,1.25,0>,.01} pigment {color MediumForestGreen}}
}

#declare Wall=
union{
	//Left Wall
	object{
		box{<0,0,0> <1,8,50>}
		pigment{
			brick
			brick_size <.75, .5, 1.5>
			mortar .1
		}
	}
	object{
		box {<-.2, 8, -.2> <1.2, 8.4, 50.2>}
		pigment{color White}
	}

	// Right Wall
	object{
		box{<43, 0, 0> <44, 8, 50>}
		pigment{
			brick
			brick_size <.75, .5, 1.5>
			mortar .1
		}
	}
	object{
		box {<42.8, 8, -.2> <44.2, 8.4, 50.2>}
		pigment{color White}
	}

	// Back Wall
	object{
		box{<0, 0, 0> <44, 8, 1>}
		pigment{
			brick
			brick_size <1.5, .5, 1.75>
			mortar .1
		}
	}
	object{
		box {<-.2, 8, -.2> <44.2, 8.4, 1.2>}
		pigment{color White}
	}

	// "Stonehenge" Front Wall
	object{Stonehenge translate <22,0,50>}
}

#declare LongHand=
object {
	intersection {
		union {
			box{<-.2,0,0> <.2,.1,3>}
			sphere{<0,.05,3> .5}
			cone{<0,.05,3.4>, .75, <0,.05,15>,0}
		}
		box {<-1,0,0> <1,.051,20>}
	}
	pigment {color Black}
	finish{ambient .2 reflection .1}
}

#declare ShortHand=
object {
	intersection {
		union {
			box{<-.2,0,0> <.2,.1,3>}
			sphere{<0,.05,3> .5}
			cone{<0,.05,3.4>, .75, <0,.05,10>,0}
		}
		box {<-1,0,0> <1,.051,20>}
	}
	pigment {color Black}
	finish{ambient .2 reflection .1}
}

#declare Patio=
union{
	object {
	        cylinder{<0,0,0>,<0,.05,0>,20}
		pigment {
			hexagon
			pigment {Gray90},
			pigment {Gray85},
			pigment {Gray80}
		}
		finish{ambient .2}
	}
	object{LongHand rotate y*-30}
	object{ShortHand rotate y*213}
}

#declare Groove=
union{
	cylinder{<0, .5, 1>, <0, 3.25, 1>, .12}
	sphere{<0, .5, 1>, .12}
	sphere{<0, 3.25, 1>, .12}
}

#declare Line=
object{
	box{<-.01, 3.95, 0> <.01, 4.1, 1.25>}
	rotate y*205
}

#declare Sundial=
union{
        // Base
	object{
		union{
			cylinder{<0, 0, 0>, <0, .15, 0>, 1.4}
			cylinder{<0, .15, 0>, <0, .3, 0>, 1.2}
		}
		texture{T_Grnt3 scale <2, 2, 2>}
		finish{phong .3 ambient .2 reflection .2}
	}
        //Fluted Column
	object{
		difference{
			cylinder{<0, 0, 0>, <0, 3.5, 0>, 1}
			object{Groove}
			object{Groove rotate y*15}
			object{Groove rotate y*30}
			object{Groove rotate y*45}
			object{Groove rotate y*60}
			object{Groove rotate y*75}
			object{Groove rotate y*90}
			object{Groove rotate y*105}
			object{Groove rotate y*120}
			object{Groove rotate y*135}
			object{Groove rotate y*150}
			object{Groove rotate y*165}
			object{Groove rotate y*180}
			object{Groove rotate y*195}
			object{Groove rotate y*210}
			object{Groove rotate y*225}
			object{Groove rotate y*240}
			object{Groove rotate y*255}
			object{Groove rotate y*270}
			object{Groove rotate y*285}
			object{Groove rotate y*300}
			object{Groove rotate y*315}
			object{Groove rotate y*330}
			object{Groove rotate y*345}
		}
		texture{T_Grnt3 scale <2, 2, 2>}
		finish{phong .3 ambient .2 reflection .2}
	}
        //Gnomen
	object{
		union {
			intersection{
				box{<-1.25, 4, -.02> <0, 5, .02>}
				union{
					difference{
						sphere{<-1.25, 5.25, 0>, 1.25}
						sphere{<-1.23, 5.25, 0>, 1.2}
					}
					box{<-1.25,4,-.03> <0,4.05,.03>}
				}
			}
			cylinder{<0,4,0>, <0,5.45,0>,.02}
			sphere{<0,5.28,0> .03}
			cone{<0,5.3,0>,.05,<0,5.4,0>,0}
		}
		rotate y*205
		texture{T_Brass_2D}
		finish{phong .3 ambient .2 reflection .1}
	}
        //Dial Face
	object{
		difference{
			intersection{
				sphere{<0, 6, 0>, 2.75}
				box{<-2, 3, -2> <2, 4, 2>}
				cylinder{<0, 3, 0>, <0, 4.1, 0>, 1.75}
			}
			difference{
				cylinder{<0, 3.95, 0> <0, 4.1, 0> 1.65}
				cylinder{<0, 3.94, 0> <0, 4.2, 0> 1.6}
			}
			difference{
				cylinder{<0, 3.95, 0> <0, 4.1, 0> 1.3}
				cylinder{<0, 3.94, 0> <0, 4.2, 0> 1.25}
			}
			object{Line}
			object{Line rotate y*20}
			object{Line rotate y*40}
			object{Line rotate y*60}
			object{Line rotate y*80}
			object{Line rotate y*100}
			object{Line rotate y*120}
			object{Line rotate y*140}
			object{Line rotate y*160}
			object{Line rotate y*180}
			object{Line rotate y*200}
			object{Line rotate y*220}
		}
		texture{T_Grnt3 scale <2, 2, 2>}
		finish{phong .3 ambient .2 reflection .2}
	}
}


#declare BLeg =
object {
	difference{
		intersection {
			union {
				difference{
					box{<-.1,0,-.5> <.15,2,.5>}
					box{<.1,.1,-.4> <.16,1.9,.4>}
				}
				cylinder{<0,1,-.75>, <.15,1,-.75>, .6}
				cylinder{<0,1,.75>, <.15,1,.75>, .6}
				cylinder{<0,0,0>, <.15,0,0>, .35}
			}
			box{<-.12,-.1,-.75> <.17,2,.75>}
		}
		cylinder{<-.11,1,-.75>, <.16,1,-.75>, .5}
		cylinder{<-.11,1,.75>, <.16,1,.75>, .5}
		cylinder{<-.11,0,0>, <.16,0,0>, .25}
	}
}

#declare Bench =
union {
	object{BLeg rotate y*180 translate <-2,0,0>}
	object{BLeg translate <2,0,0>}
	object{
		union {
			box{<-3,2,-.75> <3,2.25,.75>}
			sphere{<-3,2.15,-.75> .1}
			sphere{<-3,2.15,.75> .1}
			sphere{<3,2.15,-.75> .1}
			sphere{<3,2.15,.75> .1}
			cylinder{<-3,2.15,-.75>,<-3,2.15,.75>,.1}
			cylinder{<-3,2.15,-.75>,<3,2.15,.75>,.1}
			cylinder{<3,2.15,-.75>,<3,2.15,.75>,.1}
			cylinder{<-3,2.15,.75>,<3,2.15,.75>,.1}
		}
	}
}

#declare Twelve =
object {
	text {ttf "timrom.ttf", "XII", .25, 0}
	scale <4,4,1>
	rotate y*-90
	translate <-20.75, 4, -2.5>
	texture{T_Stone14}
}

#declare Three =
object {
	intersection{
		text {ttf "timrom.ttf", "3", 1, 0}
		cylinder{<-2,.5,4>,<2,.5,4>,4}
	}
	texture {T_Grnt26}
	finish {phong .3 ambient .3 reflection .2}
	scale <9,11,1>
	translate <-3, -.1, 22>
}

#declare Leaf =
object {
	intersection {
		union{
			sphere{<0,0,.3>,.3}
			cone{<0,0,.3>,.3,<0,0,.6>,0}
		}
		box{<-.31,-.01,0> <.31,.01,.61>}
	}
	pigment{
		gradient z
		color_map {
			[0 color ForestGreen]
			[.5 color MediumForestGreen]
			[1 color Green]
		}
		scale .6
	}
}

#declare Twig1 =
union{
	object{
		union {
			cone{<0,0,0>,.02,<0,.5,0>,0}
			sphere{<0,0,0>,.02}
		}
		pigment{DarkGreen}
	}
	object{Leaf	rotate <90,0,0>		translate <0,.49,0>}
	object{Leaf	rotate <-30,45,0>	translate <0,.39,0>}
	object{Leaf	rotate <-30,165,0>	translate <0,.29,0>}
	object{Leaf	rotate <-30,285,0>	translate <0,.19,0>}
}

#declare Twig2 =
union{
	object{
		union{
			cone{<0,0,0>,.04,<0,1,0>,.02}
			sphere{<0,0,0>,.04}
		}
		pigment{MediumWood}
	}
	object{Twig1	translate <0,1,0>}
	object{Twig1	rotate <-30,45,0>	translate <0,.75,0>}
	object{Twig1	rotate <-30,165,0>	translate <0,.5,0>}
	object{Twig1	rotate <-30,285,0>	translate <0,.25,0>}
}

#declare Twig3 =
union{
	object{
		union{
			cone{<0,0,0>,.08,<0,2,0>,.04}
			sphere{<0,0,0>,.08}
		}
		pigment{MediumWood}
	}
	object{Twig2	translate <0,2,0>}
	object{Twig2	rotate <-30,45,0>	translate <0,1.5,0>}
	object{Twig2	rotate <-30,165,0>	translate <0,1,0>}
	object{Twig2	rotate <-30,285,0>	translate <0,.5,0>}
}

#declare Twig4 =
union{
	object{
		union{
			cone{<0,0,0>,.16,<0,4,0>,.08}
			sphere{<0,0,0>,.16}
		}
		pigment{MediumWood}
	}
	object{Twig3	translate <0,4,0>}
	object{Twig3	rotate <-30,45,0>	translate <0,3,0>}
	object{Twig3	rotate <-30,165,0>	translate <0,2,0>}
	object{Twig3	rotate <-30,285,0>	translate <0,1,0>}
}

#declare Tree =
union{
	object{
		union{
			cone{<0,0,0>,.32,<0,8,0>,.16}
			sphere{<0,0,0>,.32}
		}
		pigment{MediumWood}
	}
	object{Twig4	translate <0,8,0>}
	object{Twig4	rotate <-30,45,0>	translate <0,6,0>}
	object{Twig4	rotate <-30,165,0>	translate <0,5,0>}
	object{Twig4	rotate <-30,285,0>	translate <0,4,0>}
}

#declare HGlass=
object{
	blob{
		threshold .1
		component 1, .55, <0,-.6,0>
		component 1, .55 <0,.6,0>
		component 1, .25, <0,-.3,0>
		component 1, .25, <0,.3,0>
		cylinder{<0,-.3, 0>, <0, .3, 0>, .1, strength 1}
	}
}

#declare Hourglass=
union {
	object{
		difference{
			object{HGlass}
			object{HGlass scale <.95,1,.95>}
		}
		texture{T_Old_Glass}
		finish{phong .3 reflection .2}
	}
	object{
		intersection {
			object{HGlass scale <.95,1,.95>}
			object{cone{<0,-1,0>,1,<0,-.4,0>,0}}
		}
		pigment {color White}
		finish {ambient .5}
	}
	object{
		union {
			box{<-.5,1.1,-.5> <.5,1.3,.5>}
			box{<-.5,-1.3,-.5> <.5,-1.1,.5>}
			cylinder{<-.45,-1.2,-.45>, <-.45,1.2,-.45>, .02}
			cylinder{<.45,-1.2,-.45>, <.45,1.2,-.45>, .02}
			cylinder{<-.45,-1.2,.45>, <-.45,1.2,.45>, .02}
			cylinder{<.45,-1.2,.45>, <.45,1.2,.45>, .02}
		}
		texture{T_Gold_1B}
		finish{phong .3 reflection .2}
	}
	translate <.5,1.3,.5>
	rotate y*80
}

// *ARRANGE OBJECTS *
object{Wall		translate <-22, 0, -26>}
object{Twelve}
object{Three}
object{Hourglass	translate <0,0,8>}
object{Tree		translate <0,0,24>	rotate y*-20}
object{Patio}
object{Sundial		rotate y*-25}
object{GrassTuft	translate <1.5,0,0>	rotate y*-10}
object{GrassTuft	translate <16,0,0>	rotate y*30}
object{Flower		translate <1.5,0,0>}
object{Flower		translate <6,0,0>	rotate y*-50}
object{Flower		translate <11,0,0>	rotate y*-198}
object{Bench		translate <0,0,18>			texture{T_Grnt23}}
object{Bowl		translate <0,0,18>	rotate y*30}
object{Bowl		translate <0,0,18>	rotate y*60}
object{Bench		translate <0,0,18>	rotate y*90	texture{T_Grnt23}}
object{Bowl		translate <0,0,18>	rotate y*120}
object{Bowl		translate <0,0,18>	rotate y*150}
object{Bench		translate <0,0,18>	rotate y*180	texture{T_Grnt23}}
object{Bowl		translate <0,0,18>	rotate y*210}
object{Bowl		translate <0,0,18>	rotate y*240}
object{Bench		translate <0,0,18>	rotate y*270	texture{T_Grnt23}}
object{Bowl		translate <0,0,18>	rotate y*300}
object{Bowl		translate <0,0,18>	rotate y*330}
