// Persistence of Vision Ray Tracer Scene Description File
// File: thrutime.pov
// Vers: 3
// Desc: TARDIS travelling through the time continuum
// Date: 07 Jun 96
// Auth: Tim Redman

#include "colors.inc"
#include "textures.inc"
#include "tardis.pov"
#include "tunnel.pov"
#include "clock.pov"

global_settings { ambient_light color red 1.0 green .5 blue .5 }

camera {
   perspective
   location <0,0,-40>
   look_at <0,0,0>
   angle 45
}

light_source {
   <10,10,-40>
   color White
}

light_source {
   <-20,20,20>
   color White
}

object {
   tardis
   scale 1.3
   rotate <-20,35,0>
   translate <10,0,0>
}

object {
   tunnel
}

object { watch scale .75 rotate <46,20,09> translate <-20,10,0> }
object { watch scale .75 rotate <25,38,37> translate <-20,20,50> }
object { watch scale .75 rotate <25,26,23> translate <-30,-10,40> }
object { watch scale .75 rotate <87,09,85> translate <-50,0,100> }
object { watch scale .75 rotate <67,82,96> translate <-40,-50,320> }
object { watch scale .75 rotate <36,26,10> translate <-55,-75,210> }

