/* watch.inc  -  a wrist-watch lying face down with its back  */
/*               opened;  used in "timeresp.pov"              */
/* Scene designed by:  Martin Gonda,   Copyright July 1996    */

#declare 
My_Chrome = texture { 
  pigment { color rgb<1,1,1> } 
  finish { ambient 0.2 diffuse 0.8 reflection 0.5 phong 0.8 }
}

#declare My_Dark_Chrome = texture { 
  pigment { color rgb<0.5,0.5,0.5> } 
  finish { ambient 0.1 diffuse 0.8 reflection 0.2 phong 0.6 }
}

#declare My_Gold = texture { 
  pigment { color rgb <0.8,0.65,0.3> } 
  finish { ambient 0.2 diffuse 0.8 reflection 0.4 phong 0.8 }
}

#declare watch_body = union {
  difference {
    union {
      cylinder { <0,0,-0.2>, <0,0,0.4>, 3 }
      difference { 
        box { <-4,-3,0>, <-2,3,0.4> }
        cylinder { <-4,-4.5,-0.01>, <-4,-4.5,0.41>, 3 }
        cylinder { <-4, 4.5,-0.01>, <-4, 4.5,0.41>, 3 }
      }
      difference { 
        box { <2,-3,0>, <4,3,0.4> }
        cylinder { < 4,-4.5,-0.01>, < 4,-4.5,0.41>, 3 }
        cylinder { < 4, 4.5,-0.01>, < 4, 4.5,0.41>, 3 }
      }
    }
    cylinder { <0,0,-0.21>, <0,0,0.39>, 2.6 texture { My_Dark_Chrome } }
    box { <-4.01,-1.2,-0.01>, <-3.4,1.2,0.41> }
    box { <3.4,-1.2,-0.01>, <4.01,1.2,0.41> }
  }
  torus { 2.75, 0.25 rotate <90,0,0> scale <1,1,0.6> translate <0,0,0.4> }
  union { 
    cylinder { <0,3.05,0.2>, <0,3.4,0.2>, 0.3 }
    cylinder { <0,2.0,0.2>, <0,3.1,0.2>, 0.1 }
    cylinder { <0,2.9,0.2>, <0,3.25,0.2>, 0.2 rotate <0,0,30> }
    cylinder { <0,2.9,0.2>, <0,3.25,0.2>, 0.2 rotate <0,0,-30> }
    cylinder { <0,2.9,0.2>, <0,3.25,0.2>, 0.2 rotate <0,0,150> }
    cylinder { <0,2.9,0.2>, <0,3.25,0.2>, 0.2 rotate <0,0,-150> }
    texture { My_Gold }
  }
  texture { My_Chrome }
}

#declare watch_inside = union {
  intersection { // pcb
    difference {
      box { <-2.2,-2.0,0.10>, <2.2,2,0.20>
        texture { DMFLightOak }
      }
      box { < 1.0,-2.1,0.09>, <2.3,0.5,0.21> }
      box { <-2.3,-2.1,0.09>, <-1,0,0.21> }
      cylinder { <-1,-0.5,0.09>, <-1,-0.5,0.21>, 1 }
    }
    cylinder { <0,0,0.08>, <0,0,0.22>, 2.4 }
  }
  union { 
    cylinder { <-1,-0.5,0.1>, <-1,-0.5,0.35>, 0.85 } 
    sphere { <-1,-0.5,0.3>, 0.85 scale <1,1,0.15> } //battery
    cylinder { <1.5,-1,0.2>, <1.5,0.3,0.2>, 0.3 } // crystal/cap
    texture { My_Chrome }
  }
}

#declare watch_chain_link_1 = union {
  cylinder { <-0.35,-1.1,0>, <-0.35,1.1,0>, 0.15 }
  cylinder { < 0.35,-1.1,0>, < 0.35,1.1,0>, 0.15 }
  box { <-0.35,-1.1,-0.15>, <0.35,1.1,0.15> }
  texture { My_Gold }
}

#declare watch_chain_link_2 = union {
  object { watch_chain_link_1 scale <1,0.4/2.2,1> translate <-0.6,1.35,0> 
    texture { My_Chrome }
  }
  object { watch_chain_link_1 scale <1,0.4/2.2,1> translate <-0.6,-1.35,0>
    texture { My_Chrome }
  }
}

#declare watch_chain = union {
  object { watch_chain_link_2 translate <-3.0,0,0.00>}
  object { watch_chain_link_1 translate <-4.1,0,0.02>}
  object { watch_chain_link_2 translate <-4.1,0,0.04>}
  object { watch_chain_link_1 translate <-5.2,0,0.08>}
  object { watch_chain_link_2 translate <-5.2,0,0.12>}
  object { watch_chain_link_1 translate <-6.3,0,0.16>}
  object { watch_chain_link_2 translate <-6.3,0,0.20>}
  object { watch_chain_link_1 translate <-7.4,0,0.23>}
  object { watch_chain_link_2 translate <-7.4,0,0.26>}
  object { watch_chain_link_1 translate <-8.5,0,0.29>}
  object { watch_chain_link_2 translate <-8.5,0,0.32>}
  object { watch_chain_link_1 translate <-9.6,0,0.35>}
  object { watch_chain_link_2 translate <-9.6,0,0.37>}
  object { watch_chain_link_1 translate <-10.7,0,0.39>}
  object { watch_chain_link_2 translate <-10.7,0,0.41>}
  object { watch_chain_link_1 translate <-11.8,0,0.42>}
  object { watch_chain_link_2 translate <-11.8,0,0.43>}
  object { watch_chain_link_1 translate <-12.9,0,0.44>}

  object { watch_chain_link_2 translate < 3.0,0,0> rotate<0,0,0> }
  object { watch_chain_link_1 translate < 4.1,0,0> rotate<0,0,0> }
  object { watch_chain_link_2 translate < 4.1,0,0> rotate<1,0,0> }
  object { watch_chain_link_1 translate < 5.2,0,0> rotate<1,0,0> }
  object { watch_chain_link_2 translate < 5.2,0,0> rotate<2,0,0> }
  object { watch_chain_link_1 translate < 6.3,0,0> rotate<2,0,0> }
  object { watch_chain_link_2 translate < 6.3,0,0> rotate<3,0,0> }
  object { watch_chain_link_1 translate < 7.4,0,0> rotate<3,0,0> }
  object { watch_chain_link_2 translate < 7.4,0,0> rotate<4,0,0> }
  object { watch_chain_link_1 translate < 8.5,0,0> rotate<4,0,0> }
  object { watch_chain_link_2 translate < 8.5,0,0> rotate<5,0,0> }
  object { watch_chain_link_1 translate < 9.6,0,0> rotate<5,0,0> }
  object { watch_chain_link_2 translate < 9.6,0,0> rotate<6,0,0> }
  object { watch_chain_link_1 translate < 10.7,0,0> rotate<6,0,0> }
  object { watch_chain_link_2 translate < 10.7,0,0> rotate<7,0,0> }
  object { watch_chain_link_1 translate < 11.8,0,0> rotate<7,0,0> }
  object { watch_chain_link_2 translate < 11.8,0,0> rotate<8,0,0> }
  object { watch_chain_link_1 translate < 12.9,0,0> rotate<8,0,0> }
  object { watch_chain_link_2 translate < 12.9,0,0> rotate<9,0,0> }
  object { watch_chain_link_1 translate < 14.0,0,0> rotate<9,0,0> }
  object { watch_chain_link_2 translate < 14.0,0,0> rotate<10,0,0> }
  translate <0,0,0.15>
}

#declare WATCH = union {
  object { watch_chain }
  object { watch_inside }
  object { watch_body }
  texture { pigment { color rgb <0.8,0.7,0.7> } }
}
  
