//	Created by Ben Zelonka (zelonka@globalserve.on.ca)

//	---------------"Time Storm"---------------


#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "tardis.inc"
#include "spark.inc"
#include "spark2.inc"

object{light_source{<-1.5,-2,-5> color White}}
object{light_source{<-1200,500,-500> color White}}

camera{location <0,0,0>
	direction <0,0,.5>
	look_at <0,0,1>
	translate <0,0,0>}


#declare PinkAlabaster=texture{
	pigment{
	bozo
	turbulence 0.25
	color_map{
	[0, 1 color rgb <.9,.75,.75>
	color rgb <.6,.6,.6>]}
	scale 0.4}
	finish {ambient 0.25}}

texture{
	pigment{
	granite
	color_map{
	[0, 1 color DustyRose filter 1 color DustyRose filter 0.5]}
	scale 2}
	finish{
	specular 1
	roughness 0.0001
	phong 0.25
	phong_size 75
	brilliance 4}}


#declare HyperSpace2=texture{
	pigment{
	bozo
	color_map{
	[0.00 color rgb<0.800, 0.169, 0.090>]
	[0.04 color rgbf<0.800, 0.169, 0.090, 0.447>]
	[0.27 color rgbf<0.800, 0.169, 0.090, 0.804>]
	[0.27 color rgbf<0.800, 0.169, 0.090, 1.000>]
	[1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]}
	scale <1.0, 1.0, 7.0>}
	finish {ambient 1.0}}

union{
object {Tardis
	no_shadow
	scale <.75,.75,.75>}
union{
object {spark2
	scale <2,2,10>}
object {sphere{
	<0,0,0> .2
	pigment {rgb <.9,.9,1>}
	finish {Luminous}}}
	no_shadow
	rotate x*-100
	rotate z*-35
	translate <.4,1.7,0>}
object {spark
	no_shadow
	scale <3.5,3.5,.9>
	rotate x*-45
	rotate y*-90
	translate <.65,1.7,0>}
rotate y*135
rotate z*-10
rotate x*-25
translate <1.5,-.5,5.5>}

object {spark
	no_shadow
	scale <50,50,100>
	rotate z*-25
	translate <-15,-5,30>}

object {spark
	no_shadow
	scale <35,35,30>
	rotate x*-80
	rotate z*50
	translate <-27,0,30>}

object {spark
	no_shadow
	scale <50,50,50>
	rotate x*-70
	rotate z*-40
	translate <35,17,50>}

object {spark
	no_shadow
	scale <30,30,55>
	rotate x*20
	rotate y*15
	translate <-4.5,-20,17>}


difference{
object {cylinder{
	<0,0,0>
	<0,0,50> 15
	pigment {rgbf <1,1,1,1>}}}
object {cylinder{
	<0,0,-1>
	<0,0,51> 5}}
texture {HyperSpace2
	finish {ambient .8}
	scale <.75,.75,.5>
	rotate y*-35}
no_shadow
scale <1,1,5>
rotate z*90
translate <0,0,-10>}

object {sphere{
	<0,0,0> 20000
	texture{Apocalypse
	finish {ambient 1}
	scale <10000,10000,10000>}}}

object {sphere{
	<0,0,0> 19000
	texture{
	pigment{
	granite	color_map{
	[0.00 color rgb<0.275, 0.365, 0.565>]
	[0.16 color rgbf<0.275, 0.365, 0.565, 0.239>]
	[0.27 color rgbf<0.275, 0.365, 0.565, 1.000>]
	[1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]}
	scale <1.0, 1.0, 5.0>}
	finish { ambient 1.0 diffuse 1.0}
	rotate <0.0, 0.0, 0.0>
	scale <100000.0, 100000.0, 100000.0>
	rotate y*90}}}

union{
object {sphere{
	<0,0,0> 100
	pigment{
	image_map{gif "bigwld.gif" map_type 1}}
	finish {ambient .75}}}
object {sphere{
	<0,0,0> 101
	texture{Clouds scale <40,7,40>}
	finish {ambient .5}}}
	no_shadow
	scale <.95,1,.95>
	scale <2.25,2.25,2.25>
	rotate y*-160
	rotate z*-23
	rotate x*-25
	translate <-750,350,1500>}

#declare MinuteHand=
union{
object {cylinder{
	<0,0,-.6>
	<0,0,0> .75}}
object {box{
	<-.4,0,-.6>
	<.4,7,-.55>}}
object {cylinder{
	<0,5,-.6>
	<0,5,-.55> .65}}
object {cylinder{
	<0,0,-.6>
	<0,0,-.55> .6
	scale <1,3,1>
	translate <0,3,0>}}
difference{
object {cylinder{
	<0,0,-.6>
	<0,0,-.55> 1}}
object {box{
	<-2,-2,-2>
	<2,-.5,2>}}
object {box{
	<-2,-2,-2>
	<2,-.7,2>
	rotate z*-120}}
object {box{
	<-2,-2,-2>
	<2,-.7,2>
	rotate z*120}}
translate <0,7.25,0>}
bounded_by {box{
	<-.75,-.75,-.75>
	<.75,8.5,.25>}}
pigment {Black}}

#declare HourHand=
union{
object {cylinder{
	<0,0,-.7>
	<0,0,0> .7}}
object {box{
	<-.4,0,-.7>
	<.4,4,-.65>}}
object {cylinder{
	<0,0,-.6>
	<0,0,-.55> .6
	scale <1,2.5,1>
	translate <0,2,0>}}
difference{
object {cylinder{
	<0,0,-.6>
	<0,0,-.55> 1}}
object {box{
	<-2,-2,-2>
	<2,-.5,2>}}
object {box{
	<-2,-2,-2>
	<2,-.7,2>
	rotate z*-120}}
object {box{
	<-2,-2,-2>
	<2,-.7,2>
	rotate z*120}}
translate <0,4.25,0>}
bounded_by {box{
	<-.75,-.75,-.75>
	<.75,5.5,.25>}}
pigment {Black}}

#declare Face=union{
union{			//12
object {char_I
	translate <2,0,0>}
object {char_I
	translate <0,0,0>}
object {char_X
	translate <-4,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
translate <0,8.25,-.6>}

object {char_I		//1
	translate <0,0,0>
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*30
translate <0,8.25,-.6>
rotate z*-30}

union{			//2
object {char_I
	translate <-1,0,0>}
object {char_I
	translate <1,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*60
translate <0,8.25,-.6>
rotate z*-60}

union{			//3
object {char_I
	translate <-2,0,0>}
object {char_I
	translate <0,0,0>}
object {char_I
	translate <2,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*90
translate <0,8.25,-.6>
rotate z*-90}

union{			//4
object {char_I
	translate <-2,0,0>}
object {char_V
	translate <2,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*120
translate <0,8.25,-.6>
rotate z*-120}

object {char_V		//5
	translate <0,0,0>
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*150
translate <0,8.25,-.6>
rotate z*-150}

union{			//6
object {char_I
	translate <2,0,0>}
object {char_V
	translate <-2,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*180
translate <0,8.25,-.6>
rotate z*-180}

union{			//7
object {char_I
	translate <2,0,0>}
object {char_I
	translate <0,0,0>}
object {char_V
	translate <-4,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*210
translate <0,8.25,-.6>
rotate z*-210}

union{			//8
object {char_I
	translate <3,0,0>}
object {char_I
	translate <1,0,0>}
object {char_I
	translate <-1,0,0>}
object {char_V
	translate <-5,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*240
translate <0,8.25,-.6>
rotate z*-240}

union{			//9
object {char_I
	translate <-2,0,0>}
object {char_X
	translate <2,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*270
translate <0,8.25,-.6>
rotate z*-270}

object {char_X		//10
	translate <0,0,0>
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*300
translate <0,8.25,-.6>
rotate z*-300}

union{			//11
object {char_I
	translate <2,0,0>}
object {char_X
	translate <-2,0,0>}
translate <0,-2.5,0>
scale <.25,.25,1>
rotate z*330
translate <0,8.25,-.6>
rotate z*-330}}

#declare Mecanical=union{
object {cylinder{
	<0,0,-.5>
	<0,0,-.45> 10
	texture {PinkAlabaster
	scale <5,5,5>
	rotate z*-90}}}
difference{
object {cylinder{
	<0,0,-.65>
	<0,0,-.4> 10.25}}
object {cylinder{
	<0,0,-1>
	<0,0,-.45> 10}}
	texture {Chrome_Metal}}
object {Face}
bounded_by {cylinder{
	<0,0,-.75>
	<0,0,-.25> 10.5}}
pigment {Black}}

#declare SunDial=union{
union{
difference{
object {cylinder{
	<0,0,-.5>
	<0,0,.5> 10}}
object {Face}}
object {cylinder{
	<0,0,-.35>
	<0,0,.4> 9.9
	texture {Gold_Metal}}}
	no_shadow}
difference{
object {box{
	<-.5,0,0>
	<.5,10,-10>}}
object {box{
	<-2,-10,-10>
	<2,20,0>
	rotate x*50
	translate <0,0,-8>}}}
bounded_by {cylinder{
	<0,0,-11>
	<0,0,.75> 11}}
texture {White_Marble
	scale <5,5,5>}}

#declare LED=difference{
object {box{
	<-.25,-2,-.5>
	<.25,2,.5>}}
object {box{
	<-1,-.5,-1>
	<1,.5,1>
	rotate z*45
	translate <0,2,0>}}
object {box{
	<-1,-.5,-1>
	<1,.5,1>
	rotate z*-45
	translate <0,2,0>}}
object {box{
	<-1,-.5,-1>
	<1,.5,1>
	rotate z*45
	translate <0,-2,0>}}
object {box{
	<-1,-.5,-1>
	<1,.5,1>
	rotate z*-45
	translate <0,-2,0>}}
pigment {Red}
finish {ambient 1}}

#declare Digital=union{
object {box{
	<-15,-5,-.49>
	<15,5,.5>
	pigment {Black}}}
object {box{
	<-15,-5,-.55>
	<15,5,.5>
	texture {Glass2}}}
difference{
object {box{
	<-16,-6,-.75>
	<16,6,.55>}}
object {box{
	<-15,-5,-1>
	<15,5,.5>}}
texture {Chrome_Metal}}
union{
object {cylinder{
	<0,1.5,-.5>
	<0,1.5,.5> .4}}
object {cylinder{
	<0,-1.5,-.5>
	<0,-1.5,.5> .4}}
pigment {Red}
finish {ambient 1}}

union{
object {LED
	translate <1.5,-1.5,0>}
object {LED
	translate <-1.5,-1.5,0>}
object {LED
	translate <1.5,1.5,0>}
object {LED
	translate <-1.5,1.5,0>}
object {LED
	rotate z*90
	translate <0,-3,0>}
object {LED
	rotate z*90
	translate <0,0,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,3,0>}
translate <5,0,0>}
union{
object {LED
	translate <1.5,-1.5,0>}
object {LED
	translate <-1.5,-1.5,0>}
object {LED
	translate <1.5,1.5,0>}
object {LED
	translate <-1.5,1.5,0>}
object {LED
	rotate z*90
	translate <0,-3,0>}
object {LED
	rotate z*90
	translate <0,0,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,3,0>}
translate <10,0,0>}
union{
object {LED
	translate <1.5,-1.5,0>
	pigment {Black}}
object {LED
	translate <-1.5,-1.5,0>}
object {LED
	translate <1.5,1.5,0>}
object {LED
	translate <-1.5,1.5,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,-3,0>}
object {LED
	rotate z*90
	translate <0,0,0>}
object {LED
	rotate z*90
	translate <0,3,0>}
translate <-5,0,0>}
union{
object {LED
	translate <1.5,-1.5,0>}
object {LED
	translate <-1.5,-1.5,0>
	pigment {Black}}
object {LED
	translate <1.5,1.5,0>}
object {LED
	translate <-1.5,1.5,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,-3,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,0,0>
	pigment {Black}}
object {LED
	rotate z*90
	translate <0,3,0>
	pigment {Black}}
translate <-10,0,0>}

bounded_by {box{
	<-17,-7,-1>
	<17,7,1>}}}

#declare AlarmClock=
union{
object {cylinder{
	<0,0,-.5>
	<0,0,.5> 10
	pigment {White}}}
object {cylinder{
	<0,0,-.75>
	<0,0,-.7> 10
	texture {Glass2}}}
difference{
object {cylinder{
	<0,0,-.75>
	<0,0,7.5> 10.5}}
object {cylinder{
	<0,0,-1>
	<0,0,0> 10}}
object {cylinder{
	<-5,0,5>
	<-5,0,8> 1}}}

difference{
union{
object {cylinder{
	<0,0,-1>
	<0,0,1> .75}}
object {cylinder{
	<-1,-.25,1.5>
	<-1,.25,1.5> 1.5}}
object {cylinder{
	<1,-.25,1.5>
	<1,.25,1.5> 1.5}}
difference{
object {cylinder{
	<0,-.25,0>
	<0,.25,0> 1}}
object {box{
	<-2,-2,.5>
	<2,2,2>}}
object {box{
	<-2,-2,.7>
	<2,2,2>
	rotate z*-120}}
object {box{
	<-2,-2,.7>
	<2,2,2>
	rotate z*120}}
scale <2.5,1,1>
translate <0,0,1.5>}}
object {cylinder{
	<-1,-.5,1.5>
	<-1,.5,1.5> .6}}
object {cylinder{
	<1,-.5,1.5>
	<1,.5,1.5> .6}}
rotate z*-25			//key control
translate <-5,0,8>}

union{
object {cylinder{
	<0,9,0>
	<0,15.5,0> .5}}
difference{
object {sphere{
	<0,0,0> 4
	scale <1,.5,1>}}
object {sphere{
	<0,0,0> 4
	scale <1,.5,1>
	scale <.9,.9,.9>}}
object {cylinder{
	<0,-4,0>
	<0,-1.5,0> 5}}
translate <0,13,0>}
rotate z*-30
translate <0,0,3.45>}

union{
object {cylinder{
	<0,9,0>
	<0,15.5,0> .5}}
difference{
object {sphere{
	<0,0,0> 4
	scale <1,.5,1>}}
object {sphere{
	<0,0,0> 4
	scale <1,.5,1>
	scale <.9,.9,.9>}}
object {cylinder{
	<0,-4,0>
	<0,-1.5,0> 5}}
translate <0,13,0>}
rotate z*30
translate <0,0,3.45>}

object {cylinder{
	<0,-14,0>
	<0,-9,0> .5
	rotate z*30
	translate <0,0,0>}}
object {cylinder{
	<0,-14,0>
	<0,-9,0> .5
	rotate z*30
	translate <0,0,6.9>}}
object {cylinder{
	<0,-14,0>
	<0,-9,0> .5
	rotate z*-30
	translate <0,0,0>}}
object {cylinder{
	<0,-14,0>
	<0,-9,0> .5
	rotate z*-30
	translate <0,0,6.9>}}
object {sphere{
	<0,-14,0> .75
	rotate z*30
	translate <0,0,0>}}
object {sphere{
	<0,-14,0> .75
	rotate z*30
	translate <0,0,6.9>}}
object {sphere{
	<0,-14,0> .75
	rotate z*-30
	translate <0,0,0>}}
object {sphere{
	<0,-14,0> .75
	rotate z*-30
	translate <0,0,6.9>}}
object {Face
	pigment {Black}}
texture {Brass_Metal}

bounded_by {cylinder{
	<0,0,-1>
	<0,0,10.5> 18}}}


union{
object {HourHand
	rotate z*-60}
object {MinuteHand
	rotate z*3}
object {Mecanical
	no_shadow}
	rotate z*-5
	scale <1.05,1.05,1.05>
	rotate x*-20
	rotate y*70
	translate <17.5,5,35>}
object {SunDial
	scale <.5,.5,.5>
	rotate x*25
	rotate y*-10
	translate <2,10,30>}
object {Digital
	no_shadow
	scale <.35,.35,.35>
	rotate x*30
	rotate y*-55
	translate <-13,-2,20>}

union{
object {HourHand
	rotate z*140}
object {MinuteHand
	rotate z*180}
object {AlarmClock}
	scale <.02,.02,.02>
	rotate x*-20
	rotate y*30
	translate <0,-.5,3.5>}

union{
object {HourHand
	rotate z*0}
object {MinuteHand
	rotate z*0}
object {AlarmClock}
	scale <.02,.02,.02>
	rotate x*10
	rotate y*-55
	translate <3,1.5,5.5>}

union{
object {HourHand
	rotate z*60}
object {MinuteHand
	rotate z*-60}
object {AlarmClock}
	no_shadow
	scale <.02,.02,.02>
	rotate x*20
	rotate y*40
	translate <-.75,.75,2.25>}

union{
object {HourHand
	rotate z*-25}
object {MinuteHand
	rotate z*-90}
object {AlarmClock}
	scale <.02,.02,.02>
	rotate x*-40
	rotate y*-70
	translate <0,-1.5,1.5>}

union{
object {HourHand
	rotate z*125}
object {MinuteHand
	rotate z*90}
object {AlarmClock}
	no_shadow
	scale <.02,.02,.02>
	rotate x*-20
	rotate y*30
	translate <2,0,3.5>}

union{
object {HourHand
	rotate z*45}
object {MinuteHand
	rotate z*10}
object {AlarmClock}
	no_shadow
	scale <.02,.02,.02>
	rotate x*-0
	rotate y*-40
	translate <1,1.5,4>}

union{
object {HourHand
	rotate z*90}
object {MinuteHand
	rotate z*180}
object {AlarmClock}
	scale <.02,.02,.02>
	rotate x*-20
	rotate y*65
	translate <2.5,-2,4.75>}