//An Hourglass by Roland Vansteenkiste

#declare Sand=texture{
pigment{White}normal{dents 1 scale 0.1}
}

#declare Normal3 = //from the book Raytracing Worlds
   normal {bump_map {
           gif "8tiles8.gif"
           map_type 5
           bump_size 2
           interpolate 2
        }
   }

#declare Cap=object{
union{
     difference{cylinder {-2*y,2*y,12.5}
     torus { 13,0.7 }}
     torus { 12.5,0.5 translate -1.5*y}
     torus { 12.5,0.5 translate 1.5*y}
    }
}

#declare Post=object{
union{
    sphere {<0, 0, 0>, 2}
    cylinder {-24*y, 24*y, 1}
    torus {1,0.2 translate 1.8*y}
    torus {1,0.2 translate -1.8*y}
    torus {1,0.2 translate 3.8*y}
    cone  {4*y, 1.7, 10*y, 1.35}
    torus {1,0.2 translate -3.8*y}
    cone  {-4*y, 1.7, -10*y, 1.35}
    torus {1,0.2 translate 10.2*y}
    torus {1,0.2 translate -10.2*y}
    torus {1,0.2 translate 18.6*y}
    sphere {<0, 0, 0>, 1.8 translate 20.2*y}
    torus {1,0.2 translate -18.6*y}
    sphere {<0, 0, 0>, 1.8 translate -20.2*y}
    torus {1,0.2 translate 21.8*y}
    torus {1,0.2 translate -21.8*y}
    sphere {<0, 0, 0>, 1.8 translate 23.4*y}
    sphere {<0, 0, 0>, 1.8 translate -23.4*y}
    }
}

#declare Hglass=object{
        quartic {   //Lemniscate of Gerono
          < 1.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0, -1.0,
           0.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
           0.0,  0.0,  0.0,   0.0, 0.0,  1.0,  0.0,  0.0,  0.0,  0.0,
           0.0,  0.0,  1.0,   0.0, 0.0 >
         bounded_by {sphere {<0, 0, 0>, 2 }}
         sturm
          }
}

#declare Usand=object{
        intersection{object{Hglass}
                plane {x,0.5}
                plane {-x,0}
         }
}

#declare Dsand=object{
    union{
        intersection{
                object{Hglass}
                plane {x,-0.65}
         }
      quartic {   // a piriform
        < 0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.01,
        0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
        0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
        0.0,  0.0,  0.01, 0.0, -0.01 >
        sturm
        bounded_by { sphere { <0, 0, 0>, 2 } }
        rotate 90*z
        scale <0.25, 0.25, 0.34>
        clipped_by { plane{-x,0}}
        translate -0.67*x
        }
     }
}

#declare Ring=object{
      difference{
        sphere{ <0, 0, 0>   5 }
        object {Hglass rotate 90*z scale 24.3}
       }
}

#declare HourGlass=union{
object{Cap    texture{T_Gold_3C normal{Normal3 scale 4}} translate  26*y}
object{Cap    texture{T_Gold_3C normal{Normal3 scale 4}} translate -26*y}
object{Post   texture{T_Gold_3C} translate -13.5*x}
object{Post   texture{T_Gold_3C} translate -13.5*x rotate  90*y}
object{Post   texture{T_Gold_3C} translate -13.5*x rotate 180*y}
object{Post   texture{T_Gold_3C} translate -13.5*x rotate 270*y}
object{Ring   texture{T_Gold_3C normal{Normal3 scale 2.5}}}
object{Hglass texture{T_Glass4}  rotate 90*z scale 24.3}
object{Usand  rotate 90*z scale 22.3 texture{Sand}}
object{Dsand  rotate 90*z scale 22.3 texture{Sand}}
}



