#include "colors.inc"

camera
{
  location  <0.0 , 0.0 ,-12.0>
  sky y
  up y
  right 4/3*x
  look_at   0
}

sky_sphere{ pigment{ color White } }

#declare Word="UnaPover"

#declare Signature = union{

   #declare Count=0
   #while (Count < 9)
     #declare Letter=substr(Word ,Count, 1)
     text{ ttf "Timesi.ttf", Letter, 0.1, 0
       pigment{ color Red }
       scale 0.6
       translate <-0.2, 3.3, 0.0>
       rotate -z*Count*7
     }
     #declare Count=Count+1
   #end
   rotate z*28
 }

#declare Minutes = union{

   #declare Count=1
   #while (Count < 13)
     #declare Number=str(Count, 2, 0)
     text{ ttf "Mtcorsva.ttf", Number, 0.1, 0
       pigment{ color Black }
       scale 0.8
       translate -x*0.35
       rotate z*Count*30
       translate y*4.8
       rotate -z*Count*30
     }
     #declare Count=Count+1
   #end
   translate -y*0.3
 }


#declare Mark = triangle{ 0, <0.2, 0.3, 0>, <-0.2, 0.3, 0>
   pigment{ color Black }
   translate y*5.3
 }

#declare Tick = cylinder{ 0, <0, 0.4, 0>, 0.05
   pigment{ color Black }
   scale 0.5
   translate y*5.4
 }

#declare Markings = union{

   #declare Count=1
   #while (Count < 61)
     #if (mod(Count,5))
       object{ Tick rotate z*Count*6 }
     #else
       object{ Mark rotate z*Count*6 }
       #declare Second = str(Count, 2, 0)
       text{ ttf "ftltlt.ttf", Second, 0.1, 0
         pigment{ color Red }
         finish{ ambient 0.4 }
         scale 0.3
         translate <-0.15, 5.7, 0.0>
         rotate -z*Count*6
       }
     #end
     #declare Count=Count+1
   #end
 }

#declare Seconds = union{

   #declare Count=10
   #while (Count < 70)
     #declare Number=str(Count, 2, 0)
     text{ ttf "ftltlt.ttf", Number, 0.1, 0
       scale 0.5
       rotate z*Count*6
       translate y*1.2
       rotate -z*Count*6
     }
     #declare Count=Count+10
   #end

   #declare Count=1
   #while (Count < 61)
     #if (mod(Count, 10))
       cylinder{ 0, <0, 0.1, 0>, 0.01
         pigment{ color Black }
         translate y*1.5
         rotate z*Count*6
         translate <0.25, 0.2, 0.0>
       }
     #else
       cylinder{ 0, <0, 0.2, 0>, 0.01
         pigment{ color Black }
         translate y*1.5
         rotate z*Count*6
         translate <0.25, 0.2, 0.0>
       }
     #end
     #declare Count=Count+1
   #end

   disc{ <0.25, 0.2, 0.0>, z, 1.7, 1.68 }
   disc{ <0.25, 0.2, 0.0>, z, 1.6, 1.58 }

   pigment{ color Black }
   translate <-0.25, -3.9, -0.2>
 }



object{ Minutes }

union{
  object{ Seconds }
  disc{ <0, 0, -0.1>, z, 1.4
    pigment{ color White }
    finish{ ambient 1 }
    translate -y*4.1
  }
}

object{ Markings }

object{ Signature }
