// Persistence of Vision Ray Tracer Scene Description File
// Title: The 10:15
// File : watch.pov
// Vers : 3
// Desc : Pocket Watch for July 96 IRTC
// Date : 6/5/96
// Auth : John N. Miller

global_settings { assumed_gamma 1.8 }


//**********
// ***** Standard POV-Ray Includes
#include "glass.inc"
#include "golds.inc"
#include "colors.inc"

#declare MyGold = texture{ T_Gold_3C }

#include "RefObj.inc"

//**********
// ***** Camera & Lighting

camera{
  location  <3.0, 6.0 , -7.0>
//  location  <4.0, 5.5 , -7.0>
  right 4/3*x
  up y
  sky y
  look_at <0.5, 1.0, 0.1>
//  look_at <-0.5, 1.0, 0.5>
}

light_source{
  <10, 15, 25>
  color White
  spotlight
  point_at <1.0, 0.0, 0.5>
  radius 4.5
  falloff 12.0
}


//**********
// ***** Scene Objects

 // Floor
plane{ y, -0.652
  pigment{ rgb <1.0, 0.0, 0.2> }
  normal {
    wrinkles
    normal_map {
      [0.3  bumps scale 3]
      [0.6  dents scale 3]
      [0.9  marble turbulence 1.0]
    }
  }
  finish{ crand 0.3 ambient 0.2}
}

 // Glass Dome w/Brass bevel
  object{ Bevel }
  object{ GDome texture { T_Glass3 } }

  object{ Face }
  object{ Body }

   // Top Cover
  object{ Cover
    finish{ diffuse 0.3 }
    translate x*2.55
    rotate z*75
    translate -x*2.5
  }

   // Cover Hinge
  union{
    cylinder{ 0, z, 0.05 }
    cylinder{ -z*0.001, z*0.001, 0.015 pigment{ color Black } }
    torus{ 0.046, 0.005 pigment{ color Black } rotate x*90 translate z*0.25 }
    torus{ 0.046, 0.005 pigment{ color Black } rotate x*90 translate z*0.75 }

    texture{ MyGold }
    scale 1.5
    translate <-2.5,0,-0.75>
  }

   // Bottom Cover
  object{ Cover
    rotate z*180
    translate -y*0.452
  }

   // Winder and Ring
  object{ Winder scale 0.7 translate <2.5, -0.3, 0> }

   // Hour hand
  object{ Hand
    scale 0.24
    rotate y*86
    translate y*0.03
  }

   // Post
  union{
    disc{ 0, y, 0.13, 0.04 pigment{ color Black } translate y*0.03 }
    merge{
      cylinder{ 0, y*0.06, 0.04 }
      sphere{ 0, 0.04 translate y*0.06 }
      pigment{ color Grey }
      finish{ specular 0.3 }
    }
  }

   // Minuite hand
  object{ Hand
    scale 0.20
    rotate y*307
    translate y*0.02
  }

   // Second hand
  union{
    cylinder{ -z*0.25, z*0.3, 0.01 }
    cone{ 0, 0.01, z*0.1, 0 translate z*0.3 }
    disc{ 0, y, 0.03 translate -z*0.25 }
    disc{ 0, y, 0.05 }
    cylinder{ 0, y*0.03, 0.02 pigment{ color Grey } }
    pigment{ color Black }
    rotate y*225
    translate -z*1.4
  }

  object{ CurvedChain scale 0.3 rotate y*90 translate <4.1, -0.6, -1.4> }
  object{ StraightChain scale 0.3 rotate y*90 translate <4.95, -0.6, 1.55> }
  object{ StraightChain scale 0.3 rotate y*65 translate <3.7, -0.6, 4.3> }
  object{ ChainLatch scale 0.15 rotate <-10, 0.0, 25> translate <3.3, -0.6, -1.45> }
  object{ ButtonClip scale 0.3 translate <3.3, -0.63, 4.4> }
