/*

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "Stones.inc"
#include "Golds.inc"

camera {
	location <0,2000,-8000>
	look_at  <0,2000,0>
}

light_source {<2000,1000,-5000> color White}

*/

#declare Terrac =
texture{pigment{
granite
	color_map {
		[0.0 color <0.78,0.47,0.19>]
		[0.8 color <0.90,0.60,0.34>]
		[0.9 color <0.90,0.50,0.42>]
		[1.0 color <0.67,0.31,0.13>]
	}
	scale <5,12,5>
	turbulence .2
}}

#declare Trunk = color <0.62,0.47,0.38>

#declare Leaves =
texture{pigment{
granite
	color_map {
		[0.0 color <0.62,0.74,0.38>]
		[0.2 color <0.22,0.55,0.02>]
		[0.3 color <0.00,0.35,0.02>]
		[0.5 color <0.00,0.55,0.02>]
		[0.7 color <0.70,0.79,0.02>]
		[0.9 color <0.80,0.90,0.02>]
	}
	scale 10
}}

#declare Planter1 =
union {
difference {
	union {
		box {<300,0,300><-300,50,-300>}
		box {<275,50,275><-275,75,-275>}
		box {<250,75,250><-250,275,-250> pigment{color <1.00,0.81,0.74>}}
		box {<275,225,275><-275,250,-275>}
	}
	box {<190,50,190><-190,300,-190>}
}
box {<190,50,190><-190,225,-190> pigment {color <0.36,0.20,0.00>}}
}

#declare Tree_1 =
union {

object {Planter1 texture{Terrac}finish{phong 1}}
cylinder {<0,200,0><0,800,0>,25 pigment {Trunk}}
sphere {<0,1000,0>,300 texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

#declare Tree_arm =
union {
	cylinder {<0,0,0><0,200,0>,15 pigment{Trunk}}
	sphere {<0,300,0>,100 texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}
}

object {Tree_arm rotate <0,0,-30> translate <0,400,0>}
object {Tree_arm rotate <0,0,-30> translate <0,500,0> rotate<0,180,0>}
object {Tree_arm rotate <0,0,-40> translate <0,600,0> rotate <0,90,0>}
object {Tree_arm rotate <0,0,-40> translate <0,700,0> rotate <0,270,0>}

}

#declare Tree_2 =
union {

object {Planter1 texture{Terrac}finish{phong 1}}
cylinder {<0,200,0><0,800,0>,25 pigment {Trunk}}
box {<250,400,-250><-250,900,250> texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

}

#declare Tree_3 =
union {

#declare Tree_3part =
union {
	sphere {<0,0,0>,700}
	cone {<0,0,0>,700,<0,3000,0>,100}
	sphere {<0,3000,0>,100}
}

object {Tree_3part scale <.4,1,1> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Tree_3part scale <.4,1,1> rotate<0,90,0> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Tree_3part scale <.4,1,1> rotate<0,30,0> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Tree_3part scale <.4,1,1> rotate<0,60,0> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Tree_3part scale <.4,1,1> rotate<0,-30,0> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Tree_3part scale <.4,1,1> rotate<0,-60,0> translate <0,1000,0>
texture {Leaves}normal {wrinkles .75 scale<5,10,5>}finish {phong .75}}

object {Planter1 texture{Terrac}finish{phong 1}scale <1.5,1,1.5>}
cylinder {<0,200,0><0,800,0>,50 pigment {Trunk}}

}

#declare Pinnacle =
union {
difference {
	box {<600,0,600><-600,4000,-600> texture{T_Stone8 scale 500}}
	box {<600,-100,700><2000,10000,-700> rotate<0,0,5> texture{T_Stone8 scale 500}}
	box {<-600,-100,700><-2000,10000,-700> rotate<0,0,-5> texture{T_Stone8 scale 500}}
	box {<700,-100,600><-700,10000,2000> rotate<-5,0,0> texture{T_Stone8 scale 500}}
	box {<700,-100,-600><-700,10000,-2000> rotate<5,0,0> texture{T_Stone8 scale 500}}
}	

#declare Cap = 
difference {
	box {<250,0,250><-250,1000,-250> texture{T_Gold_3C}}
	box {<250,-100,700><2000,10000,-700> rotate<0,0,25> texture{T_Gold_3C}}
	box {<-250,-100,700><-2000,10000,-700> rotate<0,0,-25> texture{T_Gold_3C}}
	box {<700,-100,250><-700,10000,2000> rotate<-25,0,0> texture{T_Gold_3C}}
	box {<700,-100,-250><-700,10000,-2000> rotate<25,0,0> texture{T_Gold_3C}}
}

object {Cap translate<0,4000,0>}
sphere {<0,4800,0>,100 texture{T_Gold_3C}}
torus {200,20 rotate<90,0,0> translate<0,4800,0> texture{T_Gold_3C}}
torus {200,20 rotate<90,90,0> translate<0,4800,0> texture{T_Gold_3C}}

#declare Text_block =
union {
text{ ttf "Artistik.ttf" "n" 2 0 translate <0,0,-1>
	scale 1000 translate <-200,300,0> texture{T_Gold_3C}}
	
text{ ttf "Artistik.ttf" "z" 2 0 translate <0,0,-1>
	scale 1000 translate <-200,1000,0> texture{T_Gold_3C}}	

text{ ttf "Artistik.ttf" "s" 2 0 translate <0,0,-1>
	scale 1000 translate <-200,1700,0> texture{T_Gold_3C}}

text{ ttf "Artistik.ttf" "f" 2 0 translate <0,0,-1>
	scale 500 translate <-100,2400,0> texture{T_Gold_3C}}
	
text{ ttf "Artistik.ttf" "g" 2 0 translate <0,0,-1>
	scale 500 translate <-100,3100,0> texture{T_Gold_3C}}	
}

difference {
union {
	object{Text_block}
	object{Text_block rotate <0,90,0>}
}
	box {<601,-100,700><2000,10000,-700> rotate<0,0,5> texture{T_Gold_3C}}
	box {<-601,-100,700><-2000,10000,-700> rotate<0,0,-5> texture{T_Gold_3C}}
	box {<700,-100,601><-700,10000,2000> rotate<-5,0,0> texture{T_Gold_3C}}
	box {<700,-100,-601><-700,10000,-2000> rotate<5,0,0> texture{T_Gold_3C}}
}	

}


