// background { color red .5 green .8 blue 1 }

// camera {
//        location <0,0,-50>
//        look_at <0,0,0>
//        angle 30
// }

// light_source {<-50, 100, -200 > color White}

#declare wasp_texture=
texture {
        finish {
               ambient <0.3,0.25,.2>
               diffuse 0.7
               phong 0.5
               phong_size 40
               }
         normal {bumps 0.1 scale 0.3}
        }

#declare wasp_wing_texture=
texture {
        finish {
               irid {0.3
                    thickness 0.3
                    turbulence .6
                    }
               ambient 0.1
               diffuse 0.2
               reflection .25
               refraction 1
               ior 1.2
               specular 1
               roughness 0.001}
//               normal {bumps 0.1}
        pigment { rgbt <.3, .1, 0, 0.6>}
        }

#declare eyes_texture=
texture {
        finish {
               ambient 0.1
               diffuse 0.2
               reflection .3
               specular 1
               roughness 0.001}
        pigment { color rgb <.1, 0, 0>}
        }

#declare Glass=
texture {
    finish {ambient 0
            diffuse 0
            reflection .25
            refraction 1
            ior 1.45
//            phong .95
//            phong_size 230
            specular 1
            roughness 0.0007
            }
            normal {bumps 0.03 scale <70,30,100>}
    pigment { color rgbf <0.93, 0.97, 0.95, 0.98> }
//    pigment { color rgbf <0.2, 0.2, 0.2, 1> }
}

#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=2
#declare r=3.5
#declare RC=17
#declare A0=0
#declare n=1.05
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=12
#declare Countn=((Count+1)/2)
#declare body02=
blob{threshold 0.6
     cylinder {<0,0,0>,<-10,-10,0>,10,-5 scale<1,.1,1>translate<0,-2,0>}
     sphere {<0,0,0>,R,5 scale<.6,1,.6> rotate<0,0,A0> translate<XS,YS,0>}
        #while (Count>=1)
           #if (Count<=10)
           #declare n=.9
           #else
           #end
           #if (Count<=9)
           #declare n=.78
           #else
           #end
           #declare R=(R*n)
           #declare A=(A0+(2*asin(R/(RC*r))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,5 scale<.6,1,.6> rotate<0,0,AA> translate<X1,Y1,0>}
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
        rotate z*85
        scale <.55,1,.95>
                rotate z*-90
                rotate y*180
                rotate x*180
        texture {wasp_texture
                 pigment {
                         image_map {tga "ww.tga"
                         map_type 2
               } scale 4.9 translate y*.9}
           }

   }

#declare body01=
blob{threshold 0.6
     sphere {<0,0,0>,1.45,4 scale<1,1.4,.9> rotate z*25 translate<-.2,1.9,0>}
     cylinder {<0,0,0>,<-10,-10,0>,8,-5 scale<1,.1,1> rotate z*-13}
     texture {wasp_texture
             pigment {
                     image_map {tga "ww1.tga"
                               map_type 2
                               } scale 2.8 translate y*0.4}
             }
     }

#include "wasp01.inc"
#declare right_wings=
union{
      union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {<0,0,0>,1}
      rotate x*-10
      rotate y*15
      }
      union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {<0,0,0>,.9}
      rotate x*-5
      rotate y*10
      translate <0.025, -2.719, .4>
      }
      scale .16
      translate <.7,1.85,-1.2>
      texture {wasp_wing_texture}
      }
#declare left_wings=
union{
      union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {<0,0,0>,1}
      rotate x*10
      rotate y*165
      }
      union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {<0,0,0>,.9}
      rotate x*5
      rotate y*170
      translate <0.025, -2.719, .4>
      }
      scale .16
      translate <-.7,1.85,-1.2>
      texture {wasp_wing_texture}
      }

#declare Side= 1
#include "wasp02.inc"
#declare left_legs=
union{
      object {leg01 translate <0,-3,0>}
      object {leg02 rotate z*-10}
      object {leg03}
scale .18
translate <-.5,1.6,1.2>
          texture {wasp_texture
                  pigment {color rgb <.85,.7,0>}
                  }
       }

#declare Side= -1
#include "wasp02.inc"
#declare right_legs=
union{
      object {leg01 translate <0,-3,0>}
      object {leg02 rotate z*10}
      object {leg03}
scale .18
translate <.5,1.6,1.2>
          texture {wasp_texture
                  pigment {color rgb <.85,.7,0>}
                  }
       }

#declare head01=
blob{threshold 0.6
     cylinder {<-.65,0,0>,<.65,0,0>,1.5,4 scale<1,1,.6>}
     sphere {<0,0,0>,1.5,3 scale<1,1.1,.65> translate <0,-.4,0>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,2 scale<1.45,1,1> translate <0,.45,-.2>}
     sphere {<0,0,0>,.4,2 scale<.9,1,1> translate <-.17,-.69,-.4> rotate z*-30}
     sphere {<0,0,0>,.4,2 scale<.9,1,1> translate <.17,-.69,-.4> rotate z*30}
     sphere {<0,0,0>,.5,3 scale<1.5,1.3,1.1> translate <0,0.17,-.4>}
     sphere {<0,0,0>,.45,3 scale<1,1.1,1> translate <-.2,0.2,-.4> rotate z*10}
     sphere {<0,0,0>,.45,3 scale<1,1.1,1> translate <.2,0.2,-.4> rotate z*-10}
     sphere {<0,0,0>,.6,-4 scale<1,1,5> translate <0,-1.75,0>}
     sphere {<0,0,0>,.55,-4 scale<.7,1,5> translate <-.92,-1.25,0> rotate z*10}
     sphere {<0,0,0>,.55,-4 scale<.7,1,5> translate <.92,-1.25,0> rotate z*-10}
     }

#declare head02=
blob{threshold 0.6
     cylinder {<-.8,0,0>,<.8,0,0>,1.4,5 scale<1,.9,.6> translate <0,0,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<.9,1,10> translate <0,.7,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1,2,10> translate <0,0,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.1,1,10> translate <0,.1,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.2,1,10> translate <0,.2,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.25,1,10> translate <0,.32,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-4 scale<1.45,1,10> translate <0,.45,-.2>}
     cylinder {<0,0,0>,<0,1,0>,.5,-3 scale<2,1,10> translate <0,.4,-.2>}
     cylinder {<0,0,0>,<0,-2,0>,.6,-5 scale<2.2,1,15> translate <0,.4,-.2>}
     }

#declare head03=
difference {
blob{threshold 0.6
     cylinder {<-.65,0,0>,<.65,0,0>,1.5,4.2 scale<1,1,.6>}
     sphere {<0,0,0>,1.5,3.2 scale<.85,1,.7> translate <0,-.1,0>}
     sphere {<0,0,0>,1.5,3.2 scale<1,1.1,.65> translate <0,-.4,0>}
     sphere {<0,0,0>,.2,3 translate <0,-0.45,-.5>}
     sphere {<0,0,0>,.4,2 scale<.3,1.4,1> translate <0,-.6,-.4>}
     sphere {<0,0,0>,.4,2 scale<1.5,1,1> translate <0,-.7,-.4>}
     sphere {<0,0,0>,.42,-3 scale<1,1.1,1> translate <-.2,0.2,-.5> rotate z*10}
     sphere {<0,0,0>,.42,-3 scale<1,1.1,1> translate <.2,0.2,-.5> rotate z*-10}
     sphere {<0,0,0>,.50,-4 scale<.9,1.4,2> translate <-1.3,.2,-.5> rotate z*10}
     sphere {<0,0,0>,.50,-4 scale<.9,1.4,2> translate <1.3,0.2,-.5> rotate z*-10}
     sphere {<0,0,0>,.42,-2 scale<.9,1.05,2> translate <-.12,-.67,-.5> rotate z*-35}
     sphere {<0,0,0>,.42,-2 scale<.9,1.05,2> translate <.12,-.67,-.5> rotate z*35}
     sphere {<0,0,0>,.3,-2 scale<.5,1,2> translate <-.3,-.9,-.5> rotate z*-35}
     sphere {<0,0,0>,.3,-2 scale<.5,1,2> translate <.3,-.9,-.5> rotate z*35}
     sphere {<0,0,0>,1.5,-4 scale<2,1.1,10> translate <0,-2.2,0>}
     }
box { <5,-.95,-5><-5,-3,5>}
}

#declare head04=
difference{
    sphere {<0,0,0>,1 scale<.5,1,.5> rotate z*55 translate <-0.25,-1.3,0>}
    sphere {<0,0,0>,1.1 scale<.4,1.2,10> rotate z*5 translate <0.4,-.9,0>}
    texture {wasp_texture
            pigment {color rgb <.95,.82,0>}
            }
    }

#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=.3
#declare r=1.85
#declare RC=3
#declare A0=0
#declare n=1.1
#declare m=(1/n)
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=12
#declare Countn=((Count+1)/2)
#declare ant01=
blob{threshold 0.6
     cylinder {<XS,YS,0>,<XS,YS-1,0>,R*1.5,5 scale<.4,1,.4>}
     sphere {<0,0,0>,R,5 scale<.4,1,.4> rotate<0,0,A0> translate<XS,YS,0>}
        #while (Count>=1)
           #if (Count<Countn)
           #declare n=m
           #else
           #end
           #declare R=(R*n)
           #declare A=(A0+(2*asin(R/(RC*r))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,5 scale<.4,1,.4> rotate<0,0,AA> translate<X1,Y1,0>
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
           texture{ wasp_texture pigment { rgb <.1,0,0> }}
     }

#declare Head=
merge {
merge {
object {head01
        texture {wasp_texture
                pigment {color rgb <.95,.82,0>}
                 }
       }
object {head02
       rotate x*5
       texture {eyes_texture}}
object {head03
       texture {wasp_texture
               pigment {color rgb <.1,0,0>}
               }
       }
object {head04}
object {head04 scale<1,1,.9> rotate y*180 rotate z*-4 translate <0.1,.1,0>}
       scale <.8,1,1>
       rotate z*180 rotate x*90
}
object {ant01 translate <0,1,0> rotate y*70 rotate x*-45 rotate z*30 translate <-.5,.5,.2>}
object {ant01 translate <0,1,0> rotate y*110 rotate x*-45 rotate z*-30 translate <.5,.5,.2>}
}

#declare Wasp=
union {
object {body02 rotate y*-90}
object {body01 rotate y*-90}
object {right_wings}
object {left_wings}
object {left_legs}
object {right_legs}
object {Head scale 0.7 rotate x*10 translate <0,3.6,0.2>}
scale 2.3
}
// object {Wasp}
object {Wasp rotate y*180 rotate z*-130 rotate x*15 translate <9993, 6731, 1580>}
// object {Wasp rotate y*180 rotate z*30 rotate x*10 translate <9920, 7300, 1350>}
// object {Wasp rotate y*180 rotate z*30 rotate x*10 translate <10200, 6850, 1250>}
object {Wasp rotate y*100 rotate z*105 rotate x*-40 translate <10045, 6750, 1585>}
object {Wasp rotate y*175 rotate z*120 rotate x*-60 translate <10027, 6712, 1573>}

#declare wasp_light=
light_source {
    <10000, 6600, 1650 > color rgb <1,1,1>
    spotlight
    point_at <10000, 6725, 1570>
    tightness 10
    radius 15
    falloff 30
    fade_distance 100
    fade_power 1
}

object {wasp_light}

// box {<12000,8270,0><7205,8275,2115> texture{Glass}}

#declare steam=
sphere {<0,0,0>,1
    pigment { color rgbt <1,1,1,1> }
    halo {
          attenuating
          spherical_mapping
          linear
          turbulence 2
          color_map {
                    [ 0 color rgbt <.99, .99, 1, 1> ]
                    [ 1 color rgbt <.99, .99, 1, -1> ]
                    }
          frequency 2
          samples 20
          scale <.5,.5,.7>
          }
     hollow}
// object {steam scale <60,50,100> translate <10560,7770,1210>}

#declare TILE_TEXTURE = texture {
    finish {
        ambient 0.5
        diffuse 0.90
        phong 1.00
        phong_size 70
        reflection 0.4
    }
    normal {bumps 0.03 scale <30,20,40>}
    pigment { rgb <1, 1, 1> }
}

// #include "tiles01.inc"
 
#declare BACK1 = texture {
    finish {
        ambient 0.30
        diffuse 0.90
        phong 0.47
        phong_size 14.0
        
    }
    pigment { rgb <1.000, 0.863, 0.773> }
}

#declare TUBES = texture {
    finish {
           ambient 0.35
           brilliance 2
           diffuse 0.3
           metallic
           specular 0.80
           roughness 1/20
           reflection 0.1
           }
    pigment { rgb <0.678, 0.264, 0.490> }
    normal { bumps .5 scale 2 }
}

#declare FABRIC = texture {
    finish {
        ambient 0.40
        diffuse 0.90
        phong 0.2
        phong_size 10
    }
    pigment { rgb <0.678, 0.264, 0.490>}
    normal { bumps .5 scale .2 }
}

// #include "ch001.inc"
// #declare chair01=
// union{
// object {chair01}
// object {chair02}
// object {chair03}
// translate <-122.50,-70,0>
// }
// object {chair01
// scale 10
// rotate z*-103
// translate <10500,6700,0>}
