
// Persistence of Vision Ray Tracer Scene Description File
// File: angel.pov
// Vers: 3
// Desc: Angel in futureshock
// Date: 9 December 1996
// Auth: Mick McMullin
//

#include "angeltex.inc"
#include "body.inc"
#include "city.inc"

#version 3

global_settings
{
  assumed_gamma 1.0
  max_trace_level 20
}

// ----------------------------------------

camera
{
  ultra_wide_angle angle 30
  location  <0.0, 9, -25.0>
  direction 1.5*z
  right     4/3*x
  sky <0.2,1,0>
  look_at   <0, 3, 0>
  //aperture 0.1               // 0...N (bigger is narrower depth of field)
  //blur_samples 2             // # of rays per pixel
  //focal_point <0.64, 3.2, -1.6>       // x,y,z point that is in focus
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------



fog
{
  fog_type   1
  distance   50
  color      rgb 0.7
  fog_offset 0.1
  fog_alt    0.2
  turbulence 0.8
}

object { city scale 0.15 rotate <0, 20, 0> translate <0,-3,3> }


#declare angel = union {
         object { body }

         object { clothes }

         object { wings }
         rotate <0, 0, -30>
         scale 0.16
         }

object { angel translate <0.64, 3.2, -1.6> }

//object { angel rotate <0, 90, 0> translate <-1, 3.5, -1.6>}
