
// Persistence of Vision Ray Tracer Scene Description File
// File: body.inc
// Vers: 3
// Desc: Include file describing a human figure
// Date: 12 December 1996
// Auth: Mick McMullin
//

#version 3

// --------------------------------------------
// declare positions for the joints in the body
// --------------------------------------------
#declare head_angle = <0, 0, 50>
#declare head_position = <0, 4.78, 0>

#declare shoulder1_position = <1, 3.9, 0>
#declare shoulder2_position = <-1, 3.4, 0>

#declare neck_base = (shoulder1_position + shoulder2_position) / 2
#declare uppertorso_length = 1.9
#declare lowertorso_length = 1.7
#declare uppertorso_angle = <10, 0, 30>
#declare lowertorso_angle = <0, 0, 0>
#declare pelvis_angle = <0, 0, -30>
#declare pelvis_width = 1.5

#declare upperarm_length = 2.2
#declare upperarm1_angle = <30, 10, 100>
#declare upperarm2_angle = <40, 0, 40>

#declare lowerarm_length = 2
#declare lowerarm1_angle = <180, 0, 100>
#declare lowerarm2_angle = <180, 0, -10>

#declare wrist1_angle = <0, 0, -60>
#declare wrist2_angle = <0, 0, 80>

#declare tophand_length = 0.6
#declare fingertopA_length = 0.3   //index
#declare fingertopB_length = 0.35  //middle
#declare fingertopC_length = 0.3   //ring
#declare fingertopD_length = 0.25  //little
#declare fingertopE_length = 0.25  //thumb
/////////////////////////////////////-----
#declare fingermidA_length = 0.15  //index
#declare fingermidB_length = 0.2   //middle
#declare fingermidC_length = 0.15  //ring
#declare fingermidD_length = 0.1   //little
/////////////////////////////////////-----
#declare fingertipA_length = 0.1   //index
#declare fingertipB_length = 0.1   //middle
#declare fingertipC_length = 0.1   //ring
#declare fingertipD_length = 0.1   //little
#declare fingertipE_length = 0.1   //thumb

// finger angles (hand 1)
#declare fingertopA1_angle = <0, 0, 0>   //index
#declare fingertopB1_angle = <0, 0, 0>   //middle
#declare fingertopC1_angle = <0, 0, 0>   //ring
#declare fingertopD1_angle = <0, 0, 0>   //little
#declare fingertopE1_angle = <0, 0, 0>   //thumb
//////////////////////////////////////////-----
#declare fingermidA1_angle = <0, 0, 0>   //index
#declare fingermidB1_angle = <0, 0, 0>   //middle
#declare fingermidC1_angle = <0, 0, 0>   //ring
#declare fingermidD1_angle = <0, 0, 0>   //little
//////////////////////////////////////////-----
#declare fingertipA1_angle = <0, 0, 0>   //index
#declare fingertipB1_angle = <0, 0, 0>   //middle
#declare fingertipC1_angle = <0, 0, 0>   //ring
#declare fingertipD1_angle = <0, 0, 0>   //little
#declare fingertipE1_angle = <0, 0, 0>   //thumb

// finger angles (hand 2)
#declare fingertopA2_angle = <0, 0, 0>   //index
#declare fingertopB2_angle = <0, 0, 0>   //middle
#declare fingertopC2_angle = <0, 0, 0>   //ring
#declare fingertopD2_angle = <0, 0, 0>   //little
#declare fingertopE2_angle = <0, 0, 0>   //thumb
//////////////////////////////////////////-----
#declare fingermidA2_angle = <0, 0, 0>   //index
#declare fingermidB2_angle = <0, 0, 0>   //middle
#declare fingermidC2_angle = <0, 0, 0>   //ring
#declare fingermidD2_angle = <0, 0, 0>   //little
//////////////////////////////////////////-----
#declare fingertipA2_angle = <0, 0, 0>   //index
#declare fingertipB2_angle = <0, 0, 0>   //middle
#declare fingertipC2_angle = <0, 0, 0>   //ring
#declare fingertipD2_angle = <0, 0, 0>   //little
#declare fingertipE2_angle = <0, 0, 0>   //thumb


#declare upperleg_length = 3
#declare upperleg1_angle = <10, 0, -10>
#declare upperleg2_angle = <40, 0, 0>

#declare lowerleg_length = 2.5
#declare lowerleg1_angle = <5, 0, 0>
#declare lowerleg2_angle = <-20, 0, 5>

#declare ankle1_angle = <-90, 0, 10>
#declare ankle2_angle = <-90, 0, -10>

// --------------------------------------------
// calculate relative positions for the joints
// --------------------------------------------
#declare elbow1_position = vrotate(<0, -upperarm_length, 0>, upperarm1_angle)
                           + shoulder1_position
#declare elbow2_position = vrotate(<0, -upperarm_length, 0>, upperarm2_angle)
                           + shoulder2_position

#declare wrist1_position = vrotate(<0, -lowerarm_length, 0>, lowerarm1_angle)
                           + elbow1_position
#declare wrist2_position = vrotate(<0, -lowerarm_length, 0>, lowerarm2_angle)
                           + elbow2_position

#declare ribcage_base = vrotate(<0, -uppertorso_length, 0>, uppertorso_angle)
                           + neck_base

#declare pelvis_position = vrotate(<0, -lowertorso_length, 0>, lowertorso_angle)
                           + ribcage_base

#declare hip1_position = vrotate(<pelvis_width/2, 0, 0>, pelvis_angle) + pelvis_position
#declare hip2_position = vrotate(<-pelvis_width/2, 0, 0>, pelvis_angle) + pelvis_position

#declare knee1_position = vrotate(<0, -upperleg_length, 0>, upperleg1_angle)
                           + hip1_position
#declare knee2_position = vrotate(<0, -upperleg_length, 0>, upperleg2_angle)
                           + hip2_position

#declare ankle1_position = vrotate(<0, -lowerleg_length, 0>, lowerleg1_angle)
                           + knee1_position
#declare ankle2_position = vrotate(<0, -lowerleg_length, 0>, lowerleg2_angle)
                           + knee2_position


// --------------------------------------------
// declare the body parts
// --------------------------------------------
/*#declare head = sphere { <0, 0.75, 0>, 0.75
                       scale <0.66, 1, 1>
                       rotate head_angle
                       translate <0,-0.75,0>
                       translate head_position
                       }
*/
#include "head.inc"
#declare head = object { head
                         scale 0.16
                         rotate head_angle
                         translate <-0.4, -0.35, -0.1>
                         translate head_position
                        }

#declare shoulders = cylinder { shoulder1_position, shoulder2_position 0.3 }
#declare upper_torso = cylinder { neck_base, ribcage_base 0.8 }
#declare lower_torso = cylinder { ribcage_base, pelvis_position 0.6 }
#declare pelvis = cylinder { hip1_position, hip2_position 0.5 }

#declare upper_left_arm = cylinder { shoulder1_position, elbow1_position 0.3 }
#declare upper_right_arm = cylinder { shoulder2_position, elbow2_position 0.3 }
#declare lower_left_arm = cylinder { elbow1_position, wrist1_position 0.2 }
#declare lower_right_arm = cylinder { elbow2_position, wrist2_position 0.2 }
#declare left_hand = box { <-0.1, 0, -0.2>, <0.1, -1, 0.2> rotate wrist1_angle translate wrist1_position }
#declare right_hand = box { <-0.1, 0, -0.2>, <0.1, -1, 0.2> rotate wrist2_angle translate wrist2_position }

#declare upper_left_leg = cylinder { hip1_position, knee1_position 0.4 }
#declare upper_right_leg = cylinder { hip2_position, knee2_position 0.4 }
#declare lower_left_leg = cylinder { knee1_position, ankle1_position 0.35 }
#declare lower_right_leg = cylinder { knee2_position, ankle2_position 0.35 }
#declare left_foot = box { <-0.25, -0.5, -1>, <0.25, 0, 0.2>
                           rotate ankle1_angle translate ankle1_position }
#declare right_foot = box { <-0.25, -0.5, -1>, <0.25, 0, 0.2>
                           rotate ankle2_angle translate ankle2_position }


#declare left_foot = blob {
                          threshold 0.6

                          cylinder { <0.05, -0.25, 0.3>, <0.1, -0.25, -1.2>, 0.2, 1 }
                          cylinder { <0, -0.25, 0.3>, <0, -0.25, -1.22>, 0.2, 1 }
                          cylinder { <-0.05, -0.25, 0.3>, <-0.1, -0.25, -1.24>, 0.2, 1 }
                          cylinder { <-0.1, -0.25, 0.3>, <-0.2, -0.25, -1.26>, 0.2, 1 }
                          cylinder { <-0.15, -0.25, 0.3>, <-0.3, -0.25, -1.28>, 0.2, 1 }

                          rotate ankle1_angle translate ankle1_position
                          }

#declare right_foot = blob {
                          threshold 0.6

                          cylinder { <0.05, -0.25, 0.3>, <0.1, -0.25, -1.28>, 0.2, 1 }
                          cylinder { <0, -0.25, 0.3>, <0, -0.25, -1.26>, 0.2, 1 }
                          cylinder { <-0.05, -0.25, 0.3>, <-0.1, -0.25, -1.24>, 0.2, 1 }
                          cylinder { <-0.1, -0.25, 0.3>, <-0.2, -0.25, -1.24>, 0.2, 1 }
                          cylinder { <-0.15, -0.25, 0.3>, <-0.3, -0.25, -1.22>, 0.2, 1 }
                          rotate ankle2_angle translate ankle2_position
                          }


#declare main_body = blob {
                          threshold 0.6

                          #include "torso.inc"
                          //#include "armslegs.inc"
                          }

#declare limbs = blob {
                          threshold 0.6

                          #include "armslegs.inc"
                          }


#declare body = union {
                      object { head }
                      object { main_body }
                      object { limbs }

                      object { left_hand }
                      object { right_hand }

                      object { left_foot }
                      object { right_foot }

                      texture { skin_texture2 }
                      }




#declare clothes_layer1  = blob {
                          threshold 0.595

                          sphere { <0,0,0>, 1, -1 scale <0.4, 1, 1>
                                   rotate <50, 0, 0> translate neck_base }
                          #include "torso.inc"

                          sphere { <0,0,0>, 1, -1 scale <0.9, 2, 0.5>
                                   rotate <0,0,10>
                                   translate shoulder1_position + <0.3, 0, -0.3>}
                          sphere { <0,0,0>, 1, -1 scale <0.9, 2, 0.5>
                                   rotate <0,0,0>
                                   translate shoulder2_position + <-0.3, 0, -0.3>}

                          sphere { <0,0,0>, 1, -1 scale <0.9, 1.3, 1>
                                   rotate <30,10,10>
                                   translate hip1_position + <0.3, 0, 0.2>}
                          sphere { <0,0,0>, 1, -1 scale <0.9, 1.3, 1>
                                   rotate <30,0,40>
                                   translate hip2_position + <-0.6, 0, 0>}


                          texture { clothes_texture3 }
                         }

#declare dress_count = 0
#declare dress_rand  = seed (14)
#declare clothes_layer2  = union {
                                 #while (dress_count < 5)
                                 cone { ribcage_base, 1, knee1_position, 2 open
                                        rotate y * 30 * rand(dress_rand)
                                        texture { clothes_texture4
                                                  pigment { turbulence 1.5 * rand(dress_rand)}
                                                 }
                                        }
                                 cone { ribcage_base, 1, knee2_position, 2 open
                                        rotate y * 30 * rand(dress_rand)
                                        texture { clothes_texture4
                                                  pigment { turbulence 1.5 * rand(dress_rand)}
                                                 }
                                        }
                                 #declare dress_count = dress_count + 1
                                 #end
                                 }


#declare clothes = union {
                         object { clothes_layer1 }
                         object { clothes_layer2 }
                         }


#declare wings1 = union {
                         sphere { <5,0,0>, 5 scale <1,0.3,0.01> rotate <0,0,60>}
                         sphere { <5,0,0>, 5 scale <1,0.3,0.01> rotate <0,0,120>}

                         texture { wings1_texture }
                         translate <0,2,0>
                         }

#declare wings2 = union {
                         sphere { <4,0,0>, 4 scale <1,0.3,0.01> rotate <0,0,30>}
                         sphere { <4,0,0>, 4 scale <1,0.3,0.01> rotate <0,0,150>}

                         texture { wings2_texture }
                         translate <0,2,0>
                         }

#declare wings = union {
                       object { wings1 }
                       object { wings2 }
                       }
                       
