// Persistence of Vision Ray Tracer Scene Description File
// File: city.inc
// Vers: 3
// Desc: City include file
// Date: 9 December, 1996
// Auth: Mick McMullin

/////////////////////////////////
// Declare some random values
/////////////////////////////////
#declare city_rand1 = seed (3)
#declare city_rand2 = seed (24)


#declare ground = object { plane { y, 0 }
                         texture { ground_texture }
                         }

/////////////////////////////////
// Declare some buildings
/////////////////////////////////
#declare Count = 0
#declare building1 = union {
                           cylinder { <0, 0, 0> <0, 4, 0>, 1 }
                           difference { box { <-1.2, 0.2, -1.2> <1.2, 3.9, 1.2>}
                                            box { <-1.3, 0.5, -1> <-1.1, 3.5, 1>
                                                texture { building2_texture } }
                                            box { <1.1, 0.5, -1> <1.3, 3.5, 1>
                                                texture { building2_texture } }
                                            box { <-1, 0.5, -1.3> <1, 3.5, -1.1>
                                                texture { building2_texture } }
                                            box { <-1, 0.5, 1.1> <1, 3.5, 1.3>
                                                texture { building2_texture } }
                                      }
                           cylinder { <-30, 2, 0> <30, 2, 0>, 0.1 }
                           //texture { pigment { rgb <0.6, 0.3, 0>} }
                              texture { pigment { rgb 0.1} }
                           }


#while (Count < 5)
    #declare Count = Count + 1
    #declare building1 = union { object { building1 }
                                 object { building1
                                          translate y*4*Count rotate y*30*Count }
                               }
#end

/////////////////////////////////

#declare city_x = -70
#declare city_z = -70
#declare city_y = 0

#declare ground_buildings = union {
                              #while (city_z < 70)
                                 #while (city_x < 70)
                                     #declare city_y = 30*rand(city_rand1)
                                     object { box { <city_x, 0, city_z>
                                                    <city_x+3, city_y, city_z+3> }
                                            }
                                 #declare city_x = city_x + 10
                                 #end
                              #declare city_x = -70
                              #declare city_z = city_z + 10
                              #end
                              //texture { pigment { rgb 0.1} }
                              texture { building2_texture scale 0.05 }
                              }

#declare city_x = -100
#declare city_z = -100
#declare city_y = 0

#declare higher_buildings = union {
                              #while (city_z < 70)
                                 #while (city_x < 70)
                                     #declare city_y = 40*rand(city_rand1)
                                     object { box { <city_x, 0, city_z>
                                                    <city_x+1.5, city_y, city_z+1.5> }
                                            }
                                     object { box { <city_x, city_y, city_z>
                                                    <city_x+1.5, city_y+0.1, city_z+1.5>
                                                    texture { building1_mortar } }
                                            }
                                 #declare city_x = city_x + city_y
                                 #end
                              #declare city_x = -100
                              #declare city_z = city_z + city_y
                              #end
                              //texture { pigment { rgb 0.1} }
                              texture { building1_texture }
                              }


#declare city = union {
                      object { ground  }
                      object { building1 }
                      object { building1 translate <30, 0, 30> rotate y*10 }
                      object { building1 translate <-30, 0, 0> rotate y*20 }
                      object { ground_buildings }
                      object { higher_buildings }
                      }
