// herbe.inc
// Copyright Xavier Manget 1996

#declare NbBrins = 10000

#declare XMax=400
#declare YMax=200

#declare HautMoyenne=4

#declare DeltaZPointe=1.5
#declare DeltaRPointe=1.5


#declare LargBaseMoyenne=0.3
#declare DeltaLargBaseBase = 0.1

#declare R1 = seed(0)

#declare Herbe=mesh {

  #while (NbBrins > 0.1 )
    #declare Theta1 = 180*rand(R1)
    #declare Rnd = rand(R1)
    #declare X=XMax*Rnd*Rnd*cos(Theta1)
    #declare Y=YMax*Rnd*Rnd*sin(Theta1)
    #declare Theta2 = 360*rand(R1)
    #declare LargeurBase=LargBaseMoyenne + DeltaLargBaseBase * (rand(R1) - 0.5)
    #declare VarRPointe = DeltaRPointe * (rand(R1) - 0.5)
    triangle{ <X, Y, 0>,
              <X + LargeurBase*cos(Theta2), Y + LargeurBase*sin(Theta2), 0>,
              <X + VarRPointe*cos(Theta2), Y + VarRPointe*sin(Theta2), HautMoyenne + DeltaZPointe * (rand(R1) - 0.5)>
    }

    #declare NbBrins=NbBrins-1
  #end

}
