/*

File:
Description:  lower body defintions
Usage:

// vars used
color:

position:

*/

include "Foot01.inc"

static define rightFoot rightFoota { scale <0.25, 0.25, 0.25> }
static define leftFoot  leftFoota  { scale <0.25, 0.25, 0.25> }

//
// right Leg
//

static define knee01     object { raw "knee01.raw", smoothAngle  }

static define rightKnee  object { knee01 }
static define rightAnkle object { sphere <0,0,0>, 0.35 * 0.75  } // N/A
static define rightCalfa object { raw "mrcalf01.raw", smoothAngle  }

static define rCalfLen max( "rightCalfa")[1]
static define rightCalf
object {
    rightKnee { translate <0, rCalfLen, 0> }
  + rightAnkle
  + rightCalfa
  }

static define rightThigh  object {  raw "mrthih01.raw", smoothAngle  }
static define rThihLen    max( "rightThigh")[1]

static define rightLeg
object { rightThigh +
  object { rightCalf +
    object {
      rightFoot
      rotate rFootRot
      }
    translate <0, -rCalfLen, 0>  // translate kRCalfTran
    rotate rCalfRot
    }
  translate <0, -rThihLen, 0>    // translate kRThighTran
  rotate rThighRot
  }

//
// left Leg
//

static define leftKnee  object { knee01 }   // shiny_red
static define leftAnkle object {  sphere <0,0,0>, 0.35 * 0.75  } // N/A
static define leftCalfa object {  raw "mlcalf01.raw", smoothAngle  }

define lCalfLen max( "leftCalfa")[1]
static define leftCalf
object {
    leftKnee { translate <0, lCalfLen, 0> }
  + rightAnkle
  + leftCalfa
  }

static define leftThigh  object {  raw "mlthih01.raw", smoothAngle  }
define lThihLen max( "leftThigh")[1]

define leftLeg
object { leftThigh +
  object { leftCalf +
    object {
      leftFoot
      rotate lFootRot
      }
    translate <0, -lCalfLen, 0>  // translate kRCalfTran
    rotate lCalfRot
    }
  translate <0, -lThihLen, 0>    // translate kRThighTran
  rotate lThighRot
  }


define hipRad 0.75  // from bwtor01.inc
static define bodyLo1
object {
    rightLeg {
      translate < hipRad * 1.1, 0, 0>
      }
  + leftLeg {
      translate <-hipRad * 1.1, 0, 0>
      }
  }

