/*

File:
Description:  bird hand/claw version 1
Usage:

// vars used
color:
define texClaw matte_white

position:
define dfltFingerRot 20
*/

static define claw01a
object {
  raw "claw01.raw", 180   //  raw "claw.raw", 180
  rotate <0, -90, 0>

  translate <0, 1.5, 0>
  scale <1/2, 1/2, 1/2>
  }

static define claw01
object {
  claw01a
  translate <0, |min( "claw01a")[1]|, 0>
  }

static define fingerBone
object {
  raw "hand01a.raw", smoothAngle
  }

static define fingerLength max( "fingerBone")[1]

static define knuckleBone
object {
  raw "hand01b.raw", smoothAngle
  }

static define finger01a // fingerBone
object {
    knuckleBone // { shiny_green }
  + fingerBone
  + knuckleBone { scale <0.9,0.9,0.9> translate <0, fingerLength, 0> }
  }

static define aFinger1
object {
    claw01  { translate  <0, fingerLength, -0.25> texClaw }
  + finger01a   // { texToe }
  }

static define aFinger2  // thumb
object { finger01a {scale <0.9, 0.9, 0.9> } +
  object {
    aFinger1
    scale <0.8, 0.8, 0.8>
    rotate <dfltFingerRot, 0, 0>
    translate < 0, fingerLength*0.9, 0>
    }
  }

static define aFinger3
object {
  object { finger01a +
    object { finger01a {scale <0.9, 0.9, 0.9> } +
      object {
        aFinger1
        scale <0.8, 0.8, 0.8>
        rotate <dfltFingerRot, 0, 0>
        translate < 0, fingerLength*0.9, 0>
        }
      rotate <dfltFingerRot,0,0>
      translate < 0, fingerLength*1.0, 0>
      }
    rotate <dfltFingerRot,0,0>
    }
  }


static define rhand1a
object {
  raw "hand01c.raw", smoothAngle
  }
static define handLength max( "rhand1a")[1]

static define rightHand
object {
    aFinger2  // knuckleBone // thumb
      {
      scale <1, 1.0, 1.2>
      rotate < 0, 85,  0> rotate < 0,  0, 25> rotate <20,  0, 0>
      translate < -2.90, handLength * 0.50, 0.40>
      }
  + rhand1a // { translate <0, 0, -0.10> }

//  + knuckleBone { translate <0, handLength, 0> }
//  + knuckleBone { rotate < 5, 0,  10> translate <-1.75, handLength, 0> }
//  + knuckleBone { rotate <10, 0, -10> translate < 1.75, handLength, 0> }

  + aFinger3 { translate <0, handLength, 0.15> }
  + aFinger3 { rotate < 5, 0,  10> translate <-1.75, handLength, 0.15> }
  + aFinger3 { rotate <10, 0, -10> translate < 1.75, handLength, 0.15> }

  // rotate into proper 'upper body part' orientation
  rotate <180, 0, 0>
  }

//
// left hand
//
static define lhand1a
object {
  raw "hand01c.raw", smoothAngle
  }

// redefine handLength - in case we define two different sized hands
static define handLength max( "lhand1a")[1]

static define leftHand
object {
    aFinger2  // knuckleBone // thumb
      {
      scale <1, 1.0, 1.2>
      rotate < 0, -85, 0> rotate < 0, 0, -25> rotate <20, 0, 0>
      translate <  2.90, handLength * 0.50, 0.40>
      }
  + lhand1a // { translate <0, 0, -0.10> }

//  + knuckleBone { translate <0, handLength, 0> }
//  + knuckleBone { rotate < 5, 0,  10> translate <-1.75, handLength, 0> }
//  + knuckleBone { rotate <10, 0, -10> translate < 1.75, handLength, 0> }

  + aFinger3 { translate <0, handLength, 0.15> }
  + aFinger3 { rotate < 5, 0,  10> translate <-1.75, handLength, 0.15> }
  + aFinger3 { rotate <10, 0, -10> translate < 1.75, handLength, 0.15> }

  // rotate into proper 'upper body part' orientation
  rotate <180, 0, 0>
  }

