
// additional colors - translated from POV-Ray (dke)

static define Black           < 0.0,  0.0,  0.0  >

static define SummerSky       < 0.22, 0.69, 0.87 >
static define RichBlue        < 0.35, 0.35, 0.67 >
static define Brass           < 0.71, 0.65, 0.26 >
static define Copper          < 0.72, 0.45, 0.20 >
static define Bronze          < 0.55, 0.47, 0.14 >
static define Bronze2         < 0.65, 0.49, 0.24 >
static define Silver          < 0.90, 0.91, 0.98 >
static define BrightGold      < 0.85, 0.85, 0.10 >
static define OldGold         < 0.81, 0.71, 0.23 >
static define Feldspar        < 0.82, 0.57, 0.46 >
static define Quartz          < 0.85, 0.85, 0.95 >
static define Mica            Black                 // needed in textures.inc
static define NeonPink        < 1.00, 0.43, 0.78 >
static define DarkPurple      < 0.53, 0.12, 0.47 >
static define NeonBlue        < 0.30, 0.30, 1.00 >
static define CoolCopper      < 0.85, 0.53, 0.10 >
static define MandarinOrange  < 0.89, 0.47, 0.20 >
static define LightWood       < 0.91, 0.76, 0.65 >
static define MediumWood      < 0.65, 0.50, 0.39 >
static define DarkWood        < 0.52, 0.37, 0.26 >
static define SpicyPink       < 1.00, 0.11, 0.68 >
static define SemiSweetChoc   < 0.42, 0.26, 0.15 >
static define BakersChoc      < 0.36, 0.20, 0.09 >
static define Flesh           < 0.96, 0.80, 0.69 >
static define NewTan          < 0.92, 0.78, 0.62 >
static define NewMidnightBlue < 0.00, 0.00, 0.61 >
static define VeryDarkBrown   < 0.35, 0.16, 0.14 >
static define DarkBrown       < 0.36, 0.25, 0.20 >
static define DarkTan         < 0.59, 0.41, 0.31 >
static define Copper          < 0.32, 0.49, 0.46 >
static define DkGreenCopper   < 0.29, 0.46, 0.43 >
static define DustyRose       < 0.52, 0.39, 0.39 >
static define HuntersGreen    < 0.13, 0.37, 0.31 >
static define Scarlet         < 0.55, 0.09, 0.09 >

//
// Start of DKE stuff
//

/*
define cement
texture {
   special matte {
      color 1.0 * Gray
      normal N + (dnoise(3*P, 4) - <0.0, 0.0, 0.0>)
      }
   }
*/

/*
static define sColor_map
   color_map([0, 0.8, <1, 0.6, 0.1>, <0, 0.3, 0>]
             [0.8, 1, <0.1, 0.5, 0.1>, <0, 0, 0.3>])

static define sColor_map
   color_map([0, 0.3,   Steel_blue, DarkSlateGray ]
             [0.3, 0.8, DarkOliveGreen, Tan]
             [0.8, 1,   DarkSlateGray, DimGrey])

static define sColor
texture { special matte { color sColor_map[marble_fn] } }
//texture { special shiny { color sColor_map[marble_fn] } }
*/


static define dented
surface { normal N + (dnoise( 10*P) - <0.5, 0.5, 0.5>) }

static define dented_white texture { special dented { color white } }
static define dented_grey texture { special dented { color grey } }
static define dented_black texture { special dented { color dark_slate_gray } }
static define dented_red texture { special dented { color red } }
static define dented_blue texture { special dented { color blue } }
static define dented_green texture { special dented { color green } }
static define dented_cyan texture { special dented { color cyan } }
static define dented_yellow texture { special dented { color yellow } }
static define dented_magenta texture { special dented { color magenta } }
static define dented_orange texture { special dented { color orange } }
static define dented_aquamarine texture { special dented { color aquamarine } }
static define dented_brown texture { special dented { color brown } }


static define army_map1
   color_map([0, 0.8, <0.8, 1.0, 0.8>, Khaki]
             [0.8, 1, Khaki, DarkOliveGreen])

static define army_marble1
texture { special shiny { color army_map1[marble_fn] } }

static define fire_map1
   color_map([0, 0.5, <1, 1.0, 0.0>, <0.4, 0.4, 0.0>]
             [0.5, 1, <0.4, 0.4, 0>, <1, 0.1, 0.1>])

static define bright
surface {
  ambient 0.5
  diffuse 0.7
  }

static define brightShiny
surface {
  ambient 0.5
  diffuse 0.7
  specular white, 0.6
  microfacet Phong 7
  }

static define bsDented // bright_shiny_dented
surface {
  ambient 0.6  // 0.1
  diffuse 0.6
  specular white, 0.6
  microfacet Phong 7
  normal N + (dnoise( 10*P) - <0.5, 0.5, 0.5>)
  }

static define kwhite_marble_map
   color_map([0, 0.8, white, 0.5*white]
             [0.8, 1, 0.5*white, 0.2*white])

static define kred_marble_map
   color_map([0, 0.8, <1, 0.8, 0.8>, <1, 0.4, 0.4>]
             [0.8, 1, <1, 0.4, 0.4>, <1, 0.1, 0.1>])

static define kgreen_marble_map
   color_map([0, 0.8, <0.8, 1, 0.8>, <0.4, 1, 0.4>]
             [0.8, 1, <0.4, 1, 0.4>, <0.1, 1, 0.1>])

static define kblue_marble_map
   color_map([0, 0.8, <0.8, 0.8, 1>, <0.4, 0.4, 1>]
             [0.8, 1, <0.4, 0.4, 1>, <0.1, 0.1, 1>])

static define kblack_marble_map
   color_map([0, 0.8, black, Gray]
             [0.8, 1, 0.5*white, 0.9*white])

static define kwhite_marble
texture { special shiny { color   kwhite_marble_map[ marble_fn ] } }

static define kred_marble
texture { special shiny { color   kred_marble_map[ marble_fn ] } }

static define kgreen_marble
texture { special shiny { color   kgreen_marble_map[ marble_fn ] } }

static define kblue_marble
texture { special shiny { color   kblue_marble_map[ marble_fn ] } }

static define kblack_marble
texture { special shiny { color   kblack_marble_map[ marble_fn ] } }


static define shiny_black texture { shiny { color Black } }

define kBlack <1/255, 1/255, 1/255>
define shiny_kBlack texture { shiny { color kBlack } }

define surFishnet
  surface {
    color (    ramp( (1 - u + v) * 10  ) > 0.85
            || ramp( (    u + v) * 10  ) > 0.85
            ? kBlack   // Red
            : Flesh  // Green
          )
    }

define texFishnet texture { special surFishnet }
define Desert (Wheat + Tan) / 2

define Black2 <1/255, 1/255, 1/255>
