/*

File:
Description:  bird wing version 1
Usage:

// vars used
color:
texClaw  - texture for the actual claw  (matte_white)
texToe   - texture for the skin/foot    (matte_green)

define texClaw matte_white
define texToe  dented_green  // matte_green

position:

*/

define ribRadius 0.0100
static define aRibA
object {
  cone <0,0,0>, ribRadius, <0, 0.850, 0>, ribRadius
  translate <0, -0.850, 0>
  rotate < 90, 0,0>
  }

static define wingClaw  // should use a finger/claw or toe
object {
  sphere <0,0,0>, ribRadius*1
  scale <1,1,1.5>
  }

static define aRibB aRibA

static define aWingB  object { raw "wing01.raw", smoothAngle }

static define aWing
object {
    aWingB { rotate <0,  53, 0> }
  + aWingB
  + aWingB { rotate <0, -53, 0> }
  + aRibA  { rotate <0,  79.50, 0> }
  + aRibB  { rotate <0,  26.50, 0> }
  + aRibB  { rotate <0, -26.50, 0> }
  + aRibB  { rotate <0, -(79.5), 0> }
  + wingClaw
  }

define wingMax max( "aWing")
define wingMin min( "aWing")
define wingCenter wingMax - wingMin /2
static define rightWing
object {
  aWing
  rotate <0,0, 15> rotate <0, -45, 0>
  translate <|wingMin[0]*0.25|, 0, |wingMin[2]|*0.25 >
  }

static define leftWing
object {
  aWing
  rotate <0,0, -15> rotate <0, 45, 0>
  translate <-|wingMin[0]*0.25|, 0, |wingMin[2]|*0.25 >
  }

static define tWings
object {
    rightWing
  + leftWing
//    aWing { rotate <0,0, 15> rotate <0, -45, 0> translate <wingCenter[0]+0, 0,0> }
//  + aWing { rotate <0,0,-15> rotate <0,  45, 0> translate <-(wingCenter[0]+0), 0,0> }
  }

