

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Bumble Bee
// Date: 12/8/96
// Auth: Benny Wilkie wilkie@intplsrv.net


//to get your include files you must have the program orb-cyl. Available from:
//               --John Beale  beale@best.com  3/24/96
//                    http://www.best.com/~beale/
//Then use the following commands to generate the include files... the files are BIG!
//the command for fuzz.inc is:  orb fuzz.gif fuzz.inc .3  8
//(this makes a 12 Megabyte include file)
//the command for cylfuzz.inc is: cyl fuzz.gif cylfuzz.inc 1 2 10   100 50
//the command for compound.inc is: orb compound.gif compound.inc .1 8
//the command for headfuzz.gif is: orb fuzz.gif headfuzz.inc .1 7

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "skies.inc"



global_settings { assumed_gamma 1.0 }



camera
{
  location    <0.0 , 5 ,-32.0>     
    look_at   <0 , 0.0 , 0.0>
}
//*********************************Sky********************************

sky_sphere { S_Cloud2 }

//********************************Ground******************************

union{
height_field
{
  gif              
  "grass1.gif"     
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate x*9999
}
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate x*-9999
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
translate x*-9999
}
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { MediumForestGreen }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
translate x*9999
}
rotate x*-3.2
}

//***********************

union{
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna}}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate x*9999
}
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate x*-9999
}

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
translate x*-9999
}
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass1.gif"     // the file name to read
   texture {pigment { Sienna }}
    translate <-0.5, 0, -0.1>
scale <10000, 1000, 10000>
translate y*-1100
translate z*9999
translate x*9999
}
translate <-5, -1, -5>
rotate x*-3
}
//*******************************************************************


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-10, 20, -40>
}

//*************************Petal************************************
#declare Petal=

union{
difference{

// SPHERE _sphere1
sphere {  < 0, 0, 0 > 1
 texture { pigment { color White  } }
finish { reflection 0.13}

  }

 sphere {  < 0, 0, 0 > 1
 texture { pigment { color White  } }
finish { reflection 0.13}
 scale  < .99, .99, .99 >
  }



box
{
  <-1.5, -1.5, -1>  // one corner position <X1 Y1 Z1>
  < 1.5,  1.5,  1>  // other corner position <X2 Y2 Z2>
  translate z*-1
  texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
}

} //end 1st difference


difference{
union{
torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*20
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*40
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*60
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*80
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*100
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*120
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*140
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*160
}

torus {1, .02
texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
rotate z*90
rotate y*180
}

}//end union
box
{
  <-2, -2, -1>  // one corner position <X1 Y1 Z1>
  < 2,  2,  1>  // other corner position <X2 Y2 Z2>
  translate z*-1
  texture { pigment { color NeonPink  } }
 finish {phong 1 phong_size 300 reflection 0.13}
}
}//end of 2nd difference


scale <1, 2 .5>
rotate <-5, 0, 0>
translate <0, 3, 0>

}

//******************************************************************

#declare Eye =
mesh {
 #include "compound.inc"
rotate <-90, 90, 0>
}

#declare Headfuzz =
mesh {
 #include "headfuzz.inc"

}

#declare Fuzz =
mesh {
 #include "fuzz.inc"
}

#declare Cyl1 =
 mesh  {
  #include "cylfuzz.inc"
  translate <-.5, 0, -5>
  rotate <90, 0, 0>
 }

 //*****************************************************************************
union{
// ********************************BUMBLE BEE*********************************
union{
//**********************************THORAX**************************************
difference{
object {
  Fuzz
  texture {  pigment {Yellow}  }
  scale  < 3.5, 4, 5 >
 translate  < -0.5, 0, 0 >
 }
sphere{ < 0, 0, 0 > 1
translate <-2, 0, 0>
scale <3.5, 3.5, 3.5>
}}

 //******************this is the hump on the bees thorax********************

object {
Fuzz
texture { pigment { color Black } }
 scale  < 2.5, 2, 4>
 translate  < -1, 3, 0 >
 }

//************************************ABDOMEN**********************************

object {
  Fuzz
  texture {  pigment {Black}  }
  scale  < 1, 3.8, 4.8 >
 rotate  < 0, 0, -5 >
 translate  < 2.125, -0.46875, 0.0625 >
 }

object {
  Fuzz
  texture {  pigment {Yellow}  }
  scale  < 1, 3.7, 4.8 >
 rotate  < 0, 0, -10 >
 translate  < 3.375, -0.78125, 0.0625 >
 }


object {
  Fuzz
  texture {  pigment {Black}  }
 scale  < 1, 3.6, 4.7 >
 rotate  < 0, 0, -20 >
 translate  < 4.625, -1.21875, 0.0625 >
 }


object {
  Fuzz
  texture {  pigment {Yellow}  }
scale  < 1, 3.5, 4.6 >
 rotate  < 0, 0, -30 >
 translate  < 5.625, -1.84375, 0.0625 >
 }


object {
  Fuzz
  texture {  pigment {Black}  }
 scale  < 1.7, 3, 4 >
 rotate  < 0, 0, -40 >
 translate  < 6.9375, -2.71875, 0.03125 >
 }

//********************************REAR LEGS**********************************************
union{
object {
  Cyl1
  texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 rotate  < 60, 20, 0 >
 translate  < 1.0225, -2.40625, 3.75 >
 }

object {
  Cyl1
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 rotate  < -60, -20, 0 >
 translate  < 1.0625, -2.15625, -3.6875 >
 }

object {
  Cyl1
 texture { pigment { color Black } }
 scale  < 0.4, 0.3, 0.3 >
 rotate  < 40, -10, 0 >
 translate  < 1.6875, -2.63451, -6.24728 >
 }

object {
  Cyl1
 texture { pigment { color Black } }
 scale  < 0.4, 0.3, 0.3 >
 rotate  < -30, -15, 0 >
 translate  < 1.2475, -2.94118, 6.08605 >
 }

object {
  Cyl1
 texture { pigment { color Black } }
 scale  < 0.2, 0.15, 0.3 >
 rotate  < -30, 40, 20 >
 translate  < 1.68652, -4.90773, 7.23702 >
 }

object {
  Cyl1
  texture { pigment { color Black } }
 scale  < 0.2, 0.15, 0.3 >
 rotate  < 30, 60, 60 >
 translate  < 2.435, -4.56022, -7.50814 >
 }

object {
  Fuzz
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 1.4625, -1.52941, 5.17927 >
 }

object {
 Fuzz
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 1.525, -1.29412, -5.11852 >
 }

object {
  Fuzz
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 1.11931, -4.26, 6.87603 >
 }

object {
  Fuzz
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 1.89448, -3.86, -7.29639 >
 }

object {
  Fuzz
 texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 2.20772, -5.44, 7.54244 >
  }

  object {
    Fuzz
    texture { pigment { color Black } }
 scale  < 0.3, 0.3, 0.3 >
 translate  < 2.87554, -5.16, -7.69029 >
    }

    // CONE _cone0
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.25, 1, 0.25 >
 rotate  < -160, -60, 0 >
 translate  < 3.19826, -6.17235, -7.88363 >
 }


// CONE _cone0_8
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.25, 1, 0.25 >
 rotate  < 150, 80, 0 >
 translate  < 2.68522, -6.43706, 7.63683 >
 }




// SPHERE _sphere8
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Orange } }
 normal {bumps .3}
   translate  < 1.25287, -2.93205, 6.15142 >
 }


// SPHERE _sphere8_11
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Orange } }
 normal {bumps .3}
  translate  < 1.64687, -2.4929, -6.22331 >
 }

// CONE _cone2
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -90 >
 translate  < 3.41379, -5.625, -7.8125 >
 }


// CONE _cone2_0
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -90 >
 translate  < 3.46552, -5.94612, -7.875 >
 }


// CONE _cone2_1
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -90 >
 translate  < 3.53448, -6.2694, -7.9375 >
 }


// CONE _cone2_2
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -70 >
 translate  < 2.74138, -5.88362, 7.5625 >
 }


// CONE _cone2_3
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -70 >
 translate  < 2.89655, -6.25, 7.625 >
 }


// CONE _cone2_3_4
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -70 >
 translate  < 3.08621, -6.50862, 7.625 >
 }

translate <0, -1.85, 0>
scale <1.1, 1.1, 1.1>
}


// ***********************************FRONT LEGS***************************************

union{

 object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -60, 5, 0 >
 translate  < -0.696759, -2.15625, -3.29861 >
   }

   object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -120, 20, 0 >
 translate  < -1.09587, -2.10453, -5.11342 >
   }

   object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.16, 0.16, 0.16 >
 rotate  < 40, 30, 0 >
 translate  < -1.68079, -3.29418, -6.53935 >
   }

   object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -60, 160, 0 >
 translate  < -0.976268, -2.24246, 3.2519 >
   }

   object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -120, 180, 0 >
 translate  < -1.31535, -2.19074, 5.02968 >
   }

   object {
   Cyl1
   texture { pigment { color Black } }
 scale  < 0.16, 0.16, 0.16 >
 rotate  < 40, 210, 0 >
 translate  < -0.992232, -3.38039, 6.56672 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 translate  < -0.787261, -1.60446, -4.24815 >
   }

    object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 translate  < -1.39071, -2.65619, -5.95185 >
   }

    object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 translate  < -1.92519, -4.0355, -6.8963 >
   }

    object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 0, 180, 0 >
 translate  < -1.29317, -1.69067, 4.12737 >
   }

    object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 0, 180, 0 >
 translate  < -1.28232, -2.7424, 5.97922 >
   }

    object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 0, 180, 0 >
 translate  < -0.673765, -4.12171, 7.10885 >
   }


   // CONE _cone0_8_1
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.16, 0.6, 0.16 >
 rotate  < 150, 80, -15 >
 translate  < -1.77864, -4.59223, -6.88169 >
 }

// CONE _cone2_2_3
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -70 >
 translate  < -1.53384, -4.28017, -6.91898 >
 }

// CONE _cone2_2_3_4
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 0, -70 >
 translate  < -1.47957, -4.60776, -6.91898 >
 }

 // CONE _cone0_8_1_5
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.16, 0.6, 0.16 >
 rotate  < 150, 440, -15 >
 translate  < -0.520894, -4.7474, 7.20416 >
 }

// CONE _cone2_2_3_5
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 360, -70 >
 translate  < -0.315692, -4.36638, 7.12983 >
 }


// CONE _cone2_2_3_4_5
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 0, 360, -70 >
 translate  < -0.263968, -4.65948, 7.12983 >
 }
translate <-.75, -1.2, 0>
scale <1.1, 1.1, 1.1>
}



//*********************************MIDDLE LEGS************************************

union{
object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -60, 5, 0 >
 translate  < 0.199793, -2.22522, -3.29861 >
}

object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -120, -20, 0 >
 translate  < 0.400682, -2.1735, -5.11342 >
}

object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.16, 0.16, 0.16 >
 rotate  < 40, 30, 0 >
 translate  < 0.415762, -3.30065, -6.55685 >
}

object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -60, 160, 0 >
 translate  < -0.0797161, -2.31143, 3.2519 >
}

object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -100, 180, 0 >
 translate  < -0.418798, -1.88471, 5.15468 >
}

object{
Cyl1
texture { pigment { color Black } }
 scale  < 0.16, 0.16, 0.16 >
 rotate  < 110, 0, 0 >
 translate  < -0.391976, -2.44936, 7.02968 >
}

 object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 translate  < 0.109291, -1.67343, -4.24815 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 translate  < 0.705842, -2.72516, -6.03185 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 40, 0, 0 >
 translate  < 0.171361, -4.08885, -7.11326 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 0, 180, 0 >
 translate  < -0.396618, -1.75964, 4.12737 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < 0, 180, 0 >
 translate  < -0.385768, -2.12387, 6.22922 >
   }

   object{
   Fuzz
   texture { pigment { color Black } }
 scale  < 0.2, 0.2, 0.2 >
 rotate  < -780, 520, 0 >
 translate  < -0.391601, -2.77319, 7.89621 >
   }

// CONE _cone0_8_1
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.16, 0.6, 0.16 >
 rotate  < 190, 80, 0 >
 translate  < 0.0475672, -4.62817, -7.13993 >
 }

// CONE _cone2_2_3
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 40, 110, -70 >
 translate  < 0.390298, -4.36515, -7.28791 >
 }


// CONE _cone2_2_3_4
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 40, 110, -70 >
 translate  < 0.336982, -4.68506, -7.29848 >
 }




// CONE _cone0_8_1_5
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { pigment { color Black } }
 scale  < 0.16, 0.6, 0.16 >
 rotate  < -90, 60, 90 >
 translate  < -0.377569, -3.38281, 8.32607 >
 }


// CONE _cone2_2_3_4_0
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 40, 50, -70 >
 translate  < -0.145087, -3.32299, 8.46152 >
 }


// CONE _cone2_2_3_4_0_1
cone { <0, -0.25, 0>, 0.1
  < 0, 0.25, 0>, 0
 texture { pigment { color Black } }
 rotate  < 40, 50, -70 >
 translate  < -0.0975006, -3.08162, 8.24152 >
 }
translate <0, -1.5, 0>
scale <1.1, 1.1, 1.1>
}
//**************************************HEAD************************************************
union{
union{
difference{
object {
  Headfuzz
texture { pigment { color Black } }
finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}
 scale  < 1, 1, 0.75 >

   }

// SPHERE _sphere1
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }
 scale  < 0.4, 0.7, 0.4 >
 rotate  < 0, 0, -20 >
 translate  < -0.75, 0.28125, -0.125 >
 }


// SPHERE _sphere1_0
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }
 scale  < 0.4, 0.7, 0.4 >
 rotate  < 0, 0, 20 >
 translate  < 0.6875, 0.28125, -0.125 >
 }}

object {
  Eye
  pigment {color Black filter 1}
texture {Glass3}
finish {
      ambient 0.99
      diffuse 0.99
      phong 1
      phong_size 100
		}
   scale  < 0.4, 0.7, 0.4 >
 rotate  < 0, 0, -20 >
 translate  < -0.75, 0.28125, -0.125 >
}

object {
  Eye
  pigment {color Black filter 1}
texture {Glass3}
finish {
      ambient 0.99
      diffuse 0.99
      phong 1
      phong_size 100
		}
scale  < 0.4, 0.7, 0.4 >
 rotate  < 0, 0, 20 >
 translate  < 0.75, 0.28125, -0.125 >

 }


difference{
 // CONE _cone0
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment { Black }
 finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}
scale  < 0.7, 0.5, 0.5 >
 rotate  < 0, 0, 180 >
 translate <0, -1.1, 0>
  }

  cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
pigment { Black }
scale <.1, .5, 3>
translate <-1, -1.5, 0>
}}


//********************************ANTENNA************************************

union{

// SPHERE _sphere3
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.5, 0.1 >
 rotate  < 30, 0, -20 >
 translate  < 0.3125, 2.71875, 0.75 >
 }


// SPHERE _sphere3_0
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.5, 0.1 >
 rotate  < 40, 0, 10 >
 translate  < -0.25, 2.78125, 0.875 >
 }


// SPHERE _sphere4
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.3125, 3.07517, 1.125 >
 }


// SPHERE _sphere4_2
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.362035, 3.10033, 1.18441 >
 }


// SPHERE _sphere4_3
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.550735, 2.83388, 1.4257 >
 }


// SPHERE _sphere4_4
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.484327, 2.91612, 1.3332 >
 }


// SPHERE _sphere4_5
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.426277, 3.01809, 1.26529 >
 }


// SPHERE _sphere4_6
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.53531, 2.85079, 1.31637 >
 }


// SPHERE _sphere4_7
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.494451, 2.97933, 1.22252 >
 }


// SPHERE _sphere4_8
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.895867, 2.43488, 1.7347 >
 }


// SPHERE _sphere4_9
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.596262, 2.77858, 1.41196 >
 }


// SPHERE _sphere4_10
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.464172, 3.06308, 1.125 >
 }


// SPHERE _sphere4_2_12
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.603522, 2.73191, 1.50175 >
 }


// SPHERE _sphere4_3_12
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.792226, 2.62336, 1.69582 >
 }


// SPHERE _sphere4_4_12
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.725811, 2.62664, 1.62965 >
 }


// SPHERE _sphere4_5_12
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.667763, 2.67599, 1.56482 >
 }


// SPHERE _sphere4_3_12_13
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.847176, 2.62336, 1.75465 >
 }


// SPHERE _sphere4_6_14
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.651472, 2.69645, 1.49748 >
 }


// SPHERE _sphere4_9_14
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.700104, 2.62424, 1.54353 >
 }


// SPHERE _sphere4_6_14_15
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.829742, 2.50229, 1.67009 >
 }


// SPHERE _sphere4_9_14_15
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.752505, 2.55953, 1.61088 >
 }


// SPHERE _sphere4_10_0
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.445889, 3.01885, 1.01537 >
 }


// SPHERE _sphere4_10_1
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.445889, 3.01885, 1.01537 >
 }


// SPHERE _sphere4_10_2
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < 0.990802, 2.37512, 1.79612 >
 }


// SPHERE _sphere4_10_3
sphere {  < 0, 0, 0 > 1
 texture { pigment { color Black } }

finish {
      ambient 0.25
      diffuse 0.25
      phong 1
      phong_size 100
		}

 scale  < 0.1, 0.1, 0.1 >
 translate  < -0.918179, 2.65399, 1.81751 >
 }


rotate <0, 180, 0>
translate <0, -1.75, 0>
scale <0.75, 0.75, 0.75>
}

rotate <-10, 90, 0>
translate <-1.5, 0, 0>
scale <3.5, 3.5, 3.5>
}

rotate <-20, 0, -5>
}


// *********************************WINGS*********************************************
union{
union{
union{
union{
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "wing.gif"     // the file name to read
texture { pigment {Black }}
translate <-.5, -1, -.5>
}

clipped_by
{
// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <6, .1, 2>
}
//***end 1st union***
disc { < 0, 0, 0>, < 0, 1, 0 >, 1
 texture { Glass }
normal { crackle 0.5 turbulence 0.5}
 scale  < 3, 1, 1 >
  }

 rotate  < -135, 0, 20 >
 translate  < 2.9375, 1.09375, 0 >
 rotate y*10
}
 rotate y*90
  translate <-.75, 2, -1.5>
 }

//******************
union{
union{
union{
height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "wing.gif"     // the file name to read
texture { pigment {Black }}
translate <-.5, -1, -.5>
}

clipped_by
{
// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <6, .01, 2>
}
//***end 1st union***
disc { < 0, 0, 0>, < 0, 1, 0 >, 1
 texture { Glass }
normal { crackle 0.5 turbulence 0.5}
 scale  < 3, 1, 1 >
  }

 rotate  < -45, 180, -20 >
 translate  < -2.875, 1.03125, 0 >
 rotate y*-10
}
  rotate y*90
  translate <-.75, 2, 1.5>
 }

 scale <2, 2, 2>
 translate x*-1
 }
translate <6, 4, 0>
}


//******************************END OF BEE******************************
//*********************************Flower************************************

union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*-20
scale <6, 6, 6>
translate <-8, -10, 0>
}

//*******************************smaller flower******************************

union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*50
rotate z*30
rotate y*35
scale <6, 6, 6>
translate <35, -20, 8>
}
rotate y*-45
}
//*********************added flowers*******************************


union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*30
rotate y*-30
scale <6, 6, 6>
translate <-10, -16, 50>
}

//***********************


union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*30
rotate y*-30
scale <6, 6, 6>
translate <70, -19, 85>
}

//***********************

union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*30
rotate y*-30
scale <6, 6, 6>
translate <-340, -16, 550>
}
//***********************

union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*30
rotate y*-40
scale <6, 6, 6>
translate <-140, -16, 520>
}
//***********************

union{
object{
Petal
translate y*-.3
}

object{
Petal
translate y*-.3
rotate z*60
}
object{
Petal
translate y*-.3
rotate z*120
}
object{
Petal
translate y*-.3
rotate z*180
}
object{
Petal
translate y*-.3
rotate z*240
}
object{
Petal
translate y*-.3
rotate z*300
}
object {
  Fuzz
  texture {  pigment {Orange}  }
scale <.75, .75, .75>
 }
rotate x*60
rotate z*30
rotate y*-25
scale <6, 6, 6>
translate <-120, -10, 590>
}
