#include "colors.inc"  // basic colors
#include "sphere.inc"  // textures for earth sphere
#include "ship.inc"    // textures/objects for cow ship
#include "text.inc"    // texture/declarations for text

// Scene Description

camera { location <1,1,-14.5> 
  look_at <3,3,0>
}

sphere { <0,0,0>, 3
  texture { LandArea }              // these declared in sphere.inc
  texture { OceanArea }
  texture { CloudArea }
}

object { CowShip                    // object declared in ship.inc
  rotate <20,0,135>
  translate <6,6,0>
  texture { Spotted }               // declared in ship.inc
}

object { CowShip                    // object declared in ship.inc
  rotate <20,0,135>
  translate <7.5,2.5,3.1>
  texture { Spotted }               // declared in ship.inc
}

text { ttf Tfont Ttext 0.1, 0
  translate <-4.3,6.3,-3>
  scale <0.9,1,1>
  texture { BlueGreen }                     // declared in text.inc
  finish { ambient 0.9 diffuse 0.1 }
}

light_source { <8,7,-4> color White }
light_source { <5,6,-3> color White }
