//---------------- Global Settings -------------------------------------------
global_settings
  { //adc_bailout           //default
    //ambient_light         //default
    assumed_gamma 2.2       //2.2
    //hf_gray_16            //off
    //irid_wavelength       // rgb<0.25,0.18,0.14>
    max_intersections 64
    max_trace_level 7
    number_of_waves 10
  }

//---------------------- Camera Settings and Placement -----------------------

#declare Position = < 100, 250, -530 >
#declare VP = < 0, 230, 0 >
#declare At = ( VP - Position ) + VP
#declare FP = VP - ( VP - Position )*0.5

camera { 
  angle 90
  location Position
  direction <0, 0, 1.65>
  blur_samples 20
  focal_point FP
  aperture 1.16
  look_at At
}

//---------------------- Atmosphere Settings----------------------------------

#declare Atmosphere = atmosphere {
  type 4            // 1:isotropic, 2:Mie(hazy), 3:Mie(Murky), 4:Rayleigh
  samples 10        // Number of samples in first distance interval
  distance 6000       // Atmosphere density, similar to fog
  scattering 0.01    // Reflectivity of atmosphere, determines brightness
  aa_level 8        // Level of binary subdivision in case of aa
  aa_threshold 0.2  // Threshold for aa to push in
  jitter 0.0        // Amount of sample jittering
}

atmosphere { Atmosphere }

//----------------------- Lights ---------------------------------------------

fog { fog_type 2 fog_alt 220 turbulence 0.3 turb_depth 1
      colour rgb < 1, 0.94, 0.94 > distance 600 up 7*y-z+0.2*x fog_offset -880 }

fog { fog_type 2 fog_alt 200 turbulence 0.3 turb_depth 10
      colour rgb < 0.6, 0.6, 1 > distance 900 up -y fog_offset -1700 }

light_source { <0, 1400, 2300> color red 1 green 1 blue 1 fade_distance 12000 atmosphere off }
light_source { <0, 500, -600> color red 1 green 1 blue 1 fade_distance 12000 atmosphere off }
light_source { <0, 5000, 2300> color red 1 green 1 blue 1 fade_distance 11000
               fade_power 2 atmosphere on }

///////////////////////////// INCLUDE FILES //////////////////////////////////

#include "building.inc"   // <- Textures file. Not included in the zip file
//#include "pinecon2.inc" // <- The Tree mesh file. Can be found elsewhere.
#include "elephant.inc"
#include "tusk.inc"
#include "earel.inc"

////////////////////////////// DECLARATIONS //////////////////////////////////

#declare River =
   prism
     { quadratic_spline 10, -30, 22
       <-12,-1>,<-11,0>,<-5,-3>,<-2,-2>,<-1,-2>,<0,-1>,<3,-1>,<4,-2>,<7,-3>,
       <10,-2>,<11,-2>,<11,-1>,<10,-1>,<7,-2>,<4,-1>,<3,0>,<0,0>,<-1,-1>,
       <-2,-1>,<-5,-2>,<-11,2>,<-11,0>
       rotate y*(-20)
       scale < 260, 1, 350 >
       translate < -370, 0, 2750 >
     }

#declare Waterfall =
   union
      { height_field
          { gif "falls.gif" smooth scale < 1000, 900, 400 >
            translate < -500, 0, -200 >
            texture { average
                        texture_map
                        { [ 0.6 Soil ]
                          [ 0.4 Stone_1 ] }
                      scale 70
                    }
          }
        merge
          { torus { 100, 50 rotate z*90 translate < -200, 490, 240 > }
            torus { 100, 60 rotate z*90 translate < -100, 470, 250 > }
            torus { 100, 70 rotate z*90 translate < 0, 460, 250 > }
            torus { 100, 60 rotate z*90 translate < 100, 470, 250 > }
            torus { 100, 50 rotate z*90 translate < 200, 490, 240 > }
            cone { < 0, 460, 150 >, 70, < 0, 0, 150 >, 100 }
            cone { < -100, 470, 150 >, 60, < -100, 0, 150 >, 100 }
            cone { < -200, 490, 140 >, 50, < -200, 0, 140 >, 110 }
            cone { < 100, 470, 150 >, 60, < 100, 0, 150 >, 100 }
            cone { < 200, 490, 140 >, 50, < 200, 0, 140 >, 110 }

            torus { 100, 50 rotate z*90 translate < -200, 290, 140 > }
            torus { 100, 60 rotate z*90 translate < -100, 220, 120 > }
            torus { 100, 70 rotate z*90 translate < 0, 210, 120 > }
            torus { 100, 60 rotate z*90 translate < 100, 220, 120 > }
            torus { 100, 50 rotate z*90 translate < 200, 290, 140 > }
            cone { < 0, 210, 20 >, 70, < 0, 0, -20 >, 100 }
            cone { < -100, 220, 20 >, 60, < -100, 0, -20 >, 100 }
            cone { < -200, 290, 40 >, 50, < -200, 0, 30 >, 110 }
            cone { < 100, 220, 20 >, 60, < 100, 0, -20 >, 100 }
            cone { < 200, 290, 40 >, 50, < 200, 0, 30 >, 110 }

            torus { 100, 60 rotate z*90 translate < -100, 100, -40 > }
            torus { 100, 70 rotate z*90 translate < 0, 100, -40 > }
            cone { < 0, 100, -40 >, 70, < 0, 0, -120 >, 100 }
            cone { < -100, 100, -40 >, 60, < -100, 0, -120 >, 100 }
            texture { Water scale 50 }
            //pigment { Red }
          }
        merge
          { sphere { < -300, 0, 0 >, 170 scale < 1, 1, 0.1 > translate -190*z }
            sphere { < -100, 0, 0 >, 170 scale < 1, 1, 0.1 > translate -190*z}
            sphere { < 100, 0, 0 >, 170 scale < 1, 1, 0.1 > translate -190*z}
            sphere { < 300, 0, 0 >, 170 scale < 1, 1, 0.1 > translate -190*z}
            finish { ambient 0 diffuse 1 refraction 1 ior 1.5 }
            pigment { rgbt < 0.95, 0.95, 1, 1 > }
            normal { crackle 1 scale 40 }
          }
      }

#declare Corona =
   union
     { difference
         { cone { < 0, 0, 0 >, 2, < 0, 2.6, 0 >, 2.5 }
           cone { < 0, -0.1, 0 >, 1.8, < 0, 2.7, 0 >, 2.35 }
           cylinder { < -3, 2.5, 0 >, < 3, 2.5, 0 >, 1 }
           cylinder { < -3, 2.5, 0 >, < 3, 2.5, 0 >, 1 rotate 45*y }
           cylinder { < -3, 2.5, 0 >, < 3, 2.5, 0 >, 1 rotate 90*y }
           cylinder { < -3, 2.5, 0 >, < 3, 2.5, 0 >, 1 rotate 135*y }
         }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+45) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+90) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+135) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+180) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+225) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+270) }
       sphere { < -2.5, 2.45, 0 >, 0.3 rotate y*(27.5+315) }
       torus { 2, 0.3 pigment { leopard turbulence 0.3
                                colour_map
                                  { [ 0.0 rgb < 1, 1, 1 > ]
                                    [ 0.5 rgb < 1, 1, 1 > ]
                                    [ 0.5 rgb < 0, 0, 0 > ]
                                    [ 1.0 rgb < 0, 0, 0 > ]
                                  }
                                scale 0.1
                              }
                      normal { bumps 0.6 }
               translate -0.3*y }
       scale 2
       pigment { rgb < 0.8, 0.76, 0.2 > }
       normal { bumps 0.1 }
       finish { SilverFinish }
     }

#declare Nails =
   union
     { difference
         { sphere { < 5, 0, 0 >, 1.4 }
           cylinder { < 5, 0, 0 >, < 5, -2, 0 >, 2 }
         }
       difference
         { sphere { < 5, 0, 0 >, 1.4 }
           cylinder { < 5, 0, 0 >, < 5, -2, 0 >, 2 }
           rotate y*30
         }
       difference
         { sphere { < 5, 0, 0 >, 1.4 }
           cylinder { < 5, 0, 0 >, < 5, -2, 0 >, 2 }
           rotate y*(-30)
         }
       scale < 1.6, 3.2, 1.2 > 
       pigment { rgb < 0.9, 0.85, 0.82 > }
       finish { specular 0.2 roughness 0.1 }
     }

#declare Eye =
   sphere
      { < 0, 0, 0 >, 0.98
        pigment { gradient -z
                  colour_map
                    { [ 0.0 rgbt < 0.98, 0.96, 0.94, 0 > ]
                      [ 0.5 rgbt < 0.97, 0.94, 0.92, 0 > ]
                      [ 0.6 rgbt < 0.5, 0.1, 0.1, 0.2 > ]
                      [ 0.6 rgbt < 0.1, 0.1, 0.1, 0.5 > ]
                      [ 1.0 rgbt < 0.1, 0.1, 0.1, 0.7 > ]
                    }
                }
        finish { Glossy reflection 0.1 refraction 1 ior 1.3 }
      }

#declare ElTusk =
   union
      { object { Tusk rotate < -90, 0, -145 > scale <1.4,2,1.8>
                 pigment { rgb < 0.95, 0.9, 0.83 > }
                 normal { agate 0.6 scale < 5, 1 ,1 > }
               }
        sphere { < 0.6, 2, 0 >, 1.4 }
        sphere { < 0.4, 2.3, 0 >, 1.4 }
        sphere { < 0.2, 2.6, 0 >, 1.4 }
        sphere { < 0.1, 2.9, 0 >, 1.4 }
        sphere { < 0.0, 3.2, 0 >, 1.4 }
        sphere { < -0.1, 3.6, 0 >, 1.42 }
        sphere { < -0.3, 4.2, 0 >, 1.5 }
      }

#declare EarAngle = 0
#declare Ears1 =
   union
      { object { Earel scale 1.8 rotate < -15, 180, -20 >
                 rotate < EarAngle, EarAngle/2, 0 >
                 translate < 46, 7, -3.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
        object { Earel scale < 1.8, 1.8, -1.8 > rotate < 15, -180, -20 >
                 rotate <-EarAngle, -EarAngle/2, 0 >
                 translate < 46, 7, 4.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
       
      }
#declare EarAngle = -40
#declare Ears2 =
   union
      { object { Earel scale 1.8 rotate < -15, 180, -20 >
                 rotate < EarAngle, EarAngle/2, 0 >
                 translate < 46, 7, -3.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
        object { Earel scale < 1.8, 1.8, -1.8 > rotate < 15, -180, -20 >
                 rotate <-EarAngle, -EarAngle/2, 0 >
                 translate < 46, 7, 4.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
       
      }
#declare EarAngle = 20
#declare Ears3 =
   union
      { object { Earel scale 1.8 rotate < -15, 180, -20 >
                 rotate < EarAngle, EarAngle/2, 0 >
                 translate < 46, 7, -3.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
        object { Earel scale < 1.8, 1.8, -1.8 > rotate < 15, -180, -20 >
                 rotate <-EarAngle, -EarAngle/2, 0 >
                 translate < 46, 7, 4.2 >
                 pigment { rgb < 0.95, 0.7, 0.92 > }
                 normal { agate 0.2 scale 3 turbulence 0.3 }
                 finish { specular 0 }
               }
       
      }

#declare Elephant =
   union
      { difference
           { object { MainElephant scale 20 }
             sphere { < 49, 2, -4.4 >, 1.4 }
             sphere { < 49, 2, 6 >, 1.4 }
             cylinder { < 14, -40, 0 >, < 14, -50, 0 >, 30 }
           }


        object { Nails translate < -10.2, -40, 9.2 > }
        object { Nails translate < -9.2, -40, -9 > }
        object { Nails translate < 28.3, -40, 8.9 > }
        object { Nails translate < 28.3, -40, -8.4 > }

        object { ElTusk rotate y*10 translate < 48, -8 , -3.2 > }
        object { ElTusk rotate y*(-10) translate < 48, -8 , 4.2 > }

        object { Eye scale 1.2 translate < 49, 2, -4 > }
        torus { 1.3, 0.3 rotate x*90 translate < 49, 2, -3.8 > }
        object { Eye scale 1.2 translate < 49, 2, 6 > }
        torus { 1.3, 0.3 rotate x*90 translate < 49, 2, 5.8 > }

        difference
          { sphere { < 0, 0, 0 >, 2 }
            sphere { < 1.64, 1.2, 0 >, 3 scale < 1, 1, 1.7 > }
            translate  < 66.2, -12.6, 0.8 >
          }
        pigment { rgb < 0.95, 0.7, 0.92 > }
        normal { average
                 scale 4
                 normal_map
                   { [ 0.8 ripples 0.4 turbulence 0.6  translate x*10 ]
                     [ 0.2 agate 0.4 turbulence 0.3  ]
                   }
               }
        finish { specular 0 }
      }

#declare Queen =
   union
      { difference
           { object { MainElephant scale 20 }
             sphere { < 49, 2, -4.4 >, 1.4 }
             sphere { < 49, 2, 6 >, 1.4 }
             cylinder { < 14, -40, 0 >, < 14, -50, 0 >, 30 }
           }

        object { Corona rotate z*(-12) translate < 44, 11.6, 1 > }

        object { Nails translate < -10.2, -40, 9.2 > }
        object { Nails translate < -9.2, -40, -9 > }
        object { Nails translate < 28.3, -40, 8.9 > }
        object { Nails translate < 28.3, -40, -8.4 > }

        object { Eye scale 1.2 translate < 49, 2, -4 > }
        torus { 1.3, 0.3 rotate x*90 translate < 49, 2, -3.8 > }
        object { Eye scale 1.2 translate < 49, 2, 6 > }
        torus { 1.3, 0.3 rotate x*90 translate < 49, 2, 5.8 > }

        difference
          { sphere { < 0, 0, 0 >, 2 }
            sphere { < 1.64, 1.2, 0 >, 3 scale < 1, 1, 1.7 > }
            translate  < 66.2, -12.6, 0.8 >
          }
        pigment { rgb < 0.95, 0.7, 0.92 > }
        normal { average
                 scale 4
                 normal_map
                   { [ 0.8 ripples 0.4 turbulence 0.6  translate x*10 ]
                     [ 0.2 agate 0.4 turbulence 0.3  ]
                   }
               }
        finish { specular 0 }
      }


#declare Grad =
   texture
     { gradient y texture_map
           { [ 0.0 pigment {rgb < 0.1, 0.6, 0.2 >} ]
             [ 0.3 pigment {rgb < 0.8, 0.8, 1 >} ]
             [ 0.5 Soil scale 0.3 ]
             [ 1.0 Stone_1 scale 0.3 ] }
       scale 350
     }

#declare Hill =
height_field { gif "hill.gif" scale < 500, 200, 500 >
                                  translate < -250, -2, -250 >
               smooth
             }

#declare Hill2 =
height_field { gif "hill2.gif" scale < 800, 350, 800 >
                                  translate < -400, -20, -400 >
               smooth
               texture { Grad }
             }

#declare Keep =
  union
     { difference
         { box { < -150, 0, -150 >, < 150, 100, 150 > }
           box { < -142, -1, -142 >, < 142, 101, 142 > }
           box { < -30, -1, -152 >, < 30, 101, 0 > }
           box { < -40, 30, -152 >, < -44, 40, 152 > }
           box { < -60, 30, -152 >, < -64, 40, 152 > }
           box { < -80, 30, -152 >, < -84, 40, 152 > }
           box { < -100, 30, -152 >, < -100, 40, 152 > }
           box { < 40, 30, -152 >, < 44, 40, 152 > }
           box { < 60, 30, -152 >, < 64, 40, 152 > }
           box { < 80, 30, -152 >, < 84, 40, 152 > }
           box { < 100, 30, -152 >, < 100, 40, 152 > }
         }
       difference
         { box { < -35, 0, -120 >, < 35, 120, -170 > }
           cylinder { < 0, 50, -175 >, < 0, 50, 0 >, 25 }
           box { < -25, -1, -175 >, < 25, 50, 0 > }
           box { < -20, 85, -175 >, < -25, 100, -130 > }
           box { < 20, 85, -175 >, < 25, 100, -130 > }
         }
       difference
         { box { < -40, 0, -40 >, < 40, 190, 40 > }
           box { < -36, -1, -36 >, < 36, 175, 36 > }
           box { < -5, 135, -50 >, < 5, 150, 0 > }
           cylinder { < 0, 150, -50 >, < 0, 150, 0 >, 5 }
           box { < -15, 135, -50 >, < -25, 150, 0 > }
           cylinder { < -20, 150, -50 >, < -20, 150, 0 >, 5 }
           box { < 15, 135, -50 >, < 25, 150, 0 > }
           cylinder { < 20, 150, -50 >, < 20, 150, 0 >, 5 }
           box { < -10, 0, -60 >, < 100, 60, 60 >
                 rotate z*(-45) translate y*190 }
           box { < 10, 0, -60 >, < -100, 60, 60 >
                 rotate z*45 translate y*190 }
           box { < -10, -1, -50 >, < 10, 30, 0 > }
           cylinder { < 0, 30, -50 >, < 0, 30, 0 >, 10 }
         }

       box { < -130, 100, -150 >, < -120, 109, -142 > }
       box { < -110, 100, -150 >, < -100, 109, -142 > }
       box { < -90, 100, -150 >, < -80, 109, -142 > }
       box { < -70, 100, -150 >, < -60, 109, -142 > }
       box { < -50, 100, -150 >, < -40, 109, -142 > }
       box { < 130, 100, -150 >, < 120, 109, -142 > }
       box { < 110, 100, -150 >, < 100, 109, -142 > }
       box { < 90, 100, -150 >, < 80, 109, -142 > }
       box { < 70, 100, -150 >, < 60, 109, -142 > }
       box { < 50, 100, -150 >, < 40, 109, -142 > }
       box { < -130, 100, 150 >, < -120, 109, 142 > }
       box { < -110, 100, 150 >, < -100, 109, 142 > }
       box { < -90, 100, 150 >, < -80, 109, 142 > }
       box { < -70, 100, 150 >, < -60, 109, 142 > }
       box { < -50, 100, 150 >, < -40, 109, 142 > }
       box { < 130, 100, 150 >, < 120, 109, 142 > }
       box { < 110, 100, 150 >, < 100, 109, 142 > }
       box { < 90, 100, 150 >, < 80, 109, 142 > }
       box { < 70, 100, 150 >, < 60, 109, 142 > }
       box { < 50, 100, 150 >, < 40, 109, 142 > }

       box { < -35, 120, -170 >, < -25, 128, 162 > }
       box { < -35, 120, -170 >, < -27, 128, 160 > }
       box { < -35, 120, -150 >, < -27, 128, 140 > }
       box { < -15, 120, -170 >, < -5, 128, 162 > }
       box { < 35, 120, -170 >, < 25, 128, 162 > }
       box { < 15, 120, -170 >, < 5, 128, 162 > }
       box { < 35, 120, -170 >, < 27, 128, 160 > }
       box { < 35, 120, -150 >, < 27, 128, 140 > }


       difference
         { cylinder { < -150, 0, -150 >, < -150, 200, -150 >, 30 }
           cylinder { < -150, -1, -150 >, < -150, 201, -150 >, 23 }
           box { < -145, 145, -190 >, < -155, 165, 190 > }
         }
       difference
         { cylinder { < 150, 0, -150 >, < 150, 200, -150 >, 30 }
           cylinder { < 150, -1, -150 >, < 150, 201, -150 >, 23 }
           box { < 145, 145, -190 >, < 155, 165, 190 > }
          }
       difference
         { cylinder { < 150, 0, 150 >, < 150, 200, 150 >, 30 }
           cylinder { < 150, -1, 150 >, < 150, 201, 150 >, 23 }
           box { < 145, 145, -190 >, < 155, 165, 190 > }
         }
       difference
         { cylinder { < -150, 0, 150 >, < -150, 200, 150 >, 30 }
           cylinder { < -150, -1, 150 >, < -150, 201, 150 >, 23 }
           box { < -145, 145, -190 >, < -155, 165, 190 > }
         }
       cone { < -150, 200, -150 >, 35, < -150, 300, -150 >, 1 texture { Roof_Tiles_Red scale 10} }
       cone { < 150, 200, -150 >, 35, < 150, 300, -150 >, 1 texture { Roof_Tiles_Red scale 10} }
       cone { < -150, 200, 150 >, 35, < -150, 300, 150 >, 1 texture { Roof_Tiles_Red scale 10} }
       cone { < 150, 200, 150 >, 35, < 150, 300, 150 >, 1 texture { Roof_Tiles_Red scale 10} }

       difference
          { box { < -60, 0, -45 >, < 0, -60, 45 > rotate z*45 translate y*194}
            box { < -60, 0, -47 >, < 0, -60, 47 > rotate z*45 translate y*190 }

            texture { Roof_Tiles_Red scale 10 }
          }

       texture { Stone_Wall_1 scale 10}
     }

#declare Temple =
   union
     { object { Elephant scale 2 translate < -30, 176, 1 >
                texture { Stone_Wall_2 scale 5 } }
       difference
         { union
              { box { < -100, 0, -100 >, < 100, 25, 100 > }
                box { < -85, 25, -85 >, < 85, 50, 85 > }
                box { < -60, 50, -60 >, < 60, 75, 60 > }
              }
           box { < 0, 1, -15 >, < 120, 40, 15 > }
         }
       box { < -45, 75, -45 >, < 45, 100, 45 > }
       texture { Stone_Wall_2 scale 5 }
     }


//----------- The Sky Backdrop -----

cylinder { < 0, -100, 0 >, < 0, 8000, 0 >, 10000
         hollow
         no_shadow
         finish { ambient 1 diffuse 0 }
         pigment { gradient y
                   color_map { [ 0.0 rgb < 1, 0.7, 0.7 > ]
                               [ 1.0 rgb < 0.1, 0.5, 1 > ] }
                   scale 5000
                 }
       }

/////////////////////// Terrain //////////////////////////////////////////////

difference
   { plane { y, 0 }
     object { River }
     texture { Grass scale 10 }
   }
object { River translate -14*y texture { Water scale <32,9,23> } }

object { Waterfall translate < -1200, 0, 5500 > }
object { Waterfall scale 0.8 translate < -1800, 0, 5700 > }
object { Hill2 scale < 1.6, 1.8 , 1.6 > translate < -200, 0, 7800 >
       }
object { Hill2 scale < 1.6, 2.1 , 1.6 > translate < -4300, 0, 6200 >
       }
  

object { Hill rotate y*30 scale < 1, 0.6, 1 > translate < 100, 0, 200 > texture { Earth scale 280 translate -24*y } }
object { Hill rotate y*120 scale < 1, 0.5, 1 > translate < -50, 0, 280 > texture { Earth scale 280 translate -4*y } }
object { Hill rotate y*90 scale < 1, 0.4, 1 > translate < -100, 0, 500 > texture { Earth scale 280 translate -24*y } }
object { Hill rotate y*160 translate < -250, -40, 620 > texture { Earth scale 280 translate -4*y } }
object { Hill rotate y*120 translate < 150, -60, 2080 > texture { Earth scale 280 translate -4*y } }
object { Hill rotate y*90 translate < 630, -20, 2500 > texture { Earth scale 280 translate -24*y } }
object { Hill rotate y*160 translate < 450, -40, 2420 > texture { Earth scale 280 translate -4*y } }
  
height_field { gif "ridge.gif" smooth
               rotate < 90, 0, 180 >
               scale < 400, 200, 260 >
               rotate <-20, -73, 0 >
               translate < 220, -10, -165 >
               texture { Stone_1 scale 15 }
             }



difference
  { height_field { gif "hill3.gif" scale < 460, 650, 460 >
                   translate < -230, 0, -230 > }
    plane { y, 20 }
    rotate x*180 translate < -400, 680, 3000 >
    texture { gradient y
              texture_map
                 { [ 0.0 Soil scale 0.1 ]
                   [ 0.8 Soil scale 0.1 ]
                   [ 0.9 Soil_w_Moss scale 0.1 ]
                   [ 1.0 Grass scale 0.1 ]
                 }
              scale 665
            }
  }
height_field { gif "hill3.gif" scale < 150, 150, 150 >
                   translate < -380-75, 0, 3050-75 >
               texture
                  { gradient y
                    texture_map
                       { [ 0.0 Soil_w_Moss scale 0.5 ]
                         [ 1.0 Soil scale 0.5 ]
                       }
                    scale 150
                  }
             }


object { Hill2 rotate y*180 translate < -2000, 0, 7000 > }
object { Hill2 scale < 3, 3, 3 > translate < 1000, 0, 7300 > }
object { Hill2 scale < 2, 1, 2 > rotate y*90 scale 2 translate < -3500, -30, 6800 > }
object { Hill2 scale 1.5 translate < -3000, -30, 7500 > }
object { Hill2 scale < 3, 0.8, 3 > rotate y*90 scale 2 translate < 500, -30, 6800 > }

///////////////////// Trees //////////////////////////////////////////////////

#declare Seed = seed(0)


#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 9+rand(Seed)*4
                 translate < 420+0.4*i*cos(i), 0, 1350+0.4*i*sin(i) > }
   #declare i = i+20
#end


#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 12+rand(Seed)*4
                 translate < 450+0.3*i*cos(i), 0, 1750+0.4*i*sin(i) > }
   #declare i = i+20
#end

#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 10+rand(Seed)*4
                 translate < -1450+0.4*i*cos(i), 0, 2050+0.2*i*sin(i) > }
   #declare i = i+20
#end
#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 10+rand(Seed)*4
                 translate < -1500+0.4*i*cos(i), 0, 2700+0.4*i*sin(i) > }
   #declare i = i+20
#end

#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 10+rand(Seed)*4
                 translate < 150+0.2*i*cos(i), 0, 900+0.2*i*sin(i) > }
   #declare i = i+20
#end
#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 10+rand(Seed)*4
                 translate < -500+0.3*i*cos(i), 0, 700+0.2*i*sin(i) > }
   #declare i = i+20
#end
#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 10+rand(Seed)*4
                 translate < -170+0.3*i*cos(i), 0, 400+0.2*i*sin(i) > }
   #declare i = i+20
#end
#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 12+rand(Seed)*4
                 translate < -400+0.4*i*cos(i), 0, 1700+0.4*i*sin(i) > }
   #declare i = i+10
#end
#declare i = 0
#while ( i <= 1080 )
   object { Pine scale 15+rand(Seed)*4
                 translate < -700+i*cos(i), 0, 3700+0.6*i*sin(i) > }
   #declare i = i+5
#end
  
  
  
height_field { gif "wirlpool.gif"
               smooth
               scale < 8000, 1300, 13000 >
               rotate x*180
               translate < -4000-550, 1300+600, 6500+4600 >
               pigment { rgbt < 1, 1, 1, 0.4 > }
               normal { bumps 0.4 scale 200 }
               no_shadow
             }
  
  

//////////////////////////// The Elephants ///////////////////////////////////

object { Elephant rotate y*(-160) translate < 165, 190, -178 > }
object { Ears1 rotate y*(-160) translate < 165, 190, -178 > }

object { Elephant scale 0.8 rotate y*230 translate < -810, 40*0.8, 1275 > }
object { Ears2 scale 0.8 rotate y*230 translate < -810, 40*0.8, 1275 > }

object { Elephant scale 0.4 rotate y*230 translate < -880, 40*0.4, 1285 > }
object { Ears3 scale 0.4 rotate y*230 translate < -880, 40*0.4, 1285 > }




#declare step = 0
#while ( step <= 26 )
   object { Elephant rotate y*180
            translate  < 0, -step*12, -step * 30 >
            rotate y*step*8
            translate < -400+step*3+10*sin(step*45), 680+10*sin(step*45), 2450 >
          }
   #switch ( mod(ceil(step),3) )
       #case ( 0 )
          object { Ears1 rotate y*180
                   translate  < 0, -step*12, -step * 30 >
                   rotate y*step*8
                   translate < -400+step*3+10*sin(step*45), 680+10*sin(step*45), 2450 >
                 }
       #break
       #case ( 1 )
          object { Ears2 rotate y*180
                   translate  < 0, -step*12, -step * 30 >
                   rotate y*step*8
                   translate < -400+step*3+10*sin(step*45), 680+10*sin(step*45), 2450 >
                 }
       #break
       #case ( 2 )
          object { Ears3 rotate y*180
                   translate  < 0, -step*12, -step * 30 >
                   rotate y*step*8
                   translate < -400+step*3+10*sin(step*45), 680+10*sin(step*45), 2450 >
                 }
       #break
       #else
   #end       //switch

   #declare step = step +2
#end


#declare step = 27
#while ( step <= 35 )
   object { Elephant rotate y*180
            translate  < 0, -step*12, -27 * 30 >
            rotate y*step*8
            translate < -400+step*4, 680+40*sin(step*10), 2650-(step-27)*90+10*sin(step*45) >
          }
   #switch ( mod(ceil(step),3) )
      #case ( 0 )
         object { Ears1 rotate y*180
                  translate  < 0, -step*12, -27 * 30 >
                  rotate y*step*8
                  translate < -400+step*4, 680+40*sin(step*10), 2650-(step-27)*90+10*sin(step*45) >
                }
      #break
      #case ( 1 )
         object { Ears2 rotate y*180
                  translate  < 0, -step*12, -27 * 30 >
                  rotate y*step*8
                  translate < -400+step*4, 680+40*sin(step*10), 2650-(step-27)*90+10*sin(step*45) >
                }
      #break
      #case ( 2 )
         object { Ears3 rotate y*180
                  translate  < 0, -step*12, -27 * 30 >
                  rotate y*step*8
                  translate < -400+step*4, 680+40*sin(step*10), 2650-(step-27)*90+10*sin(step*45) >
                }
      #break
      #else
   #end     // switch

   #declare step = step +1
#end



#declare step = 36
#while ( step <= 43.5 )
   object { Elephant rotate z*20 rotate y*(180-(step-36)*10)
            translate  < 0, -step*13, -36 * 30 >
            rotate y*step*8
            translate < -400+step*3+20*sin(step*10), 680+(step-36)*(step-36)*2.2, 2650-(step-36)*223 >
          }
   #switch ( mod(ceil(step+0.5),3) )
      #case ( 0 )
          object { Ears1 rotate z*20 rotate y*(180-(step-36)*10)
                   translate  < 0, -step*13, -36 * 30 >
                   rotate y*step*8
                   translate < -400+step*3+20*sin(step*10), 680+(step-36)*(step-36)*2.2, 2650-(step-36)*223 >
                 }
      #break
      #case ( 1 )
          object { Ears2 rotate z*20 rotate y*(180-(step-36)*10)
                   translate  < 0, -step*13, -36 * 30 >
                   rotate y*step*8
                   translate < -400+step*3+20*sin(step*10), 680+(step-36)*(step-36)*2.2, 2650-(step-36)*223 >
                 }
      #break
      #case ( 2 )
          object { Ears3 rotate z*20 rotate y*(180-(step-36)*10)
                   translate  < 0, -step*13, -36 * 30 >
                   rotate y*step*8
                   translate < -400+step*3+20*sin(step*10), 680+(step-36)*(step-36)*2.2, 2650-(step-36)*223 >
                 }
      #break
      #else
   #end     //switch

   #declare step = step +0.6
#end

object { Queen rotate z*(-18) rotate y*45 translate < -68, 302, -220 > }
object { Ears1 rotate z*(-18) rotate y*45 translate < -68, 302, -220 > }


object { Keep translate < -400, 660, 3000 > }


object { Temple rotate y*15 scale 1.3 translate < -1950, 0, 3200 > }



//------------ The semi-transparent mask for the light shafts effect.
//             There is a light source just over the surface with the
//             atmosphere attribute turned on. All other lights are
//             placed under this mask so that they don't interact with
//             it in any way.

box { <-500, 4890, 2300-500 >, < 500, 4890.1, 2300+500 >
      pigment { onion scale 2 turbulence 0.4
                colour_map
                   { [ 0.0 rgbt < 1, 1, 1, 1 > ]
                     [ 0.4 rgbt < 1, 1, 1, 1 > ]
                     [ 0.4 rgbt < 1, 1, 1, 0 > ]
                     [ 1.0 rgbt < 1, 1, 1, 0 > ] 
                   }
              }
    }


 













