/*                    Units are expressed in meters               */

#include "colors.inc"
/*-------------------------------------------------CAMERA--------------*/
camera {
   location <200,10,100>
   look_at <0,0,700>
}
/*-------------------------------------------------LIGHT--------------*/
light_source {<-200,150,0> color White}

/*-------------------------------------------------SKY--------------*/
sky_sphere {
   pigment {
      gradient y
      color_map {
         [0.8 color red 0.0 green 0.5 blue 0.8]
         [1.0 color red 0.9 green 0.9 blue 0.9]
      }
      turbulence 2
   }
   scale <1,.1,1>
}

/*-------------------------------------------------LAND---------------*/
box {
   <-10000,-0.1,-10000>,<100000,0,10000>
   texture {
      pigment {
         gradient z
         color_map {
            [0.3 color red 0.9 green 0.7 blue 0.3]
            [0.8 color red 1.0 green 0.8 blue 0.3]
            [1.0 color red 0.9 green 0.7 blue 0.3]
         }
         scale <1,1,10>
         turbulence 1
      }
      finish {ambient 0.7 diffuse 0.8}
      normal {bumps 0.5 turbulence 1}
   }
}

/*-------------------------------------------DECLARE TRACK--------------*/
#declare pista = union {
   box {                                    /* Track */
      <0,-0.1,0>,<2000,0.1,30>
      texture {
         pigment {
            bozo 
            color_map {
               [0.8 color red 0.7 green 0.7 blue 0.7]
               [1.0 color red 0.6 green 0.6 blue 0.6]
            }
         }
         finish {ambient 0.3 diffuse 0.8}
      }
   }
   #declare mm=0
   #while (mm<300) 
      box {                                    /* Midline */
         <mm,-0.1,14>,<mm+10,0.11,16>
         texture {
            pigment {color White}
            finish {ambient 0.5 diffuse 0.9}
         }
      }
      #declare mm=mm+15
   #end
   #declare ll=0                          /* Light ball on the street */
   #while (ll<300) 
      sphere {                                    
         <ll,0.5,-3>,0.5
         texture {
            pigment {color Yellow}
            finish {phong 1ambient 0.5 diffuse 0.9}
         }
      }
      sphere {                                    
         <ll,0.5,33>,0.5
         texture {
            pigment {color Yellow}
            finish {phong 1ambient 0.5 diffuse 0.9}
         }
      }
      #declare ll=ll+5
   #end

}

/*-------------------------------------------DISPLAY TRACK 1--------------*/   
object {
   pista
   translate <0,0,130>
}

/*-------------------------------------------DISPLAY TRACK 2--------------*/   
object {
   pista
   translate <0,0,180>
}

/*-------------------------------------------CONTROL TOWER----------------*/   
cylinder {                                                 /*     BASE    */
   <150,0,240>,<150,20,240>,2
   texture {
      pigment {checker color Red color White}
      finish {phong 1 ambient 0.3 diffuse 0.8}
   }
}                                                         
/*--------------*/
cylinder {                                                 /*    DISC1    */
   <150,20,240>,<150,21,240>,6
   texture {
      pigment {checker color Red color White}
      finish {phong 1 ambient 0.3 diffuse 0.8}
   }
}                                                         
/*--------------*/
cylinder {                                                 /*    DISC2    */
   <150,26,240>,<150,27,240>,6
   texture {
      pigment {checker color Red color White}
      finish {phong 1 ambient 0.3 diffuse 0.8}
   }
}                                                         
/*--------------*/
cone {                                                     /*    TOP      */
   <150,27,240>,3,<150,29,240>,2
   texture {
      pigment {checker color Red color White}
      finish {phong 1 ambient 0.3 diffuse 0.8}
   }
}                                                         
/*--------------*/
cylinder {                                                 /*    GLASS    */
   <150,21,240>,<150,26,240>,5
   texture {
      pigment {color red 0.9 green 1.0 blue 0.9 filter 0.8}
      finish {phong 1 ambient 0.3 diffuse 0.8}
   }
}                                                         
/*--------------*/                                        /*  SEPARATOR  */ 
#declare kk=0                                                          
#while (kk<=6.28)
   cylinder {
      <150+sin(kk)*5,21,240+cos(kk)*5>,<150+sin(kk)*5,26,240+cos(kk)*5>,0.05
      texture {
         pigment {color Black}
         finish {phong 1 ambient 0.3 diffuse 0.8}
      }
   }                                                         
   #declare kk=kk+(6.28/20)
#end                                                           
/*-------------------------------------------DECLARE AIRCRAFT-------------*/   
#declare aircraft = difference {
   union {   
      cylinder {                                            /*   MAIN    */
         <0,4,0>,<20,4,0>,2
         texture {
            pigment {color White}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                      /*  BORDER 1       */
         <4,4,-2>,<16,4,-2>,0.05
         texture {
            pigment {color Green}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                      /*  BORDER 2       */
         <4,4,2>,<16,4,2>,0.05
         texture {
            pigment {color Green}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      prism {                                       /*  BACK  ALETTONE */
         linear_spline
         linear_sweep
         0,0.2
         6,
         <0,0>,<0,2.5>,<1,2>,<1.5,1>,<1.5,0>,<0,0>
         texture {
            pigment {color Orange}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
         rotate <-90,0,0>
         translate <3,6,0.1>
      }
      cone {                                          /* SILVER FIRE TUBE */
         <-5,4,0>,2,<0,4,0>,1.2
         open
         texture {
            pigment {color red 0.6 green 0.6 blue 0.6}
            finish {
               ambient 0.5
               diffuse 0.8
               brilliance 2
               metallic
               specular 0.80
               roughness 1/20
               reflection 0.1
            }
         }
      }                                                         
      sphere {                                              /*   HEAD    */
         <0,0,0>,2                                                       
         texture {
            pigment {color White}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
         scale <3,1,1>
         translate <20,4,0>
      }                                                         
      cone {                                            /* BLACK END POINT */
         <26,4,0>,0.2,<29,4,0>,0.001
         texture {
            pigment {color Black}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* H WHEEL 1   */
         <21,0.5,0.2>,<21,0.5,0.6>,0.5
         texture {
            pigment {color Black}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* H WHEEL 2   */
         <21,0.5,-0.6>,<21,0.5,-0.2>,0.5
         texture {
            pigment {color Black}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* H AXIS HOR  */
         <21,0.5,-0.7>,<21,0.5,0.7>,0.3
         texture {
            pigment {color red 0.7 green 0.7 blue 0.7}
            finish {
               ambient 0.5
               diffuse 0.9
               brilliance 2
               metallic
               specular 0.80
               roughness 1/20
               reflection 0.1
            }
         }
      }                                                         
      cylinder {                                            /* H AXIS VER  */
         <21,0.5,0>,<20,2,0>,0.18
         texture {
            pigment {color Red}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* B WHEEL 1   */
         <2,0.7,-1.2>,<2,0.7,-1>,0.7
         texture {
            pigment {color Black}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* B WHEEL 2   */
         <2,0.7,1>,<2,0.7,1.2>,0.7
         texture {
            pigment {color Black}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                                            /* B AXIS HOR  */
         <2,0.7,-1.3>,<2,0.7,1.3>,0.3
         texture {
            pigment {color red 0.7 green 0.7 blue 0.7}
            finish {
               ambient 0.5
               diffuse 0.9
               brilliance 2
               metallic
               specular 0.80
               roughness 1/20
               reflection 0.1
            }
         }
      }                                                         
      cylinder {                                            /* B AXIS VER  */
         <2,0.7,0>,<2,2,0>,0.3
         texture {
            pigment {color Red}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      prism {                                               /*   ALI   */
         linear_spline
         linear_sweep
         4,4.3
         6,
         <13,-15>,<13,15>,<15,15>,<19,0>,<15,-15>,<13,-15>
         texture {
            pigment {color White}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }
      cylinder {                        /*  RIGHT  RED FOR CIRCULAR FLAG */
         <14,3.99,-13>,<14,4.31,-13>,0.9
         texture {
            pigment {color Red}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                        /*  RIGHT WHITE FOR CIRCULAR FLAG */
         <14,3.98,-13>,<14,4.32,-13>,0.6
         texture {
            pigment {color White}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                        /*  RIGHT GREEN FOR CIRCULAR FLAG */
         <14,3.97,-13>,<14,4.33,-13>,0.3
         texture {
            pigment {color Green}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                        /*  LEFT   RED FOR CIRCULAR FLAG */
         <14,3.99,13>,<14,4.31,13>,0.9
         texture {
            pigment {color Red}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                        /*  LEFT  WHITE FOR CIRCULAR FLAG */
         <14,3.98,13>,<14,4.32,13>,0.6
         texture {
            pigment {color White}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
      cylinder {                        /*  LEFT  GREEN FOR CIRCULAR FLAG */
         <14,3.97,13>,<14,4.33,13>,0.3
         texture {
            pigment {color Green}
            finish {phong 1 ambient 0.5 diffuse 0.9}
         }
      }                                                         
   }
   /*--------Windows--------*/
   #declare kk=2
   #while (kk<=22)
      box {
         <kk,5,-5>,<kk+0.4,5.4,5>
         texture {pigment {color Black}}
      }
      #declare kk=kk+0.8
   #end
}
/*-------------------------------------------DISPLAY AIRCRAFT 1-----------*/   
object {
   aircraft
   translate <160,0,145>
}
/*-------------------------------------------DISPLAY AIRCRAFT 2 (central)-*/   
object {
   aircraft
   rotate <0,0,10>
   translate <150,50,250>
}
/*-------------------------------------------DISPLAY AIRCRAFT 3-----------*/   
object {
   aircraft
   rotate <0,0,10>
   translate <150,50,300>
}
/*-------------------------------------------DISPLAY AIRCRAFT 4-----------*/   
object {
   aircraft
   rotate <0,0,10>
   translate <150,50,200>
}
/*-------------------------------------------RED   SMOKE FOR AIR 2----------*/   
#declare sc=80
sphere {                        
   <0,0,0>,1
   texture {
      pigment {color red 1 green 1 blue 1 transmit 1}
      halo {
         emitting
         spherical_mapping
         linear
         color_map {
            [0.8 color rgbt <1,0,0,0.8>]
            [1.0 color rgbt <1,1,1,0.8>]
         }
         samples 10
         turbulence 1
      }
   }
   hollow
   scale <sc,1.5,1.5>
   rotate <0,0,10>
   translate <150-sin(radians(80))*sc,54-cos(radians(80))*sc,300>
}                                                         
/*-------------------------------------------WHITE SMOKE FOR AIR 2----------*/   
sphere {                        
   <0,0,0>,1
   texture {
      pigment {color red 1 green 1 blue 1 transmit 1}
      halo {
         emitting
         spherical_mapping
         linear
         color_map {
            [0.8 color rgbt <1,1,1,0.8>]
            [1.0 color rgbt <1,1,1,0.8>]
         }
         samples 10
         turbulence 1
      }
   }
   hollow
   scale <sc,1.5,1.5>
   rotate <0,0,10>
   translate <150-sin(radians(80))*sc,54-cos(radians(80))*sc,250>
}                                                         
/*-------------------------------------------GREEN SMOKE FOR AIR 4----------*/   
sphere {                        
   <0,0,0>,1
   texture {
      pigment {color red 1 green 1 blue 1 transmit 1}
      halo {
         emitting
         spherical_mapping
         linear
         color_map {
            [0.8 color rgbt <0,1,0,0.8>]
            [1.0 color rgbt <1,1,1,0.8>]
         }
         samples 10
         turbulence 1
      }
   }
   hollow
   scale <sc,1.5,1.5>
   rotate <0,0,10>
   translate <150-sin(radians(80))*sc,54-cos(radians(80))*sc,200>
}                                                         

