// ABEJA

// Texturas

#declare tAbeja1 = texture {
   pigment { rgb<1, .804, 0> }
   finish { diffuse .7 ambient .2 }
}

#declare tOjos = texture {
   pigment { rgb 0 }
   finish {
     diffuse .7
     ambient .2
     phong 1
     phong_size 79.6 }
}

#declare tAbeja2 = texture {
   pigment { granite
     color_map {
       [ 0.000  rgb<0.03, 0, 0> ]
       [ 0.640  rgb<0.03, 0, 0> ]
       [ 0.651  rgb<1, .804, 0> ]
       [ 1.000  rgb<1, .799, 0> ]
     }
     scale .3
   }
   finish {
     diffuse .69
     ambient .2
     phong .35
     phong_size 25
   }
}

#declare tPatas = texture {
  pigment { granite
     color_map {
       [ 0 rgb 0 ]
       [ .640 rgb 0 ]
       [ .651 rgb<1, .804, 0> ]
       [ 1 rgb<1, .799, 0> ]
     }
     scale .3
   }
   normal { wrinkles 1 scale .01 }

   finish {
     diffuse .7
     ambient .2
     phong .2
     phong_size 20
   }
}

#declare tAbeja3 = texture {
   pigment { gradient x
     color_map {
       [ 0 rgb<1, .804, 0> ]
       [ .299 rgb<.027, 0, 0> ]
       [ 1 rgb<.027, 0, 0> ]
     }
     frequency 3
   }
   finish {
     diffuse .5
     ambient .2
     specular .4
     roughness .01
   }
}

#declare tAlas = texture {
   pigment {
     image_map {
       gif "ala.gif"
       transmit all .9
       transmit 0, 0
       transmit 1, 0
       transmit 15, 1
       map_type 0
       interpolate 2
     }
   }
   finish {
     diffuse .8
     ambient .6
     specular .5
     roughness .005
   }

}

// Objetos

#declare Antena = union {
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <.02, .02, .2>
    rotate -50*y
    translate  <-.75, 0, .15>
  }
  cylinder { <0,0,1>, <0,0,0>, 1
    scale <.02, .02, .5>
    rotate -10*y
    translate  <-.8963, 0, .266708>
  }
  texture { tPatas }
  rotate -40*x
  translate  <-.036516, .010518, .013213>
}

#declare Pelo = object {
  cylinder { <0,0,1>, <0,0,0>, 1
    texture { tAbeja1 }
    scale <.01, .01, 1>
    rotate -45*y
    translate  <.35, 0, -.35>
  }
}

#declare Pelos1 = union {
  object { Pelo }
  object { Pelo rotate -17.139999*z }
  object { Pelo rotate -34.279999*z }
  object { Pelo rotate -51.419998*z }
  object { Pelo rotate -68.559998*z }
  object { Pelo rotate -85.699997*z }
  object { Pelo rotate -102.839996*z }
  object { Pelo rotate -119.980003*z }
  object { Pelo rotate -137.119995*z }
  object { Pelo rotate -154.259995*z }
  object { Pelo rotate -171.399994*z }
  object { Pelo rotate 171.460007*z }
  object { Pelo rotate 154.320007*z }
  object { Pelo rotate 137.179993*z }
  object { Pelo rotate 120.039993*z }
  object { Pelo rotate 102.899994*z }
  object { Pelo rotate 85.76001*z }
  object { Pelo rotate 68.619995*z }
  object { Pelo rotate 51.480011*z }
  object { Pelo rotate 34.339996*z }
  object { Pelo rotate 17.200012*z }
}

#declare Pelos2 = object {
 Pelos1 scale <1.1, 1.1, .8> rotate -8.57*z }

#declare Pelos3 = object {
 Pelos2 scale <1.1, 1.1, .8> rotate -8.57*z }

#declare Pelos4 = object {
 Pelos3 scale <1.05, 1.05, .75> rotate -8.57*z }

#declare Pelos5 = object {
  Pelos4 scale <1.025, 1.025, .7> rotate -8.57*z }

#declare Pelos6 = object {
  Pelos5 scale <1, 1, .6> rotate -8.57*z }

#declare Cuerpo = union {
  object { Pelos1 }
  object { Pelos2 }
  object { Pelos3 }
  object { Pelos4 }
  object { Pelos5 }
  object { Pelos6 }
  object { Pelos6 scale <1, 1, .45> rotate -8.57*z }
  sphere { 0, 1 texture { tAbeja2 } scale .4 }
  scale <.8, 1, 1>
  rotate -90*y
  translate  -.05*x
}

#declare Patas1 = union {
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .4>
    rotate <90, 0, 10>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .05, <0,0,1>, .07
    scale <1, 1, .5>
    rotate <120, 0, 70>
    translate  <.21, -.39, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .02
    scale <1, 1, .35>
    rotate <140, 0, 60>
    translate  <.62, -.52, -.57>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate <150, 0, 50>
    translate  <.81, -.63, -.83>
  }
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .4>
    rotate <90, 0, 170>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .05, <0,0,1>, .07
    scale <1, 1, .5>
    rotate <120, 0, 110>
    translate  <.21, .39, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .02
    scale <1, 1, .35>
    rotate <-140, 0, -60>
    translate  <.62, .52, -.57>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate <150, 0, 120>
    translate  <.81, .63, -.83>
  }
}

#declare Patas2 = union {
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <90, 0, 10>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <130, 0, 20>
    translate  <.2, -.29, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .02
    scale <1, 1, .2>
    rotate <150, 0, -20>
    translate  <.28, -.51, -.5>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate <150, 0, -180>
    translate  <.24, -.61, -.67>
  }
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <90, 0, 170>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <130, 0, 160>
    translate  <.2, .29, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .02
    scale <1, 1, .2>
    rotate <150, 0, -160>
    translate  <.28, .51, -.5>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate 150*x
    translate  <.24, .6, -.67>
  }
  translate  -.16*x
}

#declare Patas3 = union {
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <85, 0, -10>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <140, 0, -20>
    translate  <.1, -.29, -.28>
  }
  cone { <0,0,0>, .03, <0,0,1>, .02
    scale <1, 1, .2>
    rotate <-160, 0, 50>
    translate  <.03, -.48, -.51>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate 130*x
    translate  <-.02, -.44, -.69>
  }
  cone { <0,0,0>, .03, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <85, 0, -170>
    translate  <.15, 0, -.31>
  }
  cone { <0,0,0>, .04, <0,0,1>, .05
    scale <1, 1, .3>
    rotate <140, 0, -160>
    translate  <.1, .29, -.28>
  }
  cone { <0,0,0>, .03, <0,0,1>, .02
    scale <1, 1, .2>
    rotate <160.0, 0.0, -50.0>
    translate  <.03, .48, -.51>
  }
  cone { <0,0,0>, .01, <0,0,1>, .03
    scale <1, 1, .1>
    rotate -130*x
    translate  <-.02, .43, -.69>
  }
  translate  -.41*x
}

#declare Patas = union {
  object { Patas1 }
  object { Patas2 }
  object { Patas3 }
  texture { tAbeja2 }
}

#declare CsgMand = difference {
  torus { 0.15, 0.03  rotate -x*100
    rotate -80*y
    translate  <-.68, 0, -.26>
  }
  box { -1, 1
    scale <.07, .06, .07>
    translate  <-.72, .0, -.38>
  }
  texture { tPatas }
  translate  <-.02, 0, .01>
}

#declare Abdomen = union {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.198133, 0.000000, 0.118092>, <0.198133, -0.337517, 0.118092>, <0.176741, -0.337517, -0.163933>, <0.176741, 0.000000, -0.163933>,
      <0.368511, 0.000000, 0.436991>, <0.368511, -0.725279, 0.436991>, <0.292277, -0.725279, -0.476986>, <0.292277, 0.000000, -0.476986>,
      <1.429140, 0.000000, 0.337259>, <1.429140, -0.725279, 0.337259>, <1.146014, -0.725279, -0.535097>, <1.146014, 0.000000, -0.535097>,
      <1.455623, 0.000000, -0.495872>, <1.455623, -0.000089, -0.495872>, <1.458518, -0.000089, -0.496902>, <1.458518, 0.000000, -0.496902>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.176741, 0.000000, -0.163933>, <0.176741, 0.337517, -0.163933>, <0.198133, 0.337517, 0.118092>, <0.198133, 0.000000, 0.118092>,
      <0.292277, 0.000000, -0.476986>, <0.292277, 0.725279, -0.476986>, <0.368511, 0.725279, 0.436991>, <0.368511, 0.000000, 0.436991>,
      <1.146014, 0.000000, -0.535097>, <1.146014, 0.725279, -0.535097>, <1.429140, 0.725279, 0.337259>, <1.429140, 0.000000, 0.337259>,
      <1.458518, 0.000000, -0.496902>, <1.458518, 0.000089, -0.496902>, <1.455623, 0.000089, -0.495872>, <1.455623, 0.000000, -0.495872>
    }
  texture { tAbeja3 rotate 20*y translate <-.14, 0, .24> }
}

#declare Abeja = union { 
  object { Patas scale .9 translate -.02*z }

  box { -1, 1
    texture { tAlas scale <2, 2, 1> translate <-1, -1, 0> }
    scale <.65, .85, .00001>
    rotate 30*x
    translate  <-.26, 1.04, .6>
  }
  
  box { -1, 1
    texture { tAlas scale <2.0, 2.0, 1.0> translate <-1, -1, 0> }
    scale <.65, .85, .00001>
    rotate 150*x
    translate  <-.27, -1.04, .6>
  }

  object { Antena }

  object { Antena rotate 80*x }

  sphere { 0, 1 texture { tOjos }
    scale <.13, .13, .2>
    rotate 15*y
    translate  <-.62, -.3, 0>
  }

  sphere { 0, 1 texture { tOjos }
    scale <.13, .13, .2>
    rotate 15*y
    translate  <-.62, .3, 0> }

  object { Cuerpo }

  object { Cuerpo scale <.75, .52, .9> rotate <-15, 0, -90>
    translate  <-.6, -.05, 0> }

  object { CsgMand translate <.02,0,.02> }

  object { Abdomen scale .9}
  rotate -102*x
  rotate -10*z
}
